// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/plasma-shell.xml

#ifndef QT_WAYLAND_SERVER_PLASMA_SHELL
#define QT_WAYLAND_SERVER_PLASMA_SHELL

#include "wayland-server-core.h"
#include "wayland-plasma-shell-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  org_kde_plasma_shell
    {
    public:
        org_kde_plasma_shell(struct ::wl_client *client, int id, int version);
        org_kde_plasma_shell(struct ::wl_display *display, int version);
        org_kde_plasma_shell(struct ::wl_resource *resource);
        org_kde_plasma_shell();

        virtual ~org_kde_plasma_shell();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_shell_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_shell *org_kde_plasma_shell_object;
            org_kde_plasma_shell *object() { return org_kde_plasma_shell_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


    protected:
        virtual Resource *org_kde_plasma_shell_allocate();

        virtual void org_kde_plasma_shell_destroy_global();

        virtual void org_kde_plasma_shell_bind_resource(Resource *resource);
        virtual void org_kde_plasma_shell_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_shell_get_surface(Resource *resource, uint32_t id, struct ::wl_resource *surface);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_shell_interface m_org_kde_plasma_shell_interface;

        static void handle_get_surface(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_shell *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  org_kde_plasma_surface
    {
    public:
        org_kde_plasma_surface(struct ::wl_client *client, int id, int version);
        org_kde_plasma_surface(struct ::wl_display *display, int version);
        org_kde_plasma_surface(struct ::wl_resource *resource);
        org_kde_plasma_surface();

        virtual ~org_kde_plasma_surface();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_surface_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_surface *org_kde_plasma_surface_object;
            org_kde_plasma_surface *object() { return org_kde_plasma_surface_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum role {
            role_normal = 0,
            role_desktop = 1,
            role_panel = 2,
            role_onscreendisplay = 3,
            role_notification = 4,
            role_tooltip = 5,
            role_criticalnotification = 6,
            role_StandAlone = 7,
            role_override = 8,
            role_activeFullScreen = 9,
        };

        enum panel_behavior {
            panel_behavior_always_visible = 1,
            panel_behavior_auto_hide = 2,
            panel_behavior_windows_can_cover = 3,
            panel_behavior_windows_go_below = 4,
        };

        enum error {
            error_panel_not_auto_hide = 0, // Request panel_auto_hide performed on a surface which does not correspond to an auto-hide panel.
        };

        void send_auto_hidden_panel_hidden();
        void send_auto_hidden_panel_hidden(struct ::wl_resource *resource);
        void send_auto_hidden_panel_shown();
        void send_auto_hidden_panel_shown(struct ::wl_resource *resource);

    protected:
        virtual Resource *org_kde_plasma_surface_allocate();

        virtual void org_kde_plasma_surface_destroy_global();

        virtual void org_kde_plasma_surface_bind_resource(Resource *resource);
        virtual void org_kde_plasma_surface_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_surface_destroy(Resource *resource);
        virtual void org_kde_plasma_surface_set_output(Resource *resource, struct ::wl_resource *output);
        virtual void org_kde_plasma_surface_set_position(Resource *resource, int32_t x, int32_t y);
        virtual void org_kde_plasma_surface_set_role(Resource *resource, uint32_t role);
        virtual void org_kde_plasma_surface_set_panel_behavior(Resource *resource, uint32_t flag);
        virtual void org_kde_plasma_surface_set_skip_taskbar(Resource *resource, uint32_t skip);
        virtual void org_kde_plasma_surface_panel_auto_hide_hide(Resource *resource);
        virtual void org_kde_plasma_surface_panel_auto_hide_show(Resource *resource);
        virtual void org_kde_plasma_surface_set_panel_takes_focus(Resource *resource, uint32_t takes_focus);
        virtual void org_kde_plasma_surface_set_skip_switcher(Resource *resource, uint32_t skip);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_surface_interface m_org_kde_plasma_surface_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_output(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *output);
        static void handle_set_position(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t x,
            int32_t y);
        static void handle_set_role(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t role);
        static void handle_set_panel_behavior(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t flag);
        static void handle_set_skip_taskbar(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t skip);
        static void handle_panel_auto_hide_hide(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_panel_auto_hide_show(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_panel_takes_focus(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t takes_focus);
        static void handle_set_skip_switcher(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t skip);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_surface *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
