/* gpgme_helper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gpgme_helper.vala, do not modify */

#include <glib.h>
#include "openpgp.h"
#include <stdlib.h>
#include <string.h>
#include <gpgme.h>
#include <gpgme_fix.h>
#include "gpg-error.h"
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _gpgme_data_release0(var) ((var == NULL) ? NULL : (var = (gpgme_data_release (var), NULL)))
#define _gpgme_release0(var) ((var == NULL) ? NULL : (var = (gpgme_release (var), NULL)))
typedef struct _GPGHelperParamSpecDecryptedData GPGHelperParamSpecDecryptedData;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gpgme_key_unref_vapi0(var) ((var == NULL) ? NULL : (var = (gpgme_key_unref_vapi (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _GPGHelperDecryptedDataPrivate {
	guint8* _data;
	gint _data_length1;
	gint __data_size_;
	gchar* _filename;
};

struct _GPGHelperParamSpecDecryptedData {
	GParamSpec parent_instance;
};

VALA_EXTERN gboolean gpg_helper_initialized;
gboolean gpg_helper_initialized = FALSE;
static gint GPGHelperDecryptedData_private_offset;
static gpointer gpg_helper_decrypted_data_parent_class = NULL;

VALA_EXTERN void gpg_helper_initialize (void);
VALA_EXTERN gchar* gpg_helper_get_string_from_data (struct gpgme_data* data);
VALA_EXTERN guint8* gpg_helper_get_uint8_from_data (struct gpgme_data* data,
                                        gint* result_length1);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void gpg_helper_decrypted_data_finalize (GPGHelperDecryptedData * obj);
static GType gpg_helper_decrypted_data_get_type_once (void);
VALA_EXTERN struct _gpgme_key* gpg_helper_get_key (const gchar* sig,
                                       gboolean priv,
                                       GError** error);
static guint8* _vala_array_dup4 (guint8* self,
                          gssize length);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
gpgme_throw_if_error (gpg_err_code_t _error_,
                      GError** error)
{
	gpg_err_code_t _tmp0_;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = gpg_err_code (_error_);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != GPG_ERR_NO_ERROR) {
		gpg_err_code_t _tmp2_;
		gpg_err_code_t _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = gpg_err_code (_error_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("%u", (guint) _error_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new ((GQuark) -1, (gint) _tmp3_, "%s", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static struct gpgme_data*
gpgme_data_create_from_memory (guint8* buffer,
                               gint buffer_length1,
                               gboolean copy,
                               GError** error)
{
	struct gpgme_data* data = NULL;
	struct gpgme_data* _tmp0_ = NULL;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	_tmp1_ = gpgme_data_new_from_mem (&_tmp0_, (gchar*) buffer, (gint) ((buffer_length1 * sizeof (guint8)) / sizeof (gchar)), copy);
	_gpgme_data_release0 (data);
	data = _tmp0_;
	gpgme_throw_if_error (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (data);
		return NULL;
	}
	result = data;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static struct gpgme_context*
gpgme_create (GError** error)
{
	struct gpgme_context* ctx = NULL;
	struct gpgme_context* _tmp0_ = NULL;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_context* result;
	_tmp1_ = gpgme_new (&_tmp0_);
	_gpgme_release0 (ctx);
	ctx = _tmp0_;
	gpgme_throw_if_error (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_release0 (ctx);
		return NULL;
	}
	result = ctx;
	return result;
}

static struct gpgme_data*
gpgme_data_create (GError** error)
{
	struct gpgme_data* data = NULL;
	struct gpgme_data* _tmp0_ = NULL;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	_tmp1_ = gpgme_data_new (&_tmp0_);
	_gpgme_data_release0 (data);
	data = _tmp0_;
	gpgme_throw_if_error (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (data);
		return NULL;
	}
	result = data;
	return result;
}

static struct gpgme_data*
gpgme_op_encrypt_ (struct gpgme_context* self,
                   struct _gpgme_key** recp,
                   gint recp_length1,
                   gpgme_encrypt_flags_t flags,
                   struct gpgme_data* plain,
                   GError** error)
{
	struct gpgme_data* cipher = NULL;
	struct gpgme_data* _tmp0_;
	struct gpgme_data* _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plain != NULL, NULL);
	_tmp0_ = gpgme_data_create (&_inner_error0_);
	cipher = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = cipher;
	gpgme_throw_if_error (gpgme_op_encrypt (self, recp, flags, plain, _tmp1_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (cipher);
		return NULL;
	}
	result = cipher;
	return result;
}

gchar*
gpg_helper_encrypt_armor (const gchar* plain,
                          struct _gpgme_key** keys,
                          gint keys_length1,
                          gpgme_encrypt_flags_t flags,
                          GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (plain != NULL, NULL);
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_data* plain_data = NULL;
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		struct gpgme_data* _tmp3_;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp4_;
		struct gpgme_context* _tmp5_;
		struct gpgme_data* enc_data = NULL;
		struct gpgme_context* _tmp6_;
		struct gpgme_data* _tmp7_;
		struct gpgme_data* _tmp8_;
		struct gpgme_data* _tmp9_;
		gchar* _tmp10_;
		gpg_helper_initialize ();
		_tmp0_ = string_get_data (plain, &_tmp1_);
		_tmp0__length1 = _tmp1_;
		_tmp2_ = _tmp0_;
		_tmp2__length1 = _tmp0__length1;
		_tmp3_ = gpgme_data_create_from_memory (_tmp2_, (gint) _tmp2__length1, FALSE, &_inner_error0_);
		plain_data = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp4_ = gpgme_create (&_inner_error0_);
		context = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_data_release0 (plain_data);
			goto __finally0;
		}
		_tmp5_ = context;
		gpgme_set_armor (_tmp5_, TRUE);
		_tmp6_ = context;
		_tmp7_ = plain_data;
		_tmp8_ = gpgme_op_encrypt_ (_tmp6_, keys, (gint) keys_length1, flags, _tmp7_, &_inner_error0_);
		enc_data = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_gpgme_data_release0 (plain_data);
			goto __finally0;
		}
		_tmp9_ = enc_data;
		_tmp10_ = gpg_helper_get_string_from_data (_tmp9_);
		result = _tmp10_;
		_gpgme_data_release0 (enc_data);
		_gpgme_release0 (context);
		_gpgme_data_release0 (plain_data);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static struct gpgme_data*
gpgme_data_create_from_file (const gchar* filename,
                             gint copy,
                             GError** error)
{
	struct gpgme_data* data = NULL;
	struct gpgme_data* _tmp0_ = NULL;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp1_ = gpgme_data_new_from_file (&_tmp0_, filename, copy);
	_gpgme_data_release0 (data);
	data = _tmp0_;
	gpgme_throw_if_error (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (data);
		return NULL;
	}
	result = data;
	return result;
}

guint8*
gpg_helper_encrypt_file (const gchar* uri,
                         struct _gpgme_key** keys,
                         gint keys_length1,
                         gpgme_encrypt_flags_t flags,
                         const gchar* file_name,
                         gint* result_length1,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (file_name != NULL, NULL);
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_data* plain_data = NULL;
		struct gpgme_data* _tmp0_;
		struct gpgme_data* _tmp1_;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp2_;
		struct gpgme_context* _tmp3_;
		struct gpgme_data* enc_data = NULL;
		struct gpgme_context* _tmp4_;
		struct gpgme_data* _tmp5_;
		struct gpgme_data* _tmp6_;
		struct gpgme_data* _tmp7_;
		gint _tmp8_ = 0;
		guint8* _tmp9_;
		guint8* _tmp10_;
		gint _tmp10__length1;
		gpg_helper_initialize ();
		_tmp0_ = gpgme_data_create_from_file (uri, 1, &_inner_error0_);
		plain_data = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp1_ = plain_data;
		gpgme_data_set_file_name (_tmp1_, file_name);
		_tmp2_ = gpgme_create (&_inner_error0_);
		context = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_data_release0 (plain_data);
			goto __finally0;
		}
		_tmp3_ = context;
		gpgme_set_armor (_tmp3_, TRUE);
		_tmp4_ = context;
		_tmp5_ = plain_data;
		_tmp6_ = gpgme_op_encrypt_ (_tmp4_, keys, (gint) keys_length1, flags, _tmp5_, &_inner_error0_);
		enc_data = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_gpgme_data_release0 (plain_data);
			goto __finally0;
		}
		_tmp7_ = enc_data;
		_tmp9_ = gpg_helper_get_uint8_from_data (_tmp7_, &_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _tmp8_;
		if (result_length1) {
			*result_length1 = _tmp10__length1;
		}
		result = _tmp10_;
		_gpgme_data_release0 (enc_data);
		_gpgme_release0 (context);
		_gpgme_data_release0 (plain_data);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static struct gpgme_data*
gpgme_op_decrypt_ (struct gpgme_context* self,
                   struct gpgme_data* cipher,
                   GError** error)
{
	struct gpgme_data* plain = NULL;
	struct gpgme_data* _tmp0_;
	struct gpgme_data* _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cipher != NULL, NULL);
	_tmp0_ = gpgme_data_create (&_inner_error0_);
	plain = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = plain;
	gpgme_throw_if_error (gpgme_op_decrypt (self, cipher, _tmp1_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (plain);
		return NULL;
	}
	result = plain;
	return result;
}

gchar*
gpg_helper_decrypt (const gchar* encr,
                    GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (encr != NULL, NULL);
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_data* enc_data = NULL;
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		struct gpgme_data* _tmp3_;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp4_;
		struct gpgme_data* dec_data = NULL;
		struct gpgme_context* _tmp5_;
		struct gpgme_data* _tmp6_;
		struct gpgme_data* _tmp7_;
		struct gpgme_data* _tmp8_;
		gchar* _tmp9_;
		gpg_helper_initialize ();
		_tmp0_ = string_get_data (encr, &_tmp1_);
		_tmp0__length1 = _tmp1_;
		_tmp2_ = _tmp0_;
		_tmp2__length1 = _tmp0__length1;
		_tmp3_ = gpgme_data_create_from_memory (_tmp2_, (gint) _tmp2__length1, FALSE, &_inner_error0_);
		enc_data = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp4_ = gpgme_create (&_inner_error0_);
		context = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_data_release0 (enc_data);
			goto __finally0;
		}
		_tmp5_ = context;
		_tmp6_ = enc_data;
		_tmp7_ = gpgme_op_decrypt_ (_tmp5_, _tmp6_, &_inner_error0_);
		dec_data = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_gpgme_data_release0 (enc_data);
			goto __finally0;
		}
		_tmp8_ = dec_data;
		_tmp9_ = gpg_helper_get_string_from_data (_tmp8_);
		result = _tmp9_;
		_gpgme_data_release0 (dec_data);
		_gpgme_release0 (context);
		_gpgme_data_release0 (enc_data);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static inline gpointer
gpg_helper_decrypted_data_get_instance_private (GPGHelperDecryptedData* self)
{
	return G_STRUCT_MEMBER_P (self, GPGHelperDecryptedData_private_offset);
}

GPGHelperDecryptedData*
gpg_helper_decrypted_data_construct (GType object_type)
{
	GPGHelperDecryptedData* self = NULL;
	self = (GPGHelperDecryptedData*) g_type_create_instance (object_type);
	return self;
}

GPGHelperDecryptedData*
gpg_helper_decrypted_data_new (void)
{
	return gpg_helper_decrypted_data_construct (GPG_HELPER_TYPE_DECRYPTED_DATA);
}

guint8*
gpg_helper_decrypted_data_get_data (GPGHelperDecryptedData* self,
                                    gint* result_length1)
{
	guint8* result;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data;
	_tmp0__length1 = self->priv->_data_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
gpg_helper_decrypted_data_set_data (GPGHelperDecryptedData* self,
                                    guint8* value,
                                    gint value_length1)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_data = (g_free (self->priv->_data), NULL);
	self->priv->_data = _tmp0_;
	self->priv->_data_length1 = _tmp0__length1;
	self->priv->__data_size_ = self->priv->_data_length1;
}

const gchar*
gpg_helper_decrypted_data_get_filename (GPGHelperDecryptedData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

void
gpg_helper_decrypted_data_set_filename (GPGHelperDecryptedData* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}

static void
gpg_helper_value_decrypted_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gpg_helper_value_decrypted_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gpg_helper_decrypted_data_unref (value->data[0].v_pointer);
	}
}

static void
gpg_helper_value_decrypted_data_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gpg_helper_decrypted_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gpg_helper_value_decrypted_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gpg_helper_value_decrypted_data_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GPGHelperDecryptedData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gpg_helper_decrypted_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gpg_helper_value_decrypted_data_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	GPGHelperDecryptedData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gpg_helper_decrypted_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gpg_helper_param_spec_decrypted_data (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	GPGHelperParamSpecDecryptedData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GPG_HELPER_TYPE_DECRYPTED_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gpg_helper_value_get_decrypted_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPG_HELPER_TYPE_DECRYPTED_DATA), NULL);
	return value->data[0].v_pointer;
}

void
gpg_helper_value_set_decrypted_data (GValue* value,
                                     gpointer v_object)
{
	GPGHelperDecryptedData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPG_HELPER_TYPE_DECRYPTED_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GPG_HELPER_TYPE_DECRYPTED_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gpg_helper_decrypted_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gpg_helper_decrypted_data_unref (old);
	}
}

void
gpg_helper_value_take_decrypted_data (GValue* value,
                                      gpointer v_object)
{
	GPGHelperDecryptedData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GPG_HELPER_TYPE_DECRYPTED_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GPG_HELPER_TYPE_DECRYPTED_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gpg_helper_decrypted_data_unref (old);
	}
}

static void
gpg_helper_decrypted_data_class_init (GPGHelperDecryptedDataClass * klass,
                                      gpointer klass_data)
{
	gpg_helper_decrypted_data_parent_class = g_type_class_peek_parent (klass);
	((GPGHelperDecryptedDataClass *) klass)->finalize = gpg_helper_decrypted_data_finalize;
	g_type_class_adjust_private_offset (klass, &GPGHelperDecryptedData_private_offset);
}

static void
gpg_helper_decrypted_data_instance_init (GPGHelperDecryptedData * self,
                                         gpointer klass)
{
	self->priv = gpg_helper_decrypted_data_get_instance_private (self);
	self->ref_count = 1;
}

static void
gpg_helper_decrypted_data_finalize (GPGHelperDecryptedData * obj)
{
	GPGHelperDecryptedData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPG_HELPER_TYPE_DECRYPTED_DATA, GPGHelperDecryptedData);
	g_signal_handlers_destroy (self);
	self->priv->_data = (g_free (self->priv->_data), NULL);
	_g_free0 (self->priv->_filename);
}

static GType
gpg_helper_decrypted_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gpg_helper_value_decrypted_data_init, gpg_helper_value_decrypted_data_free_value, gpg_helper_value_decrypted_data_copy_value, gpg_helper_value_decrypted_data_peek_pointer, "p", gpg_helper_value_decrypted_data_collect_value, "p", gpg_helper_value_decrypted_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GPGHelperDecryptedDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpg_helper_decrypted_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPGHelperDecryptedData), 0, (GInstanceInitFunc) gpg_helper_decrypted_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gpg_helper_decrypted_data_type_id;
	gpg_helper_decrypted_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GPGHelperDecryptedData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GPGHelperDecryptedData_private_offset = g_type_add_instance_private (gpg_helper_decrypted_data_type_id, sizeof (GPGHelperDecryptedDataPrivate));
	return gpg_helper_decrypted_data_type_id;
}

GType
gpg_helper_decrypted_data_get_type (void)
{
	static volatile gsize gpg_helper_decrypted_data_type_id__once = 0;
	if (g_once_init_enter (&gpg_helper_decrypted_data_type_id__once)) {
		GType gpg_helper_decrypted_data_type_id;
		gpg_helper_decrypted_data_type_id = gpg_helper_decrypted_data_get_type_once ();
		g_once_init_leave (&gpg_helper_decrypted_data_type_id__once, gpg_helper_decrypted_data_type_id);
	}
	return gpg_helper_decrypted_data_type_id__once;
}

gpointer
gpg_helper_decrypted_data_ref (gpointer instance)
{
	GPGHelperDecryptedData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gpg_helper_decrypted_data_unref (gpointer instance)
{
	GPGHelperDecryptedData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GPG_HELPER_DECRYPTED_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GPGHelperDecryptedData*
gpg_helper_decrypt_data (guint8* data,
                         gint data_length1,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	GPGHelperDecryptedData* result;
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_data* enc_data = NULL;
		struct gpgme_data* _tmp0_;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp1_;
		struct gpgme_data* dec_data = NULL;
		struct gpgme_context* _tmp2_;
		struct gpgme_data* _tmp3_;
		struct gpgme_data* _tmp4_;
		struct _gpgme_op_decrypt_result* dec_res = NULL;
		struct gpgme_context* _tmp5_;
		struct _gpgme_op_decrypt_result* _tmp6_;
		struct gpgme_data* _tmp7_;
		gint _tmp8_ = 0;
		guint8* _tmp9_;
		struct _gpgme_op_decrypt_result* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GPGHelperDecryptedData* _tmp13_ = NULL;
		gpg_helper_initialize ();
		_tmp0_ = gpgme_data_create_from_memory (data, (gint) data_length1, FALSE, &_inner_error0_);
		enc_data = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp1_ = gpgme_create (&_inner_error0_);
		context = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_data_release0 (enc_data);
			goto __finally0;
		}
		_tmp2_ = context;
		_tmp3_ = enc_data;
		_tmp4_ = gpgme_op_decrypt_ (_tmp2_, _tmp3_, &_inner_error0_);
		dec_data = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_gpgme_data_release0 (enc_data);
			goto __finally0;
		}
		_tmp5_ = context;
		_tmp6_ = gpgme_op_decrypt_result (_tmp5_);
		dec_res = _tmp6_;
		_tmp7_ = dec_data;
		_tmp9_ = gpg_helper_get_uint8_from_data (_tmp7_, &_tmp8_);
		_tmp10_ = dec_res;
		_tmp11_ = (*_tmp10_).file_name;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = gpg_helper_decrypted_data_new ();
		gpg_helper_decrypted_data_set_data (_tmp13_, _tmp9_, _tmp8_);
		_tmp9_ = (g_free (_tmp9_), NULL);
		gpg_helper_decrypted_data_set_filename (_tmp13_, _tmp12_);
		_g_free0 (_tmp12_);
		result = _tmp13_;
		_gpgme_data_release0 (dec_data);
		_gpgme_release0 (context);
		_gpgme_data_release0 (enc_data);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static struct gpgme_data*
gpgme_op_sign_ (struct gpgme_context* self,
                struct gpgme_data* plain,
                gpgme_sig_mode_t mode,
                GError** error)
{
	struct gpgme_data* sig = NULL;
	struct gpgme_data* _tmp0_;
	struct gpgme_data* _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plain != NULL, NULL);
	_tmp0_ = gpgme_data_create (&_inner_error0_);
	sig = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = sig;
	gpgme_throw_if_error (gpgme_op_sign (self, plain, _tmp1_, mode), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (sig);
		return NULL;
	}
	result = sig;
	return result;
}

gchar*
gpg_helper_sign (const gchar* plain,
                 gpgme_sig_mode_t mode,
                 struct _gpgme_key* key,
                 GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (plain != NULL, NULL);
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_data* plain_data = NULL;
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		struct gpgme_data* _tmp3_;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp4_;
		struct gpgme_data* signed_data = NULL;
		struct gpgme_context* _tmp6_;
		struct gpgme_data* _tmp7_;
		struct gpgme_data* _tmp8_;
		struct gpgme_data* _tmp9_;
		gchar* _tmp10_;
		gpg_helper_initialize ();
		_tmp0_ = string_get_data (plain, &_tmp1_);
		_tmp0__length1 = _tmp1_;
		_tmp2_ = _tmp0_;
		_tmp2__length1 = _tmp0__length1;
		_tmp3_ = gpgme_data_create_from_memory (_tmp2_, (gint) _tmp2__length1, FALSE, &_inner_error0_);
		plain_data = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp4_ = gpgme_create (&_inner_error0_);
		context = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_data_release0 (plain_data);
			goto __finally0;
		}
		if (key != NULL) {
			struct gpgme_context* _tmp5_;
			_tmp5_ = context;
			gpgme_signers_add (_tmp5_, key);
		}
		_tmp6_ = context;
		_tmp7_ = plain_data;
		_tmp8_ = gpgme_op_sign_ (_tmp6_, _tmp7_, mode, &_inner_error0_);
		signed_data = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_gpgme_data_release0 (plain_data);
			goto __finally0;
		}
		_tmp9_ = signed_data;
		_tmp10_ = gpg_helper_get_string_from_data (_tmp9_);
		result = _tmp10_;
		_gpgme_data_release0 (signed_data);
		_gpgme_release0 (context);
		_gpgme_data_release0 (plain_data);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static struct gpgme_data*
gpgme_op_verify_ (struct gpgme_context* self,
                  struct gpgme_data* sig,
                  struct gpgme_data* signed_text,
                  GError** error)
{
	struct gpgme_data* plaintext = NULL;
	struct gpgme_data* _tmp0_;
	struct gpgme_data* _tmp1_;
	GError* _inner_error0_ = NULL;
	struct gpgme_data* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signed_text != NULL, NULL);
	_tmp0_ = gpgme_data_create (&_inner_error0_);
	plaintext = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = plaintext;
	gpgme_throw_if_error (gpgme_op_verify (self, sig, signed_text, _tmp1_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_data_release0 (plaintext);
		return NULL;
	}
	result = plaintext;
	return result;
}

gchar*
gpg_helper_get_sign_key (const gchar* signature,
                         const gchar* text,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (signature != NULL, NULL);
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_data* sig_data = NULL;
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		struct gpgme_data* _tmp3_;
		struct gpgme_data* text_data = NULL;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp13_;
		struct gpgme_context* _tmp14_;
		struct gpgme_data* _tmp15_;
		struct gpgme_data* _tmp16_;
		struct gpgme_data* _tmp17_;
		struct gpgme_data* _tmp18_;
		struct _gpgme_op_verify_result* verify_res = NULL;
		struct gpgme_context* _tmp19_;
		struct _gpgme_op_verify_result* _tmp20_;
		gboolean _tmp21_ = FALSE;
		struct _gpgme_op_verify_result* _tmp22_;
		struct _gpgme_op_verify_result* _tmp25_;
		struct _gpgme_signature* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gpg_helper_initialize ();
		_tmp0_ = string_get_data (signature, &_tmp1_);
		_tmp0__length1 = _tmp1_;
		_tmp2_ = _tmp0_;
		_tmp2__length1 = _tmp0__length1;
		_tmp3_ = gpgme_data_create_from_memory (_tmp2_, (gint) _tmp2__length1, FALSE, &_inner_error0_);
		sig_data = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		if (text != NULL) {
			struct gpgme_data* _tmp4_ = NULL;
			guint8* _tmp5_;
			gint _tmp5__length1;
			gint _tmp6_ = 0;
			guint8* _tmp7_;
			gint _tmp7__length1;
			struct gpgme_data* _tmp8_;
			struct gpgme_data* _tmp9_;
			_tmp5_ = string_get_data (text, &_tmp6_);
			_tmp5__length1 = _tmp6_;
			_tmp7_ = _tmp5_;
			_tmp7__length1 = _tmp5__length1;
			_tmp8_ = gpgme_data_create_from_memory (_tmp7_, (gint) _tmp7__length1, FALSE, &_inner_error0_);
			_tmp4_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_gpgme_data_release0 (text_data);
				_gpgme_data_release0 (sig_data);
				goto __finally0;
			}
			_tmp9_ = _tmp4_;
			_tmp4_ = NULL;
			_gpgme_data_release0 (text_data);
			text_data = _tmp9_;
			_gpgme_data_release0 (_tmp4_);
		} else {
			struct gpgme_data* _tmp10_ = NULL;
			struct gpgme_data* _tmp11_;
			struct gpgme_data* _tmp12_;
			_tmp11_ = gpgme_data_create (&_inner_error0_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_gpgme_data_release0 (text_data);
				_gpgme_data_release0 (sig_data);
				goto __finally0;
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			_gpgme_data_release0 (text_data);
			text_data = _tmp12_;
			_gpgme_data_release0 (_tmp10_);
		}
		_tmp13_ = gpgme_create (&_inner_error0_);
		context = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_data_release0 (text_data);
			_gpgme_data_release0 (sig_data);
			goto __finally0;
		}
		_tmp14_ = context;
		_tmp15_ = sig_data;
		_tmp16_ = text_data;
		_tmp17_ = gpgme_op_verify_ (_tmp14_, _tmp15_, _tmp16_, &_inner_error0_);
		_tmp18_ = _tmp17_;
		_gpgme_data_release0 (_tmp18_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_gpgme_data_release0 (text_data);
			_gpgme_data_release0 (sig_data);
			goto __finally0;
		}
		_tmp19_ = context;
		_tmp20_ = gpgme_op_verify_result (_tmp19_);
		verify_res = _tmp20_;
		_tmp22_ = verify_res;
		if (_tmp22_ == NULL) {
			_tmp21_ = TRUE;
		} else {
			struct _gpgme_op_verify_result* _tmp23_;
			struct _gpgme_signature* _tmp24_;
			_tmp23_ = verify_res;
			_tmp24_ = (*_tmp23_).signatures;
			_tmp21_ = _tmp24_ == NULL;
		}
		if (_tmp21_) {
			result = NULL;
			_gpgme_release0 (context);
			_gpgme_data_release0 (text_data);
			_gpgme_data_release0 (sig_data);
			{
				GError* _inner_error0_ = NULL;
				g_rec_mutex_unlock (&gpgme_global_mutex);
			}
			return result;
		}
		_tmp25_ = verify_res;
		_tmp26_ = (*_tmp25_).signatures;
		_tmp27_ = (*_tmp26_).fpr;
		_tmp28_ = g_strdup (_tmp27_);
		result = _tmp28_;
		_gpgme_release0 (context);
		_gpgme_data_release0 (text_data);
		_gpgme_data_release0 (sig_data);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static void
gpgme_op_keylist_start_ (struct gpgme_context* self,
                         const gchar* pattern,
                         gint secret_only,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	gpgme_throw_if_error (gpgme_op_keylist_start (self, pattern, secret_only), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static struct _gpgme_key*
gpgme_op_keylist_next_ (struct gpgme_context* self,
                        GError** error)
{
	struct _gpgme_key* key = NULL;
	struct _gpgme_key* _tmp0_ = NULL;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	struct _gpgme_key* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gpgme_op_keylist_next (self, &_tmp0_);
	_gpgme_key_unref_vapi0 (key);
	key = _tmp0_;
	gpgme_throw_if_error (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_key_unref_vapi0 (key);
		return NULL;
	}
	result = key;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
gpgme_op_keylist_end_ (struct gpgme_context* self,
                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	gpgme_throw_if_error (gpgme_op_keylist_end (self), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

GeeList*
gpg_helper_get_keylist (const gchar* pattern,
                        gboolean secret_only,
                        GError** error)
{
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		GeeList* keys = NULL;
		GeeArrayList* _tmp0_;
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp1_;
		gint _tmp2_ = 0;
		struct gpgme_context* _tmp3_;
		struct gpgme_context* _tmp11_;
		gpg_helper_initialize ();
		_tmp0_ = gee_array_list_new (G_TYPE_POINTER, (GBoxedCopyFunc) gpgme_key_ref_vapi, (GDestroyNotify) gpgme_key_unref_vapi, NULL, NULL, NULL);
		keys = (GeeList*) _tmp0_;
		_tmp1_ = gpgme_create (&_inner_error0_);
		context = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (keys);
			goto __finally0;
		}
		if (secret_only) {
			_tmp2_ = 1;
		} else {
			_tmp2_ = 0;
		}
		_tmp3_ = context;
		gpgme_op_keylist_start_ (_tmp3_, pattern, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_g_object_unref0 (keys);
			goto __finally0;
		}
		{
			while (TRUE) {
				struct _gpgme_key* key = NULL;
				struct gpgme_context* _tmp4_;
				struct _gpgme_key* _tmp5_;
				GeeList* _tmp6_;
				struct _gpgme_key* _tmp7_;
				_tmp4_ = context;
				_tmp5_ = gpgme_op_keylist_next_ (_tmp4_, &_inner_error0_);
				key = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp6_ = keys;
				_tmp7_ = key;
				gee_collection_add ((GeeCollection*) _tmp6_, _tmp7_);
				_gpgme_key_unref_vapi0 (key);
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			if (_tmp8_->code != ((gint) GPG_ERR_EOF)) {
				GError* _tmp9_;
				GError* _tmp10_;
				_tmp9_ = e;
				_tmp10_ = _g_error_copy0 (_tmp9_);
				_inner_error0_ = _tmp10_;
				_g_error_free0 (e);
				goto __finally1;
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_g_object_unref0 (keys);
			goto __finally0;
		}
		_tmp11_ = context;
		gpgme_op_keylist_end_ (_tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			_g_object_unref0 (keys);
			goto __finally0;
		}
		result = keys;
		_gpgme_release0 (context);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

struct _gpgme_key*
gpg_helper_get_public_key (const gchar* sig,
                           GError** error)
{
	struct _gpgme_key* _tmp0_ = NULL;
	struct _gpgme_key* _tmp1_;
	struct _gpgme_key* _tmp2_;
	GError* _inner_error0_ = NULL;
	struct _gpgme_key* result;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = gpg_helper_get_key (sig, FALSE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_gpgme_key_unref_vapi0 (_tmp0_);
	return result;
}

struct _gpgme_key*
gpg_helper_get_private_key (const gchar* sig,
                            GError** error)
{
	struct _gpgme_key* _tmp0_ = NULL;
	struct _gpgme_key* _tmp1_;
	struct _gpgme_key* _tmp2_;
	GError* _inner_error0_ = NULL;
	struct _gpgme_key* result;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = gpg_helper_get_key (sig, TRUE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_gpgme_key_unref_vapi0 (_tmp0_);
	return result;
}

static struct _gpgme_key*
gpgme_get_key_ (struct gpgme_context* self,
                const gchar* fpr,
                gboolean secret,
                GError** error)
{
	struct _gpgme_key* key = NULL;
	struct _gpgme_key* _tmp0_ = NULL;
	gpg_err_code_t _tmp1_;
	GError* _inner_error0_ = NULL;
	struct _gpgme_key* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fpr != NULL, NULL);
	_tmp1_ = gpgme_get_key (self, fpr, &_tmp0_, secret);
	_gpgme_key_unref_vapi0 (key);
	key = _tmp0_;
	gpgme_throw_if_error (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gpgme_key_unref_vapi0 (key);
		return NULL;
	}
	result = key;
	return result;
}

struct _gpgme_key*
gpg_helper_get_key (const gchar* sig,
                    gboolean priv,
                    GError** error)
{
	GError* _inner_error0_ = NULL;
	struct _gpgme_key* result;
	g_return_val_if_fail (sig != NULL, NULL);
	g_rec_mutex_lock (&gpgme_global_mutex);
	{
		struct gpgme_context* context = NULL;
		struct gpgme_context* _tmp0_;
		struct _gpgme_key* key = NULL;
		struct gpgme_context* _tmp1_;
		struct _gpgme_key* _tmp2_;
		gpg_helper_initialize ();
		_tmp0_ = gpgme_create (&_inner_error0_);
		context = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp1_ = context;
		_tmp2_ = gpgme_get_key_ (_tmp1_, sig, priv, &_inner_error0_);
		key = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gpgme_release0 (context);
			goto __finally0;
		}
		result = key;
		_gpgme_release0 (context);
		{
			GError* _inner_error0_ = NULL;
			g_rec_mutex_unlock (&gpgme_global_mutex);
		}
		return result;
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_rec_mutex_unlock (&gpgme_global_mutex);
	}
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

gchar*
gpg_helper_get_string_from_data (struct gpgme_data* data)
{
	static const gsize BUF_SIZE = (gsize) 256;
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	gssize len = 0L;
	gchar* res = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (data != NULL, NULL);
	gpgme_data_seek (data, (glong) 0, 0);
	_tmp0_ = g_new0 (guint8, BUF_SIZE + 1);
	buf = _tmp0_;
	buf_length1 = BUF_SIZE + 1;
	_buf_size_ = buf_length1;
	len = (gssize) 0;
	_tmp1_ = g_strdup ("");
	res = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			guint8* _tmp3_;
			gint _tmp3__length1;
			if (!_tmp2_) {
				if (!(len > ((gssize) 0))) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp3_ = buf;
			_tmp3__length1 = buf_length1;
			len = gpgme_data_read (data, _tmp3_, BUF_SIZE);
			if (len > ((gssize) 0)) {
				guint8* _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				gchar* _tmp7_;
				_tmp4_ = buf;
				_tmp4__length1 = buf_length1;
				_tmp4_[len] = (guint8) 0;
				_tmp5_ = res;
				_tmp6_ = buf;
				_tmp6__length1 = buf_length1;
				_tmp7_ = g_strconcat (_tmp5_, (const gchar*) _tmp6_, NULL);
				_g_free0 (res);
				res = _tmp7_;
			}
		}
	}
	result = res;
	buf = (g_free (buf), NULL);
	return result;
}

static guint8*
_vala_array_dup4 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

guint8*
gpg_helper_get_uint8_from_data (struct gpgme_data* data,
                                gint* result_length1)
{
	static const gsize BUF_SIZE = (gsize) 256;
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	gssize len = 0L;
	GByteArray* res = NULL;
	GByteArray* _tmp1_;
	GByteArray* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* result;
	g_return_val_if_fail (data != NULL, NULL);
	gpgme_data_seek (data, (glong) 0, 0);
	_tmp0_ = g_new0 (guint8, BUF_SIZE + 1);
	buf = _tmp0_;
	buf_length1 = BUF_SIZE + 1;
	_buf_size_ = buf_length1;
	len = (gssize) 0;
	_tmp1_ = g_byte_array_new ();
	res = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			guint8* _tmp3_;
			gint _tmp3__length1;
			if (!_tmp2_) {
				if (!(len > ((gssize) 0))) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp3_ = buf;
			_tmp3__length1 = buf_length1;
			len = gpgme_data_read (data, _tmp3_, BUF_SIZE);
			if (len > ((gssize) 0)) {
				GByteArray* _tmp4_;
				guint8* _tmp5_;
				gint _tmp5__length1;
				_tmp4_ = res;
				_tmp5_ = buf;
				_tmp5__length1 = buf_length1;
				g_byte_array_append (_tmp4_, _tmp5_ + 0, (gint) (((gint) len) - 0));
			}
		}
	}
	_tmp6_ = res;
	_tmp7_ = _tmp6_->data;
	_tmp7__length1 = _tmp6_->len;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup4 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	_g_byte_array_unref0 (res);
	buf = (g_free (buf), NULL);
	return result;
}

void
gpg_helper_initialize (void)
{
	if (!gpg_helper_initialized) {
		gpgme_check_version (NULL);
		gpg_helper_initialized = TRUE;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

