/* BorgPlugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BorgPlugin.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#define BORG_PLUGIN_REQUIRED_MAJOR 1
#define BORG_PLUGIN_REQUIRED_MINOR 1
#define BORG_PLUGIN_REQUIRED_MICRO 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BORG_PLUGIN_0_PROPERTY,
	BORG_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* borg_plugin_properties[BORG_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_TOOL_JOB_CHAIN (deja_dup_tool_job_chain_get_type ())
#define DEJA_DUP_TOOL_JOB_CHAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_TOOL_JOB_CHAIN, DejaDupToolJobChain))
#define DEJA_DUP_TOOL_JOB_CHAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_TOOL_JOB_CHAIN, DejaDupToolJobChainClass))
#define DEJA_DUP_IS_TOOL_JOB_CHAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_TOOL_JOB_CHAIN))
#define DEJA_DUP_IS_TOOL_JOB_CHAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_TOOL_JOB_CHAIN))
#define DEJA_DUP_TOOL_JOB_CHAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_TOOL_JOB_CHAIN, DejaDupToolJobChainClass))

typedef struct _DejaDupToolJobChain DejaDupToolJobChain;
typedef struct _DejaDupToolJobChainClass DejaDupToolJobChainClass;

#define TYPE_BORG_JOB (borg_job_get_type ())
#define BORG_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BORG_JOB, BorgJob))
#define BORG_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BORG_JOB, BorgJobClass))
#define IS_BORG_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BORG_JOB))
#define IS_BORG_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BORG_JOB))
#define BORG_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BORG_JOB, BorgJobClass))

typedef struct _BorgJob BorgJob;
typedef struct _BorgJobClass BorgJobClass;

struct _BorgPluginPrivate {
	gboolean has_been_setup;
	gchar* version;
};

static gint BorgPlugin_private_offset;
static gpointer borg_plugin_parent_class = NULL;

static gchar** borg_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                           gint* result_length1);
static void borg_plugin_do_initial_setup (BorgPlugin* self,
                                   GError** error);
static gchar* borg_plugin_real_get_version (DejaDupToolPlugin* base,
                                     GError** error);
static DejaDupToolJob* borg_plugin_real_create_job (DejaDupToolPlugin* base,
                                             GError** error);
VALA_EXTERN BorgJob* borg_job_new (void);
VALA_EXTERN BorgJob* borg_job_construct (GType object_type);
VALA_EXTERN GType deja_dup_tool_job_chain_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType borg_job_get_type (void) G_GNUC_CONST ;
static gboolean borg_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                            DejaDupBackendKind kind,
                                            gchar** explanation);
static GObject * borg_plugin_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void borg_plugin_finalize (GObject * obj);
static GType borg_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
borg_plugin_get_instance_private (BorgPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, BorgPlugin_private_offset);
}

static gchar**
borg_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                   gint* result_length1)
{
	BorgPlugin * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (BorgPlugin*) base;
	_tmp1_ = _tmp0_ = g_strsplit (BORG_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
borg_plugin_do_initial_setup (BorgPlugin* self,
                              GError** error)
{
	gchar* output = NULL;
	gchar* stderr = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp11_ = FALSE;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	const gchar* _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp22_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->has_been_setup) {
		return;
	}
	g_spawn_command_line_sync ("borg --version", &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
	_g_free0 (output);
	output = _tmp0_;
	_g_free0 (stderr);
	stderr = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (stderr);
		_g_free0 (output);
		return;
	}
	_tmp2_ = output;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	tokens = _tmp4_;
	tokens_length1 = _vala_array_length (_tmp3_);
	_tokens_size_ = tokens_length1;
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = tokens;
		_tmp7__length1 = tokens_length1;
		_tmp5_ = _tmp7__length1 != 2;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		_tmp8_ = stderr;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = _tmp10_;
		tokens_length1 = _vala_array_length (_tmp9_);
		_tokens_size_ = tokens_length1;
	}
	_tmp12_ = tokens;
	_tmp12__length1 = tokens_length1;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		_tmp11_ = _tmp13__length1 != 2;
	}
	if (_tmp11_) {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, "Could not understand borg version.");
		_inner_error0_ = _tmp14_;
		g_propagate_error (error, _inner_error0_);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (output);
		return;
	}
	_tmp15_ = tokens;
	_tmp15__length1 = tokens_length1;
	_tmp16_ = _tmp15_[1];
	_tmp17_ = string_strip (_tmp16_);
	_g_free0 (self->priv->version);
	self->priv->version = _tmp17_;
	_tmp18_ = self->priv->version;
	_tmp22_ = deja_dup_parse_version (_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_);
	major = _tmp19_;
	minor = _tmp20_;
	micro = _tmp21_;
	if (!_tmp22_) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp23_ = self->priv->version;
		_tmp24_ = g_strdup_printf ("Could not understand borg version ‘%s’.", _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error0_ = _tmp27_;
		g_propagate_error (error, _inner_error0_);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (output);
		return;
	}
	if (!deja_dup_meets_version (major, minor, micro, BORG_PLUGIN_REQUIRED_MAJOR, BORG_PLUGIN_REQUIRED_MINOR, BORG_PLUGIN_REQUIRED_MICRO)) {
		gchar* msg = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GError* _tmp32_;
		GError* _tmp33_;
		_tmp28_ = g_strdup ("Déjà Dup Backup Tool requires at least version %d.%d.%.2d of borg, " "but only found version %d.%d.%.2d");
		msg = _tmp28_;
		_tmp29_ = msg;
		_tmp30_ = g_strdup_printf (_tmp29_, BORG_PLUGIN_REQUIRED_MAJOR, BORG_PLUGIN_REQUIRED_MINOR, BORG_PLUGIN_REQUIRED_MICRO, major, minor, micro);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp31_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_inner_error0_ = _tmp33_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (output);
		return;
	}
	self->priv->has_been_setup = TRUE;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (stderr);
	_g_free0 (output);
}

static gchar*
borg_plugin_real_get_version (DejaDupToolPlugin* base,
                              GError** error)
{
	BorgPlugin * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (BorgPlugin*) base;
	borg_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->version;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static DejaDupToolJob*
borg_plugin_real_create_job (DejaDupToolPlugin* base,
                             GError** error)
{
	BorgPlugin * self;
	BorgJob* _tmp0_;
	GError* _inner_error0_ = NULL;
	DejaDupToolJob* result;
	self = (BorgPlugin*) base;
	borg_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = borg_job_new ();
	result = (DejaDupToolJob*) _tmp0_;
	return result;
}

static gboolean
borg_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                   DejaDupBackendKind kind,
                                   gchar** explanation)
{
	BorgPlugin * self;
	gchar* _vala_explanation = NULL;
	gboolean result;
	self = (BorgPlugin*) base;
	_g_free0 (_vala_explanation);
	_vala_explanation = NULL;
	switch (kind) {
		case DEJA_DUP_BACKEND_KIND_LOCAL:
		{
			result = TRUE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
		default:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("This storage location is no yet supported. Please turn off the " "experimental borg support if you want to use this location.");
			_g_free0 (_vala_explanation);
			_vala_explanation = _tmp0_;
			result = FALSE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
	}
}

gchar*
borg_plugin_borg_command (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("borg");
		result = _tmp5_;
		_g_free0 (testing_str);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (BORG_COMMAND);
		result = _tmp6_;
		_g_free0 (testing_str);
		return result;
	}
}

BorgPlugin*
borg_plugin_construct (GType object_type)
{
	BorgPlugin * self = NULL;
	self = (BorgPlugin*) deja_dup_tool_plugin_construct (object_type);
	return self;
}

BorgPlugin*
borg_plugin_new (void)
{
	return borg_plugin_construct (TYPE_BORG_PLUGIN);
}

static GObject *
borg_plugin_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BorgPlugin * self;
	parent_class = G_OBJECT_CLASS (borg_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BORG_PLUGIN, BorgPlugin);
	deja_dup_tool_plugin_set_name ((DejaDupToolPlugin*) self, "borg");
	return obj;
}

static void
borg_plugin_class_init (BorgPluginClass * klass,
                        gpointer klass_data)
{
	borg_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BorgPlugin_private_offset);
	((DejaDupToolPluginClass *) klass)->get_dependencies = (gchar** (*) (DejaDupToolPlugin*, gint*)) borg_plugin_real_get_dependencies;
	((DejaDupToolPluginClass *) klass)->get_version = (gchar* (*) (DejaDupToolPlugin*, GError**)) borg_plugin_real_get_version;
	((DejaDupToolPluginClass *) klass)->create_job = (DejaDupToolJob* (*) (DejaDupToolPlugin*, GError**)) borg_plugin_real_create_job;
	((DejaDupToolPluginClass *) klass)->supports_backend = (gboolean (*) (DejaDupToolPlugin*, DejaDupBackendKind, gchar**)) borg_plugin_real_supports_backend;
	G_OBJECT_CLASS (klass)->constructor = borg_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = borg_plugin_finalize;
}

static void
borg_plugin_instance_init (BorgPlugin * self,
                           gpointer klass)
{
	self->priv = borg_plugin_get_instance_private (self);
	self->priv->has_been_setup = FALSE;
	self->priv->version = NULL;
}

static void
borg_plugin_finalize (GObject * obj)
{
	BorgPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BORG_PLUGIN, BorgPlugin);
	_g_free0 (self->priv->version);
	G_OBJECT_CLASS (borg_plugin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
borg_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BorgPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) borg_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BorgPlugin), 0, (GInstanceInitFunc) borg_plugin_instance_init, NULL };
	GType borg_plugin_type_id;
	borg_plugin_type_id = g_type_register_static (DEJA_DUP_TYPE_TOOL_PLUGIN, "BorgPlugin", &g_define_type_info, 0);
	BorgPlugin_private_offset = g_type_add_instance_private (borg_plugin_type_id, sizeof (BorgPluginPrivate));
	return borg_plugin_type_id;
}

GType
borg_plugin_get_type (void)
{
	static gsize borg_plugin_type_id__once = 0;
	if (g_once_init_enter (&borg_plugin_type_id__once)) {
		GType borg_plugin_type_id;
		borg_plugin_type_id = borg_plugin_get_type_once ();
		g_once_init_leave (&borg_plugin_type_id__once, borg_plugin_type_id);
	}
	return borg_plugin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

