/* pathwidget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from pathwidget.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define LARGE_WINDOW_SIZE 1042
#define MAX_ROW_WIDTH (LARGE_WINDOW_SIZE - 42)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_PATH_WIDGET (path_widget_get_type ())
#define PATH_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_WIDGET, PathWidget))
#define PATH_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_WIDGET, PathWidgetClass))
#define IS_PATH_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_WIDGET))
#define IS_PATH_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_WIDGET))
#define PATH_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_WIDGET, PathWidgetClass))

typedef struct _PathWidget PathWidget;
typedef struct _PathWidgetClass PathWidgetClass;
typedef struct _PathWidgetPrivate PathWidgetPrivate;

#define TYPE_ADAPTATIVE_PATHBAR (adaptative_pathbar_get_type ())
#define ADAPTATIVE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbar))
#define ADAPTATIVE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbarClass))
#define IS_ADAPTATIVE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_PATHBAR))
#define IS_ADAPTATIVE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_PATHBAR))
#define ADAPTATIVE_PATHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbarClass))

typedef struct _AdaptativePathbar AdaptativePathbar;
typedef struct _AdaptativePathbarClass AdaptativePathbarClass;

#define TYPE_PATH_ENTRY (path_entry_get_type ())
#define PATH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ENTRY, PathEntry))
#define PATH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_ENTRY, PathEntryClass))
#define IS_PATH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ENTRY))
#define IS_PATH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_ENTRY))
#define PATH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_ENTRY, PathEntryClass))

typedef struct _PathEntry PathEntry;
typedef struct _PathEntryClass PathEntryClass;
enum  {
	PATH_WIDGET_0_PROPERTY,
	PATH_WIDGET_SEARCH_MODE_ENABLED_PROPERTY,
	PATH_WIDGET_NUM_PROPERTIES
};
static GParamSpec* path_widget_properties[PATH_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_PATHBAR (pathbar_get_type ())
#define PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATHBAR, Pathbar))
#define IS_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATHBAR))
#define PATHBAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATHBAR, PathbarIface))

typedef struct _Pathbar Pathbar;
typedef struct _PathbarIface PathbarIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	PATH_ENTRY_SEARCH_MODE_UNCLEAR,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD,
	PATH_ENTRY_SEARCH_MODE_SEARCH
} PathEntrySearchMode;

#define PATH_ENTRY_TYPE_SEARCH_MODE (path_entry_search_mode_get_type ())

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _PathWidget {
	GtkBox parent_instance;
	PathWidgetPrivate * priv;
};

struct _PathWidgetClass {
	GtkBoxClass parent_class;
};

struct _PathWidgetPrivate {
	GtkModelButton* search_toggle;
	GtkModelButton* search_button;
	GtkStack* pathwidget_stack;
	GtkGrid* pathbar_grid;
	AdaptativePathbar* pathbar;
	PathEntry* searchentry;
	GtkRevealer* parent_revealer;
	GtkModelButton* parent_button;
	GThemedIcon* search_icon;
	GThemedIcon* parent_icon;
	gboolean quite_thin_window;
	gboolean extra_thin_window;
	gboolean _search_mode_enabled;
};

struct _PathbarIface {
	GTypeInterface parent_iface;
	gboolean (*has_popover) (Pathbar* self);
	void (*close_menu) (Pathbar* self);
	void (*toggle_menu) (Pathbar* self);
	void (*set_path) (Pathbar* self, ViewType type, const gchar* path);
	void (*update_ghosts) (Pathbar* self, const gchar* non_ghost_path, gboolean is_search);
	void (*get_complete_path) (Pathbar* self, gchar** _complete_path);
	void (*get_fallback_path_and_complete_path) (Pathbar* self, gchar** _fallback_path, gchar** _complete_path);
	gchar* (*get_selected_child) (Pathbar* self, const gchar* current_path);
};

static gint PathWidget_private_offset;
static gpointer path_widget_parent_class = NULL;
static AdaptativeWidgetIface * path_widget_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType path_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PathWidget, g_object_unref)
VALA_EXTERN GType adaptative_pathbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativePathbar, g_object_unref)
VALA_EXTERN GType path_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PathEntry, g_object_unref)
static void path_widget_real_set_window_size (AdaptativeWidget* base,
                                       AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
static void path_widget_enter_search_mode (PathWidget* self);
static void path_widget_set_search_mode_enabled (PathWidget* self,
                                          gboolean value);
static GVariant* _variant_new10 (gboolean value);
static void path_widget_leave_search_mode (PathWidget* self);
static GVariant* _variant_new11 (gboolean value);
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void path_widget_set_path (PathWidget* self,
                           ViewType type,
                           const gchar* path);
VALA_EXTERN GType pathbar_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void pathbar_set_path (Pathbar* self,
                       ViewType type,
                       const gchar* path);
VALA_EXTERN void path_entry_set_path (PathEntry* self,
                          ViewType type,
                          const gchar* _path);
VALA_EXTERN gboolean path_widget_get_search_mode_enabled (PathWidget* self);
VALA_EXTERN void path_widget_close_popovers (PathWidget* self);
VALA_EXTERN void pathbar_close_menu (Pathbar* self);
VALA_EXTERN gboolean path_widget_has_popover (PathWidget* self);
VALA_EXTERN gboolean pathbar_has_popover (Pathbar* self);
VALA_EXTERN void path_widget_get_complete_path (PathWidget* self,
                                    gchar** complete_path);
VALA_EXTERN void pathbar_get_complete_path (Pathbar* self,
                                gchar** _complete_path);
VALA_EXTERN void path_widget_get_fallback_path_and_complete_path (PathWidget* self,
                                                      gchar** fallback_path,
                                                      gchar** complete_path);
VALA_EXTERN void pathbar_get_fallback_path_and_complete_path (Pathbar* self,
                                                  gchar** _fallback_path,
                                                  gchar** _complete_path);
VALA_EXTERN void path_widget_update_ghosts (PathWidget* self,
                                const gchar* fallback_path);
VALA_EXTERN void pathbar_update_ghosts (Pathbar* self,
                            const gchar* non_ghost_path,
                            gboolean is_search);
VALA_EXTERN gchar* path_widget_get_selected_child (PathWidget* self,
                                       const gchar* fallback_path);
VALA_EXTERN gchar* pathbar_get_selected_child (Pathbar* self,
                                   const gchar* current_path);
VALA_EXTERN void path_widget_toggle_pathbar_menu (PathWidget* self);
VALA_EXTERN void pathbar_toggle_menu (Pathbar* self);
VALA_EXTERN void path_widget_entry_grab_focus (PathWidget* self);
VALA_EXTERN void path_entry_entry_grab_focus (PathEntry* self);
VALA_EXTERN void path_widget_entry_grab_focus_without_selecting (PathWidget* self);
VALA_EXTERN void path_entry_entry_grab_focus_without_selecting (PathEntry* self);
VALA_EXTERN gboolean path_widget_handle_event (PathWidget* self,
                                   GdkEventKey* event);
VALA_EXTERN GType path_entry_search_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void path_entry_prepare (PathEntry* self,
                         PathEntrySearchMode mode,
                         const gchar* nullable_search);
VALA_EXTERN gboolean path_entry_handle_event (PathEntry* self,
                                  GdkEventKey* event);
VALA_EXTERN void path_widget_prepare_search (PathWidget* self,
                                 PathEntrySearchMode mode,
                                 const gchar* search);
static void path_widget_real_get_preferred_width (GtkWidget* base,
                                           gint* minimum_width,
                                           gint* natural_width);
VALA_EXTERN PathWidget* path_widget_new (void);
VALA_EXTERN PathWidget* path_widget_construct (GType object_type);
static GObject * path_widget_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void path_widget_finalize (GObject * obj);
static GType path_widget_get_type_once (void);
static void _vala_path_widget_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_path_widget_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
path_widget_get_instance_private (PathWidget* self)
{
	return G_STRUCT_MEMBER_P (self, PathWidget_private_offset);
}

static void
path_widget_real_set_window_size (AdaptativeWidget* base,
                                  AdaptativeWidgetWindowSize new_size)
{
	PathWidget * self;
	AdaptativePathbar* _tmp0_;
	gboolean _quite_thin_window = FALSE;
	gboolean _extra_thin_window = FALSE;
	gboolean _tmp1_ = FALSE;
	PathEntry* _tmp11_;
	self = (PathWidget*) base;
	_tmp0_ = self->priv->pathbar;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp0_, new_size);
	_quite_thin_window = adaptative_widget_window_size_is_quite_thin (new_size);
	_extra_thin_window = adaptative_widget_window_size_is_extra_thin (new_size);
	if (self->priv->quite_thin_window != _quite_thin_window) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->extra_thin_window != _extra_thin_window;
	}
	if (_tmp1_) {
		self->priv->quite_thin_window = _quite_thin_window;
		self->priv->extra_thin_window = _extra_thin_window;
		if (_extra_thin_window) {
			GtkModelButton* _tmp2_;
			GtkModelButton* _tmp3_;
			GtkRevealer* _tmp4_;
			_tmp2_ = self->priv->search_toggle;
			gtk_widget_hide ((GtkWidget*) _tmp2_);
			_tmp3_ = self->priv->search_button;
			gtk_widget_show ((GtkWidget*) _tmp3_);
			_tmp4_ = self->priv->parent_revealer;
			gtk_revealer_set_reveal_child (_tmp4_, TRUE);
		} else {
			if (_quite_thin_window) {
				GtkModelButton* _tmp5_;
				GtkModelButton* _tmp6_;
				GtkRevealer* _tmp7_;
				_tmp5_ = self->priv->search_toggle;
				gtk_widget_hide ((GtkWidget*) _tmp5_);
				_tmp6_ = self->priv->search_button;
				gtk_widget_show ((GtkWidget*) _tmp6_);
				_tmp7_ = self->priv->parent_revealer;
				gtk_revealer_set_reveal_child (_tmp7_, FALSE);
			} else {
				GtkModelButton* _tmp8_;
				GtkModelButton* _tmp9_;
				GtkRevealer* _tmp10_;
				_tmp8_ = self->priv->search_button;
				gtk_widget_hide ((GtkWidget*) _tmp8_);
				_tmp9_ = self->priv->search_toggle;
				gtk_widget_show ((GtkWidget*) _tmp9_);
				_tmp10_ = self->priv->parent_revealer;
				gtk_revealer_set_reveal_child (_tmp10_, FALSE);
			}
		}
	}
	_tmp11_ = self->priv->searchentry;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp11_, new_size);
}

static GVariant*
_variant_new10 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
path_widget_enter_search_mode (PathWidget* self)
{
	GtkModelButton* _tmp0_;
	GVariant* _tmp1_;
	GtkStack* _tmp2_;
	PathEntry* _tmp3_;
	g_return_if_fail (self != NULL);
	path_widget_set_search_mode_enabled (self, TRUE);
	_tmp0_ = self->priv->search_toggle;
	_tmp1_ = _variant_new10 (FALSE);
	gtk_actionable_set_action_target_value ((GtkActionable*) _tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = self->priv->pathwidget_stack;
	_tmp3_ = self->priv->searchentry;
	gtk_stack_set_visible_child (_tmp2_, (GtkWidget*) _tmp3_);
}

static GVariant*
_variant_new11 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
path_widget_leave_search_mode (PathWidget* self)
{
	GtkModelButton* _tmp0_;
	GVariant* _tmp1_;
	GtkStack* _tmp2_;
	GtkGrid* _tmp3_;
	g_return_if_fail (self != NULL);
	path_widget_set_search_mode_enabled (self, FALSE);
	_tmp0_ = self->priv->search_toggle;
	_tmp1_ = _variant_new11 (TRUE);
	gtk_actionable_set_action_target_value ((GtkActionable*) _tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = self->priv->pathwidget_stack;
	_tmp3_ = self->priv->pathbar_grid;
	gtk_stack_set_visible_child (_tmp2_, (GtkWidget*) _tmp3_);
}

void
path_widget_set_path (PathWidget* self,
                      ViewType type,
                      const gchar* path)
{
	AdaptativePathbar* _tmp0_;
	PathEntry* _tmp1_;
	gboolean is_search = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->pathbar;
	pathbar_set_path ((Pathbar*) _tmp0_, type, path);
	_tmp1_ = self->priv->searchentry;
	path_entry_set_path (_tmp1_, type, path);
	is_search = type == VIEW_TYPE_SEARCH;
	if (!is_search) {
		if (g_strcmp0 (path, "/") != 0) {
			GVariant* path_variant = NULL;
			GVariant* _tmp2_;
			GtkModelButton* _tmp3_;
			GVariant* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp2_ = g_variant_new_string (path);
			g_variant_ref_sink (_tmp2_);
			path_variant = _tmp2_;
			_tmp3_ = self->priv->parent_button;
			_tmp4_ = path_variant;
			_tmp5_ = g_variant_print (_tmp4_, FALSE);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat ("browser.open-parent(", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (_tmp8_, ")", NULL);
			_tmp10_ = _tmp9_;
			gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp3_, _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp6_);
			_g_variant_unref0 (path_variant);
		} else {
			GtkModelButton* _tmp11_;
			_tmp11_ = self->priv->parent_button;
			gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp11_, "browser.disabled-state-s('/')");
		}
	}
	if (is_search) {
		gboolean _tmp13_;
		_tmp13_ = self->priv->_search_mode_enabled;
		_tmp12_ = !_tmp13_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		path_widget_enter_search_mode (self);
	} else {
		gboolean _tmp14_ = FALSE;
		if (!is_search) {
			gboolean _tmp15_;
			_tmp15_ = self->priv->_search_mode_enabled;
			_tmp14_ = _tmp15_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			path_widget_leave_search_mode (self);
		}
	}
}

void
path_widget_close_popovers (PathWidget* self)
{
	AdaptativePathbar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pathbar;
	pathbar_close_menu ((Pathbar*) _tmp0_);
}

gboolean
path_widget_has_popover (PathWidget* self)
{
	AdaptativePathbar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pathbar;
	if (pathbar_has_popover ((Pathbar*) _tmp0_)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
path_widget_get_complete_path (PathWidget* self,
                               gchar** complete_path)
{
	gchar* _vala_complete_path = NULL;
	AdaptativePathbar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pathbar;
	pathbar_get_complete_path ((Pathbar*) _tmp0_, &_tmp1_);
	_g_free0 (_vala_complete_path);
	_vala_complete_path = _tmp1_;
	if (complete_path) {
		*complete_path = _vala_complete_path;
	} else {
		_g_free0 (_vala_complete_path);
	}
}

void
path_widget_get_fallback_path_and_complete_path (PathWidget* self,
                                                 gchar** fallback_path,
                                                 gchar** complete_path)
{
	gchar* _vala_fallback_path = NULL;
	gchar* _vala_complete_path = NULL;
	AdaptativePathbar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pathbar;
	pathbar_get_fallback_path_and_complete_path ((Pathbar*) _tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (_vala_fallback_path);
	_vala_fallback_path = _tmp1_;
	_g_free0 (_vala_complete_path);
	_vala_complete_path = _tmp2_;
	if (fallback_path) {
		*fallback_path = _vala_fallback_path;
	} else {
		_g_free0 (_vala_fallback_path);
	}
	if (complete_path) {
		*complete_path = _vala_complete_path;
	} else {
		_g_free0 (_vala_complete_path);
	}
}

void
path_widget_update_ghosts (PathWidget* self,
                           const gchar* fallback_path)
{
	AdaptativePathbar* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fallback_path != NULL);
	_tmp0_ = self->priv->pathbar;
	_tmp1_ = self->priv->_search_mode_enabled;
	pathbar_update_ghosts ((Pathbar*) _tmp0_, fallback_path, _tmp1_);
}

gchar*
path_widget_get_selected_child (PathWidget* self,
                                const gchar* fallback_path)
{
	AdaptativePathbar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fallback_path != NULL, NULL);
	_tmp0_ = self->priv->pathbar;
	_tmp1_ = pathbar_get_selected_child ((Pathbar*) _tmp0_, fallback_path);
	result = _tmp1_;
	return result;
}

void
path_widget_toggle_pathbar_menu (PathWidget* self)
{
	AdaptativePathbar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pathbar;
	pathbar_toggle_menu ((Pathbar*) _tmp0_);
}

void
path_widget_entry_grab_focus (PathWidget* self)
{
	PathEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->searchentry;
	path_entry_entry_grab_focus (_tmp0_);
}

void
path_widget_entry_grab_focus_without_selecting (PathWidget* self)
{
	PathEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->searchentry;
	path_entry_entry_grab_focus_without_selecting (_tmp0_);
}

gboolean
path_widget_handle_event (PathWidget* self,
                          GdkEventKey* event)
{
	PathEntry* _tmp0_;
	PathEntry* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->searchentry;
	path_entry_prepare (_tmp0_, PATH_ENTRY_SEARCH_MODE_SEARCH, NULL);
	_tmp1_ = self->priv->searchentry;
	if (!path_entry_handle_event (_tmp1_, event)) {
		result = FALSE;
		return result;
	}
	path_widget_enter_search_mode (self);
	result = TRUE;
	return result;
}

void
path_widget_prepare_search (PathWidget* self,
                            PathEntrySearchMode mode,
                            const gchar* search)
{
	PathEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->searchentry;
	path_entry_prepare (_tmp0_, mode, search);
}

static void
path_widget_real_get_preferred_width (GtkWidget* base,
                                      gint* minimum_width,
                                      gint* natural_width)
{
	PathWidget * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (PathWidget*) base;
	GTK_WIDGET_CLASS (path_widget_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_vala_natural_width = MAX_ROW_WIDTH - 46;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

PathWidget*
path_widget_construct (GType object_type)
{
	PathWidget * self = NULL;
	self = (PathWidget*) g_object_new (object_type, NULL);
	return self;
}

PathWidget*
path_widget_new (void)
{
	return path_widget_construct (TYPE_PATH_WIDGET);
}

gboolean
path_widget_get_search_mode_enabled (PathWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_search_mode_enabled;
	return result;
}

static void
path_widget_set_search_mode_enabled (PathWidget* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_search_mode_enabled = value;
}

static GObject *
path_widget_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PathWidget * self;
	GtkModelButton* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkModelButton* _tmp2_;
	GThemedIcon* _tmp3_;
	GtkModelButton* _tmp4_;
	GThemedIcon* _tmp5_;
	parent_class = G_OBJECT_CLASS (path_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_WIDGET, PathWidget);
	_tmp0_ = self->priv->search_toggle;
	_tmp1_ = self->priv->search_icon;
	g_object_set (_tmp0_, "icon", (GIcon*) _tmp1_, NULL);
	_tmp2_ = self->priv->search_button;
	_tmp3_ = self->priv->search_icon;
	g_object_set (_tmp2_, "icon", (GIcon*) _tmp3_, NULL);
	_tmp4_ = self->priv->parent_button;
	_tmp5_ = self->priv->parent_icon;
	g_object_set (_tmp4_, "icon", (GIcon*) _tmp5_, NULL);
	return obj;
}

static void
path_widget_class_init (PathWidgetClass * klass,
                        gpointer klass_data)
{
	path_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PathWidget_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) path_widget_real_get_preferred_width;
	G_OBJECT_CLASS (klass)->get_property = _vala_path_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_path_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = path_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = path_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PATH_WIDGET_SEARCH_MODE_ENABLED_PROPERTY, path_widget_properties[PATH_WIDGET_SEARCH_MODE_ENABLED_PROPERTY] = g_param_spec_boolean ("search-mode-enabled", "search-mode-enabled", "search-mode-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/pathwidget.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_toggle", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, search_toggle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_button", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathwidget_stack", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, pathwidget_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar_grid", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, pathbar_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, pathbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "searchentry", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, searchentry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "parent_revealer", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, parent_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "parent_button", FALSE, PathWidget_private_offset + G_STRUCT_OFFSET (PathWidgetPrivate, parent_button));
}

static void
path_widget_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                              gpointer iface_data)
{
	path_widget_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) path_widget_real_set_window_size;
}

static void
path_widget_instance_init (PathWidget * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GThemedIcon* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GThemedIcon* _tmp7_;
	self->priv = path_widget_get_instance_private (self);
	_tmp0_ = g_strdup ("edit-find-symbolic");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp2_, 1);
	self->priv->search_icon = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = g_strdup ("go-up-symbolic");
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp6_, 1);
	self->priv->parent_icon = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	self->priv->quite_thin_window = FALSE;
	self->priv->extra_thin_window = FALSE;
	self->priv->_search_mode_enabled = FALSE;
	g_type_ensure (TYPE_ADAPTATIVE_PATHBAR);
	g_type_ensure (TYPE_PATH_ENTRY);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
path_widget_finalize (GObject * obj)
{
	PathWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_WIDGET, PathWidget);
	_g_object_unref0 (self->priv->search_icon);
	_g_object_unref0 (self->priv->parent_icon);
	G_OBJECT_CLASS (path_widget_parent_class)->finalize (obj);
}

static GType
path_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PathWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) path_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PathWidget), 0, (GInstanceInitFunc) path_widget_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) path_widget_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType path_widget_type_id;
	path_widget_type_id = g_type_register_static (gtk_box_get_type (), "PathWidget", &g_define_type_info, 0);
	g_type_add_interface_static (path_widget_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	PathWidget_private_offset = g_type_add_instance_private (path_widget_type_id, sizeof (PathWidgetPrivate));
	return path_widget_type_id;
}

GType
path_widget_get_type (void)
{
	static volatile gsize path_widget_type_id__once = 0;
	if (g_once_init_enter (&path_widget_type_id__once)) {
		GType path_widget_type_id;
		path_widget_type_id = path_widget_get_type_once ();
		g_once_init_leave (&path_widget_type_id__once, path_widget_type_id);
	}
	return path_widget_type_id__once;
}

static void
_vala_path_widget_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PathWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PATH_WIDGET, PathWidget);
	switch (property_id) {
		case PATH_WIDGET_SEARCH_MODE_ENABLED_PROPERTY:
		g_value_set_boolean (value, path_widget_get_search_mode_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_path_widget_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PathWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PATH_WIDGET, PathWidget);
	switch (property_id) {
		case PATH_WIDGET_SEARCH_MODE_ENABLED_PROPERTY:
		path_widget_set_search_mode_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

