/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#include "src/datovka_shared/io/db_tables.h"
#include "src/datovka_shared/io/message_db_tables.h"
#include "src/datovka_shared/io/prefs_db_tables.h"
#include "src/datovka_shared/io/records_management_db_tables.h"
#include "src/datovka_shared/io/sqlite/table.h"
#include "src/io/account_db_tables.h"
#if defined(ENABLE_TAGS)
#  include "src/io/tag_db_tables.h"
#endif /* defined(ENABLE_TAGS) */
#if defined(ENABLE_TIMESTAMP_TRACKING)
#  include "src/io/timestamp_db_tables.h"
#endif /* defined(ENABLE_TIMESTAMP_TRACKING) */

void SQLiteTbls::localiseTableDescriptions(void)
{
	/* account_db */
	AccountDbTables::accntinfTbl.reloadLocalisedDescription();
	AccountDbTables::userinfTbl.reloadLocalisedDescription();
	AccountDbTables::pwdexpdtTbl.reloadLocalisedDescription();
	AccountDbTables::dtinfTbl.reloadLocalisedDescription();
	/* message_db */
	MessageDbTables::msgsTbl.reloadLocalisedDescription();
	MessageDbTables::flsTbl.reloadLocalisedDescription();
	MessageDbTables::hshsTbl.reloadLocalisedDescription();
	MessageDbTables::evntsTbl.reloadLocalisedDescription();
	MessageDbTables::prcstTbl.reloadLocalisedDescription();
	MessageDbTables::rwmsgdtTbl.reloadLocalisedDescription();
	MessageDbTables::rwdlvrinfdtTbl.reloadLocalisedDescription();
	MessageDbTables::smsgdtTbl.reloadLocalisedDescription();
	MessageDbTables::crtdtTbl.reloadLocalisedDescription();
	MessageDbTables::msgcrtdtTbl.reloadLocalisedDescription();
	/* prefs_db */
	PrefsDbTables::prfsTbl.reloadLocalisedDescription();
#if defined(ENABLE_TAGS)
	/* tag_db */
	TagDbTables::_dbInfoTbl.reloadLocalisedDescription();
	TagDbTables::tagsTbl.reloadLocalisedDescription();
	TagDbTables::msgtagsTbl.reloadLocalisedDescription();
#endif /* defined(ENABLE_TAGS) */
#if defined(ENABLE_TIMESTAMP_TRACKING)
	/* timestamp_db */
	TimestampDbTables::_dbInfoTbl.reloadLocalisedDescription();
	TimestampDbTables::identificationTbl.reloadLocalisedDescription();
	TimestampDbTables::accountTbl.reloadLocalisedDescription();
	TimestampDbTables::identifAccountAffinityTbl.reloadLocalisedDescription();
	TimestampDbTables::messagesTbl.reloadLocalisedDescription();
	TimestampDbTables::supMsgDataTbl.reloadLocalisedDescription();
	TimestampDbTables::delInfosTbl.reloadLocalisedDescription();
	TimestampDbTables::supDelInfoDataTbl.reloadLocalisedDescription();
#endif /* defined(ENABLE_TIMESTAMP_TRACKING) */
	/* records_management_db */
	RecordsManagementDbTables::srvcInfTbl.reloadLocalisedDescription();
	RecordsManagementDbTables::strdFlsMsgsTbl.reloadLocalisedDescription();
}
