// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: prompt.proto

package prompt

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type BoolRequest struct {
	// the prompt to display to the user
	Prompt string `protobuf:"bytes,1,opt,name=prompt,proto3" json:"prompt,omitempty"`
	// if provided, the prompt will be persisted and not reprompted
	PersistentKey string `protobuf:"bytes,2,opt,name=persistentKey,proto3" json:"persistentKey,omitempty"`
	// the default value to return if the user doesn't respond
	Default bool `protobuf:"varint,3,opt,name=default,proto3" json:"default,omitempty"`
	// a (very) brief title for the prompt
	Title string `protobuf:"bytes,4,opt,name=title,proto3" json:"title,omitempty"`
}

func (m *BoolRequest) Reset()      { *m = BoolRequest{} }
func (*BoolRequest) ProtoMessage() {}
func (*BoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2532b5caf780ac64, []int{0}
}
func (m *BoolRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BoolRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoolRequest.Merge(m, src)
}
func (m *BoolRequest) XXX_Size() int {
	return m.Size()
}
func (m *BoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BoolRequest proto.InternalMessageInfo

func (m *BoolRequest) GetPrompt() string {
	if m != nil {
		return m.Prompt
	}
	return ""
}

func (m *BoolRequest) GetPersistentKey() string {
	if m != nil {
		return m.PersistentKey
	}
	return ""
}

func (m *BoolRequest) GetDefault() bool {
	if m != nil {
		return m.Default
	}
	return false
}

func (m *BoolRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

type BoolResponse struct {
	// the response from the user
	Response bool `protobuf:"varint,1,opt,name=response,proto3" json:"response,omitempty"`
}

func (m *BoolResponse) Reset()      { *m = BoolResponse{} }
func (*BoolResponse) ProtoMessage() {}
func (*BoolResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2532b5caf780ac64, []int{1}
}
func (m *BoolResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BoolResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BoolResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BoolResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoolResponse.Merge(m, src)
}
func (m *BoolResponse) XXX_Size() int {
	return m.Size()
}
func (m *BoolResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BoolResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BoolResponse proto.InternalMessageInfo

func (m *BoolResponse) GetResponse() bool {
	if m != nil {
		return m.Response
	}
	return false
}

type StringRequest struct {
	// the prompt to display to the user
	Prompt string `protobuf:"bytes,1,opt,name=prompt,proto3" json:"prompt,omitempty"`
	// the default value to return if the user doesn't respond
	Default string `protobuf:"bytes,2,opt,name=default,proto3" json:"default,omitempty"`
	// a (very) brief title for the prompt
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
}

func (m *StringRequest) Reset()      { *m = StringRequest{} }
func (*StringRequest) ProtoMessage() {}
func (*StringRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2532b5caf780ac64, []int{2}
}
func (m *StringRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringRequest.Merge(m, src)
}
func (m *StringRequest) XXX_Size() int {
	return m.Size()
}
func (m *StringRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StringRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StringRequest proto.InternalMessageInfo

func (m *StringRequest) GetPrompt() string {
	if m != nil {
		return m.Prompt
	}
	return ""
}

func (m *StringRequest) GetDefault() string {
	if m != nil {
		return m.Default
	}
	return ""
}

func (m *StringRequest) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

type StringResponse struct {
	// the response from the user
	Response string `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
}

func (m *StringResponse) Reset()      { *m = StringResponse{} }
func (*StringResponse) ProtoMessage() {}
func (*StringResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2532b5caf780ac64, []int{3}
}
func (m *StringResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringResponse.Merge(m, src)
}
func (m *StringResponse) XXX_Size() int {
	return m.Size()
}
func (m *StringResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StringResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StringResponse proto.InternalMessageInfo

func (m *StringResponse) GetResponse() string {
	if m != nil {
		return m.Response
	}
	return ""
}

func init() {
	proto.RegisterType((*BoolRequest)(nil), "dagger.prompt.BoolRequest")
	proto.RegisterType((*BoolResponse)(nil), "dagger.prompt.BoolResponse")
	proto.RegisterType((*StringRequest)(nil), "dagger.prompt.StringRequest")
	proto.RegisterType((*StringResponse)(nil), "dagger.prompt.StringResponse")
}

func init() { proto.RegisterFile("prompt.proto", fileDescriptor_2532b5caf780ac64) }

var fileDescriptor_2532b5caf780ac64 = []byte{
	// 311 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0x29, 0x28, 0xca, 0xcf,
	0x2d, 0x28, 0xd1, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0xe2, 0x4d, 0x49, 0x4c, 0x4f, 0x4f, 0x2d,
	0xd2, 0x83, 0x08, 0x2a, 0x55, 0x73, 0x71, 0x3b, 0xe5, 0xe7, 0xe7, 0x04, 0xa5, 0x16, 0x96, 0xa6,
	0x16, 0x97, 0x08, 0x89, 0x71, 0xb1, 0x41, 0x24, 0x24, 0x18, 0x15, 0x18, 0x35, 0x38, 0x83, 0xa0,
	0x3c, 0x21, 0x15, 0x2e, 0xde, 0x82, 0xd4, 0xa2, 0xe2, 0xcc, 0xe2, 0x92, 0xd4, 0xbc, 0x12, 0xef,
	0xd4, 0x4a, 0x09, 0x26, 0xb0, 0x34, 0xaa, 0xa0, 0x90, 0x04, 0x17, 0x7b, 0x4a, 0x6a, 0x5a, 0x62,
	0x69, 0x4e, 0x89, 0x04, 0xb3, 0x02, 0xa3, 0x06, 0x47, 0x10, 0x8c, 0x2b, 0x24, 0xc2, 0xc5, 0x5a,
	0x92, 0x59, 0x92, 0x93, 0x2a, 0xc1, 0x02, 0xd6, 0x07, 0xe1, 0x28, 0x69, 0x71, 0xf1, 0x40, 0x2c,
	0x2f, 0x2e, 0xc8, 0xcf, 0x2b, 0x4e, 0x15, 0x92, 0xe2, 0xe2, 0x28, 0x82, 0xb2, 0xc1, 0xf6, 0x73,
	0x04, 0xc1, 0xf9, 0x4a, 0xe1, 0x5c, 0xbc, 0xc1, 0x25, 0x45, 0x99, 0x79, 0xe9, 0x84, 0x9c, 0x8a,
	0xe4, 0x08, 0x88, 0x23, 0x31, 0x1d, 0xc1, 0x8c, 0xec, 0x08, 0x1d, 0x2e, 0x3e, 0x98, 0xc1, 0x38,
	0x9c, 0xc1, 0x89, 0x70, 0x86, 0xd1, 0x1c, 0x46, 0x2e, 0xb6, 0x00, 0x88, 0x45, 0xae, 0x5c, 0x5c,
	0x10, 0x16, 0xc8, 0x0f, 0x42, 0x52, 0x7a, 0x28, 0x01, 0xab, 0x87, 0x14, 0xaa, 0x52, 0xd2, 0x58,
	0xe5, 0xa0, 0xb6, 0x79, 0x73, 0xf1, 0x40, 0x8c, 0x81, 0xb8, 0x42, 0x48, 0x06, 0x4d, 0x31, 0x8a,
	0xaf, 0xa5, 0x64, 0x71, 0xc8, 0x42, 0x0c, 0x73, 0xb2, 0xb9, 0xf0, 0x50, 0x8e, 0xe1, 0xc6, 0x43,
	0x39, 0x86, 0x0f, 0x0f, 0xe5, 0x18, 0x1b, 0x1e, 0xc9, 0x31, 0xae, 0x78, 0x24, 0xc7, 0x78, 0xe2,
	0x91, 0x1c, 0xe3, 0x85, 0x47, 0x72, 0x8c, 0x0f, 0x1e, 0xc9, 0x31, 0xbe, 0x78, 0x24, 0xc7, 0xf0,
	0xe1, 0x91, 0x1c, 0xe3, 0x84, 0xc7, 0x72, 0x0c, 0x17, 0x1e, 0xcb, 0x31, 0xdc, 0x78, 0x2c, 0xc7,
	0x10, 0x05, 0x0d, 0xba, 0x24, 0x36, 0x70, 0x12, 0x31, 0x06, 0x04, 0x00, 0x00, 0xff, 0xff, 0xe6,
	0x81, 0xde, 0x61, 0x32, 0x02, 0x00, 0x00,
}

func (this *BoolRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BoolRequest)
	if !ok {
		that2, ok := that.(BoolRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Prompt != that1.Prompt {
		return false
	}
	if this.PersistentKey != that1.PersistentKey {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	if this.Title != that1.Title {
		return false
	}
	return true
}
func (this *BoolResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BoolResponse)
	if !ok {
		that2, ok := that.(BoolResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Response != that1.Response {
		return false
	}
	return true
}
func (this *StringRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StringRequest)
	if !ok {
		that2, ok := that.(StringRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Prompt != that1.Prompt {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	if this.Title != that1.Title {
		return false
	}
	return true
}
func (this *StringResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StringResponse)
	if !ok {
		that2, ok := that.(StringResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Response != that1.Response {
		return false
	}
	return true
}
func (this *BoolRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&prompt.BoolRequest{")
	s = append(s, "Prompt: "+fmt.Sprintf("%#v", this.Prompt)+",\n")
	s = append(s, "PersistentKey: "+fmt.Sprintf("%#v", this.PersistentKey)+",\n")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "Title: "+fmt.Sprintf("%#v", this.Title)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *BoolResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&prompt.BoolResponse{")
	s = append(s, "Response: "+fmt.Sprintf("%#v", this.Response)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StringRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&prompt.StringRequest{")
	s = append(s, "Prompt: "+fmt.Sprintf("%#v", this.Prompt)+",\n")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "Title: "+fmt.Sprintf("%#v", this.Title)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StringResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&prompt.StringResponse{")
	s = append(s, "Response: "+fmt.Sprintf("%#v", this.Response)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringPrompt(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PromptClient is the client API for Prompt service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PromptClient interface {
	PromptBool(ctx context.Context, in *BoolRequest, opts ...grpc.CallOption) (*BoolResponse, error)
	PromptString(ctx context.Context, in *StringRequest, opts ...grpc.CallOption) (*StringResponse, error)
}

type promptClient struct {
	cc *grpc.ClientConn
}

func NewPromptClient(cc *grpc.ClientConn) PromptClient {
	return &promptClient{cc}
}

func (c *promptClient) PromptBool(ctx context.Context, in *BoolRequest, opts ...grpc.CallOption) (*BoolResponse, error) {
	out := new(BoolResponse)
	err := c.cc.Invoke(ctx, "/dagger.prompt.Prompt/PromptBool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *promptClient) PromptString(ctx context.Context, in *StringRequest, opts ...grpc.CallOption) (*StringResponse, error) {
	out := new(StringResponse)
	err := c.cc.Invoke(ctx, "/dagger.prompt.Prompt/PromptString", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PromptServer is the server API for Prompt service.
type PromptServer interface {
	PromptBool(context.Context, *BoolRequest) (*BoolResponse, error)
	PromptString(context.Context, *StringRequest) (*StringResponse, error)
}

// UnimplementedPromptServer can be embedded to have forward compatible implementations.
type UnimplementedPromptServer struct {
}

func (*UnimplementedPromptServer) PromptBool(ctx context.Context, req *BoolRequest) (*BoolResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromptBool not implemented")
}
func (*UnimplementedPromptServer) PromptString(ctx context.Context, req *StringRequest) (*StringResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromptString not implemented")
}

func RegisterPromptServer(s *grpc.Server, srv PromptServer) {
	s.RegisterService(&_Prompt_serviceDesc, srv)
}

func _Prompt_PromptBool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PromptServer).PromptBool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dagger.prompt.Prompt/PromptBool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PromptServer).PromptBool(ctx, req.(*BoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Prompt_PromptString_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StringRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PromptServer).PromptString(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dagger.prompt.Prompt/PromptString",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PromptServer).PromptString(ctx, req.(*StringRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Prompt_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dagger.prompt.Prompt",
	HandlerType: (*PromptServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PromptBool",
			Handler:    _Prompt_PromptBool_Handler,
		},
		{
			MethodName: "PromptString",
			Handler:    _Prompt_PromptString_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "prompt.proto",
}

func (m *BoolRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BoolRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BoolRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Title) > 0 {
		i -= len(m.Title)
		copy(dAtA[i:], m.Title)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.Title)))
		i--
		dAtA[i] = 0x22
	}
	if m.Default {
		i--
		if m.Default {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.PersistentKey) > 0 {
		i -= len(m.PersistentKey)
		copy(dAtA[i:], m.PersistentKey)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.PersistentKey)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Prompt) > 0 {
		i -= len(m.Prompt)
		copy(dAtA[i:], m.Prompt)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.Prompt)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BoolResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BoolResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BoolResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Response {
		i--
		if m.Response {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *StringRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Title) > 0 {
		i -= len(m.Title)
		copy(dAtA[i:], m.Title)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.Title)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Default) > 0 {
		i -= len(m.Default)
		copy(dAtA[i:], m.Default)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.Default)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Prompt) > 0 {
		i -= len(m.Prompt)
		copy(dAtA[i:], m.Prompt)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.Prompt)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StringResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Response) > 0 {
		i -= len(m.Response)
		copy(dAtA[i:], m.Response)
		i = encodeVarintPrompt(dAtA, i, uint64(len(m.Response)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintPrompt(dAtA []byte, offset int, v uint64) int {
	offset -= sovPrompt(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *BoolRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prompt)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	l = len(m.PersistentKey)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	if m.Default {
		n += 2
	}
	l = len(m.Title)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	return n
}

func (m *BoolResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Response {
		n += 2
	}
	return n
}

func (m *StringRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prompt)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	l = len(m.Default)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	l = len(m.Title)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	return n
}

func (m *StringResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Response)
	if l > 0 {
		n += 1 + l + sovPrompt(uint64(l))
	}
	return n
}

func sovPrompt(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPrompt(x uint64) (n int) {
	return sovPrompt(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *BoolRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BoolRequest{`,
		`Prompt:` + fmt.Sprintf("%v", this.Prompt) + `,`,
		`PersistentKey:` + fmt.Sprintf("%v", this.PersistentKey) + `,`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`Title:` + fmt.Sprintf("%v", this.Title) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BoolResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BoolResponse{`,
		`Response:` + fmt.Sprintf("%v", this.Response) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringRequest{`,
		`Prompt:` + fmt.Sprintf("%v", this.Prompt) + `,`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`Title:` + fmt.Sprintf("%v", this.Title) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringResponse{`,
		`Response:` + fmt.Sprintf("%v", this.Response) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringPrompt(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *BoolRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPrompt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BoolRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BoolRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prompt", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prompt = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PersistentKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PersistentKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Default = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Title", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Title = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPrompt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPrompt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BoolResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPrompt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BoolResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BoolResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Response = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPrompt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPrompt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPrompt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prompt", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prompt = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Default = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Title", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Title = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPrompt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPrompt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPrompt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPrompt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPrompt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Response = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPrompt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPrompt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPrompt(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPrompt
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPrompt
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPrompt
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPrompt
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPrompt
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPrompt        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPrompt          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPrompt = fmt.Errorf("proto: unexpected end of group")
)
