/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	v1 "k8s.io/client-go/applyconfigurations/core/v1"
)

// EndpointApplyConfiguration represents a declarative configuration of the Endpoint type for use
// with apply.
//
// Endpoint represents a single logical "backend" implementing a service.
type EndpointApplyConfiguration struct {
	// addresses of this endpoint. The contents of this field are interpreted
	// according to the corresponding EndpointSlice addressType field. Consumers
	// must handle different types of addresses in the context of their own
	// capabilities. This must contain at least one address but no more than
	// 100. These are all assumed to be fungible and clients may choose to only
	// use the first element. Refer to: https://issue.k8s.io/106267
	Addresses []string `json:"addresses,omitempty"`
	// conditions contains information about the current status of the endpoint.
	Conditions *EndpointConditionsApplyConfiguration `json:"conditions,omitempty"`
	// hostname of this endpoint. This field may be used by consumers of
	// endpoints to distinguish endpoints from each other (e.g. in DNS names).
	// Multiple endpoints which use the same hostname should be considered
	// fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS
	// Label (RFC 1123) validation.
	Hostname *string `json:"hostname,omitempty"`
	// targetRef is a reference to a Kubernetes object that represents this
	// endpoint.
	TargetRef *v1.ObjectReferenceApplyConfiguration `json:"targetRef,omitempty"`
	// topology contains arbitrary topology information associated with the
	// endpoint. These key/value pairs must conform with the label format.
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
	// Topology may include a maximum of 16 key/value pairs. This includes, but
	// is not limited to the following well known keys:
	// * kubernetes.io/hostname: the value indicates the hostname of the node
	// where the endpoint is located. This should match the corresponding
	// node label.
	// * topology.kubernetes.io/zone: the value indicates the zone where the
	// endpoint is located. This should match the corresponding node label.
	// * topology.kubernetes.io/region: the value indicates the region where the
	// endpoint is located. This should match the corresponding node label.
	// This field is deprecated and will be removed in future api versions.
	Topology map[string]string `json:"topology,omitempty"`
	// nodeName represents the name of the Node hosting this endpoint. This can
	// be used to determine endpoints local to a Node.
	NodeName *string `json:"nodeName,omitempty"`
	// hints contains information associated with how an endpoint should be
	// consumed.
	Hints *EndpointHintsApplyConfiguration `json:"hints,omitempty"`
}

// EndpointApplyConfiguration constructs a declarative configuration of the Endpoint type for use with
// apply.
func Endpoint() *EndpointApplyConfiguration {
	return &EndpointApplyConfiguration{}
}

// WithAddresses adds the given value to the Addresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Addresses field.
func (b *EndpointApplyConfiguration) WithAddresses(values ...string) *EndpointApplyConfiguration {
	for i := range values {
		b.Addresses = append(b.Addresses, values[i])
	}
	return b
}

// WithConditions sets the Conditions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Conditions field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithConditions(value *EndpointConditionsApplyConfiguration) *EndpointApplyConfiguration {
	b.Conditions = value
	return b
}

// WithHostname sets the Hostname field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hostname field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithHostname(value string) *EndpointApplyConfiguration {
	b.Hostname = &value
	return b
}

// WithTargetRef sets the TargetRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetRef field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithTargetRef(value *v1.ObjectReferenceApplyConfiguration) *EndpointApplyConfiguration {
	b.TargetRef = value
	return b
}

// WithTopology puts the entries into the Topology field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Topology field,
// overwriting an existing map entries in Topology field with the same key.
func (b *EndpointApplyConfiguration) WithTopology(entries map[string]string) *EndpointApplyConfiguration {
	if b.Topology == nil && len(entries) > 0 {
		b.Topology = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Topology[k] = v
	}
	return b
}

// WithNodeName sets the NodeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeName field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithNodeName(value string) *EndpointApplyConfiguration {
	b.NodeName = &value
	return b
}

// WithHints sets the Hints field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hints field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithHints(value *EndpointHintsApplyConfiguration) *EndpointApplyConfiguration {
	b.Hints = value
	return b
}
