const char defconfig[] = 
    "-- Conky, a system monitor https://github.com/brndnmtthws/conky\n"
    "--\n"
    "-- This configuration file is Lua code. You can write code in here, and it will\n"
    "-- execute when Conky loads. You can use it to generate your own advanced\n"
    "-- configurations.\n"
    "--\n"
    "-- Try this (remove the `--`):\n"
    "--\n"
    "--   print(\"Loading Conky config\")\n"
    "--\n"
    "-- For more on Lua, see:\n"
    "-- https://www.lua.org/pil/contents.html\n"
    "--\n"
    "-- Conky Lua API: https://conky.cc/lua\n"
    "\n"
    "-- Configuration settings: https://conky.cc/config_settings\n"
    "conky.config = {\n"
    "    alignment = 'top_left',\n"
    "    background = false,\n"
    "    border_width = 1,\n"
    "    cpu_avg_samples = 2,\n"
    "    default_color = 'white',\n"
    "    default_outline_color = 'white',\n"
    "    default_shade_color = 'white',\n"
    "    double_buffer = true,\n"
    "    draw_borders = false,\n"
    "    draw_graph_borders = true,\n"
    "    draw_outline = false,\n"
    "    draw_shades = false,\n"
    "    extra_newline = false,\n"
    "    font = 'DejaVu Sans Mono:size=12',\n"
    "    gap_x = 60,\n"
    "    gap_y = 60,\n"
    "    minimum_height = 5,\n"
    "    minimum_width = 5,\n"
    "    net_avg_samples = 2,\n"
    "    no_buffers = true,\n"
    "    out_to_console = false,\n"
    "    out_to_ncurses = false,\n"
    "    out_to_stderr = false,\n"
    "    out_to_wayland = false,\n"
    "    out_to_x = true,\n"
    "    own_window = true,\n"
    "    own_window_class = 'Conky',\n"
    "    own_window_type = 'normal',\n"
    "    own_window_hints = 'undecorated,sticky,below,skip_taskbar,skip_pager',\n"
    "    show_graph_range = false,\n"
    "    show_graph_scale = false,\n"
    "    stippled_borders = 0,\n"
    "    update_interval = 1.0,\n"
    "    uppercase = false,\n"
    "    use_spacer = 'none',\n"
    "    use_xft = true,\n"
    "}\n"
    "\n"
    "-- Variables: https://conky.cc/variables\n"
    "conky.text = [[\n"
    "${color grey}Info:$color ${scroll 32 Conky $conky_version - $sysname $nodename $kernel $machine}\n"
    "$hr\n"
    "${color grey}Uptime:$color $uptime\n"
    "${color grey}Frequency (in MHz):$color $freq\n"
    "${color grey}Frequency (in GHz):$color $freq_g\n"
    "${color grey}RAM Usage:$color $mem/$memmax - $memperc% ${membar 4}\n"
    "${color grey}Swap Usage:$color $swap/$swapmax - $swapperc% ${swapbar 4}\n"
    "${color grey}CPU Usage:$color $cpu% ${cpubar 4}\n"
    "${color grey}Processes:$color $processes  ${color grey}Running:$color $running_processes\n"
    "$hr\n"
    "${color grey}File systems:\n"
    " / $color${fs_used /}/${fs_size /} ${fs_bar 6 /}\n"
    "${color grey}Networking:\n"
    "Up:$color ${upspeed} ${color grey} - Down:$color ${downspeed}\n"
    "$hr\n"
    "${color grey}Name              PID     CPU%   MEM%\n"
    "${color lightgrey} ${top name 1} ${top pid 1} ${top cpu 1} ${top mem 1}\n"
    "${color lightgrey} ${top name 2} ${top pid 2} ${top cpu 2} ${top mem 2}\n"
    "${color lightgrey} ${top name 3} ${top pid 3} ${top cpu 3} ${top mem 3}\n"
    "${color lightgrey} ${top name 4} ${top pid 4} ${top cpu 4} ${top mem 4}\n"
    "]]\n";
