/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// JKSKeystoreApplyConfiguration represents a declarative configuration of the JKSKeystore type for use
// with apply.
type JKSKeystoreApplyConfiguration struct {
	Create            *bool                                       `json:"create,omitempty"`
	Alias             *string                                     `json:"alias,omitempty"`
	PasswordSecretRef *metav1.SecretKeySelectorApplyConfiguration `json:"passwordSecretRef,omitempty"`
	Password          *string                                     `json:"password,omitempty"`
}

// JKSKeystoreApplyConfiguration constructs a declarative configuration of the JKSKeystore type for use with
// apply.
func JKSKeystore() *JKSKeystoreApplyConfiguration {
	return &JKSKeystoreApplyConfiguration{}
}

// WithCreate sets the Create field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Create field is set to the value of the last call.
func (b *JKSKeystoreApplyConfiguration) WithCreate(value bool) *JKSKeystoreApplyConfiguration {
	b.Create = &value
	return b
}

// WithAlias sets the Alias field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Alias field is set to the value of the last call.
func (b *JKSKeystoreApplyConfiguration) WithAlias(value string) *JKSKeystoreApplyConfiguration {
	b.Alias = &value
	return b
}

// WithPasswordSecretRef sets the PasswordSecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PasswordSecretRef field is set to the value of the last call.
func (b *JKSKeystoreApplyConfiguration) WithPasswordSecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *JKSKeystoreApplyConfiguration {
	b.PasswordSecretRef = value
	return b
}

// WithPassword sets the Password field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Password field is set to the value of the last call.
func (b *JKSKeystoreApplyConfiguration) WithPassword(value string) *JKSKeystoreApplyConfiguration {
	b.Password = &value
	return b
}
