/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	applyconfigurationsmetav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// CertificateSpecApplyConfiguration represents a declarative configuration of the CertificateSpec type for use
// with apply.
type CertificateSpecApplyConfiguration struct {
	Subject                 *X509SubjectApplyConfiguration                               `json:"subject,omitempty"`
	LiteralSubject          *string                                                      `json:"literalSubject,omitempty"`
	CommonName              *string                                                      `json:"commonName,omitempty"`
	Duration                *metav1.Duration                                             `json:"duration,omitempty"`
	RenewBefore             *metav1.Duration                                             `json:"renewBefore,omitempty"`
	RenewBeforePercentage   *int32                                                       `json:"renewBeforePercentage,omitempty"`
	DNSNames                []string                                                     `json:"dnsNames,omitempty"`
	IPAddresses             []string                                                     `json:"ipAddresses,omitempty"`
	URIs                    []string                                                     `json:"uris,omitempty"`
	OtherNames              []OtherNameApplyConfiguration                                `json:"otherNames,omitempty"`
	EmailAddresses          []string                                                     `json:"emailAddresses,omitempty"`
	SecretName              *string                                                      `json:"secretName,omitempty"`
	SecretTemplate          *CertificateSecretTemplateApplyConfiguration                 `json:"secretTemplate,omitempty"`
	Keystores               *CertificateKeystoresApplyConfiguration                      `json:"keystores,omitempty"`
	IssuerRef               *applyconfigurationsmetav1.IssuerReferenceApplyConfiguration `json:"issuerRef,omitempty"`
	IsCA                    *bool                                                        `json:"isCA,omitempty"`
	Usages                  []certmanagerv1.KeyUsage                                     `json:"usages,omitempty"`
	PrivateKey              *CertificatePrivateKeyApplyConfiguration                     `json:"privateKey,omitempty"`
	SignatureAlgorithm      *certmanagerv1.SignatureAlgorithm                            `json:"signatureAlgorithm,omitempty"`
	EncodeUsagesInRequest   *bool                                                        `json:"encodeUsagesInRequest,omitempty"`
	RevisionHistoryLimit    *int32                                                       `json:"revisionHistoryLimit,omitempty"`
	AdditionalOutputFormats []CertificateAdditionalOutputFormatApplyConfiguration        `json:"additionalOutputFormats,omitempty"`
	NameConstraints         *NameConstraintsApplyConfiguration                           `json:"nameConstraints,omitempty"`
}

// CertificateSpecApplyConfiguration constructs a declarative configuration of the CertificateSpec type for use with
// apply.
func CertificateSpec() *CertificateSpecApplyConfiguration {
	return &CertificateSpecApplyConfiguration{}
}

// WithSubject sets the Subject field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Subject field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithSubject(value *X509SubjectApplyConfiguration) *CertificateSpecApplyConfiguration {
	b.Subject = value
	return b
}

// WithLiteralSubject sets the LiteralSubject field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LiteralSubject field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithLiteralSubject(value string) *CertificateSpecApplyConfiguration {
	b.LiteralSubject = &value
	return b
}

// WithCommonName sets the CommonName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CommonName field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithCommonName(value string) *CertificateSpecApplyConfiguration {
	b.CommonName = &value
	return b
}

// WithDuration sets the Duration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Duration field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithDuration(value metav1.Duration) *CertificateSpecApplyConfiguration {
	b.Duration = &value
	return b
}

// WithRenewBefore sets the RenewBefore field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RenewBefore field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithRenewBefore(value metav1.Duration) *CertificateSpecApplyConfiguration {
	b.RenewBefore = &value
	return b
}

// WithRenewBeforePercentage sets the RenewBeforePercentage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RenewBeforePercentage field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithRenewBeforePercentage(value int32) *CertificateSpecApplyConfiguration {
	b.RenewBeforePercentage = &value
	return b
}

// WithDNSNames adds the given value to the DNSNames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DNSNames field.
func (b *CertificateSpecApplyConfiguration) WithDNSNames(values ...string) *CertificateSpecApplyConfiguration {
	for i := range values {
		b.DNSNames = append(b.DNSNames, values[i])
	}
	return b
}

// WithIPAddresses adds the given value to the IPAddresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IPAddresses field.
func (b *CertificateSpecApplyConfiguration) WithIPAddresses(values ...string) *CertificateSpecApplyConfiguration {
	for i := range values {
		b.IPAddresses = append(b.IPAddresses, values[i])
	}
	return b
}

// WithURIs adds the given value to the URIs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the URIs field.
func (b *CertificateSpecApplyConfiguration) WithURIs(values ...string) *CertificateSpecApplyConfiguration {
	for i := range values {
		b.URIs = append(b.URIs, values[i])
	}
	return b
}

// WithOtherNames adds the given value to the OtherNames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OtherNames field.
func (b *CertificateSpecApplyConfiguration) WithOtherNames(values ...*OtherNameApplyConfiguration) *CertificateSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOtherNames")
		}
		b.OtherNames = append(b.OtherNames, *values[i])
	}
	return b
}

// WithEmailAddresses adds the given value to the EmailAddresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EmailAddresses field.
func (b *CertificateSpecApplyConfiguration) WithEmailAddresses(values ...string) *CertificateSpecApplyConfiguration {
	for i := range values {
		b.EmailAddresses = append(b.EmailAddresses, values[i])
	}
	return b
}

// WithSecretName sets the SecretName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretName field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithSecretName(value string) *CertificateSpecApplyConfiguration {
	b.SecretName = &value
	return b
}

// WithSecretTemplate sets the SecretTemplate field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretTemplate field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithSecretTemplate(value *CertificateSecretTemplateApplyConfiguration) *CertificateSpecApplyConfiguration {
	b.SecretTemplate = value
	return b
}

// WithKeystores sets the Keystores field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Keystores field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithKeystores(value *CertificateKeystoresApplyConfiguration) *CertificateSpecApplyConfiguration {
	b.Keystores = value
	return b
}

// WithIssuerRef sets the IssuerRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IssuerRef field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithIssuerRef(value *applyconfigurationsmetav1.IssuerReferenceApplyConfiguration) *CertificateSpecApplyConfiguration {
	b.IssuerRef = value
	return b
}

// WithIsCA sets the IsCA field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IsCA field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithIsCA(value bool) *CertificateSpecApplyConfiguration {
	b.IsCA = &value
	return b
}

// WithUsages adds the given value to the Usages field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Usages field.
func (b *CertificateSpecApplyConfiguration) WithUsages(values ...certmanagerv1.KeyUsage) *CertificateSpecApplyConfiguration {
	for i := range values {
		b.Usages = append(b.Usages, values[i])
	}
	return b
}

// WithPrivateKey sets the PrivateKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PrivateKey field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithPrivateKey(value *CertificatePrivateKeyApplyConfiguration) *CertificateSpecApplyConfiguration {
	b.PrivateKey = value
	return b
}

// WithSignatureAlgorithm sets the SignatureAlgorithm field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignatureAlgorithm field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithSignatureAlgorithm(value certmanagerv1.SignatureAlgorithm) *CertificateSpecApplyConfiguration {
	b.SignatureAlgorithm = &value
	return b
}

// WithEncodeUsagesInRequest sets the EncodeUsagesInRequest field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EncodeUsagesInRequest field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithEncodeUsagesInRequest(value bool) *CertificateSpecApplyConfiguration {
	b.EncodeUsagesInRequest = &value
	return b
}

// WithRevisionHistoryLimit sets the RevisionHistoryLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RevisionHistoryLimit field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithRevisionHistoryLimit(value int32) *CertificateSpecApplyConfiguration {
	b.RevisionHistoryLimit = &value
	return b
}

// WithAdditionalOutputFormats adds the given value to the AdditionalOutputFormats field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AdditionalOutputFormats field.
func (b *CertificateSpecApplyConfiguration) WithAdditionalOutputFormats(values ...*CertificateAdditionalOutputFormatApplyConfiguration) *CertificateSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAdditionalOutputFormats")
		}
		b.AdditionalOutputFormats = append(b.AdditionalOutputFormats, *values[i])
	}
	return b
}

// WithNameConstraints sets the NameConstraints field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NameConstraints field is set to the value of the last call.
func (b *CertificateSpecApplyConfiguration) WithNameConstraints(value *NameConstraintsApplyConfiguration) *CertificateSpecApplyConfiguration {
	b.NameConstraints = value
	return b
}
