/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "cs-media-player-proxy.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__INT64 (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_Int64Func)
       (void *data1,
        gint64 arg_Position,
        void *data2);
  _GDbusCodegenMarshalVoid_Int64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_Int64Func)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_int64 (param_values + 1),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectInt64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint64 arg_Offset,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectInt64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectInt64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int64 (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringInt64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_TrackId,
        gint64 arg_Position,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringInt64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringInt64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_int64 (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_Uri,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.mpris.MediaPlayer2.Player
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CsMediaPlayer
 * @title: CsMediaPlayer
 * @short_description: Generated C code for the org.mpris.MediaPlayer2.Player D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface in C.
 */

enum
{
  CS__MEDIA_PLAYER_SEEKED,
};

static unsigned CS__MEDIA_PLAYER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.mpris.MediaPlayer2.Player ---- */

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_next =
{
  {
    -1,
    (gchar *) "Next",
    NULL,
    NULL,
    NULL
  },
  "handle-next",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_previous =
{
  {
    -1,
    (gchar *) "Previous",
    NULL,
    NULL,
    NULL
  },
  "handle-previous",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_play_pause =
{
  {
    -1,
    (gchar *) "PlayPause",
    NULL,
    NULL,
    NULL
  },
  "handle-play-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusArgInfo _cs_media_player_method_info_seek_IN_ARG_Offset =
{
  {
    -1,
    (gchar *) "Offset",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cs_media_player_method_info_seek_IN_ARG_pointers[] =
{
  &_cs_media_player_method_info_seek_IN_ARG_Offset.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_seek =
{
  {
    -1,
    (gchar *) "Seek",
    (GDBusArgInfo **) &_cs_media_player_method_info_seek_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-seek",
  FALSE
};

static const _ExtendedGDBusArgInfo _cs_media_player_method_info_set_position_IN_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _cs_media_player_method_info_set_position_IN_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cs_media_player_method_info_set_position_IN_ARG_pointers[] =
{
  &_cs_media_player_method_info_set_position_IN_ARG_TrackId.parent_struct,
  &_cs_media_player_method_info_set_position_IN_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_set_position =
{
  {
    -1,
    (gchar *) "SetPosition",
    (GDBusArgInfo **) &_cs_media_player_method_info_set_position_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-position",
  FALSE
};

static const _ExtendedGDBusArgInfo _cs_media_player_method_info_open_uri_IN_ARG_Uri =
{
  {
    -1,
    (gchar *) "Uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cs_media_player_method_info_open_uri_IN_ARG_pointers[] =
{
  &_cs_media_player_method_info_open_uri_IN_ARG_Uri.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _cs_media_player_method_info_open_uri =
{
  {
    -1,
    (gchar *) "OpenUri",
    (GDBusArgInfo **) &_cs_media_player_method_info_open_uri_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open-uri",
  FALSE
};

static const GDBusMethodInfo * const _cs_media_player_method_info_pointers[] =
{
  &_cs_media_player_method_info_next.parent_struct,
  &_cs_media_player_method_info_previous.parent_struct,
  &_cs_media_player_method_info_pause.parent_struct,
  &_cs_media_player_method_info_play_pause.parent_struct,
  &_cs_media_player_method_info_stop.parent_struct,
  &_cs_media_player_method_info_play.parent_struct,
  &_cs_media_player_method_info_seek.parent_struct,
  &_cs_media_player_method_info_set_position.parent_struct,
  &_cs_media_player_method_info_open_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _cs_media_player_signal_info_seeked_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _cs_media_player_signal_info_seeked_ARG_pointers[] =
{
  &_cs_media_player_signal_info_seeked_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _cs_media_player_signal_info_seeked =
{
  {
    -1,
    (gchar *) "Seeked",
    (GDBusArgInfo **) &_cs_media_player_signal_info_seeked_ARG_pointers,
    NULL
  },
  "seeked"
};

static const GDBusSignalInfo * const _cs_media_player_signal_info_pointers[] =
{
  &_cs_media_player_signal_info_seeked.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _cs_media_player_property_playback_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_playback_status_annotation_info_pointers[] =
{
  &_cs_media_player_property_playback_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_playback_status =
{
  {
    -1,
    (gchar *) "PlaybackStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_playback_status_annotation_info_pointers
  },
  "playback-status",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_loop_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo _cs_media_player_property_loop_status_annotation_info_1 =
{
  -1,
  (gchar *) "org.mpris.MediaPlayer2.property.optional",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_loop_status_annotation_info_pointers[] =
{
  &_cs_media_player_property_loop_status_annotation_info_0,
  &_cs_media_player_property_loop_status_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_loop_status =
{
  {
    -1,
    (gchar *) "LoopStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_loop_status_annotation_info_pointers
  },
  "loop-status",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_rate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_rate_annotation_info_pointers[] =
{
  &_cs_media_player_property_rate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_rate =
{
  {
    -1,
    (gchar *) "Rate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_rate_annotation_info_pointers
  },
  "rate",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_shuffle_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo _cs_media_player_property_shuffle_annotation_info_1 =
{
  -1,
  (gchar *) "org.mpris.MediaPlayer2.property.optional",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_shuffle_annotation_info_pointers[] =
{
  &_cs_media_player_property_shuffle_annotation_info_0,
  &_cs_media_player_property_shuffle_annotation_info_1,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_shuffle =
{
  {
    -1,
    (gchar *) "Shuffle",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_shuffle_annotation_info_pointers
  },
  "shuffle",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_metadata_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_metadata_annotation_info_pointers[] =
{
  &_cs_media_player_property_metadata_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_metadata_annotation_info_pointers
  },
  "metadata",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_volume_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_volume_annotation_info_pointers[] =
{
  &_cs_media_player_property_volume_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_volume_annotation_info_pointers
  },
  "volume",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_position_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_position_annotation_info_pointers[] =
{
  &_cs_media_player_property_position_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_position_annotation_info_pointers
  },
  "position",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _cs_media_player_property_minimum_rate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_minimum_rate_annotation_info_pointers[] =
{
  &_cs_media_player_property_minimum_rate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_minimum_rate =
{
  {
    -1,
    (gchar *) "MinimumRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_minimum_rate_annotation_info_pointers
  },
  "minimum-rate",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_maximum_rate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_maximum_rate_annotation_info_pointers[] =
{
  &_cs_media_player_property_maximum_rate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_maximum_rate =
{
  {
    -1,
    (gchar *) "MaximumRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_maximum_rate_annotation_info_pointers
  },
  "maximum-rate",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_can_go_next_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_can_go_next_annotation_info_pointers[] =
{
  &_cs_media_player_property_can_go_next_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_can_go_next =
{
  {
    -1,
    (gchar *) "CanGoNext",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_can_go_next_annotation_info_pointers
  },
  "can-go-next",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_can_go_previous_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_can_go_previous_annotation_info_pointers[] =
{
  &_cs_media_player_property_can_go_previous_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_can_go_previous =
{
  {
    -1,
    (gchar *) "CanGoPrevious",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_can_go_previous_annotation_info_pointers
  },
  "can-go-previous",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_can_play_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_can_play_annotation_info_pointers[] =
{
  &_cs_media_player_property_can_play_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_can_play =
{
  {
    -1,
    (gchar *) "CanPlay",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_can_play_annotation_info_pointers
  },
  "can-play",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_can_pause_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_can_pause_annotation_info_pointers[] =
{
  &_cs_media_player_property_can_pause_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_can_pause =
{
  {
    -1,
    (gchar *) "CanPause",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_can_pause_annotation_info_pointers
  },
  "can-pause",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_can_seek_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_can_seek_annotation_info_pointers[] =
{
  &_cs_media_player_property_can_seek_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_can_seek =
{
  {
    -1,
    (gchar *) "CanSeek",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_can_seek_annotation_info_pointers
  },
  "can-seek",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _cs_media_player_property_can_control_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _cs_media_player_property_can_control_annotation_info_pointers[] =
{
  &_cs_media_player_property_can_control_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _cs_media_player_property_info_can_control =
{
  {
    -1,
    (gchar *) "CanControl",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_cs_media_player_property_can_control_annotation_info_pointers
  },
  "can-control",
  FALSE,
  FALSE
};

static const GDBusPropertyInfo * const _cs_media_player_property_info_pointers[] =
{
  &_cs_media_player_property_info_playback_status.parent_struct,
  &_cs_media_player_property_info_loop_status.parent_struct,
  &_cs_media_player_property_info_rate.parent_struct,
  &_cs_media_player_property_info_shuffle.parent_struct,
  &_cs_media_player_property_info_metadata.parent_struct,
  &_cs_media_player_property_info_volume.parent_struct,
  &_cs_media_player_property_info_position.parent_struct,
  &_cs_media_player_property_info_minimum_rate.parent_struct,
  &_cs_media_player_property_info_maximum_rate.parent_struct,
  &_cs_media_player_property_info_can_go_next.parent_struct,
  &_cs_media_player_property_info_can_go_previous.parent_struct,
  &_cs_media_player_property_info_can_play.parent_struct,
  &_cs_media_player_property_info_can_pause.parent_struct,
  &_cs_media_player_property_info_can_seek.parent_struct,
  &_cs_media_player_property_info_can_control.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _cs_media_player_interface_info =
{
  {
    -1,
    (gchar *) "org.mpris.MediaPlayer2.Player",
    (GDBusMethodInfo **) &_cs_media_player_method_info_pointers,
    (GDBusSignalInfo **) &_cs_media_player_signal_info_pointers,
    (GDBusPropertyInfo **) &_cs_media_player_property_info_pointers,
    NULL
  },
  "media-player",
};


/**
 * cs_media_player_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
cs_media_player_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_cs_media_player_interface_info.parent_struct;
}

/**
 * cs_media_player_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CsMediaPlayer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
cs_media_player_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "playback-status");
  g_object_class_override_property (klass, property_id_begin++, "loop-status");
  g_object_class_override_property (klass, property_id_begin++, "rate");
  g_object_class_override_property (klass, property_id_begin++, "shuffle");
  g_object_class_override_property (klass, property_id_begin++, "metadata");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  g_object_class_override_property (klass, property_id_begin++, "position");
  g_object_class_override_property (klass, property_id_begin++, "minimum-rate");
  g_object_class_override_property (klass, property_id_begin++, "maximum-rate");
  g_object_class_override_property (klass, property_id_begin++, "can-go-next");
  g_object_class_override_property (klass, property_id_begin++, "can-go-previous");
  g_object_class_override_property (klass, property_id_begin++, "can-play");
  g_object_class_override_property (klass, property_id_begin++, "can-pause");
  g_object_class_override_property (klass, property_id_begin++, "can-seek");
  g_object_class_override_property (klass, property_id_begin++, "can-control");
  return property_id_begin - 1;
}


inline static void
cs_media_player_signal_marshal_seeked (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_next (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_previous (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_play_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_play (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_seek (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_set_position (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
cs_media_player_method_marshal_open_uri (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CsMediaPlayer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

/**
 * CsMediaPlayerIface:
 * @parent_iface: The parent interface.
 * @handle_next: Handler for the #CsMediaPlayer::handle-next signal.
 * @handle_open_uri: Handler for the #CsMediaPlayer::handle-open-uri signal.
 * @handle_pause: Handler for the #CsMediaPlayer::handle-pause signal.
 * @handle_play: Handler for the #CsMediaPlayer::handle-play signal.
 * @handle_play_pause: Handler for the #CsMediaPlayer::handle-play-pause signal.
 * @handle_previous: Handler for the #CsMediaPlayer::handle-previous signal.
 * @handle_seek: Handler for the #CsMediaPlayer::handle-seek signal.
 * @handle_set_position: Handler for the #CsMediaPlayer::handle-set-position signal.
 * @handle_stop: Handler for the #CsMediaPlayer::handle-stop signal.
 * @get_can_control: Getter for the #CsMediaPlayer:can-control property.
 * @get_can_go_next: Getter for the #CsMediaPlayer:can-go-next property.
 * @get_can_go_previous: Getter for the #CsMediaPlayer:can-go-previous property.
 * @get_can_pause: Getter for the #CsMediaPlayer:can-pause property.
 * @get_can_play: Getter for the #CsMediaPlayer:can-play property.
 * @get_can_seek: Getter for the #CsMediaPlayer:can-seek property.
 * @get_loop_status: Getter for the #CsMediaPlayer:loop-status property.
 * @get_maximum_rate: Getter for the #CsMediaPlayer:maximum-rate property.
 * @get_metadata: Getter for the #CsMediaPlayer:metadata property.
 * @get_minimum_rate: Getter for the #CsMediaPlayer:minimum-rate property.
 * @get_playback_status: Getter for the #CsMediaPlayer:playback-status property.
 * @get_position: Getter for the #CsMediaPlayer:position property.
 * @get_rate: Getter for the #CsMediaPlayer:rate property.
 * @get_shuffle: Getter for the #CsMediaPlayer:shuffle property.
 * @get_volume: Getter for the #CsMediaPlayer:volume property.
 * @seeked: Handler for the #CsMediaPlayer::seeked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

typedef CsMediaPlayerIface CsMediaPlayerInterface;
G_DEFINE_INTERFACE (CsMediaPlayer, cs_media_player, G_TYPE_OBJECT)

static void
cs_media_player_default_init (CsMediaPlayerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CsMediaPlayer::handle-next:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_next() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-next",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_next),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_next,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsMediaPlayer::handle-previous:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_previous() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-previous",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_previous),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_previous,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsMediaPlayer::handle-pause:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsMediaPlayer::handle-play-pause:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_play_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_play_pause),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_play_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsMediaPlayer::handle-stop:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsMediaPlayer::handle-play:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_play,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CsMediaPlayer::handle-seek:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Offset: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_seek() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-seek",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_seek),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_seek,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64);

  /**
   * CsMediaPlayer::handle-set-position:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackId: Argument passed by remote caller.
   * @arg_Position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_set_position() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-position",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_set_position),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_set_position,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT64);

  /**
   * CsMediaPlayer::handle-open-uri:
   * @object: A #CsMediaPlayer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Uri: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call cs_media_player_complete_open_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CsMediaPlayerIface, handle_open_uri),
    g_signal_accumulator_true_handled,
    NULL,
      cs_media_player_method_marshal_open_uri,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * CsMediaPlayer::seeked:
   * @object: A #CsMediaPlayer.
   * @arg_Position: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CS__MEDIA_PLAYER_SIGNALS[CS__MEDIA_PLAYER_SEEKED] =
    g_signal_new ("seeked",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CsMediaPlayerIface, seeked),
      NULL,
      NULL,
      cs_media_player_signal_marshal_seeked,
      G_TYPE_NONE,
      1, G_TYPE_INT64);

  /* GObject properties for D-Bus properties: */
  /**
   * CsMediaPlayer:playback-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("playback-status", "PlaybackStatus", "PlaybackStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:loop-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("loop-status", "LoopStatus", "LoopStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("rate", "Rate", "Rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:shuffle:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("shuffle", "Shuffle", "Shuffle", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:metadata:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("metadata", "Metadata", "Metadata", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("volume", "Volume", "Volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("position", "Position", "Position", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:minimum-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("minimum-rate", "MinimumRate", "MinimumRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:maximum-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("maximum-rate", "MaximumRate", "MaximumRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:can-go-next:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-next", "CanGoNext", "CanGoNext", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:can-go-previous:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-previous", "CanGoPrevious", "CanGoPrevious", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:can-play:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-play", "CanPlay", "CanPlay", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:can-pause:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-pause", "CanPause", "CanPause", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:can-seek:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-seek", "CanSeek", "CanSeek", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CsMediaPlayer:can-control:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-control", "CanControl", "CanControl", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * cs_media_player_get_playback_status: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cs_media_player_dup_playback_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cs_media_player_get_playback_status (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), NULL);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_playback_status (object);
}

/**
 * cs_media_player_dup_playback_status: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cs_media_player_dup_playback_status (CsMediaPlayer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "playback-status", &value, NULL);
  return value;
}

/**
 * cs_media_player_set_playback_status: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_playback_status (CsMediaPlayer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "playback-status", value, NULL);
}

/**
 * cs_media_player_get_loop_status: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cs_media_player_dup_loop_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
cs_media_player_get_loop_status (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), NULL);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_loop_status (object);
}

/**
 * cs_media_player_dup_loop_status: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
cs_media_player_dup_loop_status (CsMediaPlayer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "loop-status", &value, NULL);
  return value;
}

/**
 * cs_media_player_set_loop_status: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
cs_media_player_set_loop_status (CsMediaPlayer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "loop-status", value, NULL);
}

/**
 * cs_media_player_get_rate: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
cs_media_player_get_rate (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), 0.0);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_rate (object);
}

/**
 * cs_media_player_set_rate: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
cs_media_player_set_rate (CsMediaPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "rate", value, NULL);
}

/**
 * cs_media_player_get_shuffle: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_shuffle (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_shuffle (object);
}

/**
 * cs_media_player_set_shuffle: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
cs_media_player_set_shuffle (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "shuffle", value, NULL);
}

/**
 * cs_media_player_get_metadata: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use cs_media_player_dup_metadata() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
cs_media_player_get_metadata (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), NULL);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_metadata (object);
}

/**
 * cs_media_player_dup_metadata: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
cs_media_player_dup_metadata (CsMediaPlayer *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "metadata", &value, NULL);
  return value;
}

/**
 * cs_media_player_set_metadata: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_metadata (CsMediaPlayer *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "metadata", value, NULL);
}

/**
 * cs_media_player_get_volume: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
cs_media_player_get_volume (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), 0.0);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_volume (object);
}

/**
 * cs_media_player_set_volume: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
cs_media_player_set_volume (CsMediaPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * cs_media_player_get_position: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
cs_media_player_get_position (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), 0);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_position (object);
}

/**
 * cs_media_player_set_position: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_position (CsMediaPlayer *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "position", value, NULL);
}

/**
 * cs_media_player_get_minimum_rate: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
cs_media_player_get_minimum_rate (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), 0.0);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_minimum_rate (object);
}

/**
 * cs_media_player_set_minimum_rate: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_minimum_rate (CsMediaPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "minimum-rate", value, NULL);
}

/**
 * cs_media_player_get_maximum_rate: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
cs_media_player_get_maximum_rate (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), 0.0);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_maximum_rate (object);
}

/**
 * cs_media_player_set_maximum_rate: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_maximum_rate (CsMediaPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "maximum-rate", value, NULL);
}

/**
 * cs_media_player_get_can_go_next: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_can_go_next (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_can_go_next (object);
}

/**
 * cs_media_player_set_can_go_next: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_can_go_next (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-next", value, NULL);
}

/**
 * cs_media_player_get_can_go_previous: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_can_go_previous (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_can_go_previous (object);
}

/**
 * cs_media_player_set_can_go_previous: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_can_go_previous (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-previous", value, NULL);
}

/**
 * cs_media_player_get_can_play: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_can_play (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_can_play (object);
}

/**
 * cs_media_player_set_can_play: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_can_play (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-play", value, NULL);
}

/**
 * cs_media_player_get_can_pause: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_can_pause (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_can_pause (object);
}

/**
 * cs_media_player_set_can_pause: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_can_pause (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-pause", value, NULL);
}

/**
 * cs_media_player_get_can_seek: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_can_seek (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_can_seek (object);
}

/**
 * cs_media_player_set_can_seek: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_can_seek (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-seek", value, NULL);
}

/**
 * cs_media_player_get_can_control: (skip)
 * @object: A #CsMediaPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
cs_media_player_get_can_control (CsMediaPlayer *object)
{
  g_return_val_if_fail (CS_IS_MEDIA_PLAYER (object), FALSE);

  return CS_MEDIA_PLAYER_GET_IFACE (object)->get_can_control (object);
}

/**
 * cs_media_player_set_can_control: (skip)
 * @object: A #CsMediaPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
cs_media_player_set_can_control (CsMediaPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-control", value, NULL);
}

/**
 * cs_media_player_emit_seeked:
 * @object: A #CsMediaPlayer.
 * @arg_Position: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> D-Bus signal.
 */
void
cs_media_player_emit_seeked (
    CsMediaPlayer *object,
    gint64 arg_Position)
{
  g_signal_emit (object, CS__MEDIA_PLAYER_SIGNALS[CS__MEDIA_PLAYER_SEEKED], 0, arg_Position);
}

/**
 * cs_media_player_call_next:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_next_finish() to get the result of the operation.
 *
 * See cs_media_player_call_next_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_next (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_next_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_next().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_next().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_next_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_next_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_next() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_next_sync (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_previous:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_previous_finish() to get the result of the operation.
 *
 * See cs_media_player_call_previous_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_previous (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_previous_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_previous().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_previous().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_previous_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_previous_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_previous() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_previous_sync (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_pause:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_pause_finish() to get the result of the operation.
 *
 * See cs_media_player_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_pause (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_pause_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_pause_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_pause_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_pause_sync (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_play_pause:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_play_pause_finish() to get the result of the operation.
 *
 * See cs_media_player_call_play_pause_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_play_pause (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_play_pause_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_play_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_play_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_play_pause_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_play_pause_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_play_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_play_pause_sync (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_stop:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_stop_finish() to get the result of the operation.
 *
 * See cs_media_player_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_stop (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_stop_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_stop_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_stop_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_stop_sync (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_play:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_play_finish() to get the result of the operation.
 *
 * See cs_media_player_call_play_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_play (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_play_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_play_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_play_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_play_sync (
    CsMediaPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_seek:
 * @proxy: A #CsMediaPlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_seek_finish() to get the result of the operation.
 *
 * See cs_media_player_call_seek_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_seek (
    CsMediaPlayer *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_seek_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_seek().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_seek().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_seek_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_seek_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_seek() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_seek_sync (
    CsMediaPlayer *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_set_position:
 * @proxy: A #CsMediaPlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_set_position_finish() to get the result of the operation.
 *
 * See cs_media_player_call_set_position_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_set_position (
    CsMediaPlayer *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_set_position_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_set_position().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_set_position().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_set_position_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_set_position_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_set_position() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_set_position_sync (
    CsMediaPlayer *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_open_uri:
 * @proxy: A #CsMediaPlayerProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_call_open_uri_finish() to get the result of the operation.
 *
 * See cs_media_player_call_open_uri_sync() for the synchronous, blocking version of this method.
 */
void
cs_media_player_call_open_uri (
    CsMediaPlayer *proxy,
    const gchar *arg_Uri,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenUri",
    g_variant_new ("(s)",
                   arg_Uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * cs_media_player_call_open_uri_finish:
 * @proxy: A #CsMediaPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_call_open_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with cs_media_player_call_open_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_open_uri_finish (
    CsMediaPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_call_open_uri_sync:
 * @proxy: A #CsMediaPlayerProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_call_open_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
cs_media_player_call_open_uri_sync (
    CsMediaPlayer *proxy,
    const gchar *arg_Uri,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenUri",
    g_variant_new ("(s)",
                   arg_Uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * cs_media_player_complete_next:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_next (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_previous:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_previous (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_pause:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_pause (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_play_pause:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_play_pause (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_stop:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_stop (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_play:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_play (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_seek:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_seek (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_set_position:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_set_position (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * cs_media_player_complete_open_uri:
 * @object: A #CsMediaPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
cs_media_player_complete_open_uri (
    CsMediaPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CsMediaPlayerProxy:
 *
 * The #CsMediaPlayerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CsMediaPlayerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CsMediaPlayerProxy.
 */

struct _CsMediaPlayerProxyPrivate
{
  GData *qdata;
};

static void cs_media_player_proxy_iface_init (CsMediaPlayerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CsMediaPlayerProxy, cs_media_player_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CsMediaPlayerProxy)
                         G_IMPLEMENT_INTERFACE (CS_TYPE_MEDIA_PLAYER, cs_media_player_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CsMediaPlayerProxy, cs_media_player_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CS_TYPE_MEDIA_PLAYER, cs_media_player_proxy_iface_init))

#endif
static void
cs_media_player_proxy_finalize (GObject *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (cs_media_player_proxy_parent_class)->finalize (object);
}

static void
cs_media_player_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _cs_media_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
cs_media_player_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.mpris.MediaPlayer2.Player: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
cs_media_player_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _cs_media_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.mpris.MediaPlayer2.Player", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) cs_media_player_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
cs_media_player_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_cs_media_player_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CS_TYPE_MEDIA_PLAYER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CS_TYPE_MEDIA_PLAYER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
cs_media_player_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_media_player_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_media_player_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
cs_media_player_proxy_get_playback_status (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PlaybackStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
cs_media_player_proxy_get_loop_status (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoopStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
cs_media_player_proxy_get_rate (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Rate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_shuffle (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Shuffle");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
cs_media_player_proxy_get_metadata (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metadata");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gdouble 
cs_media_player_proxy_get_volume (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
cs_media_player_proxy_get_position (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Position");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
cs_media_player_proxy_get_minimum_rate (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MinimumRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
cs_media_player_proxy_get_maximum_rate (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MaximumRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_can_go_next (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoNext");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_can_go_previous (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoPrevious");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_can_play (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPlay");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_can_pause (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPause");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_can_seek (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanSeek");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
cs_media_player_proxy_get_can_control (CsMediaPlayer *object)
{
  CsMediaPlayerProxy *proxy = CS_MEDIA_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanControl");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
cs_media_player_proxy_init (CsMediaPlayerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = cs_media_player_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CS_TYPE_MEDIA_PLAYER_PROXY, CsMediaPlayerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), cs_media_player_interface_info ());
}

static void
cs_media_player_proxy_class_init (CsMediaPlayerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = cs_media_player_proxy_finalize;
  gobject_class->get_property = cs_media_player_proxy_get_property;
  gobject_class->set_property = cs_media_player_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = cs_media_player_proxy_g_signal;
  proxy_class->g_properties_changed = cs_media_player_proxy_g_properties_changed;

  cs_media_player_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CsMediaPlayerProxyPrivate));
#endif
}

static void
cs_media_player_proxy_iface_init (CsMediaPlayerIface *iface)
{
  iface->get_playback_status = cs_media_player_proxy_get_playback_status;
  iface->get_loop_status = cs_media_player_proxy_get_loop_status;
  iface->get_rate = cs_media_player_proxy_get_rate;
  iface->get_shuffle = cs_media_player_proxy_get_shuffle;
  iface->get_metadata = cs_media_player_proxy_get_metadata;
  iface->get_volume = cs_media_player_proxy_get_volume;
  iface->get_position = cs_media_player_proxy_get_position;
  iface->get_minimum_rate = cs_media_player_proxy_get_minimum_rate;
  iface->get_maximum_rate = cs_media_player_proxy_get_maximum_rate;
  iface->get_can_go_next = cs_media_player_proxy_get_can_go_next;
  iface->get_can_go_previous = cs_media_player_proxy_get_can_go_previous;
  iface->get_can_play = cs_media_player_proxy_get_can_play;
  iface->get_can_pause = cs_media_player_proxy_get_can_pause;
  iface->get_can_seek = cs_media_player_proxy_get_can_seek;
  iface->get_can_control = cs_media_player_proxy_get_can_control;
}

/**
 * cs_media_player_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_proxy_new_finish() to get the result of the operation.
 *
 * See cs_media_player_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
cs_media_player_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CS_TYPE_MEDIA_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * cs_media_player_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cs_media_player_proxy_new().
 *
 * Returns: (transfer full) (type CsMediaPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
CsMediaPlayer *
cs_media_player_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CS_MEDIA_PLAYER (ret);
  else
    return NULL;
}

/**
 * cs_media_player_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CsMediaPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
CsMediaPlayer *
cs_media_player_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CS_TYPE_MEDIA_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return CS_MEDIA_PLAYER (ret);
  else
    return NULL;
}


/**
 * cs_media_player_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like cs_media_player_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call cs_media_player_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See cs_media_player_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
cs_media_player_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CS_TYPE_MEDIA_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * cs_media_player_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to cs_media_player_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with cs_media_player_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CsMediaPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
CsMediaPlayer *
cs_media_player_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CS_MEDIA_PLAYER (ret);
  else
    return NULL;
}

/**
 * cs_media_player_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like cs_media_player_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See cs_media_player_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CsMediaPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
CsMediaPlayer *
cs_media_player_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CS_TYPE_MEDIA_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return CS_MEDIA_PLAYER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CsMediaPlayerSkeleton:
 *
 * The #CsMediaPlayerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CsMediaPlayerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CsMediaPlayerSkeleton.
 */

struct _CsMediaPlayerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_cs_media_player_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CS_TYPE_MEDIA_PLAYER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CS_TYPE_MEDIA_PLAYER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_cs_media_player_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_media_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_cs_media_player_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_cs_media_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _cs_media_player_skeleton_vtable =
{
  _cs_media_player_skeleton_handle_method_call,
  _cs_media_player_skeleton_handle_get_property,
  _cs_media_player_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
cs_media_player_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return cs_media_player_interface_info ();
}

static GDBusInterfaceVTable *
cs_media_player_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_cs_media_player_skeleton_vtable;
}

static GVariant *
cs_media_player_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_cs_media_player_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _cs_media_player_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _cs_media_player_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _cs_media_player_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _cs_media_player_emit_changed (gpointer user_data);

static void
cs_media_player_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _cs_media_player_emit_changed (skeleton);
}

static void
_cs_media_player_on_signal_seeked (
    CsMediaPlayer *object,
    gint64 arg_Position)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(x)",
                   arg_Position));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", "Seeked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void cs_media_player_skeleton_iface_init (CsMediaPlayerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CsMediaPlayerSkeleton, cs_media_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CsMediaPlayerSkeleton)
                         G_IMPLEMENT_INTERFACE (CS_TYPE_MEDIA_PLAYER, cs_media_player_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CsMediaPlayerSkeleton, cs_media_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CS_TYPE_MEDIA_PLAYER, cs_media_player_skeleton_iface_init))

#endif
static void
cs_media_player_skeleton_finalize (GObject *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  guint n;
  for (n = 0; n < 15; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (cs_media_player_skeleton_parent_class)->finalize (object);
}

static void
cs_media_player_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_cs_media_player_emit_changed (gpointer user_data)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2.Player",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_cs_media_player_schedule_emit_changed (CsMediaPlayerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
cs_media_player_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _cs_media_player_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _cs_media_player_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
cs_media_player_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _cs_media_player_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _cs_media_player_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
cs_media_player_skeleton_init (CsMediaPlayerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = cs_media_player_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CS_TYPE_MEDIA_PLAYER_SKELETON, CsMediaPlayerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 15);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_BOOLEAN);
}

static const gchar *
cs_media_player_skeleton_get_playback_status (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
cs_media_player_skeleton_get_loop_status (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
cs_media_player_skeleton_get_rate (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_shuffle (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
cs_media_player_skeleton_get_metadata (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
cs_media_player_skeleton_get_volume (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
cs_media_player_skeleton_get_position (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int64 (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
cs_media_player_skeleton_get_minimum_rate (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
cs_media_player_skeleton_get_maximum_rate (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_can_go_next (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_can_go_previous (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_can_play (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_can_pause (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_can_seek (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
cs_media_player_skeleton_get_can_control (CsMediaPlayer *object)
{
  CsMediaPlayerSkeleton *skeleton = CS_MEDIA_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
cs_media_player_skeleton_class_init (CsMediaPlayerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = cs_media_player_skeleton_finalize;
  gobject_class->get_property = cs_media_player_skeleton_get_property;
  gobject_class->set_property = cs_media_player_skeleton_set_property;
  gobject_class->notify       = cs_media_player_skeleton_notify;


  cs_media_player_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = cs_media_player_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = cs_media_player_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = cs_media_player_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = cs_media_player_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CsMediaPlayerSkeletonPrivate));
#endif
}

static void
cs_media_player_skeleton_iface_init (CsMediaPlayerIface *iface)
{
  iface->seeked = _cs_media_player_on_signal_seeked;
  iface->get_playback_status = cs_media_player_skeleton_get_playback_status;
  iface->get_loop_status = cs_media_player_skeleton_get_loop_status;
  iface->get_rate = cs_media_player_skeleton_get_rate;
  iface->get_shuffle = cs_media_player_skeleton_get_shuffle;
  iface->get_metadata = cs_media_player_skeleton_get_metadata;
  iface->get_volume = cs_media_player_skeleton_get_volume;
  iface->get_position = cs_media_player_skeleton_get_position;
  iface->get_minimum_rate = cs_media_player_skeleton_get_minimum_rate;
  iface->get_maximum_rate = cs_media_player_skeleton_get_maximum_rate;
  iface->get_can_go_next = cs_media_player_skeleton_get_can_go_next;
  iface->get_can_go_previous = cs_media_player_skeleton_get_can_go_previous;
  iface->get_can_play = cs_media_player_skeleton_get_can_play;
  iface->get_can_pause = cs_media_player_skeleton_get_can_pause;
  iface->get_can_seek = cs_media_player_skeleton_get_can_seek;
  iface->get_can_control = cs_media_player_skeleton_get_can_control;
}

/**
 * cs_media_player_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 *
 * Returns: (transfer full) (type CsMediaPlayerSkeleton): The skeleton object.
 */
CsMediaPlayer *
cs_media_player_skeleton_new (void)
{
  return CS_MEDIA_PLAYER (g_object_new (CS_TYPE_MEDIA_PLAYER_SKELETON, NULL));
}

