/* waylandclient.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from waylandclient.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The underlying WaylandClient does not appear to be fully thread-safe and either
 * repeated calls very quickly, or calls within the same process where the
 * reference was not release will result in mutex-locks causing and executable to spin
 * indefinitely.
 *
 * Our use in various executables is limited so we can initialise variable we use within
 * a singleton to make things thread-safe.
*/

#include "budgie-waylandclient.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>

#define BUDGIE_WAYLAND_CLIENT_MAX_INIT_ATTEMPTS 50
#define BUDGIE_WAYLAND_CLIENT_SMOOTH_MS ((guint) 500)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_WAYLAND_CLIENT_0_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_SCALE_PROPERTY,
	BUDGIE_WAYLAND_CLIENT_NUM_PROPERTIES
};
static GParamSpec* budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_WAYLAND_CLIENT_INITIALIZED_SIGNAL,
	BUDGIE_WAYLAND_CLIENT_INITIALIZATION_FAILED_SIGNAL,
	BUDGIE_WAYLAND_CLIENT_NUM_SIGNALS
};
static guint budgie_wayland_client_signals[BUDGIE_WAYLAND_CLIENT_NUM_SIGNALS] = {0};

struct _BudgieWaylandClientPrivate {
	XfwScreen* screen;
	XfwMonitor* primary_monitor;
	GdkRectangle _monitor_res;
	GdkMonitor* _gdk_monitor;
	gint _scale;
	gboolean _is_valid;
	guint monitor_update_timeout;
	guint smooth_timeout;
	gint initialization_attempts;
};

static gint BudgieWaylandClient_private_offset;
static gpointer budgie_wayland_client_parent_class = NULL;

static gboolean ___lambda4_ (BudgieWaylandClient* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void budgie_wayland_client_on_monitors_changed_smoothed (BudgieWaylandClient* self);
static void _budgie_wayland_client_on_monitors_changed_smoothed_libxfce4windowing_screen_monitors_changed (XfwScreen* _sender,
                                                                                                    gpointer self);
static void budgie_wayland_client_initialize_monitor_info (BudgieWaylandClient* self);
static gboolean __lambda5_ (BudgieWaylandClient* self);
static void budgie_wayland_client_on_monitors_changed (BudgieWaylandClient* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean budgie_wayland_client_poll_for_monitor (BudgieWaylandClient* self);
static gboolean _budgie_wayland_client_poll_for_monitor_gsource_func (gpointer self);
static void budgie_wayland_client_update_monitor_data (BudgieWaylandClient* self);
static gboolean budgie_wayland_client_validate_monitor_reference (BudgieWaylandClient* self);
static void budgie_wayland_client_refresh_monitor_info (BudgieWaylandClient* self);
static GObject * budgie_wayland_client_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void budgie_wayland_client_finalize (GObject * obj);
static GType budgie_wayland_client_get_type_once (void);
static void _vala_budgie_wayland_client_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
budgie_wayland_client_get_instance_private (BudgieWaylandClient* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieWaylandClient_private_offset);
}

gboolean
budgie_wayland_client_is_initialised (BudgieWaylandClient* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_is_valid) {
		XfwMonitor* _tmp2_;
		_tmp2_ = self->priv->primary_monitor;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkMonitor* _tmp3_;
		_tmp3_ = self->priv->_gdk_monitor;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda4_ (BudgieWaylandClient* self)
{
	gboolean result;
	g_signal_emit (self, budgie_wayland_client_signals[BUDGIE_WAYLAND_CLIENT_INITIALIZATION_FAILED_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((BudgieWaylandClient*) self);
	return result;
}

static void
_budgie_wayland_client_on_monitors_changed_smoothed_libxfce4windowing_screen_monitors_changed (XfwScreen* _sender,
                                                                                               gpointer self)
{
	budgie_wayland_client_on_monitors_changed_smoothed ((BudgieWaylandClient*) self);
}

BudgieWaylandClient*
budgie_wayland_client_construct (GType object_type)
{
	BudgieWaylandClient * self = NULL;
	XfwMonitor* _tmp0_;
	XfwScreen* _tmp1_;
	XfwScreen* _tmp2_;
	XfwScreen* _tmp3_;
	self = (BudgieWaylandClient*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->primary_monitor;
	if (_tmp0_ != NULL) {
		return self;
	}
	_tmp1_ = xfw_screen_get_default ();
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp1_;
	_tmp2_ = self->priv->screen;
	if (_tmp2_ == NULL) {
		g_critical ("waylandclient.vala:82: Failed to get default Xfw.Screen");
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		return self;
	}
	_tmp3_ = self->priv->screen;
	g_signal_connect_object (_tmp3_, "monitors-changed", (GCallback) _budgie_wayland_client_on_monitors_changed_smoothed_libxfce4windowing_screen_monitors_changed, self, 0);
	budgie_wayland_client_initialize_monitor_info (self);
	return self;
}

BudgieWaylandClient*
budgie_wayland_client_new (void)
{
	return budgie_wayland_client_construct (BUDGIE_TYPE_WAYLAND_CLIENT);
}

static gboolean
__lambda5_ (BudgieWaylandClient* self)
{
	gboolean result;
	self->priv->smooth_timeout = (guint) 0;
	g_debug ("waylandclient.vala:107: Monitor changes settled, updating...");
	budgie_wayland_client_on_monitors_changed (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((BudgieWaylandClient*) self);
	return result;
}

static void
budgie_wayland_client_on_monitors_changed_smoothed (BudgieWaylandClient* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_valid = FALSE;
	if (self->priv->smooth_timeout != ((guint) 0)) {
		g_source_remove (self->priv->smooth_timeout);
	}
	self->priv->smooth_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, BUDGIE_WAYLAND_CLIENT_SMOOTH_MS, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
_budgie_wayland_client_poll_for_monitor_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_wayland_client_poll_for_monitor ((BudgieWaylandClient*) self);
	return result;
}

static void
budgie_wayland_client_initialize_monitor_info (BudgieWaylandClient* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->monitor_update_timeout != ((guint) 0)) {
		g_source_remove (self->priv->monitor_update_timeout);
		self->priv->monitor_update_timeout = (guint) 0;
	}
	self->priv->initialization_attempts = 0;
	self->priv->monitor_update_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _budgie_wayland_client_poll_for_monitor_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
budgie_wayland_client_poll_for_monitor (BudgieWaylandClient* self)
{
	gint _tmp0_;
	XfwScreen* _tmp1_;
	XfwMonitor* _tmp2_;
	XfwMonitor* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->initialization_attempts;
	self->priv->initialization_attempts = _tmp0_ + 1;
	_tmp1_ = self->priv->screen;
	_tmp2_ = xfw_screen_get_primary_monitor (_tmp1_);
	self->priv->primary_monitor = _tmp2_;
	_tmp3_ = self->priv->primary_monitor;
	if (_tmp3_ != NULL) {
		budgie_wayland_client_update_monitor_data (self);
		self->priv->monitor_update_timeout = (guint) 0;
		if (self->priv->_is_valid) {
			g_debug ("waylandclient.vala:142: WaylandClient initialized successfully");
			g_signal_emit (self, budgie_wayland_client_signals[BUDGIE_WAYLAND_CLIENT_INITIALIZED_SIGNAL], 0);
		}
		result = FALSE;
		return result;
	}
	if (self->priv->initialization_attempts >= BUDGIE_WAYLAND_CLIENT_MAX_INIT_ATTEMPTS) {
		g_critical ("waylandclient.vala:149: Failed to initialize primary monitor after %d " \
"attempts", BUDGIE_WAYLAND_CLIENT_MAX_INIT_ATTEMPTS);
		self->priv->monitor_update_timeout = (guint) 0;
		g_signal_emit (self, budgie_wayland_client_signals[BUDGIE_WAYLAND_CLIENT_INITIALIZATION_FAILED_SIGNAL], 0);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_wayland_client_update_monitor_data (BudgieWaylandClient* self)
{
	XfwMonitor* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_monitor;
	if (_tmp0_ == NULL) {
		self->priv->_is_valid = FALSE;
		return;
	}
	{
		XfwMonitor* _tmp1_;
		GdkRectangle _tmp2_ = {0};
		XfwMonitor* _tmp3_;
		GdkMonitor* _tmp4_;
		GdkMonitor* _tmp5_;
		XfwMonitor* _tmp6_;
		GdkMonitor* _tmp7_;
		_tmp1_ = self->priv->primary_monitor;
		xfw_monitor_get_logical_geometry (_tmp1_, &_tmp2_);
		self->priv->_monitor_res = _tmp2_;
		_tmp3_ = self->priv->primary_monitor;
		_tmp4_ = xfw_monitor_get_gdk_monitor (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (self->priv->_gdk_monitor);
		self->priv->_gdk_monitor = _tmp5_;
		_tmp6_ = self->priv->primary_monitor;
		self->priv->_scale = (gint) xfw_monitor_get_scale (_tmp6_);
		_tmp7_ = self->priv->_gdk_monitor;
		self->priv->_is_valid = _tmp7_ != NULL;
		if (!self->priv->_is_valid) {
			g_warning ("waylandclient.vala:171: Failed to get valid GdkMonitor from primary mo" \
"nitor");
		} else {
			GdkRectangle _tmp8_;
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			GdkRectangle _tmp11_;
			g_debug ("waylandclient.vala:173: Monitor data updated successfully: scale=%d", self->priv->_scale);
			_tmp8_ = self->priv->_monitor_res;
			_tmp9_ = self->priv->_monitor_res;
			_tmp10_ = self->priv->_monitor_res;
			_tmp11_ = self->priv->_monitor_res;
			g_debug ("waylandclient.vala:174: Monitor data updated successfully: %dx%d at %d" \
",%d", _tmp8_.width, _tmp9_.height, _tmp10_.x, _tmp11_.y);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("waylandclient.vala:179: Error updating monitor data: %s", _tmp13_);
		self->priv->_is_valid = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
budgie_wayland_client_validate_monitor_reference (BudgieWaylandClient* self)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->_is_valid) {
		_tmp0_ = TRUE;
	} else {
		GdkMonitor* _tmp1_;
		_tmp1_ = self->priv->_gdk_monitor;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		GdkDisplay* display = NULL;
		GdkMonitor* _tmp2_;
		GdkDisplay* _tmp3_;
		GdkDisplay* _tmp4_;
		GdkDisplay* _tmp5_;
		gint n_monitors = 0;
		GdkDisplay* _tmp6_;
		gboolean found = FALSE;
		_tmp2_ = self->priv->_gdk_monitor;
		_tmp3_ = gdk_monitor_get_display (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		display = _tmp4_;
		_tmp5_ = display;
		if (_tmp5_ == NULL) {
			self->priv->_is_valid = FALSE;
			result = FALSE;
			_g_object_unref0 (display);
			return result;
		}
		_tmp6_ = display;
		n_monitors = gdk_display_get_n_monitors (_tmp6_);
		found = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					GdkDisplay* _tmp9_;
					GdkMonitor* _tmp10_;
					GdkMonitor* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					if (!(i < n_monitors)) {
						break;
					}
					_tmp9_ = display;
					_tmp10_ = gdk_display_get_monitor (_tmp9_, i);
					_tmp11_ = self->priv->_gdk_monitor;
					if (_tmp10_ == _tmp11_) {
						found = TRUE;
						break;
					}
				}
			}
		}
		if (!found) {
			self->priv->_is_valid = FALSE;
			result = FALSE;
			_g_object_unref0 (display);
			return result;
		}
		_g_object_unref0 (display);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("waylandclient.vala:211: Monitor validation failed: %s", _tmp13_);
		self->priv->_is_valid = FALSE;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = TRUE;
	return result;
}

static void
budgie_wayland_client_refresh_monitor_info (BudgieWaylandClient* self)
{
	XfwScreen* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_is_valid = FALSE;
	self->priv->primary_monitor = NULL;
	_tmp0_ = self->priv->screen;
	if (_tmp0_ == NULL) {
		XfwScreen* _tmp1_;
		XfwScreen* _tmp2_;
		_tmp1_ = xfw_screen_get_default ();
		_g_object_unref0 (self->priv->screen);
		self->priv->screen = _tmp1_;
		_tmp2_ = self->priv->screen;
		if (_tmp2_ == NULL) {
			g_critical ("waylandclient.vala:226: Cannot refresh: Xfw.Screen is null");
			return;
		}
	}
	budgie_wayland_client_initialize_monitor_info (self);
}

static void
budgie_wayland_client_on_monitors_changed (BudgieWaylandClient* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_valid = FALSE;
	budgie_wayland_client_initialize_monitor_info (self);
}

gboolean
budgie_wayland_client_with_valid_monitor (BudgieWaylandClient* self,
                                          BudgieMonitorCallback callback,
                                          gpointer callback_target,
                                          GDestroyNotify callback_target_destroy_notify)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!budgie_wayland_client_is_initialised (self)) {
		g_warning ("waylandclient.vala:242: WaylandClient not properly initialized");
		result = FALSE;
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		return result;
	}
	if (!budgie_wayland_client_validate_monitor_reference (self)) {
		g_warning ("waylandclient.vala:247: Monitor reference invalid, attempting refresh");
		budgie_wayland_client_refresh_monitor_info (self);
		if (!budgie_wayland_client_is_initialised (self)) {
			g_warning ("waylandclient.vala:251: Failed to refresh monitor reference");
			result = FALSE;
			(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
			callback = NULL;
			callback_target = NULL;
			callback_target_destroy_notify = NULL;
			return result;
		}
	}
	result = callback (callback_target);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return result;
}

GdkMonitor*
budgie_wayland_client_get_gdk_monitor (BudgieWaylandClient* self)
{
	GdkMonitor* result;
	GdkMonitor* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!budgie_wayland_client_validate_monitor_reference (self)) {
		GdkMonitor* _tmp0_;
		g_warning ("waylandclient.vala:49: GdkMonitor reference is invalid, attempting ref" \
"resh");
		budgie_wayland_client_refresh_monitor_info (self);
		_tmp0_ = self->priv->_gdk_monitor;
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->_gdk_monitor;
	result = _tmp1_;
	return result;
}

void
budgie_wayland_client_get_monitor_res (BudgieWaylandClient* self,
                                       GdkRectangle * result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	if (!budgie_wayland_client_validate_monitor_reference (self)) {
		g_warning ("waylandclient.vala:60: Monitor resolution reference is invalid, attemp" \
"ting refresh");
		budgie_wayland_client_refresh_monitor_info (self);
	}
	_tmp0_ = self->priv->_monitor_res;
	*result = _tmp0_;
	return;
}

gint
budgie_wayland_client_get_scale (BudgieWaylandClient* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (!budgie_wayland_client_validate_monitor_reference (self)) {
		g_warning ("waylandclient.vala:70: Scale reference is invalid, attempting refresh");
		budgie_wayland_client_refresh_monitor_info (self);
	}
	result = self->priv->_scale;
	return result;
}

static GObject *
budgie_wayland_client_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	static GWeakRef BudgieWaylandClient_singleton__ref;
	static GMutex BudgieWaylandClient_singleton__lock;
	BudgieWaylandClient * self;
	g_mutex_lock (&BudgieWaylandClient_singleton__lock);
	obj = g_weak_ref_get (&BudgieWaylandClient_singleton__ref);
	if (obj != NULL) {
		g_mutex_unlock (&BudgieWaylandClient_singleton__lock);
		return obj;
	}
	parent_class = G_OBJECT_CLASS (budgie_wayland_client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	g_weak_ref_set (&BudgieWaylandClient_singleton__ref, obj);
	g_mutex_unlock (&BudgieWaylandClient_singleton__lock);
	return obj;
}

static void
budgie_wayland_client_class_init (BudgieWaylandClientClass * klass,
                                  gpointer klass_data)
{
	budgie_wayland_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieWaylandClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_wayland_client_get_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_wayland_client_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_wayland_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY] = g_param_spec_object ("gdk-monitor", "gdk-monitor", "gdk-monitor", gdk_monitor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY] = g_param_spec_boxed ("monitor-res", "monitor-res", "monitor-res", gdk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WAYLAND_CLIENT_SCALE_PROPERTY, budgie_wayland_client_properties[BUDGIE_WAYLAND_CLIENT_SCALE_PROPERTY] = g_param_spec_int ("scale", "scale", "scale", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	budgie_wayland_client_signals[BUDGIE_WAYLAND_CLIENT_INITIALIZED_SIGNAL] = g_signal_new ("initialized", BUDGIE_TYPE_WAYLAND_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_wayland_client_signals[BUDGIE_WAYLAND_CLIENT_INITIALIZATION_FAILED_SIGNAL] = g_signal_new ("initialization-failed", BUDGIE_TYPE_WAYLAND_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_wayland_client_instance_init (BudgieWaylandClient * self,
                                     gpointer klass)
{
	self->priv = budgie_wayland_client_get_instance_private (self);
	self->priv->screen = NULL;
	self->priv->primary_monitor = NULL;
	self->priv->_gdk_monitor = NULL;
	self->priv->_scale = 1;
	self->priv->_is_valid = FALSE;
	self->priv->monitor_update_timeout = (guint) 0;
	self->priv->smooth_timeout = (guint) 0;
	self->priv->initialization_attempts = 0;
}

static void
budgie_wayland_client_finalize (GObject * obj)
{
	BudgieWaylandClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	if (self->priv->smooth_timeout != ((guint) 0)) {
		g_source_remove (self->priv->smooth_timeout);
	}
	if (self->priv->monitor_update_timeout != ((guint) 0)) {
		g_source_remove (self->priv->monitor_update_timeout);
	}
	_g_object_unref0 (self->priv->screen);
	_g_object_unref0 (self->priv->_gdk_monitor);
	G_OBJECT_CLASS (budgie_wayland_client_parent_class)->finalize (obj);
}

static GType
budgie_wayland_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieWaylandClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_wayland_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieWaylandClient), 0, (GInstanceInitFunc) budgie_wayland_client_instance_init, NULL };
	GType budgie_wayland_client_type_id;
	budgie_wayland_client_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieWaylandClient", &g_define_type_info, 0);
	BudgieWaylandClient_private_offset = g_type_add_instance_private (budgie_wayland_client_type_id, sizeof (BudgieWaylandClientPrivate));
	return budgie_wayland_client_type_id;
}

GType
budgie_wayland_client_get_type (void)
{
	static volatile gsize budgie_wayland_client_type_id__once = 0;
	if (g_once_init_enter (&budgie_wayland_client_type_id__once)) {
		GType budgie_wayland_client_type_id;
		budgie_wayland_client_type_id = budgie_wayland_client_get_type_once ();
		g_once_init_leave (&budgie_wayland_client_type_id__once, budgie_wayland_client_type_id);
	}
	return budgie_wayland_client_type_id__once;
}

static void
_vala_budgie_wayland_client_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BudgieWaylandClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_WAYLAND_CLIENT, BudgieWaylandClient);
	switch (property_id) {
		case BUDGIE_WAYLAND_CLIENT_GDK_MONITOR_PROPERTY:
		g_value_set_object (value, budgie_wayland_client_get_gdk_monitor (self));
		break;
		case BUDGIE_WAYLAND_CLIENT_MONITOR_RES_PROPERTY:
		{
			GdkRectangle boxed;
			budgie_wayland_client_get_monitor_res (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case BUDGIE_WAYLAND_CLIENT_SCALE_PROPERTY:
		g_value_set_int (value, budgie_wayland_client_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

