/* src/bazaar.p/bz-hash-table-object.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-hash-table-object.h"



struct _BzHashTableObject
{
  GObject parent_instance;

  GHashTable *hash_table;
};

G_DEFINE_FINAL_TYPE (BzHashTableObject, bz_hash_table_object, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_HASH_TABLE,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_hash_table_object_dispose (GObject *object)
{
  BzHashTableObject *self = BZ_HASH_TABLE_OBJECT (object);

  g_clear_pointer (&self->hash_table, g_hash_table_unref);

  G_OBJECT_CLASS (bz_hash_table_object_parent_class)->dispose (object);
}

static void
bz_hash_table_object_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzHashTableObject *self = BZ_HASH_TABLE_OBJECT (object);

  switch (prop_id)
    {
    case PROP_HASH_TABLE:
      g_value_set_boxed (value, bz_hash_table_object_get_hash_table (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_hash_table_object_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzHashTableObject *self = BZ_HASH_TABLE_OBJECT (object);

  switch (prop_id)
    {
    case PROP_HASH_TABLE:
      bz_hash_table_object_set_hash_table (self, g_value_get_boxed (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_hash_table_object_class_init (BzHashTableObjectClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_hash_table_object_set_property;
  object_class->get_property = bz_hash_table_object_get_property;
  object_class->dispose      = bz_hash_table_object_dispose;

  props[PROP_HASH_TABLE] =
      g_param_spec_boxed (
          "hash-table",
          NULL, NULL,
          G_TYPE_HASH_TABLE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_hash_table_object_init (BzHashTableObject *self)
{
}

BzHashTableObject *
bz_hash_table_object_new (void){
  return g_object_new (BZ_TYPE_HASH_TABLE_OBJECT, NULL);
}

GHashTable *
bz_hash_table_object_get_hash_table (BzHashTableObject *self){
  g_return_val_if_fail (BZ_IS_HASH_TABLE_OBJECT (self), NULL);
  return self->hash_table;
}

void
bz_hash_table_object_set_hash_table (BzHashTableObject *self,
    GHashTable *hash_table){
  g_return_if_fail (BZ_IS_HASH_TABLE_OBJECT (self));

  if (hash_table == self->hash_table)
    return;

  g_clear_pointer (&self->hash_table, g_hash_table_unref);
  if (hash_table != NULL)
    self->hash_table = g_hash_table_ref (hash_table);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_HASH_TABLE]);
}

/* End of src/bazaar.p/bz-hash-table-object.c */
