/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "bamf-gdbus-view-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_old_name,
        const gchar *arg_new_name,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__INT_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_IntIntFunc)
       (void *data1,
        gint arg_old,
        gint arg_new,
        void *data2);
  _GDbusCodegenMarshalVoid_IntIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_IntIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_int (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_xprop,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.ayatana.bamf.view
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BamfDBusItemView
 * @title: BamfDBusItemView
 * @short_description: Generated C code for the org.ayatana.bamf.view D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link> D-Bus interface in C.
 */

enum
{
  BAMF_DBUS_ITEM__VIEW_NAME_CHANGED,
  BAMF_DBUS_ITEM__VIEW_USER_VISIBLE_CHANGED,
  BAMF_DBUS_ITEM__VIEW_URGENT_CHANGED,
  BAMF_DBUS_ITEM__VIEW_RUNNING_CHANGED,
  BAMF_DBUS_ITEM__VIEW_ACTIVE_CHANGED,
  BAMF_DBUS_ITEM__VIEW_CHILD_REMOVED,
  BAMF_DBUS_ITEM__VIEW_CHILD_ADDED,
  BAMF_DBUS_ITEM__VIEW_CLOSED,
};

static unsigned BAMF_DBUS_ITEM__VIEW_SIGNALS[8] = { 0 };

/* ---- Introspection data for org.ayatana.bamf.view ---- */

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_view_type_OUT_ARG_view_type =
{
  {
    -1,
    (gchar *) "view_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_view_type_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_view_type_OUT_ARG_view_type.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_view_type =
{
  {
    -1,
    (gchar *) "ViewType",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_view_type_OUT_ARG_pointers,
    NULL
  },
  "handle-view-type",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_icon_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_icon_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_icon_OUT_ARG_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_method_icon_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_method_icon_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_method_icon_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_icon =
{
  {
    -1,
    (gchar *) "Icon",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_icon_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_method_icon_annotation_info_pointers
  },
  "handle-icon",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_name_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_name_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_name_OUT_ARG_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_method_name_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_method_name_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_method_name_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_name =
{
  {
    -1,
    (gchar *) "Name",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_name_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_method_name_annotation_info_pointers
  },
  "handle-name",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_user_visible_OUT_ARG_visible =
{
  {
    -1,
    (gchar *) "visible",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_user_visible_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_user_visible_OUT_ARG_visible.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_method_user_visible_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_method_user_visible_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_method_user_visible_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_user_visible =
{
  {
    -1,
    (gchar *) "UserVisible",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_user_visible_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_method_user_visible_annotation_info_pointers
  },
  "handle-user-visible",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_is_urgent_OUT_ARG_urgent =
{
  {
    -1,
    (gchar *) "urgent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_is_urgent_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_is_urgent_OUT_ARG_urgent.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_method_is_urgent_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_method_is_urgent_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_method_is_urgent_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_is_urgent =
{
  {
    -1,
    (gchar *) "IsUrgent",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_is_urgent_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_method_is_urgent_annotation_info_pointers
  },
  "handle-is-urgent",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_is_running_OUT_ARG_running =
{
  {
    -1,
    (gchar *) "running",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_is_running_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_is_running_OUT_ARG_running.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_method_is_running_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_method_is_running_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_method_is_running_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_is_running =
{
  {
    -1,
    (gchar *) "IsRunning",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_is_running_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_method_is_running_annotation_info_pointers
  },
  "handle-is-running",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_is_active_OUT_ARG_active =
{
  {
    -1,
    (gchar *) "active",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_is_active_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_is_active_OUT_ARG_active.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_method_is_active_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_method_is_active_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_method_is_active_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_is_active =
{
  {
    -1,
    (gchar *) "IsActive",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_is_active_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_method_is_active_annotation_info_pointers
  },
  "handle-is-active",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_parents_OUT_ARG_parents_paths =
{
  {
    -1,
    (gchar *) "parents_paths",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_parents_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_parents_OUT_ARG_parents_paths.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_parents =
{
  {
    -1,
    (gchar *) "Parents",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_parents_OUT_ARG_pointers,
    NULL
  },
  "handle-parents",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_method_info_children_OUT_ARG_children_paths =
{
  {
    -1,
    (gchar *) "children_paths",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_method_info_children_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_view_method_info_children_OUT_ARG_children_paths.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_view_method_info_children =
{
  {
    -1,
    (gchar *) "Children",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_view_method_info_children_OUT_ARG_pointers,
    NULL
  },
  "handle-children",
  FALSE
};

static const GDBusMethodInfo * const __bamf_dbus_item_view_method_info_pointers[] =
{
  &__bamf_dbus_item_view_method_info_view_type.parent_struct,
  &__bamf_dbus_item_view_method_info_icon.parent_struct,
  &__bamf_dbus_item_view_method_info_name.parent_struct,
  &__bamf_dbus_item_view_method_info_user_visible.parent_struct,
  &__bamf_dbus_item_view_method_info_is_urgent.parent_struct,
  &__bamf_dbus_item_view_method_info_is_running.parent_struct,
  &__bamf_dbus_item_view_method_info_is_active.parent_struct,
  &__bamf_dbus_item_view_method_info_parents.parent_struct,
  &__bamf_dbus_item_view_method_info_children.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_name_changed_ARG_old_name =
{
  {
    -1,
    (gchar *) "old_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_name_changed_ARG_new_name =
{
  {
    -1,
    (gchar *) "new_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_name_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_name_changed_ARG_old_name.parent_struct,
  &__bamf_dbus_item_view_signal_info_name_changed_ARG_new_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_signal_name_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_signal_name_changed_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_signal_name_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_name_changed =
{
  {
    -1,
    (gchar *) "NameChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_name_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_signal_name_changed_annotation_info_pointers
  },
  "name-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_user_visible_changed_ARG_user_visible =
{
  {
    -1,
    (gchar *) "user_visible",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_user_visible_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_user_visible_changed_ARG_user_visible.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_signal_user_visible_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_signal_user_visible_changed_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_signal_user_visible_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_user_visible_changed =
{
  {
    -1,
    (gchar *) "UserVisibleChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_user_visible_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_signal_user_visible_changed_annotation_info_pointers
  },
  "user-visible-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_urgent_changed_ARG_is_urgent =
{
  {
    -1,
    (gchar *) "is_urgent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_urgent_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_urgent_changed_ARG_is_urgent.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_signal_urgent_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_signal_urgent_changed_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_signal_urgent_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_urgent_changed =
{
  {
    -1,
    (gchar *) "UrgentChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_urgent_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_signal_urgent_changed_annotation_info_pointers
  },
  "urgent-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_running_changed_ARG_is_running =
{
  {
    -1,
    (gchar *) "is_running",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_running_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_running_changed_ARG_is_running.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_signal_running_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_signal_running_changed_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_signal_running_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_running_changed =
{
  {
    -1,
    (gchar *) "RunningChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_running_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_signal_running_changed_annotation_info_pointers
  },
  "running-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_active_changed_ARG_is_active =
{
  {
    -1,
    (gchar *) "is_active",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_active_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_active_changed_ARG_is_active.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_view_signal_active_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_view_signal_active_changed_annotation_info_pointers[] =
{
  &__bamf_dbus_item_view_signal_active_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_active_changed =
{
  {
    -1,
    (gchar *) "ActiveChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_active_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_view_signal_active_changed_annotation_info_pointers
  },
  "active-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_child_removed_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_child_removed_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_child_removed_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_child_removed =
{
  {
    -1,
    (gchar *) "ChildRemoved",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_child_removed_ARG_pointers,
    NULL
  },
  "child-removed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_view_signal_info_child_added_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_view_signal_info_child_added_ARG_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_child_added_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_child_added =
{
  {
    -1,
    (gchar *) "ChildAdded",
    (GDBusArgInfo **) &__bamf_dbus_item_view_signal_info_child_added_ARG_pointers,
    NULL
  },
  "child-added"
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_view_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const __bamf_dbus_item_view_signal_info_pointers[] =
{
  &__bamf_dbus_item_view_signal_info_name_changed.parent_struct,
  &__bamf_dbus_item_view_signal_info_user_visible_changed.parent_struct,
  &__bamf_dbus_item_view_signal_info_urgent_changed.parent_struct,
  &__bamf_dbus_item_view_signal_info_running_changed.parent_struct,
  &__bamf_dbus_item_view_signal_info_active_changed.parent_struct,
  &__bamf_dbus_item_view_signal_info_child_removed.parent_struct,
  &__bamf_dbus_item_view_signal_info_child_added.parent_struct,
  &__bamf_dbus_item_view_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_icon =
{
  {
    -1,
    (gchar *) "Icon",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_user_visible =
{
  {
    -1,
    (gchar *) "UserVisible",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "user-visible",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_running =
{
  {
    -1,
    (gchar *) "Running",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "running",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_starting =
{
  {
    -1,
    (gchar *) "Starting",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "starting",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_urgent =
{
  {
    -1,
    (gchar *) "Urgent",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "urgent",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_view_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const __bamf_dbus_item_view_property_info_pointers[] =
{
  &__bamf_dbus_item_view_property_info_name.parent_struct,
  &__bamf_dbus_item_view_property_info_icon.parent_struct,
  &__bamf_dbus_item_view_property_info_user_visible.parent_struct,
  &__bamf_dbus_item_view_property_info_running.parent_struct,
  &__bamf_dbus_item_view_property_info_starting.parent_struct,
  &__bamf_dbus_item_view_property_info_urgent.parent_struct,
  &__bamf_dbus_item_view_property_info_active.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __bamf_dbus_item_view_interface_info =
{
  {
    -1,
    (gchar *) "org.ayatana.bamf.view",
    (GDBusMethodInfo **) &__bamf_dbus_item_view_method_info_pointers,
    (GDBusSignalInfo **) &__bamf_dbus_item_view_signal_info_pointers,
    (GDBusPropertyInfo **) &__bamf_dbus_item_view_property_info_pointers,
    NULL
  },
  "view",
};


/**
 * _bamf_dbus_item_view_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_bamf_dbus_item_view_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__bamf_dbus_item_view_interface_info.parent_struct;
}

/**
 * _bamf_dbus_item_view_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #BamfDBusItemView interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_bamf_dbus_item_view_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "icon");
  g_object_class_override_property (klass, property_id_begin++, "user-visible");
  g_object_class_override_property (klass, property_id_begin++, "running");
  g_object_class_override_property (klass, property_id_begin++, "starting");
  g_object_class_override_property (klass, property_id_begin++, "urgent");
  g_object_class_override_property (klass, property_id_begin++, "active");
  return property_id_begin - 1;
}


inline static void
_bamf_dbus_item_view_signal_marshal_name_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_user_visible_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_urgent_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_running_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_active_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_child_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_child_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_view_type (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_icon (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_name (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_user_visible (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_is_urgent (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_is_running (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_is_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_parents (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_view_method_marshal_children (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * BamfDBusItemView:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link>.
 */

/**
 * BamfDBusItemViewIface:
 * @parent_iface: The parent interface.
 * @handle_children: Handler for the #BamfDBusItemView::handle-children signal.
 * @handle_icon: Handler for the #BamfDBusItemView::handle-icon signal.
 * @handle_is_active: Handler for the #BamfDBusItemView::handle-is-active signal.
 * @handle_is_running: Handler for the #BamfDBusItemView::handle-is-running signal.
 * @handle_is_urgent: Handler for the #BamfDBusItemView::handle-is-urgent signal.
 * @handle_name: Handler for the #BamfDBusItemView::handle-name signal.
 * @handle_parents: Handler for the #BamfDBusItemView::handle-parents signal.
 * @handle_user_visible: Handler for the #BamfDBusItemView::handle-user-visible signal.
 * @handle_view_type: Handler for the #BamfDBusItemView::handle-view-type signal.
 * @get_active: Getter for the #BamfDBusItemView:active property.
 * @get_icon: Getter for the #BamfDBusItemView:icon property.
 * @get_name: Getter for the #BamfDBusItemView:name property.
 * @get_running: Getter for the #BamfDBusItemView:running property.
 * @get_starting: Getter for the #BamfDBusItemView:starting property.
 * @get_urgent: Getter for the #BamfDBusItemView:urgent property.
 * @get_user_visible: Getter for the #BamfDBusItemView:user-visible property.
 * @active_changed: Handler for the #BamfDBusItemView::active-changed signal.
 * @child_added: Handler for the #BamfDBusItemView::child-added signal.
 * @child_removed: Handler for the #BamfDBusItemView::child-removed signal.
 * @closed: Handler for the #BamfDBusItemView::closed signal.
 * @name_changed: Handler for the #BamfDBusItemView::name-changed signal.
 * @running_changed: Handler for the #BamfDBusItemView::running-changed signal.
 * @urgent_changed: Handler for the #BamfDBusItemView::urgent-changed signal.
 * @user_visible_changed: Handler for the #BamfDBusItemView::user-visible-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link>.
 */

typedef BamfDBusItemViewIface BamfDBusItemViewInterface;
G_DEFINE_INTERFACE (BamfDBusItemView, _bamf_dbus_item_view, G_TYPE_OBJECT)

static void
_bamf_dbus_item_view_default_init (BamfDBusItemViewIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * BamfDBusItemView::handle-view-type:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.ViewType">ViewType()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_view_type() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-view-type",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_view_type),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_view_type,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-icon:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.Icon">Icon()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_icon() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-icon",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_icon),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_icon,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-name:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.Name">Name()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_name),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_name,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-user-visible:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.UserVisible">UserVisible()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_user_visible() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-user-visible",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_user_visible),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_user_visible,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-is-urgent:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.IsUrgent">IsUrgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_is_urgent() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-is-urgent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_is_urgent),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_is_urgent,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-is-running:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.IsRunning">IsRunning()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_is_running() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-is-running",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_is_running),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_is_running,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-is-active:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.IsActive">IsActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_is_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-is-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_is_active),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_is_active,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-parents:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.Parents">Parents()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_parents() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-parents",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_parents),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_parents,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemView::handle-children:
   * @object: A #BamfDBusItemView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-view.Children">Children()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_view_complete_children() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-children",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemViewIface, handle_children),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_view_method_marshal_children,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * BamfDBusItemView::name-changed:
   * @object: A #BamfDBusItemView.
   * @arg_old_name: Argument.
   * @arg_new_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.NameChanged">"NameChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_NAME_CHANGED] =
    g_signal_new ("name-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, name_changed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_name_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * BamfDBusItemView::user-visible-changed:
   * @object: A #BamfDBusItemView.
   * @arg_user_visible: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.UserVisibleChanged">"UserVisibleChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_USER_VISIBLE_CHANGED] =
    g_signal_new ("user-visible-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, user_visible_changed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_user_visible_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * BamfDBusItemView::urgent-changed:
   * @object: A #BamfDBusItemView.
   * @arg_is_urgent: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.UrgentChanged">"UrgentChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_URGENT_CHANGED] =
    g_signal_new ("urgent-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, urgent_changed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_urgent_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * BamfDBusItemView::running-changed:
   * @object: A #BamfDBusItemView.
   * @arg_is_running: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.RunningChanged">"RunningChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_RUNNING_CHANGED] =
    g_signal_new ("running-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, running_changed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_running_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * BamfDBusItemView::active-changed:
   * @object: A #BamfDBusItemView.
   * @arg_is_active: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.ActiveChanged">"ActiveChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_ACTIVE_CHANGED] =
    g_signal_new ("active-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, active_changed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_active_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * BamfDBusItemView::child-removed:
   * @object: A #BamfDBusItemView.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.ChildRemoved">"ChildRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_CHILD_REMOVED] =
    g_signal_new ("child-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, child_removed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_child_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * BamfDBusItemView::child-added:
   * @object: A #BamfDBusItemView.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.ChildAdded">"ChildAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_CHILD_ADDED] =
    g_signal_new ("child-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, child_added),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_child_added,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * BamfDBusItemView::closed:
   * @object: A #BamfDBusItemView.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-view.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemViewIface, closed),
      NULL,
      NULL,
      _bamf_dbus_item_view_signal_marshal_closed,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * BamfDBusItemView:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemView:icon:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.Icon">"Icon"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon", "Icon", "Icon", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemView:user-visible:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.UserVisible">"UserVisible"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("user-visible", "UserVisible", "UserVisible", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemView:running:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.Running">"Running"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("running", "Running", "Running", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemView:starting:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.Starting">"Starting"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("starting", "Starting", "Starting", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemView:urgent:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.Urgent">"Urgent"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("urgent", "Urgent", "Urgent", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemView:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-view.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * _bamf_dbus_item_view_get_name: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _bamf_dbus_item_view_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
_bamf_dbus_item_view_get_name (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), NULL);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_name (object);
}

/**
 * _bamf_dbus_item_view_dup_name: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-ayatana-bamf-view.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
_bamf_dbus_item_view_dup_name (BamfDBusItemView *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * _bamf_dbus_item_view_set_name: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_name (BamfDBusItemView *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * _bamf_dbus_item_view_get_icon: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.Icon">"Icon"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _bamf_dbus_item_view_dup_icon() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
_bamf_dbus_item_view_get_icon (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), NULL);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_icon (object);
}

/**
 * _bamf_dbus_item_view_dup_icon: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-ayatana-bamf-view.Icon">"Icon"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
_bamf_dbus_item_view_dup_icon (BamfDBusItemView *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon", &value, NULL);
  return value;
}

/**
 * _bamf_dbus_item_view_set_icon: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.Icon">"Icon"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_icon (BamfDBusItemView *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon", value, NULL);
}

/**
 * _bamf_dbus_item_view_get_user_visible: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.UserVisible">"UserVisible"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_bamf_dbus_item_view_get_user_visible (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), FALSE);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_user_visible (object);
}

/**
 * _bamf_dbus_item_view_set_user_visible: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.UserVisible">"UserVisible"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_user_visible (BamfDBusItemView *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "user-visible", value, NULL);
}

/**
 * _bamf_dbus_item_view_get_running: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.Running">"Running"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_bamf_dbus_item_view_get_running (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), FALSE);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_running (object);
}

/**
 * _bamf_dbus_item_view_set_running: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.Running">"Running"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_running (BamfDBusItemView *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "running", value, NULL);
}

/**
 * _bamf_dbus_item_view_get_starting: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.Starting">"Starting"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_bamf_dbus_item_view_get_starting (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), FALSE);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_starting (object);
}

/**
 * _bamf_dbus_item_view_set_starting: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.Starting">"Starting"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_starting (BamfDBusItemView *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "starting", value, NULL);
}

/**
 * _bamf_dbus_item_view_get_urgent: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.Urgent">"Urgent"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_bamf_dbus_item_view_get_urgent (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), FALSE);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_urgent (object);
}

/**
 * _bamf_dbus_item_view_set_urgent: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.Urgent">"Urgent"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_urgent (BamfDBusItemView *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "urgent", value, NULL);
}

/**
 * _bamf_dbus_item_view_get_active: (skip)
 * @object: A #BamfDBusItemView.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-view.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_bamf_dbus_item_view_get_active (BamfDBusItemView *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_VIEW (object), FALSE);

  return BAMF_DBUS_ITEM_VIEW_GET_IFACE (object)->get_active (object);
}

/**
 * _bamf_dbus_item_view_set_active: (skip)
 * @object: A #BamfDBusItemView.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-view.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_view_set_active (BamfDBusItemView *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * _bamf_dbus_item_view_emit_name_changed:
 * @object: A #BamfDBusItemView.
 * @arg_old_name: Argument to pass with the signal.
 * @arg_new_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.NameChanged">"NameChanged"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_view_emit_name_changed (
    BamfDBusItemView *object,
    const gchar *arg_old_name,
    const gchar *arg_new_name)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_NAME_CHANGED], 0, arg_old_name, arg_new_name);
}

/**
 * _bamf_dbus_item_view_emit_user_visible_changed:
 * @object: A #BamfDBusItemView.
 * @arg_user_visible: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.UserVisibleChanged">"UserVisibleChanged"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_view_emit_user_visible_changed (
    BamfDBusItemView *object,
    gboolean arg_user_visible)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_USER_VISIBLE_CHANGED], 0, arg_user_visible);
}

/**
 * _bamf_dbus_item_view_emit_urgent_changed:
 * @object: A #BamfDBusItemView.
 * @arg_is_urgent: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.UrgentChanged">"UrgentChanged"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_view_emit_urgent_changed (
    BamfDBusItemView *object,
    gboolean arg_is_urgent)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_URGENT_CHANGED], 0, arg_is_urgent);
}

/**
 * _bamf_dbus_item_view_emit_running_changed:
 * @object: A #BamfDBusItemView.
 * @arg_is_running: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.RunningChanged">"RunningChanged"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_view_emit_running_changed (
    BamfDBusItemView *object,
    gboolean arg_is_running)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_RUNNING_CHANGED], 0, arg_is_running);
}

/**
 * _bamf_dbus_item_view_emit_active_changed:
 * @object: A #BamfDBusItemView.
 * @arg_is_active: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.ActiveChanged">"ActiveChanged"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_view_emit_active_changed (
    BamfDBusItemView *object,
    gboolean arg_is_active)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_ACTIVE_CHANGED], 0, arg_is_active);
}

/**
 * _bamf_dbus_item_view_emit_child_removed:
 * @object: A #BamfDBusItemView.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.ChildRemoved">"ChildRemoved"</link> D-Bus signal.
 */
void
_bamf_dbus_item_view_emit_child_removed (
    BamfDBusItemView *object,
    const gchar *arg_path)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_CHILD_REMOVED], 0, arg_path);
}

/**
 * _bamf_dbus_item_view_emit_child_added:
 * @object: A #BamfDBusItemView.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.ChildAdded">"ChildAdded"</link> D-Bus signal.
 */
void
_bamf_dbus_item_view_emit_child_added (
    BamfDBusItemView *object,
    const gchar *arg_path)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_CHILD_ADDED], 0, arg_path);
}

/**
 * _bamf_dbus_item_view_emit_closed:
 * @object: A #BamfDBusItemView.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-view.Closed">"Closed"</link> D-Bus signal.
 */
void
_bamf_dbus_item_view_emit_closed (
    BamfDBusItemView *object)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__VIEW_SIGNALS[BAMF_DBUS_ITEM__VIEW_CLOSED], 0);
}

/**
 * _bamf_dbus_item_view_call_view_type:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.ViewType">ViewType()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_view_type_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_view_type_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_view_call_view_type (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ViewType",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_view_type_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_view_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_view_type().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_view_type().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_view_call_view_type_finish (
    BamfDBusItemView *proxy,
    gchar **out_view_type,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_view_type);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_view_type_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_view_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.ViewType">ViewType()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_view_type() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_view_call_view_type_sync (
    BamfDBusItemView *proxy,
    gchar **out_view_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ViewType",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_view_type);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_icon:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Icon">Icon()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_icon_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_icon_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_call_icon (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Icon",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_icon_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_icon().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_icon().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_icon_finish (
    BamfDBusItemView *proxy,
    gchar **out_name,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_icon_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Icon">Icon()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_icon() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_icon_sync (
    BamfDBusItemView *proxy,
    gchar **out_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Icon",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_name:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Name">Name()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_name_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_name_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_call_name (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Name",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_name_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_name_finish (
    BamfDBusItemView *proxy,
    gchar **out_name,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_name_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Name">Name()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_name_sync (
    BamfDBusItemView *proxy,
    gchar **out_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Name",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_user_visible:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.UserVisible">UserVisible()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_user_visible_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_user_visible_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_call_user_visible (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UserVisible",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_user_visible_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_visible: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_user_visible().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_user_visible().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_user_visible_finish (
    BamfDBusItemView *proxy,
    gboolean *out_visible,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_visible);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_user_visible_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_visible: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.UserVisible">UserVisible()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_user_visible() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_user_visible_sync (
    BamfDBusItemView *proxy,
    gboolean *out_visible,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UserVisible",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_visible);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_is_urgent:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.IsUrgent">IsUrgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_is_urgent_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_is_urgent_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_call_is_urgent (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsUrgent",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_is_urgent_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_urgent: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_is_urgent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_is_urgent().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_is_urgent_finish (
    BamfDBusItemView *proxy,
    gboolean *out_urgent,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_urgent);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_is_urgent_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_urgent: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.IsUrgent">IsUrgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_is_urgent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_is_urgent_sync (
    BamfDBusItemView *proxy,
    gboolean *out_urgent,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsUrgent",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_urgent);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_is_running:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.IsRunning">IsRunning()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_is_running_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_is_running_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_call_is_running (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsRunning",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_is_running_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_running: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_is_running().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_is_running().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_is_running_finish (
    BamfDBusItemView *proxy,
    gboolean *out_running,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_running);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_is_running_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_running: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.IsRunning">IsRunning()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_is_running() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_is_running_sync (
    BamfDBusItemView *proxy,
    gboolean *out_running,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsRunning",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_running);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_is_active:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.IsActive">IsActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_is_active_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_is_active_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_call_is_active (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_is_active_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_active: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_is_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_is_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_is_active_finish (
    BamfDBusItemView *proxy,
    gboolean *out_active,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_active);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_is_active_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_active: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.IsActive">IsActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_is_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_view_call_is_active_sync (
    BamfDBusItemView *proxy,
    gboolean *out_active,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_active);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_parents:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Parents">Parents()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_parents_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_parents_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_view_call_parents (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Parents",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_parents_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_parents_paths: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_parents().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_parents().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_view_call_parents_finish (
    BamfDBusItemView *proxy,
    gchar ***out_parents_paths,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_parents_paths);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_parents_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_parents_paths: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Parents">Parents()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_parents() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_view_call_parents_sync (
    BamfDBusItemView *proxy,
    gchar ***out_parents_paths,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Parents",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_parents_paths);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_children:
 * @proxy: A #BamfDBusItemViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Children">Children()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_call_children_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_call_children_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_view_call_children (
    BamfDBusItemView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Children",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_view_call_children_finish:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_children_paths: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_call_children().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_view_call_children().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_view_call_children_finish (
    BamfDBusItemView *proxy,
    gchar ***out_children_paths,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_children_paths);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_call_children_sync:
 * @proxy: A #BamfDBusItemViewProxy.
 * @out_children_paths: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-view.Children">Children()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_call_children() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_view_call_children_sync (
    BamfDBusItemView *proxy,
    gchar ***out_children_paths,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Children",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_children_paths);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_view_complete_view_type:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @view_type: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.ViewType">ViewType()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_view_complete_view_type (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *view_type)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   view_type));
}

/**
 * _bamf_dbus_item_view_complete_icon:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.Icon">Icon()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_complete_icon (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *name)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   name));
}

/**
 * _bamf_dbus_item_view_complete_name:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.Name">Name()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_complete_name (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *name)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   name));
}

/**
 * _bamf_dbus_item_view_complete_user_visible:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @visible: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.UserVisible">UserVisible()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_complete_user_visible (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean visible)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   visible));
}

/**
 * _bamf_dbus_item_view_complete_is_urgent:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @urgent: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.IsUrgent">IsUrgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_complete_is_urgent (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean urgent)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   urgent));
}

/**
 * _bamf_dbus_item_view_complete_is_running:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @running: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.IsRunning">IsRunning()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_complete_is_running (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean running)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   running));
}

/**
 * _bamf_dbus_item_view_complete_is_active:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @active: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.IsActive">IsActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_view_complete_is_active (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean active)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   active));
}

/**
 * _bamf_dbus_item_view_complete_parents:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @parents_paths: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.Parents">Parents()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_view_complete_parents (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *parents_paths)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   parents_paths));
}

/**
 * _bamf_dbus_item_view_complete_children:
 * @object: A #BamfDBusItemView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @children_paths: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-view.Children">Children()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_view_complete_children (
    BamfDBusItemView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *children_paths)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   children_paths));
}

/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemViewProxy:
 *
 * The #BamfDBusItemViewProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemViewProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemViewProxy.
 */

struct _BamfDBusItemViewProxyPrivate
{
  GData *qdata;
};

static void _bamf_dbus_item_view_proxy_iface_init (BamfDBusItemViewIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemViewProxy, _bamf_dbus_item_view_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (BamfDBusItemViewProxy)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_VIEW, _bamf_dbus_item_view_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemViewProxy, _bamf_dbus_item_view_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_VIEW, _bamf_dbus_item_view_proxy_iface_init))

#endif
static void
_bamf_dbus_item_view_proxy_finalize (GObject *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_bamf_dbus_item_view_proxy_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_view_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) __bamf_dbus_item_view_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
_bamf_dbus_item_view_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.ayatana.bamf.view: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
_bamf_dbus_item_view_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) __bamf_dbus_item_view_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.ayatana.bamf.view", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) _bamf_dbus_item_view_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
_bamf_dbus_item_view_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__bamf_dbus_item_view_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BAMF_DBUS_ITEM_TYPE_VIEW);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_VIEW);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_bamf_dbus_item_view_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_view_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_view_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
_bamf_dbus_item_view_proxy_get_name (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
_bamf_dbus_item_view_proxy_get_icon (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Icon");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_bamf_dbus_item_view_proxy_get_user_visible (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserVisible");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_bamf_dbus_item_view_proxy_get_running (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Running");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_bamf_dbus_item_view_proxy_get_starting (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Starting");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_bamf_dbus_item_view_proxy_get_urgent (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Urgent");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_bamf_dbus_item_view_proxy_get_active (BamfDBusItemView *object)
{
  BamfDBusItemViewProxy *proxy = BAMF_DBUS_ITEM_VIEW_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
_bamf_dbus_item_view_proxy_init (BamfDBusItemViewProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _bamf_dbus_item_view_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BAMF_DBUS_ITEM_TYPE_VIEW_PROXY, BamfDBusItemViewProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _bamf_dbus_item_view_interface_info ());
}

static void
_bamf_dbus_item_view_proxy_class_init (BamfDBusItemViewProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _bamf_dbus_item_view_proxy_finalize;
  gobject_class->get_property = _bamf_dbus_item_view_proxy_get_property;
  gobject_class->set_property = _bamf_dbus_item_view_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _bamf_dbus_item_view_proxy_g_signal;
  proxy_class->g_properties_changed = _bamf_dbus_item_view_proxy_g_properties_changed;

  _bamf_dbus_item_view_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemViewProxyPrivate));
#endif
}

static void
_bamf_dbus_item_view_proxy_iface_init (BamfDBusItemViewIface *iface)
{
  iface->get_name = _bamf_dbus_item_view_proxy_get_name;
  iface->get_icon = _bamf_dbus_item_view_proxy_get_icon;
  iface->get_user_visible = _bamf_dbus_item_view_proxy_get_user_visible;
  iface->get_running = _bamf_dbus_item_view_proxy_get_running;
  iface->get_starting = _bamf_dbus_item_view_proxy_get_starting;
  iface->get_urgent = _bamf_dbus_item_view_proxy_get_urgent;
  iface->get_active = _bamf_dbus_item_view_proxy_get_active;
}

/**
 * _bamf_dbus_item_view_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_proxy_new_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_view_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_VIEW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.view", NULL);
}

/**
 * _bamf_dbus_item_view_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_view_proxy_new().
 *
 * Returns: (transfer full) (type BamfDBusItemViewProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemView *
_bamf_dbus_item_view_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_VIEW (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_view_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemViewProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemView *
_bamf_dbus_item_view_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_VIEW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.view", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_VIEW (ret);
  else
    return NULL;
}


/**
 * _bamf_dbus_item_view_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _bamf_dbus_item_view_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_view_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_view_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_view_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_VIEW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.view", NULL);
}

/**
 * _bamf_dbus_item_view_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_view_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_view_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type BamfDBusItemViewProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemView *
_bamf_dbus_item_view_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_VIEW (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_view_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _bamf_dbus_item_view_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_view_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemViewProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemView *
_bamf_dbus_item_view_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_VIEW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.view", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_VIEW (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemViewSkeleton:
 *
 * The #BamfDBusItemViewSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemViewSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemViewSkeleton.
 */

struct _BamfDBusItemViewSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__bamf_dbus_item_view_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BAMF_DBUS_ITEM_TYPE_VIEW);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_VIEW);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__bamf_dbus_item_view_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_view_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__bamf_dbus_item_view_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_view_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __bamf_dbus_item_view_skeleton_vtable =
{
  __bamf_dbus_item_view_skeleton_handle_method_call,
  __bamf_dbus_item_view_skeleton_handle_get_property,
  __bamf_dbus_item_view_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_bamf_dbus_item_view_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _bamf_dbus_item_view_interface_info ();
}

static GDBusInterfaceVTable *
_bamf_dbus_item_view_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__bamf_dbus_item_view_skeleton_vtable;
}

static GVariant *
_bamf_dbus_item_view_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (__bamf_dbus_item_view_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __bamf_dbus_item_view_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __bamf_dbus_item_view_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __bamf_dbus_item_view_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean __bamf_dbus_item_view_emit_changed (gpointer user_data);

static void
_bamf_dbus_item_view_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    __bamf_dbus_item_view_emit_changed (skeleton);
}

static void
__bamf_dbus_item_view_on_signal_name_changed (
    BamfDBusItemView *object,
    const gchar *arg_old_name,
    const gchar *arg_new_name)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_old_name,
                   arg_new_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "NameChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_user_visible_changed (
    BamfDBusItemView *object,
    gboolean arg_user_visible)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_user_visible));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "UserVisibleChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_urgent_changed (
    BamfDBusItemView *object,
    gboolean arg_is_urgent)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_is_urgent));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "UrgentChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_running_changed (
    BamfDBusItemView *object,
    gboolean arg_is_running)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_is_running));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "RunningChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_active_changed (
    BamfDBusItemView *object,
    gboolean arg_is_active)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_is_active));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "ActiveChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_child_removed (
    BamfDBusItemView *object,
    const gchar *arg_path)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "ChildRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_child_added (
    BamfDBusItemView *object,
    const gchar *arg_path)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "ChildAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_view_on_signal_closed (
    BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.view", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void _bamf_dbus_item_view_skeleton_iface_init (BamfDBusItemViewIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemViewSkeleton, _bamf_dbus_item_view_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (BamfDBusItemViewSkeleton)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_VIEW, _bamf_dbus_item_view_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemViewSkeleton, _bamf_dbus_item_view_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_VIEW, _bamf_dbus_item_view_skeleton_iface_init))

#endif
static void
_bamf_dbus_item_view_skeleton_finalize (GObject *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_bamf_dbus_item_view_skeleton_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_view_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
__bamf_dbus_item_view_emit_changed (gpointer user_data)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.ayatana.bamf.view",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
__bamf_dbus_item_view_schedule_emit_changed (BamfDBusItemViewSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
_bamf_dbus_item_view_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, __bamf_dbus_item_view_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] __bamf_dbus_item_view_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
_bamf_dbus_item_view_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) __bamf_dbus_item_view_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        __bamf_dbus_item_view_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
_bamf_dbus_item_view_skeleton_init (BamfDBusItemViewSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _bamf_dbus_item_view_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BAMF_DBUS_ITEM_TYPE_VIEW_SKELETON, BamfDBusItemViewSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
}

static const gchar *
_bamf_dbus_item_view_skeleton_get_name (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
_bamf_dbus_item_view_skeleton_get_icon (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_bamf_dbus_item_view_skeleton_get_user_visible (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_bamf_dbus_item_view_skeleton_get_running (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_bamf_dbus_item_view_skeleton_get_starting (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_bamf_dbus_item_view_skeleton_get_urgent (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_bamf_dbus_item_view_skeleton_get_active (BamfDBusItemView *object)
{
  BamfDBusItemViewSkeleton *skeleton = BAMF_DBUS_ITEM_VIEW_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
_bamf_dbus_item_view_skeleton_class_init (BamfDBusItemViewSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _bamf_dbus_item_view_skeleton_finalize;
  gobject_class->get_property = _bamf_dbus_item_view_skeleton_get_property;
  gobject_class->set_property = _bamf_dbus_item_view_skeleton_set_property;
  gobject_class->notify       = _bamf_dbus_item_view_skeleton_notify;


  _bamf_dbus_item_view_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _bamf_dbus_item_view_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _bamf_dbus_item_view_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _bamf_dbus_item_view_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _bamf_dbus_item_view_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemViewSkeletonPrivate));
#endif
}

static void
_bamf_dbus_item_view_skeleton_iface_init (BamfDBusItemViewIface *iface)
{
  iface->name_changed = __bamf_dbus_item_view_on_signal_name_changed;
  iface->user_visible_changed = __bamf_dbus_item_view_on_signal_user_visible_changed;
  iface->urgent_changed = __bamf_dbus_item_view_on_signal_urgent_changed;
  iface->running_changed = __bamf_dbus_item_view_on_signal_running_changed;
  iface->active_changed = __bamf_dbus_item_view_on_signal_active_changed;
  iface->child_removed = __bamf_dbus_item_view_on_signal_child_removed;
  iface->child_added = __bamf_dbus_item_view_on_signal_child_added;
  iface->closed = __bamf_dbus_item_view_on_signal_closed;
  iface->get_name = _bamf_dbus_item_view_skeleton_get_name;
  iface->get_icon = _bamf_dbus_item_view_skeleton_get_icon;
  iface->get_user_visible = _bamf_dbus_item_view_skeleton_get_user_visible;
  iface->get_running = _bamf_dbus_item_view_skeleton_get_running;
  iface->get_starting = _bamf_dbus_item_view_skeleton_get_starting;
  iface->get_urgent = _bamf_dbus_item_view_skeleton_get_urgent;
  iface->get_active = _bamf_dbus_item_view_skeleton_get_active;
}

/**
 * _bamf_dbus_item_view_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link>.
 *
 * Returns: (transfer full) (type BamfDBusItemViewSkeleton): The skeleton object.
 */
BamfDBusItemView *
_bamf_dbus_item_view_skeleton_new (void)
{
  return BAMF_DBUS_ITEM_VIEW (g_object_new (BAMF_DBUS_ITEM_TYPE_VIEW_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.ayatana.bamf.application
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BamfDBusItemApplication
 * @title: BamfDBusItemApplication
 * @short_description: Generated C code for the org.ayatana.bamf.application D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link> D-Bus interface in C.
 */

enum
{
  BAMF_DBUS_ITEM__APPLICATION_WINDOW_REMOVED,
  BAMF_DBUS_ITEM__APPLICATION_WINDOW_ADDED,
  BAMF_DBUS_ITEM__APPLICATION_SUPPORTED_MIME_TYPES_CHANGED,
  BAMF_DBUS_ITEM__APPLICATION_DESKTOP_FILE_UPDATED,
};

static unsigned BAMF_DBUS_ITEM__APPLICATION_SIGNALS[4] = { 0 };

/* ---- Introspection data for org.ayatana.bamf.application ---- */

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_show_stubs_OUT_ARG_show_stubs =
{
  {
    -1,
    (gchar *) "show_stubs",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_show_stubs_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_show_stubs_OUT_ARG_show_stubs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_show_stubs =
{
  {
    -1,
    (gchar *) "ShowStubs",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_show_stubs_OUT_ARG_pointers,
    NULL
  },
  "handle-show-stubs",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_xids_OUT_ARG_xids =
{
  {
    -1,
    (gchar *) "xids",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_xids_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_xids_OUT_ARG_xids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_xids =
{
  {
    -1,
    (gchar *) "Xids",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_xids_OUT_ARG_pointers,
    NULL
  },
  "handle-xids",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_desktop_file_OUT_ARG_desktop_file =
{
  {
    -1,
    (gchar *) "desktop_file",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_desktop_file_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_desktop_file_OUT_ARG_desktop_file.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_desktop_file =
{
  {
    -1,
    (gchar *) "DesktopFile",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_desktop_file_OUT_ARG_pointers,
    NULL
  },
  "handle-desktop-file",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_supported_mime_types_OUT_ARG_mime_types =
{
  {
    -1,
    (gchar *) "mime_types",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_supported_mime_types_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_supported_mime_types_OUT_ARG_mime_types.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_supported_mime_types =
{
  {
    -1,
    (gchar *) "SupportedMimeTypes",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_supported_mime_types_OUT_ARG_pointers,
    NULL
  },
  "handle-supported-mime-types",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_application_type_OUT_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_application_type_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_application_type_OUT_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_application_type =
{
  {
    -1,
    (gchar *) "ApplicationType",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_application_type_OUT_ARG_pointers,
    NULL
  },
  "handle-application-type",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_application_menu_OUT_ARG_busname =
{
  {
    -1,
    (gchar *) "busname",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_application_menu_OUT_ARG_objectpath =
{
  {
    -1,
    (gchar *) "objectpath",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_application_menu_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_application_menu_OUT_ARG_busname.parent_struct,
  &__bamf_dbus_item_application_method_info_application_menu_OUT_ARG_objectpath.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_application_method_application_menu_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_application_method_application_menu_annotation_info_pointers[] =
{
  &__bamf_dbus_item_application_method_application_menu_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_application_menu =
{
  {
    -1,
    (gchar *) "ApplicationMenu",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_application_menu_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_application_method_application_menu_annotation_info_pointers
  },
  "handle-application-menu",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_method_info_focusable_child_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_method_info_focusable_child_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_application_method_info_focusable_child_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_application_method_info_focusable_child =
{
  {
    -1,
    (gchar *) "FocusableChild",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_application_method_info_focusable_child_OUT_ARG_pointers,
    NULL
  },
  "handle-focusable-child",
  FALSE
};

static const GDBusMethodInfo * const __bamf_dbus_item_application_method_info_pointers[] =
{
  &__bamf_dbus_item_application_method_info_show_stubs.parent_struct,
  &__bamf_dbus_item_application_method_info_xids.parent_struct,
  &__bamf_dbus_item_application_method_info_desktop_file.parent_struct,
  &__bamf_dbus_item_application_method_info_supported_mime_types.parent_struct,
  &__bamf_dbus_item_application_method_info_application_type.parent_struct,
  &__bamf_dbus_item_application_method_info_application_menu.parent_struct,
  &__bamf_dbus_item_application_method_info_focusable_child.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_signal_info_window_removed_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_signal_info_window_removed_ARG_pointers[] =
{
  &__bamf_dbus_item_application_signal_info_window_removed_ARG_path.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_application_signal_window_removed_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_application_signal_window_removed_annotation_info_pointers[] =
{
  &__bamf_dbus_item_application_signal_window_removed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_application_signal_info_window_removed =
{
  {
    -1,
    (gchar *) "WindowRemoved",
    (GDBusArgInfo **) &__bamf_dbus_item_application_signal_info_window_removed_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_application_signal_window_removed_annotation_info_pointers
  },
  "window-removed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_signal_info_window_added_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_signal_info_window_added_ARG_pointers[] =
{
  &__bamf_dbus_item_application_signal_info_window_added_ARG_path.parent_struct,
  NULL
};

static const GDBusAnnotationInfo __bamf_dbus_item_application_signal_window_added_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const __bamf_dbus_item_application_signal_window_added_annotation_info_pointers[] =
{
  &__bamf_dbus_item_application_signal_window_added_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_application_signal_info_window_added =
{
  {
    -1,
    (gchar *) "WindowAdded",
    (GDBusArgInfo **) &__bamf_dbus_item_application_signal_info_window_added_ARG_pointers,
    (GDBusAnnotationInfo **) &__bamf_dbus_item_application_signal_window_added_annotation_info_pointers
  },
  "window-added"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_signal_info_supported_mime_types_changed_ARG_dnd_mimes =
{
  {
    -1,
    (gchar *) "dnd_mimes",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_signal_info_supported_mime_types_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_application_signal_info_supported_mime_types_changed_ARG_dnd_mimes.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_application_signal_info_supported_mime_types_changed =
{
  {
    -1,
    (gchar *) "SupportedMimeTypesChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_application_signal_info_supported_mime_types_changed_ARG_pointers,
    NULL
  },
  "supported-mime-types-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_application_signal_info_desktop_file_updated_ARG_desktop_file =
{
  {
    -1,
    (gchar *) "desktop_file",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_application_signal_info_desktop_file_updated_ARG_pointers[] =
{
  &__bamf_dbus_item_application_signal_info_desktop_file_updated_ARG_desktop_file.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_application_signal_info_desktop_file_updated =
{
  {
    -1,
    (gchar *) "DesktopFileUpdated",
    (GDBusArgInfo **) &__bamf_dbus_item_application_signal_info_desktop_file_updated_ARG_pointers,
    NULL
  },
  "desktop-file-updated"
};

static const GDBusSignalInfo * const __bamf_dbus_item_application_signal_info_pointers[] =
{
  &__bamf_dbus_item_application_signal_info_window_removed.parent_struct,
  &__bamf_dbus_item_application_signal_info_window_added.parent_struct,
  &__bamf_dbus_item_application_signal_info_supported_mime_types_changed.parent_struct,
  &__bamf_dbus_item_application_signal_info_desktop_file_updated.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __bamf_dbus_item_application_interface_info =
{
  {
    -1,
    (gchar *) "org.ayatana.bamf.application",
    (GDBusMethodInfo **) &__bamf_dbus_item_application_method_info_pointers,
    (GDBusSignalInfo **) &__bamf_dbus_item_application_signal_info_pointers,
    NULL,
    NULL
  },
  "application",
};


/**
 * _bamf_dbus_item_application_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_bamf_dbus_item_application_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__bamf_dbus_item_application_interface_info.parent_struct;
}

/**
 * _bamf_dbus_item_application_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #BamfDBusItemApplication interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_bamf_dbus_item_application_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
_bamf_dbus_item_application_signal_marshal_window_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_signal_marshal_window_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_signal_marshal_supported_mime_types_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_signal_marshal_desktop_file_updated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_show_stubs (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_xids (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_desktop_file (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_supported_mime_types (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_application_type (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_application_menu (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_application_method_marshal_focusable_child (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * BamfDBusItemApplication:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link>.
 */

/**
 * BamfDBusItemApplicationIface:
 * @parent_iface: The parent interface.
 * @handle_application_menu: Handler for the #BamfDBusItemApplication::handle-application-menu signal.
 * @handle_application_type: Handler for the #BamfDBusItemApplication::handle-application-type signal.
 * @handle_desktop_file: Handler for the #BamfDBusItemApplication::handle-desktop-file signal.
 * @handle_focusable_child: Handler for the #BamfDBusItemApplication::handle-focusable-child signal.
 * @handle_show_stubs: Handler for the #BamfDBusItemApplication::handle-show-stubs signal.
 * @handle_supported_mime_types: Handler for the #BamfDBusItemApplication::handle-supported-mime-types signal.
 * @handle_xids: Handler for the #BamfDBusItemApplication::handle-xids signal.
 * @desktop_file_updated: Handler for the #BamfDBusItemApplication::desktop-file-updated signal.
 * @supported_mime_types_changed: Handler for the #BamfDBusItemApplication::supported-mime-types-changed signal.
 * @window_added: Handler for the #BamfDBusItemApplication::window-added signal.
 * @window_removed: Handler for the #BamfDBusItemApplication::window-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link>.
 */

typedef BamfDBusItemApplicationIface BamfDBusItemApplicationInterface;
G_DEFINE_INTERFACE (BamfDBusItemApplication, _bamf_dbus_item_application, G_TYPE_OBJECT)

static void
_bamf_dbus_item_application_default_init (BamfDBusItemApplicationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * BamfDBusItemApplication::handle-show-stubs:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.ShowStubs">ShowStubs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_show_stubs() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-stubs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_show_stubs),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_show_stubs,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemApplication::handle-xids:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.Xids">Xids()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_xids() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-xids",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_xids),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_xids,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemApplication::handle-desktop-file:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.DesktopFile">DesktopFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_desktop_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-desktop-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_desktop_file),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_desktop_file,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemApplication::handle-supported-mime-types:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.SupportedMimeTypes">SupportedMimeTypes()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_supported_mime_types() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-supported-mime-types",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_supported_mime_types),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_supported_mime_types,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemApplication::handle-application-type:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationType">ApplicationType()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_application_type() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-application-type",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_application_type),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_application_type,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemApplication::handle-application-menu:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationMenu">ApplicationMenu()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_application_menu() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-application-menu",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_application_menu),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_application_menu,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemApplication::handle-focusable-child:
   * @object: A #BamfDBusItemApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-application.FocusableChild">FocusableChild()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_application_complete_focusable_child() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-focusable-child",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemApplicationIface, handle_focusable_child),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_application_method_marshal_focusable_child,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * BamfDBusItemApplication::window-removed:
   * @object: A #BamfDBusItemApplication.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-application.WindowRemoved">"WindowRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_WINDOW_REMOVED] =
    g_signal_new ("window-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemApplicationIface, window_removed),
      NULL,
      NULL,
      _bamf_dbus_item_application_signal_marshal_window_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * BamfDBusItemApplication::window-added:
   * @object: A #BamfDBusItemApplication.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-application.WindowAdded">"WindowAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Deprecated: The D-Bus signal has been deprecated.
   */
  BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_WINDOW_ADDED] =
    g_signal_new ("window-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemApplicationIface, window_added),
      NULL,
      NULL,
      _bamf_dbus_item_application_signal_marshal_window_added,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * BamfDBusItemApplication::supported-mime-types-changed:
   * @object: A #BamfDBusItemApplication.
   * @arg_dnd_mimes: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-application.SupportedMimeTypesChanged">"SupportedMimeTypesChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_SUPPORTED_MIME_TYPES_CHANGED] =
    g_signal_new ("supported-mime-types-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemApplicationIface, supported_mime_types_changed),
      NULL,
      NULL,
      _bamf_dbus_item_application_signal_marshal_supported_mime_types_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRV);

  /**
   * BamfDBusItemApplication::desktop-file-updated:
   * @object: A #BamfDBusItemApplication.
   * @arg_desktop_file: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-application.DesktopFileUpdated">"DesktopFileUpdated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_DESKTOP_FILE_UPDATED] =
    g_signal_new ("desktop-file-updated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemApplicationIface, desktop_file_updated),
      NULL,
      NULL,
      _bamf_dbus_item_application_signal_marshal_desktop_file_updated,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * _bamf_dbus_item_application_emit_window_removed:
 * @object: A #BamfDBusItemApplication.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-application.WindowRemoved">"WindowRemoved"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_application_emit_window_removed (
    BamfDBusItemApplication *object,
    const gchar *arg_path)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_WINDOW_REMOVED], 0, arg_path);
}

/**
 * _bamf_dbus_item_application_emit_window_added:
 * @object: A #BamfDBusItemApplication.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-application.WindowAdded">"WindowAdded"</link> D-Bus signal.
 *
 * Deprecated: The D-Bus signal has been deprecated.
 */
void
_bamf_dbus_item_application_emit_window_added (
    BamfDBusItemApplication *object,
    const gchar *arg_path)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_WINDOW_ADDED], 0, arg_path);
}

/**
 * _bamf_dbus_item_application_emit_supported_mime_types_changed:
 * @object: A #BamfDBusItemApplication.
 * @arg_dnd_mimes: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-application.SupportedMimeTypesChanged">"SupportedMimeTypesChanged"</link> D-Bus signal.
 */
void
_bamf_dbus_item_application_emit_supported_mime_types_changed (
    BamfDBusItemApplication *object,
    const gchar *const *arg_dnd_mimes)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_SUPPORTED_MIME_TYPES_CHANGED], 0, arg_dnd_mimes);
}

/**
 * _bamf_dbus_item_application_emit_desktop_file_updated:
 * @object: A #BamfDBusItemApplication.
 * @arg_desktop_file: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-application.DesktopFileUpdated">"DesktopFileUpdated"</link> D-Bus signal.
 */
void
_bamf_dbus_item_application_emit_desktop_file_updated (
    BamfDBusItemApplication *object,
    const gchar *arg_desktop_file)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__APPLICATION_SIGNALS[BAMF_DBUS_ITEM__APPLICATION_DESKTOP_FILE_UPDATED], 0, arg_desktop_file);
}

/**
 * _bamf_dbus_item_application_call_show_stubs:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.ShowStubs">ShowStubs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_show_stubs_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_show_stubs_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_application_call_show_stubs (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowStubs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_show_stubs_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_show_stubs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_show_stubs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_show_stubs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_show_stubs_finish (
    BamfDBusItemApplication *proxy,
    gboolean *out_show_stubs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_show_stubs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_show_stubs_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_show_stubs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.ShowStubs">ShowStubs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_show_stubs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_show_stubs_sync (
    BamfDBusItemApplication *proxy,
    gboolean *out_show_stubs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowStubs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_show_stubs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_xids:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.Xids">Xids()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_xids_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_xids_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_application_call_xids (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Xids",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_xids_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_xids: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_xids().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_xids().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_xids_finish (
    BamfDBusItemApplication *proxy,
    GVariant **out_xids,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@au)",
                 out_xids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_xids_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_xids: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.Xids">Xids()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_xids() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_xids_sync (
    BamfDBusItemApplication *proxy,
    GVariant **out_xids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Xids",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@au)",
                 out_xids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_desktop_file:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.DesktopFile">DesktopFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_desktop_file_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_desktop_file_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_application_call_desktop_file (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DesktopFile",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_desktop_file_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_desktop_file: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_desktop_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_desktop_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_desktop_file_finish (
    BamfDBusItemApplication *proxy,
    gchar **out_desktop_file,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_desktop_file);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_desktop_file_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_desktop_file: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.DesktopFile">DesktopFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_desktop_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_desktop_file_sync (
    BamfDBusItemApplication *proxy,
    gchar **out_desktop_file,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DesktopFile",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_desktop_file);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_supported_mime_types:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.SupportedMimeTypes">SupportedMimeTypes()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_supported_mime_types_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_supported_mime_types_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_application_call_supported_mime_types (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SupportedMimeTypes",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_supported_mime_types_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_mime_types: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_supported_mime_types().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_supported_mime_types().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_supported_mime_types_finish (
    BamfDBusItemApplication *proxy,
    gchar ***out_mime_types,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_mime_types);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_supported_mime_types_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_mime_types: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.SupportedMimeTypes">SupportedMimeTypes()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_supported_mime_types() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_supported_mime_types_sync (
    BamfDBusItemApplication *proxy,
    gchar ***out_mime_types,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SupportedMimeTypes",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_mime_types);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_application_type:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationType">ApplicationType()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_application_type_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_application_type_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_application_call_application_type (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ApplicationType",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_application_type_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_application_type().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_application_type().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_application_type_finish (
    BamfDBusItemApplication *proxy,
    gchar **out_type,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_type);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_application_type_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationType">ApplicationType()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_application_type() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_application_type_sync (
    BamfDBusItemApplication *proxy,
    gchar **out_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ApplicationType",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_type);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_application_menu:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationMenu">ApplicationMenu()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_application_menu_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_application_menu_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_application_call_application_menu (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ApplicationMenu",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_application_menu_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_busname: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_objectpath: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_application_menu().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_application_menu().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_application_call_application_menu_finish (
    BamfDBusItemApplication *proxy,
    gchar **out_busname,
    gchar **out_objectpath,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_busname,
                 out_objectpath);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_application_menu_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_busname: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_objectpath: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationMenu">ApplicationMenu()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_application_menu() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
_bamf_dbus_item_application_call_application_menu_sync (
    BamfDBusItemApplication *proxy,
    gchar **out_busname,
    gchar **out_objectpath,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ApplicationMenu",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_busname,
                 out_objectpath);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_focusable_child:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.FocusableChild">FocusableChild()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_call_focusable_child_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_call_focusable_child_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_application_call_focusable_child (
    BamfDBusItemApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FocusableChild",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_application_call_focusable_child_finish:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_call_focusable_child().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_application_call_focusable_child().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_focusable_child_finish (
    BamfDBusItemApplication *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_call_focusable_child_sync:
 * @proxy: A #BamfDBusItemApplicationProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-application.FocusableChild">FocusableChild()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_call_focusable_child() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_application_call_focusable_child_sync (
    BamfDBusItemApplication *proxy,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FocusableChild",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_application_complete_show_stubs:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @show_stubs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.ShowStubs">ShowStubs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_application_complete_show_stubs (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean show_stubs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   show_stubs));
}

/**
 * _bamf_dbus_item_application_complete_xids:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @xids: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.Xids">Xids()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_application_complete_xids (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *xids)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@au)",
                   xids));
}

/**
 * _bamf_dbus_item_application_complete_desktop_file:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @desktop_file: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.DesktopFile">DesktopFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_application_complete_desktop_file (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *desktop_file)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   desktop_file));
}

/**
 * _bamf_dbus_item_application_complete_supported_mime_types:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @mime_types: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.SupportedMimeTypes">SupportedMimeTypes()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_application_complete_supported_mime_types (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *mime_types)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   mime_types));
}

/**
 * _bamf_dbus_item_application_complete_application_type:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @type: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationType">ApplicationType()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_application_complete_application_type (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *type)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   type));
}

/**
 * _bamf_dbus_item_application_complete_application_menu:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @busname: Parameter to return.
 * @objectpath: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.ApplicationMenu">ApplicationMenu()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
_bamf_dbus_item_application_complete_application_menu (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *busname,
    const gchar *objectpath)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   busname,
                   objectpath));
}

/**
 * _bamf_dbus_item_application_complete_focusable_child:
 * @object: A #BamfDBusItemApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-application.FocusableChild">FocusableChild()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_application_complete_focusable_child (
    BamfDBusItemApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   path));
}

/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemApplicationProxy:
 *
 * The #BamfDBusItemApplicationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemApplicationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemApplicationProxy.
 */

struct _BamfDBusItemApplicationProxyPrivate
{
  GData *qdata;
};

static void _bamf_dbus_item_application_proxy_iface_init (BamfDBusItemApplicationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemApplicationProxy, _bamf_dbus_item_application_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (BamfDBusItemApplicationProxy)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_APPLICATION, _bamf_dbus_item_application_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemApplicationProxy, _bamf_dbus_item_application_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_APPLICATION, _bamf_dbus_item_application_proxy_iface_init))

#endif
static void
_bamf_dbus_item_application_proxy_finalize (GObject *object)
{
  BamfDBusItemApplicationProxy *proxy = BAMF_DBUS_ITEM_APPLICATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_bamf_dbus_item_application_proxy_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_application_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_application_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_application_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__bamf_dbus_item_application_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BAMF_DBUS_ITEM_TYPE_APPLICATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_APPLICATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_bamf_dbus_item_application_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  BamfDBusItemApplicationProxy *proxy = BAMF_DBUS_ITEM_APPLICATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_application_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_application_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
_bamf_dbus_item_application_proxy_init (BamfDBusItemApplicationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _bamf_dbus_item_application_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BAMF_DBUS_ITEM_TYPE_APPLICATION_PROXY, BamfDBusItemApplicationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _bamf_dbus_item_application_interface_info ());
}

static void
_bamf_dbus_item_application_proxy_class_init (BamfDBusItemApplicationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _bamf_dbus_item_application_proxy_finalize;
  gobject_class->get_property = _bamf_dbus_item_application_proxy_get_property;
  gobject_class->set_property = _bamf_dbus_item_application_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _bamf_dbus_item_application_proxy_g_signal;
  proxy_class->g_properties_changed = _bamf_dbus_item_application_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemApplicationProxyPrivate));
#endif
}

static void
_bamf_dbus_item_application_proxy_iface_init (BamfDBusItemApplicationIface *iface G_GNUC_UNUSED)
{
}

/**
 * _bamf_dbus_item_application_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_proxy_new_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_application_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_APPLICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.application", NULL);
}

/**
 * _bamf_dbus_item_application_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_application_proxy_new().
 *
 * Returns: (transfer full) (type BamfDBusItemApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemApplication *
_bamf_dbus_item_application_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_APPLICATION (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_application_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemApplication *
_bamf_dbus_item_application_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_APPLICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.application", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_APPLICATION (ret);
  else
    return NULL;
}


/**
 * _bamf_dbus_item_application_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _bamf_dbus_item_application_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_application_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_application_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_application_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_APPLICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.application", NULL);
}

/**
 * _bamf_dbus_item_application_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_application_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_application_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type BamfDBusItemApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemApplication *
_bamf_dbus_item_application_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_APPLICATION (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_application_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _bamf_dbus_item_application_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_application_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemApplication *
_bamf_dbus_item_application_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_APPLICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.application", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_APPLICATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemApplicationSkeleton:
 *
 * The #BamfDBusItemApplicationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemApplicationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemApplicationSkeleton.
 */

struct _BamfDBusItemApplicationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__bamf_dbus_item_application_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BAMF_DBUS_ITEM_TYPE_APPLICATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_APPLICATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__bamf_dbus_item_application_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_application_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__bamf_dbus_item_application_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_application_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __bamf_dbus_item_application_skeleton_vtable =
{
  __bamf_dbus_item_application_skeleton_handle_method_call,
  __bamf_dbus_item_application_skeleton_handle_get_property,
  __bamf_dbus_item_application_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_bamf_dbus_item_application_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _bamf_dbus_item_application_interface_info ();
}

static GDBusInterfaceVTable *
_bamf_dbus_item_application_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__bamf_dbus_item_application_skeleton_vtable;
}

static GVariant *
_bamf_dbus_item_application_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (__bamf_dbus_item_application_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __bamf_dbus_item_application_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __bamf_dbus_item_application_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __bamf_dbus_item_application_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.application", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
_bamf_dbus_item_application_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
__bamf_dbus_item_application_on_signal_window_removed (
    BamfDBusItemApplication *object,
    const gchar *arg_path)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.application", "WindowRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_application_on_signal_window_added (
    BamfDBusItemApplication *object,
    const gchar *arg_path)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.application", "WindowAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_application_on_signal_supported_mime_types_changed (
    BamfDBusItemApplication *object,
    const gchar *const *arg_dnd_mimes)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(^as)",
                   arg_dnd_mimes));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.application", "SupportedMimeTypesChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_application_on_signal_desktop_file_updated (
    BamfDBusItemApplication *object,
    const gchar *arg_desktop_file)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_desktop_file));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.application", "DesktopFileUpdated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void _bamf_dbus_item_application_skeleton_iface_init (BamfDBusItemApplicationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemApplicationSkeleton, _bamf_dbus_item_application_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (BamfDBusItemApplicationSkeleton)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_APPLICATION, _bamf_dbus_item_application_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemApplicationSkeleton, _bamf_dbus_item_application_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_APPLICATION, _bamf_dbus_item_application_skeleton_iface_init))

#endif
static void
_bamf_dbus_item_application_skeleton_finalize (GObject *object)
{
  BamfDBusItemApplicationSkeleton *skeleton = BAMF_DBUS_ITEM_APPLICATION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_bamf_dbus_item_application_skeleton_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_application_skeleton_init (BamfDBusItemApplicationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _bamf_dbus_item_application_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BAMF_DBUS_ITEM_TYPE_APPLICATION_SKELETON, BamfDBusItemApplicationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
_bamf_dbus_item_application_skeleton_class_init (BamfDBusItemApplicationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _bamf_dbus_item_application_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _bamf_dbus_item_application_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _bamf_dbus_item_application_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _bamf_dbus_item_application_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _bamf_dbus_item_application_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemApplicationSkeletonPrivate));
#endif
}

static void
_bamf_dbus_item_application_skeleton_iface_init (BamfDBusItemApplicationIface *iface)
{
  iface->window_removed = __bamf_dbus_item_application_on_signal_window_removed;
  iface->window_added = __bamf_dbus_item_application_on_signal_window_added;
  iface->supported_mime_types_changed = __bamf_dbus_item_application_on_signal_supported_mime_types_changed;
  iface->desktop_file_updated = __bamf_dbus_item_application_on_signal_desktop_file_updated;
}

/**
 * _bamf_dbus_item_application_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link>.
 *
 * Returns: (transfer full) (type BamfDBusItemApplicationSkeleton): The skeleton object.
 */
BamfDBusItemApplication *
_bamf_dbus_item_application_skeleton_new (void)
{
  return BAMF_DBUS_ITEM_APPLICATION (g_object_new (BAMF_DBUS_ITEM_TYPE_APPLICATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.ayatana.bamf.window
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BamfDBusItemWindow
 * @title: BamfDBusItemWindow
 * @short_description: Generated C code for the org.ayatana.bamf.window D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link> D-Bus interface in C.
 */

enum
{
  BAMF_DBUS_ITEM__WINDOW_MONITOR_CHANGED,
  BAMF_DBUS_ITEM__WINDOW_MAXIMIZED_CHANGED,
};

static unsigned BAMF_DBUS_ITEM__WINDOW_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.ayatana.bamf.window ---- */

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_get_xid_OUT_ARG_xid =
{
  {
    -1,
    (gchar *) "xid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_get_xid_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_get_xid_OUT_ARG_xid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_get_xid =
{
  {
    -1,
    (gchar *) "GetXid",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_get_xid_OUT_ARG_pointers,
    NULL
  },
  "handle-get-xid",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_get_pid_OUT_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_get_pid_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_get_pid_OUT_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_get_pid =
{
  {
    -1,
    (gchar *) "GetPid",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_get_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-get-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_transient_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_transient_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_transient_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_transient =
{
  {
    -1,
    (gchar *) "Transient",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_transient_OUT_ARG_pointers,
    NULL
  },
  "handle-transient",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_window_type_OUT_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_window_type_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_window_type_OUT_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_window_type =
{
  {
    -1,
    (gchar *) "WindowType",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_window_type_OUT_ARG_pointers,
    NULL
  },
  "handle-window-type",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_xprop_IN_ARG_xprop =
{
  {
    -1,
    (gchar *) "xprop",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_xprop_IN_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_xprop_IN_ARG_xprop.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_xprop_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_xprop_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_xprop_OUT_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_xprop =
{
  {
    -1,
    (gchar *) "Xprop",
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_xprop_IN_ARG_pointers,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_xprop_OUT_ARG_pointers,
    NULL
  },
  "handle-xprop",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_monitor_OUT_ARG_monitor_number =
{
  {
    -1,
    (gchar *) "monitor_number",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_monitor_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_monitor_OUT_ARG_monitor_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_monitor =
{
  {
    -1,
    (gchar *) "Monitor",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_method_info_maximized_OUT_ARG_maximized =
{
  {
    -1,
    (gchar *) "maximized",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_method_info_maximized_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_window_method_info_maximized_OUT_ARG_maximized.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_window_method_info_maximized =
{
  {
    -1,
    (gchar *) "Maximized",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_window_method_info_maximized_OUT_ARG_pointers,
    NULL
  },
  "handle-maximized",
  FALSE
};

static const GDBusMethodInfo * const __bamf_dbus_item_window_method_info_pointers[] =
{
  &__bamf_dbus_item_window_method_info_get_xid.parent_struct,
  &__bamf_dbus_item_window_method_info_get_pid.parent_struct,
  &__bamf_dbus_item_window_method_info_transient.parent_struct,
  &__bamf_dbus_item_window_method_info_window_type.parent_struct,
  &__bamf_dbus_item_window_method_info_xprop.parent_struct,
  &__bamf_dbus_item_window_method_info_monitor.parent_struct,
  &__bamf_dbus_item_window_method_info_maximized.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_signal_info_monitor_changed_ARG_old =
{
  {
    -1,
    (gchar *) "old",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_signal_info_monitor_changed_ARG_new =
{
  {
    -1,
    (gchar *) "new",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_signal_info_monitor_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_window_signal_info_monitor_changed_ARG_old.parent_struct,
  &__bamf_dbus_item_window_signal_info_monitor_changed_ARG_new.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_window_signal_info_monitor_changed =
{
  {
    -1,
    (gchar *) "MonitorChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_window_signal_info_monitor_changed_ARG_pointers,
    NULL
  },
  "monitor-changed"
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_signal_info_maximized_changed_ARG_old =
{
  {
    -1,
    (gchar *) "old",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_window_signal_info_maximized_changed_ARG_new =
{
  {
    -1,
    (gchar *) "new",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_window_signal_info_maximized_changed_ARG_pointers[] =
{
  &__bamf_dbus_item_window_signal_info_maximized_changed_ARG_old.parent_struct,
  &__bamf_dbus_item_window_signal_info_maximized_changed_ARG_new.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __bamf_dbus_item_window_signal_info_maximized_changed =
{
  {
    -1,
    (gchar *) "MaximizedChanged",
    (GDBusArgInfo **) &__bamf_dbus_item_window_signal_info_maximized_changed_ARG_pointers,
    NULL
  },
  "maximized-changed"
};

static const GDBusSignalInfo * const __bamf_dbus_item_window_signal_info_pointers[] =
{
  &__bamf_dbus_item_window_signal_info_monitor_changed.parent_struct,
  &__bamf_dbus_item_window_signal_info_maximized_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __bamf_dbus_item_window_interface_info =
{
  {
    -1,
    (gchar *) "org.ayatana.bamf.window",
    (GDBusMethodInfo **) &__bamf_dbus_item_window_method_info_pointers,
    (GDBusSignalInfo **) &__bamf_dbus_item_window_signal_info_pointers,
    NULL,
    NULL
  },
  "window",
};


/**
 * _bamf_dbus_item_window_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_bamf_dbus_item_window_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__bamf_dbus_item_window_interface_info.parent_struct;
}

/**
 * _bamf_dbus_item_window_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #BamfDBusItemWindow interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_bamf_dbus_item_window_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
_bamf_dbus_item_window_signal_marshal_monitor_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_signal_marshal_maximized_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_get_xid (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_get_pid (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_transient (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_window_type (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_xprop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_monitor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_window_method_marshal_maximized (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * BamfDBusItemWindow:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link>.
 */

/**
 * BamfDBusItemWindowIface:
 * @parent_iface: The parent interface.
 * @handle_get_pid: Handler for the #BamfDBusItemWindow::handle-get-pid signal.
 * @handle_get_xid: Handler for the #BamfDBusItemWindow::handle-get-xid signal.
 * @handle_maximized: Handler for the #BamfDBusItemWindow::handle-maximized signal.
 * @handle_monitor: Handler for the #BamfDBusItemWindow::handle-monitor signal.
 * @handle_transient: Handler for the #BamfDBusItemWindow::handle-transient signal.
 * @handle_window_type: Handler for the #BamfDBusItemWindow::handle-window-type signal.
 * @handle_xprop: Handler for the #BamfDBusItemWindow::handle-xprop signal.
 * @maximized_changed: Handler for the #BamfDBusItemWindow::maximized-changed signal.
 * @monitor_changed: Handler for the #BamfDBusItemWindow::monitor-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link>.
 */

typedef BamfDBusItemWindowIface BamfDBusItemWindowInterface;
G_DEFINE_INTERFACE (BamfDBusItemWindow, _bamf_dbus_item_window, G_TYPE_OBJECT)

static void
_bamf_dbus_item_window_default_init (BamfDBusItemWindowIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * BamfDBusItemWindow::handle-get-xid:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.GetXid">GetXid()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_get_xid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-xid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_get_xid),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_get_xid,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemWindow::handle-get-pid:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.GetPid">GetPid()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_get_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_get_pid),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_get_pid,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemWindow::handle-transient:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.Transient">Transient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_transient() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-transient",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_transient),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_transient,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemWindow::handle-window-type:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.WindowType">WindowType()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_window_type() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-window-type",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_window_type),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_window_type,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemWindow::handle-xprop:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_xprop: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.Xprop">Xprop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_xprop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-xprop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_xprop),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_xprop,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * BamfDBusItemWindow::handle-monitor:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.Monitor">Monitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_monitor),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_monitor,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemWindow::handle-maximized:
   * @object: A #BamfDBusItemWindow.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-window.Maximized">Maximized()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_window_complete_maximized() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-maximized",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemWindowIface, handle_maximized),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_window_method_marshal_maximized,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * BamfDBusItemWindow::monitor-changed:
   * @object: A #BamfDBusItemWindow.
   * @arg_old: Argument.
   * @arg_new: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-window.MonitorChanged">"MonitorChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__WINDOW_SIGNALS[BAMF_DBUS_ITEM__WINDOW_MONITOR_CHANGED] =
    g_signal_new ("monitor-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemWindowIface, monitor_changed),
      NULL,
      NULL,
      _bamf_dbus_item_window_signal_marshal_monitor_changed,
      G_TYPE_NONE,
      2, G_TYPE_INT, G_TYPE_INT);

  /**
   * BamfDBusItemWindow::maximized-changed:
   * @object: A #BamfDBusItemWindow.
   * @arg_old: Argument.
   * @arg_new: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ayatana-bamf-window.MaximizedChanged">"MaximizedChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  BAMF_DBUS_ITEM__WINDOW_SIGNALS[BAMF_DBUS_ITEM__WINDOW_MAXIMIZED_CHANGED] =
    g_signal_new ("maximized-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (BamfDBusItemWindowIface, maximized_changed),
      NULL,
      NULL,
      _bamf_dbus_item_window_signal_marshal_maximized_changed,
      G_TYPE_NONE,
      2, G_TYPE_INT, G_TYPE_INT);

}

/**
 * _bamf_dbus_item_window_emit_monitor_changed:
 * @object: A #BamfDBusItemWindow.
 * @arg_old: Argument to pass with the signal.
 * @arg_new: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-window.MonitorChanged">"MonitorChanged"</link> D-Bus signal.
 */
void
_bamf_dbus_item_window_emit_monitor_changed (
    BamfDBusItemWindow *object,
    gint arg_old,
    gint arg_new)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__WINDOW_SIGNALS[BAMF_DBUS_ITEM__WINDOW_MONITOR_CHANGED], 0, arg_old, arg_new);
}

/**
 * _bamf_dbus_item_window_emit_maximized_changed:
 * @object: A #BamfDBusItemWindow.
 * @arg_old: Argument to pass with the signal.
 * @arg_new: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ayatana-bamf-window.MaximizedChanged">"MaximizedChanged"</link> D-Bus signal.
 */
void
_bamf_dbus_item_window_emit_maximized_changed (
    BamfDBusItemWindow *object,
    gint arg_old,
    gint arg_new)
{
  g_signal_emit (object, BAMF_DBUS_ITEM__WINDOW_SIGNALS[BAMF_DBUS_ITEM__WINDOW_MAXIMIZED_CHANGED], 0, arg_old, arg_new);
}

/**
 * _bamf_dbus_item_window_call_get_xid:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.GetXid">GetXid()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_get_xid_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_get_xid_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_get_xid (
    BamfDBusItemWindow *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetXid",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_get_xid_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_xid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_get_xid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_get_xid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_get_xid_finish (
    BamfDBusItemWindow *proxy,
    guint *out_xid,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_xid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_get_xid_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_xid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.GetXid">GetXid()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_get_xid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_get_xid_sync (
    BamfDBusItemWindow *proxy,
    guint *out_xid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetXid",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_xid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_get_pid:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.GetPid">GetPid()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_get_pid_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_get_pid_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_get_pid (
    BamfDBusItemWindow *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPid",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_get_pid_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_get_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_get_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_get_pid_finish (
    BamfDBusItemWindow *proxy,
    guint *out_pid,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_get_pid_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.GetPid">GetPid()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_get_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_get_pid_sync (
    BamfDBusItemWindow *proxy,
    guint *out_pid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPid",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_transient:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Transient">Transient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_transient_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_transient_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_transient (
    BamfDBusItemWindow *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Transient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_transient_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_transient().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_transient().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_transient_finish (
    BamfDBusItemWindow *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_transient_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Transient">Transient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_transient() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_transient_sync (
    BamfDBusItemWindow *proxy,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Transient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_window_type:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.WindowType">WindowType()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_window_type_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_window_type_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_window_type (
    BamfDBusItemWindow *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "WindowType",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_window_type_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_window_type().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_window_type().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_window_type_finish (
    BamfDBusItemWindow *proxy,
    guint *out_type,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_type);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_window_type_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.WindowType">WindowType()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_window_type() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_window_type_sync (
    BamfDBusItemWindow *proxy,
    guint *out_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "WindowType",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_type);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_xprop:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @arg_xprop: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Xprop">Xprop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_xprop_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_xprop_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_xprop (
    BamfDBusItemWindow *proxy,
    const gchar *arg_xprop,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Xprop",
    g_variant_new ("(s)",
                   arg_xprop),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_xprop_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_xprop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_xprop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_xprop_finish (
    BamfDBusItemWindow *proxy,
    gchar **out_name,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_xprop_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @arg_xprop: Argument to pass with the method invocation.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Xprop">Xprop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_xprop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_xprop_sync (
    BamfDBusItemWindow *proxy,
    const gchar *arg_xprop,
    gchar **out_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Xprop",
    g_variant_new ("(s)",
                   arg_xprop),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_monitor:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Monitor">Monitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_monitor_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_monitor_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_monitor (
    BamfDBusItemWindow *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Monitor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_monitor_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_monitor_number: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_monitor_finish (
    BamfDBusItemWindow *proxy,
    gint *out_monitor_number,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_monitor_number);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_monitor_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_monitor_number: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Monitor">Monitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_monitor_sync (
    BamfDBusItemWindow *proxy,
    gint *out_monitor_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Monitor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_monitor_number);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_maximized:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Maximized">Maximized()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_call_maximized_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_call_maximized_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_window_call_maximized (
    BamfDBusItemWindow *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Maximized",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_window_call_maximized_finish:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_maximized: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_call_maximized().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_window_call_maximized().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_maximized_finish (
    BamfDBusItemWindow *proxy,
    gint *out_maximized,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_maximized);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_call_maximized_sync:
 * @proxy: A #BamfDBusItemWindowProxy.
 * @out_maximized: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-window.Maximized">Maximized()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_call_maximized() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_window_call_maximized_sync (
    BamfDBusItemWindow *proxy,
    gint *out_maximized,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Maximized",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_maximized);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_window_complete_get_xid:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @xid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.GetXid">GetXid()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_get_xid (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint xid)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   xid));
}

/**
 * _bamf_dbus_item_window_complete_get_pid:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @pid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.GetPid">GetPid()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_get_pid (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint pid)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   pid));
}

/**
 * _bamf_dbus_item_window_complete_transient:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.Transient">Transient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_transient (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   path));
}

/**
 * _bamf_dbus_item_window_complete_window_type:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @type: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.WindowType">WindowType()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_window_type (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint type)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   type));
}

/**
 * _bamf_dbus_item_window_complete_xprop:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.Xprop">Xprop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_xprop (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *name)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   name));
}

/**
 * _bamf_dbus_item_window_complete_monitor:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @monitor_number: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.Monitor">Monitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_monitor (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint monitor_number)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   monitor_number));
}

/**
 * _bamf_dbus_item_window_complete_maximized:
 * @object: A #BamfDBusItemWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @maximized: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-window.Maximized">Maximized()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_window_complete_maximized (
    BamfDBusItemWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint maximized)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   maximized));
}

/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemWindowProxy:
 *
 * The #BamfDBusItemWindowProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemWindowProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemWindowProxy.
 */

struct _BamfDBusItemWindowProxyPrivate
{
  GData *qdata;
};

static void _bamf_dbus_item_window_proxy_iface_init (BamfDBusItemWindowIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemWindowProxy, _bamf_dbus_item_window_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (BamfDBusItemWindowProxy)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_WINDOW, _bamf_dbus_item_window_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemWindowProxy, _bamf_dbus_item_window_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_WINDOW, _bamf_dbus_item_window_proxy_iface_init))

#endif
static void
_bamf_dbus_item_window_proxy_finalize (GObject *object)
{
  BamfDBusItemWindowProxy *proxy = BAMF_DBUS_ITEM_WINDOW_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_bamf_dbus_item_window_proxy_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_window_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_window_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_window_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__bamf_dbus_item_window_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BAMF_DBUS_ITEM_TYPE_WINDOW);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_WINDOW);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_bamf_dbus_item_window_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  BamfDBusItemWindowProxy *proxy = BAMF_DBUS_ITEM_WINDOW_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_window_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_window_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
_bamf_dbus_item_window_proxy_init (BamfDBusItemWindowProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _bamf_dbus_item_window_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BAMF_DBUS_ITEM_TYPE_WINDOW_PROXY, BamfDBusItemWindowProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _bamf_dbus_item_window_interface_info ());
}

static void
_bamf_dbus_item_window_proxy_class_init (BamfDBusItemWindowProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _bamf_dbus_item_window_proxy_finalize;
  gobject_class->get_property = _bamf_dbus_item_window_proxy_get_property;
  gobject_class->set_property = _bamf_dbus_item_window_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _bamf_dbus_item_window_proxy_g_signal;
  proxy_class->g_properties_changed = _bamf_dbus_item_window_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemWindowProxyPrivate));
#endif
}

static void
_bamf_dbus_item_window_proxy_iface_init (BamfDBusItemWindowIface *iface G_GNUC_UNUSED)
{
}

/**
 * _bamf_dbus_item_window_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_proxy_new_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_window_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_WINDOW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.window", NULL);
}

/**
 * _bamf_dbus_item_window_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_window_proxy_new().
 *
 * Returns: (transfer full) (type BamfDBusItemWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemWindow *
_bamf_dbus_item_window_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_WINDOW (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_window_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemWindow *
_bamf_dbus_item_window_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_WINDOW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.window", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_WINDOW (ret);
  else
    return NULL;
}


/**
 * _bamf_dbus_item_window_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _bamf_dbus_item_window_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_window_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_window_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_window_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_WINDOW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.window", NULL);
}

/**
 * _bamf_dbus_item_window_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_window_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_window_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type BamfDBusItemWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemWindow *
_bamf_dbus_item_window_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_WINDOW (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_window_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _bamf_dbus_item_window_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_window_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemWindow *
_bamf_dbus_item_window_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_WINDOW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.window", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_WINDOW (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemWindowSkeleton:
 *
 * The #BamfDBusItemWindowSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemWindowSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemWindowSkeleton.
 */

struct _BamfDBusItemWindowSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__bamf_dbus_item_window_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BAMF_DBUS_ITEM_TYPE_WINDOW);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_WINDOW);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__bamf_dbus_item_window_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_window_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__bamf_dbus_item_window_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_window_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __bamf_dbus_item_window_skeleton_vtable =
{
  __bamf_dbus_item_window_skeleton_handle_method_call,
  __bamf_dbus_item_window_skeleton_handle_get_property,
  __bamf_dbus_item_window_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_bamf_dbus_item_window_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _bamf_dbus_item_window_interface_info ();
}

static GDBusInterfaceVTable *
_bamf_dbus_item_window_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__bamf_dbus_item_window_skeleton_vtable;
}

static GVariant *
_bamf_dbus_item_window_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (__bamf_dbus_item_window_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __bamf_dbus_item_window_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __bamf_dbus_item_window_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __bamf_dbus_item_window_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.window", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
_bamf_dbus_item_window_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
__bamf_dbus_item_window_on_signal_monitor_changed (
    BamfDBusItemWindow *object,
    gint arg_old,
    gint arg_new)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ii)",
                   arg_old,
                   arg_new));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.window", "MonitorChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__bamf_dbus_item_window_on_signal_maximized_changed (
    BamfDBusItemWindow *object,
    gint arg_old,
    gint arg_new)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ii)",
                   arg_old,
                   arg_new));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.window", "MaximizedChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void _bamf_dbus_item_window_skeleton_iface_init (BamfDBusItemWindowIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemWindowSkeleton, _bamf_dbus_item_window_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (BamfDBusItemWindowSkeleton)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_WINDOW, _bamf_dbus_item_window_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemWindowSkeleton, _bamf_dbus_item_window_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_WINDOW, _bamf_dbus_item_window_skeleton_iface_init))

#endif
static void
_bamf_dbus_item_window_skeleton_finalize (GObject *object)
{
  BamfDBusItemWindowSkeleton *skeleton = BAMF_DBUS_ITEM_WINDOW_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_bamf_dbus_item_window_skeleton_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_window_skeleton_init (BamfDBusItemWindowSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _bamf_dbus_item_window_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BAMF_DBUS_ITEM_TYPE_WINDOW_SKELETON, BamfDBusItemWindowSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
_bamf_dbus_item_window_skeleton_class_init (BamfDBusItemWindowSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _bamf_dbus_item_window_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _bamf_dbus_item_window_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _bamf_dbus_item_window_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _bamf_dbus_item_window_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _bamf_dbus_item_window_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemWindowSkeletonPrivate));
#endif
}

static void
_bamf_dbus_item_window_skeleton_iface_init (BamfDBusItemWindowIface *iface)
{
  iface->monitor_changed = __bamf_dbus_item_window_on_signal_monitor_changed;
  iface->maximized_changed = __bamf_dbus_item_window_on_signal_maximized_changed;
}

/**
 * _bamf_dbus_item_window_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link>.
 *
 * Returns: (transfer full) (type BamfDBusItemWindowSkeleton): The skeleton object.
 */
BamfDBusItemWindow *
_bamf_dbus_item_window_skeleton_new (void)
{
  return BAMF_DBUS_ITEM_WINDOW (g_object_new (BAMF_DBUS_ITEM_TYPE_WINDOW_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.ayatana.bamf.tab
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BamfDBusItemTab
 * @title: BamfDBusItemTab
 * @short_description: Generated C code for the org.ayatana.bamf.tab D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.ayatana.bamf.tab ---- */

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_tab_method_info_raise =
{
  {
    -1,
    (gchar *) "Raise",
    NULL,
    NULL,
    NULL
  },
  "handle-raise",
  FALSE
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_tab_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const _ExtendedGDBusArgInfo __bamf_dbus_item_tab_method_info_request_preview_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __bamf_dbus_item_tab_method_info_request_preview_OUT_ARG_pointers[] =
{
  &__bamf_dbus_item_tab_method_info_request_preview_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __bamf_dbus_item_tab_method_info_request_preview =
{
  {
    -1,
    (gchar *) "RequestPreview",
    NULL,
    (GDBusArgInfo **) &__bamf_dbus_item_tab_method_info_request_preview_OUT_ARG_pointers,
    NULL
  },
  "handle-request-preview",
  FALSE
};

static const GDBusMethodInfo * const __bamf_dbus_item_tab_method_info_pointers[] =
{
  &__bamf_dbus_item_tab_method_info_raise.parent_struct,
  &__bamf_dbus_item_tab_method_info_close.parent_struct,
  &__bamf_dbus_item_tab_method_info_request_preview.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_tab_property_info_location =
{
  {
    -1,
    (gchar *) "location",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_tab_property_info_xid =
{
  {
    -1,
    (gchar *) "xid",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "xid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_tab_property_info_desktop_id =
{
  {
    -1,
    (gchar *) "desktop-id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "desktop-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __bamf_dbus_item_tab_property_info_is_foreground_tab =
{
  {
    -1,
    (gchar *) "is-foreground-tab",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "is-foreground-tab",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const __bamf_dbus_item_tab_property_info_pointers[] =
{
  &__bamf_dbus_item_tab_property_info_location.parent_struct,
  &__bamf_dbus_item_tab_property_info_xid.parent_struct,
  &__bamf_dbus_item_tab_property_info_desktop_id.parent_struct,
  &__bamf_dbus_item_tab_property_info_is_foreground_tab.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __bamf_dbus_item_tab_interface_info =
{
  {
    -1,
    (gchar *) "org.ayatana.bamf.tab",
    (GDBusMethodInfo **) &__bamf_dbus_item_tab_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &__bamf_dbus_item_tab_property_info_pointers,
    NULL
  },
  "tab",
};


/**
 * _bamf_dbus_item_tab_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_bamf_dbus_item_tab_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__bamf_dbus_item_tab_interface_info.parent_struct;
}

/**
 * _bamf_dbus_item_tab_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #BamfDBusItemTab interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_bamf_dbus_item_tab_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "location");
  g_object_class_override_property (klass, property_id_begin++, "xid");
  g_object_class_override_property (klass, property_id_begin++, "desktop-id");
  g_object_class_override_property (klass, property_id_begin++, "is-foreground-tab");
  return property_id_begin - 1;
}


inline static void
_bamf_dbus_item_tab_method_marshal_raise (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_tab_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_bamf_dbus_item_tab_method_marshal_request_preview (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * BamfDBusItemTab:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link>.
 */

/**
 * BamfDBusItemTabIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #BamfDBusItemTab::handle-close signal.
 * @handle_raise: Handler for the #BamfDBusItemTab::handle-raise signal.
 * @handle_request_preview: Handler for the #BamfDBusItemTab::handle-request-preview signal.
 * @get_desktop_id: Getter for the #BamfDBusItemTab:desktop-id property.
 * @get_is_foreground_tab: Getter for the #BamfDBusItemTab:is-foreground-tab property.
 * @get_location: Getter for the #BamfDBusItemTab:location property.
 * @get_xid: Getter for the #BamfDBusItemTab:xid property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link>.
 */

typedef BamfDBusItemTabIface BamfDBusItemTabInterface;
G_DEFINE_INTERFACE (BamfDBusItemTab, _bamf_dbus_item_tab, G_TYPE_OBJECT)

static void
_bamf_dbus_item_tab_default_init (BamfDBusItemTabIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * BamfDBusItemTab::handle-raise:
   * @object: A #BamfDBusItemTab.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-tab.Raise">Raise()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_tab_complete_raise() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-raise",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemTabIface, handle_raise),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_tab_method_marshal_raise,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemTab::handle-close:
   * @object: A #BamfDBusItemTab.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-tab.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_tab_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemTabIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_tab_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BamfDBusItemTab::handle-request-preview:
   * @object: A #BamfDBusItemTab.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ayatana-bamf-tab.RequestPreview">RequestPreview()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _bamf_dbus_item_tab_complete_request_preview() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-preview",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BamfDBusItemTabIface, handle_request_preview),
    g_signal_accumulator_true_handled,
    NULL,
      _bamf_dbus_item_tab_method_marshal_request_preview,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * BamfDBusItemTab:location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-tab.location">"location"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("location", "location", "location", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemTab:xid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-tab.xid">"xid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("xid", "xid", "xid", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemTab:desktop-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-tab.desktop-id">"desktop-id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BamfDBusItemTab:is-foreground-tab:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-ayatana-bamf-tab.is-foreground-tab">"is-foreground-tab"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("is-foreground-tab", "is-foreground-tab", "is-foreground-tab", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * _bamf_dbus_item_tab_get_location: (skip)
 * @object: A #BamfDBusItemTab.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-tab.location">"location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _bamf_dbus_item_tab_dup_location() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
_bamf_dbus_item_tab_get_location (BamfDBusItemTab *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_TAB (object), NULL);

  return BAMF_DBUS_ITEM_TAB_GET_IFACE (object)->get_location (object);
}

/**
 * _bamf_dbus_item_tab_dup_location: (skip)
 * @object: A #BamfDBusItemTab.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-ayatana-bamf-tab.location">"location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
_bamf_dbus_item_tab_dup_location (BamfDBusItemTab *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "location", &value, NULL);
  return value;
}

/**
 * _bamf_dbus_item_tab_set_location: (skip)
 * @object: A #BamfDBusItemTab.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-tab.location">"location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_tab_set_location (BamfDBusItemTab *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "location", value, NULL);
}

/**
 * _bamf_dbus_item_tab_get_xid: (skip)
 * @object: A #BamfDBusItemTab.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-tab.xid">"xid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
_bamf_dbus_item_tab_get_xid (BamfDBusItemTab *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_TAB (object), 0);

  return BAMF_DBUS_ITEM_TAB_GET_IFACE (object)->get_xid (object);
}

/**
 * _bamf_dbus_item_tab_set_xid: (skip)
 * @object: A #BamfDBusItemTab.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-tab.xid">"xid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_tab_set_xid (BamfDBusItemTab *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "xid", value, NULL);
}

/**
 * _bamf_dbus_item_tab_get_desktop_id: (skip)
 * @object: A #BamfDBusItemTab.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-tab.desktop-id">"desktop-id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _bamf_dbus_item_tab_dup_desktop_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
_bamf_dbus_item_tab_get_desktop_id (BamfDBusItemTab *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_TAB (object), NULL);

  return BAMF_DBUS_ITEM_TAB_GET_IFACE (object)->get_desktop_id (object);
}

/**
 * _bamf_dbus_item_tab_dup_desktop_id: (skip)
 * @object: A #BamfDBusItemTab.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-ayatana-bamf-tab.desktop-id">"desktop-id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
_bamf_dbus_item_tab_dup_desktop_id (BamfDBusItemTab *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "desktop-id", &value, NULL);
  return value;
}

/**
 * _bamf_dbus_item_tab_set_desktop_id: (skip)
 * @object: A #BamfDBusItemTab.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-tab.desktop-id">"desktop-id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_tab_set_desktop_id (BamfDBusItemTab *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "desktop-id", value, NULL);
}

/**
 * _bamf_dbus_item_tab_get_is_foreground_tab: (skip)
 * @object: A #BamfDBusItemTab.
 *
 * Gets the value of the <link linkend="gdbus-property-org-ayatana-bamf-tab.is-foreground-tab">"is-foreground-tab"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_bamf_dbus_item_tab_get_is_foreground_tab (BamfDBusItemTab *object)
{
  g_return_val_if_fail (BAMF_DBUS_ITEM_IS_TAB (object), FALSE);

  return BAMF_DBUS_ITEM_TAB_GET_IFACE (object)->get_is_foreground_tab (object);
}

/**
 * _bamf_dbus_item_tab_set_is_foreground_tab: (skip)
 * @object: A #BamfDBusItemTab.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-ayatana-bamf-tab.is-foreground-tab">"is-foreground-tab"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_bamf_dbus_item_tab_set_is_foreground_tab (BamfDBusItemTab *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "is-foreground-tab", value, NULL);
}

/**
 * _bamf_dbus_item_tab_call_raise:
 * @proxy: A #BamfDBusItemTabProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-tab.Raise">Raise()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_tab_call_raise_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_tab_call_raise_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_tab_call_raise (
    BamfDBusItemTab *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Raise",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_tab_call_raise_finish:
 * @proxy: A #BamfDBusItemTabProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_tab_call_raise().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_tab_call_raise().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_tab_call_raise_finish (
    BamfDBusItemTab *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_tab_call_raise_sync:
 * @proxy: A #BamfDBusItemTabProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-tab.Raise">Raise()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_tab_call_raise() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_tab_call_raise_sync (
    BamfDBusItemTab *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Raise",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_tab_call_close:
 * @proxy: A #BamfDBusItemTabProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-tab.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_tab_call_close_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_tab_call_close_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_tab_call_close (
    BamfDBusItemTab *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_tab_call_close_finish:
 * @proxy: A #BamfDBusItemTabProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_tab_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_tab_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_tab_call_close_finish (
    BamfDBusItemTab *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_tab_call_close_sync:
 * @proxy: A #BamfDBusItemTabProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-tab.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_tab_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_tab_call_close_sync (
    BamfDBusItemTab *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_tab_call_request_preview:
 * @proxy: A #BamfDBusItemTabProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-tab.RequestPreview">RequestPreview()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_tab_call_request_preview_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_tab_call_request_preview_sync() for the synchronous, blocking version of this method.
 */
void
_bamf_dbus_item_tab_call_request_preview (
    BamfDBusItemTab *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestPreview",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _bamf_dbus_item_tab_call_request_preview_finish:
 * @proxy: A #BamfDBusItemTabProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_tab_call_request_preview().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _bamf_dbus_item_tab_call_request_preview().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_tab_call_request_preview_finish (
    BamfDBusItemTab *proxy,
    gchar **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_tab_call_request_preview_sync:
 * @proxy: A #BamfDBusItemTabProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ayatana-bamf-tab.RequestPreview">RequestPreview()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_tab_call_request_preview() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_bamf_dbus_item_tab_call_request_preview_sync (
    BamfDBusItemTab *proxy,
    gchar **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestPreview",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _bamf_dbus_item_tab_complete_raise:
 * @object: A #BamfDBusItemTab.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-tab.Raise">Raise()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_tab_complete_raise (
    BamfDBusItemTab *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * _bamf_dbus_item_tab_complete_close:
 * @object: A #BamfDBusItemTab.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-tab.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_tab_complete_close (
    BamfDBusItemTab *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * _bamf_dbus_item_tab_complete_request_preview:
 * @object: A #BamfDBusItemTab.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ayatana-bamf-tab.RequestPreview">RequestPreview()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_bamf_dbus_item_tab_complete_request_preview (
    BamfDBusItemTab *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   data));
}

/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemTabProxy:
 *
 * The #BamfDBusItemTabProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemTabProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemTabProxy.
 */

struct _BamfDBusItemTabProxyPrivate
{
  GData *qdata;
};

static void _bamf_dbus_item_tab_proxy_iface_init (BamfDBusItemTabIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemTabProxy, _bamf_dbus_item_tab_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (BamfDBusItemTabProxy)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_TAB, _bamf_dbus_item_tab_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemTabProxy, _bamf_dbus_item_tab_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_TAB, _bamf_dbus_item_tab_proxy_iface_init))

#endif
static void
_bamf_dbus_item_tab_proxy_finalize (GObject *object)
{
  BamfDBusItemTabProxy *proxy = BAMF_DBUS_ITEM_TAB_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_bamf_dbus_item_tab_proxy_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_tab_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) __bamf_dbus_item_tab_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
_bamf_dbus_item_tab_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.ayatana.bamf.tab: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
_bamf_dbus_item_tab_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) __bamf_dbus_item_tab_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.ayatana.bamf.tab", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) _bamf_dbus_item_tab_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
_bamf_dbus_item_tab_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__bamf_dbus_item_tab_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BAMF_DBUS_ITEM_TYPE_TAB);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_TAB);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_bamf_dbus_item_tab_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  BamfDBusItemTabProxy *proxy = BAMF_DBUS_ITEM_TAB_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_tab_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_tab_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
_bamf_dbus_item_tab_proxy_get_location (BamfDBusItemTab *object)
{
  BamfDBusItemTabProxy *proxy = BAMF_DBUS_ITEM_TAB_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "location");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
_bamf_dbus_item_tab_proxy_get_xid (BamfDBusItemTab *object)
{
  BamfDBusItemTabProxy *proxy = BAMF_DBUS_ITEM_TAB_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "xid");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
_bamf_dbus_item_tab_proxy_get_desktop_id (BamfDBusItemTab *object)
{
  BamfDBusItemTabProxy *proxy = BAMF_DBUS_ITEM_TAB_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "desktop-id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_bamf_dbus_item_tab_proxy_get_is_foreground_tab (BamfDBusItemTab *object)
{
  BamfDBusItemTabProxy *proxy = BAMF_DBUS_ITEM_TAB_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "is-foreground-tab");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
_bamf_dbus_item_tab_proxy_init (BamfDBusItemTabProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _bamf_dbus_item_tab_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BAMF_DBUS_ITEM_TYPE_TAB_PROXY, BamfDBusItemTabProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _bamf_dbus_item_tab_interface_info ());
}

static void
_bamf_dbus_item_tab_proxy_class_init (BamfDBusItemTabProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _bamf_dbus_item_tab_proxy_finalize;
  gobject_class->get_property = _bamf_dbus_item_tab_proxy_get_property;
  gobject_class->set_property = _bamf_dbus_item_tab_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _bamf_dbus_item_tab_proxy_g_signal;
  proxy_class->g_properties_changed = _bamf_dbus_item_tab_proxy_g_properties_changed;

  _bamf_dbus_item_tab_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemTabProxyPrivate));
#endif
}

static void
_bamf_dbus_item_tab_proxy_iface_init (BamfDBusItemTabIface *iface)
{
  iface->get_location = _bamf_dbus_item_tab_proxy_get_location;
  iface->get_xid = _bamf_dbus_item_tab_proxy_get_xid;
  iface->get_desktop_id = _bamf_dbus_item_tab_proxy_get_desktop_id;
  iface->get_is_foreground_tab = _bamf_dbus_item_tab_proxy_get_is_foreground_tab;
}

/**
 * _bamf_dbus_item_tab_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_tab_proxy_new_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_tab_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_tab_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_TAB_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.tab", NULL);
}

/**
 * _bamf_dbus_item_tab_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_tab_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_tab_proxy_new().
 *
 * Returns: (transfer full) (type BamfDBusItemTabProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemTab *
_bamf_dbus_item_tab_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_TAB (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_tab_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_tab_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemTabProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemTab *
_bamf_dbus_item_tab_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_TAB_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.tab", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_TAB (ret);
  else
    return NULL;
}


/**
 * _bamf_dbus_item_tab_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _bamf_dbus_item_tab_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_tab_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_tab_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_tab_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_TAB_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.tab", NULL);
}

/**
 * _bamf_dbus_item_tab_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_tab_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_tab_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type BamfDBusItemTabProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemTab *
_bamf_dbus_item_tab_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_TAB (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_tab_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _bamf_dbus_item_tab_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_tab_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemTabProxy): The constructed proxy object or %NULL if @error is set.
 */
BamfDBusItemTab *
_bamf_dbus_item_tab_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_TAB_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ayatana.bamf.tab", NULL);
  if (ret != NULL)
    return BAMF_DBUS_ITEM_TAB (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * BamfDBusItemTabSkeleton:
 *
 * The #BamfDBusItemTabSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemTabSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemTabSkeleton.
 */

struct _BamfDBusItemTabSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__bamf_dbus_item_tab_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BAMF_DBUS_ITEM_TYPE_TAB);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BAMF_DBUS_ITEM_TYPE_TAB);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__bamf_dbus_item_tab_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_tab_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__bamf_dbus_item_tab_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__bamf_dbus_item_tab_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __bamf_dbus_item_tab_skeleton_vtable =
{
  __bamf_dbus_item_tab_skeleton_handle_method_call,
  __bamf_dbus_item_tab_skeleton_handle_get_property,
  __bamf_dbus_item_tab_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_bamf_dbus_item_tab_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _bamf_dbus_item_tab_interface_info ();
}

static GDBusInterfaceVTable *
_bamf_dbus_item_tab_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__bamf_dbus_item_tab_skeleton_vtable;
}

static GVariant *
_bamf_dbus_item_tab_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (__bamf_dbus_item_tab_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __bamf_dbus_item_tab_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __bamf_dbus_item_tab_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __bamf_dbus_item_tab_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ayatana.bamf.tab", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean __bamf_dbus_item_tab_emit_changed (gpointer user_data);

static void
_bamf_dbus_item_tab_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    __bamf_dbus_item_tab_emit_changed (skeleton);
}

static void _bamf_dbus_item_tab_skeleton_iface_init (BamfDBusItemTabIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemTabSkeleton, _bamf_dbus_item_tab_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (BamfDBusItemTabSkeleton)
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_TAB, _bamf_dbus_item_tab_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BamfDBusItemTabSkeleton, _bamf_dbus_item_tab_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_TAB, _bamf_dbus_item_tab_skeleton_iface_init))

#endif
static void
_bamf_dbus_item_tab_skeleton_finalize (GObject *object)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_bamf_dbus_item_tab_skeleton_parent_class)->finalize (object);
}

static void
_bamf_dbus_item_tab_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
__bamf_dbus_item_tab_emit_changed (gpointer user_data)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.ayatana.bamf.tab",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
__bamf_dbus_item_tab_schedule_emit_changed (BamfDBusItemTabSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
_bamf_dbus_item_tab_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, __bamf_dbus_item_tab_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] __bamf_dbus_item_tab_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
_bamf_dbus_item_tab_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) __bamf_dbus_item_tab_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        __bamf_dbus_item_tab_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
_bamf_dbus_item_tab_skeleton_init (BamfDBusItemTabSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _bamf_dbus_item_tab_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BAMF_DBUS_ITEM_TYPE_TAB_SKELETON, BamfDBusItemTabSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
}

static const gchar *
_bamf_dbus_item_tab_skeleton_get_location (BamfDBusItemTab *object)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
_bamf_dbus_item_tab_skeleton_get_xid (BamfDBusItemTab *object)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
_bamf_dbus_item_tab_skeleton_get_desktop_id (BamfDBusItemTab *object)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_bamf_dbus_item_tab_skeleton_get_is_foreground_tab (BamfDBusItemTab *object)
{
  BamfDBusItemTabSkeleton *skeleton = BAMF_DBUS_ITEM_TAB_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
_bamf_dbus_item_tab_skeleton_class_init (BamfDBusItemTabSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _bamf_dbus_item_tab_skeleton_finalize;
  gobject_class->get_property = _bamf_dbus_item_tab_skeleton_get_property;
  gobject_class->set_property = _bamf_dbus_item_tab_skeleton_set_property;
  gobject_class->notify       = _bamf_dbus_item_tab_skeleton_notify;


  _bamf_dbus_item_tab_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _bamf_dbus_item_tab_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _bamf_dbus_item_tab_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _bamf_dbus_item_tab_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _bamf_dbus_item_tab_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BamfDBusItemTabSkeletonPrivate));
#endif
}

static void
_bamf_dbus_item_tab_skeleton_iface_init (BamfDBusItemTabIface *iface)
{
  iface->get_location = _bamf_dbus_item_tab_skeleton_get_location;
  iface->get_xid = _bamf_dbus_item_tab_skeleton_get_xid;
  iface->get_desktop_id = _bamf_dbus_item_tab_skeleton_get_desktop_id;
  iface->get_is_foreground_tab = _bamf_dbus_item_tab_skeleton_get_is_foreground_tab;
}

/**
 * _bamf_dbus_item_tab_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link>.
 *
 * Returns: (transfer full) (type BamfDBusItemTabSkeleton): The skeleton object.
 */
BamfDBusItemTab *
_bamf_dbus_item_tab_skeleton_new (void)
{
  return BAMF_DBUS_ITEM_TAB (g_object_new (BAMF_DBUS_ITEM_TYPE_TAB_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BamfDBusItemObject
 * @title: BamfDBusItemObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #BamfDBusItemObject, #BamfDBusItemObjectProxy, and #BamfDBusItemObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * BamfDBusItemObject:
 *
 * The #BamfDBusItemObject type is a specialized container of interfaces.
 */

/**
 * BamfDBusItemObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #BamfDBusItemObject interface.
 */

typedef BamfDBusItemObjectIface BamfDBusItemObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (BamfDBusItemObject, _bamf_dbus_item_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
_bamf_dbus_item_object_default_init (BamfDBusItemObjectIface *iface)
{
  /**
   * BamfDBusItemObject:view:
   *
   * The #BamfDBusItemView instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("view", "view", "view", BAMF_DBUS_ITEM_TYPE_VIEW, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * BamfDBusItemObject:application:
   *
   * The #BamfDBusItemApplication instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("application", "application", "application", BAMF_DBUS_ITEM_TYPE_APPLICATION, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * BamfDBusItemObject:window:
   *
   * The #BamfDBusItemWindow instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("window", "window", "window", BAMF_DBUS_ITEM_TYPE_WINDOW, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * BamfDBusItemObject:tab:
   *
   * The #BamfDBusItemTab instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("tab", "tab", "tab", BAMF_DBUS_ITEM_TYPE_TAB, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * _bamf_dbus_item_object_get_view:
 * @object: A #BamfDBusItemObject.
 *
 * Gets the #BamfDBusItemView instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #BamfDBusItemView that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
BamfDBusItemView *_bamf_dbus_item_object_get_view (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.view");
  if (ret == NULL)
    return NULL;
  return BAMF_DBUS_ITEM_VIEW (ret);
}

/**
 * _bamf_dbus_item_object_get_application:
 * @object: A #BamfDBusItemObject.
 *
 * Gets the #BamfDBusItemApplication instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #BamfDBusItemApplication that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
BamfDBusItemApplication *_bamf_dbus_item_object_get_application (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.application");
  if (ret == NULL)
    return NULL;
  return BAMF_DBUS_ITEM_APPLICATION (ret);
}

/**
 * _bamf_dbus_item_object_get_window:
 * @object: A #BamfDBusItemObject.
 *
 * Gets the #BamfDBusItemWindow instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #BamfDBusItemWindow that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
BamfDBusItemWindow *_bamf_dbus_item_object_get_window (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.window");
  if (ret == NULL)
    return NULL;
  return BAMF_DBUS_ITEM_WINDOW (ret);
}

/**
 * _bamf_dbus_item_object_get_tab:
 * @object: A #BamfDBusItemObject.
 *
 * Gets the #BamfDBusItemTab instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #BamfDBusItemTab that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
BamfDBusItemTab *_bamf_dbus_item_object_get_tab (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.tab");
  if (ret == NULL)
    return NULL;
  return BAMF_DBUS_ITEM_TAB (ret);
}


/**
 * _bamf_dbus_item_object_peek_view: (skip)
 * @object: A #BamfDBusItemObject.
 *
 * Like _bamf_dbus_item_object_get_view() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #BamfDBusItemView or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
BamfDBusItemView *_bamf_dbus_item_object_peek_view (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.view");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BAMF_DBUS_ITEM_VIEW (ret);
}

/**
 * _bamf_dbus_item_object_peek_application: (skip)
 * @object: A #BamfDBusItemObject.
 *
 * Like _bamf_dbus_item_object_get_application() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #BamfDBusItemApplication or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
BamfDBusItemApplication *_bamf_dbus_item_object_peek_application (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.application");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BAMF_DBUS_ITEM_APPLICATION (ret);
}

/**
 * _bamf_dbus_item_object_peek_window: (skip)
 * @object: A #BamfDBusItemObject.
 *
 * Like _bamf_dbus_item_object_get_window() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #BamfDBusItemWindow or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
BamfDBusItemWindow *_bamf_dbus_item_object_peek_window (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.window");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BAMF_DBUS_ITEM_WINDOW (ret);
}

/**
 * _bamf_dbus_item_object_peek_tab: (skip)
 * @object: A #BamfDBusItemObject.
 *
 * Like _bamf_dbus_item_object_get_tab() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #BamfDBusItemTab or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
BamfDBusItemTab *_bamf_dbus_item_object_peek_tab (BamfDBusItemObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.tab");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BAMF_DBUS_ITEM_TAB (ret);
}


static void
_bamf_dbus_item_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * BamfDBusItemObjectProxy:
 *
 * The #BamfDBusItemObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemObjectProxy.
 */

static void
_bamf_dbus_item_object_proxy___bamf_dbus_item_object_iface_init (BamfDBusItemObjectIface *iface G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = _bamf_dbus_item_object_notify;
  iface->interface_removed = _bamf_dbus_item_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (BamfDBusItemObjectProxy, _bamf_dbus_item_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_OBJECT, _bamf_dbus_item_object_proxy___bamf_dbus_item_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, _bamf_dbus_item_object_proxy__g_dbus_object_iface_init))

static void
_bamf_dbus_item_object_proxy_init (BamfDBusItemObjectProxy *object G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
_bamf_dbus_item_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  BamfDBusItemObjectProxy *object = BAMF_DBUS_ITEM_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.view");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.application");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.window");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.tab");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
_bamf_dbus_item_object_proxy_class_init (BamfDBusItemObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = _bamf_dbus_item_object_proxy_set_property;
  gobject_class->get_property = _bamf_dbus_item_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "view");
  g_object_class_override_property (gobject_class, 2, "application");
  g_object_class_override_property (gobject_class, 3, "window");
  g_object_class_override_property (gobject_class, 4, "tab");
}

/**
 * _bamf_dbus_item_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
BamfDBusItemObjectProxy *
_bamf_dbus_item_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return BAMF_DBUS_ITEM_OBJECT_PROXY (g_object_new (BAMF_DBUS_ITEM_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * BamfDBusItemObjectSkeleton:
 *
 * The #BamfDBusItemObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemObjectSkeleton.
 */

static void
_bamf_dbus_item_object_skeleton___bamf_dbus_item_object_iface_init (BamfDBusItemObjectIface *iface G_GNUC_UNUSED)
{
}


static void
_bamf_dbus_item_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = _bamf_dbus_item_object_notify;
  iface->interface_removed = _bamf_dbus_item_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (BamfDBusItemObjectSkeleton, _bamf_dbus_item_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (BAMF_DBUS_ITEM_TYPE_OBJECT, _bamf_dbus_item_object_skeleton___bamf_dbus_item_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, _bamf_dbus_item_object_skeleton__g_dbus_object_iface_init))

static void
_bamf_dbus_item_object_skeleton_init (BamfDBusItemObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  BamfDBusItemObjectSkeleton *object = BAMF_DBUS_ITEM_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BAMF_DBUS_ITEM_IS_VIEW (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.ayatana.bamf.view");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BAMF_DBUS_ITEM_IS_APPLICATION (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.ayatana.bamf.application");
        }
      break;

    case 3:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BAMF_DBUS_ITEM_IS_WINDOW (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.ayatana.bamf.window");
        }
      break;

    case 4:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BAMF_DBUS_ITEM_IS_TAB (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.ayatana.bamf.tab");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
_bamf_dbus_item_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  BamfDBusItemObjectSkeleton *object = BAMF_DBUS_ITEM_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.view");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.application");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.window");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.ayatana.bamf.tab");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
_bamf_dbus_item_object_skeleton_class_init (BamfDBusItemObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = _bamf_dbus_item_object_skeleton_set_property;
  gobject_class->get_property = _bamf_dbus_item_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "view");
  g_object_class_override_property (gobject_class, 2, "application");
  g_object_class_override_property (gobject_class, 3, "window");
  g_object_class_override_property (gobject_class, 4, "tab");
}

/**
 * _bamf_dbus_item_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
BamfDBusItemObjectSkeleton *
_bamf_dbus_item_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return BAMF_DBUS_ITEM_OBJECT_SKELETON (g_object_new (BAMF_DBUS_ITEM_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * _bamf_dbus_item_object_skeleton_set_view:
 * @object: A #BamfDBusItemObjectSkeleton.
 * @interface_: (nullable): A #BamfDBusItemView or %NULL to clear the interface.
 *
 * Sets the #BamfDBusItemView instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-view.top_of_page">org.ayatana.bamf.view</link> on @object.
 */
void _bamf_dbus_item_object_skeleton_set_view (BamfDBusItemObjectSkeleton *object, BamfDBusItemView *interface_)
{
  g_object_set (G_OBJECT (object), "view", interface_, NULL);
}

/**
 * _bamf_dbus_item_object_skeleton_set_application:
 * @object: A #BamfDBusItemObjectSkeleton.
 * @interface_: (nullable): A #BamfDBusItemApplication or %NULL to clear the interface.
 *
 * Sets the #BamfDBusItemApplication instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-application.top_of_page">org.ayatana.bamf.application</link> on @object.
 */
void _bamf_dbus_item_object_skeleton_set_application (BamfDBusItemObjectSkeleton *object, BamfDBusItemApplication *interface_)
{
  g_object_set (G_OBJECT (object), "application", interface_, NULL);
}

/**
 * _bamf_dbus_item_object_skeleton_set_window:
 * @object: A #BamfDBusItemObjectSkeleton.
 * @interface_: (nullable): A #BamfDBusItemWindow or %NULL to clear the interface.
 *
 * Sets the #BamfDBusItemWindow instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-window.top_of_page">org.ayatana.bamf.window</link> on @object.
 */
void _bamf_dbus_item_object_skeleton_set_window (BamfDBusItemObjectSkeleton *object, BamfDBusItemWindow *interface_)
{
  g_object_set (G_OBJECT (object), "window", interface_, NULL);
}

/**
 * _bamf_dbus_item_object_skeleton_set_tab:
 * @object: A #BamfDBusItemObjectSkeleton.
 * @interface_: (nullable): A #BamfDBusItemTab or %NULL to clear the interface.
 *
 * Sets the #BamfDBusItemTab instance for the D-Bus interface <link linkend="gdbus-interface-org-ayatana-bamf-tab.top_of_page">org.ayatana.bamf.tab</link> on @object.
 */
void _bamf_dbus_item_object_skeleton_set_tab (BamfDBusItemObjectSkeleton *object, BamfDBusItemTab *interface_)
{
  g_object_set (G_OBJECT (object), "tab", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BamfDBusItemObjectManagerClient
 * @title: BamfDBusItemObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses _bamf_dbus_item_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * BamfDBusItemObjectManagerClient:
 *
 * The #BamfDBusItemObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BamfDBusItemObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BamfDBusItemObjectManagerClient.
 */

G_DEFINE_TYPE (BamfDBusItemObjectManagerClient, _bamf_dbus_item_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
_bamf_dbus_item_object_manager_client_init (BamfDBusItemObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
_bamf_dbus_item_object_manager_client_class_init (BamfDBusItemObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * _bamf_dbus_item_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #BamfDBusItemObjectProxy.
 */
GType
_bamf_dbus_item_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return BAMF_DBUS_ITEM_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.ayatana.bamf.view", (gpointer) (guintptr) (BAMF_DBUS_ITEM_TYPE_VIEW_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.ayatana.bamf.application", (gpointer) (guintptr) (BAMF_DBUS_ITEM_TYPE_APPLICATION_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.ayatana.bamf.window", (gpointer) (guintptr) (BAMF_DBUS_ITEM_TYPE_WINDOW_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.ayatana.bamf.tab", (gpointer) (guintptr) (BAMF_DBUS_ITEM_TYPE_TAB_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * _bamf_dbus_item_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using _bamf_dbus_item_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_object_manager_client_new_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", _bamf_dbus_item_object_manager_client_get_proxy_type, NULL);
}

/**
 * _bamf_dbus_item_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_object_manager_client_new().
 *
 * Returns: (transfer full) (type BamfDBusItemObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
_bamf_dbus_item_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using _bamf_dbus_item_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
_bamf_dbus_item_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", _bamf_dbus_item_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * _bamf_dbus_item_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _bamf_dbus_item_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _bamf_dbus_item_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See _bamf_dbus_item_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_bamf_dbus_item_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (BAMF_DBUS_ITEM_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", _bamf_dbus_item_object_manager_client_get_proxy_type, NULL);
}

/**
 * _bamf_dbus_item_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _bamf_dbus_item_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _bamf_dbus_item_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type BamfDBusItemObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
_bamf_dbus_item_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * _bamf_dbus_item_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _bamf_dbus_item_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _bamf_dbus_item_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BamfDBusItemObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
_bamf_dbus_item_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (BAMF_DBUS_ITEM_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", _bamf_dbus_item_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


