/*
 * Copyright Collabora Ltd
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include <stdint.h>

#pragma once
#include "util/macros.h"

struct panlib_copy_query_result_args {
   uint64_t pool_addr;
   uint64_t available_addr;
   uint32_t query_stride;
   uint32_t first_query;
   uint32_t query_count;
   uint8_t _pad5[4];
   uint64_t dst_addr;
   uint64_t dst_stride;
   uint32_t query_type;
   uint32_t flags;
   uint32_t report_count;
} PACKED;

static_assert(offsetof(struct panlib_copy_query_result_args, pool_addr) == 0, "");
static_assert(offsetof(struct panlib_copy_query_result_args, available_addr) == 8, "");
static_assert(offsetof(struct panlib_copy_query_result_args, query_stride) == 16, "");
static_assert(offsetof(struct panlib_copy_query_result_args, first_query) == 20, "");
static_assert(offsetof(struct panlib_copy_query_result_args, query_count) == 24, "");
static_assert(offsetof(struct panlib_copy_query_result_args, dst_addr) == 32, "");
static_assert(offsetof(struct panlib_copy_query_result_args, dst_stride) == 40, "");
static_assert(offsetof(struct panlib_copy_query_result_args, query_type) == 48, "");
static_assert(offsetof(struct panlib_copy_query_result_args, flags) == 52, "");
static_assert(offsetof(struct panlib_copy_query_result_args, report_count) == 56, "");
static_assert(sizeof(struct panlib_copy_query_result_args) == 60, "");

struct panlib_clear_query_result_args {
   uint64_t pool_addr;
   uint64_t available_addr;
   uint32_t query_stride;
   uint32_t first_query;
   uint32_t query_count;
   uint32_t report_count;
   uint32_t availaible_value;
} PACKED;

static_assert(offsetof(struct panlib_clear_query_result_args, pool_addr) == 0, "");
static_assert(offsetof(struct panlib_clear_query_result_args, available_addr) == 8, "");
static_assert(offsetof(struct panlib_clear_query_result_args, query_stride) == 16, "");
static_assert(offsetof(struct panlib_clear_query_result_args, first_query) == 20, "");
static_assert(offsetof(struct panlib_clear_query_result_args, query_count) == 24, "");
static_assert(offsetof(struct panlib_clear_query_result_args, report_count) == 28, "");
static_assert(offsetof(struct panlib_clear_query_result_args, availaible_value) == 32, "");
static_assert(sizeof(struct panlib_clear_query_result_args) == 36, "");

struct panlib_indirect_dispatch_args {
   uint64_t cmd;
   uint32_t size_x;
   uint32_t size_y;
   uint32_t size_z;
   uint8_t _pad4[4];
   uint64_t indirect_job;
   uint64_t num_wg_sysval_x;
   uint64_t num_wg_sysval_y;
   uint64_t num_wg_sysval_z;
} PACKED;

static_assert(offsetof(struct panlib_indirect_dispatch_args, cmd) == 0, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, size_x) == 8, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, size_y) == 12, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, size_z) == 16, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, indirect_job) == 24, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, num_wg_sysval_x) == 32, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, num_wg_sysval_y) == 40, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, num_wg_sysval_z) == 48, "");
static_assert(sizeof(struct panlib_indirect_dispatch_args) == 56, "");

enum libpan_shaders_program {
    PANLIB_COPY_QUERY_RESULT = 0,
    PANLIB_CLEAR_QUERY_RESULT = 1,
    PANLIB_INDIRECT_DISPATCH = 2,
    LIBPAN_SHADERS_NUM_PROGRAMS,
};


#define panlib_copy_query_result_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_copy_query_result_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_copy_query_result(_context, _grid, _barrier, pool_addr, available_addr, query_stride, first_query, query_count, dst_addr, dst_stride, query_type, flags, report_count) do { \
   struct panlib_copy_query_result_args _args = {pool_addr, available_addr, query_stride, first_query, query_count, {0}, dst_addr, dst_stride, query_type, flags, report_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_clear_query_result_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_clear_query_result_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_clear_query_result(_context, _grid, _barrier, pool_addr, available_addr, query_stride, first_query, query_count, report_count, availaible_value) do { \
   struct panlib_clear_query_result_args _args = {pool_addr, available_addr, query_stride, first_query, query_count, report_count, availaible_value};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_indirect_dispatch_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_indirect_dispatch_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_INDIRECT_DISPATCH, &_args, sizeof(_args)); \
} while(0);

#define panlib_indirect_dispatch(_context, _grid, _barrier, cmd, size_x, size_y, size_z, indirect_job, num_wg_sysval_x, num_wg_sysval_y, num_wg_sysval_z) do { \
   struct panlib_indirect_dispatch_args _args = {cmd, size_x, size_y, size_z, {0}, indirect_job, num_wg_sysval_x, num_wg_sysval_y, num_wg_sysval_z};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_INDIRECT_DISPATCH, &_args, sizeof(_args)); \
} while(0);


extern const uint32_t *libpan_shaders_default_v9[LIBPAN_SHADERS_NUM_PROGRAMS];
