// Copyright 2024 Red Hat Inc.
// SPDX-License-Identifier: MIT

// This file is generated by lat_rs_gen.py. DO NOT EDIT!
#![allow(unused_variables)]

const fn pred(has_pred: bool, a: u32, b: u32) -> u32 {
    if has_pred {
        a + b
    } else {
        b
    }
}

#[derive(PartialEq)]
pub enum PredLatencySM100 {
    DispAlu,
    DispDualAlu,
    Coupled,
    Dualalu,
    R2P,
    R2Ur,
    Fma,
    Fp16,
    Hfma2Mma,
    RedirectedFp64,
    Decoupled,
    Guard,
}

impl PredLatencySM100 {
    pub fn raw(writer: PredLatencySM100, reader: PredLatencySM100, has_pred: bool) -> u32 {
        use PredLatencySM100::*;
        match reader {
            DispAlu => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 13,
                Hfma2Mma => 14,
                RedirectedFp64 => 14,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for DispAlu"),
            },
            DispDualAlu => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 13,
                Hfma2Mma => 14,
                RedirectedFp64 => 14,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for DispDualAlu"),
            },
            Coupled => match writer {
                DispAlu => 4,
                DispDualAlu => 4,
                Coupled => 4,
                Dualalu => 4,
                R2P => 5,
                R2Ur => 8,
                Fma => 5,
                Fp16 => 5,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Coupled"),
            },
            Dualalu => match writer {
                DispAlu => 4,
                DispDualAlu => 4,
                Coupled => 4,
                Dualalu => 4,
                R2P => 5,
                R2Ur => 8,
                Fma => 5,
                Fp16 => 5,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Dualalu"),
            },
            R2P => match writer {
                DispAlu => 4,
                DispDualAlu => 4,
                Coupled => 4,
                Dualalu => 4,
                R2P => 5,
                R2Ur => 8,
                Fma => 5,
                Fp16 => 5,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for R2P"),
            },
            R2Ur => match writer {
                _ => panic!("Illegal writer value in raw for R2Ur"),
            },
            Fma => match writer {
                DispAlu => 5,
                DispDualAlu => 5,
                Coupled => 5,
                Dualalu => 5,
                R2P => 5,
                R2Ur => 13,
                Fma => 4,
                Fp16 => 5,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Fma"),
            },
            Fp16 => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 5,
                Hfma2Mma => 14,
                RedirectedFp64 => 14,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Fp16"),
            },
            Hfma2Mma => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 13,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Hfma2Mma"),
            },
            RedirectedFp64 => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 13,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for RedirectedFp64"),
            },
            Decoupled => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 13,
                Hfma2Mma => 14,
                RedirectedFp64 => 14,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Decoupled"),
            },
            Guard => match writer {
                DispAlu => 13,
                DispDualAlu => 13,
                Coupled => 13,
                Dualalu => 13,
                R2P => 13,
                R2Ur => 13,
                Fma => 13,
                Fp16 => 13,
                Hfma2Mma => 14,
                RedirectedFp64 => 14,
                Decoupled => 1,

                _ => panic!("Illegal writer value in raw for Guard"),
            },
        }
    }
    pub fn war(reader: PredLatencySM100, writer: PredLatencySM100, has_pred: bool) -> u32 {
        use PredLatencySM100::*;
        match writer {
            DispAlu => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for DispAlu"),
            },
            DispDualAlu => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for DispDualAlu"),
            },
            Coupled => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for Coupled"),
            },
            Dualalu => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for Dualalu"),
            },
            R2P => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for R2P"),
            },
            R2Ur => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for R2Ur"),
            },
            Fma => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for Fma"),
            },
            Fp16 => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for Fp16"),
            },
            Hfma2Mma => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for Hfma2Mma"),
            },
            RedirectedFp64 => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for RedirectedFp64"),
            },
            Decoupled => match reader {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,

                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,
                Guard => 1,
                _ => panic!("Illegal reader value in war for Decoupled"),
            },
            Guard => match reader {
                _ => panic!("Illegal reader value in war for Guard"),
            },
        }
    }
    pub fn waw(writer1: PredLatencySM100, writer2: PredLatencySM100, has_pred: bool) -> u32 {
        use PredLatencySM100::*;
        match writer2 {
            DispAlu => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => pred(has_pred, 1, 7),
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for DispAlu"),
            },
            DispDualAlu => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => pred(has_pred, 1, 7),
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for DispDualAlu"),
            },
            Coupled => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => pred(has_pred, 1, 7),
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for Coupled"),
            },
            Dualalu => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => pred(has_pred, 1, 7),
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for Dualalu"),
            },
            R2P => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => pred(has_pred, 1, 7),
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for R2P"),
            },
            R2Ur => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => 1,
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for R2Ur"),
            },
            Fma => match writer1 {
                DispAlu => 1,
                DispDualAlu => 1,
                Coupled => 1,
                Dualalu => 1,
                R2P => 1,
                R2Ur => pred(has_pred, 1, 8),
                Fma => 1,
                Fp16 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for Fma"),
            },
            Fp16 => match writer1 {
                DispAlu => pred(has_pred, 2, 6),
                DispDualAlu => pred(has_pred, 2, 6),
                Coupled => pred(has_pred, 2, 6),
                Dualalu => pred(has_pred, 2, 6),
                R2P => pred(has_pred, 2, 6),
                R2Ur => pred(has_pred, 2, 6),
                Fma => pred(has_pred, 2, 6),
                Fp16 => 1,
                Hfma2Mma => pred(has_pred, 2, 7),
                RedirectedFp64 => pred(has_pred, 2, 7),
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for Fp16"),
            },
            Hfma2Mma => match writer1 {
                DispAlu => pred(has_pred, 2, 5),
                DispDualAlu => pred(has_pred, 2, 5),
                Coupled => pred(has_pred, 2, 5),
                Dualalu => pred(has_pred, 2, 5),
                R2P => pred(has_pred, 2, 5),
                R2Ur => pred(has_pred, 2, 5),
                Fma => pred(has_pred, 2, 5),
                Fp16 => pred(has_pred, 2, 5),
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for Hfma2Mma"),
            },
            RedirectedFp64 => match writer1 {
                DispAlu => pred(has_pred, 2, 5),
                DispDualAlu => pred(has_pred, 2, 5),
                Coupled => pred(has_pred, 2, 5),
                Dualalu => pred(has_pred, 2, 5),
                R2P => pred(has_pred, 2, 5),
                R2Ur => pred(has_pred, 2, 5),
                Fma => pred(has_pred, 2, 5),
                Fp16 => pred(has_pred, 2, 5),
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for RedirectedFp64"),
            },
            Decoupled => match writer1 {
                DispAlu => pred(has_pred, 2, 10),
                DispDualAlu => pred(has_pred, 2, 10),
                Coupled => pred(has_pred, 2, 10),
                Dualalu => pred(has_pred, 2, 10),
                R2P => pred(has_pred, 2, 10),
                R2Ur => pred(has_pred, 2, 10),
                Fma => pred(has_pred, 2, 10),
                Fp16 => pred(has_pred, 2, 10),
                Hfma2Mma => pred(has_pred, 1, 12),
                RedirectedFp64 => pred(has_pred, 1, 12),
                Decoupled => 1,

                _ => panic!("Illegal writer1 value in waw for Decoupled"),
            },
            Guard => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Guard"),
            },
        }
    }
}

#[derive(PartialEq)]
pub enum RegLatencySM100 {
    Alu,
    Dualalu,
    Disp64,
    Fma,
    FmaAlu,
    ImadWideReadAb,
    ImadWideReadCl,
    ImadWideReadCh,
    ImadWideWriteDl,
    ImadWideWriteDh,
    Fp16,
    Fp16Alu,
    Fp16F32,
    Hfma2Mma,
    RedirectedFp64,
    Imma,
    Hmma,
    Dmma,
    Branch,
    Decoupled,
    DecoupledAgu,
}

impl RegLatencySM100 {
    pub fn raw(writer: RegLatencySM100, reader: RegLatencySM100, has_pred: bool) -> u32 {
        use RegLatencySM100::*;
        match reader {
            Alu => match writer {
                Alu => 4,
                Dualalu => 4,
                Disp64 => 6,
                Fma => 5,
                FmaAlu => 5,

                ImadWideWriteDl => 3,
                ImadWideWriteDh => 5,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Alu"),
            },
            Dualalu => match writer {
                Alu => 4,
                Dualalu => 4,
                Disp64 => 6,
                Fma => 5,
                FmaAlu => 5,

                ImadWideWriteDl => 3,
                ImadWideWriteDh => 5,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Dualalu"),
            },
            Disp64 => match writer {
                _ => panic!("Illegal writer value in raw for Disp64"),
            },
            Fma => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 4,
                FmaAlu => 4,

                ImadWideWriteDl => 2,
                ImadWideWriteDh => 4,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Fma"),
            },
            FmaAlu => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 4,
                FmaAlu => 4,

                ImadWideWriteDl => 2,
                ImadWideWriteDh => 4,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for FmaAlu"),
            },
            ImadWideReadAb => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 4,
                FmaAlu => 4,

                ImadWideWriteDl => 4,
                ImadWideWriteDh => 6,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for ImadWideReadAb"),
            },
            ImadWideReadCl => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 4,
                FmaAlu => 4,

                ImadWideWriteDl => 2,
                ImadWideWriteDh => 4,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for ImadWideReadCl"),
            },
            ImadWideReadCh => match writer {
                Alu => 3,
                Dualalu => 3,
                Disp64 => 4,
                Fma => 2,
                FmaAlu => 2,

                ImadWideWriteDl => 2,
                ImadWideWriteDh => 2,
                Fp16 => 3,
                Fp16Alu => 3,
                Fp16F32 => 3,
                Hfma2Mma => 8,
                RedirectedFp64 => 8,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for ImadWideReadCh"),
            },
            ImadWideWriteDl => match writer {
                _ => panic!("Illegal writer value in raw for ImadWideWriteDl"),
            },
            ImadWideWriteDh => match writer {
                _ => panic!("Illegal writer value in raw for ImadWideWriteDh"),
            },
            Fp16 => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 5,
                FmaAlu => 5,

                ImadWideWriteDl => 3,
                ImadWideWriteDh => 5,
                Fp16 => 4,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Fp16"),
            },
            Fp16Alu => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 5,
                FmaAlu => 5,

                ImadWideWriteDl => 3,
                ImadWideWriteDh => 5,
                Fp16 => 5,
                Fp16Alu => 4,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Fp16Alu"),
            },
            Fp16F32 => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 6,
                Fma => 5,
                FmaAlu => 5,

                ImadWideWriteDl => 3,
                ImadWideWriteDh => 5,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 10,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Fp16F32"),
            },
            Hfma2Mma => match writer {
                Alu => 6,
                Dualalu => 6,
                Disp64 => 6,
                Fma => 6,
                FmaAlu => 6,

                ImadWideWriteDl => 6,
                ImadWideWriteDh => 6,
                Fp16 => 6,
                Fp16Alu => 6,
                Fp16F32 => 6,
                Hfma2Mma => 8,
                RedirectedFp64 => 10,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Hfma2Mma"),
            },
            RedirectedFp64 => match writer {
                Alu => 6,
                Dualalu => 6,
                Disp64 => 6,
                Fma => 6,
                FmaAlu => 6,

                ImadWideWriteDl => 6,
                ImadWideWriteDh => 6,
                Fp16 => 6,
                Fp16Alu => 6,
                Fp16F32 => 6,
                Hfma2Mma => 8,
                RedirectedFp64 => 8,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for RedirectedFp64"),
            },
            Imma => match writer {
                Alu => 7,
                Dualalu => 7,
                Disp64 => 7,
                Fma => 7,
                FmaAlu => 7,

                ImadWideWriteDl => 7,
                ImadWideWriteDh => 7,
                Fp16 => 7,
                Fp16Alu => 7,
                Fp16F32 => 7,
                Hfma2Mma => 11,
                RedirectedFp64 => 11,
                Imma => 20,
                Hmma => 20,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Imma"),
            },
            Hmma => match writer {
                Alu => 7,
                Dualalu => 7,
                Disp64 => 7,
                Fma => 7,
                FmaAlu => 7,

                ImadWideWriteDl => 7,
                ImadWideWriteDh => 7,
                Fp16 => 7,
                Fp16Alu => 7,
                Fp16F32 => 7,
                Hfma2Mma => 11,
                RedirectedFp64 => 11,
                Imma => 20,
                Hmma => 20,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Hmma"),
            },
            Dmma => match writer {
                Alu => 7,
                Dualalu => 7,
                Disp64 => 7,
                Fma => 7,
                FmaAlu => 7,

                ImadWideWriteDl => 7,
                ImadWideWriteDh => 7,
                Fp16 => 7,
                Fp16Alu => 7,
                Fp16F32 => 7,
                Hfma2Mma => 11,
                RedirectedFp64 => 11,
                Imma => 20,
                Hmma => 20,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Dmma"),
            },
            Branch => match writer {
                Alu => 4,
                Dualalu => 4,
                Disp64 => 4,
                Fma => 4,
                FmaAlu => 4,

                ImadWideWriteDl => 4,
                ImadWideWriteDh => 4,
                Fp16 => 4,
                Fp16Alu => 4,
                Fp16F32 => 4,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Branch"),
            },
            Decoupled => match writer {
                Alu => 4,
                Dualalu => 4,
                Disp64 => 4,
                Fma => 4,
                FmaAlu => 4,

                ImadWideWriteDl => 4,
                ImadWideWriteDh => 4,
                Fp16 => 4,
                Fp16Alu => 4,
                Fp16F32 => 4,
                Hfma2Mma => 6,
                RedirectedFp64 => 6,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for Decoupled"),
            },
            DecoupledAgu => match writer {
                Alu => 5,
                Dualalu => 5,
                Disp64 => 5,
                Fma => 5,
                FmaAlu => 5,

                ImadWideWriteDl => 5,
                ImadWideWriteDh => 5,
                Fp16 => 5,
                Fp16Alu => 5,
                Fp16F32 => 5,
                Hfma2Mma => 7,
                RedirectedFp64 => 7,
                Imma => 19,
                Hmma => 19,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer value in raw for DecoupledAgu"),
            },
        }
    }
    pub fn war(reader: RegLatencySM100, writer: RegLatencySM100, has_pred: bool) -> u32 {
        use RegLatencySM100::*;
        match writer {
            Alu => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Alu"),
            },
            Dualalu => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Dualalu"),
            },
            Disp64 => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Disp64"),
            },
            Fma => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Fma"),
            },
            FmaAlu => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for FmaAlu"),
            },
            ImadWideReadAb => match reader {
                _ => panic!("Illegal reader value in war for ImadWideReadAb"),
            },
            ImadWideReadCl => match reader {
                _ => panic!("Illegal reader value in war for ImadWideReadCl"),
            },
            ImadWideReadCh => match reader {
                _ => panic!("Illegal reader value in war for ImadWideReadCh"),
            },
            ImadWideWriteDl => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for ImadWideWriteDl"),
            },
            ImadWideWriteDh => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for ImadWideWriteDh"),
            },
            Fp16 => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Fp16"),
            },
            Fp16Alu => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Fp16Alu"),
            },
            Fp16F32 => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Fp16F32"),
            },
            Hfma2Mma => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Hfma2Mma"),
            },
            RedirectedFp64 => match reader {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,
                ImadWideReadAb => 1,
                ImadWideReadCl => 1,
                ImadWideReadCh => 1,

                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for RedirectedFp64"),
            },
            Imma => match reader {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,
                ImadWideReadAb => 2,
                ImadWideReadCl => 2,
                ImadWideReadCh => 2,

                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Imma"),
            },
            Hmma => match reader {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,
                ImadWideReadAb => 2,
                ImadWideReadCl => 2,
                ImadWideReadCh => 2,

                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Hmma"),
            },
            Dmma => match reader {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,
                ImadWideReadAb => 2,
                ImadWideReadCl => 2,
                ImadWideReadCh => 2,

                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Dmma"),
            },
            Branch => match reader {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,
                ImadWideReadAb => 2,
                ImadWideReadCl => 2,
                ImadWideReadCh => 2,

                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Branch"),
            },
            Decoupled => match reader {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,
                ImadWideReadAb => 2,
                ImadWideReadCl => 2,
                ImadWideReadCh => 2,

                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for Decoupled"),
            },
            DecoupledAgu => match reader {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,
                ImadWideReadAb => 2,
                ImadWideReadCl => 2,
                ImadWideReadCh => 2,

                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal reader value in war for DecoupledAgu"),
            },
        }
    }
    pub fn waw(writer1: RegLatencySM100, writer2: RegLatencySM100, has_pred: bool) -> u32 {
        use RegLatencySM100::*;
        match writer2 {
            Alu => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 3),
                RedirectedFp64 => pred(has_pred, 3, 3),
                Imma => pred(has_pred, 14, 2),
                Hmma => pred(has_pred, 14, 2),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Alu"),
            },
            Dualalu => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 3),
                RedirectedFp64 => pred(has_pred, 3, 3),
                Imma => pred(has_pred, 14, 2),
                Hmma => pred(has_pred, 14, 2),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Dualalu"),
            },
            Disp64 => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 1),
                RedirectedFp64 => pred(has_pred, 3, 1),
                Imma => pred(has_pred, 14, 1),
                Hmma => pred(has_pred, 14, 1),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Disp64"),
            },
            Fma => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => pred(has_pred, 1, 1),
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 3),
                RedirectedFp64 => pred(has_pred, 3, 3),
                Imma => pred(has_pred, 14, 3),
                Hmma => pred(has_pred, 14, 3),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Fma"),
            },
            FmaAlu => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => pred(has_pred, 1, 1),
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 3),
                RedirectedFp64 => pred(has_pred, 3, 3),
                Imma => pred(has_pred, 14, 3),
                Hmma => pred(has_pred, 14, 3),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for FmaAlu"),
            },
            ImadWideReadAb => match writer1 {
                _ => panic!("Illegal writer1 value in waw for ImadWideReadAb"),
            },
            ImadWideReadCl => match writer1 {
                _ => panic!("Illegal writer1 value in waw for ImadWideReadCl"),
            },
            ImadWideReadCh => match writer1 {
                _ => panic!("Illegal writer1 value in waw for ImadWideReadCh"),
            },
            ImadWideWriteDl => match writer1 {
                Alu => pred(has_pred, 1, 2),
                Dualalu => pred(has_pred, 1, 2),
                Disp64 => pred(has_pred, 1, 3),
                Fma => pred(has_pred, 1, 1),
                FmaAlu => pred(has_pred, 1, 1),

                ImadWideWriteDl => 1,
                ImadWideWriteDh => pred(has_pred, 1, 1),
                Fp16 => pred(has_pred, 1, 2),
                Fp16Alu => pred(has_pred, 1, 2),
                Fp16F32 => pred(has_pred, 1, 2),
                Hfma2Mma => pred(has_pred, 5, 3),
                RedirectedFp64 => pred(has_pred, 5, 3),
                Imma => pred(has_pred, 14, 3),
                Hmma => pred(has_pred, 14, 3),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for ImadWideWriteDl"),
            },
            ImadWideWriteDh => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 5, 1),
                RedirectedFp64 => pred(has_pred, 5, 1),
                Imma => pred(has_pred, 14, 3),
                Hmma => pred(has_pred, 14, 3),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for ImadWideWriteDh"),
            },
            Fp16 => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 3),
                RedirectedFp64 => pred(has_pred, 3, 3),
                Imma => pred(has_pred, 14, 2),
                Hmma => pred(has_pred, 14, 2),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Fp16"),
            },
            Fp16Alu => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => pred(has_pred, 1, 1),
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 3),
                RedirectedFp64 => pred(has_pred, 3, 3),
                Imma => pred(has_pred, 14, 2),
                Hmma => pred(has_pred, 14, 2),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Fp16Alu"),
            },
            Fp16F32 => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => pred(has_pred, 3, 2),
                RedirectedFp64 => pred(has_pred, 3, 2),
                Imma => pred(has_pred, 14, 2),
                Hmma => pred(has_pred, 14, 2),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Fp16F32"),
            },
            Hfma2Mma => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 1,
                RedirectedFp64 => 3,
                Imma => 14,
                Hmma => 14,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Hfma2Mma"),
            },
            RedirectedFp64 => match writer1 {
                Alu => 1,
                Dualalu => 1,
                Disp64 => 1,
                Fma => 1,
                FmaAlu => 1,

                ImadWideWriteDl => 1,
                ImadWideWriteDh => 1,
                Fp16 => 1,
                Fp16Alu => 1,
                Fp16F32 => 1,
                Hfma2Mma => 2,
                RedirectedFp64 => 1,
                Imma => 13,
                Hmma => 13,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for RedirectedFp64"),
            },
            Imma => match writer1 {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,

                ImadWideWriteDl => 2,
                ImadWideWriteDh => 2,
                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Imma"),
            },
            Hmma => match writer1 {
                Alu => 2,
                Dualalu => 2,
                Disp64 => 2,
                Fma => 2,
                FmaAlu => 2,

                ImadWideWriteDl => 2,
                ImadWideWriteDh => 2,
                Fp16 => 2,
                Fp16Alu => 2,
                Fp16F32 => 2,
                Hfma2Mma => 2,
                RedirectedFp64 => 2,
                Imma => 1,
                Hmma => 1,
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Hmma"),
            },
            Dmma => match writer1 {
                Alu => pred(has_pred, 2, 4),
                Dualalu => pred(has_pred, 2, 4),
                Disp64 => pred(has_pred, 2, 4),
                Fma => pred(has_pred, 2, 4),
                FmaAlu => pred(has_pred, 2, 4),

                ImadWideWriteDl => pred(has_pred, 2, 4),
                ImadWideWriteDh => pred(has_pred, 2, 4),
                Fp16 => pred(has_pred, 2, 4),
                Fp16Alu => pred(has_pred, 2, 4),
                Fp16F32 => pred(has_pred, 2, 4),
                Hfma2Mma => pred(has_pred, 2, 8),
                RedirectedFp64 => pred(has_pred, 2, 8),
                Imma => pred(has_pred, 10, 9),
                Hmma => pred(has_pred, 10, 9),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Dmma"),
            },
            Branch => match writer1 {
                Alu => pred(has_pred, 1, 5),
                Dualalu => pred(has_pred, 1, 5),
                Disp64 => pred(has_pred, 1, 5),
                Fma => pred(has_pred, 1, 5),
                FmaAlu => pred(has_pred, 1, 5),

                ImadWideWriteDl => pred(has_pred, 1, 5),
                ImadWideWriteDh => pred(has_pred, 1, 5),
                Fp16 => pred(has_pred, 1, 5),
                Fp16Alu => pred(has_pred, 1, 5),
                Fp16F32 => pred(has_pred, 1, 5),
                Hfma2Mma => pred(has_pred, 1, 9),
                RedirectedFp64 => pred(has_pred, 1, 9),
                Imma => pred(has_pred, 13, 6),
                Hmma => pred(has_pred, 13, 6),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Branch"),
            },
            Decoupled => match writer1 {
                Alu => pred(has_pred, 1, 5),
                Dualalu => pred(has_pred, 1, 5),
                Disp64 => pred(has_pred, 1, 5),
                Fma => pred(has_pred, 1, 5),
                FmaAlu => pred(has_pred, 1, 5),

                ImadWideWriteDl => pred(has_pred, 1, 5),
                ImadWideWriteDh => pred(has_pred, 1, 5),
                Fp16 => pred(has_pred, 1, 5),
                Fp16Alu => pred(has_pred, 1, 5),
                Fp16F32 => pred(has_pred, 1, 5),
                Hfma2Mma => pred(has_pred, 1, 9),
                RedirectedFp64 => pred(has_pred, 1, 9),
                Imma => pred(has_pred, 13, 6),
                Hmma => pred(has_pred, 13, 6),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for Decoupled"),
            },
            DecoupledAgu => match writer1 {
                Alu => pred(has_pred, 1, 5),
                Dualalu => pred(has_pred, 1, 5),
                Disp64 => pred(has_pred, 1, 5),
                Fma => pred(has_pred, 1, 5),
                FmaAlu => pred(has_pred, 1, 5),

                ImadWideWriteDl => pred(has_pred, 1, 5),
                ImadWideWriteDh => pred(has_pred, 1, 5),
                Fp16 => pred(has_pred, 1, 5),
                Fp16Alu => pred(has_pred, 1, 5),
                Fp16F32 => pred(has_pred, 1, 5),
                Hfma2Mma => pred(has_pred, 1, 9),
                RedirectedFp64 => pred(has_pred, 1, 9),
                Imma => pred(has_pred, 13, 6),
                Hmma => pred(has_pred, 13, 6),
                Dmma => 1,
                Branch => 1,
                Decoupled => 1,
                DecoupledAgu => 1,
                _ => panic!("Illegal writer1 value in waw for DecoupledAgu"),
            },
        }
    }
}

#[derive(PartialEq)]
pub enum UpredLatencySM100 {
    Coupled,
    Udp,
    Voteu,
    UGuard,
    BraJmp,
    UldcMma,
    Usetmaxreg,
}

impl UpredLatencySM100 {
    pub fn raw(writer: UpredLatencySM100, reader: UpredLatencySM100, has_pred: bool) -> u32 {
        use UpredLatencySM100::*;
        match reader {
            Coupled => match writer {
                Udp => 6,
                Voteu => 1,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer value in raw for Coupled"),
            },
            Udp => match writer {
                Udp => 4,
                Voteu => 1,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer value in raw for Udp"),
            },
            Voteu => match writer {
                _ => panic!("Illegal writer value in raw for Voteu"),
            },
            UGuard => match writer {
                Udp => 11,
                Voteu => 5,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer value in raw for UGuard"),
            },
            BraJmp => match writer {
                Udp => 9,
                Voteu => 2,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer value in raw for BraJmp"),
            },
            UldcMma => match writer {
                Udp => 11,
                Voteu => 5,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer value in raw for UldcMma"),
            },
            Usetmaxreg => match writer {
                _ => panic!("Illegal writer value in raw for Usetmaxreg"),
            },
        }
    }
    pub fn war(reader: UpredLatencySM100, writer: UpredLatencySM100, has_pred: bool) -> u32 {
        use UpredLatencySM100::*;
        match writer {
            Coupled => match reader {
                _ => panic!("Illegal reader value in war for Coupled"),
            },
            Udp => match reader {
                Coupled => 1,
                Udp => 1,

                UGuard => 1,
                BraJmp => 1,
                UldcMma => 1,

                _ => panic!("Illegal reader value in war for Udp"),
            },
            Voteu => match reader {
                Coupled => 2,
                Udp => 2,

                UGuard => 1,
                BraJmp => 1,
                UldcMma => 1,

                _ => panic!("Illegal reader value in war for Voteu"),
            },
            UGuard => match reader {
                _ => panic!("Illegal reader value in war for UGuard"),
            },
            BraJmp => match reader {
                _ => panic!("Illegal reader value in war for BraJmp"),
            },
            UldcMma => match reader {
                _ => panic!("Illegal reader value in war for UldcMma"),
            },
            Usetmaxreg => match reader {
                Coupled => 1,
                Udp => 1,

                UGuard => 1,
                BraJmp => 1,
                UldcMma => 1,

                _ => panic!("Illegal reader value in war for Usetmaxreg"),
            },
        }
    }
    pub fn waw(writer1: UpredLatencySM100, writer2: UpredLatencySM100, has_pred: bool) -> u32 {
        use UpredLatencySM100::*;
        match writer2 {
            Coupled => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Coupled"),
            },
            Udp => match writer1 {
                Udp => 1,
                Voteu => 1,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer1 value in waw for Udp"),
            },
            Voteu => match writer1 {
                Udp => 7,
                Voteu => 1,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer1 value in waw for Voteu"),
            },
            UGuard => match writer1 {
                _ => panic!("Illegal writer1 value in waw for UGuard"),
            },
            BraJmp => match writer1 {
                _ => panic!("Illegal writer1 value in waw for BraJmp"),
            },
            UldcMma => match writer1 {
                _ => panic!("Illegal writer1 value in waw for UldcMma"),
            },
            Usetmaxreg => match writer1 {
                Udp => pred(has_pred, 8, 2),
                Voteu => 8,

                Usetmaxreg => 1,
                _ => panic!("Illegal writer1 value in waw for Usetmaxreg"),
            },
        }
    }
}

#[derive(PartialEq)]
pub enum UregLatencySM100 {
    Coupled,
    CoupledMma,
    Decoupled,
    Branch,
    CoupledBindless,
    DecoupledBindless,
    Hfma2Mma,
    ToUr,
    Tex,
    Tma,
    Rpcmov64,
    Udp,
    Uldc,
    Umov,
    Elect,
    R2Ur,
    Voteu,
}

impl UregLatencySM100 {
    pub fn raw(writer: UregLatencySM100, reader: UregLatencySM100, has_pred: bool) -> u32 {
        use UregLatencySM100::*;
        match reader {
            Coupled => match writer {
                ToUr => 1,

                Udp => 6,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Coupled"),
            },
            CoupledMma => match writer {
                ToUr => 1,

                Udp => 6,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for CoupledMma"),
            },
            Decoupled => match writer {
                ToUr => 1,

                Udp => 9,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Decoupled"),
            },
            Branch => match writer {
                ToUr => 1,

                Udp => 10,
                Uldc => 3,
                Umov => 3,
                Elect => 3,
                R2Ur => 13,
                Voteu => 3,
                _ => panic!("Illegal writer value in raw for Branch"),
            },
            CoupledBindless => match writer {
                ToUr => 1,

                Udp => 12,
                Uldc => 5,
                Umov => 5,
                Elect => 5,
                R2Ur => 15,
                Voteu => 5,
                _ => panic!("Illegal writer value in raw for CoupledBindless"),
            },
            DecoupledBindless => match writer {
                ToUr => 1,

                Udp => 12,
                Uldc => 5,
                Umov => 5,
                Elect => 5,
                R2Ur => 15,
                Voteu => 5,
                _ => panic!("Illegal writer value in raw for DecoupledBindless"),
            },
            Hfma2Mma => match writer {
                ToUr => 1,

                Udp => 9,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Hfma2Mma"),
            },
            ToUr => match writer {
                ToUr => 1,

                Udp => 12,
                Uldc => 5,
                Umov => 5,
                Elect => 5,
                R2Ur => 13,
                Voteu => 5,
                _ => panic!("Illegal writer value in raw for ToUr"),
            },
            Tex => match writer {
                ToUr => 1,

                Udp => 9,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Tex"),
            },
            Tma => match writer {
                ToUr => 1,

                Udp => 9,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Tma"),
            },
            Rpcmov64 => match writer {
                ToUr => 1,

                Udp => 9,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Rpcmov64"),
            },
            Udp => match writer {
                ToUr => 1,

                Udp => 4,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Udp"),
            },
            Uldc => match writer {
                ToUr => 1,

                Udp => 12,
                Uldc => 5,
                Umov => 5,
                Elect => 5,
                R2Ur => 15,
                Voteu => 5,
                _ => panic!("Illegal writer value in raw for Uldc"),
            },
            Umov => match writer {
                ToUr => 1,

                Udp => 7,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Umov"),
            },
            Elect => match writer {
                ToUr => 1,

                Udp => 8,
                Uldc => 2,
                Umov => 2,
                Elect => 2,
                R2Ur => 13,
                Voteu => 2,
                _ => panic!("Illegal writer value in raw for Elect"),
            },
            R2Ur => match writer {
                _ => panic!("Illegal writer value in raw for R2Ur"),
            },
            Voteu => match writer {
                _ => panic!("Illegal writer value in raw for Voteu"),
            },
        }
    }
    pub fn war(reader: UregLatencySM100, writer: UregLatencySM100, has_pred: bool) -> u32 {
        use UregLatencySM100::*;
        match writer {
            Coupled => match reader {
                _ => panic!("Illegal reader value in war for Coupled"),
            },
            CoupledMma => match reader {
                _ => panic!("Illegal reader value in war for CoupledMma"),
            },
            Decoupled => match reader {
                _ => panic!("Illegal reader value in war for Decoupled"),
            },
            Branch => match reader {
                _ => panic!("Illegal reader value in war for Branch"),
            },
            CoupledBindless => match reader {
                _ => panic!("Illegal reader value in war for CoupledBindless"),
            },
            DecoupledBindless => match reader {
                _ => panic!("Illegal reader value in war for DecoupledBindless"),
            },
            Hfma2Mma => match reader {
                _ => panic!("Illegal reader value in war for Hfma2Mma"),
            },
            ToUr => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 1,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for ToUr"),
            },
            Tex => match reader {
                _ => panic!("Illegal reader value in war for Tex"),
            },
            Tma => match reader {
                _ => panic!("Illegal reader value in war for Tma"),
            },
            Rpcmov64 => match reader {
                _ => panic!("Illegal reader value in war for Rpcmov64"),
            },
            Udp => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 1,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for Udp"),
            },
            Uldc => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 3,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for Uldc"),
            },
            Umov => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 3,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for Umov"),
            },
            Elect => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 3,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for Elect"),
            },
            R2Ur => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 1,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for R2Ur"),
            },
            Voteu => match reader {
                Coupled => 1,
                CoupledMma => 1,
                Decoupled => 1,
                Branch => 1,
                CoupledBindless => 1,
                DecoupledBindless => 1,
                Hfma2Mma => 1,
                ToUr => 1,
                Tex => 1,
                Tma => 1,
                Rpcmov64 => 1,
                Udp => 3,
                Uldc => 1,
                Umov => 1,
                Elect => 1,

                _ => panic!("Illegal reader value in war for Voteu"),
            },
        }
    }
    pub fn waw(writer1: UregLatencySM100, writer2: UregLatencySM100, has_pred: bool) -> u32 {
        use UregLatencySM100::*;
        match writer2 {
            Coupled => match writer1 {
                ToUr => 1,

                _ => panic!("Illegal writer1 value in waw for Coupled"),
            },
            CoupledMma => match writer1 {
                ToUr => 1,

                _ => panic!("Illegal writer1 value in waw for CoupledMma"),
            },
            Decoupled => match writer1 {
                ToUr => 1,

                _ => panic!("Illegal writer1 value in waw for Decoupled"),
            },
            Branch => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Branch"),
            },
            CoupledBindless => match writer1 {
                _ => panic!("Illegal writer1 value in waw for CoupledBindless"),
            },
            DecoupledBindless => match writer1 {
                _ => panic!("Illegal writer1 value in waw for DecoupledBindless"),
            },
            Hfma2Mma => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Hfma2Mma"),
            },
            ToUr => match writer1 {
                ToUr => 1,

                Udp => pred(has_pred, 4, 7),
                Uldc => 4,
                Umov => 4,
                Elect => 4,
                R2Ur => pred(has_pred, 4, 10),
                Voteu => 4,
                _ => panic!("Illegal writer1 value in waw for ToUr"),
            },
            Tex => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Tex"),
            },
            Tma => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Tma"),
            },
            Rpcmov64 => match writer1 {
                _ => panic!("Illegal writer1 value in waw for Rpcmov64"),
            },
            Udp => match writer1 {
                ToUr => 1,

                Udp => 1,
                Uldc => 1,
                Umov => 1,
                Elect => 1,
                R2Ur => pred(has_pred, 4, 5),
                Voteu => 1,
                _ => panic!("Illegal writer1 value in waw for Udp"),
            },
            Uldc => match writer1 {
                ToUr => 1,

                Udp => 7,
                Uldc => 1,
                Umov => 1,
                Elect => 1,
                R2Ur => pred(has_pred, 10, 1),
                Voteu => 1,
                _ => panic!("Illegal writer1 value in waw for Uldc"),
            },
            Umov => match writer1 {
                ToUr => 1,

                Udp => 7,
                Uldc => 1,
                Umov => 1,
                Elect => 1,
                R2Ur => pred(has_pred, 10, 1),
                Voteu => 1,
                _ => panic!("Illegal writer1 value in waw for Umov"),
            },
            Elect => match writer1 {
                ToUr => 1,

                Udp => 7,
                Uldc => 1,
                Umov => 1,
                Elect => 1,
                R2Ur => pred(has_pred, 10, 1),
                Voteu => 1,
                _ => panic!("Illegal writer1 value in waw for Elect"),
            },
            R2Ur => match writer1 {
                ToUr => 1,

                Udp => 7,
                Uldc => 1,
                Umov => 1,
                Elect => 1,
                R2Ur => 1,
                Voteu => 1,
                _ => panic!("Illegal writer1 value in waw for R2Ur"),
            },
            Voteu => match writer1 {
                ToUr => 1,

                Udp => 7,
                Uldc => 1,
                Umov => 1,
                Elect => 1,
                R2Ur => pred(has_pred, 10, 1),
                Voteu => 1,
                _ => panic!("Illegal writer1 value in waw for Voteu"),
            },
        }
    }
}
