/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.components;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.compaction.components.IComponent;
import org.eclipse.elk.alg.layered.compaction.components.IConnectedComponents;
import org.eclipse.elk.alg.layered.compaction.components.IExternalExtension;
import org.eclipse.elk.alg.layered.compaction.oned.CGraph;
import org.eclipse.elk.alg.layered.compaction.oned.CGroup;
import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.ICGraphTransformer;
import org.eclipse.elk.alg.layered.compaction.oned.ISpacingsHandler;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public class ComponentsToCGraphTransformer<N, E>
implements ICGraphTransformer<IConnectedComponents<N, E>> {
    private CGraph cGraph;
    private double spacing;
    private Map<IComponent<N, E>, KVector> oldPosition = Maps.newHashMap();
    private Map<IComponent<N, E>, CRectNode> offsets = Maps.newHashMap();
    private KVector globalOffset;
    private KVector graphSize;
    private Map<IExternalExtension<E>, Pair<CGroup, CNode>> externalExtensions = Maps.newHashMap();
    private Multimap<Direction, Pair<CGroup, CNode>> externalPlaceholder = HashMultimap.create();
    public static final ISpacingsHandler<? super CNode> SPACING_HANDLER = new ISpacingsHandler<CNode>(){

        @Override
        public double getHorizontalSpacing(CNode cNode1, CNode cNode2) {
            return Math.min(cNode1.getHorizontalSpacing(), cNode2.getHorizontalSpacing());
        }

        @Override
        public double getVerticalSpacing(CNode cNode1, CNode cNode2) {
            return Math.min(cNode1.getVerticalSpacing(), cNode2.getVerticalSpacing());
        }
    };

    public ComponentsToCGraphTransformer(double spacing) {
        this.spacing = spacing;
    }

    public KVector getOffset(IComponent<N, E> c) {
        KVector cOffset = this.oldPosition.get(c).clone().sub(this.offsets.get(c).rect.getPosition());
        return cOffset;
    }

    public KVector getGlobalOffset() {
        return this.globalOffset;
    }

    public KVector getGraphSize() {
        return this.graphSize;
    }

    public Map<IExternalExtension<E>, Pair<CGroup, CNode>> getExternalExtensions() {
        return this.externalExtensions;
    }

    public Multimap<Direction, Pair<CGroup, CNode>> getExternalPlaceholder() {
        return this.externalPlaceholder;
    }

    @Override
    public CGraph transform(IConnectedComponents<N, E> ccs) {
        this.cGraph = new CGraph(EnumSet.allOf(Direction.class));
        for (IComponent<N, E> comp : ccs.getComponents()) {
            CRectNode rectNode;
            CGroup group = new CGroup(new CNode[0]);
            this.cGraph.cGroups.add(group);
            for (ElkRectangle elkRectangle : comp.getHull()) {
                rectNode = new CRectNode(elkRectangle);
                this.setLock(rectNode, comp.getExternalExtensionSides());
                if (!this.oldPosition.containsKey(comp)) {
                    this.oldPosition.put(comp, new KVector(elkRectangle.x, elkRectangle.y));
                    this.offsets.put(comp, rectNode);
                }
                this.cGraph.cNodes.add(rectNode);
                group.addCNode(rectNode);
            }
            for (IExternalExtension iExternalExtension : comp.getExternalExtensions()) {
                rectNode = new CRectNode(iExternalExtension.getRepresentor());
                this.externalExtensions.put(iExternalExtension, Pair.of(group, rectNode));
                this.setLock(rectNode, comp.getExternalExtensionSides());
                if (iExternalExtension.getPlaceholder() == null) continue;
                CRectNode rectPlaceholder = new CRectNode(iExternalExtension.getPlaceholder(), 1.0);
                this.setLock(rectPlaceholder, comp.getExternalExtensionSides());
                CGroup dummyGroup = new CGroup(new CNode[0]);
                dummyGroup.addCNode(rectPlaceholder);
                this.externalPlaceholder.put(iExternalExtension.getDirection(), Pair.of(group, rectPlaceholder));
            }
        }
        return this.cGraph;
    }

    private void setLock(CNode cNode, Set<PortSide> portSides) {
        if (portSides.isEmpty()) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH)) {
            cNode.lock.set(true, true, true, false);
        }
        if (portSides.equals(PortSide.SIDES_EAST)) {
            cNode.lock.set(false, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_SOUTH)) {
            cNode.lock.set(true, true, false, true);
        }
        if (portSides.equals(PortSide.SIDES_WEST)) {
            cNode.lock.set(true, false, true, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_EAST)) {
            cNode.lock.set(false, true, true, false);
        }
        if (portSides.equals(PortSide.SIDES_EAST_SOUTH)) {
            cNode.lock.set(false, true, false, true);
        }
        if (portSides.equals(PortSide.SIDES_SOUTH_WEST)) {
            cNode.lock.set(true, false, false, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_WEST)) {
            cNode.lock.set(true, false, true, false);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_SOUTH)) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_EAST_WEST)) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_SOUTH)) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_EAST_SOUTH_WEST)) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_SOUTH_WEST)) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_EAST_WEST)) {
            cNode.lock.set(true, true, true, true);
        }
        if (portSides.equals(PortSide.SIDES_NORTH_EAST_SOUTH_WEST)) {
            cNode.lock.set(true, true, true, true);
        }
    }

    @Override
    public void applyLayout() {
        for (CNode n : this.cGraph.cNodes) {
            n.applyElementPosition();
        }
        KVector topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        KVector bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (CNode cNode : this.cGraph.cNodes) {
            topLeft.x = Math.min(topLeft.x, cNode.hitbox.x);
            topLeft.y = Math.min(topLeft.y, cNode.hitbox.y);
            bottomRight.x = Math.max(bottomRight.x, cNode.hitbox.x + cNode.hitbox.width);
            bottomRight.y = Math.max(bottomRight.y, cNode.hitbox.y + cNode.hitbox.height);
        }
        for (Pair pair : this.externalPlaceholder.values()) {
            CNode cNode = (CNode)pair.getSecond();
            topLeft.x = Math.min(topLeft.x, cNode.hitbox.x);
            topLeft.y = Math.min(topLeft.y, cNode.hitbox.y);
            bottomRight.x = Math.max(bottomRight.x, cNode.hitbox.x + cNode.hitbox.width);
            bottomRight.y = Math.max(bottomRight.y, cNode.hitbox.y + cNode.hitbox.height);
        }
        this.globalOffset = topLeft.clone().negate();
        this.graphSize = bottomRight.clone().sub(topLeft);
        this.cGraph.cGroups.clear();
        this.cGraph.cNodes.clear();
    }

    private final class CRectNode
    extends CNode {
        private ElkRectangle rect;
        private Double individualSpacing;

        private CRectNode(ElkRectangle rect) {
            this(rect, null);
        }

        private CRectNode(ElkRectangle rect, Double spacing) {
            this.rect = rect;
            this.hitbox = new ElkRectangle(rect.x, rect.y, rect.width, rect.height);
            this.individualSpacing = spacing;
        }

        @Override
        public double getHorizontalSpacing() {
            return this.individualSpacing != null ? this.individualSpacing : ComponentsToCGraphTransformer.this.spacing;
        }

        @Override
        public double getVerticalSpacing() {
            return this.individualSpacing != null ? this.individualSpacing : ComponentsToCGraphTransformer.this.spacing;
        }

        @Override
        public void applyElementPosition() {
            this.rect.x = this.hitbox.x;
            this.rect.y = this.hitbox.y;
        }

        @Override
        public double getElementPosition() {
            return this.rect.x;
        }

        public String toString() {
            return "";
        }
    }
}

