/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Objects;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.AbstractControllerMutationQuota;

public class PermissiveControllerMutationQuota
extends AbstractControllerMutationQuota {
    private final Sensor quotaSensor;

    public PermissiveControllerMutationQuota(Time time, Sensor quotaSensor) {
        super(time);
        this.quotaSensor = Objects.requireNonNull(quotaSensor, "quotaSensor cannot be null");
    }

    @Override
    public boolean isExceeded() {
        return false;
    }

    @Override
    public void record(double permits) {
        long timeMs = this.time.milliseconds();
        try {
            this.quotaSensor.record(permits, timeMs, true);
        }
        catch (QuotaViolationException e) {
            this.updateThrottleTime(e, timeMs);
        }
    }
}

