/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.one.util.streamex;

import java.util.Spliterator;
import java.util.stream.BaseStream;
import org.jetbrains.kotlin.one.util.streamex.StreamContext;

abstract class BaseStreamEx<T, S extends BaseStream<T, S>, SPLTR extends Spliterator<T>, B extends BaseStreamEx<T, S, SPLTR, B>>
implements BaseStream<T, S> {
    private S stream;
    SPLTR spliterator;
    StreamContext context;

    BaseStreamEx(S stream, StreamContext context2) {
        this.stream = stream;
        this.context = context2;
    }

    BaseStreamEx(SPLTR spliterator, StreamContext context2) {
        this.spliterator = spliterator;
        this.context = context2;
    }

    abstract S createStream();

    final S stream() {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.spliterator == null) {
            throw new IllegalStateException("Stream is already consumed");
        }
        this.stream = this.createStream();
        this.spliterator = null;
        return this.stream;
    }

    public SPLTR spliterator() {
        if (this.stream != null) {
            return (SPLTR)this.stream.spliterator();
        }
        if (this.spliterator != null) {
            SPLTR s2 = this.spliterator;
            this.spliterator = null;
            return s2;
        }
        throw new IllegalStateException("Stream is already consumed");
    }

    @Override
    public boolean isParallel() {
        return this.context.parallel;
    }

    @Override
    public S sequential() {
        this.context = this.context.sequential();
        if (this.stream != null) {
            this.stream = this.stream.sequential();
        }
        return (S)this;
    }

    @Override
    public S parallel() {
        this.context = this.context.parallel();
        if (this.stream != null) {
            this.stream = this.stream.parallel();
        }
        return (S)this;
    }

    @Override
    public S unordered() {
        this.stream = this.stream().unordered();
        return (S)this;
    }

    @Override
    public S onClose(Runnable closeHandler) {
        this.context = this.context.onClose(closeHandler);
        return (S)this;
    }

    @Override
    public void close() {
        this.context.close();
    }
}

