/// Unique IDs for each statically-registered module.
#[repr(u16)]
pub enum ModuleID {
  SiteSecurity,
  Anonymous081,
  Anonymous066,
  Anonymous380,
  Anonymous095,
  Anonymous243,
  Anonymous611,
  Anonymous641,
  UrlClassifierTestUtils,
  Anonymous235,
  Anonymous329,
  Anonymous421,
  Anonymous429,
  Anonymous449,
  Anonymous074,
  Anonymous005,
  Anonymous330,
  Anonymous642,
  Anonymous322,
  Anonymous600,
  FolderNotification,
  Anonymous046,
  Anonymous175,
  Anonymous416,
  Anonymous077,
  Anonymous420,
  Anonymous102,
  Anonymous674,
  Anonymous483,
  Anonymous145,
  Anonymous153,
  Anonymous489,
  Anonymous442,
  Anonymous604,
  Anonymous622,
  Anonymous520,
  Anonymous579,
  Anonymous309,
  Anonymous479,
  Anonymous355,
  ExtensionPolicy,
  Anonymous232,
  Anonymous399,
  ScriptSecurityManager,
  Anonymous537,
  Anonymous194,
  Anonymous538,
  Anonymous562,
  Anonymous248,
  Anonymous657,
  Anonymous111,
  Anonymous044,
  Anonymous048,
  Anonymous199,
  Anonymous040,
  Anonymous250,
  Anonymous546,
  Anonymous652,
  CaptivePortal,
  Anonymous310,
  Anonymous037,
  AppStartup,
  Anonymous434,
  Prefetch,
  Anonymous584,
  StringBundle,
  Anonymous065,
  Anonymous682,
  Anonymous388,
  Anonymous433,
  Anonymous552,
  WifiMonitor,
  Anonymous197,
  Anonymous117,
  Anonymous118,
  Anonymous313,
  Anonymous036,
  Anonymous435,
  Anonymous184,
  Anonymous351,
  Anonymous150,
  CategoryManager,
  Anonymous286,
  Anonymous484,
  Anonymous643,
  StreamConverter,
  Anonymous265,
  NSSErrors,
  Anonymous022,
  Anonymous161,
  FileProtocolHandler,
  Anonymous440,
  Anonymous513,
  UrlClassifierDB,
  Anonymous466,
  Anonymous647,
  Anonymous300,
  Anonymous284,
  Anonymous124,
  Anonymous058,
  Anonymous282,
  Anonymous006,
  Anonymous185,
  Anonymous464,
  OutgoingServer,
  Anonymous009,
  Anonymous574,
  PlacesPreviewsHelper,
  Anonymous573,
  Anonymous253,
  Anonymous038,
  Anonymous277,
  Anonymous594,
  Anonymous011,
  Anonymous252,
  Anonymous577,
  Anonymous414,
  Anonymous613,
  ApplicationReputation,
  Anonymous405,
  DBusHandlerApp,
  Anonymous114,
  Anonymous387,
  Anonymous423,
  Anonymous130,
  Anonymous125,
  Anonymous103,
  WindowWatcher,
  Anonymous571,
  Anonymous128,
  Anonymous342,
  Anonymous193,
  Anonymous690,
  Anonymous162,
  Anonymous289,
  Anonymous675,
  Anonymous672,
  Anonymous576,
  Anonymous323,
  Anonymous630,
  Anonymous401,
  Filter,
  Anonymous689,
  Anonymous660,
  Anonymous524,
  Anonymous001,
  Anonymous363,
  Anonymous264,
  Anonymous598,
  Anonymous369,
  Anonymous358,
  EffectiveTLD,
  Anonymous224,
  Anonymous494,
  CookieBannerService,
  Anonymous112,
  Anonymous348,
  Anonymous553,
  Anonymous050,
  Anonymous283,
  Anonymous241,
  Anonymous214,
  StreamTransport,
  Anonymous450,
  Anonymous172,
  MimeHeaderParam,
  Anonymous669,
  Anonymous043,
  Anonymous272,
  Anonymous497,
  Anonymous201,
  Anonymous290,
  Anonymous678,
  Anonymous079,
  Anonymous687,
  IO,
  Anonymous084,
  Anonymous230,
  Anonymous020,
  Anonymous299,
  Anonymous532,
  Anonymous480,
  XULRuntime,
  Anonymous297,
  Dashboard,
  Anonymous547,
  Anonymous509,
  Anonymous582,
  Anonymous567,
  Anonymous192,
  Anonymous138,
  Anonymous456,
  Anonymous324,
  Anonymous220,
  Anonymous305,
  Anonymous601,
  Anonymous234,
  Anonymous638,
  TypeAheadFind,
  Anonymous390,
  Anonymous226,
  UrlClassifierUtils,
  Anonymous267,
  Anonymous088,
  Anonymous512,
  Anonymous000,
  Anonymous533,
  Anonymous231,
  Anonymous217,
  Anonymous078,
  Anonymous053,
  Anonymous280,
  Anonymous371,
  Anonymous010,
  ContentSecurityManager,
  Anonymous167,
  Anonymous106,
  Anonymous383,
  Anonymous035,
  Anonymous519,
  Anonymous076,
  Anonymous179,
  Anonymous334,
  Anonymous684,
  History,
  Anonymous271,
  Tag,
  Anonymous541,
  Anonymous631,
  Anonymous200,
  Anonymous281,
  Anonymous198,
  Anonymous105,
  Anonymous141,
  Anonymous523,
  Anonymous211,
  Anonymous614,
  Anonymous294,
  Anonymous367,
  Anonymous244,
  Anonymous688,
  Anonymous052,
  Anonymous032,
  Anonymous686,
  Anonymous580,
  Anonymous257,
  Anonymous340,
  Anonymous664,
  Anonymous375,
  Anonymous028,
  Anonymous398,
  Anonymous069,
  Anonymous025,
  Anonymous134,
  CacheStorage,
  Anonymous033,
  Anonymous645,
  Anonymous661,
  Anonymous295,
  Anonymous677,
  Anonymous683,
  Anonymous493,
  Anonymous359,
  Anonymous516,
  Anonymous612,
  Anonymous667,
  Anonymous098,
  Anonymous514,
  Anonymous639,
  Anonymous361,
  Anonymous166,
  Anonymous377,
  Anonymous488,
  Anonymous336,
  Anonymous151,
  Anonymous215,
  HttpAuthCache,
  Anonymous558,
  Anonymous260,
  MailSession,
  NetworkErrorLogging,
  Anonymous045,
  AccountManager,
  Anonymous644,
  Anonymous004,
  Anonymous014,
  AbManager,
  IdentityCredentialStorageService,
  Anonymous609,
  Anonymous467,
  Anonymous292,
  Anonymous191,
  Anonymous317,
  Anonymous129,
  Anonymous528,
  Anonymous208,
  PermissionManager,
  Anonymous572,
  Anonymous470,
  Anonymous623,
  Anonymous188,
  Anonymous238,
  Anonymous109,
  Anonymous133,
  Anonymous304,
  Anonymous116,
  Anonymous254,
  Anonymous210,
  Anonymous131,
  Anonymous047,
  Anonymous008,
  Anonymous067,
  Anonymous410,
  Anonymous356,
  Anonymous445,
  Anonymous472,
  Anonymous654,
  Anonymous374,
  Anonymous142,
  Anonymous586,
  Anonymous620,
  Anonymous137,
  Anonymous352,
  Anonymous027,
  AuthPromptAdapter,
  Anonymous651,
  ProtocolProxy,
  Anonymous002,
  Anonymous261,
  Anonymous259,
  Anonymous455,
  Anonymous673,
  Anonymous190,
  Anonymous462,
  Anonymous270,
  Anonymous101,
  AsyncShutdown,
  Anonymous372,
  Anonymous262,
  Anonymous544,
  Anonymous364,
  Anonymous092,
  Anonymous060,
  HttpHandler,
  Anonymous024,
  Anonymous391,
  Anonymous607,
  Anonymous564,
  MimeConverter,
  Anonymous438,
  Anonymous402,
  Anonymous339,
  BounceTrackingProtection,
  Anonymous221,
  Anonymous505,
  Anonymous548,
  Preferences,
  Anonymous335,
  Anonymous485,
  Anonymous444,
  Anonymous245,
  Anonymous325,
  NSSCertificateDB,
  Anonymous326,
  Anonymous583,
  Anonymous379,
  Anonymous132,
  Anonymous120,
  Anonymous665,
  Anonymous671,
  Anonymous202,
  Anonymous492,
  Anonymous478,
  Anonymous064,
  Anonymous291,
  ThirdPartyUtil,
  Anonymous437,
  Anonymous522,
  DBView,
  Anonymous425,
  Alerts,
  Anonymous341,
  CredentialChooserService,
  Anonymous378,
  Anonymous534,
  Anonymous030,
  Anonymous223,
  Anonymous216,
  Anonymous104,
  Anonymous506,
  Anonymous119,
  Anonymous529,
  Anonymous469,
  Anonymous189,
  Anonymous097,
  Anonymous621,
  Anonymous457,
  Anonymous451,
  Anonymous255,
  Anonymous338,
  Anonymous140,
  Anonymous082,
  Anonymous591,
  Anonymous507,
  Anonymous165,
  Anonymous360,
  Anonymous256,
  Anonymous127,
  Anonymous019,
  Anonymous087,
  Anonymous344,
  Anonymous592,
  Anonymous233,
  Anonymous012,
  AddonContentPolicy,
  Directory,
  Anonymous662,
  Anonymous318,
  UrlClassifierPrefixSet,
  Compose,
  Anonymous649,
  Anonymous588,
  Anonymous417,
  Anonymous321,
  Anonymous617,
  Anonymous634,
  Anonymous646,
  Anonymous468,
  Anonymous258,
  Anonymous213,
  Anonymous311,
  Anonymous676,
  PrivateAttribution,
  Anonymous212,
  URILoader,
  Anonymous143,
  Anonymous177,
  Anonymous561,
  Anonymous195,
  Anonymous337,
  Anonymous653,
  Anonymous628,
  Anonymous685,
  Anonymous054,
  UrlClassifierStreamUpdater,
  Anonymous549,
  Anonymous597,
  Anonymous156,
  Anonymous085,
  Anonymous251,
  Anonymous068,
  Anonymous186,
  Anonymous042,
  Anonymous298,
  Anonymous495,
  Anonymous176,
  Anonymous463,
  Anonymous287,
  Anonymous055,
  Anonymous072,
  Anonymous477,
  Anonymous144,
  Anonymous017,
  Anonymous306,
  RandomGenerator,
  Anonymous499,
  Anonymous403,
  Anonymous307,
  Anonymous146,
  Anonymous691,
  Anonymous051,
  Anonymous021,
  DNS,
  Anonymous396,
  Imap,
  Anonymous099,
  Anonymous447,
  Anonymous362,
  Anonymous219,
  Anonymous181,
  Anonymous089,
  Anonymous227,
  nsIContentAnalysis,
  Locale,
  Anonymous273,
  Anonymous595,
  Anonymous075,
  Anonymous034,
  Anonymous648,
  Anonymous616,
  Anonymous422,
  Anonymous578,
  Anonymous315,
  RFPService,
  Anonymous347,
  Anonymous350,
  Anonymous209,
  Anonymous504,
  Anonymous376,
  Anonymous453,
  Anonymous503,
  Anonymous100,
  Anonymous263,
  Anonymous575,
  Anonymous498,
  Anonymous160,
  Anonymous091,
  Folder,
  IDN,
  Anonymous279,
  DB,
  Anonymous486,
  CORSPreflightCache,
  Anonymous510,
  URIFixup,
  SocketTransport,
  Anonymous633,
  Anonymous349,
  Anonymous236,
  Anonymous439,
  Anonymous237,
  Anonymous629,
  Anonymous168,
  Copy,
  Anonymous490,
  Anonymous196,
  Anonymous566,
  Anonymous606,
  Anonymous314,
  Anonymous018,
  ExternalProtocolHandler,
  Anonymous551,
  Anonymous436,
  Anonymous029,
  Anonymous158,
  Anonymous636,
  Anonymous543,
  Anonymous246,
  Anonymous668,
  Anonymous407,
  Anonymous164,
  Anonymous626,
  Anonymous059,
  Anonymous599,
  Anonymous404,
  Anonymous475,
  Anonymous312,
  Anonymous003,
  ChromeRegistry,
  Anonymous663,
  Anonymous126,
  Anonymous187,
  Anonymous303,
  Anonymous346,
  Anonymous320,
  Anonymous071,
  Anonymous275,
  Anonymous476,
  Anonymous080,
  Anonymous332,
  Anonymous147,
  Anonymous136,
  Anonymous207,
  Anonymous382,
  Anonymous203,
  Anonymous218,
  Anonymous593,
  Anonymous392,
  Anonymous491,
  Anonymous171,
  Anonymous602,
  Anonymous557,
  Anonymous473,
  PageThumbsStorage,
  Anonymous531,
  Anonymous581,
  Anonymous525,
  Anonymous278,
  Anonymous268,
  Anonymous381,
  Anonymous110,
  Anonymous406,
  Anonymous094,
  Anonymous228,
  Anonymous285,
  Anonymous222,
  Anonymous122,
  Anonymous542,
  ServiceWorkerManager,
  Anonymous670,
  Anonymous049,
  Anonymous296,
  Anonymous180,
  Anonymous608,
  Anonymous121,
  Anonymous554,
  Anonymous173,
  Anonymous063,
  Anonymous587,
  Anonymous428,
  Anonymous518,
  Anonymous400,
  Anonymous590,
  Anonymous527,
  Anonymous328,
  Anonymous365,
  Anonymous090,
  Anonymous443,
  Anonymous500,
  Anonymous073,
  Anonymous560,
  Anonymous083,
  Anonymous148,
  Anonymous426,
  Anonymous409,
  Anonymous061,
  Anonymous659,
  Anonymous026,
  Anonymous269,
  Anonymous511,
  Anonymous345,
  Anonymous632,
  Anonymous316,
  HttpActivityDistributor,
  Anonymous031,
  Anonymous487,
  Anonymous430,
  Anonymous327,
  Anonymous333,
  Anonymous482,
  SystemInfo,
  Anonymous555,
  Anonymous370,
  Anonymous680,
  Anonymous057,
  Anonymous015,
  Anonymous182,
  Anonymous640,
  Anonymous293,
  Anonymous389,
  Anonymous007,
  Anonymous427,
  Anonymous170,
  Anonymous115,
  Anonymous536,
  Anonymous413,
  Anonymous353,
  Anonymous086,
  Anonymous615,
  Anonymous540,
  Console,
  Anonymous149,
  Anonymous288,
  Anonymous563,
  Anonymous458,
  Anonymous603,
  Anonymous526,
  Anonymous155,
  Anonymous225,
  Anonymous154,
  Anonymous679,
  Anonymous204,
  Anonymous393,
  Anonymous517,
  HeaderParser,
  IdentityCredentialPromptService,
  Anonymous319,
  Anonymous431,
  Anonymous113,
  Anonymous229,
  Anonymous454,
  Anonymous206,
  URLQueryStringStripper,
  Anonymous242,
  Anonymous266,
  Anonymous123,
  Anonymous501,
  Anonymous247,
  Anonymous239,
  Anonymous062,
  Anonymous412,
  Anonymous655,
  Anonymous471,
  Anonymous658,
  Anonymous452,
  Anonymous152,
  Anonymous274,
  Anonymous625,
  Anonymous013,
  Anonymous461,
  Anonymous569,
  Anonymous637,
  DocLoader,
  Anonymous521,
  Anonymous397,
  Anonymous559,
  Anonymous624,
  Anonymous108,
  Anonymous016,
  Anonymous139,
  Anonymous096,
  Anonymous589,
  Anonymous418,
  Anonymous605,
  Anonymous568,
  Anonymous107,
  Anonymous446,
  Anonymous039,
  Anonymous650,
  Anonymous276,
  Anonymous056,
  Anonymous178,
  Anonymous331,
  Anonymous419,
  Anonymous570,
  Anonymous502,
  Anonymous535,
  Anonymous249,
  Anonymous357,
  Anonymous481,
  TextToSubURI,
  NSSComponent,
  Anonymous550,
  Anonymous432,
  Anonymous093,
  DownloadPlatform,
  Anonymous384,
  Anonymous459,
  Anonymous240,
  Anonymous496,
  Anonymous441,
  Anonymous163,
  Import,
  Anonymous023,
  Anonymous539,
  Anonymous666,
  Anonymous556,
  Anonymous585,
  Anonymous627,
  Anonymous415,
  Anonymous465,
  Anonymous366,
  Anonymous408,
  Anonymous610,
  Anonymous070,
  Anonymous545,
  Anonymous474,
  Anonymous635,
  Anonymous681,
  Anonymous448,
  Anonymous308,
  Anonymous656,
  Anonymous183,
  Anonymous368,
  Anonymous394,
  Anonymous619,
  Anonymous343,
  Anonymous373,
  Anonymous302,
  Anonymous596,
  Anonymous395,
  Anonymous301,
  Anonymous460,
  Anonymous174,
  Observer,
  Anonymous515,
  GfxInfo,
  Anonymous565,
  Anonymous530,
  Anonymous135,
  FindService,
  Anonymous411,
  Anonymous618,
  AlertNotification,
  Anonymous508,
  Anonymous424,
  Anonymous041,
  Anonymous157,
  Anonymous386,
  Anonymous159,
  UUIDGenerator,
  Anonymous205,
  Anonymous169,
  Anonymous385,
  Anonymous354,

}


#[allow(non_snake_case)]
pub mod AbManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AbManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AbManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod AccountManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AccountManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AccountManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod AddonContentPolicy {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AddonContentPolicy, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AddonContentPolicy, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod AlertNotification {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AlertNotification, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AlertNotification, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Alerts {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Alerts, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Alerts, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod AppStartup {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AppStartup, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AppStartup, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ApplicationReputation {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ApplicationReputation, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod AsyncShutdown {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AsyncShutdown, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AsyncShutdown, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod AuthPromptAdapter {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::AuthPromptAdapter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::AuthPromptAdapter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod BounceTrackingProtection {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::BounceTrackingProtection, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod CORSPreflightCache {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::CORSPreflightCache, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod CacheStorage {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::CacheStorage, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod CaptivePortal {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::CaptivePortal, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod CategoryManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::CategoryManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::CategoryManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ChromeRegistry {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ChromeRegistry, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Compose {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Compose, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Compose, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Console {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Console, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Console, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ContentSecurityManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ContentSecurityManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::ContentSecurityManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod CookieBannerService {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::CookieBannerService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Copy {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Copy, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Copy, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod CredentialChooserService {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::CredentialChooserService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::CredentialChooserService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod DB {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::DB, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::DB, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod DBView {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::DBView, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::DBView, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod DBusHandlerApp {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::DBusHandlerApp, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::DBusHandlerApp, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod DNS {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::DNS, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Dashboard {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Dashboard, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Dashboard, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Directory {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Directory, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Directory, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod DocLoader {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::DocLoader, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::DocLoader, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod DownloadPlatform {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::DownloadPlatform, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::DownloadPlatform, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod EffectiveTLD {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::EffectiveTLD, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ExtensionPolicy {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ExtensionPolicy, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ExternalProtocolHandler {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ExternalProtocolHandler, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::ExternalProtocolHandler, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod FileProtocolHandler {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::FileProtocolHandler, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Filter {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Filter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Filter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod FindService {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::FindService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::FindService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Folder {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Folder, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Folder, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod FolderNotification {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::FolderNotification, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::FolderNotification, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod GfxInfo {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::GfxInfo, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::GfxInfo, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod HeaderParser {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::HeaderParser, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::HeaderParser, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod History {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::History, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod HttpActivityDistributor {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::HttpActivityDistributor, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::HttpActivityDistributor, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod HttpAuthCache {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::HttpAuthCache, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod HttpHandler {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::HttpHandler, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod IDN {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::IDN, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::IDN, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod IO {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::IO, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod IdentityCredentialPromptService {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::IdentityCredentialPromptService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::IdentityCredentialPromptService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod IdentityCredentialStorageService {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::IdentityCredentialStorageService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Imap {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Imap, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Imap, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Import {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Import, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Import, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Locale {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Locale, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod MailSession {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::MailSession, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::MailSession, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod MimeConverter {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::MimeConverter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::MimeConverter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod MimeHeaderParam {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::MimeHeaderParam, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::MimeHeaderParam, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod NSSCertificateDB {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::NSSCertificateDB, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::NSSCertificateDB, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod NSSComponent {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::NSSComponent, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::NSSComponent, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod NSSErrors {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::NSSErrors, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::NSSErrors, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod NetworkErrorLogging {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::NetworkErrorLogging, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Observer {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Observer, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Observer, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod OutgoingServer {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::OutgoingServer, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::OutgoingServer, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod PageThumbsStorage {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::PageThumbsStorage, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::PageThumbsStorage, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod PermissionManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::PermissionManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod PlacesPreviewsHelper {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::PlacesPreviewsHelper, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::PlacesPreviewsHelper, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Preferences {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Preferences, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Prefetch {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Prefetch, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Prefetch, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod PrivateAttribution {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::PrivateAttribution, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::PrivateAttribution, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ProtocolProxy {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ProtocolProxy, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod RFPService {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::RFPService, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod RandomGenerator {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::RandomGenerator, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::RandomGenerator, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ScriptSecurityManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ScriptSecurityManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::ScriptSecurityManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ServiceWorkerManager {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ServiceWorkerManager, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod SiteSecurity {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::SiteSecurity, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::SiteSecurity, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod SocketTransport {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::SocketTransport, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod StreamConverter {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::StreamConverter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::StreamConverter, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod StreamTransport {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::StreamTransport, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::StreamTransport, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod StringBundle {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::StringBundle, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::StringBundle, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod SystemInfo {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::SystemInfo, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::SystemInfo, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod Tag {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::Tag, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::Tag, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod TextToSubURI {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::TextToSubURI, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::TextToSubURI, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod ThirdPartyUtil {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::ThirdPartyUtil, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::ThirdPartyUtil, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod TypeAheadFind {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::TypeAheadFind, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::TypeAheadFind, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod URIFixup {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::URIFixup, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod URILoader {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::URILoader, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::URILoader, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod URLQueryStringStripper {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::URLQueryStringStripper, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod UUIDGenerator {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::UUIDGenerator, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::UUIDGenerator, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod UrlClassifierDB {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::UrlClassifierDB, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::UrlClassifierDB, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod UrlClassifierPrefixSet {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::UrlClassifierPrefixSet, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::UrlClassifierPrefixSet, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod UrlClassifierStreamUpdater {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::UrlClassifierStreamUpdater, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::UrlClassifierStreamUpdater, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod UrlClassifierTestUtils {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::UrlClassifierTestUtils, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::UrlClassifierTestUtils, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod UrlClassifierUtils {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::UrlClassifierUtils, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::UrlClassifierUtils, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod WifiMonitor {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::WifiMonitor, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod WindowWatcher {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::WindowWatcher, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::WindowWatcher, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod XULRuntime {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::XULRuntime, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::XULRuntime, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

#[allow(non_snake_case)]
pub mod nsIContentAnalysis {
    /// Get the singleton service instance for this component.
    pub fn service<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_GetServiceByModuleID(super::ModuleID::nsIContentAnalysis, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }

    /// Create a new instance of this component.
    pub fn create<T: crate::XpCom>() -> Result<crate::RefPtr<T>, nserror::nsresult> {
        let mut ga = crate::GetterAddrefs::<T>::new();
        let rv = unsafe { super::Gecko_CreateInstanceByModuleID(super::ModuleID::nsIContentAnalysis, &T::IID, ga.void_ptr()) };
        if rv.failed() {
            return Err(rv);
        }
        ga.refptr().ok_or(nserror::NS_ERROR_NO_INTERFACE)
    }
}

