mod n0 {
// This code was autogenerated with `dbus-codegen-rust `, see https://github.com/diwic/dbus-rs
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait StatusNotifierWatcher {
    fn register_status_notifier_item(&self, service: &str) -> Result<(), dbus::Error>;
    fn register_status_notifier_host(&self, service: &str) -> Result<(), dbus::Error>;
    fn registered_status_notifier_items(&self) -> Result<Vec<String>, dbus::Error>;
    fn is_status_notifier_host_registered(&self) -> Result<bool, dbus::Error>;
    fn protocol_version(&self) -> Result<i32, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> StatusNotifierWatcher for blocking::Proxy<'a, C> {

    fn register_status_notifier_item(&self, service: &str) -> Result<(), dbus::Error> {
        self.method_call("org.kde.StatusNotifierWatcher", "RegisterStatusNotifierItem", (service, ))
    }

    fn register_status_notifier_host(&self, service: &str) -> Result<(), dbus::Error> {
        self.method_call("org.kde.StatusNotifierWatcher", "RegisterStatusNotifierHost", (service, ))
    }

    fn registered_status_notifier_items(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.kde.StatusNotifierWatcher", "RegisteredStatusNotifierItems")
    }

    fn is_status_notifier_host_registered(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.kde.StatusNotifierWatcher", "IsStatusNotifierHostRegistered")
    }

    fn protocol_version(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.kde.StatusNotifierWatcher", "ProtocolVersion")
    }
}

#[derive(Debug)]
pub struct StatusNotifierWatcherStatusNotifierItemRegistered {
    pub arg0: String,
}

impl arg::AppendAll for StatusNotifierWatcherStatusNotifierItemRegistered {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
    }
}

impl arg::ReadAll for StatusNotifierWatcherStatusNotifierItemRegistered {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierWatcherStatusNotifierItemRegistered {
            arg0: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierWatcherStatusNotifierItemRegistered {
    const NAME: &'static str = "StatusNotifierItemRegistered";
    const INTERFACE: &'static str = "org.kde.StatusNotifierWatcher";
}

#[derive(Debug)]
pub struct StatusNotifierWatcherStatusNotifierItemUnregistered {
    pub arg0: String,
}

impl arg::AppendAll for StatusNotifierWatcherStatusNotifierItemUnregistered {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
    }
}

impl arg::ReadAll for StatusNotifierWatcherStatusNotifierItemUnregistered {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierWatcherStatusNotifierItemUnregistered {
            arg0: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierWatcherStatusNotifierItemUnregistered {
    const NAME: &'static str = "StatusNotifierItemUnregistered";
    const INTERFACE: &'static str = "org.kde.StatusNotifierWatcher";
}

#[derive(Debug)]
pub struct StatusNotifierWatcherStatusNotifierHostRegistered {
}

impl arg::AppendAll for StatusNotifierWatcherStatusNotifierHostRegistered {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierWatcherStatusNotifierHostRegistered {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierWatcherStatusNotifierHostRegistered {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierWatcherStatusNotifierHostRegistered {
    const NAME: &'static str = "StatusNotifierHostRegistered";
    const INTERFACE: &'static str = "org.kde.StatusNotifierWatcher";
}

#[derive(Debug)]
pub struct StatusNotifierWatcherStatusNotifierHostUnregistered {
}

impl arg::AppendAll for StatusNotifierWatcherStatusNotifierHostUnregistered {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierWatcherStatusNotifierHostUnregistered {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierWatcherStatusNotifierHostUnregistered {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierWatcherStatusNotifierHostUnregistered {
    const NAME: &'static str = "StatusNotifierHostUnregistered";
    const INTERFACE: &'static str = "org.kde.StatusNotifierWatcher";
}

}
pub use n0::*;
mod n1 {
// This code was autogenerated with `dbus-codegen-rust `, see https://github.com/diwic/dbus-rs
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus_tree as tree;

pub trait StatusNotifierItem {
    fn context_menu(&self, x_: i32, y_: i32) -> Result<(), tree::MethodErr>;
    fn activate(&self, x_: i32, y_: i32) -> Result<(), tree::MethodErr>;
    fn secondary_activate(&self, x_: i32, y_: i32) -> Result<(), tree::MethodErr>;
    fn scroll(&self, delta: i32, orientation: &str) -> Result<(), tree::MethodErr>;
    fn category(&self) -> Result<String, tree::MethodErr>;
    fn id(&self) -> Result<String, tree::MethodErr>;
    fn title(&self) -> Result<String, tree::MethodErr>;
    fn status(&self) -> Result<String, tree::MethodErr>;
    fn window_id(&self) -> Result<i32, tree::MethodErr>;
    fn icon_theme_path(&self) -> Result<String, tree::MethodErr>;
    fn menu(&self) -> Result<dbus::Path<'static>, tree::MethodErr>;
    fn item_is_menu(&self) -> Result<bool, tree::MethodErr>;
    fn icon_name(&self) -> Result<String, tree::MethodErr>;
    fn icon_pixmap(&self) -> Result<Vec<(i32, i32, Vec<u8>)>, tree::MethodErr>;
    fn overlay_icon_name(&self) -> Result<String, tree::MethodErr>;
    fn overlay_icon_pixmap(&self) -> Result<Vec<(i32, i32, Vec<u8>)>, tree::MethodErr>;
    fn attention_icon_name(&self) -> Result<String, tree::MethodErr>;
    fn attention_icon_pixmap(&self) -> Result<Vec<(i32, i32, Vec<u8>)>, tree::MethodErr>;
    fn attention_movie_name(&self) -> Result<String, tree::MethodErr>;
    fn tool_tip(&self) -> Result<(String, Vec<(i32, i32, Vec<u8>)>, String, String), tree::MethodErr>;
}

pub fn status_notifier_item_server<F, T, D>(factory: &tree::Factory<tree::MTFn<D>, D>, data: D::Interface, f: F) -> tree::Interface<tree::MTFn<D>, D>
where
    D: tree::DataType,
    D::Method: Default,
    D::Property: Default,
    D::Signal: Default,
    T: AsRef<dyn StatusNotifierItem>,
    F: 'static + Fn(&tree::MethodInfo<tree::MTFn<D>, D>) -> T,
{
    let i = factory.interface("org.kde.StatusNotifierItem", data);
    let f = ::std::sync::Arc::new(f);
    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let x_: i32 = i.read()?;
        let y_: i32 = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        d.context_menu(x_, y_)?;
        let rm = minfo.msg.method_return();
        Ok(vec!(rm))
    };
    let m = factory.method("ContextMenu", Default::default(), h);
    let m = m.in_arg(("x", "i"));
    let m = m.in_arg(("y", "i"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let x_: i32 = i.read()?;
        let y_: i32 = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        d.activate(x_, y_)?;
        let rm = minfo.msg.method_return();
        Ok(vec!(rm))
    };
    let m = factory.method("Activate", Default::default(), h);
    let m = m.in_arg(("x", "i"));
    let m = m.in_arg(("y", "i"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let x_: i32 = i.read()?;
        let y_: i32 = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        d.secondary_activate(x_, y_)?;
        let rm = minfo.msg.method_return();
        Ok(vec!(rm))
    };
    let m = factory.method("SecondaryActivate", Default::default(), h);
    let m = m.in_arg(("x", "i"));
    let m = m.in_arg(("y", "i"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let delta: i32 = i.read()?;
        let orientation: &str = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        d.scroll(delta, orientation)?;
        let rm = minfo.msg.method_return();
        Ok(vec!(rm))
    };
    let m = factory.method("Scroll", Default::default(), h);
    let m = m.in_arg(("delta", "i"));
    let m = m.in_arg(("orientation", "s"));
    let i = i.add_m(m);

    let p = factory.property::<&str, _>("Category", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.category()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("Id", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.id()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("Title", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.title()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("Status", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.status()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<i32, _>("WindowId", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.window_id()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("IconThemePath", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.icon_theme_path()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<dbus::Path, _>("Menu", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.menu()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<bool, _>("ItemIsMenu", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.item_is_menu()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("IconName", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.icon_name()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<Vec<(i32, i32, Vec<u8>)>, _>("IconPixmap", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.icon_pixmap()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("OverlayIconName", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.overlay_icon_name()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<Vec<(i32, i32, Vec<u8>)>, _>("OverlayIconPixmap", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.overlay_icon_pixmap()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("AttentionIconName", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.attention_icon_name()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<Vec<(i32, i32, Vec<u8>)>, _>("AttentionIconPixmap", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.attention_icon_pixmap()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("AttentionMovieName", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.attention_movie_name()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<(&str, Vec<(i32, i32, Vec<u8>)>, &str, &str), _>("ToolTip", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.tool_tip()?);
        Ok(())
    });
    let i = i.add_p(p);
    let s = factory.signal("NewTitle", Default::default());
    let i = i.add_s(s);
    let s = factory.signal("NewIcon", Default::default());
    let i = i.add_s(s);
    let s = factory.signal("NewAttentionIcon", Default::default());
    let i = i.add_s(s);
    let s = factory.signal("NewOverlayIcon", Default::default());
    let i = i.add_s(s);
    let s = factory.signal("NewToolTip", Default::default());
    let i = i.add_s(s);
    let s = factory.signal("NewStatus", Default::default());
    let s = s.arg(("status", "s"));
    let i = i.add_s(s);
    i
}

#[derive(Debug)]
pub struct StatusNotifierItemNewTitle {
}

impl arg::AppendAll for StatusNotifierItemNewTitle {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierItemNewTitle {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierItemNewTitle {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierItemNewTitle {
    const NAME: &'static str = "NewTitle";
    const INTERFACE: &'static str = "org.kde.StatusNotifierItem";
}

#[derive(Debug)]
pub struct StatusNotifierItemNewIcon {
}

impl arg::AppendAll for StatusNotifierItemNewIcon {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierItemNewIcon {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierItemNewIcon {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierItemNewIcon {
    const NAME: &'static str = "NewIcon";
    const INTERFACE: &'static str = "org.kde.StatusNotifierItem";
}

#[derive(Debug)]
pub struct StatusNotifierItemNewAttentionIcon {
}

impl arg::AppendAll for StatusNotifierItemNewAttentionIcon {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierItemNewAttentionIcon {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierItemNewAttentionIcon {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierItemNewAttentionIcon {
    const NAME: &'static str = "NewAttentionIcon";
    const INTERFACE: &'static str = "org.kde.StatusNotifierItem";
}

#[derive(Debug)]
pub struct StatusNotifierItemNewOverlayIcon {
}

impl arg::AppendAll for StatusNotifierItemNewOverlayIcon {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierItemNewOverlayIcon {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierItemNewOverlayIcon {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierItemNewOverlayIcon {
    const NAME: &'static str = "NewOverlayIcon";
    const INTERFACE: &'static str = "org.kde.StatusNotifierItem";
}

#[derive(Debug)]
pub struct StatusNotifierItemNewToolTip {
}

impl arg::AppendAll for StatusNotifierItemNewToolTip {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for StatusNotifierItemNewToolTip {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierItemNewToolTip {
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierItemNewToolTip {
    const NAME: &'static str = "NewToolTip";
    const INTERFACE: &'static str = "org.kde.StatusNotifierItem";
}

#[derive(Debug)]
pub struct StatusNotifierItemNewStatus {
    pub status: String,
}

impl arg::AppendAll for StatusNotifierItemNewStatus {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.status, i);
    }
}

impl arg::ReadAll for StatusNotifierItemNewStatus {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(StatusNotifierItemNewStatus {
            status: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for StatusNotifierItemNewStatus {
    const NAME: &'static str = "NewStatus";
    const INTERFACE: &'static str = "org.kde.StatusNotifierItem";
}

}
pub use n1::*;
mod n2 {
// This code was autogenerated with `dbus-codegen-rust `, see https://github.com/diwic/dbus-rs
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus_tree as tree;

pub trait Dbusmenu {
    fn get_layout(&self, parent_id: i32, recursion_depth: i32, property_names: Vec<&str>) -> Result<(u32, (i32, arg::PropMap, Vec<arg::Variant<Box<dyn arg::RefArg + 'static>>>)), tree::MethodErr>;
    fn get_group_properties(&self, ids: Vec<i32>, property_names: Vec<&str>) -> Result<Vec<(i32, arg::PropMap)>, tree::MethodErr>;
    fn get_property(&self, id: i32, name: &str) -> Result<arg::Variant<Box<dyn arg::RefArg + 'static>>, tree::MethodErr>;
    fn event(&self, id: i32, event_id: &str, data: arg::Variant<Box<dyn arg::RefArg>>, timestamp: u32) -> Result<(), tree::MethodErr>;
    fn event_group(&self, events: Vec<(i32, &str, arg::Variant<Box<dyn arg::RefArg>>, u32)>) -> Result<Vec<i32>, tree::MethodErr>;
    fn about_to_show(&self, id: i32) -> Result<bool, tree::MethodErr>;
    fn about_to_show_group(&self, ids: Vec<i32>) -> Result<(Vec<i32>, Vec<i32>), tree::MethodErr>;
    fn version(&self) -> Result<u32, tree::MethodErr>;
    fn text_direction(&self) -> Result<String, tree::MethodErr>;
    fn status(&self) -> Result<String, tree::MethodErr>;
    fn icon_theme_path(&self) -> Result<Vec<String>, tree::MethodErr>;
}

pub fn dbusmenu_server<F, T, D>(factory: &tree::Factory<tree::MTFn<D>, D>, data: D::Interface, f: F) -> tree::Interface<tree::MTFn<D>, D>
where
    D: tree::DataType,
    D::Method: Default,
    D::Property: Default,
    D::Signal: Default,
    T: AsRef<dyn Dbusmenu>,
    F: 'static + Fn(&tree::MethodInfo<tree::MTFn<D>, D>) -> T,
{
    let i = factory.interface("com.canonical.dbusmenu", data);
    let f = ::std::sync::Arc::new(f);
    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let parent_id: i32 = i.read()?;
        let recursion_depth: i32 = i.read()?;
        let property_names: Vec<&str> = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        let (revision, layout) = d.get_layout(parent_id, recursion_depth, property_names)?;
        let rm = minfo.msg.method_return();
        let rm = rm.append1(revision);
        let rm = rm.append1(layout);
        Ok(vec!(rm))
    };
    let m = factory.method("GetLayout", Default::default(), h);
    let m = m.in_arg(("parentId", "i"));
    let m = m.in_arg(("recursionDepth", "i"));
    let m = m.in_arg(("propertyNames", "as"));
    let m = m.out_arg(("revision", "u"));
    let m = m.out_arg(("layout", "(ia{sv}av)"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let ids: Vec<i32> = i.read()?;
        let property_names: Vec<&str> = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        let properties = d.get_group_properties(ids, property_names)?;
        let rm = minfo.msg.method_return();
        let rm = rm.append1(properties);
        Ok(vec!(rm))
    };
    let m = factory.method("GetGroupProperties", Default::default(), h);
    let m = m.in_arg(("ids", "ai"));
    let m = m.in_arg(("propertyNames", "as"));
    let m = m.out_arg(("properties", "a(ia{sv})"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let id: i32 = i.read()?;
        let name: &str = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        let value = d.get_property(id, name)?;
        let rm = minfo.msg.method_return();
        let rm = rm.append1(value);
        Ok(vec!(rm))
    };
    let m = factory.method("GetProperty", Default::default(), h);
    let m = m.in_arg(("id", "i"));
    let m = m.in_arg(("name", "s"));
    let m = m.out_arg(("value", "v"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let id: i32 = i.read()?;
        let event_id: &str = i.read()?;
        let data: arg::Variant<Box<dyn arg::RefArg>> = i.read()?;
        let timestamp: u32 = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        d.event(id, event_id, data, timestamp)?;
        let rm = minfo.msg.method_return();
        Ok(vec!(rm))
    };
    let m = factory.method("Event", Default::default(), h);
    let m = m.in_arg(("id", "i"));
    let m = m.in_arg(("eventId", "s"));
    let m = m.in_arg(("data", "v"));
    let m = m.in_arg(("timestamp", "u"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let events: Vec<(i32, &str, arg::Variant<Box<dyn arg::RefArg>>, u32)> = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        let id_errors = d.event_group(events)?;
        let rm = minfo.msg.method_return();
        let rm = rm.append1(id_errors);
        Ok(vec!(rm))
    };
    let m = factory.method("EventGroup", Default::default(), h);
    let m = m.in_arg(("events", "a(isvu)"));
    let m = m.out_arg(("idErrors", "ai"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let id: i32 = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        let need_update = d.about_to_show(id)?;
        let rm = minfo.msg.method_return();
        let rm = rm.append1(need_update);
        Ok(vec!(rm))
    };
    let m = factory.method("AboutToShow", Default::default(), h);
    let m = m.in_arg(("id", "i"));
    let m = m.out_arg(("needUpdate", "b"));
    let i = i.add_m(m);

    let fclone = f.clone();
    let h = move |minfo: &tree::MethodInfo<tree::MTFn<D>, D>| {
        let mut i = minfo.msg.iter_init();
        let ids: Vec<i32> = i.read()?;
        let dd = fclone(minfo);
        let d = dd.as_ref();
        let (updates_needed, id_errors) = d.about_to_show_group(ids)?;
        let rm = minfo.msg.method_return();
        let rm = rm.append1(updates_needed);
        let rm = rm.append1(id_errors);
        Ok(vec!(rm))
    };
    let m = factory.method("AboutToShowGroup", Default::default(), h);
    let m = m.in_arg(("ids", "ai"));
    let m = m.out_arg(("updatesNeeded", "ai"));
    let m = m.out_arg(("idErrors", "ai"));
    let i = i.add_m(m);

    let p = factory.property::<u32, _>("Version", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.version()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("TextDirection", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.text_direction()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<&str, _>("Status", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.status()?);
        Ok(())
    });
    let i = i.add_p(p);

    let p = factory.property::<Vec<&str>, _>("IconThemePath", Default::default());
    let p = p.access(tree::Access::Read);
    let fclone = f.clone();
    let p = p.on_get(move |a, pinfo| {
        let minfo = pinfo.to_method_info();
        let dd = fclone(&minfo);
        let d = dd.as_ref();
        a.append(d.icon_theme_path()?);
        Ok(())
    });
    let i = i.add_p(p);
    let s = factory.signal("ItemsPropertiesUpdated", Default::default());
    let s = s.arg(("updatedProps", "a(ia{sv})"));
    let s = s.arg(("removedProps", "a(ias)"));
    let i = i.add_s(s);
    let s = factory.signal("LayoutUpdated", Default::default());
    let s = s.arg(("revision", "u"));
    let s = s.arg(("parent", "i"));
    let i = i.add_s(s);
    let s = factory.signal("ItemActivationRequested", Default::default());
    let s = s.arg(("id", "i"));
    let s = s.arg(("timestamp", "u"));
    let i = i.add_s(s);
    i
}

#[derive(Debug)]
pub struct DbusmenuItemsPropertiesUpdated {
    pub updated_props: Vec<(i32, arg::PropMap)>,
    pub removed_props: Vec<(i32, Vec<String>)>,
}

impl arg::AppendAll for DbusmenuItemsPropertiesUpdated {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.updated_props, i);
        arg::RefArg::append(&self.removed_props, i);
    }
}

impl arg::ReadAll for DbusmenuItemsPropertiesUpdated {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DbusmenuItemsPropertiesUpdated {
            updated_props: i.read()?,
            removed_props: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DbusmenuItemsPropertiesUpdated {
    const NAME: &'static str = "ItemsPropertiesUpdated";
    const INTERFACE: &'static str = "com.canonical.dbusmenu";
}

#[derive(Debug)]
pub struct DbusmenuLayoutUpdated {
    pub revision: u32,
    pub parent: i32,
}

impl arg::AppendAll for DbusmenuLayoutUpdated {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.revision, i);
        arg::RefArg::append(&self.parent, i);
    }
}

impl arg::ReadAll for DbusmenuLayoutUpdated {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DbusmenuLayoutUpdated {
            revision: i.read()?,
            parent: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DbusmenuLayoutUpdated {
    const NAME: &'static str = "LayoutUpdated";
    const INTERFACE: &'static str = "com.canonical.dbusmenu";
}

#[derive(Debug)]
pub struct DbusmenuItemActivationRequested {
    pub id: i32,
    pub timestamp: u32,
}

impl arg::AppendAll for DbusmenuItemActivationRequested {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.id, i);
        arg::RefArg::append(&self.timestamp, i);
    }
}

impl arg::ReadAll for DbusmenuItemActivationRequested {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DbusmenuItemActivationRequested {
            id: i.read()?,
            timestamp: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DbusmenuItemActivationRequested {
    const NAME: &'static str = "ItemActivationRequested";
    const INTERFACE: &'static str = "com.canonical.dbusmenu";
}

}
pub use n2::*;
