//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PresState_h
#define PresState_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/dom/BlobImpl.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "nsPoint.h"
#include "mozilla/dom/CustomElementTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SelectContentData|
//
namespace mozilla {
class SelectContentData final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SelectContentData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SelectContentData(
            const nsTArray<uint32_t>& _indices,
            const nsTArray<nsString>& _values) :
        indices_(_indices),
        values_(_values)
    {
    }

    MOZ_IMPLICIT SelectContentData(
            nsTArray<uint32_t>&& _indices,
            nsTArray<nsString>&& _values) :
        indices_(std::move(_indices)),
        values_(std::move(_values))
    {
    }

    nsTArray<uint32_t>&
    indices()
    {
        return indices_;
    }
    const nsTArray<uint32_t>&
    indices() const
    {
        return indices_;
    }

    nsTArray<nsString>&
    values()
    {
        return values_;
    }
    const nsTArray<nsString>&
    values() const
    {
        return values_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<uint32_t>> indices_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsString>> values_;
};
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::SelectContentData>
{
    typedef ::mozilla::SelectContentData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CheckedContentData|
//
namespace mozilla {
class CheckedContentData final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CheckedContentData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CheckedContentData(const bool& _checked) :
        checked_(_checked)
    {
    }

    MOZ_IMPLICIT CheckedContentData(bool&& _checked) :
        checked_(std::move(_checked))
    {
    }

    bool&
    checked()
    {
        return checked_;
    }
    const bool&
    checked() const
    {
        return checked_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> checked_;
};
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::CheckedContentData>
{
    typedef ::mozilla::CheckedContentData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileContentData|
//
namespace mozilla {
class FileContentData final
{
public:
    enum Type {
        T__None,
        TBlobImpl = 1,
        TnsString,
        T__Last = TnsString
    };

private:
    typedef ::mozilla::dom::BlobImpl BlobImpl;
    typedef ::nsString nsString;
    typedef RefPtr<BlobImpl> BlobImpl__tdef;
    typedef nsString nsString__tdef;

    RefPtr<BlobImpl>*
    ptr_BlobImpl()
    {
        return (&(mVBlobImpl));
    }
    const RefPtr<BlobImpl>*
    constptr_BlobImpl() const
    {
        return (&(mVBlobImpl));
    }
    nsString*
    ptr_nsString()
    {
        return (&(mVnsString));
    }
    const nsString*
    constptr_nsString() const
    {
        return (&(mVnsString));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileContentData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileContentData(BlobImpl* aOther);

    MOZ_IMPLICIT FileContentData(RefPtr<BlobImpl>&& aOther);

    MOZ_IMPLICIT FileContentData(const nsString& aOther);

    MOZ_IMPLICIT FileContentData(nsString&& aOther);

    MOZ_IMPLICIT FileContentData(const FileContentData& aOther);

    MOZ_IMPLICIT FileContentData(FileContentData&& aOther);

    ~FileContentData();

    Type
    type() const
    {
        return mType;
    }

    FileContentData&
    operator=(BlobImpl* aRhs);

    FileContentData&
    operator=(RefPtr<BlobImpl>&& aRhs);

    FileContentData&
    operator=(const nsString& aRhs);

    FileContentData&
    operator=(nsString&& aRhs);

    FileContentData&
    operator=(const FileContentData& aRhs);

    FileContentData&
    operator=(FileContentData&& aRhs);

    RefPtr<BlobImpl>&
    get_BlobImpl()
    {
        AssertSanity(TBlobImpl);
        return (*(ptr_BlobImpl()));
    }
    BlobImpl*
    get_BlobImpl() const
    {
        AssertSanity(TBlobImpl);
        return (*(constptr_BlobImpl()));
    }
    operator RefPtr<BlobImpl>&()
    {
        return get_BlobImpl();
    }
    operator BlobImpl*() const
    {
        return get_BlobImpl();
    }

    nsString&
    get_nsString()
    {
        AssertSanity(TnsString);
        return (*(ptr_nsString()));
    }
    const nsString&
    get_nsString() const
    {
        AssertSanity(TnsString);
        return (*(constptr_nsString()));
    }
    operator nsString&()
    {
        return get_nsString();
    }
    operator const nsString&() const
    {
        return get_nsString();
    }

private:
    union {
        RefPtr<BlobImpl> mVBlobImpl;
        nsString mVnsString;
    };
    Type mType;
};
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::FileContentData>
{
    typedef ::mozilla::FileContentData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TextContentData|
//
namespace mozilla {
class TextContentData final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TextContentData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TextContentData(
            const nsString& _value,
            const bool& _lastValueChangeWasInteractive) :
        value_(_value),
        lastValueChangeWasInteractive_(_lastValueChangeWasInteractive)
    {
    }

    MOZ_IMPLICIT TextContentData(
            nsString&& _value,
            bool&& _lastValueChangeWasInteractive) :
        value_(std::move(_value)),
        lastValueChangeWasInteractive_(std::move(_lastValueChangeWasInteractive))
    {
    }

    nsString&
    value()
    {
        return value_;
    }
    const nsString&
    value() const
    {
        return value_;
    }

    bool&
    lastValueChangeWasInteractive()
    {
        return lastValueChangeWasInteractive_;
    }
    const bool&
    lastValueChangeWasInteractive() const
    {
        return lastValueChangeWasInteractive_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> value_;
    ::mozilla::ipc::IPDLStructMember<bool> lastValueChangeWasInteractive_;
};
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::TextContentData>
{
    typedef ::mozilla::TextContentData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union PresContentData|
//
namespace mozilla {
class PresContentData final
{
public:
    enum Type {
        T__None,
        Tvoid_t = 1,
        TTextContentData,
        TSelectContentData,
        TCheckedContentData,
        TArrayOfFileContentData,
        TCustomElementTuple,
        T__Last = TCustomElementTuple
    };

private:
    typedef ::mozilla::void_t void_t;
    typedef ::mozilla::TextContentData TextContentData;
    typedef ::mozilla::SelectContentData SelectContentData;
    typedef ::mozilla::CheckedContentData CheckedContentData;
    typedef ::mozilla::FileContentData FileContentData;
    typedef ::mozilla::dom::CustomElementTuple CustomElementTuple;
    typedef void_t void_t__tdef;
    typedef TextContentData TextContentData__tdef;
    typedef SelectContentData SelectContentData__tdef;
    typedef CheckedContentData CheckedContentData__tdef;
    typedef nsTArray<FileContentData> ArrayOfFileContentData__tdef;
    typedef CustomElementTuple CustomElementTuple__tdef;

    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }
    TextContentData*
    ptr_TextContentData()
    {
        return (&(mVTextContentData));
    }
    const TextContentData*
    constptr_TextContentData() const
    {
        return (&(mVTextContentData));
    }
    SelectContentData*
    ptr_SelectContentData()
    {
        return (&(mVSelectContentData));
    }
    const SelectContentData*
    constptr_SelectContentData() const
    {
        return (&(mVSelectContentData));
    }
    CheckedContentData*
    ptr_CheckedContentData()
    {
        return (&(mVCheckedContentData));
    }
    const CheckedContentData*
    constptr_CheckedContentData() const
    {
        return (&(mVCheckedContentData));
    }
    nsTArray<FileContentData>*
    ptr_ArrayOfFileContentData()
    {
        return (&(mVArrayOfFileContentData));
    }
    const nsTArray<FileContentData>*
    constptr_ArrayOfFileContentData() const
    {
        return (&(mVArrayOfFileContentData));
    }
    CustomElementTuple*
    ptr_CustomElementTuple()
    {
        return (&(mVCustomElementTuple));
    }
    const CustomElementTuple*
    constptr_CustomElementTuple() const
    {
        return (&(mVCustomElementTuple));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT PresContentData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT PresContentData(const void_t& aOther);

    MOZ_IMPLICIT PresContentData(void_t&& aOther);

    MOZ_IMPLICIT PresContentData(const TextContentData& aOther);

    MOZ_IMPLICIT PresContentData(TextContentData&& aOther);

    MOZ_IMPLICIT PresContentData(const SelectContentData& aOther);

    MOZ_IMPLICIT PresContentData(SelectContentData&& aOther);

    MOZ_IMPLICIT PresContentData(const CheckedContentData& aOther);

    MOZ_IMPLICIT PresContentData(CheckedContentData&& aOther);

    MOZ_IMPLICIT PresContentData(const nsTArray<FileContentData>& aOther);

    MOZ_IMPLICIT PresContentData(nsTArray<FileContentData>&& aOther);

    MOZ_IMPLICIT PresContentData(const CustomElementTuple& aOther);

    MOZ_IMPLICIT PresContentData(CustomElementTuple&& aOther);

    MOZ_IMPLICIT PresContentData(const PresContentData& aOther);

    MOZ_IMPLICIT PresContentData(PresContentData&& aOther);

    ~PresContentData();

    Type
    type() const
    {
        return mType;
    }

    PresContentData&
    operator=(const void_t& aRhs);

    PresContentData&
    operator=(void_t&& aRhs);

    PresContentData&
    operator=(const TextContentData& aRhs);

    PresContentData&
    operator=(TextContentData&& aRhs);

    PresContentData&
    operator=(const SelectContentData& aRhs);

    PresContentData&
    operator=(SelectContentData&& aRhs);

    PresContentData&
    operator=(const CheckedContentData& aRhs);

    PresContentData&
    operator=(CheckedContentData&& aRhs);

    PresContentData&
    operator=(const nsTArray<FileContentData>& aRhs);

    PresContentData&
    operator=(nsTArray<FileContentData>&& aRhs);

    PresContentData&
    operator=(const CustomElementTuple& aRhs);

    PresContentData&
    operator=(CustomElementTuple&& aRhs);

    PresContentData&
    operator=(const PresContentData& aRhs);

    PresContentData&
    operator=(PresContentData&& aRhs);

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

    TextContentData&
    get_TextContentData()
    {
        AssertSanity(TTextContentData);
        return (*(ptr_TextContentData()));
    }
    const TextContentData&
    get_TextContentData() const
    {
        AssertSanity(TTextContentData);
        return (*(constptr_TextContentData()));
    }
    operator TextContentData&()
    {
        return get_TextContentData();
    }
    operator const TextContentData&() const
    {
        return get_TextContentData();
    }

    SelectContentData&
    get_SelectContentData()
    {
        AssertSanity(TSelectContentData);
        return (*(ptr_SelectContentData()));
    }
    const SelectContentData&
    get_SelectContentData() const
    {
        AssertSanity(TSelectContentData);
        return (*(constptr_SelectContentData()));
    }
    operator SelectContentData&()
    {
        return get_SelectContentData();
    }
    operator const SelectContentData&() const
    {
        return get_SelectContentData();
    }

    CheckedContentData&
    get_CheckedContentData()
    {
        AssertSanity(TCheckedContentData);
        return (*(ptr_CheckedContentData()));
    }
    const CheckedContentData&
    get_CheckedContentData() const
    {
        AssertSanity(TCheckedContentData);
        return (*(constptr_CheckedContentData()));
    }
    operator CheckedContentData&()
    {
        return get_CheckedContentData();
    }
    operator const CheckedContentData&() const
    {
        return get_CheckedContentData();
    }

    nsTArray<FileContentData>&
    get_ArrayOfFileContentData()
    {
        AssertSanity(TArrayOfFileContentData);
        return (*(ptr_ArrayOfFileContentData()));
    }
    const nsTArray<FileContentData>&
    get_ArrayOfFileContentData() const
    {
        AssertSanity(TArrayOfFileContentData);
        return (*(constptr_ArrayOfFileContentData()));
    }
    operator nsTArray<FileContentData>&()
    {
        return get_ArrayOfFileContentData();
    }
    operator const nsTArray<FileContentData>&() const
    {
        return get_ArrayOfFileContentData();
    }

    CustomElementTuple&
    get_CustomElementTuple()
    {
        AssertSanity(TCustomElementTuple);
        return (*(ptr_CustomElementTuple()));
    }
    const CustomElementTuple&
    get_CustomElementTuple() const
    {
        AssertSanity(TCustomElementTuple);
        return (*(constptr_CustomElementTuple()));
    }
    operator CustomElementTuple&()
    {
        return get_CustomElementTuple();
    }
    operator const CustomElementTuple&() const
    {
        return get_CustomElementTuple();
    }

private:
    union {
        void_t mVvoid_t;
        TextContentData mVTextContentData;
        SelectContentData mVSelectContentData;
        CheckedContentData mVCheckedContentData;
        nsTArray<FileContentData> mVArrayOfFileContentData;
        CustomElementTuple mVCustomElementTuple;
    };
    Type mType;
};
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::PresContentData>
{
    typedef ::mozilla::PresContentData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct PresState|
//
namespace mozilla {
class PresState final
{
private:
    typedef ::mozilla::PresContentData PresContentData;
    typedef ::nsPoint nsPoint;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    PresState() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT PresState(
            const PresContentData& _contentData,
            const nsPoint& _scrollState,
            const bool& _allowScrollOriginDowngrade,
            const float& _resolution,
            const bool& _disabledSet,
            const bool& _disabled,
            const bool& _droppedDown) :
        contentData_(_contentData),
        scrollState_(_scrollState),
        allowScrollOriginDowngrade_(_allowScrollOriginDowngrade),
        disabledSet_(_disabledSet),
        disabled_(_disabled),
        droppedDown_(_droppedDown),
        resolution_(_resolution)
    {
    }

    MOZ_IMPLICIT PresState(
            PresContentData&& _contentData,
            nsPoint&& _scrollState,
            bool&& _allowScrollOriginDowngrade,
            float&& _resolution,
            bool&& _disabledSet,
            bool&& _disabled,
            bool&& _droppedDown) :
        contentData_(std::move(_contentData)),
        scrollState_(std::move(_scrollState)),
        allowScrollOriginDowngrade_(std::move(_allowScrollOriginDowngrade)),
        disabledSet_(std::move(_disabledSet)),
        disabled_(std::move(_disabled)),
        droppedDown_(std::move(_droppedDown)),
        resolution_(std::move(_resolution))
    {
    }

    PresContentData&
    contentData()
    {
        return contentData_;
    }
    const PresContentData&
    contentData() const
    {
        return contentData_;
    }

    nsPoint&
    scrollState()
    {
        return scrollState_;
    }
    const nsPoint&
    scrollState() const
    {
        return scrollState_;
    }

    bool&
    allowScrollOriginDowngrade()
    {
        return allowScrollOriginDowngrade_;
    }
    const bool&
    allowScrollOriginDowngrade() const
    {
        return allowScrollOriginDowngrade_;
    }

    float&
    resolution()
    {
        return resolution_;
    }
    const float&
    resolution() const
    {
        return resolution_;
    }

    bool&
    disabledSet()
    {
        return disabledSet_;
    }
    const bool&
    disabledSet() const
    {
        return disabledSet_;
    }

    bool&
    disabled()
    {
        return disabled_;
    }
    const bool&
    disabled() const
    {
        return disabled_;
    }

    bool&
    droppedDown()
    {
        return droppedDown_;
    }
    const bool&
    droppedDown() const
    {
        return droppedDown_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PresContentData> contentData_;
    ::mozilla::ipc::IPDLStructMember<nsPoint> scrollState_;
    ::mozilla::ipc::IPDLStructMember<bool> allowScrollOriginDowngrade_;
    ::mozilla::ipc::IPDLStructMember<bool> disabledSet_;
    ::mozilla::ipc::IPDLStructMember<bool> disabled_;
    ::mozilla::ipc::IPDLStructMember<bool> droppedDown_;
    ::mozilla::ipc::IPDLStructMember<float> resolution_;
};
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::PresState>
{
    typedef ::mozilla::PresState paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef PresState_h
