/* THIS FILE IS AUTOGENERATED FROM SVGTransformList.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "DOMMatrixBinding.h"
#include "DOMSVGTransform.h"
#include "DOMSVGTransformList.h"
#include "MainThreadUtils.h"
#include "SVGTransformListBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace SVGTransformList_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_numberOfItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "numberOfItems", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->NumberOfItems());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo numberOfItems_getterinfo = {
  { get_numberOfItems },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clear(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "clear", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clear(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Clear(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.clear"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clear_methodinfo = {
  { (JSJitGetterOp)clear },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
initialize(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGTransformList.initialize");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "initialize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGTransformList.initialize", 1)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGTransform> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGTransform, mozilla::dom::DOMSVGTransform>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGTransform");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->Initialize(MOZ_KnownLive(NonNullHelper(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.initialize"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo initialize_methodinfo = {
  { (JSJitGetterOp)initialize },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getItem(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "getItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGTransformList.getItem", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->GetItem(arg0, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.getItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getItem_methodinfo = {
  { (JSJitGetterOp)getItem },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
insertItemBefore(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGTransformList.insertItemBefore");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "insertItemBefore", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGTransformList.insertItemBefore", 2)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGTransform> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGTransform, mozilla::dom::DOMSVGTransform>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGTransform");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->InsertItemBefore(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.insertItemBefore"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo insertItemBefore_methodinfo = {
  { (JSJitGetterOp)insertItemBefore },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
replaceItem(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGTransformList.replaceItem");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "replaceItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGTransformList.replaceItem", 2)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGTransform> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGTransform, mozilla::dom::DOMSVGTransform>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGTransform");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->ReplaceItem(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.replaceItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo replaceItem_methodinfo = {
  { (JSJitGetterOp)replaceItem },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeItem(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "removeItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGTransformList.removeItem", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->RemoveItem(arg0, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.removeItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo removeItem_methodinfo = {
  { (JSJitGetterOp)removeItem },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
appendItem(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGTransformList.appendItem");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "appendItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGTransformList.appendItem", 1)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGTransform> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGTransform, mozilla::dom::DOMSVGTransform>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGTransform");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->AppendItem(MOZ_KnownLive(NonNullHelper(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.appendItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo appendItem_methodinfo = {
  { (JSJitGetterOp)appendItem },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createSVGTransformFromMatrix(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGTransformList.createSVGTransformFromMatrix");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "createSVGTransformFromMatrix", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  binding_detail::FastDOMMatrix2DInit arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->CreateSVGTransformFromMatrix(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.createSVGTransformFromMatrix"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createSVGTransformFromMatrix_methodinfo = {
  { (JSJitGetterOp)createSVGTransformFromMatrix },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
consolidate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "consolidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->Consolidate(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.consolidate"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo consolidate_methodinfo = {
  { (JSJitGetterOp)consolidate },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGTransformList", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGTransformList*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Length());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo length_getterinfo = {
  { get_length },
  { prototypes::id::SVGTransformList },
  { PrototypeTraits<prototypes::id::SVGTransformList>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("clear", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clear_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("initialize", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initialize_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("insertItemBefore", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&insertItemBefore_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("replaceItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&replaceItem_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("appendItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&appendItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createSVGTransformFromMatrix", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createSVGTransformFromMatrix_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("consolidate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&consolidate_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_SYM_FNSPEC(iterator, nullptr, nullptr, 0, 0, "$ArrayValues"),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(10 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("numberOfItems", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &numberOfItems_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("length", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &length_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[12];
static PropertyInfo sNativeProperties_propertyInfos[12];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  12,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[10] }
  }
};
static_assert(12 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, mozilla::dom::DOMSVGTransformList>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  bool
  getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::dom::DOMSVGTransformList*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::dom::DOMSVGTransformList*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::SVGTransformList,
  constructors::id::SVGTransformList,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::SVGTransformList>::Depth,
  prototypes::id::SVGTransformList,
  true,
  0,
  "SVGTransformList",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "SVGTransformListPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::SVGTransformList,
  PrototypeTraits<prototypes::id::SVGTransformList>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    JS::Rooted<JS::Value> value(cx);
    mozilla::dom::DOMSVGTransformList* self = UnwrapProxy(proxy);
    bool found = false;
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, &value)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
      return true;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  if (IsArrayIndex(GetArrayIndexFromId(id))) {
    *done = true;
    return opresult.failNoIndexedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  uint32_t length = UnwrapProxy(proxy)->Length();
  MOZ_ASSERT(int32_t(length) >= 0);
  for (int32_t i = 0; i < int32_t(length); ++i) {
    if (!props.append(JS::PropertyKey::Int(i))) {
      return false;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool found = false;
    mozilla::dom::DOMSVGTransformList* self = UnwrapProxy(proxy);
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;

    *bp = found;
    return true;
  }


  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    mozilla::dom::DOMSVGTransformList* self = UnwrapProxy(proxy);
    bool found = false;
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    // Even if we don't have this index, we don't forward the
    // get on to our expando object.
  } else {
    bool expandoHasProp = false;
    { // Scope for expando
      JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
      if (expando) {
        if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
          return false;
        }

        if (expandoHasProp) {
          // Forward the get to the expando object, but our receiver is whatever our
          // receiver is.
          if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
            return false;
          }
        }
      }
    }

    if (expandoHasProp) {
      return true;
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "SVGTransformList";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::dom::DOMSVGTransformList* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::DOMSVGTransformList>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::DOMSVGTransformList>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool deleteSucceeded;
    bool found = false;
    mozilla::dom::DOMSVGTransformList* self = UnwrapProxy(proxy);
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
    deleteSucceeded = !found;
    return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

bool
DOMProxyHandler::getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const
{
  JS::Rooted<JS::Value> temp(cx);
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");

  mozilla::dom::DOMSVGTransformList* self = UnwrapProxy(proxy);
  uint32_t length = self->Length();
  // Compute the end of the indices we'll get ourselves
  uint32_t ourEnd = std::clamp(length, begin, end);

  for (uint32_t index = begin; index < ourEnd; ++index) {
    bool found = false;
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGTransform>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGTransformList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    MOZ_ASSERT(found);
    if (!GetOrCreateDOMReflector(cx, result, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!adder->append(cx, temp)) return false;
    continue;
  }

  if (end > ourEnd) {
    JS::Rooted<JSObject*> proto(cx);
    if (!js::GetObjectProto(cx, proxy, &proto)) {
      return false;
    }
    return js::GetElementsWithAdder(cx, proto, proxy, ourEnd, end, adder);
  }

  return true;
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::dom::DOMSVGTransformList>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("SVGTransformList",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::SVGTransformList, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::DOMSVGTransformList>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::DOMSVGTransformList>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::DOMSVGTransformList>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::dom::DOMSVGTransformList* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::DOMSVGTransformList>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::DOMSVGTransformList*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::DOMSVGTransformList> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::SVGTransformList);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::SVGTransformList);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "SVGTransformList",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::SVGTransformList,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::SVGTransformList,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace SVGTransformList_Binding



} // namespace mozilla::dom
