// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanXpcomMetrics_h
#define mozilla_GleanXpcomMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace memory {
  /**
   * generated from memory.collection_time
   * Time spent gathering memory telemetry in milliseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_COLLECTION_TIME.
   */
  constexpr impl::TimingDistributionMetric collection_time(4783);

  /**
   * generated from memory.distribution_among_content
   * Absolute difference of each content process' USS and the mean of USS's, normalized by the mean, in percentage. It will be recorded with the rest of the memory probes when gatherMemory is called, if at least 2 content processes are alive. Example: in case of 4 content processes with USS's: 1G, 500MB, 1G, 1.5G, the reported numbers will be: 0, 50, 0, 50. Which indicates that 2 processes used 50% more or 50% less memory than the avarage and 2 used exactly as much as the avarage.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram MEMORY_DISTRIBUTION_AMONG_CONTENT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> distribution_among_content(4784);

  /**
   * generated from memory.free_purged_pages
   * Time(ms) to purge dirty heap pages.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_FREE_PURGED_PAGES_MS.
   */
  constexpr impl::TimingDistributionMetric free_purged_pages(4785);

  /**
   * generated from memory.ghost_windows
   * Number of ghost windows
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram GHOST_WINDOWS.
   */
  constexpr impl::CustomDistributionMetric ghost_windows(4786);

  /**
   * generated from memory.heap_allocated
   * Heap memory allocated (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_HEAP_ALLOCATED.
   */
  constexpr impl::MemoryDistributionMetric heap_allocated(4787);

  /**
   * generated from memory.heap_overhead_fraction
   * Fraction of committed heap memory that is overhead (percentage).
   * This metric was generated to correspond to the Legacy Telemetry linear histogram MEMORY_HEAP_OVERHEAD_FRACTION.
   */
  constexpr impl::CustomDistributionMetric heap_overhead_fraction(4788);

  /**
   * generated from memory.images_content_used_uncompressed
   * Memory used for uncompressed, in-use content images (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_IMAGES_CONTENT_USED_UNCOMPRESSED.
   */
  constexpr impl::MemoryDistributionMetric images_content_used_uncompressed(4789);

  /**
   * generated from memory.js_compartments_system
   * Total JavaScript compartments used for add-ons and internals.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_COMPARTMENTS_SYSTEM.
   */
  constexpr impl::CustomDistributionMetric js_compartments_system(4790);

  /**
   * generated from memory.js_compartments_user
   * Total JavaScript compartments used for web pages
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_COMPARTMENTS_USER.
   */
  constexpr impl::CustomDistributionMetric js_compartments_user(4791);

  /**
   * generated from memory.js_gc_heap
   * Memory used by the garbage-collected JavaScript heap (KB) by process type
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_GC_HEAP.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, DynamicLabel> js_gc_heap(4792);

  /**
   * generated from memory.js_realms_system
   * Total JavaScript realms used for add-ons and internals.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_REALMS_SYSTEM.
   */
  constexpr impl::CustomDistributionMetric js_realms_system(4793);

  /**
   * generated from memory.js_realms_user
   * Total JavaScript realms used for web pages.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_REALMS_USER.
   */
  constexpr impl::CustomDistributionMetric js_realms_user(4794);

  /**
   * generated from memory.low_memory_events_physical
   * Number of low-physical-memory events fired since last ping
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram LOW_MEMORY_EVENTS_PHYSICAL.
   */
  constexpr impl::CustomDistributionMetric low_memory_events_physical(4795);

  /**
   * generated from memory.page_faults_hard
   * Hard page faults (since last telemetry ping)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PAGE_FAULTS_HARD.
   */
  constexpr impl::CustomDistributionMetric page_faults_hard(4796);

  /**
   * generated from memory.resident_fast
   * Resident memory size (KB) by process type
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_RESIDENT_FAST.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, DynamicLabel> resident_fast(4797);

  /**
   * generated from memory.resident_peak
   * Peak resident memory size (KB) by process type
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_RESIDENT_PEAK.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, DynamicLabel> resident_peak(4798);

  /**
   * generated from memory.storage_sqlite
   * Memory used by SQLite (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_STORAGE_SQLITE.
   */
  constexpr impl::MemoryDistributionMetric storage_sqlite(4799);

  /**
   * generated from memory.total
   * Total Memory Across All Processes (KB) (inaccurate WRT shared memory. See MemoryTelemetry.cpp)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_TOTAL.
   */
  constexpr impl::MemoryDistributionMetric total(4800);

  /**
   * generated from memory.unique
   * Unique Set Size (KB) by process type
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_UNIQUE.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, DynamicLabel> unique(4801);

  /**
   * generated from memory.unique_content_startup
   * Unique Set Size of Content Process at Startup (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_UNIQUE_CONTENT_STARTUP.
   */
  constexpr impl::MemoryDistributionMetric unique_content_startup(4802);

  /**
   * generated from memory.vsize
   * Virtual memory size (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_VSIZE.
   */
  constexpr impl::MemoryDistributionMetric vsize(4803);

  /**
   * generated from memory.vsize_max_contiguous
   * Maximum-sized block of contiguous virtual memory (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_VSIZE_MAX_CONTIGUOUS.
   */
  constexpr impl::MemoryDistributionMetric vsize_max_contiguous(4804);
}

namespace system {
  /**
   * generated from system.apple_model_id
   * The `hw.model` of the hardware running this software.
   * Mac only.
   * e.g. "MacBookPro14,1"
   */
  constexpr impl::StringMetric apple_model_id(5943);

  /**
   * generated from system.has_win_package_id
   * Whether the app has a package identity.
   * Windows only.
   */
  constexpr impl::BooleanMetric has_win_package_id(5944);

  /**
   * generated from system.is_wow_64
   * Whether we're in Windows32-on-Windows64 mode.
   * Windows only.
   */
  constexpr impl::BooleanMetric is_wow_64(5945);

  /**
   * generated from system.is_wow_arm_64
   * Whether we're in Windows32-on-WindowsForArm64 mode.
   * Windows only.
   */
  constexpr impl::BooleanMetric is_wow_arm_64(5946);

  /**
   * generated from system.memory
   * The physical memory size in MB (2^20 bytes).
   * e.g. 32211
   */
  constexpr impl::QuantityMetric memory(5947);

  /**
   * generated from system.virtual_memory
   * The size of the user-mode portion of the virtual address space of the parent process.
   * Windows only.
   * e.g. 134217728
   */
  constexpr impl::QuantityMetric virtual_memory(5948);

  /**
   * generated from system.win_package_family_name
   * The full application package name without any of the components that might change
   * during the life cycle of the app (such as the version number or the architecture).
   * Uniquely identifies the application within one Windows installation.
   * Windows only.
   * Only included if it begins with "Mozilla." or "MozillaCorporation.".
   * e.g. "Mozilla.Firefox_n80bbvh6b1yt2"
   */
  constexpr impl::StringMetric win_package_family_name(5949);
}

namespace cycle_collector {
  /**
   * generated from cycle_collector.async_snow_white_freeing
   * Time spent on one asynchronous SnowWhite freeing (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_ASYNC_SNOW_WHITE_FREEING.
   */
  constexpr impl::TimingDistributionMetric async_snow_white_freeing(6167);

  /**
   * generated from cycle_collector.collected
   * Number of objects collected by the cycle collector
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_COLLECTED.
   */
  constexpr impl::CustomDistributionMetric collected(6168);

  /**
   * generated from cycle_collector.deferred_finalize_async
   * Pause time for asynchronous deferred finalization (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEFERRED_FINALIZE_ASYNC.
   */
  constexpr impl::TimingDistributionMetric deferred_finalize_async(6169);

  /**
   * generated from cycle_collector.finish_igc
   */
  enum class FinishIgcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Cycle collection finished an incremental GC
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_FINISH_IGC.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FinishIgcLabel> finish_igc(6170);

  /**
   * generated from cycle_collector.forget_skippable_max
   * Max time spent on one forget skippable (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FORGET_SKIPPABLE_MAX.
   */
  constexpr impl::TimingDistributionMetric forget_skippable_max(6171);

  /**
   * generated from cycle_collector.full
   * Full pause time for one cycle collection, including preparation (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_FULL.
   */
  constexpr impl::TimingDistributionMetric full(6172);

  /**
   * generated from cycle_collector.max_pause
   * Longest pause for an individual slice of one cycle collection, including preparation (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_MAX_PAUSE.
   */
  constexpr impl::TimingDistributionMetric max_pause(6173);

  /**
   * generated from cycle_collector.need_gc
   */
  enum class NeedGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Needed garbage collection before cycle collection.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_NEED_GC.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NeedGcLabel> need_gc(6174);

  /**
   * generated from cycle_collector.slice_during_idle
   * Percent of cycle collector slice done during idle time
   * This metric was generated to correspond to the Legacy Telemetry linear histogram CYCLE_COLLECTOR_SLICE_DURING_IDLE.
   */
  constexpr impl::CustomDistributionMetric slice_during_idle(6175);

  /**
   * generated from cycle_collector.sync_skippable
   */
  enum class SyncSkippableLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Cycle collection synchronously ran forget skippable
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_SYNC_SKIPPABLE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SyncSkippableLabel> sync_skippable(6176);

  /**
   * generated from cycle_collector.time
   * Time spent on one cycle collection (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR.
   */
  constexpr impl::TimingDistributionMetric time(6177);

  /**
   * generated from cycle_collector.time_between
   * Time spent in between cycle collections (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_TIME_BETWEEN.
   */
  constexpr impl::TimingDistributionMetric time_between(6178);

  /**
   * generated from cycle_collector.visited_gced
   * Number of JS objects visited by the cycle collector
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_VISITED_GCED.
   */
  constexpr impl::CustomDistributionMetric visited_gced(6179);

  /**
   * generated from cycle_collector.visited_ref_counted
   * Number of ref counted objects visited by the cycle collector
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_VISITED_REF_COUNTED.
   */
  constexpr impl::CustomDistributionMetric visited_ref_counted(6180);

  /**
   * generated from cycle_collector.worker_collected
   * Number of objects collected by the cycle collector in a worker
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER_COLLECTED.
   */
  constexpr impl::CustomDistributionMetric worker_collected(6181);

  /**
   * generated from cycle_collector.worker_need_gc
   */
  enum class WorkerNeedGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Needed garbage collection before cycle collection in a worker.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_WORKER_NEED_GC.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, WorkerNeedGcLabel> worker_need_gc(6182);

  /**
   * generated from cycle_collector.worker_time
   * Time spent on one cycle collection in a worker (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER.
   */
  constexpr impl::TimingDistributionMetric worker_time(6183);

  /**
   * generated from cycle_collector.worker_visited_gced
   * Number of JS objects visited by the cycle collector in a worker
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER_VISITED_GCED.
   */
  constexpr impl::CustomDistributionMetric worker_visited_gced(6184);

  /**
   * generated from cycle_collector.worker_visited_ref_counted
   * Number of ref counted objects visited by the cycle collector in a worker
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER_VISITED_REF_COUNTED.
   */
  constexpr impl::CustomDistributionMetric worker_visited_ref_counted(6185);
}

namespace event {
  /**
   * generated from event.longtask
   * LongTask events for parent process (keys: event name): time the event ran in ms
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram EVENT_LONGTASK.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> longtask(6186);
}

namespace hdd {
  /**
   * generated from hdd.binary
   */

  struct BinaryObject {
    Maybe<nsCString> model;
    Maybe<nsCString> revision;
    Maybe<nsCString> diskType;
  };
  /**
   * Information about the disk the application binary is stored on.
   * Windows only.
   * * model - The disk's self-reported model string
   * * revision - The disk's self-reported revision string
   * * diskType - Either "HDD" or "SSD"
   */
  constexpr impl::ObjectMetric<BinaryObject, struct BinaryObjectTag> binary(6187);

  /**
   * generated from hdd.profile
   */

  struct ProfileObject {
    Maybe<nsCString> model;
    Maybe<nsCString> revision;
    Maybe<nsCString> diskType;
  };
  /**
   * Information about the disk the profile is stored on.
   * Windows only.
   * * model - The disk's self-reported model string
   * * revision - The disk's self-reported revision string
   * * diskType - Either "HDD" or "SSD"
   */
  constexpr impl::ObjectMetric<ProfileObject, struct ProfileObjectTag> profile(6188);

  /**
   * generated from hdd.system
   */

  struct SystemObject {
    Maybe<nsCString> model;
    Maybe<nsCString> revision;
    Maybe<nsCString> diskType;
  };
  /**
   * Information about the disk the system files are stored on.
   * Windows only.
   * * model - The disk's self-reported model string
   * * revision - The disk's self-reported revision string
   * * diskType - Either "HDD" or "SSD"
   */
  constexpr impl::ObjectMetric<SystemObject, struct SystemObjectTag> system(6189);
}

template <>
inline void impl::ObjectMetric<hdd::BinaryObject, hdd::BinaryObjectTag>::Set(const hdd::BinaryObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.model.isSome()) {
      writer.StringProperty("model", *(aObj.model));
    }
    if (aObj.revision.isSome()) {
      writer.StringProperty("revision", *(aObj.revision));
    }
    if (aObj.diskType.isSome()) {
      writer.StringProperty("diskType", *(aObj.diskType));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<hdd::ProfileObject, hdd::ProfileObjectTag>::Set(const hdd::ProfileObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.model.isSome()) {
      writer.StringProperty("model", *(aObj.model));
    }
    if (aObj.revision.isSome()) {
      writer.StringProperty("revision", *(aObj.revision));
    }
    if (aObj.diskType.isSome()) {
      writer.StringProperty("diskType", *(aObj.diskType));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<hdd::SystemObject, hdd::SystemObjectTag>::Set(const hdd::SystemObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.model.isSome()) {
      writer.StringProperty("model", *(aObj.model));
    }
    if (aObj.revision.isSome()) {
      writer.StringProperty("revision", *(aObj.revision));
    }
    if (aObj.diskType.isSome()) {
      writer.StringProperty("diskType", *(aObj.diskType));
    }
  }
  writer.EndObject();


  SetStr(json);
}

namespace memory_phc {
  /**
   * generated from memory_phc.slop
   * Over-allocation due to PHC's rounding (aka internal fragmentation).  Measured in bytes.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_PHC_SLOP.
   */
  constexpr impl::MemoryDistributionMetric slop(6190);

  /**
   * generated from memory_phc.slots_allocated
   * Number of PHC slots currently allocated
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_PHC_SLOTS_ALLOCATED.
   */
  constexpr impl::CustomDistributionMetric slots_allocated(6191);

  /**
   * generated from memory_phc.slots_freed
   * Number of PHC slots allocated-then-freed
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_PHC_SLOTS_FREED.
   */
  constexpr impl::CustomDistributionMetric slots_freed(6192);
}

namespace memory_watcher {
  /**
   * generated from memory_watcher.on_high_memory_stats
   */
  struct OnHighMemoryStatsExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is recorded when the memory situation is no longer low. The "stats" object consists of three numbers comma-delimited: 1) how many times a tab was unloaded 2) how many memory-pressure events were dispatched 3) how long we were in the low-memory situation in seconds This event was generated to correspond to the Legacy Telemetry event memory_watcher.on_high_memory#stats.
   */
  constexpr impl::EventMetric<OnHighMemoryStatsExtra> on_high_memory_stats(6193);

  /**
   * generated from memory_watcher.process_oom_killed
   */
  struct ProcessOomKilledExtra {
    mozilla::Maybe<nsCString> psiFullAvg10;
    mozilla::Maybe<nsCString> psiFullAvg60;
    mozilla::Maybe<nsCString> psiSomeAvg10;
    mozilla::Maybe<nsCString> psiSomeAvg60;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (psiFullAvg10) {
        extraKeys.AppendElement()->AssignASCII("psi_full_avg10");
        extraValues.EmplaceBack(psiFullAvg10.value());
      }
      if (psiFullAvg60) {
        extraKeys.AppendElement()->AssignASCII("psi_full_avg60");
        extraValues.EmplaceBack(psiFullAvg60.value());
      }
      if (psiSomeAvg10) {
        extraKeys.AppendElement()->AssignASCII("psi_some_avg10");
        extraValues.EmplaceBack(psiSomeAvg10.value());
      }
      if (psiSomeAvg60) {
        extraKeys.AppendElement()->AssignASCII("psi_some_avg60");
        extraValues.EmplaceBack(psiSomeAvg60.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a content process is killed by the Linux OOM killer (SIGKILL). PSI (Pressure Stall Information) metrics are included to understand memory pressure context at the time of the kill. This helps analyze memory pressure patterns and OOM kill correlation.
   */
  constexpr impl::EventMetric<ProcessOomKilledExtra> process_oom_killed(6194);
}

namespace system_cpu {
  /**
   * generated from system.cpu.big_cores
   * Big (or Performance) CPU cores.
   */
  constexpr impl::QuantityMetric big_cores(6195);

  /**
   * generated from system.cpu.extensions
   * Recognized CPU extensions.
   */
  constexpr impl::StringListMetric extensions(6196);

  /**
   * generated from system.cpu.family
   * CPU family.
   */
  constexpr impl::QuantityMetric family(6197);

  /**
   * generated from system.cpu.l2_cache
   * L2 cache size (only on Windows and Mac).
   */
  constexpr impl::QuantityMetric l2_cache(6198);

  /**
   * generated from system.cpu.l3_cache
   * L3 cache size.
   */
  constexpr impl::QuantityMetric l3_cache(6199);

  /**
   * generated from system.cpu.little_cores
   * Little (or Efficient) CPU cores.
   */
  constexpr impl::QuantityMetric little_cores(6200);

  /**
   * generated from system.cpu.logical_cores
   * Logical CPU cores.
   */
  constexpr impl::QuantityMetric logical_cores(6201);

  /**
   * generated from system.cpu.medium_cores
   * Medium CPU cores.
   */
  constexpr impl::QuantityMetric medium_cores(6202);

  /**
   * generated from system.cpu.model
   * CPU model.
   */
  constexpr impl::QuantityMetric model(6203);

  /**
   * generated from system.cpu.name
   * The user readable CPU name. (e.g. "Intel(R) Core(TM) i9-8950HK CPU @ 2.90GHz")
   */
  constexpr impl::StringMetric name(6204);

  /**
   * generated from system.cpu.physical_cores
   * Physical CPU cores.
   */
  constexpr impl::QuantityMetric physical_cores(6205);

  /**
   * generated from system.cpu.speed
   * CPU speed in MHz.
   */
  constexpr impl::QuantityMetric speed(6206);

  /**
   * generated from system.cpu.stepping
   * CPU stepping.
   */
  constexpr impl::QuantityMetric stepping(6207);

  /**
   * generated from system.cpu.vendor
   * The CPU vendor (e.g. "GenuineIntel").
   */
  constexpr impl::StringMetric vendor(6208);
}

namespace system_os {
  /**
   * generated from system.os.distro
   * The Operating System's distribution, according to sysinfo.
   * Linux only.
   * e.g. "Linuxmint"
   */
  constexpr impl::StringMetric distro(6209);

  /**
   * generated from system.os.distro_version
   * The Operating System's distribution's version, according to sysinfo.
   * Linux only.
   * e.g. "22"
   */
  constexpr impl::StringMetric distro_version(6210);

  /**
   * generated from system.os.locale
   * The Operating System's local, according to ospreferences.
   * e.g. "en-US"
   */
  constexpr impl::StringMetric locale(6211);

  /**
   * generated from system.os.name
   * The Operating System's name, according to sysinfo.
   * e.g. "Windows_NT"
   * Expected in most cases to be identical to `client_info.os`.
   */
  constexpr impl::StringMetric name(6212);

  /**
   * generated from system.os.service_pack_major
   * The Windows service pack's major version, according to WindowsVersionInfo.
   * Windows only.
   * e.g. 0
   */
  constexpr impl::QuantityMetric service_pack_major(6213);

  /**
   * generated from system.os.service_pack_minor
   * The Windows service pack's minor version, according to WindowsVersionInfo.
   * Windows only.
   * e.g. 0
   */
  constexpr impl::QuantityMetric service_pack_minor(6214);

  /**
   * generated from system.os.version
   * The Operating System's version, according to sysinfo.
   * e.g. "6.3"
   * Expected in most cases to be identical to `client_info.os_version`.
   */
  constexpr impl::StringMetric version(6215);

  /**
   * generated from system.os.windows_build_number
   * The Windows build number, according to WindowsVersionInfo.
   * Windows only.
   * e.g. 26100
   * Expected in most cases to be identical to `client_info.windows_build_number`.
   */
  constexpr impl::QuantityMetric windows_build_number(6216);

  /**
   * generated from system.os.windows_ubr
   * The Windows update build revision number, according to
   * `SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion`.
   * Windows only.
   * e.g. 3775
   */
  constexpr impl::QuantityMetric windows_ubr(6217);
}

namespace timer_thread {
  /**
   * generated from timer_thread.timers_fired_per_wakeup
   * How many timers were processed in a single wake-up of the Timer Thread.
   */
  constexpr impl::CustomDistributionMetric timers_fired_per_wakeup(6218);
}

namespace xpcom {
  /**
   * generated from xpcom.abi
   * A string tag identifying the binary ABI of the current processor and
   * compiler vtable. This is taken from the TARGET_XPCOM_ABI configure
   * variable. It may not be available on all platforms, especially
   * unusual processor or compiler combinations.
   * 
   * The result takes the form <processor>-<compilerABI>, for example:
   *   - x86-msvc
   *   - ppc-gcc3
   * 
   * This value should almost always be used in combination with the
   * operating system.
   */
  constexpr impl::StringMetric abi(6219);
}

} // namespace mozilla::glean

#endif // mozilla_GleanXpcomMetrics_h
