// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanProcesstoolsMetrics_h
#define mozilla_GleanProcesstoolsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace power {
  /**
   * generated from power.cpu_time_bogus_values
   * Impossibly large CPU time values that were discarded.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cpu_time_bogus_values(5357);

  /**
   * generated from power.cpu_time_per_process_type_ms
   */
  enum class CpuTimePerProcessTypeMsLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    eInference = 17,
    e__Other__,
  };
  /**
   * CPU time used by each process type in ms.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CpuTimePerProcessTypeMsLabel> cpu_time_per_process_type_ms(5358);

  /**
   * generated from power.cpu_time_per_tracker_type_ms
   */
  enum class CpuTimePerTrackerTypeMsLabel: uint16_t {
    eAd = 0,
    eAnalytics = 1,
    eCryptomining = 2,
    eFingerprinting = 3,
    eSocial = 4,
    eUnknown = 5,
    e__Other__,
  };
  /**
   * CPU time used by content processes used only for tracking resources, labeled by the category of the tracker.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CpuTimePerTrackerTypeMsLabel> cpu_time_per_tracker_type_ms(5359);

  /**
   * generated from power.energy_per_process_type
   */
  enum class EnergyPerProcessTypeLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    eInference = 17,
    e__Other__,
  };
  /**
   * How much energy (in µWh) has been used, broken down by process type. Only available on Apple Silicon.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EnergyPerProcessTypeLabel> energy_per_process_type(5360);

  /**
   * generated from power.gpu_time_bogus_values
   * Impossibly large GPU time values that were discarded.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> gpu_time_bogus_values(5361);

  /**
   * generated from power.gpu_time_per_process_type_ms
   */
  enum class GpuTimePerProcessTypeMsLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    eInference = 17,
    e__Other__,
  };
  /**
   * GPU time used by each process type in ms.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GpuTimePerProcessTypeMsLabel> gpu_time_per_process_type_ms(5362);

  /**
   * generated from power.total_cpu_time_ms
   * Total CPU time used by all processes in ms.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> total_cpu_time_ms(5363);

  /**
   * generated from power.total_gpu_time_ms
   * Total GPU time used by all processes in ms.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> total_gpu_time_ms(5364);

  /**
   * generated from power.total_thread_wakeups
   * How many times threads woke up and could have woken up a CPU core.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> total_thread_wakeups(5365);

  /**
   * generated from power.wakeups_per_process_type
   */
  enum class WakeupsPerProcessTypeLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    eInference = 17,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, WakeupsPerProcessTypeLabel> wakeups_per_process_type(5366);
}

namespace power_battery {
  /**
   * generated from power.battery.percentage_when_user_active
   * Records how many percent of battery was available for each period of user activity.
   */
  constexpr impl::CustomDistributionMetric percentage_when_user_active(5367);
}

namespace power_cpu_ms_per_thread {
  /**
   * generated from power.cpu_ms_per_thread.content_background
   */
  enum class ContentBackgroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ContentBackgroundLabel> content_background(5368);

  /**
   * generated from power.cpu_ms_per_thread.content_foreground
   */
  enum class ContentForegroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ContentForegroundLabel> content_foreground(5369);

  /**
   * generated from power.cpu_ms_per_thread.gpu_process
   */
  enum class GpuProcessLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GpuProcessLabel> gpu_process(5370);

  /**
   * generated from power.cpu_ms_per_thread.inference_process
   */
  enum class InferenceProcessLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, InferenceProcessLabel> inference_process(5371);

  /**
   * generated from power.cpu_ms_per_thread.parent_active
   */
  enum class ParentActiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ParentActiveLabel> parent_active(5372);

  /**
   * generated from power.cpu_ms_per_thread.parent_inactive
   */
  enum class ParentInactiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ParentInactiveLabel> parent_inactive(5373);
}

namespace power_wakeups_per_thread {
  /**
   * generated from power.wakeups_per_thread.content_background
   */
  enum class ContentBackgroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ContentBackgroundLabel> content_background(5374);

  /**
   * generated from power.wakeups_per_thread.content_foreground
   */
  enum class ContentForegroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ContentForegroundLabel> content_foreground(5375);

  /**
   * generated from power.wakeups_per_thread.gpu_process
   */
  enum class GpuProcessLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GpuProcessLabel> gpu_process(5376);

  /**
   * generated from power.wakeups_per_thread.inference_process
   */
  enum class InferenceProcessLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, InferenceProcessLabel> inference_process(5377);

  /**
   * generated from power.wakeups_per_thread.parent_active
   */
  enum class ParentActiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ParentActiveLabel> parent_active(5378);

  /**
   * generated from power.wakeups_per_thread.parent_inactive
   */
  enum class ParentInactiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    eOnnxWorker = 63,
    ePacerthread = 64,
    ePermission = 65,
    ePlayeventsound = 66,
    eProcesshangmon = 67,
    eProfilerchild = 68,
    eProxyresolution = 69,
    eQuotamanagerIo = 70,
    eRegisterfonts = 71,
    eRemotebackbuffer = 72,
    eRemotelzystream = 73,
    eRemvidchild = 74,
    eRenderer = 75,
    eSandboxreporter = 76,
    eSavescripts = 77,
    eSocketThread = 78,
    eSoftwarevsyncthread = 79,
    eSqldbContentPrefsSqlite = 80,
    eSqldbCookiesSqlite = 81,
    eSqldbFormhistorySqlite = 82,
    eSslCert = 83,
    eStartupcache = 84,
    eStreamtrans = 85,
    eStylethread = 86,
    eSwcomposite = 87,
    eTaskcontroller = 88,
    eTimer = 89,
    eToastbgthread = 90,
    eTrrBackground = 91,
    eUntrustedModules = 92,
    eUrlClassifier = 93,
    eVideocapture = 94,
    eVsynciothread = 95,
    eWebrtccallthread = 96,
    eWebrtcworker = 97,
    eWincompositor = 98,
    eWindowsvsyncthread = 99,
    eWinwindowocclusioncalc = 100,
    eWifiTickler = 101,
    eWorkerLauncher = 102,
    eWrrenderbackend = 103,
    eWrscenebuilder = 104,
    eWrscenebuilderlp = 105,
    eWrworker = 106,
    eWrworkerlp = 107,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ParentInactiveLabel> parent_inactive(5379);
}

} // namespace mozilla::glean

#endif // mozilla_GleanProcesstoolsMetrics_h
