// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomQuotaMetrics_h
#define mozilla_GleanDomQuotaMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace dom_quota {
  /**
   * generated from dom.quota.first_initialization_attempt
   * True if the first initialization attempt succeeded, keyed by the initialization type.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram QM_FIRST_INITIALIZATION_ATTEMPT.
   */
  constexpr impl::DualLabeledCounterMetric first_initialization_attempt(3967);

  /**
   * generated from dom.quota.info_load_time
   * Time (ms) for the QuotaManager to load quota information. Keyed by conditions during quota info loading, see RecordTimeDeltaHelper::Run in https://searchfox.org/mozilla-central/source/dom/quota/ActorsParent.cpp
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram QM_QUOTA_INFO_LOAD_TIME_V0.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> info_load_time(3968);

  /**
   * generated from dom.quota.shutdown_time
   * Time (ms) for the QuotaManager to shutdown. Keyed by conditions during shutdown, see RecordTimeDeltaHelper::Run in https://searchfox.org/mozilla-central/source/dom/quota/ActorsParent.cpp
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram QM_SHUTDOWN_TIME_V0.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> shutdown_time(3969);
}

namespace dom_quota_try {
  /**
   * generated from dom.quota.try.error_step
   */
  struct ErrorStepExtra {
    mozilla::Maybe<nsCString> context;
    mozilla::Maybe<nsCString> frameId;
    mozilla::Maybe<nsCString> processId;
    mozilla::Maybe<nsCString> result;
    mozilla::Maybe<uint32_t> seq;
    mozilla::Maybe<nsCString> severity;
    mozilla::Maybe<nsCString> sourceFile;
    mozilla::Maybe<uint32_t> sourceLine;
    mozilla::Maybe<nsCString> stackId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (context) {
        extraKeys.AppendElement()->AssignASCII("context");
        extraValues.EmplaceBack(context.value());
      }
      if (frameId) {
        extraKeys.AppendElement()->AssignASCII("frame_id");
        extraValues.EmplaceBack(frameId.value());
      }
      if (processId) {
        extraKeys.AppendElement()->AssignASCII("process_id");
        extraValues.EmplaceBack(processId.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      if (seq) {
        extraKeys.AppendElement()->AssignASCII("seq");
        extraValues.AppendElement()->AppendInt(seq.value());
      }
      if (severity) {
        extraKeys.AppendElement()->AssignASCII("severity");
        extraValues.EmplaceBack(severity.value());
      }
      if (sourceFile) {
        extraKeys.AppendElement()->AssignASCII("source_file");
        extraValues.EmplaceBack(sourceFile.value());
      }
      if (sourceLine) {
        extraKeys.AppendElement()->AssignASCII("source_line");
        extraValues.AppendElement()->AppendInt(sourceLine.value());
      }
      if (stackId) {
        extraKeys.AppendElement()->AssignASCII("stack_id");
        extraValues.EmplaceBack(stackId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An event recorded on an error of the quota manager or its clients. Since errors are usually propagated up the call chain, all such propagation steps are recorded for an error. This is only active during specific contexts, in particular during storage initialization. No dynamic data is included in the event beyond the error code which will be added through Bug 1670555. This event was generated to correspond to the Legacy Telemetry event dom.quota.try.error#step.
   */
  constexpr impl::EventMetric<ErrorStepExtra> error_step(3970);
}

namespace quotamanager {
  /**
   * generated from quotamanager.restore_origin_directory_metadata_counter
   * Increments each time QuotaManager::RestoreDirectoryMetadata2 is called to restore origin directory metadata. This typically occurs when expected directory metadata is missing or needs to be regenerated. The counter is incremented regardless of whether the restoration ultimately succeeds or fails. This can provide insight into the impacts of specific code changes, including potential optimizations or regressions.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> restore_origin_directory_metadata_counter(3971);
}

namespace quotamanager_initialize_repository {
  /**
   * generated from quotamanager.initialize.repository.number_of_iterations
   */
  enum class NumberOfIterationsLabel: uint16_t {
    ePersistent = 0,
    eTemporary = 1,
    eDefault = 2,
    ePrivate = 3,
    e__Other__,
  };
  /**
   * This metric logs the count of directory entries iterated within the QuotaManager::InitializeRepository function for each repository type. Each instance of this metric is labeled with one of three repository types: "persistent", "temporary" or "default" (there's also "private" repository but that should never be iterated by the function). The main purpose is to track and analyze iteration counts during the initialization process of each repository type, helping to identify performance trends or potential inefficiencies across these repositories. This can provide insight into the impacts of specific code changes, including potential optimizations or regressions.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, NumberOfIterationsLabel> number_of_iterations(3972);
}

namespace quotamanager_initialize_temporarystorage {
  /**
   * generated from quotamanager.initialize.temporarystorage.non_persisted_zero_usage_origins
   * Logs the number of non-persisted origins that have zero quota-charged usage after full temporary storage initialization. These origins do not store any real data but still contribute to internal bookkeeping by having directories and files created on disk, which can unnecessarily increase initialization costs. Measuring how many such origins exist in the wild helps evaluate whether the temporary storage cleanup logic should be updated to clear them. This in turn can guide potential optimizations and improve the performance of temporary storage initialization over time, while also helping to detect unexpected regressions. Note: Non-persisted origins can be cleared when they have no data, while persisted origins cannot be cleared even at zero usage because the persisted flag is currently stored alongside the origin data and would be lost.
   */
  constexpr impl::CustomDistributionMetric non_persisted_zero_usage_origins(3973);

  /**
   * generated from quotamanager.initialize.temporarystorage.total_time_excluding_suspend
   * This metric logs the total time required to initialize temporary storage within the QuotaManager after startup on the I/O thread. The duration excludes any periods when the system was suspended (e.g. system sleep or hibernation), to better reflect actual time spent performing temporary storage initialization. The primary goal is to measure the actual runtime cost of temporary storage initialization under typical conditions, without distortion from system-level suspension delays. This data can help detect performance regressions or improvements during startup-related phases, particularly for users with significant amounts of temporary storage data on disk.
   */
  constexpr impl::TimingDistributionMetric total_time_excluding_suspend(3974);
}

namespace quotamanager_shutdown {
  /**
   * generated from quotamanager.shutdown.total_time_excluding_suspend
   * This metric logs the total time required to shut down the QuotaManager instance on the PBackground thread. The duration excludes any periods when the system was suspended (system sleep or hibernation), to better reflect actual time spent performing shutdown. While the shutdown process is measured on the PBackground thread, it involves spinning the event loop and thus waiting for operations on other threads (especially I/O threads) to complete. The primary goal is to measure the actual runtime cost of shutdown under typical conditions, without distortion from system-level suspension delays. This data can help detect performance regressions or improvements related to QuotaManager shutdown behavior, especially in scenarios involving large amounts of user storage data.
   */
  constexpr impl::TimingDistributionMetric total_time_excluding_suspend(3975);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomQuotaMetrics_h
