#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentPictureInPicture = 3369,
  DocumentPictureInPictureEvent = 3394,
  DocumentTimeline = 3424,
  DocumentType = 3441,
  DominatorTree = 3454,
  DragEvent = 3468,
  DynamicsCompressorNode = 3478,
  EXT_blend_minmax = 3501,
  EXT_color_buffer_float = 3518,
  EXT_color_buffer_half_float = 3541,
  EXT_depth_clamp = 3569,
  EXT_disjoint_timer_query = 3585,
  EXT_float_blend = 3610,
  EXT_frag_depth = 3626,
  EXT_sRGB = 3641,
  EXT_shader_texture_lod = 3650,
  EXT_texture_compression_bptc = 3673,
  EXT_texture_compression_rgtc = 3702,
  EXT_texture_filter_anisotropic = 3731,
  EXT_texture_norm16 = 3762,
  Element = 3781,
  ElementInternals = 3789,
  EncodedAudioChunk = 3806,
  EncodedVideoChunk = 3824,
  ErrorEvent = 3842,
  Event = 3853,
  EventCallbackDebuggerNotification = 3859,
  EventCounts = 3893,
  EventSource = 3905,
  EventTarget = 3917,
  Exception = 3929,
  ExtendableCookieChangeEvent = 3939,
  ExtendableEvent = 3967,
  ExtendableMessageEvent = 3983,
  ExtensionAlarms = 4006,
  ExtensionBrowser = 4022,
  ExtensionBrowserSettings = 4039,
  ExtensionBrowserSettingsColorManagement = 4064,
  ExtensionDns = 4104,
  ExtensionEventManager = 4117,
  ExtensionMockAPI = 4139,
  ExtensionPort = 4156,
  ExtensionProxy = 4170,
  ExtensionRuntime = 4185,
  ExtensionScripting = 4202,
  ExtensionSetting = 4221,
  ExtensionTest = 4238,
  External = 4252,
  FeaturePolicy = 4261,
  FeaturePolicyViolationReportBody = 4275,
  FetchEvent = 4308,
  FetchObserver = 4319,
  File = 4333,
  FileList = 4338,
  FileReader = 4347,
  FileReaderSync = 4358,
  FileSystem = 4373,
  FileSystemDirectoryEntry = 4384,
  FileSystemDirectoryHandle = 4409,
  FileSystemDirectoryHandle_AsyncIterator = 4435,
  FileSystemDirectoryIterator = 4475,
  FileSystemDirectoryReader = 4503,
  FileSystemEntry = 4529,
  FileSystemFileEntry = 4545,
  FileSystemFileHandle = 4565,
  FileSystemHandle = 4586,
  FileSystemSyncAccessHandle = 4603,
  FileSystemWritableFileStream = 4630,
  Flex = 4659,
  FlexItemValues = 4664,
  FlexLineValues = 4679,
  FluentBundle = 4694,
  FluentBundleAsyncIterator = 4707,
  FluentBundleIterator = 4733,
  FluentPattern = 4754,
  FluentResource = 4768,
  FocusEvent = 4783,
  FontFace = 4794,
  FontFaceSet = 4803,
  FontFaceSetIterator = 4815,
  FontFaceSetLoadEvent = 4835,
  FormData = 4856,
  FormData_Iterator = 4865,
  FormDataEvent = 4883,
  FragmentDirective = 4897,
  FrameCrashedEvent = 4915,
  FrameLoader = 4933,
  GPU = 4945,
  GPUAdapter = 4949,
  GPUAdapterInfo = 4960,
  GPUBindGroup = 4975,
  GPUBindGroupLayout = 4988,
  GPUBuffer = 5007,
  GPUBufferUsage = 5017,
  GPUCanvasContext = 5032,
  GPUColorWrite = 5049,
  GPUCommandBuffer = 5063,
  GPUCommandEncoder = 5080,
  GPUCompilationInfo = 5098,
  GPUCompilationMessage = 5117,
  GPUComputePassEncoder = 5139,
  GPUComputePipeline = 5161,
  GPUDevice = 5180,
  GPUDeviceLostInfo = 5190,
  GPUError = 5208,
  GPUExternalTexture = 5217,
  GPUInternalError = 5236,
  GPUMapMode = 5253,
  GPUOutOfMemoryError = 5264,
  GPUPipelineError = 5284,
  GPUPipelineLayout = 5301,
  GPUQuerySet = 5319,
  GPUQueue = 5331,
  GPURenderBundle = 5340,
  GPURenderBundleEncoder = 5356,
  GPURenderPassEncoder = 5379,
  GPURenderPipeline = 5400,
  GPUSampler = 5418,
  GPUShaderModule = 5429,
  GPUShaderStage = 5445,
  GPUSupportedFeatures = 5460,
  GPUSupportedLimits = 5481,
  GPUTexture = 5500,
  GPUTextureUsage = 5511,
  GPUTextureView = 5527,
  GPUUncapturedErrorEvent = 5542,
  GPUValidationError = 5566,
  GainNode = 5585,
  Gamepad = 5594,
  GamepadAxisMoveEvent = 5602,
  GamepadButton = 5623,
  GamepadButtonEvent = 5637,
  GamepadEvent = 5656,
  GamepadHapticActuator = 5669,
  GamepadLightIndicator = 5691,
  GamepadPose = 5713,
  GamepadServiceTest = 5725,
  GamepadTouch = 5744,
  Geolocation = 5757,
  GeolocationCoordinates = 5769,
  GeolocationPosition = 5792,
  GeolocationPositionError = 5812,
  GetUserMediaRequest = 5837,
  GleanBoolean = 5857,
  GleanCategory = 5870,
  GleanCounter = 5884,
  GleanCustomDistribution = 5897,
  GleanDatetime = 5921,
  GleanDenominator = 5935,
  GleanDualLabeledCounter = 5952,
  GleanEvent = 5976,
  GleanImpl = 5987,
  GleanLabeled = 5997,
  GleanMemoryDistribution = 6010,
  GleanMetric = 6034,
  GleanNumerator = 6046,
  GleanObject = 6061,
  GleanPingsImpl = 6073,
  GleanQuantity = 6088,
  GleanRate = 6102,
  GleanString = 6112,
  GleanStringList = 6124,
  GleanText = 6140,
  GleanTimespan = 6150,
  GleanTimingDistribution = 6164,
  GleanUrl = 6188,
  GleanUuid = 6197,
  Grid = 6207,
  GridArea = 6212,
  GridDimension = 6221,
  GridLine = 6235,
  GridLines = 6244,
  GridTrack = 6254,
  GridTracks = 6264,
  HTMLAllCollection = 6275,
  HTMLAnchorElement = 6293,
  HTMLAreaElement = 6311,
  HTMLAudioElement = 6327,
  HTMLBRElement = 6344,
  HTMLBaseElement = 6358,
  HTMLBodyElement = 6374,
  HTMLButtonElement = 6390,
  HTMLCanvasElement = 6408,
  HTMLCollection = 6426,
  HTMLDListElement = 6441,
  HTMLDataElement = 6458,
  HTMLDataListElement = 6474,
  HTMLDetailsElement = 6494,
  HTMLDialogElement = 6513,
  HTMLDirectoryElement = 6531,
  HTMLDivElement = 6552,
  HTMLDocument = 6567,
  HTMLElement = 6580,
  HTMLEmbedElement = 6592,
  HTMLFieldSetElement = 6609,
  HTMLFontElement = 6629,
  HTMLFormControlsCollection = 6645,
  HTMLFormElement = 6672,
  HTMLFrameElement = 6688,
  HTMLFrameSetElement = 6705,
  HTMLHRElement = 6725,
  HTMLHeadElement = 6739,
  HTMLHeadingElement = 6755,
  HTMLHtmlElement = 6774,
  HTMLIFrameElement = 6790,
  HTMLImageElement = 6808,
  HTMLInputElement = 6825,
  HTMLLIElement = 6842,
  HTMLLabelElement = 6856,
  HTMLLegendElement = 6873,
  HTMLLinkElement = 6891,
  HTMLMapElement = 6907,
  HTMLMarqueeElement = 6922,
  HTMLMediaElement = 6941,
  HTMLMenuElement = 6958,
  HTMLMetaElement = 6974,
  HTMLMeterElement = 6990,
  HTMLModElement = 7007,
  HTMLOListElement = 7022,
  HTMLObjectElement = 7039,
  HTMLOptGroupElement = 7057,
  HTMLOptionElement = 7077,
  HTMLOptionsCollection = 7095,
  HTMLOutputElement = 7117,
  HTMLParagraphElement = 7135,
  HTMLParamElement = 7156,
  HTMLPictureElement = 7173,
  HTMLPreElement = 7192,
  HTMLProgressElement = 7207,
  HTMLQuoteElement = 7227,
  HTMLScriptElement = 7244,
  HTMLSelectElement = 7262,
  HTMLSlotElement = 7280,
  HTMLSourceElement = 7296,
  HTMLSpanElement = 7314,
  HTMLStyleElement = 7330,
  HTMLTableCaptionElement = 7347,
  HTMLTableCellElement = 7371,
  HTMLTableColElement = 7392,
  HTMLTableElement = 7412,
  HTMLTableRowElement = 7429,
  HTMLTableSectionElement = 7449,
  HTMLTemplateElement = 7473,
  HTMLTextAreaElement = 7493,
  HTMLTimeElement = 7513,
  HTMLTitleElement = 7529,
  HTMLTrackElement = 7546,
  HTMLUListElement = 7563,
  HTMLUnknownElement = 7580,
  HTMLVideoElement = 7599,
  HashChangeEvent = 7616,
  Headers = 7632,
  Headers_Iterator = 7640,
  HeapSnapshot = 7657,
  Highlight = 7670,
  HighlightRegistry = 7680,
  History = 7698,
  IDBCursor = 7706,
  IDBCursorWithValue = 7716,
  IDBDatabase = 7735,
  IDBFactory = 7747,
  IDBIndex = 7758,
  IDBKeyRange = 7767,
  IDBObjectStore = 7779,
  IDBOpenDBRequest = 7794,
  IDBRequest = 7811,
  IDBTransaction = 7822,
  IDBVersionChangeEvent = 7837,
  IIRFilterNode = 7859,
  IOUtils = 7873,
  IdentityCredential = 7881,
  IdentityProvider = 7900,
  IdleDeadline = 7917,
  Image = 7930,
  ImageBitmap = 7936,
  ImageBitmapRenderingContext = 7948,
  ImageCapture = 7976,
  ImageCaptureError = 7989,
  ImageCaptureErrorEvent = 8007,
  ImageData = 8030,
  ImageDecoder = 8040,
  ImageDocument = 8053,
  ImageTrack = 8067,
  ImageTrackList = 8078,
  InferenceSession = 8093,
  InputEvent = 8110,
  InspectorCSSParser = 8121,
  InspectorFontFace = 8140,
  InspectorUtils = 8158,
  IntersectionObserver = 8173,
  IntersectionObserverEntry = 8194,
  IntlUtils = 8220,
  JSActorTypeUtils = 8230,
  JSProcessActorChild = 8247,
  JSProcessActorParent = 8267,
  JSWindowActorChild = 8288,
  JSWindowActorParent = 8307,
  KeyEvent = 8327,
  KeyboardEvent = 8336,
  KeyframeEffect = 8350,
  L10nFileSource = 8365,
  L10nOverlays = 8380,
  L10nRegistry = 8393,
  LargestContentfulPaint = 8406,
  LegacyMozTCPSocket = 8429,
  LlamaRunner = 8448,
  Localization = 8460,
  Location = 8473,
  Lock = 8482,
  LockManager = 8487,
  MIDIAccess = 8499,
  MIDIConnectionEvent = 8510,
  MIDIInput = 8530,
  MIDIInputMap = 8540,
  MIDIMessageEvent = 8553,
  MIDIOutput = 8570,
  MIDIOutputMap = 8581,
  MIDIPort = 8595,
  MLS = 8604,
  MLSGroupView = 8608,
  MOZ_debug = 8621,
  MatchGlob = 8631,
  MatchPattern = 8641,
  MatchPatternSet = 8654,
  MathMLElement = 8670,
  MediaCapabilities = 8684,
  MediaControlService = 8702,
  MediaController = 8722,
  MediaDeviceInfo = 8738,
  MediaDevices = 8754,
  MediaElementAudioSourceNode = 8767,
  MediaEncryptedEvent = 8795,
  MediaError = 8815,
  MediaKeyError = 8826,
  MediaKeyMessageEvent = 8840,
  MediaKeySession = 8861,
  MediaKeyStatusMap = 8877,
  MediaKeyStatusMap_Iterator = 8895,
  MediaKeySystemAccess = 8922,
  MediaKeys = 8943,
  MediaList = 8953,
  MediaMetadata = 8963,
  MediaQueryList = 8977,
  MediaQueryListEvent = 8992,
  MediaRecorder = 9012,
  MediaRecorderErrorEvent = 9026,
  MediaSession = 9050,
  MediaSource = 9063,
  MediaStream = 9075,
  MediaStreamAudioDestinationNode = 9087,
  MediaStreamAudioSourceNode = 9119,
  MediaStreamError = 9146,
  MediaStreamEvent = 9163,
  MediaStreamTrack = 9180,
  MediaStreamTrackAudioSourceNode = 9197,
  MediaStreamTrackEvent = 9229,
  MerchantValidationEvent = 9251,
  MessageBroadcaster = 9275,
  MessageChannel = 9294,
  MessageEvent = 9309,
  MessageListenerManager = 9322,
  MessagePort = 9345,
  MessageSender = 9357,
  MimeType = 9371,
  MimeTypeArray = 9380,
  MouseEvent = 9394,
  MouseScrollEvent = 9405,
  MozCanvasPrintState = 9422,
  MozDocumentMatcher = 9442,
  MozDocumentObserver = 9461,
  MozQueryInterface = 9481,
  MozSharedMap = 9499,
  MozSharedMap_Iterator = 9512,
  MozSharedMapChangeEvent = 9534,
  MozStorageAsyncStatementParams = 9558,
  MozStorageStatementParams = 9589,
  MozStorageStatementRow = 9615,
  MozWritableSharedMap = 9638,
  MutationObserver = 9659,
  MutationRecord = 9676,
  NamedNodeMap = 9691,
  NavigateEvent = 9704,
  Navigation = 9718,
  NavigationActivation = 9729,
  NavigationCurrentEntryChangeEvent = 9750,
  NavigationDestination = 9784,
  NavigationHistoryEntry = 9806,
  NavigationPrecommitController = 9829,
  NavigationPreloadManager = 9859,
  NavigationTransition = 9884,
  Navigator = 9905,
  NavigatorLogin = 9915,
  NetworkInformation = 9930,
  Node = 9949,
  NodeFilter = 9954,
  NodeIterator = 9965,
  NodeList = 9978,
  Notification = 9987,
  NotificationEvent = 10000,
  NotifyPaintEvent = 10018,
  OES_draw_buffers_indexed = 10035,
  OES_element_index_uint = 10060,
  OES_fbo_render_mipmap = 10083,
  OES_standard_derivatives = 10105,
  OES_texture_float = 10130,
  OES_texture_float_linear = 10148,
  OES_texture_half_float = 10173,
  OES_texture_half_float_linear = 10196,
  OES_vertex_array_object = 10226,
  OVR_multiview2 = 10250,
  OfflineAudioCompletionEvent = 10265,
  OfflineAudioContext = 10293,
  OffscreenCanvas = 10313,
  OffscreenCanvasRenderingContext2D = 10329,
  OnlyForUseInConstructor = 10363,
  Option = 10387,
  OscillatorNode = 10394,
  PageRevealEvent = 10409,
  PageSwapEvent = 10425,
  PageTransitionEvent = 10439,
  PaintRequest = 10459,
  PaintRequestList = 10472,
  PaintWorkletGlobalScope = 10489,
  PannerNode = 10513,
  ParentProcessMessageManager = 10524,
  Path2D = 10552,
  PathUtils = 10559,
  PaymentAddress = 10569,
  PaymentMethodChangeEvent = 10584,
  PaymentRequest = 10609,
  PaymentRequestUpdateEvent = 10624,
  PaymentResponse = 10650,
  PeerConnectionImpl = 10666,
  PeerConnectionObserver = 10685,
  Performance = 10708,
  PerformanceEntry = 10720,
  PerformanceEntryEvent = 10737,
  PerformanceEventTiming = 10759,
  PerformanceMark = 10782,
  PerformanceMeasure = 10798,
  PerformanceNavigation = 10817,
  PerformanceNavigationTiming = 10839,
  PerformanceObserver = 10867,
  PerformanceObserverEntryList = 10887,
  PerformancePaintTiming = 10916,
  PerformanceResourceTiming = 10939,
  PerformanceServerTiming = 10965,
  PerformanceTiming = 10989,
  PeriodicWave = 11007,
  PermissionStatus = 11020,
  Permissions = 11037,
  PlacesBookmark = 11049,
  PlacesBookmarkAddition = 11064,
  PlacesBookmarkChanged = 11087,
  PlacesBookmarkGuid = 11109,
  PlacesBookmarkKeyword = 11128,
  PlacesBookmarkMoved = 11150,
  PlacesBookmarkRemoved = 11170,
  PlacesBookmarkTags = 11192,
  PlacesBookmarkTime = 11211,
  PlacesBookmarkTitle = 11230,
  PlacesBookmarkUrl = 11250,
  PlacesEvent = 11268,
  PlacesEventCounts = 11280,
  PlacesFavicon = 11298,
  PlacesHistoryCleared = 11312,
  PlacesObservers = 11333,
  PlacesPurgeCaches = 11349,
  PlacesRanking = 11367,
  PlacesVisit = 11381,
  PlacesVisitRemoved = 11393,
  PlacesVisitTitle = 11412,
  PlacesWeakCallbackWrapper = 11429,
  Plugin = 11455,
  PluginArray = 11462,
  PluginCrashedEvent = 11474,
  PointerEvent = 11493,
  PopStateEvent = 11506,
  PopupBlockedEvent = 11520,
  PopupPositionedEvent = 11538,
  PositionStateEvent = 11559,
  PrecompiledScript = 11578,
  PrivateAttribution = 11596,
  ProcessMessageManager = 11615,
  ProcessingInstruction = 11637,
  ProgressEvent = 11659,
  PromiseDebugging = 11673,
  PromiseNativeHandler = 11690,
  PromiseRejectionEvent = 11711,
  PublicKeyCredential = 11733,
  PushEvent = 11753,
  PushManager = 11763,
  PushManagerImpl = 11775,
  PushMessageData = 11791,
  PushSubscription = 11807,
  PushSubscriptionChangeEvent = 11824,
  PushSubscriptionOptions = 11852,
  RTCCertificate = 11876,
  RTCDTMFSender = 11891,
  RTCDTMFToneChangeEvent = 11905,
  RTCDataChannel = 11928,
  RTCDataChannelEvent = 11943,
  RTCDtlsTransport = 11963,
  RTCEncodedAudioFrame = 11980,
  RTCEncodedVideoFrame = 12001,
  RTCIceCandidate = 12022,
  RTCIceTransport = 12038,
  RTCIdentityProviderRegistrar = 12054,
  RTCPeerConnection = 12083,
  RTCPeerConnectionIceEvent = 12101,
  RTCPeerConnectionStatic = 12127,
  RTCRtpReceiver = 12151,
  RTCRtpScriptTransform = 12166,
  RTCRtpScriptTransformer = 12188,
  RTCRtpSender = 12212,
  RTCRtpTransceiver = 12225,
  RTCSctpTransport = 12243,
  RTCSessionDescription = 12260,
  RTCStatsReport = 12282,
  RTCTrackEvent = 12297,
  RTCTransformEvent = 12311,
  RadioNodeList = 12329,
  Range = 12343,
  ReadableByteStreamController = 12349,
  ReadableStream = 12378,
  ReadableStream_AsyncIterator = 12393,
  ReadableStreamBYOBReader = 12422,
  ReadableStreamBYOBRequest = 12447,
  ReadableStreamDefaultController = 12473,
  ReadableStreamDefaultReader = 12505,
  RedirectBlockedEvent = 12533,
  Report = 12554,
  ReportBody = 12561,
  ReportingObserver = 12572,
  Request = 12590,
  ResizeObserver = 12598,
  ResizeObserverEntry = 12613,
  ResizeObserverSize = 12633,
  Response = 12652,
  SVGAElement = 12661,
  SVGAngle = 12673,
  SVGAnimateElement = 12682,
  SVGAnimateMotionElement = 12700,
  SVGAnimateTransformElement = 12724,
  SVGAnimatedAngle = 12751,
  SVGAnimatedBoolean = 12768,
  SVGAnimatedEnumeration = 12787,
  SVGAnimatedInteger = 12810,
  SVGAnimatedLength = 12829,
  SVGAnimatedLengthList = 12847,
  SVGAnimatedNumber = 12869,
  SVGAnimatedNumberList = 12887,
  SVGAnimatedPreserveAspectRatio = 12909,
  SVGAnimatedRect = 12940,
  SVGAnimatedString = 12956,
  SVGAnimatedTransformList = 12974,
  SVGAnimationElement = 12999,
  SVGCircleElement = 13019,
  SVGClipPathElement = 13036,
  SVGComponentTransferFunctionElement = 13055,
  SVGDefsElement = 13091,
  SVGDescElement = 13106,
  SVGElement = 13121,
  SVGEllipseElement = 13132,
  SVGFEBlendElement = 13150,
  SVGFEColorMatrixElement = 13168,
  SVGFEComponentTransferElement = 13192,
  SVGFECompositeElement = 13222,
  SVGFEConvolveMatrixElement = 13244,
  SVGFEDiffuseLightingElement = 13271,
  SVGFEDisplacementMapElement = 13299,
  SVGFEDistantLightElement = 13327,
  SVGFEDropShadowElement = 13352,
  SVGFEFloodElement = 13375,
  SVGFEFuncAElement = 13393,
  SVGFEFuncBElement = 13411,
  SVGFEFuncGElement = 13429,
  SVGFEFuncRElement = 13447,
  SVGFEGaussianBlurElement = 13465,
  SVGFEImageElement = 13490,
  SVGFEMergeElement = 13508,
  SVGFEMergeNodeElement = 13526,
  SVGFEMorphologyElement = 13548,
  SVGFEOffsetElement = 13571,
  SVGFEPointLightElement = 13590,
  SVGFESpecularLightingElement = 13613,
  SVGFESpotLightElement = 13642,
  SVGFETileElement = 13664,
  SVGFETurbulenceElement = 13681,
  SVGFilterElement = 13704,
  SVGForeignObjectElement = 13721,
  SVGGElement = 13745,
  SVGGeometryElement = 13757,
  SVGGradientElement = 13776,
  SVGGraphicsElement = 13795,
  SVGImageElement = 13814,
  SVGLength = 13830,
  SVGLengthList = 13840,
  SVGLineElement = 13854,
  SVGLinearGradientElement = 13869,
  SVGMPathElement = 13894,
  SVGMarkerElement = 13910,
  SVGMaskElement = 13927,
  SVGMatrix = 13942,
  SVGMetadataElement = 13952,
  SVGNumber = 13971,
  SVGNumberList = 13981,
  SVGPathElement = 13995,
  SVGPathSegment = 14010,
  SVGPatternElement = 14025,
  SVGPoint = 14043,
  SVGPointList = 14052,
  SVGPolygonElement = 14065,
  SVGPolylineElement = 14083,
  SVGPreserveAspectRatio = 14102,
  SVGRadialGradientElement = 14125,
  SVGRect = 14150,
  SVGRectElement = 14158,
  SVGSVGElement = 14173,
  SVGScriptElement = 14187,
  SVGSetElement = 14204,
  SVGStopElement = 14218,
  SVGStringList = 14233,
  SVGStyleElement = 14247,
  SVGSwitchElement = 14263,
  SVGSymbolElement = 14280,
  SVGTSpanElement = 14297,
  SVGTextContentElement = 14313,
  SVGTextElement = 14335,
  SVGTextPathElement = 14350,
  SVGTextPositioningElement = 14369,
  SVGTitleElement = 14395,
  SVGTransform = 14411,
  SVGTransformList = 14424,
  SVGUnitTypes = 14441,
  SVGUseElement = 14454,
  SVGViewElement = 14468,
  Sanitizer = 14483,
  Scheduler = 14493,
  Screen = 14503,
  ScreenLuminance = 14510,
  ScreenOrientation = 14526,
  ScriptProcessorNode = 14544,
  ScrollAreaEvent = 14564,
  SecurityPolicyViolationEvent = 14580,
  Selection = 14609,
  ServiceWorker = 14619,
  ServiceWorkerContainer = 14633,
  ServiceWorkerGlobalScope = 14656,
  ServiceWorkerRegistration = 14681,
  SessionStoreFormData = 14707,
  SessionStoreScrollData = 14728,
  SessionStoreUtils = 14751,
  ShadowRealmGlobalScope = 14769,
  ShadowRoot = 14792,
  SharedWorker = 14803,
  SharedWorkerGlobalScope = 14816,
  SimpleGestureEvent = 14840,
  SourceBuffer = 14859,
  SourceBufferList = 14872,
  SpeechGrammar = 14889,
  SpeechGrammarList = 14903,
  SpeechRecognition = 14921,
  SpeechRecognitionAlternative = 14939,
  SpeechRecognitionError = 14968,
  SpeechRecognitionEvent = 14991,
  SpeechRecognitionResult = 15014,
  SpeechRecognitionResultList = 15038,
  SpeechSynthesis = 15066,
  SpeechSynthesisErrorEvent = 15082,
  SpeechSynthesisEvent = 15108,
  SpeechSynthesisUtterance = 15129,
  SpeechSynthesisVoice = 15154,
  StaticRange = 15175,
  StereoPannerNode = 15187,
  Storage = 15204,
  StorageEvent = 15212,
  StorageManager = 15225,
  StreamFilter = 15240,
  StreamFilterDataEvent = 15253,
  StructuredCloneHolder = 15275,
  StructuredCloneTester = 15297,
  StylePropertyMap = 15319,
  StylePropertyMapReadOnly = 15336,
  StylePropertyMapReadOnly_Iterator = 15361,
  StyleSheet = 15395,
  StyleSheetApplicableStateChangeEvent = 15406,
  StyleSheetList = 15443,
  StyleSheetRemovedEvent = 15458,
  SubmitEvent = 15481,
  SubtleCrypto = 15493,
  SyncMessageSender = 15506,
  SyncReadFile = 15524,
  TCPServerSocket = 15537,
  TCPServerSocketEvent = 15553,
  TCPSocket = 15574,
  TCPSocketErrorEvent = 15584,
  TCPSocketEvent = 15604,
  TaskController = 15619,
  TaskPriorityChangeEvent = 15634,
  TaskSignal = 15658,
  Tensor = 15669,
  TestAttributesOnTypes = 15676,
  TestCEReactionsInterface = 15698,
  TestCImplementedInterface = 15723,
  TestCImplementedInterface2 = 15749,
  TestCallbackDictUnionOverload = 15776,
  TestChildInterface = 15806,
  TestConstructorForFuncInterface = 15825,
  TestConstructorForPrefInterface = 15857,
  TestConstructorForSCInterface = 15889,
  TestCppKeywordNamedMethodsInterface = 15919,
  TestDeprecatedInterface = 15955,
  TestExampleInterface = 15979,
  TestExampleProxyInterface = 16000,
  TestExampleThrowingConstructorInterface = 16026,
  TestExampleWorkerInterface = 16066,
  TestFuncConstructorForDifferentFuncInterface = 16093,
  TestFuncConstructorForInterface = 16138,
  TestHTMLConstructorInterface = 16170,
  TestIndexedAndNamedGetterAndSetterInterface = 16199,
  TestIndexedAndNamedGetterInterface = 16243,
  TestIndexedAndNamedSetterInterface = 16278,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 16313,
  TestIndexedGetterInterface = 16363,
  TestIndexedSetterInterface = 16390,
  TestInterface = 16417,
  TestInterfaceWithPromiseConstructorArg = 16431,
  TestJSImplInterface = 16470,
  TestJSImplInterface2 = 16490,
  TestJSImplInterface3 = 16511,
  TestJSImplInterface4 = 16532,
  TestJSImplInterface5 = 16553,
  TestJSImplInterface6 = 16574,
  TestJSImplNoInterfaceObject = 16595,
  TestLegacyFactoryFunctionInterface = 16623,
  TestLegacyFactoryFunctionInterface2 = 16658,
  TestNamedDeleterInterface = 16694,
  TestNamedDeleterWithRetvalInterface = 16720,
  TestNamedGetterInterface = 16756,
  TestNamedSetterInterface = 16781,
  TestNamespace = 16806,
  TestNonWrapperCacheInterface = 16820,
  TestParentInterface = 16849,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16869,
  TestPrefConstructorForDifferentPrefInterface = 16917,
  TestPrefConstructorForInterface = 16962,
  TestProtoObjectHackedNamespace = 16994,
  TestRenamedInterface = 17025,
  TestRenamedNamespace = 17046,
  TestReportBody = 17067,
  TestReportGenerator = 17082,
  TestSCConstructorForInterface = 17102,
  TestSecureContextInterface = 17132,
  TestThrowingConstructorInterface = 17159,
  TestUtils = 17192,
  TestWorkerExposedInterface = 17202,
  TestingDeprecatedInterface = 17229,
  Text = 17256,
  TextClause = 17261,
  TextDecoder = 17272,
  TextDecoderStream = 17284,
  TextEncoder = 17302,
  TextEncoderStream = 17314,
  TextEvent = 17332,
  TextMetrics = 17342,
  TextTrack = 17354,
  TextTrackCue = 17364,
  TextTrackCueList = 17377,
  TextTrackList = 17394,
  TimeEvent = 17408,
  TimeRanges = 17418,
  ToggleEvent = 17429,
  Touch = 17441,
  TouchEvent = 17447,
  TouchList = 17458,
  TrackEvent = 17468,
  TransformStream = 17479,
  TransformStreamDefaultController = 17495,
  TransitionEvent = 17528,
  TreeColumn = 17544,
  TreeColumns = 17555,
  TreeContentView = 17567,
  TreeWalker = 17583,
  TrustedHTML = 17594,
  TrustedScript = 17606,
  TrustedScriptURL = 17620,
  TrustedTypePolicy = 17637,
  TrustedTypePolicyFactory = 17655,
  UDPMessageEvent = 17680,
  UDPSocket = 17696,
  UIEvent = 17706,
  URL = 17714,
  URLPattern = 17718,
  URLSearchParams = 17729,
  URLSearchParams_Iterator = 17745,
  UniFFIPointer = 17770,
  UniFFIScaffolding = 17784,
  UserActivation = 17802,
  UserInteraction = 17817,
  UserProximityEvent = 17833,
  VRDisplay = 17852,
  VRDisplayCapabilities = 17862,
  VRDisplayEvent = 17884,
  VREyeParameters = 17899,
  VRFieldOfView = 17915,
  VRFrameData = 17929,
  VRMockController = 17941,
  VRMockDisplay = 17958,
  VRPose = 17972,
  VRServiceTest = 17979,
  VRStageParameters = 17993,
  VTTCue = 18011,
  VTTRegion = 18018,
  ValidityState = 18028,
  VideoColorSpace = 18042,
  VideoDecoder = 18058,
  VideoEncoder = 18071,
  VideoFrame = 18084,
  VideoPlaybackQuality = 18095,
  VideoTrack = 18116,
  VideoTrackList = 18127,
  ViewTransition = 18142,
  ViewTransitionTypeSet = 18157,
  VisualViewport = 18179,
  WEBGL_color_buffer_float = 18194,
  WEBGL_compressed_texture_astc = 18219,
  WEBGL_compressed_texture_etc = 18249,
  WEBGL_compressed_texture_etc1 = 18278,
  WEBGL_compressed_texture_pvrtc = 18308,
  WEBGL_compressed_texture_s3tc = 18339,
  WEBGL_compressed_texture_s3tc_srgb = 18369,
  WEBGL_debug_renderer_info = 18404,
  WEBGL_debug_shaders = 18430,
  WEBGL_depth_texture = 18450,
  WEBGL_draw_buffers = 18470,
  WEBGL_explicit_present = 18489,
  WEBGL_lose_context = 18512,
  WEBGL_provoking_vertex = 18531,
  WGSLLanguageFeatures = 18554,
  WakeLock = 18575,
  WakeLockSentinel = 18584,
  WaveShaperNode = 18601,
  WebExtensionContentScript = 18616,
  WebExtensionPolicy = 18642,
  WebGL2RenderingContext = 18661,
  WebGLActiveInfo = 18684,
  WebGLBuffer = 18700,
  WebGLContextEvent = 18712,
  WebGLFramebuffer = 18730,
  WebGLProgram = 18747,
  WebGLQuery = 18760,
  WebGLRenderbuffer = 18771,
  WebGLRenderingContext = 18789,
  WebGLSampler = 18811,
  WebGLShader = 18824,
  WebGLShaderPrecisionFormat = 18836,
  WebGLSync = 18863,
  WebGLTexture = 18873,
  WebGLTransformFeedback = 18886,
  WebGLUniformLocation = 18909,
  WebGLVertexArrayObject = 18930,
  WebKitCSSMatrix = 18953,
  WebSocket = 18969,
  WebTransport = 18979,
  WebTransportBidirectionalStream = 18992,
  WebTransportDatagramDuplexStream = 19024,
  WebTransportError = 19057,
  WebTransportReceiveStream = 19075,
  WebTransportSendStream = 19101,
  WebrtcGlobalInformation = 19124,
  WheelEvent = 19148,
  Window = 19159,
  WindowClient = 19166,
  WindowContext = 19179,
  WindowGlobalChild = 19193,
  WindowGlobalParent = 19211,
  WindowRoot = 19230,
  Worker = 19241,
  WorkerDebuggerGlobalScope = 19248,
  WorkerGlobalScope = 19274,
  WorkerLocation = 19292,
  WorkerNavigator = 19307,
  WorkerTestUtils = 19323,
  Worklet = 19339,
  WorkletGlobalScope = 19347,
  WritableStream = 19366,
  WritableStreamDefaultController = 19381,
  WritableStreamDefaultWriter = 19413,
  XMLDocument = 19441,
  XMLHttpRequest = 19453,
  XMLHttpRequestEventTarget = 19468,
  XMLHttpRequestUpload = 19494,
  XMLSerializer = 19515,
  XPathEvaluator = 19529,
  XPathExpression = 19544,
  XPathResult = 19560,
  XRBoundedReferenceSpace = 19572,
  XRFrame = 19596,
  XRInputSource = 19604,
  XRInputSourceArray = 19618,
  XRInputSourceEvent = 19637,
  XRInputSourcesChangeEvent = 19656,
  XRPose = 19682,
  XRReferenceSpace = 19689,
  XRReferenceSpaceEvent = 19706,
  XRRenderState = 19728,
  XRRigidTransform = 19742,
  XRSession = 19759,
  XRSessionEvent = 19769,
  XRSpace = 19784,
  XRSystem = 19792,
  XRView = 19801,
  XRViewerPose = 19808,
  XRViewport = 19821,
  XRWebGLLayer = 19832,
  XSLTProcessor = 19845,
  XULCommandEvent = 19859,
  XULElement = 19875,
  XULFrameElement = 19886,
  XULMenuElement = 19902,
  XULPopupElement = 19917,
  XULResizerElement = 19933,
  XULTextElement = 19951,
  XULTreeElement = 19966,
  console = 19981,
  webkitSpeechGrammar = 19989,
  webkitSpeechGrammarList = 20009,
  webkitSpeechRecognition = 20033,
  webkitURL = 20057,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
