/* src/bazaar.p/bz-curated-section.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-entry-group.h"
#include "bz-curated-category-info.h"
#include "bz-curated-markdown-info.h"
#include "bz-curated-image-info.h"

G_BEGIN_DECLS



#define BZ_TYPE_CURATED_SECTION (bz_curated_section_get_type ())
G_DECLARE_FINAL_TYPE (BzCuratedSection, bz_curated_section, BZ, CURATED_SECTION, GObject)

BzCuratedSection *
bz_curated_section_new (void);

gboolean
bz_curated_section_get_expand_horizontally (BzCuratedSection *self);

gboolean
bz_curated_section_get_expand_vertically (BzCuratedSection *self);

GListModel *
bz_curated_section_get_classes (BzCuratedSection *self);

GListModel *
bz_curated_section_get_light_classes (BzCuratedSection *self);

GListModel *
bz_curated_section_get_dark_classes (BzCuratedSection *self);

BzCuratedCategoryInfo *
bz_curated_section_get_category (BzCuratedSection *self);

BzCuratedMarkdownInfo *
bz_curated_section_get_markdown (BzCuratedSection *self);

BzCuratedImageInfo *
bz_curated_section_get_image (BzCuratedSection *self);

void
bz_curated_section_set_expand_horizontally (BzCuratedSection *self,
    gboolean expand_horizontally);

void
bz_curated_section_set_expand_vertically (BzCuratedSection *self,
    gboolean expand_vertically);

void
bz_curated_section_set_classes (BzCuratedSection *self,
    GListModel *classes);

void
bz_curated_section_set_light_classes (BzCuratedSection *self,
    GListModel *light_classes);

void
bz_curated_section_set_dark_classes (BzCuratedSection *self,
    GListModel *dark_classes);

void
bz_curated_section_set_category (BzCuratedSection *self,
    BzCuratedCategoryInfo *category);

void
bz_curated_section_set_markdown (BzCuratedSection *self,
    BzCuratedMarkdownInfo *markdown);

void
bz_curated_section_set_image (BzCuratedSection *self,
    BzCuratedImageInfo *image);

G_END_DECLS

/* End of src/bazaar.p/bz-curated-section.h */
