\name{LabelMapOverlayImageFilter}
\alias{LabelMapOverlayImageFilter}
\title{LabelMapOverlayImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Apply a colormap to a label map and superimpose it on an image.
LabelMapOverlayImageFilter}
\details{
Apply a colormap to a label map and put it on top of the feature
image. The feature image is typically the image from which the
labeling was produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.
The set of colors is a good selection of distinct colors. The opacity
of the label map can be defined by the user. A background label
produce a gray pixel with the same intensity than the input one.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
LabelOverlayImageFilter , LabelOverlayFunctor
LabelMapToRGBImageFilter , LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter
LabelMapOverlay for the procedural interface
itk::LabelMapOverlayImageFilter for the Doxygen on the original ITK class.
LabelMapOverlayImageFilter}
%C++ includes: sitkLabelMapOverlayImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &labelMapImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{std::vector< unsigned char > GetColormap() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOpacity() const:}{
Set/Get the opacity of the colored label image. The value must be
between 0 and 1
}
\item{ LabelMapOverlayImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetColormap(std::vector< unsigned char > Colormap):}{}
\item{Self SetOpacity(double Opacity):}{
Set/Get the opacity of the colored label image. The value must be
between 0 and 1
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelMapOverlayImageFilter():}{
Destructor
}
}
}
