/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Flips an image across user specified axes.


FlipImageFilter flips an image across user specified axes. The flip axes are set via
method SetFlipAxes( array ) where the input is a
FixedArray&lt;bool,ImageDimension&gt;. The image is flipped across
axes for which array[i] is true.

In terms of grid coordinates the image is flipped within the
LargestPossibleRegion of the input image. As such, the
LargestPossibleRegion of the output image is the same as the input.

In terms of geometric coordinates, the output origin is such that the
image is flipped with respect to the coordinate axes.
See:
 itk::simple::Flip for the procedural interface

 itk::FlipImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFlipImageFilter.h
*/
public class FlipImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FlipImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FlipImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FlipImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FlipImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FlipImageFilter::~FlipImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FlipImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FlipImageFilter::FlipImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FlipImageFilter() {
    this(SimpleITKJNI.new_FlipImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FlipImageFilter::SetFlipAxes(std::vector&lt; bool &gt; FlipAxes)

Set/Get the axis to be flipped. The image is flipped along axes for
which array[i] is true. Default is false.

*/
public  void setFlipAxes(VectorBool FlipAxes) {
    SimpleITKJNI.FlipImageFilter_setFlipAxes(swigCPtr, this, VectorBool.getCPtr(FlipAxes), FlipAxes);
  }

  /**
std::vector&lt;bool&gt; itk::simple::FlipImageFilter::GetFlipAxes() const

Set/Get the axis to be flipped. The image is flipped along axes for
which array[i] is true. Default is false.

*/
public  VectorBool getFlipAxes() {
    return new VectorBool(SimpleITKJNI.FlipImageFilter_getFlipAxes(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FlipImageFilter::SetFlipAboutOrigin(bool FlipAboutOrigin)

Controls how the output origin is computed. If FlipAboutOrigin is
"On", the flip will occur about the origin of the axis, otherwise,
the flip will occur about the center of the axis. Default is "On".

*/
public  void setFlipAboutOrigin(boolean FlipAboutOrigin) {
    SimpleITKJNI.FlipImageFilter_setFlipAboutOrigin(swigCPtr, this, FlipAboutOrigin);
  }

  /**
Self&amp; itk::simple::FlipImageFilter::FlipAboutOriginOn()

Set the value of FlipAboutOrigin to true or false respectfully.

*/
public  void flipAboutOriginOn() {
    SimpleITKJNI.FlipImageFilter_flipAboutOriginOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FlipImageFilter::FlipAboutOriginOff()
*/
public  void flipAboutOriginOff() {
    SimpleITKJNI.FlipImageFilter_flipAboutOriginOff(swigCPtr, this);
  }

  /**
bool itk::simple::FlipImageFilter::GetFlipAboutOrigin() const

Controls how the output origin is computed. If FlipAboutOrigin is
"On", the flip will occur about the origin of the axis, otherwise,
the flip will occur about the center of the axis. Default is "On".

*/
public  boolean getFlipAboutOrigin() {
    return SimpleITKJNI.FlipImageFilter_getFlipAboutOrigin(swigCPtr, this);
  }

  /**
std::string itk::simple::FlipImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FlipImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FlipImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FlipImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FlipImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FlipImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
