#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

#ifdef __cplusplus
namespace zeroidc {
#endif // __cplusplus

typedef struct ZeroIDC ZeroIDC;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

struct ZeroIDC *zeroidc_new(const char *issuer,
                            const char *client_id,
                            const char *auth_endpoint,
                            const char *provider,
                            uint16_t web_listen_port);

void zeroidc_delete(struct ZeroIDC *ptr);

void zeroidc_start(struct ZeroIDC *ptr);

void zeroidc_stop(struct ZeroIDC *ptr);

bool zeroidc_is_running(struct ZeroIDC *ptr);

uint64_t zeroidc_get_exp_time(struct ZeroIDC *ptr);

void zeroidc_set_nonce_and_csrf(struct ZeroIDC *ptr, const char *csrf_token, const char *nonce);

void free_cstr(char *s);

char *zeroidc_get_auth_url(struct ZeroIDC *ptr);

char *zeroidc_token_exchange(struct ZeroIDC *idc, const char *code);

char *zeroidc_get_url_param_value(const char *param, const char *path);

char *zeroidc_network_id_from_state(const char *state);

void zeroidc_kick_refresh_thread(struct ZeroIDC *idc);

#ifdef __cplusplus
} // extern "C"
#endif // __cplusplus

#ifdef __cplusplus
} // namespace zeroidc
#endif // __cplusplus
