/* recent-manager-provider.c generated by valac 0.56.17, the Vala compiler
 * generated from recent-manager-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "zeitgeist-datamodel.h"
#include <gio/gio.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_RECENT_MANAGER_GTK (recent_manager_gtk_get_type ())
#define RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtk))
#define RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))
#define IS_RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_MANAGER_GTK))
#define IS_RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_MANAGER_GTK))
#define RECENT_MANAGER_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))

typedef struct _RecentManagerGtk RecentManagerGtk;
typedef struct _RecentManagerGtkClass RecentManagerGtkClass;
typedef struct _RecentManagerGtkPrivate RecentManagerGtkPrivate;
enum  {
	RECENT_MANAGER_GTK_0_PROPERTY,
	RECENT_MANAGER_GTK_UNIQUE_ID_PROPERTY,
	RECENT_MANAGER_GTK_NAME_PROPERTY,
	RECENT_MANAGER_GTK_DESCRIPTION_PROPERTY,
	RECENT_MANAGER_GTK_DATAHUB_PROPERTY,
	RECENT_MANAGER_GTK_ENABLED_PROPERTY,
	RECENT_MANAGER_GTK_REGISTER_PROPERTY,
	RECENT_MANAGER_GTK_NUM_PROPERTIES
};
static GParamSpec* recent_manager_gtk_properties[RECENT_MANAGER_GTK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _RecentManagerGtk {
	DataProvider parent_instance;
	RecentManagerGtkPrivate * priv;
};

struct _RecentManagerGtkClass {
	DataProviderClass parent_class;
};

struct _RecentManagerGtkPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GtkRecentManager* recent_manager;
	guint idle_id;
};

static gint RecentManagerGtk_private_offset;
static gpointer recent_manager_gtk_parent_class = NULL;

VALA_EXTERN GType data_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataProvider, g_object_unref)
VALA_EXTERN GType data_hub_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataHub, g_object_unref)
VALA_EXTERN GType recent_manager_gtk_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RecentManagerGtk, g_object_unref)
VALA_EXTERN void data_provider_start (DataProvider* self);
VALA_EXTERN void data_provider_stop (DataProvider* self);
VALA_EXTERN const gchar* data_provider_get_unique_id (DataProvider* self);
VALA_EXTERN void data_provider_set_unique_id (DataProvider* self,
                                  const gchar* value);
VALA_EXTERN const gchar* data_provider_get_name (DataProvider* self);
VALA_EXTERN void data_provider_set_name (DataProvider* self,
                             const gchar* value);
VALA_EXTERN const gchar* data_provider_get_description (DataProvider* self);
VALA_EXTERN void data_provider_set_description (DataProvider* self,
                                    const gchar* value);
VALA_EXTERN DataHub* data_provider_get_datahub (DataProvider* self);
VALA_EXTERN void data_provider_set_datahub (DataProvider* self,
                                DataHub* value);
VALA_EXTERN gboolean data_provider_get_enabled (DataProvider* self);
VALA_EXTERN void data_provider_set_enabled (DataProvider* self,
                                gboolean value);
VALA_EXTERN gboolean data_provider_get_register (DataProvider* self);
VALA_EXTERN void data_provider_set_register (DataProvider* self,
                                 gboolean value);
VALA_EXTERN RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub);
VALA_EXTERN RecentManagerGtk* recent_manager_gtk_construct (GType object_type,
                                                DataHub* datahub);
static void recent_manager_gtk_real_start (DataProvider* base);
static void recent_manager_gtk_items_changed (RecentManagerGtk* self);
static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender,
                                                                   gpointer self);
VALA_EXTERN GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self);
static void recent_manager_gtk_real_stop (DataProvider* base);
static gboolean ___lambda4_ (RecentManagerGtk* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gchar** data_hub_get_data_source_actors (DataHub* self,
                                         gboolean only_enabled,
                                         gint* result_length1);
VALA_EXTERN gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype);
VALA_EXTERN gchar* utils_find_desktop_file_for_app (const gchar* app_name,
                                        const gchar* mimetype);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN gint64 data_provider_get_last_timestamp (DataProvider* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static inline void _g_list_free__gtk_recent_info_unref0_ (GList* self);
VALA_EXTERN void data_provider_set_last_timestamp (DataProvider* self,
                                       gint64 value);
static GObject * recent_manager_gtk_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void recent_manager_gtk_finalize (GObject * obj);
static GType recent_manager_gtk_get_type_once (void);
static void _vala_recent_manager_gtk_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_recent_manager_gtk_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
recent_manager_gtk_get_instance_private (RecentManagerGtk* self)
{
	return G_STRUCT_MEMBER_P (self, RecentManagerGtk_private_offset);
}

RecentManagerGtk*
recent_manager_gtk_construct (GType object_type,
                              DataHub* datahub)
{
	RecentManagerGtk * self = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	self = (RecentManagerGtk*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,recent", "name", "Recently Used Documents", "description", "Logs events from GtkRecentlyUsed", "datahub", datahub, NULL);
	return self;
}

RecentManagerGtk*
recent_manager_gtk_new (DataHub* datahub)
{
	return recent_manager_gtk_construct (TYPE_RECENT_MANAGER_GTK, datahub);
}

static void
_recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender,
                                                              gpointer self)
{
	recent_manager_gtk_items_changed ((RecentManagerGtk*) self);
}

static void
recent_manager_gtk_real_start (DataProvider* base)
{
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->recent_manager;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self, 0);
	_tmp1_ = recent_manager_gtk_get_items (self);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp2_);
	_g_ptr_array_unref0 (_tmp2_);
}

static void
recent_manager_gtk_real_stop (DataProvider* base)
{
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_;
	guint _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->recent_manager;
	g_signal_parse_name ("changed", gtk_recent_manager_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self);
}

static gboolean
___lambda4_ (RecentManagerGtk* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gboolean result;
	_tmp0_ = recent_manager_gtk_get_items (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	self->priv->idle_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((RecentManagerGtk*) self);
	return result;
}

static void
recent_manager_gtk_items_changed (RecentManagerGtk* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->idle_id == ((guint) 0)) {
		self->priv->idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_gtk_recent_info_ref0 (gpointer self)
{
	return self ? gtk_recent_info_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_gtk_recent_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}

static inline void
_g_list_free__gtk_recent_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gtk_recent_info_unref0_);
}

GPtrArray*
recent_manager_gtk_get_items (RecentManagerGtk* self)
{
	GPtrArray* events = NULL;
	GPtrArray* _tmp0_;
	gint64 signal_time = 0LL;
	gchar** ignored_actors = NULL;
	DataHub* _tmp1_;
	DataHub* _tmp2_;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint ignored_actors_length1;
	gint _ignored_actors_size_;
	GtkRecentManager* _tmp5_;
	GList* _tmp6_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	events = _tmp0_;
	signal_time = zeitgeist_timestamp_from_now ();
	_tmp1_ = data_provider_get_datahub ((DataProvider*) self);
	_tmp2_ = _tmp1_;
	_tmp4_ = data_hub_get_data_source_actors (_tmp2_, TRUE, &_tmp3_);
	ignored_actors = _tmp4_;
	ignored_actors_length1 = _tmp3_;
	_ignored_actors_size_ = ignored_actors_length1;
	_tmp5_ = self->priv->recent_manager;
	_tmp6_ = gtk_recent_manager_get_items (_tmp5_);
	{
		GList* ri_collection = NULL;
		GList* ri_it = NULL;
		ri_collection = _tmp6_;
		for (ri_it = ri_collection; ri_it != NULL; ri_it = ri_it->next) {
			GtkRecentInfo* _tmp7_;
			GtkRecentInfo* ri = NULL;
			_tmp7_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) ri_it->data);
			ri = _tmp7_;
			{
				GFile* file_obj = NULL;
				GtkRecentInfo* _tmp8_;
				const gchar* _tmp9_;
				GFile* _tmp10_;
				gchar* uri = NULL;
				GFile* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				GtkRecentInfo* _tmp14_;
				gboolean _tmp16_ = FALSE;
				GtkRecentInfo* _tmp17_;
				gchar* last_app = NULL;
				GtkRecentInfo* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* exec_str = NULL;
				guint count = 0U;
				gulong time_ = 0UL;
				gboolean registered = FALSE;
				GtkRecentInfo* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				guint _tmp27_ = 0U;
				time_t _tmp28_ = 0;
				gboolean _tmp29_;
				gchar** exec = NULL;
				const gchar* _tmp32_;
				gchar** _tmp33_;
				gchar** _tmp34_;
				gint exec_length1;
				gint _exec_size_;
				gchar* desktop_file = NULL;
				gboolean _tmp35_ = FALSE;
				gchar** _tmp36_;
				gint _tmp36__length1;
				const gchar* _tmp37_;
				const gchar* _tmp59_;
				gchar* actor = NULL;
				const gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				const gchar* _tmp70_;
				gchar** _tmp71_;
				gint _tmp71__length1;
				GFile* parent_file = NULL;
				GFile* _tmp72_;
				GFile* _tmp73_;
				gchar* _tmp74_ = NULL;
				GFile* _tmp75_;
				gchar* origin = NULL;
				gchar* _tmp80_;
				ZeitgeistSubject* subject = NULL;
				const gchar* _tmp81_;
				GtkRecentInfo* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				const gchar* _tmp86_;
				GtkRecentInfo* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				GtkRecentInfo* _tmp90_;
				const gchar* _tmp91_;
				ZeitgeistSubject* _tmp92_;
				ZeitgeistEvent* event = NULL;
				gint64 timestamp = 0LL;
				gboolean log_create = FALSE;
				gboolean log_modify = FALSE;
				gboolean log_access = FALSE;
				GtkRecentInfo* _tmp93_;
				GtkRecentInfo* _tmp94_;
				GtkRecentInfo* _tmp95_;
				GtkRecentInfo* _tmp96_;
				_tmp8_ = ri;
				_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
				_tmp10_ = g_file_new_for_uri (_tmp9_);
				file_obj = _tmp10_;
				_tmp11_ = file_obj;
				_tmp12_ = g_file_get_uri (_tmp11_);
				uri = _tmp12_;
				_tmp14_ = ri;
				if (gtk_recent_info_get_private_hint (_tmp14_)) {
					_tmp13_ = TRUE;
				} else {
					const gchar* _tmp15_;
					_tmp15_ = uri;
					_tmp13_ = g_str_has_prefix (_tmp15_, "file:///tmp/");
				}
				if (_tmp13_) {
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp17_ = ri;
				if (gtk_recent_info_is_local (_tmp17_)) {
					GtkRecentInfo* _tmp18_;
					_tmp18_ = ri;
					_tmp16_ = !gtk_recent_info_exists (_tmp18_);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp19_ = ri;
				_tmp20_ = gtk_recent_info_last_application (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_strip (_tmp21_);
				_tmp23_ = _tmp22_;
				_g_free0 (_tmp21_);
				last_app = _tmp23_;
				_tmp24_ = ri;
				_tmp25_ = last_app;
				_tmp29_ = gtk_recent_info_get_application_info (_tmp24_, _tmp25_, &_tmp26_, &_tmp27_, (time_t*) (&_tmp28_));
				exec_str = _tmp26_;
				count = _tmp27_;
				time_ = (gulong) _tmp28_;
				registered = _tmp29_;
				if (!registered) {
					const gchar* _tmp30_;
					GtkRecentInfo* _tmp31_;
					_tmp30_ = last_app;
					_tmp31_ = ri;
					g_warning ("recent-manager-provider.vala:106: %s was not registered in RecentInfo " \
"item %p", _tmp30_, _tmp31_);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp32_ = exec_str;
				_tmp34_ = _tmp33_ = g_strsplit_set (_tmp32_, " \t\n", 2);
				exec = _tmp34_;
				exec_length1 = _vala_array_length (_tmp33_);
				_exec_size_ = exec_length1;
				_tmp36_ = exec;
				_tmp36__length1 = exec_length1;
				_tmp37_ = _tmp36_[0];
				if (g_strcmp0 (_tmp37_, "soffice") == 0) {
					_tmp35_ = TRUE;
				} else {
					gchar** _tmp38_;
					gint _tmp38__length1;
					const gchar* _tmp39_;
					_tmp38_ = exec;
					_tmp38__length1 = exec_length1;
					_tmp39_ = _tmp38_[0];
					_tmp35_ = g_strcmp0 (_tmp39_, "ooffice") == 0;
				}
				if (_tmp35_) {
					GtkRecentInfo* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp40_ = ri;
					_tmp41_ = gtk_recent_info_get_mime_type (_tmp40_);
					_tmp42_ = utils_get_ooo_desktop_file_for_mimetype (_tmp41_);
					_g_free0 (desktop_file);
					desktop_file = _tmp42_;
				} else {
					gchar** _tmp43_;
					gint _tmp43__length1;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					gboolean _tmp46_ = FALSE;
					const gchar* _tmp47_;
					_tmp43_ = exec;
					_tmp43__length1 = exec_length1;
					_tmp44_ = _tmp43_[0];
					_tmp45_ = utils_find_desktop_file_for_app (_tmp44_, NULL);
					_g_free0 (desktop_file);
					desktop_file = _tmp45_;
					_tmp47_ = desktop_file;
					if (_tmp47_ == NULL) {
						gchar** _tmp48_;
						gint _tmp48__length1;
						const gchar* _tmp49_;
						_tmp48_ = exec;
						_tmp48__length1 = exec_length1;
						_tmp49_ = _tmp48_[0];
						_tmp46_ = g_str_has_suffix (_tmp49_, "-bin");
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						gchar** _tmp50_;
						gint _tmp50__length1;
						const gchar* _tmp51_;
						gchar** _tmp52_;
						gint _tmp52__length1;
						const gchar* _tmp53_;
						gint _tmp54_;
						gint _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						_tmp50_ = exec;
						_tmp50__length1 = exec_length1;
						_tmp51_ = _tmp50_[0];
						_tmp52_ = exec;
						_tmp52__length1 = exec_length1;
						_tmp53_ = _tmp52_[0];
						_tmp54_ = strlen (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = string_substring (_tmp51_, (glong) 0, (glong) (_tmp55_ - 4));
						_tmp57_ = _tmp56_;
						_tmp58_ = utils_find_desktop_file_for_app (_tmp57_, NULL);
						_g_free0 (desktop_file);
						desktop_file = _tmp58_;
						_g_free0 (_tmp57_);
					}
				}
				_tmp59_ = desktop_file;
				if (_tmp59_ == NULL) {
					const gchar* _tmp60_;
					gchar** _tmp61_;
					gint _tmp61__length1;
					const gchar* _tmp62_;
					GtkRecentInfo* _tmp63_;
					const gchar* _tmp64_;
					_tmp60_ = uri;
					_tmp61_ = exec;
					_tmp61__length1 = exec_length1;
					_tmp62_ = _tmp61_[0];
					_tmp63_ = ri;
					_tmp64_ = gtk_recent_info_get_mime_type (_tmp63_);
					g_debug ("recent-manager-provider.vala:132: Desktop file for \"%s\" was not foun" \
"d, exec: %s, mime_type: %s", _tmp60_, _tmp62_, _tmp64_);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp65_ = desktop_file;
				_tmp66_ = g_path_get_basename (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strdup_printf ("application://%s", _tmp67_);
				_tmp69_ = _tmp68_;
				_g_free0 (_tmp67_);
				actor = _tmp69_;
				_tmp70_ = actor;
				_tmp71_ = ignored_actors;
				_tmp71__length1 = ignored_actors_length1;
				if (_vala_string_array_contains (_tmp71_, _tmp71__length1, _tmp70_)) {
					_g_free0 (actor);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp72_ = file_obj;
				_tmp73_ = g_file_get_parent (_tmp72_);
				parent_file = _tmp73_;
				_tmp75_ = parent_file;
				if (_tmp75_ != NULL) {
					GFile* _tmp76_;
					gchar* _tmp77_;
					_tmp76_ = parent_file;
					_tmp77_ = g_file_get_uri (_tmp76_);
					_g_free0 (_tmp74_);
					_tmp74_ = _tmp77_;
				} else {
					const gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp78_ = uri;
					_tmp79_ = g_path_get_dirname (_tmp78_);
					_g_free0 (_tmp74_);
					_tmp74_ = _tmp79_;
				}
				_tmp80_ = g_strdup (_tmp74_);
				origin = _tmp80_;
				_tmp81_ = uri;
				_tmp82_ = ri;
				_tmp83_ = gtk_recent_info_get_mime_type (_tmp82_);
				_tmp84_ = zeitgeist_interpretation_for_mimetype (_tmp83_);
				_tmp85_ = uri;
				_tmp86_ = zeitgeist_manifestation_for_uri (_tmp85_);
				_tmp87_ = ri;
				_tmp88_ = gtk_recent_info_get_mime_type (_tmp87_);
				_tmp89_ = origin;
				_tmp90_ = ri;
				_tmp91_ = gtk_recent_info_get_display_name (_tmp90_);
				_tmp92_ = zeitgeist_subject_new_full (_tmp81_, _tmp84_, _tmp86_, _tmp88_, _tmp89_, _tmp91_, "");
				subject = _tmp92_;
				log_create = TRUE;
				log_modify = TRUE;
				log_access = TRUE;
				_tmp93_ = ri;
				_tmp94_ = ri;
				if (gtk_recent_info_get_added (_tmp93_) == gtk_recent_info_get_modified (_tmp94_)) {
					log_modify = FALSE;
				}
				_tmp95_ = ri;
				_tmp96_ = ri;
				if (gtk_recent_info_get_modified (_tmp95_) == gtk_recent_info_get_visited (_tmp96_)) {
					log_access = FALSE;
				}
				if (log_create) {
					const gchar* _tmp97_;
					ZeitgeistEvent* _tmp98_;
					ZeitgeistEvent* _tmp99_;
					ZeitgeistSubject* _tmp100_;
					GtkRecentInfo* _tmp101_;
					ZeitgeistEvent* _tmp102_;
					gboolean _tmp103_ = FALSE;
					gint64 _tmp104_;
					gint64 _tmp105_;
					_tmp97_ = actor;
					_tmp98_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp97_, NULL, NULL, NULL);
					_g_object_unref0 (event);
					event = _tmp98_;
					_tmp99_ = event;
					_tmp100_ = subject;
					zeitgeist_event_add_subject (_tmp99_, _tmp100_);
					_tmp101_ = ri;
					timestamp = (gint64) gtk_recent_info_get_added (_tmp101_);
					timestamp *= (gint64) 1000;
					_tmp102_ = event;
					zeitgeist_event_set_timestamp (_tmp102_, timestamp);
					_tmp104_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp105_ = _tmp104_;
					if (timestamp > _tmp105_) {
						_tmp103_ = timestamp >= ((gint64) 0);
					} else {
						_tmp103_ = FALSE;
					}
					if (_tmp103_) {
						GPtrArray* _tmp106_;
						ZeitgeistEvent* _tmp107_;
						_tmp106_ = events;
						_tmp107_ = event;
						event = NULL;
						g_ptr_array_add (_tmp106_, _tmp107_);
					}
				}
				if (log_modify) {
					const gchar* _tmp108_;
					ZeitgeistEvent* _tmp109_;
					ZeitgeistEvent* _tmp110_;
					ZeitgeistSubject* _tmp111_;
					GtkRecentInfo* _tmp112_;
					ZeitgeistEvent* _tmp113_;
					gboolean _tmp114_ = FALSE;
					gint64 _tmp115_;
					gint64 _tmp116_;
					_tmp108_ = actor;
					_tmp109_ = zeitgeist_event_new_full (ZEITGEIST_ZG_MODIFY_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp108_, NULL, NULL, NULL);
					_g_object_unref0 (event);
					event = _tmp109_;
					_tmp110_ = event;
					_tmp111_ = subject;
					zeitgeist_event_add_subject (_tmp110_, _tmp111_);
					_tmp112_ = ri;
					timestamp = (gint64) gtk_recent_info_get_modified (_tmp112_);
					timestamp *= (gint64) 1000;
					_tmp113_ = event;
					zeitgeist_event_set_timestamp (_tmp113_, timestamp);
					_tmp115_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp116_ = _tmp115_;
					if (timestamp > _tmp116_) {
						_tmp114_ = timestamp >= ((gint64) 0);
					} else {
						_tmp114_ = FALSE;
					}
					if (_tmp114_) {
						GPtrArray* _tmp117_;
						ZeitgeistEvent* _tmp118_;
						_tmp117_ = events;
						_tmp118_ = event;
						event = NULL;
						g_ptr_array_add (_tmp117_, _tmp118_);
					}
				}
				if (log_access) {
					const gchar* _tmp119_;
					ZeitgeistEvent* _tmp120_;
					ZeitgeistEvent* _tmp121_;
					ZeitgeistSubject* _tmp122_;
					GtkRecentInfo* _tmp123_;
					ZeitgeistEvent* _tmp124_;
					gboolean _tmp125_ = FALSE;
					gint64 _tmp126_;
					gint64 _tmp127_;
					_tmp119_ = actor;
					_tmp120_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp119_, NULL, NULL, NULL);
					_g_object_unref0 (event);
					event = _tmp120_;
					_tmp121_ = event;
					_tmp122_ = subject;
					zeitgeist_event_add_subject (_tmp121_, _tmp122_);
					_tmp123_ = ri;
					timestamp = (gint64) gtk_recent_info_get_visited (_tmp123_);
					timestamp *= (gint64) 1000;
					_tmp124_ = event;
					zeitgeist_event_set_timestamp (_tmp124_, timestamp);
					_tmp126_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp127_ = _tmp126_;
					if (timestamp > _tmp127_) {
						_tmp125_ = timestamp >= ((gint64) 0);
					} else {
						_tmp125_ = FALSE;
					}
					if (_tmp125_) {
						GPtrArray* _tmp128_;
						ZeitgeistEvent* _tmp129_;
						_tmp128_ = events;
						_tmp129_ = event;
						event = NULL;
						g_ptr_array_add (_tmp128_, _tmp129_);
					}
				}
				_g_object_unref0 (event);
				_g_object_unref0 (subject);
				_g_free0 (origin);
				_g_free0 (_tmp74_);
				_g_object_unref0 (parent_file);
				_g_free0 (actor);
				_g_free0 (desktop_file);
				exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (last_app);
				_g_free0 (uri);
				_g_object_unref0 (file_obj);
				_gtk_recent_info_unref0 (ri);
			}
		}
		(ri_collection == NULL) ? NULL : (ri_collection = (_g_list_free__gtk_recent_info_unref0_ (ri_collection), NULL));
	}
	data_provider_set_last_timestamp ((DataProvider*) self, signal_time);
	result = events;
	ignored_actors = (_vala_array_free (ignored_actors, ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static const gchar*
recent_manager_gtk_real_get_unique_id (DataProvider* base)
{
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}

static void
recent_manager_gtk_real_set_unique_id (DataProvider* base,
                                       const gchar* value)
{
	RecentManagerGtk* self;
	gchar* old_value;
	self = (RecentManagerGtk*) base;
	old_value = recent_manager_gtk_real_get_unique_id (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, recent_manager_gtk_properties[RECENT_MANAGER_GTK_UNIQUE_ID_PROPERTY]);
	}
}

static const gchar*
recent_manager_gtk_real_get_name (DataProvider* base)
{
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
recent_manager_gtk_real_set_name (DataProvider* base,
                                  const gchar* value)
{
	RecentManagerGtk* self;
	gchar* old_value;
	self = (RecentManagerGtk*) base;
	old_value = recent_manager_gtk_real_get_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, recent_manager_gtk_properties[RECENT_MANAGER_GTK_NAME_PROPERTY]);
	}
}

static const gchar*
recent_manager_gtk_real_get_description (DataProvider* base)
{
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
recent_manager_gtk_real_set_description (DataProvider* base,
                                         const gchar* value)
{
	RecentManagerGtk* self;
	gchar* old_value;
	self = (RecentManagerGtk*) base;
	old_value = recent_manager_gtk_real_get_description (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, recent_manager_gtk_properties[RECENT_MANAGER_GTK_DESCRIPTION_PROPERTY]);
	}
}

static DataHub*
recent_manager_gtk_real_get_datahub (DataProvider* base)
{
	DataHub* result;
	RecentManagerGtk* self;
	DataHub* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
recent_manager_gtk_real_set_datahub (DataProvider* base,
                                     DataHub* value)
{
	RecentManagerGtk* self;
	DataHub* old_value;
	self = (RecentManagerGtk*) base;
	old_value = recent_manager_gtk_real_get_datahub (base);
	if (old_value != value) {
		DataHub* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_datahub);
		self->priv->_datahub = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, recent_manager_gtk_properties[RECENT_MANAGER_GTK_DATAHUB_PROPERTY]);
	}
}

static gboolean
recent_manager_gtk_real_get_enabled (DataProvider* base)
{
	gboolean result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_enabled;
	return result;
}

static void
recent_manager_gtk_real_set_enabled (DataProvider* base,
                                     gboolean value)
{
	RecentManagerGtk* self;
	gboolean old_value;
	self = (RecentManagerGtk*) base;
	old_value = recent_manager_gtk_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, recent_manager_gtk_properties[RECENT_MANAGER_GTK_ENABLED_PROPERTY]);
	}
}

static gboolean
recent_manager_gtk_real_get_register (DataProvider* base)
{
	gboolean result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_register;
	return result;
}

static void
recent_manager_gtk_real_set_register (DataProvider* base,
                                      gboolean value)
{
	RecentManagerGtk* self;
	gboolean old_value;
	self = (RecentManagerGtk*) base;
	old_value = recent_manager_gtk_real_get_register (base);
	if (old_value != value) {
		self->priv->_register = value;
		g_object_notify_by_pspec ((GObject *) self, recent_manager_gtk_properties[RECENT_MANAGER_GTK_REGISTER_PROPERTY]);
	}
}

static GObject *
recent_manager_gtk_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_;
	parent_class = G_OBJECT_CLASS (recent_manager_gtk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	_tmp0_ = gtk_recent_manager_get_default ();
	self->priv->recent_manager = _tmp0_;
	return obj;
}

static void
recent_manager_gtk_class_init (RecentManagerGtkClass * klass,
                               gpointer klass_data)
{
	recent_manager_gtk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RecentManagerGtk_private_offset);
	((DataProviderClass *) klass)->start = (void (*) (DataProvider*)) recent_manager_gtk_real_start;
	((DataProviderClass *) klass)->stop = (void (*) (DataProvider*)) recent_manager_gtk_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = (const gchar* (*) (DataProvider*)) recent_manager_gtk_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = (void (*) (DataProvider*, const gchar*)) recent_manager_gtk_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = (const gchar* (*) (DataProvider*)) recent_manager_gtk_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = (void (*) (DataProvider*, const gchar*)) recent_manager_gtk_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = (const gchar* (*) (DataProvider*)) recent_manager_gtk_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = (void (*) (DataProvider*, const gchar*)) recent_manager_gtk_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = (DataHub* (*) (DataProvider*)) recent_manager_gtk_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = (void (*) (DataProvider*, DataHub*)) recent_manager_gtk_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = (gboolean (*) (DataProvider*)) recent_manager_gtk_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = (void (*) (DataProvider*, gboolean)) recent_manager_gtk_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = (gboolean (*) (DataProvider*)) recent_manager_gtk_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = (void (*) (DataProvider*, gboolean)) recent_manager_gtk_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_recent_manager_gtk_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_recent_manager_gtk_set_property;
	G_OBJECT_CLASS (klass)->constructor = recent_manager_gtk_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_manager_gtk_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_UNIQUE_ID_PROPERTY, recent_manager_gtk_properties[RECENT_MANAGER_GTK_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_NAME_PROPERTY, recent_manager_gtk_properties[RECENT_MANAGER_GTK_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DESCRIPTION_PROPERTY, recent_manager_gtk_properties[RECENT_MANAGER_GTK_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DATAHUB_PROPERTY, recent_manager_gtk_properties[RECENT_MANAGER_GTK_DATAHUB_PROPERTY] = g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_ENABLED_PROPERTY, recent_manager_gtk_properties[RECENT_MANAGER_GTK_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_REGISTER_PROPERTY, recent_manager_gtk_properties[RECENT_MANAGER_GTK_REGISTER_PROPERTY] = g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
recent_manager_gtk_instance_init (RecentManagerGtk * self,
                                  gpointer klass)
{
	self->priv = recent_manager_gtk_get_instance_private (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->idle_id = (guint) 0;
}

static void
recent_manager_gtk_finalize (GObject * obj)
{
	RecentManagerGtk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	G_OBJECT_CLASS (recent_manager_gtk_parent_class)->finalize (obj);
}

static GType
recent_manager_gtk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RecentManagerGtkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_manager_gtk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentManagerGtk), 0, (GInstanceInitFunc) recent_manager_gtk_instance_init, NULL };
	GType recent_manager_gtk_type_id;
	recent_manager_gtk_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "RecentManagerGtk", &g_define_type_info, 0);
	RecentManagerGtk_private_offset = g_type_add_instance_private (recent_manager_gtk_type_id, sizeof (RecentManagerGtkPrivate));
	return recent_manager_gtk_type_id;
}

GType
recent_manager_gtk_get_type (void)
{
	static volatile gsize recent_manager_gtk_type_id__once = 0;
	if (g_once_init_enter (&recent_manager_gtk_type_id__once)) {
		GType recent_manager_gtk_type_id;
		recent_manager_gtk_type_id = recent_manager_gtk_get_type_once ();
		g_once_init_leave (&recent_manager_gtk_type_id__once, recent_manager_gtk_type_id);
	}
	return recent_manager_gtk_type_id__once;
}

static void
_vala_recent_manager_gtk_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RecentManagerGtk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_NAME_PROPERTY:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION_PROPERTY:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DATAHUB_PROPERTY:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_ENABLED_PROPERTY:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_REGISTER_PROPERTY:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_recent_manager_gtk_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RecentManagerGtk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID_PROPERTY:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_NAME_PROPERTY:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION_PROPERTY:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DATAHUB_PROPERTY:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case RECENT_MANAGER_GTK_ENABLED_PROPERTY:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case RECENT_MANAGER_GTK_REGISTER_PROPERTY:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

