/* This file is generated by vkr_device_object.py. */

#ifndef VKR_QUERY_POOL_GEN_H
#define VKR_QUERY_POOL_GEN_H

#include "vkr_common.h"

#include "venus-protocol/vn_protocol_renderer_query_pool.h"

#include "vkr_context.h"
#include "vkr_device.h"

/* create a driver VkQueryPool and update the vkr_query_pool */
static inline VkResult
vkr_query_pool_create_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkCreateQueryPool *args,
   struct vkr_query_pool *obj)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkCreateQueryPool_args_handle(args);
   args->ret = vk->CreateQueryPool(args->device, args->pCreateInfo, NULL,
      &obj->base.handle.query_pool);
   return args->ret;
}

/* create a vkr_query_pool */
static inline struct vkr_query_pool *
vkr_query_pool_create(
   struct vkr_context *ctx,
   struct vn_command_vkCreateQueryPool *args)
{
   struct vkr_query_pool *obj = vkr_context_alloc_object(ctx, sizeof(*obj),
      VK_OBJECT_TYPE_QUERY_POOL, args->pQueryPool);
   if (!obj) {
      args->ret = VK_ERROR_OUT_OF_HOST_MEMORY;
      return NULL;
   }

   /* handles in args are replaced */
   if (vkr_query_pool_create_driver_handle(ctx, args, obj) != VK_SUCCESS) {
      free(obj);
      return NULL;
   }

   return obj;
}

/* create a vkr_query_pool and add it to the vkr_device */
static inline struct vkr_query_pool *
vkr_query_pool_create_and_add(
   struct vkr_context *ctx,
   struct vn_command_vkCreateQueryPool *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);

   struct vkr_query_pool *obj = vkr_query_pool_create(ctx, args);
   if (!obj)
      return NULL;

   vkr_device_add_object(ctx, dev, &obj->base);
   return obj;
}

/* destroy a driver VkQueryPool */
static inline void
vkr_query_pool_destroy_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkDestroyQueryPool *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkDestroyQueryPool_args_handle(args);
   vk->DestroyQueryPool(args->device, args->queryPool, NULL);
}

/* remove a vkr_query_pool from the device and destroy it */
static inline void
vkr_query_pool_destroy_and_remove(
   struct vkr_context *ctx,
   struct vn_command_vkDestroyQueryPool *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vkr_query_pool *obj = vkr_query_pool_from_handle(args->queryPool);
   if (!obj)
      return;

   vkr_query_pool_destroy_driver_handle(ctx, args);

   vkr_device_remove_object(ctx, dev, &obj->base);
}

#endif /* VKR_QUERY_POOL_GEN_H */
