/* This file is generated by vkr_device_object.py. */

#ifndef VKR_COMMAND_BUFFER_GEN_H
#define VKR_COMMAND_BUFFER_GEN_H

#include "vkr_common.h"

#include "venus-protocol/vn_protocol_renderer_command_pool.h"
#include "venus-protocol/vn_protocol_renderer_command_buffer.h"

#include "vkr_context.h"
#include "vkr_device.h"

/* create a driver VkCommandPool and update the vkr_command_pool */
static inline VkResult
vkr_command_pool_create_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkCreateCommandPool *args,
   struct vkr_command_pool *obj)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkCreateCommandPool_args_handle(args);
   args->ret = vk->CreateCommandPool(args->device, args->pCreateInfo, NULL,
      &obj->base.handle.command_pool);
   return args->ret;
}

/* create a vkr_command_pool */
static inline struct vkr_command_pool *
vkr_command_pool_create(
   struct vkr_context *ctx,
   struct vn_command_vkCreateCommandPool *args)
{
   struct vkr_command_pool *obj = vkr_context_alloc_object(ctx, sizeof(*obj),
      VK_OBJECT_TYPE_COMMAND_POOL, args->pCommandPool);
   if (!obj) {
      args->ret = VK_ERROR_OUT_OF_HOST_MEMORY;
      return NULL;
   }

   /* handles in args are replaced */
   if (vkr_command_pool_create_driver_handle(ctx, args, obj) != VK_SUCCESS) {
      free(obj);
      return NULL;
   }

   return obj;
}

/* create a vkr_command_pool and add it to the vkr_device */
static inline struct vkr_command_pool *
vkr_command_pool_create_and_add(
   struct vkr_context *ctx,
   struct vn_command_vkCreateCommandPool *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);

   struct vkr_command_pool *obj = vkr_command_pool_create(ctx, args);
   if (!obj)
      return NULL;

   vkr_device_add_object(ctx, dev, &obj->base);
   return obj;
}

/* destroy a driver VkCommandPool */
static inline void
vkr_command_pool_destroy_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkDestroyCommandPool *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkDestroyCommandPool_args_handle(args);
   vk->DestroyCommandPool(args->device, args->commandPool, NULL);
}

/* remove a vkr_command_pool from the device and destroy it */
static inline void
vkr_command_pool_destroy_and_remove(
   struct vkr_context *ctx,
   struct vn_command_vkDestroyCommandPool *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vkr_command_pool *obj = vkr_command_pool_from_handle(args->commandPool);
   if (!obj)
      return;

   vkr_command_pool_destroy_driver_handle(ctx, args);

   vkr_device_remove_object(ctx, dev, &obj->base);
}

/* initialize an object_array for vkr_command_buffers */
static inline VkResult
vkr_command_buffer_init_array(
   struct vkr_context *ctx,
   struct vn_command_vkAllocateCommandBuffers *args,
   struct object_array *arr)
{
   args->ret = object_array_init(ctx, arr, args->pAllocateInfo->commandBufferCount,
                                 VK_OBJECT_TYPE_COMMAND_BUFFER, sizeof(struct vkr_command_buffer),
                                 sizeof(*args->pCommandBuffers),
                                 args->pCommandBuffers)
                  ? VK_SUCCESS
                  : VK_ERROR_OUT_OF_HOST_MEMORY;
   return args->ret;
}

/* create an array of driver VkCommandBuffers from a pool and update the
 * object_array
 */
static inline
VkResult vkr_command_buffer_create_driver_handles(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkAllocateCommandBuffers *args,
   struct object_array *arr)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkAllocateCommandBuffers_args_handle(args);
   args->ret = vk->AllocateCommandBuffers(args->device, args->pAllocateInfo,
      arr->handle_storage);
   return args->ret;
}

/* create an array of vkr_command_buffers */
static inline VkResult
vkr_command_buffer_create_array(
   struct vkr_context *ctx,
   struct vn_command_vkAllocateCommandBuffers *args,
   struct object_array *arr)
{
   if (vkr_command_buffer_init_array(ctx, args, arr) != VK_SUCCESS)
      return args->ret;

   if (vkr_command_buffer_create_driver_handles(ctx, args, arr) < VK_SUCCESS) {
      /* In case the client expects a reply, clear all returned handles to
       * VK_NULL_HANDLE.
       */
      memset(args->pCommandBuffers, 0,
             args->pAllocateInfo->commandBufferCount * sizeof(args->pCommandBuffers[0]));
      object_array_fini(arr);
      return args->ret;
   }

   return args->ret;
}

/* steal vkr_command_buffers from an object_array and add them to the
 * vkr_command_pool and the context
 */
static inline
void vkr_command_buffer_add_array(
   struct vkr_context *ctx,
   struct vkr_device *dev,
   struct vkr_command_pool *pool,
   struct object_array *arr)
{
   for (uint32_t i = 0; i < arr->count; i++) {
      struct vkr_command_buffer *obj = arr->objects[i];

      obj->base.handle.command_buffer = ((VkCommandBuffer *)arr->handle_storage)[i];
      obj->device = dev;

      /* pool objects are tracked by the pool other than the device */
      list_add(&obj->base.track_head, &pool->command_buffers);

      vkr_context_add_object(ctx, &obj->base);
   }

   arr->objects_stolen = true;
   object_array_fini(arr);
}

/* destroy an array of driver VkCommandBuffers from a pool, remove them from the
 * vkr_command_pool, and return the list of affected vkr_command_buffers
 */
static inline void
vkr_command_buffer_destroy_driver_handles(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkFreeCommandBuffers *args,
   struct list_head *free_list)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   list_inithead(free_list);
   for (uint32_t i = 0; i < args->commandBufferCount; i++) {
      struct vkr_command_buffer *obj =
         vkr_command_buffer_from_handle(args->pCommandBuffers[i]);
      if (!obj)
         continue;

      list_del(&obj->base.track_head);
      list_addtail(&obj->base.track_head, free_list);
   }

   /* handles in args are replaced */
   vn_replace_vkFreeCommandBuffers_args_handle(args);
   vk->FreeCommandBuffers(args->device, args->commandPool,
      args->commandBufferCount, args->pCommandBuffers);
}

#endif /* VKR_COMMAND_BUFFER_GEN_H */
