/*
Okta Admin Management

Allows customers to easily access the Okta Management APIs

Copyright 2018 - Present Okta, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

API version: 2024.06.1
Contact: devex-public@okta.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.
package okta

import (
	"encoding/json"
)

// UserSchemaAttributeMaster struct for UserSchemaAttributeMaster
type UserSchemaAttributeMaster struct {
	Priority []UserSchemaAttributeMasterPriority `json:"priority,omitempty"`
	Type *string `json:"type,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _UserSchemaAttributeMaster UserSchemaAttributeMaster

// NewUserSchemaAttributeMaster instantiates a new UserSchemaAttributeMaster object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUserSchemaAttributeMaster() *UserSchemaAttributeMaster {
	this := UserSchemaAttributeMaster{}
	return &this
}

// NewUserSchemaAttributeMasterWithDefaults instantiates a new UserSchemaAttributeMaster object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUserSchemaAttributeMasterWithDefaults() *UserSchemaAttributeMaster {
	this := UserSchemaAttributeMaster{}
	return &this
}

// GetPriority returns the Priority field value if set, zero value otherwise.
func (o *UserSchemaAttributeMaster) GetPriority() []UserSchemaAttributeMasterPriority {
	if o == nil || o.Priority == nil {
		var ret []UserSchemaAttributeMasterPriority
		return ret
	}
	return o.Priority
}

// GetPriorityOk returns a tuple with the Priority field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UserSchemaAttributeMaster) GetPriorityOk() ([]UserSchemaAttributeMasterPriority, bool) {
	if o == nil || o.Priority == nil {
		return nil, false
	}
	return o.Priority, true
}

// HasPriority returns a boolean if a field has been set.
func (o *UserSchemaAttributeMaster) HasPriority() bool {
	if o != nil && o.Priority != nil {
		return true
	}

	return false
}

// SetPriority gets a reference to the given []UserSchemaAttributeMasterPriority and assigns it to the Priority field.
func (o *UserSchemaAttributeMaster) SetPriority(v []UserSchemaAttributeMasterPriority) {
	o.Priority = v
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *UserSchemaAttributeMaster) GetType() string {
	if o == nil || o.Type == nil {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UserSchemaAttributeMaster) GetTypeOk() (*string, bool) {
	if o == nil || o.Type == nil {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *UserSchemaAttributeMaster) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *UserSchemaAttributeMaster) SetType(v string) {
	o.Type = &v
}

func (o UserSchemaAttributeMaster) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Priority != nil {
		toSerialize["priority"] = o.Priority
	}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return json.Marshal(toSerialize)
}

func (o *UserSchemaAttributeMaster) UnmarshalJSON(bytes []byte) (err error) {
	varUserSchemaAttributeMaster := _UserSchemaAttributeMaster{}

	err = json.Unmarshal(bytes, &varUserSchemaAttributeMaster)
	if err == nil {
		*o = UserSchemaAttributeMaster(varUserSchemaAttributeMaster)
	} else {
		return err
	}

	additionalProperties := make(map[string]interface{})

	err = json.Unmarshal(bytes, &additionalProperties)
	if err == nil {
		delete(additionalProperties, "priority")
		delete(additionalProperties, "type")
		o.AdditionalProperties = additionalProperties
	} else {
		return err
	}

	return err
}

type NullableUserSchemaAttributeMaster struct {
	value *UserSchemaAttributeMaster
	isSet bool
}

func (v NullableUserSchemaAttributeMaster) Get() *UserSchemaAttributeMaster {
	return v.value
}

func (v *NullableUserSchemaAttributeMaster) Set(val *UserSchemaAttributeMaster) {
	v.value = val
	v.isSet = true
}

func (v NullableUserSchemaAttributeMaster) IsSet() bool {
	return v.isSet
}

func (v *NullableUserSchemaAttributeMaster) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUserSchemaAttributeMaster(val *UserSchemaAttributeMaster) *NullableUserSchemaAttributeMaster {
	return &NullableUserSchemaAttributeMaster{value: val, isSet: true}
}

func (v NullableUserSchemaAttributeMaster) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUserSchemaAttributeMaster) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}

