// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudIamWorkloadIdentityProvider WorkloadIdentityProvider is an identity provider that federates identity to a
// service principal.
//
// swagger:model hashicorp.cloud.iam.WorkloadIdentityProvider
type HashicorpCloudIamWorkloadIdentityProvider struct {

	// aws config
	AwsConfig *HashicorpCloudIamAWSWorkloadIdentityProviderConfig `json:"aws_config,omitempty"`

	// conditional_access is a go-bexpr string that is evaluated when exchanging
	// tokens. It restricts which upstream identities are allowed to access the
	// service principal.
	ConditionalAccess string `json:"conditional_access,omitempty"`

	// created_at is when the workload identity provider was created.
	// Format: date-time
	CreatedAt *strfmt.DateTime `json:"created_at,omitempty"`

	// description is an optional description for the workload identity provider.
	Description string `json:"description,omitempty"`

	// oidc config
	OidcConfig *HashicorpCloudIamOIDCWorkloadIdentityProviderConfig `json:"oidc_config,omitempty"`

	// resource_id is the resource identifier for this workload identity
	// provider.
	ResourceID string `json:"resource_id,omitempty"`

	// resource_name is the resource name for this workload identity
	// provider.
	ResourceName string `json:"resource_name,omitempty"`

	// system_managed indicates that the provider is not editable or deletable
	// by the user.
	SystemManaged bool `json:"system_managed,omitempty"`

	// updated_at is when the workload identity provider was last updated.
	// Format: date-time
	UpdatedAt *strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud iam workload identity provider
func (m *HashicorpCloudIamWorkloadIdentityProvider) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAwsConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOidcConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamWorkloadIdentityProvider) validateAwsConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.AwsConfig) { // not required
		return nil
	}

	if m.AwsConfig != nil {
		if err := m.AwsConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aws_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aws_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamWorkloadIdentityProvider) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudIamWorkloadIdentityProvider) validateOidcConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.OidcConfig) { // not required
		return nil
	}

	if m.OidcConfig != nil {
		if err := m.OidcConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oidc_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("oidc_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamWorkloadIdentityProvider) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam workload identity provider based on the context it is used
func (m *HashicorpCloudIamWorkloadIdentityProvider) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAwsConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOidcConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamWorkloadIdentityProvider) contextValidateAwsConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.AwsConfig != nil {

		if swag.IsZero(m.AwsConfig) { // not required
			return nil
		}

		if err := m.AwsConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aws_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aws_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamWorkloadIdentityProvider) contextValidateOidcConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.OidcConfig != nil {

		if swag.IsZero(m.OidcConfig) { // not required
			return nil
		}

		if err := m.OidcConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oidc_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("oidc_config")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamWorkloadIdentityProvider) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamWorkloadIdentityProvider) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamWorkloadIdentityProvider
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
