// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudIamGetServicePrincipalResponse GetServicePrincipalResponse is the response message for fetching a service principal.
//
// swagger:model hashicorp.cloud.iam.GetServicePrincipalResponse
type HashicorpCloudIamGetServicePrincipalResponse struct {

	// keys is the list of the service principal keys that belong to the
	// retrieved service principal.
	Keys []*HashicorpCloudIamServicePrincipalKey `json:"keys"`

	// service_principal is the retrieved service principal.
	ServicePrincipal *HashicorpCloudIamServicePrincipal `json:"service_principal,omitempty"`
}

// Validate validates this hashicorp cloud iam get service principal response
func (m *HashicorpCloudIamGetServicePrincipalResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeys(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServicePrincipal(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamGetServicePrincipalResponse) validateKeys(formats strfmt.Registry) error {
	if swag.IsZero(m.Keys) { // not required
		return nil
	}

	for i := 0; i < len(m.Keys); i++ {
		if swag.IsZero(m.Keys[i]) { // not required
			continue
		}

		if m.Keys[i] != nil {
			if err := m.Keys[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("keys" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("keys" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudIamGetServicePrincipalResponse) validateServicePrincipal(formats strfmt.Registry) error {
	if swag.IsZero(m.ServicePrincipal) { // not required
		return nil
	}

	if m.ServicePrincipal != nil {
		if err := m.ServicePrincipal.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_principal")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("service_principal")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam get service principal response based on the context it is used
func (m *HashicorpCloudIamGetServicePrincipalResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateKeys(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServicePrincipal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamGetServicePrincipalResponse) contextValidateKeys(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Keys); i++ {

		if m.Keys[i] != nil {

			if swag.IsZero(m.Keys[i]) { // not required
				return nil
			}

			if err := m.Keys[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("keys" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("keys" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudIamGetServicePrincipalResponse) contextValidateServicePrincipal(ctx context.Context, formats strfmt.Registry) error {

	if m.ServicePrincipal != nil {

		if swag.IsZero(m.ServicePrincipal) { // not required
			return nil
		}

		if err := m.ServicePrincipal.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_principal")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("service_principal")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamGetServicePrincipalResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamGetServicePrincipalResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamGetServicePrincipalResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
