//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import "time"

// ApprovalSettings - The approval settings.
type ApprovalSettings struct {
	// The type of rule
	ApprovalMode *ApprovalMode

	// The approval stages of the request.
	ApprovalStages []*ApprovalStage

	// Determines whether approval is required or not.
	IsApprovalRequired *bool

	// Determines whether approval is required for assignment extension.
	IsApprovalRequiredForExtension *bool

	// Determine whether requestor justification is required.
	IsRequestorJustificationRequired *bool
}

// ApprovalStage - The approval stage.
type ApprovalStage struct {
	// The time in days when approval request would be timed out
	ApprovalStageTimeOutInDays *int32

	// The escalation approver of the request.
	EscalationApprovers []*UserSet

	// The time in minutes when the approval request would be escalated if the primary approver does not approve
	EscalationTimeInMinutes *int32

	// Determines whether approver need to provide justification for his decision.
	IsApproverJustificationRequired *bool

	// The value determine whether escalation feature is enabled.
	IsEscalationEnabled *bool

	// The primary approver of the request.
	PrimaryApprovers []*UserSet
}

// ClassicAdministrator - Classic Administrators
type ClassicAdministrator struct {
	// The ID of the administrator.
	ID *string

	// The name of the administrator.
	Name *string

	// Properties for the classic administrator.
	Properties *ClassicAdministratorProperties

	// The type of the administrator.
	Type *string
}

// ClassicAdministratorListResult - ClassicAdministrator list result information.
type ClassicAdministratorListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// An array of administrators.
	Value []*ClassicAdministrator
}

// ClassicAdministratorProperties - Classic Administrator properties.
type ClassicAdministratorProperties struct {
	// The email address of the administrator.
	EmailAddress *string

	// The role of the administrator.
	Role *string
}

// DenyAssignment - Deny Assignment
type DenyAssignment struct {
	// Deny assignment properties.
	Properties *DenyAssignmentProperties

	// READ-ONLY; The deny assignment ID.
	ID *string

	// READ-ONLY; The deny assignment name.
	Name *string

	// READ-ONLY; The deny assignment type.
	Type *string
}

// DenyAssignmentFilter - Deny Assignments filter
type DenyAssignmentFilter struct {
	// Return deny assignment with specified name.
	DenyAssignmentName *string

	// Return all deny assignments where the specified principal is listed either in the principals list or exclude principals
	// list of deny assignments.
	GdprExportPrincipalID *string

	// Return all deny assignments where the specified principal is listed in the principals list of deny assignments.
	PrincipalID *string
}

// DenyAssignmentListResult - Deny assignment list operation result.
type DenyAssignmentListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Deny assignment list.
	Value []*DenyAssignment
}

// DenyAssignmentPermission - Deny assignment permissions.
type DenyAssignmentPermission struct {
	// Actions to which the deny assignment does not grant access.
	Actions []*string

	// The conditions on the Deny assignment permission. This limits the resources it applies to.
	Condition *string

	// Version of the condition.
	ConditionVersion *string

	// Data actions to which the deny assignment does not grant access.
	DataActions []*string

	// Actions to exclude from that the deny assignment does not grant access.
	NotActions []*string

	// Data actions to exclude from that the deny assignment does not grant access.
	NotDataActions []*string
}

// DenyAssignmentProperties - Deny assignment properties.
type DenyAssignmentProperties struct {
	// The display name of the deny assignment.
	DenyAssignmentName *string

	// The description of the deny assignment.
	Description *string

	// Determines if the deny assignment applies to child scopes. Default value is false.
	DoNotApplyToChildScopes *bool

	// Array of principals to which the deny assignment does not apply.
	ExcludePrincipals []*Principal

	// Specifies whether this deny assignment was created by Azure and cannot be edited or deleted.
	IsSystemProtected *bool

	// An array of permissions that are denied by the deny assignment.
	Permissions []*DenyAssignmentPermission

	// Array of principals to which the deny assignment applies.
	Principals []*Principal

	// The deny assignment scope.
	Scope *string
}

// EligibleChildResource - Eligible child resource
type EligibleChildResource struct {
	// READ-ONLY; The resource scope Id.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// EligibleChildResourcesListResult - Eligible child resources list operation result.
type EligibleChildResourcesListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Eligible child resource list.
	Value []*EligibleChildResource
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

type ExpandedProperties struct {
	// Details of the principal
	Principal *ExpandedPropertiesPrincipal

	// Details of role definition
	RoleDefinition *ExpandedPropertiesRoleDefinition

	// Details of the resource scope
	Scope *ExpandedPropertiesScope
}

// ExpandedPropertiesPrincipal - Details of the principal
type ExpandedPropertiesPrincipal struct {
	// Display name of the principal
	DisplayName *string

	// Email id of the principal
	Email *string

	// Id of the principal
	ID *string

	// Type of the principal
	Type *string
}

// ExpandedPropertiesRoleDefinition - Details of role definition
type ExpandedPropertiesRoleDefinition struct {
	// Display name of the role definition
	DisplayName *string

	// Id of the role definition
	ID *string

	// Type of the role definition
	Type *string
}

// ExpandedPropertiesScope - Details of the resource scope
type ExpandedPropertiesScope struct {
	// Display name of the resource
	DisplayName *string

	// Scope id of the resource
	ID *string

	// Type of the resource
	Type *string
}

// Permission - Role definition permissions.
type Permission struct {
	// Allowed actions.
	Actions []*string

	// Allowed Data actions.
	DataActions []*string

	// Denied actions.
	NotActions []*string

	// Denied Data actions.
	NotDataActions []*string
}

// PermissionGetResult - Permissions information.
type PermissionGetResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// An array of permissions.
	Value []*Permission
}

// PolicyAssignmentProperties - Expanded info of resource scope, role definition and policy
type PolicyAssignmentProperties struct {
	// Details of the policy
	Policy *PolicyAssignmentPropertiesPolicy

	// Details of role definition
	RoleDefinition *PolicyAssignmentPropertiesRoleDefinition

	// Details of the resource scope
	Scope *PolicyAssignmentPropertiesScope
}

// PolicyAssignmentPropertiesPolicy - Details of the policy
type PolicyAssignmentPropertiesPolicy struct {
	// Id of the policy
	ID *string

	// The last modified date time.
	LastModifiedDateTime *time.Time

	// READ-ONLY; The name of the entity last modified it
	LastModifiedBy *Principal
}

// PolicyAssignmentPropertiesRoleDefinition - Details of role definition
type PolicyAssignmentPropertiesRoleDefinition struct {
	// Display name of the role definition
	DisplayName *string

	// Id of the role definition
	ID *string

	// Type of the role definition
	Type *string
}

// PolicyAssignmentPropertiesScope - Details of the resource scope
type PolicyAssignmentPropertiesScope struct {
	// Display name of the resource
	DisplayName *string

	// Scope id of the resource
	ID *string

	// Type of the resource
	Type *string
}

// PolicyProperties - Expanded info of resource scope
type PolicyProperties struct {
	// READ-ONLY; Details of the resource scope
	Scope *PolicyPropertiesScope
}

// PolicyPropertiesScope - Details of the resource scope
type PolicyPropertiesScope struct {
	// Display name of the resource
	DisplayName *string

	// Scope id of the resource
	ID *string

	// Type of the resource
	Type *string
}

// Principal - The name of the entity last modified it
type Principal struct {
	// The name of the principal made changes
	DisplayName *string

	// Email of principal
	Email *string

	// The id of the principal made changes
	ID *string

	// Type of principal such as user , group etc
	Type *string
}

// ProviderOperation - Operation
type ProviderOperation struct {
	// The operation description.
	Description *string

	// The operation display name.
	DisplayName *string

	// The dataAction flag to specify the operation type.
	IsDataAction *bool

	// The operation name.
	Name *string

	// The operation origin.
	Origin *string

	// The operation properties.
	Properties any
}

// ProviderOperationsMetadata - Provider Operations metadata
type ProviderOperationsMetadata struct {
	// The provider display name.
	DisplayName *string

	// The provider id.
	ID *string

	// The provider name.
	Name *string

	// The provider operations.
	Operations []*ProviderOperation

	// The provider resource types
	ResourceTypes []*ResourceType

	// The provider type.
	Type *string
}

// ProviderOperationsMetadataListResult - Provider operations metadata list
type ProviderOperationsMetadataListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The list of providers.
	Value []*ProviderOperationsMetadata
}

// ResourceType - Resource Type
type ResourceType struct {
	// The resource type display name.
	DisplayName *string

	// The resource type name.
	Name *string

	// The resource type operations.
	Operations []*ProviderOperation
}

// RoleAssignment - Role Assignments
type RoleAssignment struct {
	// Role assignment properties.
	Properties *RoleAssignmentProperties

	// READ-ONLY; The role assignment ID.
	ID *string

	// READ-ONLY; The role assignment name.
	Name *string

	// READ-ONLY; The role assignment type.
	Type *string
}

// RoleAssignmentCreateParameters - Role assignment create parameters.
type RoleAssignmentCreateParameters struct {
	// REQUIRED; Role assignment properties.
	Properties *RoleAssignmentProperties
}

// RoleAssignmentFilter - Role Assignments filter
type RoleAssignmentFilter struct {
	// Returns role assignment of the specific principal.
	PrincipalID *string
}

// RoleAssignmentListResult - Role assignment list operation result.
type RoleAssignmentListResult struct {
	// Role assignment list.
	Value []*RoleAssignment

	// READ-ONLY; The skipToken to use for getting the next set of results.
	NextLink *string
}

// RoleAssignmentProperties - Role assignment properties.
type RoleAssignmentProperties struct {
	// REQUIRED; The principal ID.
	PrincipalID *string

	// REQUIRED; The role definition ID.
	RoleDefinitionID *string

	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently the only accepted value is '2.0'
	ConditionVersion *string

	// Id of the delegated managed identity resource
	DelegatedManagedIdentityResourceID *string

	// Description of role assignment
	Description *string

	// The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// READ-ONLY; Id of the user who created the assignment
	CreatedBy *string

	// READ-ONLY; Time it was created
	CreatedOn *time.Time

	// READ-ONLY; The role assignment scope.
	Scope *string

	// READ-ONLY; Id of the user who updated the assignment
	UpdatedBy *string

	// READ-ONLY; Time it was updated
	UpdatedOn *time.Time
}

// RoleAssignmentSchedule - Role Assignment schedule
type RoleAssignmentSchedule struct {
	// Role assignment schedule properties.
	Properties *RoleAssignmentScheduleProperties

	// READ-ONLY; The role assignment schedule Id.
	ID *string

	// READ-ONLY; The role assignment schedule name.
	Name *string

	// READ-ONLY; The role assignment schedule type.
	Type *string
}

// RoleAssignmentScheduleFilter - Role assignment schedule filter
type RoleAssignmentScheduleFilter struct {
	// Returns role assignment schedule of the specific principal.
	PrincipalID *string

	// Returns role assignment schedule of the specific role definition.
	RoleDefinitionID *string

	// Returns role assignment schedule instances of the specific status.
	Status *string
}

// RoleAssignmentScheduleInstance - Information about current or upcoming role assignment schedule instance
type RoleAssignmentScheduleInstance struct {
	// Role assignment schedule instance properties.
	Properties *RoleAssignmentScheduleInstanceProperties

	// READ-ONLY; The role assignment schedule instance ID.
	ID *string

	// READ-ONLY; The role assignment schedule instance name.
	Name *string

	// READ-ONLY; The role assignment schedule instance type.
	Type *string
}

// RoleAssignmentScheduleInstanceFilter - Role assignment schedule instance filter
type RoleAssignmentScheduleInstanceFilter struct {
	// Returns role assignment schedule instances of the specific principal.
	PrincipalID *string

	// Returns role assignment schedule instances belonging to a specific role assignment schedule.
	RoleAssignmentScheduleID *string

	// Returns role assignment schedule instances of the specific role definition.
	RoleDefinitionID *string

	// Returns role assignment schedule instances of the specific status.
	Status *string
}

// RoleAssignmentScheduleInstanceListResult - Role assignment schedule instance list operation result.
type RoleAssignmentScheduleInstanceListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role assignment schedule instance list.
	Value []*RoleAssignmentScheduleInstance
}

// RoleAssignmentScheduleInstanceProperties - Role assignment schedule properties with scope.
type RoleAssignmentScheduleInstanceProperties struct {
	// Assignment type of the role assignment schedule
	AssignmentType *AssignmentType

	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string

	// DateTime when role assignment schedule was created
	CreatedOn *time.Time

	// The endDateTime of the role assignment schedule instance
	EndDateTime *time.Time

	// Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties

	// roleEligibilityScheduleId used to activate
	LinkedRoleEligibilityScheduleID *string

	// roleEligibilityScheduleInstanceId linked to this roleAssignmentScheduleInstance
	LinkedRoleEligibilityScheduleInstanceID *string

	// Membership type of the role assignment schedule
	MemberType *MemberType

	// Role Assignment Id in external system
	OriginRoleAssignmentID *string

	// The principal ID.
	PrincipalID *string

	// The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// Id of the master role assignment schedule
	RoleAssignmentScheduleID *string

	// The role definition ID.
	RoleDefinitionID *string

	// The role assignment schedule scope.
	Scope *string

	// The startDateTime of the role assignment schedule instance
	StartDateTime *time.Time

	// The status of the role assignment schedule instance.
	Status *Status
}

// RoleAssignmentScheduleListResult - Role assignment schedule list operation result.
type RoleAssignmentScheduleListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role assignment schedule list.
	Value []*RoleAssignmentSchedule
}

// RoleAssignmentScheduleProperties - Role assignment schedule properties with scope.
type RoleAssignmentScheduleProperties struct {
	// Assignment type of the role assignment schedule
	AssignmentType *AssignmentType

	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string

	// DateTime when role assignment schedule was created
	CreatedOn *time.Time

	// End DateTime when role assignment schedule
	EndDateTime *time.Time

	// Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties

	// The id of roleEligibilitySchedule used to activated this roleAssignmentSchedule
	LinkedRoleEligibilityScheduleID *string

	// Membership type of the role assignment schedule
	MemberType *MemberType

	// The principal ID.
	PrincipalID *string

	// The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// The id of roleAssignmentScheduleRequest used to create this roleAssignmentSchedule
	RoleAssignmentScheduleRequestID *string

	// The role definition ID.
	RoleDefinitionID *string

	// The role assignment schedule scope.
	Scope *string

	// Start DateTime when role assignment schedule
	StartDateTime *time.Time

	// The status of the role assignment schedule.
	Status *Status

	// DateTime when role assignment schedule was modified
	UpdatedOn *time.Time
}

// RoleAssignmentScheduleRequest - Role Assignment schedule request
type RoleAssignmentScheduleRequest struct {
	// Role assignment schedule request properties.
	Properties *RoleAssignmentScheduleRequestProperties

	// READ-ONLY; The role assignment schedule request ID.
	ID *string

	// READ-ONLY; The role assignment schedule request name.
	Name *string

	// READ-ONLY; The role assignment schedule request type.
	Type *string
}

// RoleAssignmentScheduleRequestFilter - Role assignment schedule request filter
type RoleAssignmentScheduleRequestFilter struct {
	// Returns role assignment requests of the specific principal.
	PrincipalID *string

	// Returns role assignment requests created by specific principal.
	RequestorID *string

	// Returns role assignment requests of the specific role definition.
	RoleDefinitionID *string

	// Returns role assignment requests of specific status.
	Status *string
}

// RoleAssignmentScheduleRequestListResult - Role assignment schedule request list operation result.
type RoleAssignmentScheduleRequestListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role assignment schedule request list.
	Value []*RoleAssignmentScheduleRequest
}

// RoleAssignmentScheduleRequestProperties - Role assignment schedule request properties with scope.
type RoleAssignmentScheduleRequestProperties struct {
	// REQUIRED; The principal ID.
	PrincipalID *string

	// REQUIRED; The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc
	RequestType *RequestType

	// REQUIRED; The role definition ID.
	RoleDefinitionID *string

	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string

	// Justification for the role assignment
	Justification *string

	// The linked role eligibility schedule id - to activate an eligibility.
	LinkedRoleEligibilityScheduleID *string

	// Schedule info of the role assignment schedule
	ScheduleInfo *RoleAssignmentScheduleRequestPropertiesScheduleInfo

	// The resultant role assignment schedule id or the role assignment schedule id being updated
	TargetRoleAssignmentScheduleID *string

	// The role assignment schedule instance id being updated
	TargetRoleAssignmentScheduleInstanceID *string

	// Ticket Info of the role assignment
	TicketInfo *RoleAssignmentScheduleRequestPropertiesTicketInfo

	// READ-ONLY; The approvalId of the role assignment schedule request.
	ApprovalID *string

	// READ-ONLY; DateTime when role assignment schedule request was created
	CreatedOn *time.Time

	// READ-ONLY; Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties

	// READ-ONLY; The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// READ-ONLY; Id of the user who created this request
	RequestorID *string

	// READ-ONLY; The role assignment schedule request scope.
	Scope *string

	// READ-ONLY; The status of the role assignment schedule request.
	Status *Status
}

// RoleAssignmentScheduleRequestPropertiesScheduleInfo - Schedule info of the role assignment schedule
type RoleAssignmentScheduleRequestPropertiesScheduleInfo struct {
	// Expiration of the role assignment schedule
	Expiration *RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration

	// Start DateTime of the role assignment schedule.
	StartDateTime *time.Time
}

// RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration - Expiration of the role assignment schedule
type RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration struct {
	// Duration of the role assignment schedule in TimeSpan.
	Duration *string

	// End DateTime of the role assignment schedule.
	EndDateTime *time.Time

	// Type of the role assignment schedule expiration
	Type *Type
}

// RoleAssignmentScheduleRequestPropertiesTicketInfo - Ticket Info of the role assignment
type RoleAssignmentScheduleRequestPropertiesTicketInfo struct {
	// Ticket number for the role assignment
	TicketNumber *string

	// Ticket system name for the role assignment
	TicketSystem *string
}

// RoleDefinition - Role definition.
type RoleDefinition struct {
	// Role definition properties.
	Properties *RoleDefinitionProperties

	// READ-ONLY; The role definition ID.
	ID *string

	// READ-ONLY; The role definition name.
	Name *string

	// READ-ONLY; The role definition type.
	Type *string
}

// RoleDefinitionFilter - Role Definitions filter
type RoleDefinitionFilter struct {
	// Returns role definition with the specific name.
	RoleName *string

	// Returns role definition with the specific type.
	Type *string
}

// RoleDefinitionListResult - Role definition list operation result.
type RoleDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role definition list.
	Value []*RoleDefinition
}

// RoleDefinitionProperties - Role definition properties.
type RoleDefinitionProperties struct {
	// Role definition assignable scopes.
	AssignableScopes []*string

	// The role definition description.
	Description *string

	// Role definition permissions.
	Permissions []*Permission

	// The role name.
	RoleName *string

	// The role type.
	RoleType *string
}

// RoleEligibilitySchedule - Role eligibility schedule
type RoleEligibilitySchedule struct {
	// role eligibility schedule properties.
	Properties *RoleEligibilityScheduleProperties

	// READ-ONLY; The role eligibility schedule Id.
	ID *string

	// READ-ONLY; The role eligibility schedule name.
	Name *string

	// READ-ONLY; The role eligibility schedule type.
	Type *string
}

// RoleEligibilityScheduleFilter - Role eligibility schedule filter
type RoleEligibilityScheduleFilter struct {
	// Returns role eligibility schedule of the specific principal.
	PrincipalID *string

	// Returns role eligibility schedule of the specific role definition.
	RoleDefinitionID *string

	// Returns role eligibility schedule of the specific status.
	Status *string
}

// RoleEligibilityScheduleInstance - Information about current or upcoming role eligibility schedule instance
type RoleEligibilityScheduleInstance struct {
	// Role eligibility schedule instance properties.
	Properties *RoleEligibilityScheduleInstanceProperties

	// READ-ONLY; The role eligibility schedule instance ID.
	ID *string

	// READ-ONLY; The role eligibility schedule instance name.
	Name *string

	// READ-ONLY; The role eligibility schedule instance type.
	Type *string
}

// RoleEligibilityScheduleInstanceFilter - Role eligibility schedule instance filter
type RoleEligibilityScheduleInstanceFilter struct {
	// Returns role eligibility schedule instances of the specific principal.
	PrincipalID *string

	// Returns role eligibility schedule instances of the specific role definition.
	RoleDefinitionID *string

	// Returns role eligibility schedule instances belonging to a specific role eligibility schedule.
	RoleEligibilityScheduleID *string

	// Returns role eligibility schedule instances of the specific status.
	Status *string
}

// RoleEligibilityScheduleInstanceListResult - Role eligibility schedule instance list operation result.
type RoleEligibilityScheduleInstanceListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role eligibility schedule instance list.
	Value []*RoleEligibilityScheduleInstance
}

// RoleEligibilityScheduleInstanceProperties - Role eligibility schedule properties with scope.
type RoleEligibilityScheduleInstanceProperties struct {
	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string

	// DateTime when role eligibility schedule was created
	CreatedOn *time.Time

	// The endDateTime of the role eligibility schedule instance
	EndDateTime *time.Time

	// Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties

	// Membership type of the role eligibility schedule
	MemberType *MemberType

	// The principal ID.
	PrincipalID *string

	// The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// The role definition ID.
	RoleDefinitionID *string

	// Id of the master role eligibility schedule
	RoleEligibilityScheduleID *string

	// The role eligibility schedule scope.
	Scope *string

	// The startDateTime of the role eligibility schedule instance
	StartDateTime *time.Time

	// The status of the role eligibility schedule instance
	Status *Status
}

// RoleEligibilityScheduleListResult - role eligibility schedule list operation result.
type RoleEligibilityScheduleListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// role eligibility schedule list.
	Value []*RoleEligibilitySchedule
}

// RoleEligibilityScheduleProperties - Role eligibility schedule properties with scope.
type RoleEligibilityScheduleProperties struct {
	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string

	// DateTime when role eligibility schedule was created
	CreatedOn *time.Time

	// End DateTime when role eligibility schedule
	EndDateTime *time.Time

	// Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties

	// Membership type of the role eligibility schedule
	MemberType *MemberType

	// The principal ID.
	PrincipalID *string

	// The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// The role definition ID.
	RoleDefinitionID *string

	// The id of roleEligibilityScheduleRequest used to create this roleAssignmentSchedule
	RoleEligibilityScheduleRequestID *string

	// The role eligibility schedule scope.
	Scope *string

	// Start DateTime when role eligibility schedule
	StartDateTime *time.Time

	// The status of the role eligibility schedule.
	Status *Status

	// DateTime when role eligibility schedule was modified
	UpdatedOn *time.Time
}

// RoleEligibilityScheduleRequest - Role Eligibility schedule request
type RoleEligibilityScheduleRequest struct {
	// Role eligibility schedule request properties.
	Properties *RoleEligibilityScheduleRequestProperties

	// READ-ONLY; The role eligibility schedule request ID.
	ID *string

	// READ-ONLY; The role eligibility schedule request name.
	Name *string

	// READ-ONLY; The role eligibility schedule request type.
	Type *string
}

// RoleEligibilityScheduleRequestFilter - Role eligibility schedule request filter
type RoleEligibilityScheduleRequestFilter struct {
	// Returns role eligibility requests of the specific principal.
	PrincipalID *string

	// Returns role eligibility requests created by specific principal.
	RequestorID *string

	// Returns role eligibility requests of the specific role definition.
	RoleDefinitionID *string

	// Returns role eligibility requests of specific status.
	Status *string
}

// RoleEligibilityScheduleRequestListResult - Role eligibility schedule request list operation result.
type RoleEligibilityScheduleRequestListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role eligibility schedule request list.
	Value []*RoleEligibilityScheduleRequest
}

// RoleEligibilityScheduleRequestProperties - Role eligibility schedule request properties with scope.
type RoleEligibilityScheduleRequestProperties struct {
	// REQUIRED; The principal ID.
	PrincipalID *string

	// REQUIRED; The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc
	RequestType *RequestType

	// REQUIRED; The role definition ID.
	RoleDefinitionID *string

	// The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
	// StringEqualsIgnoreCase
	// 'foostoragecontainer'
	Condition *string

	// Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string

	// Justification for the role eligibility
	Justification *string

	// Schedule info of the role eligibility schedule
	ScheduleInfo *RoleEligibilityScheduleRequestPropertiesScheduleInfo

	// The resultant role eligibility schedule id or the role eligibility schedule id being updated
	TargetRoleEligibilityScheduleID *string

	// The role eligibility schedule instance id being updated
	TargetRoleEligibilityScheduleInstanceID *string

	// Ticket Info of the role eligibility
	TicketInfo *RoleEligibilityScheduleRequestPropertiesTicketInfo

	// READ-ONLY; The approvalId of the role eligibility schedule request.
	ApprovalID *string

	// READ-ONLY; DateTime when role eligibility schedule request was created
	CreatedOn *time.Time

	// READ-ONLY; Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties

	// READ-ONLY; The principal type of the assigned principal ID.
	PrincipalType *PrincipalType

	// READ-ONLY; Id of the user who created this request
	RequestorID *string

	// READ-ONLY; The role eligibility schedule request scope.
	Scope *string

	// READ-ONLY; The status of the role eligibility schedule request.
	Status *Status
}

// RoleEligibilityScheduleRequestPropertiesScheduleInfo - Schedule info of the role eligibility schedule
type RoleEligibilityScheduleRequestPropertiesScheduleInfo struct {
	// Expiration of the role eligibility schedule
	Expiration *RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration

	// Start DateTime of the role eligibility schedule.
	StartDateTime *time.Time
}

// RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration - Expiration of the role eligibility schedule
type RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration struct {
	// Duration of the role eligibility schedule in TimeSpan.
	Duration *string

	// End DateTime of the role eligibility schedule.
	EndDateTime *time.Time

	// Type of the role eligibility schedule expiration
	Type *Type
}

// RoleEligibilityScheduleRequestPropertiesTicketInfo - Ticket Info of the role eligibility
type RoleEligibilityScheduleRequestPropertiesTicketInfo struct {
	// Ticket number for the role eligibility
	TicketNumber *string

	// Ticket system name for the role eligibility
	TicketSystem *string
}

// RoleManagementPolicy - Role management policy
type RoleManagementPolicy struct {
	// Role management policy properties.
	Properties *RoleManagementPolicyProperties

	// READ-ONLY; The role management policy Id.
	ID *string

	// READ-ONLY; The role management policy name.
	Name *string

	// READ-ONLY; The role management policy type.
	Type *string
}

// RoleManagementPolicyApprovalRule - The role management policy approval rule.
type RoleManagementPolicyApprovalRule struct {
	// REQUIRED; The type of rule
	RuleType *RoleManagementPolicyRuleType

	// The id of the rule.
	ID *string

	// The approval setting
	Setting *ApprovalSettings

	// The target of the current rule.
	Target *RoleManagementPolicyRuleTarget
}

// GetRoleManagementPolicyRule implements the RoleManagementPolicyRuleClassification interface for type RoleManagementPolicyApprovalRule.
func (r *RoleManagementPolicyApprovalRule) GetRoleManagementPolicyRule() *RoleManagementPolicyRule {
	return &RoleManagementPolicyRule{
		ID:       r.ID,
		RuleType: r.RuleType,
		Target:   r.Target,
	}
}

// RoleManagementPolicyAssignment - Role management policy
type RoleManagementPolicyAssignment struct {
	// Role management policy properties.
	Properties *RoleManagementPolicyAssignmentProperties

	// READ-ONLY; The role management policy Id.
	ID *string

	// READ-ONLY; The role management policy name.
	Name *string

	// READ-ONLY; The role management policy type.
	Type *string
}

// RoleManagementPolicyAssignmentListResult - Role management policy assignment list operation result.
type RoleManagementPolicyAssignmentListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role management policy assignment list.
	Value []*RoleManagementPolicyAssignment
}

// RoleManagementPolicyAssignmentProperties - Role management policy assignment properties with scope.
type RoleManagementPolicyAssignmentProperties struct {
	// The policy id role management policy assignment.
	PolicyID *string

	// The role definition of management policy assignment.
	RoleDefinitionID *string

	// The role management policy scope.
	Scope *string

	// READ-ONLY; The readonly computed rule applied to the policy.
	EffectiveRules []RoleManagementPolicyRuleClassification

	// READ-ONLY; Additional properties of scope, role definition and policy
	PolicyAssignmentProperties *PolicyAssignmentProperties
}

// RoleManagementPolicyAuthenticationContextRule - The role management policy authentication context rule.
type RoleManagementPolicyAuthenticationContextRule struct {
	// REQUIRED; The type of rule
	RuleType *RoleManagementPolicyRuleType

	// The claim value.
	ClaimValue *string

	// The id of the rule.
	ID *string

	// The value indicating if rule is enabled.
	IsEnabled *bool

	// The target of the current rule.
	Target *RoleManagementPolicyRuleTarget
}

// GetRoleManagementPolicyRule implements the RoleManagementPolicyRuleClassification interface for type RoleManagementPolicyAuthenticationContextRule.
func (r *RoleManagementPolicyAuthenticationContextRule) GetRoleManagementPolicyRule() *RoleManagementPolicyRule {
	return &RoleManagementPolicyRule{
		ID:       r.ID,
		RuleType: r.RuleType,
		Target:   r.Target,
	}
}

// RoleManagementPolicyEnablementRule - The role management policy enablement rule.
type RoleManagementPolicyEnablementRule struct {
	// REQUIRED; The type of rule
	RuleType *RoleManagementPolicyRuleType

	// The list of enabled rules.
	EnabledRules []*EnablementRules

	// The id of the rule.
	ID *string

	// The target of the current rule.
	Target *RoleManagementPolicyRuleTarget
}

// GetRoleManagementPolicyRule implements the RoleManagementPolicyRuleClassification interface for type RoleManagementPolicyEnablementRule.
func (r *RoleManagementPolicyEnablementRule) GetRoleManagementPolicyRule() *RoleManagementPolicyRule {
	return &RoleManagementPolicyRule{
		ID:       r.ID,
		RuleType: r.RuleType,
		Target:   r.Target,
	}
}

// RoleManagementPolicyExpirationRule - The role management policy expiration rule.
type RoleManagementPolicyExpirationRule struct {
	// REQUIRED; The type of rule
	RuleType *RoleManagementPolicyRuleType

	// The id of the rule.
	ID *string

	// The value indicating whether expiration is required.
	IsExpirationRequired *bool

	// The maximum duration of expiration in timespan.
	MaximumDuration *string

	// The target of the current rule.
	Target *RoleManagementPolicyRuleTarget
}

// GetRoleManagementPolicyRule implements the RoleManagementPolicyRuleClassification interface for type RoleManagementPolicyExpirationRule.
func (r *RoleManagementPolicyExpirationRule) GetRoleManagementPolicyRule() *RoleManagementPolicyRule {
	return &RoleManagementPolicyRule{
		ID:       r.ID,
		RuleType: r.RuleType,
		Target:   r.Target,
	}
}

// RoleManagementPolicyListResult - Role management policy list operation result.
type RoleManagementPolicyListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// Role management policy list.
	Value []*RoleManagementPolicy
}

// RoleManagementPolicyNotificationRule - The role management policy notification rule.
type RoleManagementPolicyNotificationRule struct {
	// REQUIRED; The type of rule
	RuleType *RoleManagementPolicyRuleType

	// The id of the rule.
	ID *string

	// Determines if the notification will be sent to the recipient type specified in the policy rule.
	IsDefaultRecipientsEnabled *bool

	// The notification level.
	NotificationLevel *NotificationLevel

	// The list of notification recipients.
	NotificationRecipients []*string

	// The type of notification.
	NotificationType *NotificationDeliveryMechanism

	// The recipient type.
	RecipientType *RecipientType

	// The target of the current rule.
	Target *RoleManagementPolicyRuleTarget
}

// GetRoleManagementPolicyRule implements the RoleManagementPolicyRuleClassification interface for type RoleManagementPolicyNotificationRule.
func (r *RoleManagementPolicyNotificationRule) GetRoleManagementPolicyRule() *RoleManagementPolicyRule {
	return &RoleManagementPolicyRule{
		ID:       r.ID,
		RuleType: r.RuleType,
		Target:   r.Target,
	}
}

// RoleManagementPolicyProperties - Role management policy properties with scope.
type RoleManagementPolicyProperties struct {
	// The role management policy description.
	Description *string

	// The role management policy display name.
	DisplayName *string

	// The role management policy is default policy.
	IsOrganizationDefault *bool

	// The rule applied to the policy.
	Rules []RoleManagementPolicyRuleClassification

	// The role management policy scope.
	Scope *string

	// READ-ONLY; The readonly computed rule applied to the policy.
	EffectiveRules []RoleManagementPolicyRuleClassification

	// READ-ONLY; The name of the entity last modified it
	LastModifiedBy *Principal

	// READ-ONLY; The last modified date time.
	LastModifiedDateTime *time.Time

	// READ-ONLY; Additional properties of scope
	PolicyProperties *PolicyProperties
}

// RoleManagementPolicyRule - The role management policy rule.
type RoleManagementPolicyRule struct {
	// REQUIRED; The type of rule
	RuleType *RoleManagementPolicyRuleType

	// The id of the rule.
	ID *string

	// The target of the current rule.
	Target *RoleManagementPolicyRuleTarget
}

// GetRoleManagementPolicyRule implements the RoleManagementPolicyRuleClassification interface for type RoleManagementPolicyRule.
func (r *RoleManagementPolicyRule) GetRoleManagementPolicyRule() *RoleManagementPolicyRule { return r }

// RoleManagementPolicyRuleTarget - The role management policy rule target.
type RoleManagementPolicyRuleTarget struct {
	// The caller of the setting.
	Caller *string

	// The list of enforced settings.
	EnforcedSettings []*string

	// The list of inheritable settings.
	InheritableSettings []*string

	// The assignment level to which rule is applied.
	Level *string

	// The type of operation.
	Operations []*string

	// The list of target objects.
	TargetObjects []*string
}

// UserSet - The detail of a user.
type UserSet struct {
	// The description of the user.
	Description *string

	// The object id of the user.
	ID *string

	// The value indicating whether the user is a backup fallback approver
	IsBackup *bool

	// The type of user.
	UserType *UserType
}

// ValidationResponse - Validation response
type ValidationResponse struct {
	// Failed validation result details
	ErrorInfo *ValidationResponseErrorInfo

	// READ-ONLY; Whether or not validation succeeded
	IsValid *bool
}

// ValidationResponseErrorInfo - Failed validation result details
type ValidationResponseErrorInfo struct {
	// READ-ONLY; Error code indicating why validation failed
	Code *string

	// READ-ONLY; Message indicating why validation failed
	Message *string
}
