/* valadoc.c generated by valac, the Vala compiler
 * generated from valadoc.vala, do not modify */

/* valadoc.vala
 *
 * Copyright (C) 2008-2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vala.h>
#include <valadoc.h>
#include <glib/gstdio.h>
#include <valacodegen.h>
#include <locale.h>

#define VALA_DOC_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VALA_DOC (vala_doc_get_type ())
#define VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DOC, ValaDoc))
#define VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DOC, ValaDocClass))
#define IS_VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DOC))
#define IS_VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DOC))
#define VALA_DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DOC, ValaDocClass))

typedef struct _ValaDoc ValaDoc;
typedef struct _ValaDocClass ValaDocClass;
typedef struct _ValaDocPrivate ValaDocPrivate;
enum  {
	VALA_DOC_0_PROPERTY,
	VALA_DOC_NUM_PROPERTIES
};
static GParamSpec* vala_doc_properties[VALA_DOC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALADOC_TYPE_TREE_BUILDER (valadoc_tree_builder_get_type ())
#define VALADOC_TREE_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilder))
#define VALADOC_TREE_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilderClass))
#define VALADOC_IS_TREE_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_TREE_BUILDER))
#define VALADOC_IS_TREE_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_TREE_BUILDER))
#define VALADOC_TREE_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilderClass))

typedef struct _ValadocTreeBuilder ValadocTreeBuilder;
typedef struct _ValadocTreeBuilderClass ValadocTreeBuilderClass;
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALADOC_TYPE_SYMBOL_RESOLVER (valadoc_symbol_resolver_get_type ())
#define VALADOC_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_SYMBOL_RESOLVER, ValadocSymbolResolver))
#define VALADOC_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_SYMBOL_RESOLVER, ValadocSymbolResolverClass))
#define VALADOC_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_SYMBOL_RESOLVER))
#define VALADOC_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_SYMBOL_RESOLVER))
#define VALADOC_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_SYMBOL_RESOLVER, ValadocSymbolResolverClass))

typedef struct _ValadocSymbolResolver ValadocSymbolResolver;
typedef struct _ValadocSymbolResolverClass ValadocSymbolResolverClass;

#define VALADOC_TYPE_GIR_WRITER (valadoc_gir_writer_get_type ())
#define VALADOC_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_GIR_WRITER, ValadocGirWriter))
#define VALADOC_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_GIR_WRITER, ValadocGirWriterClass))
#define VALADOC_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_GIR_WRITER))
#define VALADOC_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_GIR_WRITER))
#define VALADOC_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_GIR_WRITER, ValadocGirWriterClass))

typedef struct _ValadocGirWriter ValadocGirWriter;
typedef struct _ValadocGirWriterClass ValadocGirWriterClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaDoc {
	GObject parent_instance;
	ValaDocPrivate * priv;
};

struct _ValaDocClass {
	GObjectClass parent_class;
};

static gpointer vala_doc_parent_class = NULL;
static gchar* vala_doc_directory;
static gchar* vala_doc_basedir;
static gchar** vala_doc_defines;
static gboolean vala_doc_experimental;
static gboolean vala_doc_experimental_non_null;
static gchar** vala_doc_metadata_directories;
static gchar** vala_doc_gir_directories;
static gchar** vala_doc_vapi_directories;
static gchar** vala_doc_packages;
static gchar** vala_doc_import_directories;
static gchar** vala_doc_import_packages;
static gchar** vala_doc_alternative_resource_dirs;
static gchar* vala_doc_wikidirectory;
static gboolean vala_doc_with_deps;
static gchar* vala_doc_docletpath;
static gchar** vala_doc_pluginargs;
static gboolean vala_doc__protected;
static gboolean vala_doc__internal;
static gboolean vala_doc__private;
static gboolean vala_doc_use_svg_images;
static gchar* vala_doc_pkg_name;
static gchar* vala_doc_pkg_version;
static gchar* vala_doc_gir;
static gboolean vala_doc_version;
static gboolean vala_doc_force;
static gboolean vala_doc_fatal_warnings;
static gboolean vala_doc_verbose;
static gboolean vala_doc_disable_diagnostic_colors;
static gchar* vala_doc_target_glib;
static gchar** vala_doc_tsources;
static gchar* vala_doc_wikidirectory = NULL;
static gchar* vala_doc_pkg_version = NULL;
static gchar* vala_doc_docletpath = NULL;
static gchar** vala_doc_pluginargs = NULL;
static gchar* vala_doc_directory = NULL;
static gchar* vala_doc_pkg_name = NULL;
static gchar* vala_doc_gir = NULL;
static gchar* vala_doc_gir_namespace;
static gchar* vala_doc_gir_namespace = NULL;
static gchar* vala_doc_gir_version;
static gchar* vala_doc_gir_version = NULL;
static gboolean vala_doc_add_inherited;
static gboolean vala_doc_add_inherited = FALSE;
static gboolean vala_doc__protected = TRUE;
static gboolean vala_doc__internal = FALSE;
static gboolean vala_doc_with_deps = FALSE;
static gboolean vala_doc__private = FALSE;
static gboolean vala_doc_version = FALSE;
static gboolean vala_doc_use_svg_images = FALSE;
static gboolean vala_doc_disable_diagnostic_colors = FALSE;
static gboolean vala_doc_verbose = FALSE;
static gboolean vala_doc_force = FALSE;
static gboolean vala_doc_fatal_warnings = FALSE;
static gchar* vala_doc_basedir = NULL;
static gchar** vala_doc_defines = NULL;
static gboolean vala_doc_experimental = FALSE;
static gboolean vala_doc_experimental_non_null = FALSE;
static ValaProfile vala_doc_profile;
static ValaProfile vala_doc_profile = 0;
static gchar** vala_doc_import_packages = NULL;
static gchar** vala_doc_import_directories = NULL;
static gchar** vala_doc_vapi_directories = NULL;
static gchar** vala_doc_metadata_directories = NULL;
static gchar** vala_doc_gir_directories = NULL;
static gchar** vala_doc_tsources = NULL;
static gchar** vala_doc_packages = NULL;
static gchar** vala_doc_alternative_resource_dirs = NULL;
static gchar* vala_doc_target_glib = NULL;

VALA_EXTERN GType vala_doc_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaDoc, g_object_unref)
static gboolean vala_doc_option_parse_profile (const gchar* option_name,
                                        const gchar* val,
                                        void* data,
                                        GError** error);
static gboolean vala_doc_option_deprecated (const gchar* option_name,
                                     const gchar* val,
                                     void* data,
                                     GError** error);
static gint vala_doc_quit (ValadocErrorReporter* reporter);
static gboolean vala_doc_check_pkg_name (void);
static gchar* vala_doc_get_pkg_name (ValaDoc* self);
static ValadocModuleLoader* vala_doc_create_module_loader (ValaDoc* self,
                                                    ValadocErrorReporter* reporter,
                                                    ValadocDoclet** doclet);
static gint vala_doc_run (ValaDoc* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
VALA_EXTERN GType valadoc_tree_builder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocTreeBuilder, vala_code_visitor_unref)
VALA_EXTERN ValadocTreeBuilder* valadoc_tree_builder_new (void);
VALA_EXTERN ValadocTreeBuilder* valadoc_tree_builder_construct (GType object_type);
VALA_EXTERN ValadocApiTree* valadoc_tree_builder_build (ValadocTreeBuilder* self,
                                            ValadocSettings* settings,
                                            ValadocErrorReporter* reporter);
VALA_EXTERN GType valadoc_symbol_resolver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocSymbolResolver, g_object_unref)
VALA_EXTERN ValadocSymbolResolver* valadoc_symbol_resolver_new (ValadocTreeBuilder* builder);
VALA_EXTERN ValadocSymbolResolver* valadoc_symbol_resolver_construct (GType object_type,
                                                          ValadocTreeBuilder* builder);
VALA_EXTERN GType valadoc_gir_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocGirWriter, vala_code_visitor_unref)
VALA_EXTERN ValadocGirWriter* valadoc_gir_writer_new (ValadocSymbolResolver* resolver);
VALA_EXTERN ValadocGirWriter* valadoc_gir_writer_construct (GType object_type,
                                                ValadocSymbolResolver* resolver);
static gint vala_doc_main (gchar** args,
                    gint args_length1);
VALA_EXTERN ValaDoc* vala_doc_new (void);
VALA_EXTERN ValaDoc* vala_doc_construct (GType object_type);
static void vala_doc_finalize (GObject * obj);
static GType vala_doc_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry VALA_DOC_options[33] = {{"directory", 'o', (gint) 0, G_OPTION_ARG_FILENAME, &vala_doc_directory, "Output directory", "DIRECTORY"}, {"basedir", 'b', (gint) 0, G_OPTION_ARG_FILENAME, &vala_doc_basedir, "Base source directory", "DIRECTORY"}, {"define", 'D', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_defines, "Define SYMBOL", "SYMBOL..."}, {"profile", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_doc_option_parse_profile, "Minimum runtime dependency: 'gobject' (default) or 'posix' (minimal li" \
"bc)", "PROFILE"}, {"enable-experimental", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_experimental, "Enable experimental features", NULL}, {"enable-experimental-non-null", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"metadatadir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"driver", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_doc_option_deprecated, "Name of an driver or path to a custom driver (DEPRECATED AND IGNORED)", NULL}, {"importdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_import_directories, "Look for external documentation in DIRECTORY", "DIRECTORY..."}, {"import", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_import_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"alternative-resource-dir", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_alternative_resource_dirs, "Alternative resource directories", "DIRECTORY..."}, {"wiki", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_doc_wikidirectory, "Wiki directory", "DIRECTORY"}, {"deps", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_with_deps, "Adds packages to the documentation", NULL}, {"doclet", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_docletpath, "Name of an included doclet or path to custom doclet", "PLUGIN"}, {"doclet-arg", 'X', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_pluginargs, "Pass arguments to the doclet", "ARG"}, {"no-protected", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &vala_doc__protected, "Removes protected elements from documentation", NULL}, {"internal", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc__internal, "Adds internal elements to documentation", NULL}, {"private", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc__private, "Adds private elements to documentation", NULL}, {"use-svg-images", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_use_svg_images, "Generate SVG image charts instead of PNG", NULL}, {"package-name", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_pkg_name, "package name", "NAME"}, {"package-version", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_pkg_version, "package version", "VERSION"}, {"gir", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_version, "Display version number", NULL}, {"force", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_force, "force", NULL}, {"fatal-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_fatal_warnings, "Treat warnings as fatal", NULL}, {"verbose", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_verbose, "Show all warnings", NULL}, {"no-color", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_target_glib, "Target version of glib for code generation", "'MAJOR.MINOR', or 'auto'"}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_tsources, NULL, "FILE..."}, {NULL}};

static gboolean
vala_doc_option_parse_profile (const gchar* option_name,
                               const gchar* val,
                               void* data,
                               GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("gobject-2.0"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("gobject"))))) {
		switch (0) {
			default:
			{
				vala_doc_profile = VALA_PROFILE_GOBJECT;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("libc")))) {
		switch (0) {
			default:
			{
				vala_doc_profile = VALA_PROFILE_LIBC;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("posix")))) {
		switch (0) {
			default:
			{
				vala_doc_profile = VALA_PROFILE_POSIX;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --profile argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_doc_option_deprecated (const gchar* option_name,
                            const gchar* val,
                            void* data,
                            GError** error)
{
	gboolean result;
	g_return_val_if_fail (option_name != NULL, FALSE);
	g_print ("Command-line option `%s` is deprecated and will be ignored\n", option_name);
	result = TRUE;
	return result;
}

static gint
vala_doc_quit (ValadocErrorReporter* reporter)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (reporter != NULL, 0);
	_tmp1_ = valadoc_error_reporter_get_errors (reporter);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		gboolean _tmp3_ = FALSE;
		if (!vala_doc_fatal_warnings) {
			_tmp3_ = TRUE;
		} else {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = valadoc_error_reporter_get_warnings (reporter);
			_tmp5_ = _tmp4_;
			_tmp3_ = _tmp5_ == 0;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = valadoc_error_reporter_get_warnings (reporter);
		_tmp7_ = _tmp6_;
		g_print ("Succeeded - %d warning(s)\n", _tmp7_);
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = valadoc_error_reporter_get_errors (reporter);
		_tmp9_ = _tmp8_;
		_tmp10_ = valadoc_error_reporter_get_warnings (reporter);
		_tmp11_ = _tmp10_;
		g_print ("Failed: %d error(s), %d warning(s)\n", _tmp9_, _tmp11_);
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static gboolean
vala_doc_check_pkg_name (void)
{
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean result;
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = vala_doc_pkg_name;
	if (g_strcmp0 (_tmp2_, "glib-2.0") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = vala_doc_pkg_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "gobject-2.0") == 0;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vala_doc_tsources;
	_tmp4__length1 = _vala_array_length (vala_doc_tsources);
	{
		gchar** package_collection = NULL;
		gint package_collection_length1 = 0;
		gint _package_collection_size_ = 0;
		gint package_it = 0;
		package_collection = _tmp4_;
		package_collection_length1 = _tmp4__length1;
		for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
			gchar* _tmp5_;
			gchar* package = NULL;
			_tmp5_ = g_strdup (package_collection[package_it]);
			package = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = vala_doc_pkg_name;
				_tmp7_ = package;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = FALSE;
					_g_free0 (package);
					return result;
				}
				_g_free0 (package);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
vala_doc_get_pkg_name (ValaDoc* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = vala_doc_directory;
		if (g_str_has_suffix (_tmp1_, "/")) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = vala_doc_directory;
			_tmp3_ = g_path_get_dirname (_tmp2_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp3_;
		} else {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = vala_doc_directory;
			_tmp5_ = g_path_get_basename (_tmp4_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp5_;
		}
	}
	_tmp6_ = vala_doc_pkg_name;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}

static ValadocModuleLoader*
vala_doc_create_module_loader (ValaDoc* self,
                               ValadocErrorReporter* reporter,
                               ValadocDoclet** doclet)
{
	ValadocDoclet* _vala_doclet = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocModuleLoader* _tmp0_;
	gchar* pluginpath = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocModuleLoader* _tmp4_;
	const gchar* _tmp5_;
	ValadocDoclet* _tmp6_;
	ValadocDoclet* _tmp7_;
	ValadocModuleLoader* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	_tmp0_ = valadoc_module_loader_get_instance ();
	modules = _tmp0_;
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = NULL;
	_tmp1_ = vala_doc_docletpath;
	_tmp2_ = valadoc_module_loader_get_doclet_path (_tmp1_, reporter);
	pluginpath = _tmp2_;
	_tmp3_ = pluginpath;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		return result;
	}
	_tmp4_ = modules;
	_tmp5_ = pluginpath;
	_tmp6_ = valadoc_module_loader_create_doclet (_tmp4_, _tmp5_);
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = _tmp6_;
	_tmp7_ = _vala_doclet;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = pluginpath;
		valadoc_error_reporter_simple_error (reporter, NULL, "failed to load doclet '%s'", _tmp8_);
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		return result;
	}
	result = modules;
	_g_free0 (pluginpath);
	if (doclet) {
		*doclet = _vala_doclet;
	} else {
		_g_object_unref0 (_vala_doclet);
	}
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
vala_doc_run (ValaDoc* self)
{
	ValaCodeContext* context = NULL;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValadocErrorReporter* reporter = NULL;
	ValadocErrorReporter* _tmp2_;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	const gchar* _tmp19_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	ValadocErrorReporter* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	const gchar* _tmp34_;
	ValadocSettings* settings = NULL;
	ValadocSettings* _tmp68_;
	ValadocErrorReporter* _tmp69_;
	ValadocSettings* _tmp70_;
	ValadocSettings* _tmp71_;
	gchar* _tmp72_;
	ValadocSettings* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	ValadocSettings* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	const gchar* _tmp79_;
	ValadocSettings* _tmp91_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	ValadocSettings* _tmp94_;
	ValadocSettings* _tmp95_;
	ValadocSettings* _tmp96_;
	ValadocSettings* _tmp97_;
	ValadocSettings* _tmp98_;
	ValadocSettings* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	ValadocSettings* _tmp102_;
	ValadocSettings* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	ValadocSettings* _tmp106_;
	gchar** _tmp107_;
	gint _tmp107__length1;
	gchar** _tmp108_;
	gint _tmp108__length1;
	ValadocSettings* _tmp109_;
	ValadocSettings* _tmp110_;
	ValadocSettings* _tmp111_;
	const gchar* _tmp112_;
	gchar* _tmp113_;
	ValadocSettings* _tmp114_;
	const gchar* _tmp115_;
	gchar* _tmp116_;
	ValadocSettings* _tmp117_;
	gchar** _tmp118_;
	gint _tmp118__length1;
	gchar** _tmp119_;
	gint _tmp119__length1;
	ValadocSettings* _tmp120_;
	gchar** _tmp121_;
	gint _tmp121__length1;
	gchar** _tmp122_;
	gint _tmp122__length1;
	ValadocSettings* _tmp123_;
	gchar** _tmp124_;
	gint _tmp124__length1;
	gchar** _tmp125_;
	gint _tmp125__length1;
	ValadocSettings* _tmp126_;
	const gchar* _tmp127_;
	gchar* _tmp128_;
	ValadocSettings* _tmp129_;
	ValadocSettings* _tmp130_;
	gchar** _tmp131_;
	gint _tmp131__length1;
	gchar** _tmp132_;
	gint _tmp132__length1;
	ValadocSettings* _tmp133_;
	gchar** _tmp134_;
	gint _tmp134__length1;
	gchar** _tmp135_;
	gint _tmp135__length1;
	ValadocSettings* _tmp136_;
	ValadocSettings* _tmp137_;
	gchar** _tmp138_;
	gint _tmp138__length1;
	gchar** _tmp139_;
	gint _tmp139__length1;
	ValadocSettings* _tmp140_;
	gchar** _tmp141_;
	gint _tmp141__length1;
	gchar** _tmp142_;
	gint _tmp142__length1;
	ValadocDoclet* doclet = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocErrorReporter* _tmp143_;
	ValadocDoclet* _tmp144_ = NULL;
	ValadocModuleLoader* _tmp145_;
	gboolean _tmp146_ = FALSE;
	ValadocErrorReporter* _tmp147_;
	gint _tmp148_;
	gint _tmp149_;
	ValadocTreeBuilder* builder = NULL;
	ValadocTreeBuilder* _tmp152_;
	ValadocApiTree* doctree = NULL;
	ValadocTreeBuilder* _tmp153_;
	ValadocSettings* _tmp154_;
	ValadocErrorReporter* _tmp155_;
	ValadocApiTree* _tmp156_;
	ValadocErrorReporter* _tmp157_;
	gint _tmp158_;
	gint _tmp159_;
	ValadocSymbolResolver* resolver = NULL;
	ValadocTreeBuilder* _tmp161_;
	ValadocSymbolResolver* _tmp162_;
	ValadocApiTree* _tmp163_;
	ValadocSymbolResolver* _tmp164_;
	ValadocApiChildSymbolRegistrar* registrar = NULL;
	ValadocApiChildSymbolRegistrar* _tmp165_;
	ValadocApiTree* _tmp166_;
	ValadocApiChildSymbolRegistrar* _tmp167_;
	ValadocDocumentationParser* docparser = NULL;
	ValadocSettings* _tmp168_;
	ValadocErrorReporter* _tmp169_;
	ValadocApiTree* _tmp170_;
	ValadocModuleLoader* _tmp171_;
	ValadocDocumentationParser* _tmp172_;
	ValadocApiTree* _tmp173_;
	ValadocImporterDocumentationImporter** importers = NULL;
	ValadocApiTree* _tmp175_;
	ValadocDocumentationParser* _tmp176_;
	ValadocModuleLoader* _tmp177_;
	ValadocSettings* _tmp178_;
	ValadocErrorReporter* _tmp179_;
	ValadocImporterValadocDocumentationImporter* _tmp180_;
	ValadocApiTree* _tmp181_;
	ValadocDocumentationParser* _tmp182_;
	ValadocModuleLoader* _tmp183_;
	ValadocSettings* _tmp184_;
	ValadocErrorReporter* _tmp185_;
	ValadocImporterGirDocumentationImporter* _tmp186_;
	ValadocImporterDocumentationImporter** _tmp187_;
	gint importers_length1;
	gint _importers_size_;
	ValadocApiTree* _tmp188_;
	ValadocDocumentationParser* _tmp189_;
	ValadocErrorReporter* _tmp190_;
	gint _tmp191_;
	gint _tmp192_;
	ValadocApiTree* _tmp194_;
	ValadocImporterDocumentationImporter** _tmp195_;
	gint _tmp195__length1;
	gchar** _tmp196_;
	gint _tmp196__length1;
	gchar** _tmp197_;
	gint _tmp197__length1;
	ValadocErrorReporter* _tmp198_;
	gint _tmp199_;
	gint _tmp200_;
	ValadocApiTree* _tmp202_;
	ValadocDocumentationParser* _tmp203_;
	ValadocErrorReporter* _tmp204_;
	gint _tmp205_;
	gint _tmp206_;
	const gchar* _tmp208_;
	ValadocDoclet* _tmp233_;
	ValadocSettings* _tmp234_;
	ValadocApiTree* _tmp235_;
	ValadocErrorReporter* _tmp236_;
	ValadocErrorReporter* _tmp237_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	context = _tmp0_;
	_tmp1_ = context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = valadoc_error_reporter_new (NULL);
	reporter = _tmp2_;
	if (vala_doc_disable_diagnostic_colors == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValadocErrorReporter* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = reporter;
			_tmp6_ = env_colors;
			valadoc_error_reporter_set_colors (_tmp5_, _tmp6_);
		} else {
			ValadocErrorReporter* _tmp7_;
			_tmp7_ = reporter;
			valadoc_error_reporter_set_colors (_tmp7_, VALA_DOC_DEFAULT_COLORS);
		}
	}
	_tmp8_ = vala_doc_directory;
	if (_tmp8_ == NULL) {
		ValadocErrorReporter* _tmp9_;
		ValadocErrorReporter* _tmp10_;
		_tmp9_ = reporter;
		valadoc_error_reporter_simple_error (_tmp9_, NULL, "No output directory specified.");
		_tmp10_ = reporter;
		result = vala_doc_quit (_tmp10_);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	if (!vala_doc_check_pkg_name ()) {
		ValadocErrorReporter* _tmp11_;
		ValadocErrorReporter* _tmp12_;
		_tmp11_ = reporter;
		valadoc_error_reporter_simple_error (_tmp11_, NULL, "File already exists");
		_tmp12_ = reporter;
		result = vala_doc_quit (_tmp12_);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp13_ = vala_doc_directory;
	if (g_file_test (_tmp13_, G_FILE_TEST_EXISTS)) {
		if (vala_doc_force == TRUE) {
			gboolean tmp = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = vala_doc_directory;
			tmp = valadoc_remove_directory (_tmp14_);
			if (tmp == FALSE) {
				ValadocErrorReporter* _tmp15_;
				ValadocErrorReporter* _tmp16_;
				_tmp15_ = reporter;
				valadoc_error_reporter_simple_error (_tmp15_, NULL, "Can't remove directory.");
				_tmp16_ = reporter;
				result = vala_doc_quit (_tmp16_);
				_g_object_unref0 (reporter);
				_vala_code_context_unref0 (context);
				return result;
			}
		} else {
			ValadocErrorReporter* _tmp17_;
			ValadocErrorReporter* _tmp18_;
			_tmp17_ = reporter;
			valadoc_error_reporter_simple_error (_tmp17_, NULL, "File already exists");
			_tmp18_ = reporter;
			result = vala_doc_quit (_tmp18_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
	}
	_tmp19_ = vala_doc_wikidirectory;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		_tmp20_ = vala_doc_wikidirectory;
		if (!g_file_test (_tmp20_, G_FILE_TEST_IS_DIR)) {
			ValadocErrorReporter* _tmp21_;
			ValadocErrorReporter* _tmp22_;
			_tmp21_ = reporter;
			valadoc_error_reporter_simple_error (_tmp21_, NULL, "Wiki-directory does not exist.");
			_tmp22_ = reporter;
			result = vala_doc_quit (_tmp22_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
	}
	_tmp23_ = vala_doc_alternative_resource_dirs;
	_tmp23__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp23_;
		dir_collection_length1 = _tmp23__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp24_;
				_tmp24_ = dir;
				if (!g_file_test (_tmp24_, G_FILE_TEST_IS_DIR)) {
					ValadocErrorReporter* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					ValadocErrorReporter* _tmp29_;
					_tmp25_ = reporter;
					_tmp26_ = dir;
					_tmp27_ = g_strdup_printf ("alternative resource directory '%s' does not exist.", _tmp26_);
					_tmp28_ = _tmp27_;
					valadoc_error_reporter_simple_error (_tmp25_, NULL, "%s", _tmp28_);
					_g_free0 (_tmp28_);
					_tmp29_ = reporter;
					result = vala_doc_quit (_tmp29_);
					_g_object_unref0 (reporter);
					_vala_code_context_unref0 (context);
					return result;
				}
			}
		}
	}
	_tmp30_ = reporter;
	_tmp31_ = valadoc_error_reporter_get_errors (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 0) {
		ValadocErrorReporter* _tmp33_;
		_tmp33_ = reporter;
		result = vala_doc_quit (_tmp33_);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp34_ = vala_doc_gir;
	if (_tmp34_ != NULL) {
		gchar* gir_base = NULL;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		glong gir_len = 0L;
		const gchar* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint last_hyphen = 0;
		const gchar* _tmp40_;
		gboolean _tmp41_ = FALSE;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		const gchar* _tmp54_;
		gboolean report_warning = FALSE;
		gchar** _tmp61_;
		gint _tmp61__length1;
		_tmp35_ = vala_doc_gir;
		_tmp36_ = g_path_get_basename (_tmp35_);
		gir_base = _tmp36_;
		_tmp37_ = gir_base;
		_tmp38_ = strlen (_tmp37_);
		_tmp39_ = _tmp38_;
		gir_len = (glong) _tmp39_;
		_tmp40_ = gir_base;
		last_hyphen = string_last_index_of_char (_tmp40_, (gunichar) '-', 0);
		if (last_hyphen == -1) {
			_tmp41_ = TRUE;
		} else {
			const gchar* _tmp42_;
			_tmp42_ = gir_base;
			_tmp41_ = !g_str_has_suffix (_tmp42_, ".gir");
		}
		if (_tmp41_) {
			ValadocErrorReporter* _tmp43_;
			const gchar* _tmp44_;
			ValadocErrorReporter* _tmp45_;
			_tmp43_ = reporter;
			_tmp44_ = vala_doc_gir;
			valadoc_error_reporter_simple_error (_tmp43_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp44_);
			_tmp45_ = reporter;
			result = vala_doc_quit (_tmp45_);
			_g_free0 (gir_base);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		_tmp46_ = gir_base;
		_tmp47_ = string_substring (_tmp46_, (glong) 0, (glong) last_hyphen);
		_g_free0 (vala_doc_gir_namespace);
		vala_doc_gir_namespace = _tmp47_;
		_tmp48_ = gir_base;
		_tmp49_ = string_substring (_tmp48_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
		_g_free0 (vala_doc_gir_version);
		vala_doc_gir_version = _tmp49_;
		_tmp50_ = vala_doc_gir_version;
		g_strcanon (_tmp50_, "0123456789.", '?');
		_tmp54_ = vala_doc_gir_namespace;
		if (g_strcmp0 (_tmp54_, "") == 0) {
			_tmp53_ = TRUE;
		} else {
			const gchar* _tmp55_;
			_tmp55_ = vala_doc_gir_version;
			_tmp53_ = g_strcmp0 (_tmp55_, "") == 0;
		}
		if (_tmp53_) {
			_tmp52_ = TRUE;
		} else {
			const gchar* _tmp56_;
			_tmp56_ = vala_doc_gir_version;
			_tmp52_ = !g_ascii_isdigit (string_get (_tmp56_, (glong) 0));
		}
		if (_tmp52_) {
			_tmp51_ = TRUE;
		} else {
			const gchar* _tmp57_;
			_tmp57_ = vala_doc_gir_version;
			_tmp51_ = string_contains (_tmp57_, "?");
		}
		if (_tmp51_) {
			ValadocErrorReporter* _tmp58_;
			const gchar* _tmp59_;
			ValadocErrorReporter* _tmp60_;
			_tmp58_ = reporter;
			_tmp59_ = vala_doc_gir;
			valadoc_error_reporter_simple_error (_tmp58_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp59_);
			_tmp60_ = reporter;
			result = vala_doc_quit (_tmp60_);
			_g_free0 (gir_base);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		report_warning = TRUE;
		_tmp61_ = vala_doc_tsources;
		_tmp61__length1 = _vala_array_length (vala_doc_tsources);
		{
			gchar** source_collection = NULL;
			gint source_collection_length1 = 0;
			gint _source_collection_size_ = 0;
			gint source_it = 0;
			source_collection = _tmp61_;
			source_collection_length1 = _tmp61__length1;
			for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
				gchar* _tmp62_;
				gchar* source = NULL;
				_tmp62_ = g_strdup (source_collection[source_it]);
				source = _tmp62_;
				{
					gboolean _tmp63_ = FALSE;
					const gchar* _tmp64_;
					_tmp64_ = source;
					if (g_str_has_suffix (_tmp64_, ".vala")) {
						_tmp63_ = TRUE;
					} else {
						const gchar* _tmp65_;
						_tmp65_ = source;
						_tmp63_ = g_str_has_suffix (_tmp65_, ".gs");
					}
					if (_tmp63_) {
						report_warning = FALSE;
						_g_free0 (source);
						break;
					}
					_g_free0 (source);
				}
			}
		}
		if (report_warning == TRUE) {
			ValadocErrorReporter* _tmp66_;
			ValadocErrorReporter* _tmp67_;
			_tmp66_ = reporter;
			valadoc_error_reporter_simple_error (_tmp66_, NULL, "No source file specified to be compiled to gir.");
			_tmp67_ = reporter;
			result = vala_doc_quit (_tmp67_);
			_g_free0 (gir_base);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		_g_free0 (gir_base);
	}
	_tmp68_ = valadoc_settings_new ();
	settings = _tmp68_;
	_tmp69_ = reporter;
	_tmp70_ = settings;
	valadoc_error_reporter_set_settings (_tmp69_, _tmp70_);
	_tmp71_ = settings;
	_tmp72_ = vala_doc_get_pkg_name (self);
	_g_free0 (_tmp71_->pkg_name);
	_tmp71_->pkg_name = _tmp72_;
	_tmp73_ = settings;
	_tmp74_ = vala_doc_gir_namespace;
	_tmp75_ = g_strdup (_tmp74_);
	_g_free0 (_tmp73_->gir_namespace);
	_tmp73_->gir_namespace = _tmp75_;
	_tmp76_ = settings;
	_tmp77_ = vala_doc_gir_version;
	_tmp78_ = g_strdup (_tmp77_);
	_g_free0 (_tmp76_->gir_version);
	_tmp76_->gir_version = _tmp78_;
	_tmp79_ = vala_doc_gir;
	if (_tmp79_ != NULL) {
		ValadocSettings* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		ValadocSettings* _tmp83_;
		const gchar* _tmp84_;
		gchar* _tmp85_;
		ValadocSettings* _tmp86_;
		const gchar* _tmp87_;
		_tmp80_ = settings;
		_tmp81_ = vala_doc_gir;
		_tmp82_ = g_path_get_basename (_tmp81_);
		_g_free0 (_tmp80_->gir_name);
		_tmp80_->gir_name = _tmp82_;
		_tmp83_ = settings;
		_tmp84_ = vala_doc_gir;
		_tmp85_ = g_path_get_dirname (_tmp84_);
		_g_free0 (_tmp83_->gir_directory);
		_tmp83_->gir_directory = _tmp85_;
		_tmp86_ = settings;
		_tmp87_ = _tmp86_->gir_directory;
		if (g_strcmp0 (_tmp87_, "") == 0) {
			ValadocSettings* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			_tmp88_ = settings;
			_tmp89_ = vala_doc_directory;
			_tmp90_ = g_path_get_dirname (_tmp89_);
			_g_free0 (_tmp88_->gir_directory);
			_tmp88_->gir_directory = _tmp90_;
		}
	}
	_tmp91_ = settings;
	_tmp92_ = vala_doc_pkg_version;
	_tmp93_ = g_strdup (_tmp92_);
	_g_free0 (_tmp91_->pkg_version);
	_tmp91_->pkg_version = _tmp93_;
	_tmp94_ = settings;
	_tmp94_->add_inherited = vala_doc_add_inherited;
	_tmp95_ = settings;
	_tmp95_->_protected = vala_doc__protected;
	_tmp96_ = settings;
	_tmp96_->_internal = vala_doc__internal;
	_tmp97_ = settings;
	_tmp97_->with_deps = vala_doc_with_deps;
	_tmp98_ = settings;
	_tmp98_->_private = vala_doc__private;
	_tmp99_ = settings;
	_tmp100_ = vala_doc_directory;
	_tmp101_ = vala_code_context_realpath (_tmp100_);
	_g_free0 (_tmp99_->path);
	_tmp99_->path = _tmp101_;
	_tmp102_ = settings;
	_tmp102_->verbose = vala_doc_verbose;
	_tmp103_ = settings;
	_tmp104_ = vala_doc_wikidirectory;
	_tmp105_ = g_strdup (_tmp104_);
	_g_free0 (_tmp103_->wiki_directory);
	_tmp103_->wiki_directory = _tmp105_;
	_tmp106_ = settings;
	_tmp107_ = vala_doc_pluginargs;
	_tmp107__length1 = _vala_array_length (vala_doc_pluginargs);
	_tmp108_ = (_tmp107_ != NULL) ? _vala_array_dup1 (_tmp107_, _tmp107__length1) : _tmp107_;
	_tmp108__length1 = _tmp107__length1;
	_tmp106_->pluginargs = (_vala_array_free (_tmp106_->pluginargs, _tmp106_->pluginargs_length1, (GDestroyNotify) g_free), NULL);
	_tmp106_->pluginargs = _tmp108_;
	_tmp106_->pluginargs_length1 = _tmp108__length1;
	_tmp109_ = settings;
	_tmp109_->experimental = vala_doc_experimental;
	_tmp110_ = settings;
	_tmp110_->experimental_non_null = vala_doc_experimental_non_null;
	_tmp111_ = settings;
	_tmp112_ = vala_doc_basedir;
	_tmp113_ = g_strdup (_tmp112_);
	_g_free0 (_tmp111_->basedir);
	_tmp111_->basedir = _tmp113_;
	_tmp114_ = settings;
	_tmp115_ = vala_doc_directory;
	_tmp116_ = g_strdup (_tmp115_);
	_g_free0 (_tmp114_->directory);
	_tmp114_->directory = _tmp116_;
	_tmp117_ = settings;
	_tmp118_ = vala_doc_vapi_directories;
	_tmp118__length1 = _vala_array_length (vala_doc_vapi_directories);
	_tmp119_ = (_tmp118_ != NULL) ? _vala_array_dup2 (_tmp118_, _tmp118__length1) : _tmp118_;
	_tmp119__length1 = _tmp118__length1;
	_tmp117_->vapi_directories = (_vala_array_free (_tmp117_->vapi_directories, _tmp117_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp117_->vapi_directories = _tmp119_;
	_tmp117_->vapi_directories_length1 = _tmp119__length1;
	_tmp120_ = settings;
	_tmp121_ = vala_doc_metadata_directories;
	_tmp121__length1 = _vala_array_length (vala_doc_metadata_directories);
	_tmp122_ = (_tmp121_ != NULL) ? _vala_array_dup3 (_tmp121_, _tmp121__length1) : _tmp121_;
	_tmp122__length1 = _tmp121__length1;
	_tmp120_->metadata_directories = (_vala_array_free (_tmp120_->metadata_directories, _tmp120_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp120_->metadata_directories = _tmp122_;
	_tmp120_->metadata_directories_length1 = _tmp122__length1;
	_tmp123_ = settings;
	_tmp124_ = vala_doc_gir_directories;
	_tmp124__length1 = _vala_array_length (vala_doc_gir_directories);
	_tmp125_ = (_tmp124_ != NULL) ? _vala_array_dup4 (_tmp124_, _tmp124__length1) : _tmp124_;
	_tmp125__length1 = _tmp124__length1;
	_tmp123_->gir_directories = (_vala_array_free (_tmp123_->gir_directories, _tmp123_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp123_->gir_directories = _tmp125_;
	_tmp123_->gir_directories_length1 = _tmp125__length1;
	_tmp126_ = settings;
	_tmp127_ = vala_doc_target_glib;
	_tmp128_ = g_strdup (_tmp127_);
	_g_free0 (_tmp126_->target_glib);
	_tmp126_->target_glib = _tmp128_;
	_tmp129_ = settings;
	_tmp129_->use_svg_images = vala_doc_use_svg_images;
	_tmp130_ = settings;
	_tmp131_ = vala_doc_tsources;
	_tmp131__length1 = _vala_array_length (vala_doc_tsources);
	_tmp132_ = (_tmp131_ != NULL) ? _vala_array_dup5 (_tmp131_, _tmp131__length1) : _tmp131_;
	_tmp132__length1 = _tmp131__length1;
	_tmp130_->source_files = (_vala_array_free (_tmp130_->source_files, _tmp130_->source_files_length1, (GDestroyNotify) g_free), NULL);
	_tmp130_->source_files = _tmp132_;
	_tmp130_->source_files_length1 = _tmp132__length1;
	_tmp133_ = settings;
	_tmp134_ = vala_doc_packages;
	_tmp134__length1 = _vala_array_length (vala_doc_packages);
	_tmp135_ = (_tmp134_ != NULL) ? _vala_array_dup6 (_tmp134_, _tmp134__length1) : _tmp134_;
	_tmp135__length1 = _tmp134__length1;
	_tmp133_->packages = (_vala_array_free (_tmp133_->packages, _tmp133_->packages_length1, (GDestroyNotify) g_free), NULL);
	_tmp133_->packages = _tmp135_;
	_tmp133_->packages_length1 = _tmp135__length1;
	_tmp136_ = settings;
	_tmp136_->profile = vala_doc_profile;
	_tmp137_ = settings;
	_tmp138_ = vala_doc_defines;
	_tmp138__length1 = _vala_array_length (vala_doc_defines);
	_tmp139_ = (_tmp138_ != NULL) ? _vala_array_dup7 (_tmp138_, _tmp138__length1) : _tmp138_;
	_tmp139__length1 = _tmp138__length1;
	_tmp137_->defines = (_vala_array_free (_tmp137_->defines, _tmp137_->defines_length1, (GDestroyNotify) g_free), NULL);
	_tmp137_->defines = _tmp139_;
	_tmp137_->defines_length1 = _tmp139__length1;
	_tmp140_ = settings;
	_tmp141_ = vala_doc_alternative_resource_dirs;
	_tmp141__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	_tmp142_ = (_tmp141_ != NULL) ? _vala_array_dup8 (_tmp141_, _tmp141__length1) : _tmp141_;
	_tmp142__length1 = _tmp141__length1;
	_tmp140_->alternative_resource_dirs = (_vala_array_free (_tmp140_->alternative_resource_dirs, _tmp140_->alternative_resource_dirs_length1, (GDestroyNotify) g_free), NULL);
	_tmp140_->alternative_resource_dirs = _tmp142_;
	_tmp140_->alternative_resource_dirs_length1 = _tmp142__length1;
	doclet = NULL;
	_tmp143_ = reporter;
	_tmp145_ = vala_doc_create_module_loader (self, _tmp143_, &_tmp144_);
	_g_object_unref0 (doclet);
	doclet = _tmp144_;
	modules = _tmp145_;
	_tmp147_ = reporter;
	_tmp148_ = valadoc_error_reporter_get_errors (_tmp147_);
	_tmp149_ = _tmp148_;
	if (_tmp149_ > 0) {
		_tmp146_ = TRUE;
	} else {
		ValadocModuleLoader* _tmp150_;
		_tmp150_ = modules;
		_tmp146_ = _tmp150_ == NULL;
	}
	if (_tmp146_) {
		ValadocErrorReporter* _tmp151_;
		_tmp151_ = reporter;
		result = vala_doc_quit (_tmp151_);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp152_ = valadoc_tree_builder_new ();
	builder = _tmp152_;
	_tmp153_ = builder;
	_tmp154_ = settings;
	_tmp155_ = reporter;
	_tmp156_ = valadoc_tree_builder_build (_tmp153_, _tmp154_, _tmp155_);
	doctree = _tmp156_;
	_tmp157_ = reporter;
	_tmp158_ = valadoc_error_reporter_get_errors (_tmp157_);
	_tmp159_ = _tmp158_;
	if (_tmp159_ > 0) {
		ValadocErrorReporter* _tmp160_;
		_g_object_unref0 (doclet);
		doclet = NULL;
		_tmp160_ = reporter;
		result = vala_doc_quit (_tmp160_);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp161_ = builder;
	_tmp162_ = valadoc_symbol_resolver_new (_tmp161_);
	resolver = _tmp162_;
	_tmp163_ = doctree;
	_tmp164_ = resolver;
	valadoc_api_tree_accept (_tmp163_, (ValadocApiVisitor*) _tmp164_);
	_tmp165_ = valadoc_api_child_symbol_registrar_new ();
	registrar = _tmp165_;
	_tmp166_ = doctree;
	_tmp167_ = registrar;
	valadoc_api_tree_accept (_tmp166_, (ValadocApiVisitor*) _tmp167_);
	_tmp168_ = settings;
	_tmp169_ = reporter;
	_tmp170_ = doctree;
	_tmp171_ = modules;
	_tmp172_ = valadoc_documentation_parser_new (_tmp168_, _tmp169_, _tmp170_, _tmp171_);
	docparser = _tmp172_;
	_tmp173_ = doctree;
	if (!valadoc_api_tree_create_tree (_tmp173_)) {
		ValadocErrorReporter* _tmp174_;
		_tmp174_ = reporter;
		result = vala_doc_quit (_tmp174_);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp175_ = doctree;
	_tmp176_ = docparser;
	_tmp177_ = modules;
	_tmp178_ = settings;
	_tmp179_ = reporter;
	_tmp180_ = valadoc_importer_valadoc_documentation_importer_new (_tmp175_, _tmp176_, _tmp177_, _tmp178_, _tmp179_);
	_tmp181_ = doctree;
	_tmp182_ = docparser;
	_tmp183_ = modules;
	_tmp184_ = settings;
	_tmp185_ = reporter;
	_tmp186_ = valadoc_importer_gir_documentation_importer_new (_tmp181_, _tmp182_, _tmp183_, _tmp184_, _tmp185_);
	_tmp187_ = g_new0 (ValadocImporterDocumentationImporter*, 2 + 1);
	_tmp187_[0] = (ValadocImporterDocumentationImporter*) _tmp180_;
	_tmp187_[1] = (ValadocImporterDocumentationImporter*) _tmp186_;
	importers = _tmp187_;
	importers_length1 = 2;
	_importers_size_ = importers_length1;
	_tmp188_ = doctree;
	_tmp189_ = docparser;
	valadoc_api_tree_parse_comments (_tmp188_, _tmp189_);
	_tmp190_ = reporter;
	_tmp191_ = valadoc_error_reporter_get_errors (_tmp190_);
	_tmp192_ = _tmp191_;
	if (_tmp192_ > 0) {
		ValadocErrorReporter* _tmp193_;
		_tmp193_ = reporter;
		result = vala_doc_quit (_tmp193_);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp194_ = doctree;
	_tmp195_ = importers;
	_tmp195__length1 = importers_length1;
	_tmp196_ = vala_doc_import_packages;
	_tmp196__length1 = _vala_array_length (vala_doc_import_packages);
	_tmp197_ = vala_doc_import_directories;
	_tmp197__length1 = _vala_array_length (vala_doc_import_directories);
	valadoc_api_tree_import_comments (_tmp194_, _tmp195_, (gint) _tmp195__length1, _tmp196_, (gint) _tmp196__length1, _tmp197_, (gint) _tmp197__length1);
	_tmp198_ = reporter;
	_tmp199_ = valadoc_error_reporter_get_errors (_tmp198_);
	_tmp200_ = _tmp199_;
	if (_tmp200_ > 0) {
		ValadocErrorReporter* _tmp201_;
		_tmp201_ = reporter;
		result = vala_doc_quit (_tmp201_);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp202_ = doctree;
	_tmp203_ = docparser;
	valadoc_api_tree_check_comments (_tmp202_, _tmp203_);
	_tmp204_ = reporter;
	_tmp205_ = valadoc_error_reporter_get_errors (_tmp204_);
	_tmp206_ = _tmp205_;
	if (_tmp206_ > 0) {
		ValadocErrorReporter* _tmp207_;
		_tmp207_ = reporter;
		result = vala_doc_quit (_tmp207_);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp208_ = vala_doc_gir;
	if (_tmp208_ != NULL) {
		ValadocGirWriter* gir_writer = NULL;
		ValadocSymbolResolver* _tmp209_;
		ValadocGirWriter* _tmp210_;
		ValadocGirWriter* _tmp211_;
		ValadocApiTree* _tmp212_;
		ValaCodeContext* _tmp213_;
		ValaCodeContext* _tmp214_;
		ValadocSettings* _tmp215_;
		const gchar* _tmp216_;
		ValadocSettings* _tmp217_;
		const gchar* _tmp218_;
		ValadocSettings* _tmp219_;
		const gchar* _tmp220_;
		gchar* _tmp221_;
		gchar* _tmp222_;
		ValadocSettings* _tmp223_;
		const gchar* _tmp224_;
		ValadocSettings* _tmp225_;
		const gchar* _tmp226_;
		ValadocSettings* _tmp227_;
		const gchar* _tmp228_;
		ValadocErrorReporter* _tmp229_;
		gint _tmp230_;
		gint _tmp231_;
		_tmp209_ = resolver;
		_tmp210_ = valadoc_gir_writer_new (_tmp209_);
		gir_writer = _tmp210_;
		_tmp211_ = gir_writer;
		_tmp212_ = doctree;
		_tmp213_ = valadoc_api_tree_get_context (_tmp212_);
		_tmp214_ = _tmp213_;
		_tmp215_ = settings;
		_tmp216_ = _tmp215_->gir_directory;
		_tmp217_ = settings;
		_tmp218_ = _tmp217_->gir_namespace;
		_tmp219_ = settings;
		_tmp220_ = _tmp219_->gir_version;
		_tmp221_ = g_strdup_printf ("%s-%s.gir", _tmp218_, _tmp220_);
		_tmp222_ = _tmp221_;
		_tmp223_ = settings;
		_tmp224_ = _tmp223_->gir_namespace;
		_tmp225_ = settings;
		_tmp226_ = _tmp225_->gir_version;
		_tmp227_ = settings;
		_tmp228_ = _tmp227_->pkg_name;
		vala_gir_writer_write_file ((ValaGIRWriter*) _tmp211_, _tmp214_, _tmp216_, _tmp222_, _tmp224_, _tmp226_, _tmp228_, NULL);
		_g_free0 (_tmp222_);
		_tmp229_ = reporter;
		_tmp230_ = valadoc_error_reporter_get_errors (_tmp229_);
		_tmp231_ = _tmp230_;
		if (_tmp231_ > 0) {
			ValadocErrorReporter* _tmp232_;
			_tmp232_ = reporter;
			result = vala_doc_quit (_tmp232_);
			_vala_code_visitor_unref0 (gir_writer);
			importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (docparser);
			_g_object_unref0 (registrar);
			_g_object_unref0 (resolver);
			_valadoc_api_tree_unref0 (doctree);
			_vala_code_visitor_unref0 (builder);
			_g_object_unref0 (modules);
			_g_object_unref0 (doclet);
			_g_object_unref0 (settings);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		_vala_code_visitor_unref0 (gir_writer);
	}
	_tmp233_ = doclet;
	_tmp234_ = settings;
	_tmp235_ = doctree;
	_tmp236_ = reporter;
	valadoc_doclet_process (_tmp233_, _tmp234_, _tmp235_, _tmp236_);
	_tmp237_ = reporter;
	result = vala_doc_quit (_tmp237_);
	importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (docparser);
	_g_object_unref0 (registrar);
	_g_object_unref0 (resolver);
	_valadoc_api_tree_unref0 (doctree);
	_vala_code_visitor_unref0 (builder);
	_g_object_unref0 (modules);
	_g_object_unref0 (doclet);
	_g_object_unref0 (settings);
	_g_object_unref0 (reporter);
	_vala_code_context_unref0 (context);
	return result;
}

static gint
vala_doc_main (gchar** args,
               gint args_length1)
{
	const gchar* _tmp0_;
	ValaDoc* valadoc = NULL;
	ValaDoc* _tmp11_;
	ValaDoc* _tmp12_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	_tmp0_ = vala_get_build_version ();
	if (g_strcmp0 (_tmp0_, VALA_BUILD_VERSION) != 0) {
		const gchar* _tmp1_;
		_tmp1_ = vala_get_build_version ();
		g_printerr ("Integrity check failed (libvala %s doesn't match valadoc %s)\n", _tmp1_, VALA_BUILD_VERSION);
		result = 1;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		GOptionContext* _tmp4_;
		GOptionContext* _tmp5_;
		_tmp2_ = g_option_context_new ("- Vala Documentation Tool");
		opt_context = _tmp2_;
		_tmp3_ = opt_context;
		g_option_context_set_help_enabled (_tmp3_, TRUE);
		_tmp4_ = opt_context;
		g_option_context_add_main_entries (_tmp4_, VALA_DOC_options, NULL);
		_tmp5_ = opt_context;
		g_option_context_parse (_tmp5_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp6_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_print ("%s\n", _tmp8_);
		_tmp9_ = args[0];
		g_print ("Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_doc_version) {
		g_print ("Valadoc %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp11_ = vala_doc_new ();
	valadoc = _tmp11_;
	_tmp12_ = valadoc;
	result = vala_doc_run (_tmp12_);
	_g_object_unref0 (valadoc);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_doc_main (argv, argc);
}

ValaDoc*
vala_doc_construct (GType object_type)
{
	ValaDoc * self = NULL;
	self = (ValaDoc*) g_object_new (object_type, NULL);
	return self;
}

ValaDoc*
vala_doc_new (void)
{
	return vala_doc_construct (TYPE_VALA_DOC);
}

static void
vala_doc_class_init (ValaDocClass * klass,
                     gpointer klass_data)
{
	vala_doc_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vala_doc_finalize;
}

static void
vala_doc_instance_init (ValaDoc * self,
                        gpointer klass)
{
}

static void
vala_doc_finalize (GObject * obj)
{
	ValaDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALA_DOC, ValaDoc);
	G_OBJECT_CLASS (vala_doc_parent_class)->finalize (obj);
}

static GType
vala_doc_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoc), 0, (GInstanceInitFunc) vala_doc_instance_init, NULL };
	GType vala_doc_type_id;
	vala_doc_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaDoc", &g_define_type_info, 0);
	return vala_doc_type_id;
}

GType
vala_doc_get_type (void)
{
	static volatile gsize vala_doc_type_id__once = 0;
	if (g_once_init_enter (&vala_doc_type_id__once)) {
		GType vala_doc_type_id;
		vala_doc_type_id = vala_doc_get_type_once ();
		g_once_init_leave (&vala_doc_type_id__once, vala_doc_type_id);
	}
	return vala_doc_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

