// python wrapper for ttkPlanarGraphLayout
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkPlanarGraphLayout.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkPlanarGraphLayout(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkPlanarGraphLayout_ClassNew(); }


static PyObject *
PyttkPlanarGraphLayout_SetUseSequences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseSequences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseSequences(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetUseSequences(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetUseSequences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseSequences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseSequences() :
      op->ttkPlanarGraphLayout::GetUseSequences());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetUseSizes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseSizes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseSizes(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetUseSizes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetUseSizes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseSizes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseSizes() :
      op->ttkPlanarGraphLayout::GetUseSizes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetUseBranches(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseBranches");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseBranches(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetUseBranches(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetUseBranches(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseBranches");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseBranches() :
      op->ttkPlanarGraphLayout::GetUseBranches());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetUseLevels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseLevels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseLevels(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetUseLevels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetUseLevels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseLevels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseLevels() :
      op->ttkPlanarGraphLayout::GetUseLevels());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetOutputArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputArrayName(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetOutputArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetOutputArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetOutputArrayName() :
      op->ttkPlanarGraphLayout::GetOutputArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetInputIsAMergeTree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputIsAMergeTree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInputIsAMergeTree(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetInputIsAMergeTree(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetInputIsAMergeTree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputIsAMergeTree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInputIsAMergeTree() :
      op->ttkPlanarGraphLayout::GetInputIsAMergeTree());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetBranchDecompositionPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchDecompositionPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchDecompositionPlanarLayout(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetBranchDecompositionPlanarLayout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetBranchDecompositionPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchDecompositionPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBranchDecompositionPlanarLayout() :
      op->ttkPlanarGraphLayout::GetBranchDecompositionPlanarLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetBranchSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchSpacing(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetBranchSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetBranchSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBranchSpacing() :
      op->ttkPlanarGraphLayout::GetBranchSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImportantPairs(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImportantPairs() :
      op->ttkPlanarGraphLayout::GetImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetMaximumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumImportantPairs(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetMaximumImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetMaximumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaximumImportantPairs() :
      op->ttkPlanarGraphLayout::GetMaximumImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetMinimumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinimumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinimumImportantPairs(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetMinimumImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetMinimumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinimumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMinimumImportantPairs() :
      op->ttkPlanarGraphLayout::GetMinimumImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImportantPairsSpacing(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetImportantPairsSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImportantPairsSpacing() :
      op->ttkPlanarGraphLayout::GetImportantPairsSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetNonImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonImportantPairsSpacing(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetNonImportantPairsSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetNonImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonImportantPairsSpacing() :
      op->ttkPlanarGraphLayout::GetNonImportantPairsSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetNonImportantPairsProximity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonImportantPairsProximity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonImportantPairsProximity(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetNonImportantPairsProximity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetNonImportantPairsProximity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonImportantPairsProximity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonImportantPairsProximity() :
      op->ttkPlanarGraphLayout::GetNonImportantPairsProximity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetExcludeImportantPairsLower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeImportantPairsLower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeImportantPairsLower(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetExcludeImportantPairsLower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetExcludeImportantPairsLower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeImportantPairsLower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExcludeImportantPairsLower() :
      op->ttkPlanarGraphLayout::GetExcludeImportantPairsLower());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SetExcludeImportantPairsHigher(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeImportantPairsHigher");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeImportantPairsHigher(temp0);
    }
    else
    {
      op->ttkPlanarGraphLayout::SetExcludeImportantPairsHigher(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetExcludeImportantPairsHigher(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeImportantPairsHigher");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExcludeImportantPairsHigher() :
      op->ttkPlanarGraphLayout::GetExcludeImportantPairsHigher());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkPlanarGraphLayout::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkPlanarGraphLayout::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkPlanarGraphLayout *tempr = ttkPlanarGraphLayout::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkPlanarGraphLayout *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkPlanarGraphLayout::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkPlanarGraphLayout::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPlanarGraphLayout_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPlanarGraphLayout *op = static_cast<ttkPlanarGraphLayout *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkPlanarGraphLayout::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkPlanarGraphLayout_Methods[] = {
  {"SetUseSequences", PyttkPlanarGraphLayout_SetUseSequences, METH_VARARGS,
   "SetUseSequences(self, _arg:bool) -> None\nC++: virtual void SetUseSequences(bool _arg)\n\n"},
  {"GetUseSequences", PyttkPlanarGraphLayout_GetUseSequences, METH_VARARGS,
   "GetUseSequences(self) -> bool\nC++: virtual bool GetUseSequences()\n\n"},
  {"SetUseSizes", PyttkPlanarGraphLayout_SetUseSizes, METH_VARARGS,
   "SetUseSizes(self, _arg:bool) -> None\nC++: virtual void SetUseSizes(bool _arg)\n\n"},
  {"GetUseSizes", PyttkPlanarGraphLayout_GetUseSizes, METH_VARARGS,
   "GetUseSizes(self) -> bool\nC++: virtual bool GetUseSizes()\n\n"},
  {"SetUseBranches", PyttkPlanarGraphLayout_SetUseBranches, METH_VARARGS,
   "SetUseBranches(self, _arg:bool) -> None\nC++: virtual void SetUseBranches(bool _arg)\n\n"},
  {"GetUseBranches", PyttkPlanarGraphLayout_GetUseBranches, METH_VARARGS,
   "GetUseBranches(self) -> bool\nC++: virtual bool GetUseBranches()\n\n"},
  {"SetUseLevels", PyttkPlanarGraphLayout_SetUseLevels, METH_VARARGS,
   "SetUseLevels(self, _arg:bool) -> None\nC++: virtual void SetUseLevels(bool _arg)\n\n"},
  {"GetUseLevels", PyttkPlanarGraphLayout_GetUseLevels, METH_VARARGS,
   "GetUseLevels(self) -> bool\nC++: virtual bool GetUseLevels()\n\n"},
  {"SetOutputArrayName", PyttkPlanarGraphLayout_SetOutputArrayName, METH_VARARGS,
   "SetOutputArrayName(self, _arg:str) -> None\nC++: virtual void SetOutputArrayName(const std::string &_arg)\n\n"},
  {"GetOutputArrayName", PyttkPlanarGraphLayout_GetOutputArrayName, METH_VARARGS,
   "GetOutputArrayName(self) -> str\nC++: virtual std::string GetOutputArrayName()\n\n"},
  {"SetInputIsAMergeTree", PyttkPlanarGraphLayout_SetInputIsAMergeTree, METH_VARARGS,
   "SetInputIsAMergeTree(self, _arg:bool) -> None\nC++: virtual void SetInputIsAMergeTree(bool _arg)\n\n"},
  {"GetInputIsAMergeTree", PyttkPlanarGraphLayout_GetInputIsAMergeTree, METH_VARARGS,
   "GetInputIsAMergeTree(self) -> bool\nC++: virtual bool GetInputIsAMergeTree()\n\n"},
  {"SetBranchDecompositionPlanarLayout", PyttkPlanarGraphLayout_SetBranchDecompositionPlanarLayout, METH_VARARGS,
   "SetBranchDecompositionPlanarLayout(self, _arg:bool) -> None\nC++: virtual void SetBranchDecompositionPlanarLayout(bool _arg)\n\n"},
  {"GetBranchDecompositionPlanarLayout", PyttkPlanarGraphLayout_GetBranchDecompositionPlanarLayout, METH_VARARGS,
   "GetBranchDecompositionPlanarLayout(self) -> bool\nC++: virtual bool GetBranchDecompositionPlanarLayout()\n\n"},
  {"SetBranchSpacing", PyttkPlanarGraphLayout_SetBranchSpacing, METH_VARARGS,
   "SetBranchSpacing(self, _arg:float) -> None\nC++: virtual void SetBranchSpacing(double _arg)\n\n"},
  {"GetBranchSpacing", PyttkPlanarGraphLayout_GetBranchSpacing, METH_VARARGS,
   "GetBranchSpacing(self) -> float\nC++: virtual double GetBranchSpacing()\n\n"},
  {"SetImportantPairs", PyttkPlanarGraphLayout_SetImportantPairs, METH_VARARGS,
   "SetImportantPairs(self, _arg:float) -> None\nC++: virtual void SetImportantPairs(double _arg)\n\n"},
  {"GetImportantPairs", PyttkPlanarGraphLayout_GetImportantPairs, METH_VARARGS,
   "GetImportantPairs(self) -> float\nC++: virtual double GetImportantPairs()\n\n"},
  {"SetMaximumImportantPairs", PyttkPlanarGraphLayout_SetMaximumImportantPairs, METH_VARARGS,
   "SetMaximumImportantPairs(self, _arg:int) -> None\nC++: virtual void SetMaximumImportantPairs(int _arg)\n\n"},
  {"GetMaximumImportantPairs", PyttkPlanarGraphLayout_GetMaximumImportantPairs, METH_VARARGS,
   "GetMaximumImportantPairs(self) -> int\nC++: virtual int GetMaximumImportantPairs()\n\n"},
  {"SetMinimumImportantPairs", PyttkPlanarGraphLayout_SetMinimumImportantPairs, METH_VARARGS,
   "SetMinimumImportantPairs(self, _arg:int) -> None\nC++: virtual void SetMinimumImportantPairs(int _arg)\n\n"},
  {"GetMinimumImportantPairs", PyttkPlanarGraphLayout_GetMinimumImportantPairs, METH_VARARGS,
   "GetMinimumImportantPairs(self) -> int\nC++: virtual int GetMinimumImportantPairs()\n\n"},
  {"SetImportantPairsSpacing", PyttkPlanarGraphLayout_SetImportantPairsSpacing, METH_VARARGS,
   "SetImportantPairsSpacing(self, _arg:float) -> None\nC++: virtual void SetImportantPairsSpacing(double _arg)\n\n"},
  {"GetImportantPairsSpacing", PyttkPlanarGraphLayout_GetImportantPairsSpacing, METH_VARARGS,
   "GetImportantPairsSpacing(self) -> float\nC++: virtual double GetImportantPairsSpacing()\n\n"},
  {"SetNonImportantPairsSpacing", PyttkPlanarGraphLayout_SetNonImportantPairsSpacing, METH_VARARGS,
   "SetNonImportantPairsSpacing(self, _arg:float) -> None\nC++: virtual void SetNonImportantPairsSpacing(double _arg)\n\n"},
  {"GetNonImportantPairsSpacing", PyttkPlanarGraphLayout_GetNonImportantPairsSpacing, METH_VARARGS,
   "GetNonImportantPairsSpacing(self) -> float\nC++: virtual double GetNonImportantPairsSpacing()\n\n"},
  {"SetNonImportantPairsProximity", PyttkPlanarGraphLayout_SetNonImportantPairsProximity, METH_VARARGS,
   "SetNonImportantPairsProximity(self, _arg:float) -> None\nC++: virtual void SetNonImportantPairsProximity(double _arg)\n\n"},
  {"GetNonImportantPairsProximity", PyttkPlanarGraphLayout_GetNonImportantPairsProximity, METH_VARARGS,
   "GetNonImportantPairsProximity(self) -> float\nC++: virtual double GetNonImportantPairsProximity()\n\n"},
  {"SetExcludeImportantPairsLower", PyttkPlanarGraphLayout_SetExcludeImportantPairsLower, METH_VARARGS,
   "SetExcludeImportantPairsLower(self, _arg:str) -> None\nC++: virtual void SetExcludeImportantPairsLower(\n    const std::string &_arg)\n\n"},
  {"GetExcludeImportantPairsLower", PyttkPlanarGraphLayout_GetExcludeImportantPairsLower, METH_VARARGS,
   "GetExcludeImportantPairsLower(self) -> str\nC++: virtual std::string GetExcludeImportantPairsLower()\n\n"},
  {"SetExcludeImportantPairsHigher", PyttkPlanarGraphLayout_SetExcludeImportantPairsHigher, METH_VARARGS,
   "SetExcludeImportantPairsHigher(self, _arg:str) -> None\nC++: virtual void SetExcludeImportantPairsHigher(\n    const std::string &_arg)\n\n"},
  {"GetExcludeImportantPairsHigher", PyttkPlanarGraphLayout_GetExcludeImportantPairsHigher, METH_VARARGS,
   "GetExcludeImportantPairsHigher(self) -> str\nC++: virtual std::string GetExcludeImportantPairsHigher()\n\n"},
  {"IsTypeOf", PyttkPlanarGraphLayout_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkPlanarGraphLayout_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkPlanarGraphLayout_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkPlanarGraphLayout\nC++: static ttkPlanarGraphLayout *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkPlanarGraphLayout_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkPlanarGraphLayout\nC++: ttkPlanarGraphLayout *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkPlanarGraphLayout_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkPlanarGraphLayout_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkPlanarGraphLayout_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_sequences"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetUseSequences(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetUseSequences(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetUseSequences(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseSequences/SetUseSequences\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_sizes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetUseSizes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetUseSizes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetUseSizes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseSizes/SetUseSizes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_branches"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetUseBranches(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetUseBranches(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetUseBranches(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseBranches/SetUseBranches\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_levels"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetUseLevels(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetUseLevels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetUseLevels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseLevels/SetUseLevels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetOutputArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetOutputArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetOutputArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputArrayName/SetOutputArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_is_a_merge_tree"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetInputIsAMergeTree(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetInputIsAMergeTree(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetInputIsAMergeTree(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInputIsAMergeTree/SetInputIsAMergeTree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_decomposition_planar_layout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetBranchDecompositionPlanarLayout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetBranchDecompositionPlanarLayout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetBranchDecompositionPlanarLayout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchDecompositionPlanarLayout/SetBranchDecompositionPlanarLayout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetBranchSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetBranchSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetBranchSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchSpacing/SetBranchSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImportantPairs/SetImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetMaximumImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetMaximumImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetMaximumImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumImportantPairs/SetMaximumImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("minimum_important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetMinimumImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetMinimumImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetMinimumImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinimumImportantPairs/SetMinimumImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("important_pairs_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetImportantPairsSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetImportantPairsSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetImportantPairsSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImportantPairsSpacing/SetImportantPairsSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_important_pairs_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetNonImportantPairsSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetNonImportantPairsSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetNonImportantPairsSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonImportantPairsSpacing/SetNonImportantPairsSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_important_pairs_proximity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetNonImportantPairsProximity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetNonImportantPairsProximity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetNonImportantPairsProximity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonImportantPairsProximity/SetNonImportantPairsProximity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_important_pairs_lower"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetExcludeImportantPairsLower(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetExcludeImportantPairsLower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetExcludeImportantPairsLower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeImportantPairsLower/SetExcludeImportantPairsLower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_important_pairs_higher"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPlanarGraphLayout_GetExcludeImportantPairsHigher(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPlanarGraphLayout_SetExcludeImportantPairsHigher(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPlanarGraphLayout_SetExcludeImportantPairsHigher(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeImportantPairsHigher/SetExcludeImportantPairsHigher\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkPlanarGraphLayout_Doc =
  "ttkPlanarGraphLayout - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk (jl@jluk.de)\\date 01.12.2018\n\n"
  "TTK VTK-filter that computes a planar graph layout.\n\n"
  "VTK wrapping code for the ttk::PlanarGraphLayout package.\n\n"
  "This filter computes a planar graph layout of a vtkUnstructuredGrid.\n"
  "To improve the quality of the layout it is possible to pass\n"
  "additional field data to the algorithm:\n\n"
  " 1) Sequences: Points are positioned along the x-axis based on a\n"
  "sequence (e.g., time indices or scalar values). 1) \\b Sizes: Points\n"
  "cover space on the y-axis based on their size. 1) \\b Branches: Points\n"
  "with the same branch label are positioned on straight lines. 1)\n"
  "Levels: The layout of points with the same level label are computed\n"
  "individually and afterwards nested based on the level hierarchy. This\n"
  "makes it possible to draw nested graphs where each level is a layer\n"
  "of the resulting graph.\n\n"
  "Related publication:\n\n"
  "'Nested Tracking Graphs'. Jonas Lukasczyk, Gunther Weber, Ross\n"
  "Maciejewski, Christoph Garth, and Heike Leitte. Computer Graphics\n"
  "Forum (Special Issue, Proceedings Eurographics / IEEE Symposium on\n"
  "Visualization). Vol. 36. No. 3. 2017.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\param Input A vtkUnstructuredGrid that represents a graph.\n"
  "\\param Output The input vtkUnstructuredGrid with an additional point\n"
  "    data\n"
  "field that records the computed layout. Note: to project the graph\n"
  "based on the comptued layout use either the ttkProjectFromField\n"
  "filter or the \\b vtkCalculator.\n\n"
  "\\sa ttk::PlanarGraphLayout\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  >Contour Tree Alignment example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/nestedTrackingFromOverlap/\"\n"
  "  >Nested Tracking from Overlap example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkPlanarGraphLayout_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkPlanarGraphLayout.ttkPlanarGraphLayout", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkPlanarGraphLayout_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkPlanarGraphLayout_StaticNew()
{
  return ttkPlanarGraphLayout::New();
}

PyObject *PyttkPlanarGraphLayout_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkPlanarGraphLayout_Type, PyttkPlanarGraphLayout_Methods,
    "ttkPlanarGraphLayout",
 &PyttkPlanarGraphLayout_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkPlanarGraphLayout_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkPlanarGraphLayout(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkPlanarGraphLayout_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkPlanarGraphLayout", o) != 0)
  {
    Py_DECREF(o);
  }

}

