/* TeeJee.FileSystem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.FileSystem.vala, do not modify */

/*
 * TeeJee.FileSystem.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib-object.h>

#define TEE_JEE_FILE_SYSTEM_KB ((gint64) 1000)
#define TEE_JEE_FILE_SYSTEM_MB (1000 * TEE_JEE_FILE_SYSTEM_KB)
#define TEE_JEE_FILE_SYSTEM_GB (1000 * TEE_JEE_FILE_SYSTEM_MB)
#define TEE_JEE_FILE_SYSTEM_TB (1000 * TEE_JEE_FILE_SYSTEM_GB)
#define TEE_JEE_FILE_SYSTEM_KiB ((gint64) 1024)
#define TEE_JEE_FILE_SYSTEM_MiB (1024 * TEE_JEE_FILE_SYSTEM_KiB)
#define TEE_JEE_FILE_SYSTEM_GiB (1024 * TEE_JEE_FILE_SYSTEM_MiB)
#define TEE_JEE_FILE_SYSTEM_TiB (1024 * TEE_JEE_FILE_SYSTEM_GiB)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_basename (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN gchar* tee_jee_file_system_remove_trailing_slash (const gchar* path);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gint64* tee_jee_file_system_file_line_count (const gchar* file_path);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN gboolean tee_jee_file_system_dir_create (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN gboolean tee_jee_file_system_file_copy (const gchar* src_file,
                                        const gchar* dest_file);
VALA_EXTERN void tee_jee_file_system_file_move (const gchar* src_file,
                                    const gchar* dest_file);
VALA_EXTERN gboolean tee_jee_file_system_file_is_symlink (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_gzip (const gchar* src_file);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN gchar* tee_jee_file_system_file_resolve_executable_path (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_get_symlink_target (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean tee_jee_file_system_dir_empty_delete (const gchar* path);
VALA_EXTERN gboolean tee_jee_file_system_dir_delete_recursive (const gchar* dir);
VALA_EXTERN gboolean tee_jee_file_system_dir_delete (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN gboolean tee_jee_file_system_dir_is_empty (const gchar* dir_path);
VALA_EXTERN GeeArrayList* tee_jee_file_system_dir_list_names (const gchar* path);
static gint __lambda18_ (const gchar* a,
                  const gchar* b);
static gint ___lambda18__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN gboolean tee_jee_file_system_chown (const gchar* dir_path,
                                    const gchar* user,
                                    const gchar* group);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN gint tee_jee_file_system_chmod (const gchar* file,
                                const gchar* permission);

gchar*
tee_jee_file_system_file_parent (const gchar* file_path)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_file_new_for_path (file_path);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
tee_jee_file_system_file_basename (const gchar* file_path)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_file_new_for_path (file_path);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
tee_jee_file_system_path_combine (const gchar* path1,
                                  const gchar* path2)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = g_build_path ("/", path1, path2, NULL);
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
tee_jee_file_system_remove_trailing_slash (const gchar* path)
{
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	if (g_str_has_suffix (path, "/")) {
		gint _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = strlen (path);
		_tmp1_ = _tmp0_;
		_tmp2_ = string_slice (path, (glong) 0, (glong) (_tmp1_ - 1));
		result = _tmp2_;
		return result;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (path);
		result = _tmp3_;
		return result;
	}
}

gboolean
tee_jee_file_system_file_exists (const gchar* file_path)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	if (g_file_test (file_path, G_FILE_TEST_EXISTS)) {
		_tmp0_ = !g_file_test (file_path, G_FILE_TEST_IS_DIR);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
tee_jee_file_system_file_delete (const gchar* file_path)
{
	gboolean _tmp9_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_new_for_path (file_path);
		file = _tmp0_;
		_tmp1_ = file;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = file;
			g_file_delete (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
		}
		result = TRUE;
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		_tmp5_ = g_strdup_printf (": %s", file_path);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_ ("Failed to delete file"), _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_error (_tmp8_, FALSE, FALSE);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

gint64*
tee_jee_file_system_file_line_count (const gchar* file_path)
{
	GError* _inner_error0_ = NULL;
	gint64* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	{
		glong line_nums = 0L;
		gchar symbol = '\0';
		GFile* file = NULL;
		GFile* _tmp0_;
		GFileInputStream* inStream = NULL;
		GFile* _tmp1_;
		GFileInputStream* _tmp2_;
		GBufferedInputStream* bis = NULL;
		GFileInputStream* _tmp3_;
		GBufferedInputStream* _tmp4_;
		GBufferedInputStream* _tmp8_;
		gint64 _tmp9_;
		gint64* _tmp10_;
		line_nums = (glong) 0;
		_tmp0_ = g_file_new_for_path (file_path);
		file = _tmp0_;
		_tmp1_ = file;
		_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
		inStream = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp3_ = inStream;
		_tmp4_ = (GBufferedInputStream*) g_buffered_input_stream_new_sized ((GInputStream*) _tmp3_, (gsize) (1 * TEE_JEE_FILE_SYSTEM_MiB));
		bis = _tmp4_;
		while (TRUE) {
			gint _tmp5_ = 0;
			GBufferedInputStream* _tmp6_;
			_tmp6_ = bis;
			_tmp5_ = g_buffered_input_stream_read_byte (_tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (bis);
				_g_object_unref0 (inStream);
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			symbol = (gchar) _tmp5_;
			if (!(((gint) symbol) != -1)) {
				break;
			}
			if (symbol == '\n') {
				glong _tmp7_;
				_tmp7_ = line_nums;
				line_nums = _tmp7_ + 1;
			}
		}
		_tmp8_ = bis;
		g_input_stream_close ((GInputStream*) _tmp8_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (bis);
			_g_object_unref0 (inStream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp9_ = (gint64) line_nums;
		_tmp10_ = __int64_dup0 (&_tmp9_);
		result = _tmp10_;
		_g_object_unref0 (bis);
		_g_object_unref0 (inStream);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		tee_jee_logging_log_error (_tmp12_, FALSE, FALSE);
		_tmp13_ = g_strdup_printf (": %s", file_path);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_ ("Failed to read file"), _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

gchar*
tee_jee_file_system_file_read (const gchar* file_path)
{
	gchar* txt = NULL;
	gsize size = 0UL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gsize _tmp1_ = 0UL;
		g_file_get_contents (file_path, &_tmp0_, &_tmp1_, &_inner_error0_);
		_g_free0 (txt);
		txt = _tmp0_;
		size = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = txt;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		tee_jee_logging_log_error (_tmp3_, FALSE, FALSE);
		_tmp4_ = g_strdup_printf (": %s", file_path);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_ ("Failed to read file"), _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		tee_jee_logging_log_error (_tmp7_, FALSE, FALSE);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (txt);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_free0 (txt);
	return result;
}

gboolean
tee_jee_file_system_file_write (const gchar* file_path,
                                const gchar* contents)
{
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		GFile* file = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFileOutputStream* file_stream = NULL;
		GFile* _tmp5_;
		GFileOutputStream* _tmp6_;
		GDataOutputStream* data_stream = NULL;
		GFileOutputStream* _tmp7_;
		GDataOutputStream* _tmp8_;
		GDataOutputStream* _tmp9_;
		GDataOutputStream* _tmp10_;
		_tmp0_ = tee_jee_file_system_file_parent (file_path);
		_tmp1_ = _tmp0_;
		tee_jee_file_system_dir_create (_tmp1_, FALSE);
		_g_free0 (_tmp1_);
		_tmp2_ = g_file_new_for_path (file_path);
		file = _tmp2_;
		_tmp3_ = file;
		if (g_file_query_exists (_tmp3_, NULL)) {
			GFile* _tmp4_;
			_tmp4_ = file;
			g_file_delete (_tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
		}
		_tmp5_ = file;
		_tmp6_ = g_file_create (_tmp5_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		file_stream = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp7_ = file_stream;
		_tmp8_ = g_data_output_stream_new ((GOutputStream*) _tmp7_);
		data_stream = _tmp8_;
		_tmp9_ = data_stream;
		g_data_output_stream_put_string (_tmp9_, contents, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (data_stream);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp10_ = data_stream;
		g_output_stream_close ((GOutputStream*) _tmp10_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (data_stream);
			_g_object_unref0 (file_stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		result = TRUE;
		_g_object_unref0 (data_stream);
		_g_object_unref0 (file_stream);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		tee_jee_logging_log_error (_tmp12_, FALSE, FALSE);
		_tmp13_ = g_strdup_printf (": %s", file_path);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_ ("Failed to write file"), _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp17_;
}

gboolean
tee_jee_file_system_file_copy (const gchar* src_file,
                               const gchar* dest_file)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (src_file != NULL, FALSE);
	g_return_val_if_fail (dest_file != NULL, FALSE);
	{
		GFile* file_src = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_new_for_path (src_file);
		file_src = _tmp0_;
		_tmp1_ = file_src;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GFile* file_dest = NULL;
			GFile* _tmp2_;
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp2_ = g_file_new_for_path (dest_file);
			file_dest = _tmp2_;
			_tmp3_ = file_src;
			_tmp4_ = file_dest;
			g_file_copy (_tmp3_, _tmp4_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_dest);
				_g_object_unref0 (file_src);
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_object_unref0 (file_dest);
			_g_object_unref0 (file_src);
			return result;
		}
		_g_object_unref0 (file_src);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
		_tmp7_ = g_strdup_printf (": '%s', '%s'", src_file, dest_file);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_ ("Failed to copy file"), _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	result = FALSE;
	return result;
}

void
tee_jee_file_system_file_move (const gchar* src_file,
                               const gchar* dest_file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src_file != NULL);
	g_return_if_fail (dest_file != NULL);
	{
		GFile* file_src = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_new_for_path (src_file);
		file_src = _tmp0_;
		_tmp1_ = file_src;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GFile* file_dest = NULL;
			GFile* _tmp2_;
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp2_ = g_file_new_for_path (dest_file);
			file_dest = _tmp2_;
			_tmp3_ = file_src;
			_tmp4_ = file_dest;
			g_file_move (_tmp3_, _tmp4_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_dest);
				_g_object_unref0 (file_src);
				goto __catch0_g_error;
			}
			_g_object_unref0 (file_dest);
		} else {
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = g_strdup_printf (": '%s'", src_file);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat (_ ("File not found"), _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			tee_jee_logging_log_error (_tmp8_, FALSE, FALSE);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp6_);
		}
		_g_object_unref0 (file_src);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
		_tmp11_ = g_strdup_printf (": '%s', '%s'", src_file, dest_file);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_ ("Failed to move file"), _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		tee_jee_logging_log_error (_tmp14_, FALSE, FALSE);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
tee_jee_file_system_file_is_symlink (const gchar* file_path)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file_path != NULL, FALSE);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_new_for_path (file_path);
		file = _tmp0_;
		_tmp1_ = file;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GFileInfo* info = NULL;
			GFile* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			GFileInfo* _tmp5_;
			GFileInfo* _tmp6_;
			GFileType file_type = 0;
			GFileInfo* _tmp7_;
			_tmp2_ = file;
			_tmp3_ = g_strdup_printf ("%s", G_FILE_ATTRIBUTE_STANDARD_TYPE);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_file_query_info (_tmp2_, _tmp4_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			info = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp7_ = info;
			file_type = g_file_info_get_file_type (_tmp7_);
			result = file_type == G_FILE_TYPE_SYMBOLIC_LINK;
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		tee_jee_logging_log_error (_tmp9_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = FALSE;
	return result;
}

gboolean
tee_jee_file_system_file_gzip (const gchar* src_file)
{
	gchar* dst_file = NULL;
	gchar* _tmp0_;
	gchar* cmd = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean result;
	g_return_val_if_fail (src_file != NULL, FALSE);
	_tmp0_ = g_strconcat (src_file, ".gz", NULL);
	dst_file = _tmp0_;
	tee_jee_file_system_file_delete (dst_file);
	_tmp1_ = tee_jee_file_system_escape_single_quote (src_file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("gzip '%s'", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	cmd = _tmp4_;
	tee_jee_process_helper_exec_sync (cmd, &_tmp5_, &_tmp6_);
	_g_free0 (std_out);
	std_out = _tmp5_;
	_g_free0 (std_err);
	std_err = _tmp6_;
	result = tee_jee_file_system_file_exists (dst_file);
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	_g_free0 (dst_file);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
tee_jee_file_system_file_resolve_executable_path (const gchar* file_path)
{
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	if (g_str_has_prefix (file_path, "/")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (file_path);
		result = _tmp0_;
		return result;
	} else {
		if (!string_contains (file_path, "/")) {
			gchar* _tmp1_;
			_tmp1_ = g_find_program_in_path (file_path);
			result = _tmp1_;
			return result;
		} else {
			if (g_str_has_prefix (file_path, "./")) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp2_ = g_get_current_dir ();
				_tmp3_ = _tmp2_;
				_tmp4_ = strlen (file_path);
				_tmp5_ = _tmp4_;
				_tmp6_ = string_slice (file_path, (glong) 2, (glong) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = tee_jee_file_system_path_combine (_tmp3_, _tmp7_);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (_tmp3_);
				result = _tmp9_;
				return result;
			} else {
				if (g_str_has_prefix (file_path, "../")) {
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp10_ = g_get_current_dir ();
					_tmp11_ = _tmp10_;
					_tmp12_ = tee_jee_file_system_file_parent (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = strlen (file_path);
					_tmp15_ = _tmp14_;
					_tmp16_ = string_slice (file_path, (glong) 3, (glong) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = tee_jee_file_system_path_combine (_tmp13_, _tmp17_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					result = _tmp19_;
					return result;
				} else {
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp20_ = g_get_current_dir ();
					_tmp21_ = _tmp20_;
					_tmp22_ = tee_jee_file_system_path_combine (_tmp21_, file_path);
					_tmp23_ = _tmp22_;
					_g_free0 (_tmp21_);
					result = _tmp23_;
					return result;
				}
			}
		}
	}
}

gchar*
tee_jee_file_system_file_get_symlink_target (const gchar* file_path)
{
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	{
		GFileInfo* info = NULL;
		GFile* file = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_parse_name (file_path);
		file = _tmp0_;
		_tmp1_ = file;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GFileInfo* _tmp2_ = NULL;
			GFile* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp3_ = file;
			_tmp4_ = g_strdup_printf ("%s", G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_file_query_info (_tmp3_, _tmp5_, 0, NULL, &_inner_error0_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_tmp2_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			_tmp8_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (info);
			info = _tmp8_;
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_symlink_target (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (file);
			_g_object_unref0 (info);
			return result;
		}
		_g_object_unref0 (file);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		tee_jee_logging_log_error (_tmp13_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp14_ = g_strdup ("");
	result = _tmp14_;
	return result;
}

gboolean
tee_jee_file_system_dir_exists (const gchar* dir_path)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	if (g_file_test (dir_path, G_FILE_TEST_EXISTS)) {
		_tmp0_ = g_file_test (dir_path, G_FILE_TEST_IS_DIR);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
tee_jee_file_system_dir_create (const gchar* dir_path,
                                gboolean show_message)
{
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	{
		GFile* dir = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_parse_name (dir_path);
		dir = _tmp0_;
		_tmp1_ = dir;
		if (g_file_query_exists (_tmp1_, NULL) == FALSE) {
			gboolean ok = FALSE;
			GFile* _tmp2_;
			_tmp2_ = dir;
			ok = g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dir);
				goto __catch0_g_error;
			}
			if (show_message) {
				if (ok) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp3_ = g_strdup_printf (": %s", dir_path);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat (_ ("Created directory"), _tmp4_, NULL);
					_tmp6_ = _tmp5_;
					tee_jee_logging_log_msg (_tmp6_, FALSE);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
				} else {
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp7_ = g_strdup_printf (": %s", dir_path);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_ ("Failed to create directory"), _tmp8_, NULL);
					_tmp10_ = _tmp9_;
					tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
				}
			}
		}
		result = TRUE;
		_g_object_unref0 (dir);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		tee_jee_logging_log_error (_tmp12_, FALSE, FALSE);
		_tmp13_ = g_strdup_printf (": %s", dir_path);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_ ("Failed to create directory"), _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp17_;
}

gboolean
tee_jee_file_system_dir_empty_delete (const gchar* path)
{
	GFile* dirf = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	dirf = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = dirf;
		if (g_file_query_file_type (_tmp1_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY) {
			gboolean _tmp2_ = FALSE;
			GFile* _tmp3_;
			_tmp3_ = dirf;
			_tmp2_ = g_file_delete (_tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = _tmp2_;
			_g_object_unref0 (dirf);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* ioe = NULL;
		GError* _tmp4_;
		ioe = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = ioe;
		if (g_error_matches (_tmp4_, g_io_error_quark (), G_IO_ERROR_NOT_FOUND)) {
			result = TRUE;
			_g_error_free0 (ioe);
			_g_object_unref0 (dirf);
			return result;
		}
		_g_error_free0 (ioe);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		_g_object_unref0 (dirf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	_g_object_unref0 (dirf);
	return result;
}

gboolean
tee_jee_file_system_dir_delete_recursive (const gchar* dir)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dir != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (dir);
	f = _tmp0_;
	_tmp1_ = f;
	if (g_file_query_exists (_tmp1_, NULL)) {
		{
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp2_;
			GFileEnumerator* _tmp3_;
			GFileInfo* info = NULL;
			GFile* _tmp30_;
			_tmp2_ = f;
			_tmp3_ = g_file_enumerate_children (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			enumerator = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp4_ = NULL;
				GFileEnumerator* _tmp5_;
				GFileInfo* _tmp6_;
				GFileInfo* _tmp7_;
				GFileInfo* _tmp8_;
				gchar* name = NULL;
				GFileInfo* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				GFileInfo* _tmp12_;
				_tmp5_ = enumerator;
				_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					goto __catch0_g_error;
				}
				_tmp7_ = _tmp4_;
				_tmp4_ = NULL;
				_g_object_unref0 (info);
				info = _tmp7_;
				_tmp8_ = info;
				if (!(_tmp8_ != NULL)) {
					_g_object_unref0 (_tmp4_);
					break;
				}
				_tmp9_ = info;
				_tmp10_ = g_file_info_get_name (_tmp9_);
				_tmp11_ = g_strdup (_tmp10_);
				name = _tmp11_;
				_tmp12_ = info;
				if (g_file_info_get_file_type (_tmp12_) == G_FILE_TYPE_DIRECTORY) {
					gboolean _tmp13_ = FALSE;
					const gchar* _tmp14_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gboolean _tmp21_;
					_tmp14_ = name;
					if (g_strcmp0 (_tmp14_, ".") == 0) {
						_tmp13_ = TRUE;
					} else {
						const gchar* _tmp15_;
						_tmp15_ = name;
						_tmp13_ = g_strcmp0 (_tmp15_, "..") == 0;
					}
					if (_tmp13_) {
						_g_free0 (name);
						_g_object_unref0 (_tmp4_);
						continue;
					}
					_tmp16_ = g_strconcat (dir, "/", NULL);
					_tmp17_ = _tmp16_;
					_tmp18_ = name;
					_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
					_tmp20_ = _tmp19_;
					_tmp21_ = !tee_jee_file_system_dir_delete_recursive (_tmp20_);
					_g_free0 (_tmp20_);
					_g_free0 (_tmp17_);
					if (_tmp21_) {
						result = FALSE;
						_g_free0 (name);
						_g_object_unref0 (_tmp4_);
						_g_object_unref0 (info);
						_g_object_unref0 (enumerator);
						_g_object_unref0 (f);
						return result;
					}
				} else {
					GFile* file = NULL;
					gchar* _tmp22_;
					gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					GFile* _tmp27_;
					GFile* _tmp28_;
					GFile* _tmp29_;
					_tmp22_ = g_strconcat (dir, "/", NULL);
					_tmp23_ = _tmp22_;
					_tmp24_ = name;
					_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_file_new_for_path (_tmp26_);
					_tmp28_ = _tmp27_;
					_g_free0 (_tmp26_);
					_g_free0 (_tmp23_);
					file = _tmp28_;
					_tmp29_ = file;
					g_file_delete (_tmp29_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file);
						_g_free0 (name);
						_g_object_unref0 (_tmp4_);
						_g_object_unref0 (info);
						_g_object_unref0 (enumerator);
						goto __catch0_g_error;
					}
					_g_object_unref0 (file);
				}
				_g_free0 (name);
				_g_object_unref0 (_tmp4_);
			}
			_tmp30_ = f;
			g_file_delete (_tmp30_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
		}
		goto __finally0;
		__catch0_g_error:
		{
			gchar* _tmp31_;
			gchar* _tmp32_;
			g_clear_error (&_inner_error0_);
			_tmp31_ = g_strdup_printf ("Can not enumerate folder %s", dir);
			_tmp32_ = _tmp31_;
			tee_jee_logging_log_error (_tmp32_, FALSE, FALSE);
			_g_free0 (_tmp32_);
			result = FALSE;
			_g_object_unref0 (f);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp33_ = FALSE;
			_g_object_unref0 (f);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp33_;
		}
	}
	result = TRUE;
	_g_object_unref0 (f);
	return result;
}

gboolean
tee_jee_file_system_dir_delete (const gchar* dir_path,
                                gboolean show_message)
{
	gboolean status = FALSE;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	status = tee_jee_file_system_dir_delete_recursive (dir_path);
	if (show_message) {
		if (status) {
			gchar* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = g_strdup_printf (": %s", dir_path);
			_tmp1_ = _tmp0_;
			_tmp2_ = g_strconcat (_ ("Deleted directory"), _tmp1_, NULL);
			_tmp3_ = _tmp2_;
			tee_jee_logging_log_msg (_tmp3_, FALSE);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp1_);
		} else {
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = g_strdup_printf (": %s", dir_path);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_ ("Failed to delete directory"), _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			tee_jee_logging_log_error (_tmp7_, FALSE, FALSE);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
		}
	}
	result = status;
	return result;
}

gboolean
tee_jee_file_system_dir_is_empty (const gchar* dir_path)
{
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	{
		gboolean is_empty = FALSE;
		GFile* dir = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		is_empty = TRUE;
		_tmp0_ = g_file_parse_name (dir_path);
		dir = _tmp0_;
		_tmp1_ = dir;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GFileInfo* info = NULL;
			GFileEnumerator* enu = NULL;
			GFile* _tmp2_;
			GFileEnumerator* _tmp3_;
			_tmp2_ = dir;
			_tmp3_ = g_file_enumerate_children (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
			enu = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (dir);
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp4_ = NULL;
				GFileEnumerator* _tmp5_;
				GFileInfo* _tmp6_;
				GFileInfo* _tmp7_;
				GFileInfo* _tmp8_;
				_tmp5_ = enu;
				_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (enu);
					_g_object_unref0 (info);
					_g_object_unref0 (dir);
					goto __catch0_g_error;
				}
				_tmp7_ = _tmp4_;
				_tmp4_ = NULL;
				_g_object_unref0 (info);
				info = _tmp7_;
				_tmp8_ = info;
				if (!(_tmp8_ != NULL)) {
					_g_object_unref0 (_tmp4_);
					break;
				}
				is_empty = FALSE;
				_g_object_unref0 (_tmp4_);
				break;
			}
			_g_object_unref0 (enu);
			_g_object_unref0 (info);
		}
		result = is_empty;
		_g_object_unref0 (dir);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp11_;
}

static gint
__lambda18_ (const gchar* a,
             const gchar* b)
{
	GCompareFunc _tmp0_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

static gint
___lambda18__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda18_ ((const gchar*) a, (const gchar*) b);
	return result;
}

GeeArrayList*
tee_jee_file_system_dir_list_names (const gchar* path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GCompareDataFunc entry_compare = NULL;
	gpointer entry_compare_target;
	GDestroyNotify entry_compare_target_destroy_notify;
	GeeArrayList* _tmp19_;
	GCompareDataFunc _tmp20_;
	gpointer _tmp20__target;
	GDestroyNotify _tmp20__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GFile* f_home = NULL;
		GFile* _tmp1_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFileEnumerator* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileInfo* file = NULL;
		_tmp1_ = g_file_new_for_path (path);
		f_home = _tmp1_;
		_tmp2_ = f_home;
		_tmp3_ = g_strdup_printf ("%s", G_FILE_ATTRIBUTE_STANDARD_NAME);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_enumerate_children (_tmp2_, _tmp4_, 0, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		enumerator = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f_home);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp7_ = NULL;
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			gchar* name = NULL;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			GeeArrayList* _tmp15_;
			const gchar* _tmp16_;
			_tmp8_ = enumerator;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (f_home);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (file);
			file = _tmp10_;
			_tmp11_ = file;
			if (!(_tmp11_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp12_ = file;
			_tmp13_ = g_file_info_get_name (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			name = _tmp14_;
			_tmp15_ = list;
			_tmp16_ = name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			_g_free0 (name);
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (f_home);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		tee_jee_logging_log_error (_tmp18_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	entry_compare = ___lambda18__gcompare_data_func;
	entry_compare_target = NULL;
	entry_compare_target_destroy_notify = NULL;
	_tmp19_ = list;
	_tmp20_ = entry_compare;
	_tmp20__target = entry_compare_target;
	_tmp20__target_destroy_notify = entry_compare_target_destroy_notify;
	entry_compare = NULL;
	entry_compare_target = NULL;
	entry_compare_target_destroy_notify = NULL;
	gee_list_sort ((GeeList*) _tmp19_, _tmp20_, _tmp20__target, _tmp20__target_destroy_notify);
	result = list;
	(entry_compare_target_destroy_notify == NULL) ? NULL : (entry_compare_target_destroy_notify (entry_compare_target), NULL);
	entry_compare = NULL;
	entry_compare_target = NULL;
	entry_compare_target_destroy_notify = NULL;
	return result;
}

gboolean
tee_jee_file_system_chown (const gchar* dir_path,
                           const gchar* user,
                           const gchar* group)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (dir_path != NULL, FALSE);
	g_return_val_if_fail (user != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp0_ = tee_jee_file_system_escape_single_quote (dir_path);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("chown %s:%s -R '%s'", user, group, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cmd = _tmp3_;
	status = tee_jee_process_helper_exec_sync (cmd, NULL, NULL);
	result = status == 0;
	_g_free0 (cmd);
	return result;
}

gchar*
tee_jee_file_system_format_file_size (guint64 size,
                                      gboolean binary_units,
                                      const gchar* unit,
                                      gboolean show_units,
                                      gint decimals)
{
	gint _tmp0_ = 0;
	guint64 unit_k = 0ULL;
	guint64 _tmp1_ = 0ULL;
	guint64 unit_m = 0ULL;
	guint64 _tmp2_ = 0ULL;
	guint64 unit_g = 0ULL;
	guint64 _tmp3_ = 0ULL;
	guint64 unit_t = 0ULL;
	gchar* txt = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gchar* result;
	g_return_val_if_fail (unit != NULL, NULL);
	if (binary_units) {
		_tmp0_ = 1024;
	} else {
		_tmp0_ = 1000;
	}
	unit_k = (guint64) _tmp0_;
	if (binary_units) {
		_tmp1_ = 1024 * unit_k;
	} else {
		_tmp1_ = 1000 * unit_k;
	}
	unit_m = _tmp1_;
	if (binary_units) {
		_tmp2_ = 1024 * unit_m;
	} else {
		_tmp2_ = 1000 * unit_m;
	}
	unit_g = _tmp2_;
	if (binary_units) {
		_tmp3_ = 1024 * unit_g;
	} else {
		_tmp3_ = 1000 * unit_g;
	}
	unit_t = _tmp3_;
	_tmp4_ = g_strdup ("");
	txt = _tmp4_;
	if (size > unit_t) {
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (unit);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = g_strcmp0 (unit, "t") == 0;
		}
		_tmp5_ = _tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = txt;
		_tmp10_ = g_strdup_printf ("%%'0.%df", decimals);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_tmp11_, size / (1.0 * unit_t));
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
		_g_free0 (txt);
		txt = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		if (show_units) {
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			if (binary_units) {
				_tmp15_ = "Ti";
			} else {
				_tmp15_ = "T";
			}
			_tmp16_ = txt;
			_tmp17_ = g_strdup_printf (" %sB", _tmp15_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
			_g_free0 (txt);
			txt = _tmp19_;
			_g_free0 (_tmp18_);
		}
	} else {
		gboolean _tmp20_ = FALSE;
		if (size > unit_g) {
			gboolean _tmp21_ = FALSE;
			gint _tmp22_;
			gint _tmp23_;
			_tmp22_ = strlen (unit);
			_tmp23_ = _tmp22_;
			if (_tmp23_ == 0) {
				_tmp21_ = TRUE;
			} else {
				_tmp21_ = g_strcmp0 (unit, "g") == 0;
			}
			_tmp20_ = _tmp21_;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp24_ = txt;
			_tmp25_ = g_strdup_printf ("%%'0.%df", decimals);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf (_tmp26_, size / (1.0 * unit_g));
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
			_g_free0 (txt);
			txt = _tmp29_;
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			if (show_units) {
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				if (binary_units) {
					_tmp30_ = "Gi";
				} else {
					_tmp30_ = "G";
				}
				_tmp31_ = txt;
				_tmp32_ = g_strdup_printf (" %sB", _tmp30_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
				_g_free0 (txt);
				txt = _tmp34_;
				_g_free0 (_tmp33_);
			}
		} else {
			gboolean _tmp35_ = FALSE;
			if (size > unit_m) {
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				gint _tmp38_;
				_tmp37_ = strlen (unit);
				_tmp38_ = _tmp37_;
				if (_tmp38_ == 0) {
					_tmp36_ = TRUE;
				} else {
					_tmp36_ = g_strcmp0 (unit, "m") == 0;
				}
				_tmp35_ = _tmp36_;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp39_ = txt;
				_tmp40_ = g_strdup_printf ("%%'0.%df", decimals);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup_printf (_tmp41_, size / (1.0 * unit_m));
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp39_, _tmp43_, NULL);
				_g_free0 (txt);
				txt = _tmp44_;
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				if (show_units) {
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					if (binary_units) {
						_tmp45_ = "Mi";
					} else {
						_tmp45_ = "M";
					}
					_tmp46_ = txt;
					_tmp47_ = g_strdup_printf (" %sB", _tmp45_);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat (_tmp46_, _tmp48_, NULL);
					_g_free0 (txt);
					txt = _tmp49_;
					_g_free0 (_tmp48_);
				}
			} else {
				gboolean _tmp50_ = FALSE;
				if (size > unit_k) {
					gboolean _tmp51_ = FALSE;
					gint _tmp52_;
					gint _tmp53_;
					_tmp52_ = strlen (unit);
					_tmp53_ = _tmp52_;
					if (_tmp53_ == 0) {
						_tmp51_ = TRUE;
					} else {
						_tmp51_ = g_strcmp0 (unit, "k") == 0;
					}
					_tmp50_ = _tmp51_;
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					const gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					_tmp54_ = txt;
					_tmp55_ = g_strdup_printf ("%%'0.%df", decimals);
					_tmp56_ = _tmp55_;
					_tmp57_ = g_strdup_printf (_tmp56_, size / (1.0 * unit_k));
					_tmp58_ = _tmp57_;
					_tmp59_ = g_strconcat (_tmp54_, _tmp58_, NULL);
					_g_free0 (txt);
					txt = _tmp59_;
					_g_free0 (_tmp58_);
					_g_free0 (_tmp56_);
					if (show_units) {
						const gchar* _tmp60_ = NULL;
						const gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						if (binary_units) {
							_tmp60_ = "Ki";
						} else {
							_tmp60_ = "K";
						}
						_tmp61_ = txt;
						_tmp62_ = g_strdup_printf (" %sB", _tmp60_);
						_tmp63_ = _tmp62_;
						_tmp64_ = g_strconcat (_tmp61_, _tmp63_, NULL);
						_g_free0 (txt);
						txt = _tmp64_;
						_g_free0 (_tmp63_);
					}
				} else {
					const gchar* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					_tmp65_ = txt;
					_tmp66_ = g_strdup_printf ("%'0lu", size);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strconcat (_tmp65_, _tmp67_, NULL);
					_g_free0 (txt);
					txt = _tmp68_;
					_g_free0 (_tmp67_);
					if (show_units) {
						const gchar* _tmp69_;
						gchar* _tmp70_;
						_tmp69_ = txt;
						_tmp70_ = g_strconcat (_tmp69_, " B", NULL);
						_g_free0 (txt);
						txt = _tmp70_;
					}
				}
			}
		}
	}
	result = txt;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
tee_jee_file_system_escape_single_quote (const gchar* file_path)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = string_replace (file_path, "'", "'\\''");
	result = _tmp0_;
	return result;
}

gint
tee_jee_file_system_chmod (const gchar* file,
                           const gchar* permission)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (file != NULL, 0);
	g_return_val_if_fail (permission != NULL, 0);
	_tmp0_ = tee_jee_file_system_escape_single_quote (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("chmod %s '%s'", permission, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cmd = _tmp3_;
	result = tee_jee_process_helper_exec_sync (cmd, NULL, NULL);
	_g_free0 (cmd);
	return result;
}

