/**********************************************************************

Audacity: A Digital Audio Editor

NoteTrackView.h

Paul Licameli split from class NoteTrack

**********************************************************************/

#ifndef __AUDACITY_NOTE_TRACK_VIEW__
#define __AUDACITY_NOTE_TRACK_VIEW__

#include "../../../ui/CommonTrackView.h"

#ifdef EXPERIMENTAL_MIDI_STRETCHING
#include "StretchHandle.h"
#endif

class NoteTrackView final : public CommonTrackView
{
   NoteTrackView( const NoteTrackView& ) = delete;
   NoteTrackView &operator=( const NoteTrackView& ) = delete;

public:
   explicit
   NoteTrackView( const std::shared_ptr<Track> &pTrack );
   ~NoteTrackView() override;

private:
   std::shared_ptr<TrackVRulerControls> DoGetVRulerControls() override;
   std::shared_ptr<CommonTrackCell> GetAffordanceControls() override;

   std::vector<UIHandlePtr> DetailedHitTest
      (const TrackPanelMouseState &state,
       const TenacityProject *pProject, int currentTool, bool bMultiTool)
      override;

   // TrackPanelDrawable implementation
   void Draw(
      TrackPanelDrawingContext &context,
      const wxRect &rect, unsigned iPass ) override;

   std::shared_ptr<CommonTrackCell> mpAffordanceCellControl;

   #ifdef EXPERIMENTAL_MIDI_STRETCHING
   std::weak_ptr<StretchHandle> mStretchHandle;
   #endif
};
#endif
