#include "_gen/svc-misc.h"

#include <telepathy-glib/telepathy-glib.h>

static const DBusGObjectInfo _tpl_svc_logger_object_info;

struct _TplSvcLoggerClass {
    GTypeInterface parent_class;
    tpl_svc_logger_get_favourite_contacts_impl get_favourite_contacts_cb;
    tpl_svc_logger_add_favourite_contact_impl add_favourite_contact_cb;
    tpl_svc_logger_remove_favourite_contact_impl remove_favourite_contact_cb;
    tpl_svc_logger_clear_impl clear_cb;
    tpl_svc_logger_clear_account_impl clear_account_cb;
    tpl_svc_logger_clear_entity_impl clear_entity_cb;
};

enum {
    SIGNAL_LOGGER_FavouriteContactsChanged,
    N_LOGGER_SIGNALS
};
static guint logger_signals[N_LOGGER_SIGNALS] = {0};

static void tpl_svc_logger_base_init (gpointer klass);

GType
tpl_svc_logger_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TplSvcLoggerClass),
        tpl_svc_logger_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TplSvcLogger", &info, 0);
    }

  return type;
}

static void
tpl_svc_logger_get_favourite_contacts (TplSvcLogger *self,
    DBusGMethodInvocation *context)
{
  tpl_svc_logger_get_favourite_contacts_impl impl = (TPL_SVC_LOGGER_GET_CLASS (self)->get_favourite_contacts_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tpl_svc_logger_implement_get_favourite_contacts (TplSvcLoggerClass *klass, tpl_svc_logger_get_favourite_contacts_impl impl)
{
  klass->get_favourite_contacts_cb = impl;
}

static void
tpl_svc_logger_add_favourite_contact (TplSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    DBusGMethodInvocation *context)
{
  tpl_svc_logger_add_favourite_contact_impl impl = (TPL_SVC_LOGGER_GET_CLASS (self)->add_favourite_contact_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        in_Identifier,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tpl_svc_logger_implement_add_favourite_contact (TplSvcLoggerClass *klass, tpl_svc_logger_add_favourite_contact_impl impl)
{
  klass->add_favourite_contact_cb = impl;
}

static void
tpl_svc_logger_remove_favourite_contact (TplSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    DBusGMethodInvocation *context)
{
  tpl_svc_logger_remove_favourite_contact_impl impl = (TPL_SVC_LOGGER_GET_CLASS (self)->remove_favourite_contact_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        in_Identifier,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tpl_svc_logger_implement_remove_favourite_contact (TplSvcLoggerClass *klass, tpl_svc_logger_remove_favourite_contact_impl impl)
{
  klass->remove_favourite_contact_cb = impl;
}

static void
tpl_svc_logger_clear (TplSvcLogger *self,
    DBusGMethodInvocation *context)
{
  tpl_svc_logger_clear_impl impl = (TPL_SVC_LOGGER_GET_CLASS (self)->clear_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tpl_svc_logger_implement_clear (TplSvcLoggerClass *klass, tpl_svc_logger_clear_impl impl)
{
  klass->clear_cb = impl;
}

static void
tpl_svc_logger_clear_account (TplSvcLogger *self,
    const gchar *in_Account,
    DBusGMethodInvocation *context)
{
  tpl_svc_logger_clear_account_impl impl = (TPL_SVC_LOGGER_GET_CLASS (self)->clear_account_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tpl_svc_logger_implement_clear_account (TplSvcLoggerClass *klass, tpl_svc_logger_clear_account_impl impl)
{
  klass->clear_account_cb = impl;
}

static void
tpl_svc_logger_clear_entity (TplSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    gint in_Type,
    DBusGMethodInvocation *context)
{
  tpl_svc_logger_clear_entity_impl impl = (TPL_SVC_LOGGER_GET_CLASS (self)->clear_entity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        in_Identifier,
        in_Type,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tpl_svc_logger_implement_clear_entity (TplSvcLoggerClass *klass, tpl_svc_logger_clear_entity_impl impl)
{
  klass->clear_entity_cb = impl;
}

void
tpl_svc_logger_emit_favourite_contacts_changed (gpointer instance,
    const gchar *arg_Account,
    const gchar **arg_Added,
    const gchar **arg_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TPL_TYPE_SVC_LOGGER));
  g_signal_emit (instance,
      logger_signals[SIGNAL_LOGGER_FavouriteContactsChanged],
      0,
      arg_Account,
      arg_Added,
      arg_Removed);
}

static inline void
tpl_svc_logger_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (tpl_svc_logger_get_type (),
      &_tpl_svc_logger_object_info);

  logger_signals[SIGNAL_LOGGER_FavouriteContactsChanged] =
  g_signal_new ("favourite-contacts-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      3,
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRV,
      G_TYPE_STRV);

}
static void
tpl_svc_logger_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tpl_svc_logger_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tpl_svc_logger_methods[] = {
  { (GCallback) tpl_svc_logger_get_favourite_contacts, g_cclosure_marshal_generic, 0 },
  { (GCallback) tpl_svc_logger_add_favourite_contact, g_cclosure_marshal_generic, 95 },
  { (GCallback) tpl_svc_logger_remove_favourite_contact, g_cclosure_marshal_generic, 184 },
  { (GCallback) tpl_svc_logger_clear, g_cclosure_marshal_generic, 276 },
  { (GCallback) tpl_svc_logger_clear_account, g_cclosure_marshal_generic, 324 },
  { (GCallback) tpl_svc_logger_clear_entity, g_cclosure_marshal_generic, 391 },
};

static const DBusGObjectInfo _tpl_svc_logger_object_info = {
  0,
  _tpl_svc_logger_methods,
  6,
"org.freedesktop.Telepathy.Logger.DRAFT\0GetFavouriteContacts\0A\0Favourite_Contacts\0O\0F\0N\0a(oas)\0\0org.freedesktop.Telepathy.Logger.DRAFT\0AddFavouriteContact\0A\0Account\0I\0o\0Identifier\0I\0s\0\0org.freedesktop.Telepathy.Logger.DRAFT\0RemoveFavouriteContact\0A\0Account\0I\0o\0Identifier\0I\0s\0\0org.freedesktop.Telepathy.Logger.DRAFT\0Clear\0A\0\0org.freedesktop.Telepathy.Logger.DRAFT\0ClearAccount\0A\0Account\0I\0o\0\0org.freedesktop.Telepathy.Logger.DRAFT\0ClearEntity\0A\0Account\0I\0o\0Identifier\0I\0s\0Type\0I\0i\0\0\0",
"org.freedesktop.Telepathy.Logger.DRAFT\0FavouriteContactsChanged\0\0",
"\0\0",
};


