/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	resourcev1 "k8s.io/api/resource/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// DeviceClassLister helps list DeviceClasses.
// All objects returned here must be treated as read-only.
type DeviceClassLister interface {
	// List lists all DeviceClasses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*resourcev1.DeviceClass, err error)
	// Get retrieves the DeviceClass from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*resourcev1.DeviceClass, error)
	DeviceClassListerExpansion
}

// deviceClassLister implements the DeviceClassLister interface.
type deviceClassLister struct {
	listers.ResourceIndexer[*resourcev1.DeviceClass]
}

// NewDeviceClassLister returns a new DeviceClassLister.
func NewDeviceClassLister(indexer cache.Indexer) DeviceClassLister {
	return &deviceClassLister{listers.New[*resourcev1.DeviceClass](indexer, resourcev1.Resource("deviceclass"))}
}
