/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	coordinationv1beta1 "k8s.io/api/coordination/v1beta1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// LeaseCandidateLister helps list LeaseCandidates.
// All objects returned here must be treated as read-only.
type LeaseCandidateLister interface {
	// List lists all LeaseCandidates in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*coordinationv1beta1.LeaseCandidate, err error)
	// LeaseCandidates returns an object that can list and get LeaseCandidates.
	LeaseCandidates(namespace string) LeaseCandidateNamespaceLister
	LeaseCandidateListerExpansion
}

// leaseCandidateLister implements the LeaseCandidateLister interface.
type leaseCandidateLister struct {
	listers.ResourceIndexer[*coordinationv1beta1.LeaseCandidate]
}

// NewLeaseCandidateLister returns a new LeaseCandidateLister.
func NewLeaseCandidateLister(indexer cache.Indexer) LeaseCandidateLister {
	return &leaseCandidateLister{listers.New[*coordinationv1beta1.LeaseCandidate](indexer, coordinationv1beta1.Resource("leasecandidate"))}
}

// LeaseCandidates returns an object that can list and get LeaseCandidates.
func (s *leaseCandidateLister) LeaseCandidates(namespace string) LeaseCandidateNamespaceLister {
	return leaseCandidateNamespaceLister{listers.NewNamespaced[*coordinationv1beta1.LeaseCandidate](s.ResourceIndexer, namespace)}
}

// LeaseCandidateNamespaceLister helps list and get LeaseCandidates.
// All objects returned here must be treated as read-only.
type LeaseCandidateNamespaceLister interface {
	// List lists all LeaseCandidates in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*coordinationv1beta1.LeaseCandidate, err error)
	// Get retrieves the LeaseCandidate from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*coordinationv1beta1.LeaseCandidate, error)
	LeaseCandidateNamespaceListerExpansion
}

// leaseCandidateNamespaceLister implements the LeaseCandidateNamespaceLister
// interface.
type leaseCandidateNamespaceLister struct {
	listers.ResourceIndexer[*coordinationv1beta1.LeaseCandidate]
}
