/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	certificatesv1alpha1 "k8s.io/api/certificates/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PodCertificateRequestLister helps list PodCertificateRequests.
// All objects returned here must be treated as read-only.
type PodCertificateRequestLister interface {
	// List lists all PodCertificateRequests in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*certificatesv1alpha1.PodCertificateRequest, err error)
	// PodCertificateRequests returns an object that can list and get PodCertificateRequests.
	PodCertificateRequests(namespace string) PodCertificateRequestNamespaceLister
	PodCertificateRequestListerExpansion
}

// podCertificateRequestLister implements the PodCertificateRequestLister interface.
type podCertificateRequestLister struct {
	listers.ResourceIndexer[*certificatesv1alpha1.PodCertificateRequest]
}

// NewPodCertificateRequestLister returns a new PodCertificateRequestLister.
func NewPodCertificateRequestLister(indexer cache.Indexer) PodCertificateRequestLister {
	return &podCertificateRequestLister{listers.New[*certificatesv1alpha1.PodCertificateRequest](indexer, certificatesv1alpha1.Resource("podcertificaterequest"))}
}

// PodCertificateRequests returns an object that can list and get PodCertificateRequests.
func (s *podCertificateRequestLister) PodCertificateRequests(namespace string) PodCertificateRequestNamespaceLister {
	return podCertificateRequestNamespaceLister{listers.NewNamespaced[*certificatesv1alpha1.PodCertificateRequest](s.ResourceIndexer, namespace)}
}

// PodCertificateRequestNamespaceLister helps list and get PodCertificateRequests.
// All objects returned here must be treated as read-only.
type PodCertificateRequestNamespaceLister interface {
	// List lists all PodCertificateRequests in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*certificatesv1alpha1.PodCertificateRequest, err error)
	// Get retrieves the PodCertificateRequest from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*certificatesv1alpha1.PodCertificateRequest, error)
	PodCertificateRequestNamespaceListerExpansion
}

// podCertificateRequestNamespaceLister implements the PodCertificateRequestNamespaceLister
// interface.
type podCertificateRequestNamespaceLister struct {
	listers.ResourceIndexer[*certificatesv1alpha1.PodCertificateRequest]
}
