/* zeal-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from zeal-plugin.vala, do not modify */

/*
 * Copyright (C) 2015 Jérémy Munsch <jeremy.munsch@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Jérémy Munsch <jeremy.munsch@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_ZEAL_PLUGIN_0_PROPERTY,
	SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_ZEAL_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_zeal_plugin_properties[SYNAPSE_ZEAL_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseZealPluginSearchData SynapseZealPluginSearchData;
enum  {
	SYNAPSE_ZEAL_DOC_0_PROPERTY,
	SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY,
	SYNAPSE_ZEAL_DOC_NUM_PROPERTIES
};
static GParamSpec* synapse_zeal_doc_properties[SYNAPSE_ZEAL_DOC_NUM_PROPERTIES];
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _SynapseZealPluginPrivate {
	gboolean _enabled;
	GeeList* doclist;
};

struct _SynapseZealPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZealPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp7_;
	GeeList* matchers;
	SynapseQuery _tmp8_;
	const gchar* _tmp9_;
	GeeList* _tmp10_;
	GeeList* _doc_list;
	GeeList* _tmp11_;
	gint _doc_size;
	GeeList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _doc_index;
	gint _tmp15_;
	gint _tmp16_;
	SynapseZealDoc* doc;
	GeeList* _tmp17_;
	gpointer _tmp18_;
	GeeList* _matcher_list;
	GeeList* _tmp19_;
	gint _matcher_size;
	GeeList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _matcher_index;
	gint _tmp23_;
	gint _tmp24_;
	GeeMapEntry* matcher;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	GeeMapEntry* _tmp27_;
	gconstpointer _tmp28_;
	gconstpointer _tmp29_;
	SynapseZealDoc* _tmp30_;
	const gchar* _tmp31_;
	SynapseZealDoc* _tmp32_;
	SynapseQuery _tmp33_;
	const gchar* _tmp34_;
	SynapseResultSet* _tmp35_;
	SynapseZealDoc* _tmp36_;
	GeeMapEntry* _tmp37_;
	gconstpointer _tmp38_;
	gconstpointer _tmp39_;
	SynapseZealDoc* _tmp40_;
	GRegex* _tmp41_;
	SynapseQuery _tmp42_;
	const gchar* _tmp43_;
	SynapseZealDoc* _tmp44_;
	const gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gchar** part_collection;
	gint part_collection_length1;
	gint _part_collection_size_;
	gint part_it;
	gchar* _tmp48_;
	gchar* part;
	SynapseQuery _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	SynapseZealDoc* _tmp53_;
	SynapseQuery _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	SynapseResultSet* _tmp60_;
	SynapseZealDoc* _tmp61_;
	GError* _inner_error0_;
};

struct _SynapseZealDocPrivate {
	gchar* _doc_path;
	gchar* query;
	gchar* doc_name;
	gchar* version;
};

static gint SynapseZealPlugin_private_offset;
static gpointer synapse_zeal_plugin_parent_class = NULL;
static SynapseActivatableIface * synapse_zeal_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_zeal_plugin_synapse_item_provider_parent_iface = NULL;
static gint SynapseZealDoc_private_offset;
static gpointer synapse_zeal_doc_parent_class = NULL;

static void synapse_zeal_plugin_real_activate (SynapseActivatable* base);
static void synapse_zeal_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_zeal_plugin_register_plugin (void);
static void _synapse_zeal_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_zeal_plugin_real_handles_query (SynapseItemProvider* base,
                                                 SynapseQuery* query);
static void synapse_zeal_plugin_real_search_data_free (gpointer _data);
static void synapse_zeal_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* q,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean synapse_zeal_plugin_real_search_co (SynapseZealPluginSearchData* _data_);
static gboolean _synapse_zeal_plugin_real_search_co_gsource_func (gpointer self);
static void synapse_zeal_plugin_finalize (GObject * obj);
static GType synapse_zeal_plugin_get_type_once (void);
static void _vala_synapse_zeal_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_synapse_zeal_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void synapse_zeal_doc_real_do_action (SynapseActionMatch* base);
static void synapse_zeal_doc_parse_doc_name (SynapseZealDoc* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void synapse_zeal_doc_parse_doc_bundle (SynapseZealDoc* self);
static GObject * synapse_zeal_doc_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void synapse_zeal_doc_finalize (GObject * obj);
static GType synapse_zeal_doc_get_type_once (void);
static void _vala_synapse_zeal_doc_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_synapse_zeal_doc_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
synapse_zeal_plugin_get_instance_private (SynapseZealPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZealPlugin_private_offset);
}

static void
synapse_zeal_plugin_real_activate (SynapseActivatable* base)
{
	SynapseZealPlugin * self;
	gchar* docsets_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 51 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 53 "zeal-plugin.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 53 "zeal-plugin.vala"
	_tmp1_ = g_strdup_printf ("%s/Zeal/Zeal/docsets/", _tmp0_);
#line 53 "zeal-plugin.vala"
	docsets_path = _tmp1_;
#line 54 "zeal-plugin.vala"
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_ZEAL_DOC, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 54 "zeal-plugin.vala"
	_g_object_unref0 (self->priv->doclist);
#line 54 "zeal-plugin.vala"
	self->priv->doclist = (GeeList*) _tmp2_;
#line 255 "zeal-plugin.c"
	{
		GDir* dir = NULL;
		const gchar* _tmp3_;
		GDir* _tmp4_;
		gchar* name = NULL;
#line 58 "zeal-plugin.vala"
		_tmp3_ = docsets_path;
#line 58 "zeal-plugin.vala"
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error0_);
#line 58 "zeal-plugin.vala"
		dir = _tmp4_;
#line 58 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 58 "zeal-plugin.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 271 "zeal-plugin.c"
				goto __catch0_g_file_error;
			}
#line 58 "zeal-plugin.vala"
			_g_free0 (docsets_path);
#line 58 "zeal-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 58 "zeal-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 58 "zeal-plugin.vala"
			return;
#line 282 "zeal-plugin.c"
		}
#line 59 "zeal-plugin.vala"
		name = NULL;
#line 61 "zeal-plugin.vala"
		while (TRUE) {
#line 288 "zeal-plugin.c"
			GDir* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* path = NULL;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* type = NULL;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp16_;
			const gchar* _tmp19_;
			const gchar* _tmp22_;
			const gchar* _tmp25_;
			SynapseZealDoc* zdoc = NULL;
			const gchar* _tmp26_;
			SynapseZealDoc* _tmp27_;
			GeeList* _tmp28_;
			SynapseZealDoc* _tmp29_;
#line 61 "zeal-plugin.vala"
			_tmp5_ = dir;
#line 61 "zeal-plugin.vala"
			_tmp6_ = g_dir_read_name (_tmp5_);
#line 61 "zeal-plugin.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 61 "zeal-plugin.vala"
			_g_free0 (name);
#line 61 "zeal-plugin.vala"
			name = _tmp7_;
#line 61 "zeal-plugin.vala"
			_tmp8_ = name;
#line 61 "zeal-plugin.vala"
			if (!(_tmp8_ != NULL)) {
#line 61 "zeal-plugin.vala"
				break;
#line 325 "zeal-plugin.c"
			}
#line 63 "zeal-plugin.vala"
			_tmp9_ = docsets_path;
#line 63 "zeal-plugin.vala"
			_tmp10_ = name;
#line 63 "zeal-plugin.vala"
			_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
#line 63 "zeal-plugin.vala"
			path = _tmp11_;
#line 64 "zeal-plugin.vala"
			_tmp12_ = g_strdup ("");
#line 64 "zeal-plugin.vala"
			type = _tmp12_;
#line 66 "zeal-plugin.vala"
			_tmp13_ = path;
#line 66 "zeal-plugin.vala"
			if (g_file_test (_tmp13_, G_FILE_TEST_IS_REGULAR)) {
#line 343 "zeal-plugin.c"
				const gchar* _tmp14_;
				gchar* _tmp15_;
#line 67 "zeal-plugin.vala"
				_tmp14_ = type;
#line 67 "zeal-plugin.vala"
				_tmp15_ = g_strconcat (_tmp14_, "| REGULAR ", NULL);
#line 67 "zeal-plugin.vala"
				_g_free0 (type);
#line 67 "zeal-plugin.vala"
				type = _tmp15_;
#line 354 "zeal-plugin.c"
			}
#line 68 "zeal-plugin.vala"
			_tmp16_ = path;
#line 68 "zeal-plugin.vala"
			if (g_file_test (_tmp16_, G_FILE_TEST_IS_SYMLINK)) {
#line 360 "zeal-plugin.c"
				const gchar* _tmp17_;
				gchar* _tmp18_;
#line 69 "zeal-plugin.vala"
				_tmp17_ = type;
#line 69 "zeal-plugin.vala"
				_tmp18_ = g_strconcat (_tmp17_, "| SYMLINK ", NULL);
#line 69 "zeal-plugin.vala"
				_g_free0 (type);
#line 69 "zeal-plugin.vala"
				type = _tmp18_;
#line 371 "zeal-plugin.c"
			}
#line 70 "zeal-plugin.vala"
			_tmp19_ = path;
#line 70 "zeal-plugin.vala"
			if (g_file_test (_tmp19_, G_FILE_TEST_IS_DIR)) {
#line 377 "zeal-plugin.c"
				const gchar* _tmp20_;
				gchar* _tmp21_;
#line 71 "zeal-plugin.vala"
				_tmp20_ = type;
#line 71 "zeal-plugin.vala"
				_tmp21_ = g_strconcat (_tmp20_, "| DIR ", NULL);
#line 71 "zeal-plugin.vala"
				_g_free0 (type);
#line 71 "zeal-plugin.vala"
				type = _tmp21_;
#line 388 "zeal-plugin.c"
			}
#line 72 "zeal-plugin.vala"
			_tmp22_ = path;
#line 72 "zeal-plugin.vala"
			if (g_file_test (_tmp22_, G_FILE_TEST_IS_EXECUTABLE)) {
#line 394 "zeal-plugin.c"
				const gchar* _tmp23_;
				gchar* _tmp24_;
#line 73 "zeal-plugin.vala"
				_tmp23_ = type;
#line 73 "zeal-plugin.vala"
				_tmp24_ = g_strconcat (_tmp23_, "| EXECUTABLE ", NULL);
#line 73 "zeal-plugin.vala"
				_g_free0 (type);
#line 73 "zeal-plugin.vala"
				type = _tmp24_;
#line 405 "zeal-plugin.c"
			}
#line 75 "zeal-plugin.vala"
			_tmp25_ = path;
#line 75 "zeal-plugin.vala"
			if (g_strcmp0 (_tmp25_, "") == 0) {
#line 76 "zeal-plugin.vala"
				_g_free0 (type);
#line 76 "zeal-plugin.vala"
				_g_free0 (path);
#line 76 "zeal-plugin.vala"
				continue;
#line 417 "zeal-plugin.c"
			}
#line 78 "zeal-plugin.vala"
			_tmp26_ = path;
#line 78 "zeal-plugin.vala"
			_tmp27_ = synapse_zeal_doc_new (_tmp26_);
#line 78 "zeal-plugin.vala"
			zdoc = _tmp27_;
#line 79 "zeal-plugin.vala"
			_tmp28_ = self->priv->doclist;
#line 79 "zeal-plugin.vala"
			_tmp29_ = zdoc;
#line 79 "zeal-plugin.vala"
			gee_collection_add ((GeeCollection*) _tmp28_, _tmp29_);
#line 61 "zeal-plugin.vala"
			_g_object_unref0 (zdoc);
#line 61 "zeal-plugin.vala"
			_g_free0 (type);
#line 61 "zeal-plugin.vala"
			_g_free0 (path);
#line 437 "zeal-plugin.c"
		}
#line 56 "zeal-plugin.vala"
		_g_free0 (name);
#line 56 "zeal-plugin.vala"
		_g_dir_close0 (dir);
#line 443 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 56 "zeal-plugin.vala"
		e = _inner_error0_;
#line 56 "zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 84 "zeal-plugin.vala"
		_tmp30_ = e;
#line 84 "zeal-plugin.vala"
		_tmp31_ = _tmp30_->message;
#line 84 "zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:84: %s", _tmp31_);
#line 56 "zeal-plugin.vala"
		_g_error_free0 (e);
#line 463 "zeal-plugin.c"
	}
	__finally0:
#line 56 "zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "zeal-plugin.vala"
		_g_free0 (docsets_path);
#line 56 "zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 56 "zeal-plugin.vala"
		return;
#line 476 "zeal-plugin.c"
	}
#line 51 "zeal-plugin.vala"
	_g_free0 (docsets_path);
#line 480 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseZealPlugin * self;
#line 88 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 90 "zeal-plugin.vala"
	_g_object_unref0 (self->priv->doclist);
#line 90 "zeal-plugin.vala"
	self->priv->doclist = NULL;
#line 493 "zeal-plugin.c"
}

static void
_synapse_zeal_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 100 "zeal-plugin.vala"
	synapse_zeal_plugin_register_plugin ();
#line 501 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 100 "zeal-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 100 "zeal-plugin.vala"
	_tmp1_ = _tmp0_;
#line 100 "zeal-plugin.vala"
	_tmp2_ = g_find_program_in_path ("zeal");
#line 100 "zeal-plugin.vala"
	_tmp3_ = _tmp2_;
#line 100 "zeal-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_ZEAL_PLUGIN, _ ("Zeal"), _ ("Zeal offline documentation (zealdocs.org)"), "zeal", _synapse_zeal_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("zeal is not installed, please see zealdocs.org"));
#line 100 "zeal-plugin.vala"
	_g_free0 (_tmp3_);
#line 100 "zeal-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 525 "zeal-plugin.c"
}

static gboolean
synapse_zeal_plugin_real_handles_query (SynapseItemProvider* base,
                                        SynapseQuery* query)
{
	SynapseZealPlugin * self;
	gboolean _tmp0_ = FALSE;
	SynapseQuery _tmp1_;
	gboolean result;
#line 111 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 111 "zeal-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 113 "zeal-plugin.vala"
	_tmp1_ = *query;
#line 113 "zeal-plugin.vala"
	if ((_tmp1_.query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 544 "zeal-plugin.c"
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 113 "zeal-plugin.vala"
		_tmp2_ = self->priv->doclist;
#line 113 "zeal-plugin.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 113 "zeal-plugin.vala"
		_tmp4_ = _tmp3_;
#line 113 "zeal-plugin.vala"
		_tmp0_ = _tmp4_ > 0;
#line 556 "zeal-plugin.c"
	} else {
#line 113 "zeal-plugin.vala"
		_tmp0_ = FALSE;
#line 560 "zeal-plugin.c"
	}
#line 113 "zeal-plugin.vala"
	result = _tmp0_;
#line 113 "zeal-plugin.vala"
	return result;
#line 566 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_search_data_free (gpointer _data)
{
	SynapseZealPluginSearchData* _data_;
	_data_ = _data;
#line 45 "zeal-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 45 "zeal-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 45 "zeal-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 45 "zeal-plugin.vala"
	g_slice_free (SynapseZealPluginSearchData, _data_);
#line 582 "zeal-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 45 "zeal-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 590 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_search (SynapseItemProvider* base,
                                 SynapseQuery* q,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapseZealPlugin * self;
	SynapseZealPluginSearchData* _data_;
	SynapseZealPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 45 "zeal-plugin.vala"
	g_return_if_fail (q != NULL);
#line 45 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 45 "zeal-plugin.vala"
	_data_ = g_slice_new0 (SynapseZealPluginSearchData);
#line 45 "zeal-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 45 "zeal-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeal_plugin_real_search_data_free);
#line 45 "zeal-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 45 "zeal-plugin.vala"
	_data_->self = _tmp0_;
#line 45 "zeal-plugin.vala"
	_tmp1_ = *q;
#line 45 "zeal-plugin.vala"
	_tmp2_ = _tmp1_;
#line 45 "zeal-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 45 "zeal-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 45 "zeal-plugin.vala"
	_data_->q = _tmp3_;
#line 45 "zeal-plugin.vala"
	synapse_zeal_plugin_real_search_co (_data_);
#line 631 "zeal-plugin.c"
}

static SynapseResultSet*
synapse_zeal_plugin_search_finish (SynapseItemProvider* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SynapseResultSet* result;
	SynapseZealPluginSearchData* _data_;
#line 45 "zeal-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 45 "zeal-plugin.vala"
	if (NULL == _data_) {
#line 45 "zeal-plugin.vala"
		return NULL;
#line 647 "zeal-plugin.c"
	}
#line 45 "zeal-plugin.vala"
	result = _data_->result;
#line 45 "zeal-plugin.vala"
	_data_->result = NULL;
#line 45 "zeal-plugin.vala"
	return result;
#line 655 "zeal-plugin.c"
}

static gboolean
_synapse_zeal_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeal_plugin_real_search_co (self);
#line 118 "zeal-plugin.vala"
	return result;
#line 665 "zeal-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 687 "zeal-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 691 "zeal-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 697 "zeal-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 701 "zeal-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 705 "zeal-plugin.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 713 "zeal-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 741 "zeal-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 750 "zeal-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 764 "zeal-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 773 "zeal-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 787 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 796 "zeal-plugin.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 805 "zeal-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 826 "zeal-plugin.c"
}

static gboolean
synapse_zeal_plugin_real_search_co (SynapseZealPluginSearchData* _data_)
{
#line 116 "zeal-plugin.vala"
	switch (_data_->_state_) {
#line 116 "zeal-plugin.vala"
		case 0:
#line 836 "zeal-plugin.c"
		goto _state_0;
#line 116 "zeal-plugin.vala"
		case 1:
#line 840 "zeal-plugin.c"
		goto _state_1;
		default:
#line 116 "zeal-plugin.vala"
		g_assert_not_reached ();
#line 845 "zeal-plugin.c"
	}
	_state_0:
#line 118 "zeal-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_zeal_plugin_real_search_co_gsource_func, _data_, NULL);
#line 119 "zeal-plugin.vala"
	_data_->_state_ = 1;
#line 119 "zeal-plugin.vala"
	return FALSE;
#line 854 "zeal-plugin.c"
	_state_1:
	;
#line 120 "zeal-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 120 "zeal-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 120 "zeal-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 120 "zeal-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 120 "zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 120 "zeal-plugin.vala"
			return FALSE;
#line 869 "zeal-plugin.c"
		} else {
#line 120 "zeal-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 120 "zeal-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 120 "zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 120 "zeal-plugin.vala"
			return FALSE;
#line 879 "zeal-plugin.c"
		}
	}
#line 122 "zeal-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 122 "zeal-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 122 "zeal-plugin.vala"
	_data_->_tmp2_ = g_utf8_strdown (_data_->_tmp1_, (gssize) -1);
#line 122 "zeal-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 122 "zeal-plugin.vala"
	_data_->_tmp4_ = string_replace (_data_->_tmp3_, "zeal", "");
#line 122 "zeal-plugin.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 122 "zeal-plugin.vala"
	_data_->_tmp6_ = string_strip (_data_->_tmp5_);
#line 122 "zeal-plugin.vala"
	_g_free0 (_data_->q.query_string);
#line 122 "zeal-plugin.vala"
	_data_->q.query_string = _data_->_tmp6_;
#line 122 "zeal-plugin.vala"
	_g_free0 (_data_->_tmp5_);
#line 122 "zeal-plugin.vala"
	_g_free0 (_data_->_tmp3_);
#line 123 "zeal-plugin.vala"
	_data_->_tmp7_ = synapse_result_set_new ();
#line 123 "zeal-plugin.vala"
	_data_->results = _data_->_tmp7_;
#line 124 "zeal-plugin.vala"
	_data_->_tmp8_ = _data_->q;
#line 124 "zeal-plugin.vala"
	_data_->_tmp9_ = _data_->_tmp8_.query_string;
#line 124 "zeal-plugin.vala"
	_data_->_tmp10_ = synapse_query_get_matchers_for_query (_data_->_tmp9_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 124 "zeal-plugin.vala"
	_data_->matchers = _data_->_tmp10_;
#line 916 "zeal-plugin.c"
	{
#line 126 "zeal-plugin.vala"
		_data_->_tmp11_ = _data_->self->priv->doclist;
#line 126 "zeal-plugin.vala"
		_data_->_doc_list = _data_->_tmp11_;
#line 126 "zeal-plugin.vala"
		_data_->_tmp12_ = _data_->_doc_list;
#line 126 "zeal-plugin.vala"
		_data_->_tmp13_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp12_);
#line 126 "zeal-plugin.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 126 "zeal-plugin.vala"
		_data_->_doc_size = _data_->_tmp14_;
#line 126 "zeal-plugin.vala"
		_data_->_doc_index = -1;
#line 126 "zeal-plugin.vala"
		while (TRUE) {
#line 126 "zeal-plugin.vala"
			_data_->_doc_index = _data_->_doc_index + 1;
#line 126 "zeal-plugin.vala"
			_data_->_tmp15_ = _data_->_doc_index;
#line 126 "zeal-plugin.vala"
			_data_->_tmp16_ = _data_->_doc_size;
#line 126 "zeal-plugin.vala"
			if (!(_data_->_tmp15_ < _data_->_tmp16_)) {
#line 126 "zeal-plugin.vala"
				break;
#line 944 "zeal-plugin.c"
			}
#line 126 "zeal-plugin.vala"
			_data_->_tmp17_ = _data_->_doc_list;
#line 126 "zeal-plugin.vala"
			_data_->_tmp18_ = gee_list_get (_data_->_tmp17_, _data_->_doc_index);
#line 126 "zeal-plugin.vala"
			_data_->doc = (SynapseZealDoc*) _data_->_tmp18_;
#line 952 "zeal-plugin.c"
			{
#line 128 "zeal-plugin.vala"
				_data_->_tmp19_ = _data_->matchers;
#line 128 "zeal-plugin.vala"
				_data_->_matcher_list = _data_->_tmp19_;
#line 128 "zeal-plugin.vala"
				_data_->_tmp20_ = _data_->_matcher_list;
#line 128 "zeal-plugin.vala"
				_data_->_tmp21_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp20_);
#line 128 "zeal-plugin.vala"
				_data_->_tmp22_ = _data_->_tmp21_;
#line 128 "zeal-plugin.vala"
				_data_->_matcher_size = _data_->_tmp22_;
#line 128 "zeal-plugin.vala"
				_data_->_matcher_index = -1;
#line 128 "zeal-plugin.vala"
				while (TRUE) {
#line 128 "zeal-plugin.vala"
					_data_->_matcher_index = _data_->_matcher_index + 1;
#line 128 "zeal-plugin.vala"
					_data_->_tmp23_ = _data_->_matcher_index;
#line 128 "zeal-plugin.vala"
					_data_->_tmp24_ = _data_->_matcher_size;
#line 128 "zeal-plugin.vala"
					if (!(_data_->_tmp23_ < _data_->_tmp24_)) {
#line 128 "zeal-plugin.vala"
						break;
#line 980 "zeal-plugin.c"
					}
#line 128 "zeal-plugin.vala"
					_data_->_tmp25_ = _data_->_matcher_list;
#line 128 "zeal-plugin.vala"
					_data_->_tmp26_ = gee_list_get (_data_->_tmp25_, _data_->_matcher_index);
#line 128 "zeal-plugin.vala"
					_data_->matcher = (GeeMapEntry*) _data_->_tmp26_;
#line 130 "zeal-plugin.vala"
					_data_->_tmp27_ = _data_->matcher;
#line 130 "zeal-plugin.vala"
					_data_->_tmp28_ = gee_map_entry_get_key (_data_->_tmp27_);
#line 130 "zeal-plugin.vala"
					_data_->_tmp29_ = _data_->_tmp28_;
#line 130 "zeal-plugin.vala"
					_data_->_tmp30_ = _data_->doc;
#line 130 "zeal-plugin.vala"
					_data_->_tmp31_ = _data_->_tmp30_->scf_bundle_name;
#line 130 "zeal-plugin.vala"
					if (g_regex_match ((GRegex*) _data_->_tmp29_, _data_->_tmp31_, 0, NULL)) {
#line 132 "zeal-plugin.vala"
						_data_->_tmp32_ = _data_->doc;
#line 132 "zeal-plugin.vala"
						_data_->_tmp33_ = _data_->q;
#line 132 "zeal-plugin.vala"
						_data_->_tmp34_ = _data_->_tmp33_.query_string;
#line 132 "zeal-plugin.vala"
						synapse_zeal_doc_update_title (_data_->_tmp32_, _data_->_tmp34_);
#line 133 "zeal-plugin.vala"
						_data_->_tmp35_ = _data_->results;
#line 133 "zeal-plugin.vala"
						_data_->_tmp36_ = _data_->doc;
#line 133 "zeal-plugin.vala"
						_data_->_tmp37_ = _data_->matcher;
#line 133 "zeal-plugin.vala"
						_data_->_tmp38_ = gee_map_entry_get_value (_data_->_tmp37_);
#line 133 "zeal-plugin.vala"
						_data_->_tmp39_ = _data_->_tmp38_;
#line 133 "zeal-plugin.vala"
						synapse_result_set_add (_data_->_tmp35_, (SynapseMatch*) _data_->_tmp36_, (gint) ((gintptr) _data_->_tmp39_));
#line 1020 "zeal-plugin.c"
					}
#line 128 "zeal-plugin.vala"
					_g_object_unref0 (_data_->matcher);
#line 1024 "zeal-plugin.c"
				}
			}
#line 137 "zeal-plugin.vala"
			_data_->_tmp40_ = _data_->doc;
#line 137 "zeal-plugin.vala"
			_data_->_tmp41_ = _data_->_tmp40_->regex;
#line 137 "zeal-plugin.vala"
			_data_->_tmp42_ = _data_->q;
#line 137 "zeal-plugin.vala"
			_data_->_tmp43_ = _data_->_tmp42_.query_string;
#line 137 "zeal-plugin.vala"
			if (g_regex_match (_data_->_tmp41_, _data_->_tmp43_, 0, NULL)) {
#line 139 "zeal-plugin.vala"
				_data_->_tmp44_ = _data_->doc;
#line 139 "zeal-plugin.vala"
				_data_->_tmp45_ = _data_->_tmp44_->scf_bundle_name;
#line 139 "zeal-plugin.vala"
				_data_->_tmp47_ = _data_->_tmp46_ = g_strsplit_set (_data_->_tmp45_, "_ ", 0);
#line 1043 "zeal-plugin.c"
				{
#line 139 "zeal-plugin.vala"
					_data_->part_collection_length1 = 0;
#line 139 "zeal-plugin.vala"
					_data_->_part_collection_size_ = 0;
#line 139 "zeal-plugin.vala"
					_data_->part_collection = _data_->_tmp47_;
#line 139 "zeal-plugin.vala"
					_data_->part_collection_length1 = _vala_array_length (_data_->_tmp46_);
#line 139 "zeal-plugin.vala"
					for (_data_->part_it = 0; _data_->part_it < _data_->part_collection_length1; _data_->part_it = _data_->part_it + 1) {
#line 139 "zeal-plugin.vala"
						_data_->_tmp48_ = g_strdup (_data_->part_collection[_data_->part_it]);
#line 139 "zeal-plugin.vala"
						_data_->part = _data_->_tmp48_;
#line 1059 "zeal-plugin.c"
						{
#line 140 "zeal-plugin.vala"
							_data_->_tmp49_ = _data_->q;
#line 140 "zeal-plugin.vala"
							_data_->_tmp50_ = _data_->_tmp49_.query_string;
#line 140 "zeal-plugin.vala"
							_data_->_tmp51_ = _data_->part;
#line 140 "zeal-plugin.vala"
							_data_->_tmp52_ = synapse_zeal_doc_replace_first_occurence (_data_->_tmp50_, _data_->_tmp51_, "");
#line 140 "zeal-plugin.vala"
							_g_free0 (_data_->q.query_string);
#line 140 "zeal-plugin.vala"
							_data_->q.query_string = _data_->_tmp52_;
#line 139 "zeal-plugin.vala"
							_g_free0 (_data_->part);
#line 1075 "zeal-plugin.c"
						}
					}
#line 139 "zeal-plugin.vala"
					_data_->part_collection = (_vala_array_free (_data_->part_collection, _data_->part_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1080 "zeal-plugin.c"
				}
#line 141 "zeal-plugin.vala"
				_data_->_tmp53_ = _data_->doc;
#line 141 "zeal-plugin.vala"
				_data_->_tmp54_ = _data_->q;
#line 141 "zeal-plugin.vala"
				_data_->_tmp55_ = _data_->_tmp54_.query_string;
#line 141 "zeal-plugin.vala"
				_data_->_tmp56_ = string_replace (_data_->_tmp55_, ":", "");
#line 141 "zeal-plugin.vala"
				_data_->_tmp57_ = _data_->_tmp56_;
#line 141 "zeal-plugin.vala"
				_data_->_tmp58_ = string_strip (_data_->_tmp57_);
#line 141 "zeal-plugin.vala"
				_data_->_tmp59_ = _data_->_tmp58_;
#line 141 "zeal-plugin.vala"
				synapse_zeal_doc_update_title (_data_->_tmp53_, _data_->_tmp59_);
#line 141 "zeal-plugin.vala"
				_g_free0 (_data_->_tmp59_);
#line 141 "zeal-plugin.vala"
				_g_free0 (_data_->_tmp57_);
#line 142 "zeal-plugin.vala"
				_data_->_tmp60_ = _data_->results;
#line 142 "zeal-plugin.vala"
				_data_->_tmp61_ = _data_->doc;
#line 142 "zeal-plugin.vala"
				synapse_result_set_add (_data_->_tmp60_, (SynapseMatch*) _data_->_tmp61_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 143 "zeal-plugin.vala"
				_g_object_unref0 (_data_->doc);
#line 143 "zeal-plugin.vala"
				break;
#line 1112 "zeal-plugin.c"
			}
#line 126 "zeal-plugin.vala"
			_g_object_unref0 (_data_->doc);
#line 1116 "zeal-plugin.c"
		}
	}
#line 147 "zeal-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 147 "zeal-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 147 "zeal-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 147 "zeal-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 147 "zeal-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 147 "zeal-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 147 "zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 147 "zeal-plugin.vala"
			return FALSE;
#line 1135 "zeal-plugin.c"
		} else {
#line 147 "zeal-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 147 "zeal-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 147 "zeal-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 147 "zeal-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 147 "zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 147 "zeal-plugin.vala"
			return FALSE;
#line 1149 "zeal-plugin.c"
		}
	}
#line 148 "zeal-plugin.vala"
	_data_->result = _data_->results;
#line 148 "zeal-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 148 "zeal-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 148 "zeal-plugin.vala"
	if (_data_->_state_ != 0) {
#line 148 "zeal-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 148 "zeal-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1164 "zeal-plugin.c"
		}
	}
#line 148 "zeal-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 148 "zeal-plugin.vala"
	return FALSE;
#line 1171 "zeal-plugin.c"
}

SynapseZealPlugin*
synapse_zeal_plugin_construct (GType object_type)
{
	SynapseZealPlugin * self = NULL;
#line 45 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) g_object_new (object_type, NULL);
#line 45 "zeal-plugin.vala"
	return self;
#line 1182 "zeal-plugin.c"
}

SynapseZealPlugin*
synapse_zeal_plugin_new (void)
{
#line 45 "zeal-plugin.vala"
	return synapse_zeal_plugin_construct (SYNAPSE_TYPE_ZEAL_PLUGIN);
#line 1190 "zeal-plugin.c"
}

static gboolean
synapse_zeal_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseZealPlugin* self;
#line 47 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 47 "zeal-plugin.vala"
	result = self->priv->_enabled;
#line 47 "zeal-plugin.vala"
	return result;
#line 1204 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_set_enabled (SynapseActivatable* base,
                                      gboolean value)
{
	SynapseZealPlugin* self;
	gboolean old_value;
#line 47 "zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 47 "zeal-plugin.vala"
	old_value = synapse_zeal_plugin_real_get_enabled (base);
#line 47 "zeal-plugin.vala"
	if (old_value != value) {
#line 47 "zeal-plugin.vala"
		self->priv->_enabled = value;
#line 47 "zeal-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeal_plugin_properties[SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY]);
#line 1223 "zeal-plugin.c"
	}
}

static void
synapse_zeal_plugin_class_init (SynapseZealPluginClass * klass,
                                gpointer klass_data)
{
#line 45 "zeal-plugin.vala"
	synapse_zeal_plugin_parent_class = g_type_class_peek_parent (klass);
#line 45 "zeal-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZealPlugin_private_offset);
#line 45 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeal_plugin_get_property;
#line 45 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeal_plugin_set_property;
#line 45 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeal_plugin_finalize;
#line 45 "zeal-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY, synapse_zeal_plugin_properties[SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 95 "zeal-plugin.vala"
	synapse_zeal_plugin_register_plugin ();
#line 1245 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                        gpointer iface_data)
{
#line 45 "zeal-plugin.vala"
	synapse_zeal_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 45 "zeal-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_zeal_plugin_real_activate;
#line 45 "zeal-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_zeal_plugin_real_deactivate;
#line 45 "zeal-plugin.vala"
	iface->get_enabled = synapse_zeal_plugin_real_get_enabled;
#line 45 "zeal-plugin.vala"
	iface->set_enabled = synapse_zeal_plugin_real_set_enabled;
#line 1262 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                          gpointer iface_data)
{
#line 45 "zeal-plugin.vala"
	synapse_zeal_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 45 "zeal-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_zeal_plugin_real_handles_query;
#line 45 "zeal-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_zeal_plugin_real_search;
#line 45 "zeal-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_zeal_plugin_search_finish;
#line 1277 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_instance_init (SynapseZealPlugin * self,
                                   gpointer klass)
{
#line 45 "zeal-plugin.vala"
	self->priv = synapse_zeal_plugin_get_instance_private (self);
#line 47 "zeal-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1288 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_finalize (GObject * obj)
{
	SynapseZealPlugin * self;
#line 45 "zeal-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin);
#line 49 "zeal-plugin.vala"
	_g_object_unref0 (self->priv->doclist);
#line 45 "zeal-plugin.vala"
	G_OBJECT_CLASS (synapse_zeal_plugin_parent_class)->finalize (obj);
#line 1301 "zeal-plugin.c"
}

/**
   * This plugin looks for zeal installed documentations
   * then it allows you to make a query on a specified doc
   * It supports queries like :
   * zeal php:php
   * or
   * zeal php constant
   * zeal php:constant
   * php constant
   * php magic constant
   * php magic constant zeal
   * php :  magic constant zeal
   *
   * and so it searches "php:magic constants" in zeal by opening it.
   * It handles complicated doc names like Apache_HTTP_Server "apache license"
   * "server license" "http license" these 3 result in "apache http server:license"
   *
   * An update would consist to aggregate the sqlite databases
   * and show results directly or develop a CLI update to zeal
   * directly.
   */
static GType
synapse_zeal_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZealPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeal_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZealPlugin), 0, (GInstanceInitFunc) synapse_zeal_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeal_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_zeal_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeal_plugin_type_id;
	synapse_zeal_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZealPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeal_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_zeal_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseZealPlugin_private_offset = g_type_add_instance_private (synapse_zeal_plugin_type_id, sizeof (SynapseZealPluginPrivate));
	return synapse_zeal_plugin_type_id;
}

GType
synapse_zeal_plugin_get_type (void)
{
	static volatile gsize synapse_zeal_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeal_plugin_type_id__once)) {
		GType synapse_zeal_plugin_type_id;
		synapse_zeal_plugin_type_id = synapse_zeal_plugin_get_type_once ();
		g_once_init_leave (&synapse_zeal_plugin_type_id__once, synapse_zeal_plugin_type_id);
	}
	return synapse_zeal_plugin_type_id__once;
}

static void
_vala_synapse_zeal_plugin_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapseZealPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin);
#line 45 "zeal-plugin.vala"
	switch (property_id) {
#line 45 "zeal-plugin.vala"
		case SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY:
#line 45 "zeal-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 45 "zeal-plugin.vala"
		break;
#line 1367 "zeal-plugin.c"
		default:
#line 45 "zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "zeal-plugin.vala"
		break;
#line 1373 "zeal-plugin.c"
	}
}

static void
_vala_synapse_zeal_plugin_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapseZealPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin);
#line 45 "zeal-plugin.vala"
	switch (property_id) {
#line 45 "zeal-plugin.vala"
		case SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY:
#line 45 "zeal-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 45 "zeal-plugin.vala"
		break;
#line 1393 "zeal-plugin.c"
		default:
#line 45 "zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "zeal-plugin.vala"
		break;
#line 1399 "zeal-plugin.c"
	}
}

static inline gpointer
synapse_zeal_doc_get_instance_private (SynapseZealDoc* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZealDoc_private_offset);
}

SynapseZealDoc*
synapse_zeal_doc_construct (GType object_type,
                            const gchar* doc_path)
{
	SynapseZealDoc * self = NULL;
#line 163 "zeal-plugin.vala"
	g_return_val_if_fail (doc_path != NULL, NULL);
#line 165 "zeal-plugin.vala"
	self = (SynapseZealDoc*) g_object_new (object_type, "title", "Zeal Doc", "description", _ ("Zeal documentation research"), "icon-name", "zeal", "has-thumbnail", FALSE, "doc-path", doc_path, NULL);
#line 163 "zeal-plugin.vala"
	return self;
#line 1420 "zeal-plugin.c"
}

SynapseZealDoc*
synapse_zeal_doc_new (const gchar* doc_path)
{
#line 163 "zeal-plugin.vala"
	return synapse_zeal_doc_construct (SYNAPSE_TYPE_ZEAL_DOC, doc_path);
#line 1428 "zeal-plugin.c"
}

static void
synapse_zeal_doc_real_do_action (SynapseActionMatch* base)
{
	SynapseZealDoc * self;
	GError* _inner_error0_ = NULL;
#line 190 "zeal-plugin.vala"
	self = (SynapseZealDoc*) base;
#line 1438 "zeal-plugin.c"
	{
		GAppInfo* ai = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp6_;
#line 194 "zeal-plugin.vala"
		_tmp0_ = self->scf_bundle_name;
#line 194 "zeal-plugin.vala"
		_tmp1_ = self->priv->query;
#line 194 "zeal-plugin.vala"
		_tmp2_ = g_strdup_printf ("zeal \"%s:%s\"", _tmp0_, _tmp1_);
#line 194 "zeal-plugin.vala"
		_tmp3_ = _tmp2_;
#line 194 "zeal-plugin.vala"
		_tmp4_ = g_app_info_create_from_commandline (_tmp3_, "zeal", 0, &_inner_error0_);
#line 194 "zeal-plugin.vala"
		_tmp5_ = _tmp4_;
#line 194 "zeal-plugin.vala"
		_g_free0 (_tmp3_);
#line 194 "zeal-plugin.vala"
		ai = _tmp5_;
#line 194 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1466 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 195 "zeal-plugin.vala"
		_tmp6_ = ai;
#line 195 "zeal-plugin.vala"
		g_app_info_launch (_tmp6_, NULL, NULL, &_inner_error0_);
#line 195 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "zeal-plugin.vala"
			_g_object_unref0 (ai);
#line 1477 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 192 "zeal-plugin.vala"
		_g_object_unref0 (ai);
#line 1482 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 192 "zeal-plugin.vala"
		err = _inner_error0_;
#line 192 "zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 199 "zeal-plugin.vala"
		_tmp7_ = err;
#line 199 "zeal-plugin.vala"
		_tmp8_ = _tmp7_->message;
#line 199 "zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:199: Could not launch zeal %s", _tmp8_);
#line 192 "zeal-plugin.vala"
		_g_error_free0 (err);
#line 1502 "zeal-plugin.c"
	}
	__finally0:
#line 192 "zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 192 "zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 192 "zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 192 "zeal-plugin.vala"
		return;
#line 1513 "zeal-plugin.c"
	}
}

void
synapse_zeal_doc_update_title (SynapseZealDoc* self,
                               const gchar* query)
{
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* version = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 203 "zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 203 "zeal-plugin.vala"
	g_return_if_fail (query != NULL);
#line 205 "zeal-plugin.vala"
	_tmp0_ = g_strdup (query);
#line 205 "zeal-plugin.vala"
	_g_free0 (self->priv->query);
#line 205 "zeal-plugin.vala"
	self->priv->query = _tmp0_;
#line 206 "zeal-plugin.vala"
	_tmp2_ = self->priv->version;
#line 206 "zeal-plugin.vala"
	if (_tmp2_ != NULL) {
#line 1543 "zeal-plugin.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 206 "zeal-plugin.vala"
		_tmp3_ = self->priv->version;
#line 206 "zeal-plugin.vala"
		_tmp4_ = g_strdup_printf (" (v%s)", _tmp3_);
#line 206 "zeal-plugin.vala"
		_g_free0 (_tmp1_);
#line 206 "zeal-plugin.vala"
		_tmp1_ = _tmp4_;
#line 1554 "zeal-plugin.c"
	} else {
		gchar* _tmp5_;
#line 206 "zeal-plugin.vala"
		_tmp5_ = g_strdup ("");
#line 206 "zeal-plugin.vala"
		_g_free0 (_tmp1_);
#line 206 "zeal-plugin.vala"
		_tmp1_ = _tmp5_;
#line 1563 "zeal-plugin.c"
	}
#line 206 "zeal-plugin.vala"
	_tmp6_ = g_strdup (_tmp1_);
#line 206 "zeal-plugin.vala"
	version = _tmp6_;
#line 207 "zeal-plugin.vala"
	_tmp7_ = self->priv->doc_name;
#line 207 "zeal-plugin.vala"
	_tmp8_ = g_strdup_printf ("Search for %s in %s%s", query, _tmp7_, version);
#line 207 "zeal-plugin.vala"
	_tmp9_ = _tmp8_;
#line 207 "zeal-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp9_);
#line 207 "zeal-plugin.vala"
	_g_free0 (_tmp9_);
#line 203 "zeal-plugin.vala"
	_g_free0 (version);
#line 203 "zeal-plugin.vala"
	_g_free0 (_tmp1_);
#line 1583 "zeal-plugin.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1607 "zeal-plugin.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1615 "zeal-plugin.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1621 "zeal-plugin.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 1645 "zeal-plugin.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 1654 "zeal-plugin.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1673 "zeal-plugin.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1677 "zeal-plugin.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1683 "zeal-plugin.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1693 "zeal-plugin.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1701 "zeal-plugin.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1705 "zeal-plugin.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 1711 "zeal-plugin.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 1721 "zeal-plugin.c"
}

gchar*
synapse_zeal_doc_replace_first_occurence (const gchar* str,
                                          const gchar* search,
                                          const gchar* replace)
{
	gint pos = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
#line 210 "zeal-plugin.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 210 "zeal-plugin.vala"
	g_return_val_if_fail (search != NULL, NULL);
#line 210 "zeal-plugin.vala"
	g_return_val_if_fail (replace != NULL, NULL);
#line 212 "zeal-plugin.vala"
	pos = string_index_of (str, search, 0);
#line 213 "zeal-plugin.vala"
	if (pos < 0) {
#line 1751 "zeal-plugin.c"
		gchar* _tmp0_;
#line 214 "zeal-plugin.vala"
		_tmp0_ = g_strdup (str);
#line 214 "zeal-plugin.vala"
		result = _tmp0_;
#line 214 "zeal-plugin.vala"
		return result;
#line 1759 "zeal-plugin.c"
	}
#line 215 "zeal-plugin.vala"
	_tmp1_ = string_substring (str, (glong) 0, (glong) pos);
#line 215 "zeal-plugin.vala"
	_tmp2_ = _tmp1_;
#line 215 "zeal-plugin.vala"
	_tmp3_ = g_strconcat (_tmp2_, replace, NULL);
#line 215 "zeal-plugin.vala"
	_tmp4_ = _tmp3_;
#line 215 "zeal-plugin.vala"
	_tmp5_ = strlen (search);
#line 215 "zeal-plugin.vala"
	_tmp6_ = _tmp5_;
#line 215 "zeal-plugin.vala"
	_tmp7_ = string_substring (str, (glong) (pos + _tmp6_), (glong) -1);
#line 215 "zeal-plugin.vala"
	_tmp8_ = _tmp7_;
#line 215 "zeal-plugin.vala"
	_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
#line 215 "zeal-plugin.vala"
	_tmp10_ = _tmp9_;
#line 215 "zeal-plugin.vala"
	_g_free0 (_tmp8_);
#line 215 "zeal-plugin.vala"
	_g_free0 (_tmp4_);
#line 215 "zeal-plugin.vala"
	_g_free0 (_tmp2_);
#line 215 "zeal-plugin.vala"
	result = _tmp10_;
#line 215 "zeal-plugin.vala"
	return result;
#line 1791 "zeal-plugin.c"
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
#line 229 "zeal-plugin.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 1799 "zeal-plugin.c"
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
#line 229 "zeal-plugin.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 1807 "zeal-plugin.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 232 "zeal-plugin.vala"
	g_boxed_free (json_node_get_type (), self);
#line 1815 "zeal-plugin.c"
}

static void
synapse_zeal_doc_parse_doc_name (SynapseZealDoc* self)
{
	gchar* data = NULL;
	GError* _inner_error0_ = NULL;
#line 218 "zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 1825 "zeal-plugin.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		JsonParser* parser = NULL;
		JsonParser* _tmp4_;
		gboolean _tmp5_ = FALSE;
		JsonParser* _tmp6_;
		const gchar* _tmp7_;
#line 224 "zeal-plugin.vala"
		_tmp0_ = self->priv->_doc_path;
#line 224 "zeal-plugin.vala"
		_tmp1_ = g_strconcat (_tmp0_, "/meta.json", NULL);
#line 224 "zeal-plugin.vala"
		_tmp2_ = _tmp1_;
#line 224 "zeal-plugin.vala"
		g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
#line 224 "zeal-plugin.vala"
		_g_free0 (data);
#line 224 "zeal-plugin.vala"
		data = _tmp3_;
#line 224 "zeal-plugin.vala"
		_g_free0 (_tmp2_);
#line 224 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1852 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 225 "zeal-plugin.vala"
		_tmp4_ = json_parser_new ();
#line 225 "zeal-plugin.vala"
		parser = _tmp4_;
#line 227 "zeal-plugin.vala"
		_tmp6_ = parser;
#line 227 "zeal-plugin.vala"
		_tmp7_ = data;
#line 227 "zeal-plugin.vala"
		_tmp5_ = json_parser_load_from_data (_tmp6_, _tmp7_, (gssize) -1, &_inner_error0_);
#line 227 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 227 "zeal-plugin.vala"
			_g_object_unref0 (parser);
#line 1869 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 227 "zeal-plugin.vala"
		if (_tmp5_) {
#line 1874 "zeal-plugin.c"
			JsonNode* node = NULL;
			JsonParser* _tmp8_;
			JsonNode* _tmp9_;
			JsonNode* _tmp10_;
			JsonNode* _tmp11_;
			JsonObject* obj = NULL;
			JsonNode* _tmp15_;
			JsonObject* _tmp16_;
			JsonObject* _tmp17_;
			GList* _tmp18_;
#line 229 "zeal-plugin.vala"
			_tmp8_ = parser;
#line 229 "zeal-plugin.vala"
			_tmp9_ = json_parser_get_root (_tmp8_);
#line 229 "zeal-plugin.vala"
			_tmp10_ = __vala_JsonNode_copy0 (_tmp9_);
#line 229 "zeal-plugin.vala"
			node = _tmp10_;
#line 231 "zeal-plugin.vala"
			_tmp11_ = node;
#line 231 "zeal-plugin.vala"
			if (json_node_get_node_type (_tmp11_) != JSON_NODE_OBJECT) {
#line 1897 "zeal-plugin.c"
				JsonNode* _tmp12_;
				const gchar* _tmp13_;
				GError* _tmp14_;
#line 232 "zeal-plugin.vala"
				_tmp12_ = node;
#line 232 "zeal-plugin.vala"
				_tmp13_ = json_node_type_name (_tmp12_);
#line 232 "zeal-plugin.vala"
				_tmp14_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unexpected element type %s", _tmp13_);
#line 232 "zeal-plugin.vala"
				_inner_error0_ = _tmp14_;
#line 232 "zeal-plugin.vala"
				__vala_JsonNode_free0 (node);
#line 232 "zeal-plugin.vala"
				_g_object_unref0 (parser);
#line 1913 "zeal-plugin.c"
				goto __catch0_g_error;
			}
#line 234 "zeal-plugin.vala"
			_tmp15_ = node;
#line 234 "zeal-plugin.vala"
			_tmp16_ = json_node_get_object (_tmp15_);
#line 234 "zeal-plugin.vala"
			obj = _tmp16_;
#line 235 "zeal-plugin.vala"
			_tmp17_ = obj;
#line 235 "zeal-plugin.vala"
			_tmp18_ = json_object_get_members (_tmp17_);
#line 1926 "zeal-plugin.c"
			{
				GList* name_collection = NULL;
				GList* name_it = NULL;
#line 235 "zeal-plugin.vala"
				name_collection = _tmp18_;
#line 235 "zeal-plugin.vala"
				for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
#line 1934 "zeal-plugin.c"
					const gchar* name = NULL;
#line 235 "zeal-plugin.vala"
					name = (const gchar*) name_it->data;
#line 1938 "zeal-plugin.c"
					{
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						GQuark _tmp22_ = 0U;
#line 237 "zeal-plugin.vala"
						static GQuark _tmp21_label0 = 0;
#line 237 "zeal-plugin.vala"
						static GQuark _tmp21_label1 = 0;
#line 237 "zeal-plugin.vala"
						_tmp19_ = name;
#line 237 "zeal-plugin.vala"
						_tmp20_ = _tmp19_;
#line 237 "zeal-plugin.vala"
						_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
#line 237 "zeal-plugin.vala"
						if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("version")))) {
#line 237 "zeal-plugin.vala"
							switch (0) {
#line 1957 "zeal-plugin.c"
								default:
								{
									JsonNode* item = NULL;
									JsonObject* _tmp23_;
									const gchar* _tmp24_;
									JsonNode* _tmp25_;
									JsonNode* _tmp26_;
									JsonObject* _tmp30_;
									const gchar* _tmp31_;
									gchar* _tmp32_;
#line 240 "zeal-plugin.vala"
									_tmp23_ = obj;
#line 240 "zeal-plugin.vala"
									_tmp24_ = name;
#line 240 "zeal-plugin.vala"
									_tmp25_ = json_object_get_member (_tmp23_, _tmp24_);
#line 240 "zeal-plugin.vala"
									item = _tmp25_;
#line 241 "zeal-plugin.vala"
									_tmp26_ = item;
#line 241 "zeal-plugin.vala"
									if (json_node_get_node_type (_tmp26_) != JSON_NODE_VALUE) {
#line 1980 "zeal-plugin.c"
										JsonNode* _tmp27_;
										const gchar* _tmp28_;
										GError* _tmp29_;
#line 242 "zeal-plugin.vala"
										_tmp27_ = item;
#line 242 "zeal-plugin.vala"
										_tmp28_ = json_node_type_name (_tmp27_);
#line 242 "zeal-plugin.vala"
										_tmp29_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unexpected element type %s", _tmp28_);
#line 242 "zeal-plugin.vala"
										_inner_error0_ = _tmp29_;
#line 242 "zeal-plugin.vala"
										(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
#line 242 "zeal-plugin.vala"
										__vala_JsonNode_free0 (node);
#line 242 "zeal-plugin.vala"
										_g_object_unref0 (parser);
#line 1998 "zeal-plugin.c"
										goto __catch0_g_error;
									}
#line 243 "zeal-plugin.vala"
									_tmp30_ = obj;
#line 243 "zeal-plugin.vala"
									_tmp31_ = json_object_get_string_member (_tmp30_, "version");
#line 243 "zeal-plugin.vala"
									_tmp32_ = g_strdup (_tmp31_);
#line 243 "zeal-plugin.vala"
									_g_free0 (self->priv->version);
#line 243 "zeal-plugin.vala"
									self->priv->version = _tmp32_;
#line 244 "zeal-plugin.vala"
									break;
#line 2013 "zeal-plugin.c"
								}
							}
						} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("name")))) {
#line 237 "zeal-plugin.vala"
							switch (0) {
#line 2019 "zeal-plugin.c"
								default:
								{
									JsonNode* item = NULL;
									JsonObject* _tmp33_;
									const gchar* _tmp34_;
									JsonNode* _tmp35_;
									JsonNode* _tmp36_;
									JsonObject* _tmp40_;
									const gchar* _tmp41_;
									gchar* _tmp42_;
#line 247 "zeal-plugin.vala"
									_tmp33_ = obj;
#line 247 "zeal-plugin.vala"
									_tmp34_ = name;
#line 247 "zeal-plugin.vala"
									_tmp35_ = json_object_get_member (_tmp33_, _tmp34_);
#line 247 "zeal-plugin.vala"
									item = _tmp35_;
#line 248 "zeal-plugin.vala"
									_tmp36_ = item;
#line 248 "zeal-plugin.vala"
									if (json_node_get_node_type (_tmp36_) != JSON_NODE_VALUE) {
#line 2042 "zeal-plugin.c"
										JsonNode* _tmp37_;
										const gchar* _tmp38_;
										GError* _tmp39_;
#line 249 "zeal-plugin.vala"
										_tmp37_ = item;
#line 249 "zeal-plugin.vala"
										_tmp38_ = json_node_type_name (_tmp37_);
#line 249 "zeal-plugin.vala"
										_tmp39_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unexpected element type %s", _tmp38_);
#line 249 "zeal-plugin.vala"
										_inner_error0_ = _tmp39_;
#line 249 "zeal-plugin.vala"
										(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
#line 249 "zeal-plugin.vala"
										__vala_JsonNode_free0 (node);
#line 249 "zeal-plugin.vala"
										_g_object_unref0 (parser);
#line 2060 "zeal-plugin.c"
										goto __catch0_g_error;
									}
#line 250 "zeal-plugin.vala"
									_tmp40_ = obj;
#line 250 "zeal-plugin.vala"
									_tmp41_ = json_object_get_string_member (_tmp40_, "name");
#line 250 "zeal-plugin.vala"
									_tmp42_ = g_strdup (_tmp41_);
#line 250 "zeal-plugin.vala"
									_g_free0 (self->priv->doc_name);
#line 250 "zeal-plugin.vala"
									self->priv->doc_name = _tmp42_;
#line 251 "zeal-plugin.vala"
									break;
#line 2075 "zeal-plugin.c"
								}
							}
						}
					}
				}
#line 235 "zeal-plugin.vala"
				(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
#line 2083 "zeal-plugin.c"
			}
#line 227 "zeal-plugin.vala"
			__vala_JsonNode_free0 (node);
#line 2087 "zeal-plugin.c"
		} else {
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			GError* _tmp46_;
			GError* _tmp47_;
#line 257 "zeal-plugin.vala"
			_tmp43_ = self->priv->_doc_path;
#line 257 "zeal-plugin.vala"
			_tmp44_ = g_strconcat (_tmp43_, "/meta.json", NULL);
#line 257 "zeal-plugin.vala"
			_tmp45_ = _tmp44_;
#line 257 "zeal-plugin.vala"
			_tmp46_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unable to parse data form %s", _tmp45_);
#line 257 "zeal-plugin.vala"
			_tmp47_ = _tmp46_;
#line 257 "zeal-plugin.vala"
			_g_free0 (_tmp45_);
#line 257 "zeal-plugin.vala"
			_inner_error0_ = _tmp47_;
#line 257 "zeal-plugin.vala"
			_g_object_unref0 (parser);
#line 2110 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 222 "zeal-plugin.vala"
		_g_object_unref0 (parser);
#line 2115 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
#line 222 "zeal-plugin.vala"
		e = _inner_error0_;
#line 222 "zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 262 "zeal-plugin.vala"
		_tmp48_ = e;
#line 262 "zeal-plugin.vala"
		_tmp49_ = _tmp48_->message;
#line 262 "zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:262: %s", _tmp49_);
#line 222 "zeal-plugin.vala"
		_g_error_free0 (e);
#line 2135 "zeal-plugin.c"
	}
	__finally0:
#line 222 "zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 222 "zeal-plugin.vala"
		_g_free0 (data);
#line 222 "zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 222 "zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 222 "zeal-plugin.vala"
		return;
#line 2148 "zeal-plugin.c"
	}
#line 218 "zeal-plugin.vala"
	_g_free0 (data);
#line 2152 "zeal-plugin.c"
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
#line 269 "zeal-plugin.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 269 "zeal-plugin.vala"
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
#line 269 "zeal-plugin.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 2166 "zeal-plugin.c"
	}
#line 269 "zeal-plugin.vala"
	return *re;
#line 2170 "zeal-plugin.c"
}

static gpointer
_g_regex_ref0 (gpointer self)
{
#line 269 "zeal-plugin.vala"
	return self ? g_regex_ref (self) : NULL;
#line 2178 "zeal-plugin.c"
}

static void
synapse_zeal_doc_parse_doc_bundle (SynapseZealDoc* self)
{
	gchar* contents = NULL;
	GRegex* exp = NULL;
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 266 "zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 269 "zeal-plugin.vala"
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\<key\\>([a-zA-Z0-9 _-]+)\\<\\/key\\>[\\n\\t ]*\\<string\\>([a-zA-Z0-9\\. _-]+)\\<\\/string\\>", 0));
#line 269 "zeal-plugin.vala"
	exp = _tmp0_;
#line 2194 "zeal-plugin.c"
	{
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
#line 273 "zeal-plugin.vala"
		_tmp1_ = self->priv->_doc_path;
#line 273 "zeal-plugin.vala"
		_tmp2_ = g_strconcat (_tmp1_, "/Contents/Info.plist", NULL);
#line 273 "zeal-plugin.vala"
		_tmp3_ = _tmp2_;
#line 273 "zeal-plugin.vala"
		g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
#line 273 "zeal-plugin.vala"
		_g_free0 (contents);
#line 273 "zeal-plugin.vala"
		contents = _tmp4_;
#line 273 "zeal-plugin.vala"
		_g_free0 (_tmp3_);
#line 273 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2216 "zeal-plugin.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 271 "zeal-plugin.vala"
		e = _inner_error0_;
#line 271 "zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 277 "zeal-plugin.vala"
		_tmp5_ = e;
#line 277 "zeal-plugin.vala"
		_tmp6_ = _tmp5_->message;
#line 277 "zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:277: Unable to read file: %s", _tmp6_);
#line 271 "zeal-plugin.vala"
		_g_error_free0 (e);
#line 2238 "zeal-plugin.c"
	}
	__finally0:
#line 271 "zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 271 "zeal-plugin.vala"
		_g_regex_unref0 (exp);
#line 271 "zeal-plugin.vala"
		_g_free0 (contents);
#line 271 "zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 271 "zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 271 "zeal-plugin.vala"
		return;
#line 2253 "zeal-plugin.c"
	}
	{
		GMatchInfo* mi = NULL;
		{
			GRegex* _tmp7_;
			const gchar* _tmp8_;
			GMatchInfo* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
#line 283 "zeal-plugin.vala"
			_tmp7_ = exp;
#line 283 "zeal-plugin.vala"
			_tmp8_ = contents;
#line 283 "zeal-plugin.vala"
			g_regex_match (_tmp7_, _tmp8_, 0, &_tmp9_);
#line 283 "zeal-plugin.vala"
			_g_match_info_unref0 (mi);
#line 283 "zeal-plugin.vala"
			mi = _tmp9_;
#line 283 "zeal-plugin.vala"
			_tmp10_ = TRUE;
#line 283 "zeal-plugin.vala"
			while (TRUE) {
#line 2276 "zeal-plugin.c"
				GMatchInfo* _tmp12_;
				GMatchInfo* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GQuark _tmp17_ = 0U;
#line 285 "zeal-plugin.vala"
				static GQuark _tmp16_label0 = 0;
#line 285 "zeal-plugin.vala"
				static GQuark _tmp16_label1 = 0;
#line 283 "zeal-plugin.vala"
				if (!_tmp10_) {
#line 2288 "zeal-plugin.c"
					GMatchInfo* _tmp11_;
#line 283 "zeal-plugin.vala"
					_tmp11_ = mi;
#line 283 "zeal-plugin.vala"
					g_match_info_next (_tmp11_, &_inner_error0_);
#line 283 "zeal-plugin.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 283 "zeal-plugin.vala"
						_g_match_info_unref0 (mi);
#line 2298 "zeal-plugin.c"
						goto __catch1_g_error;
					}
				}
#line 283 "zeal-plugin.vala"
				_tmp10_ = FALSE;
#line 283 "zeal-plugin.vala"
				_tmp12_ = mi;
#line 283 "zeal-plugin.vala"
				if (!g_match_info_matches (_tmp12_)) {
#line 283 "zeal-plugin.vala"
					break;
#line 2310 "zeal-plugin.c"
				}
#line 285 "zeal-plugin.vala"
				_tmp13_ = mi;
#line 285 "zeal-plugin.vala"
				_tmp14_ = g_match_info_fetch (_tmp13_, 1);
#line 285 "zeal-plugin.vala"
				_tmp15_ = _tmp14_;
#line 285 "zeal-plugin.vala"
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
#line 285 "zeal-plugin.vala"
				g_free (_tmp15_);
#line 285 "zeal-plugin.vala"
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("CFBundleIdentifier")))) {
#line 285 "zeal-plugin.vala"
					switch (0) {
#line 2326 "zeal-plugin.c"
						default:
						{
							GMatchInfo* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
#line 288 "zeal-plugin.vala"
							_tmp18_ = mi;
#line 288 "zeal-plugin.vala"
							_tmp19_ = g_match_info_fetch (_tmp18_, 2);
#line 288 "zeal-plugin.vala"
							_tmp20_ = _tmp19_;
#line 288 "zeal-plugin.vala"
							_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
#line 288 "zeal-plugin.vala"
							_g_free0 (self->scf_bundle_identifier);
#line 288 "zeal-plugin.vala"
							self->scf_bundle_identifier = _tmp21_;
#line 288 "zeal-plugin.vala"
							_g_free0 (_tmp20_);
#line 289 "zeal-plugin.vala"
							break;
#line 2349 "zeal-plugin.c"
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("CFBundleName")))) {
#line 285 "zeal-plugin.vala"
					switch (0) {
#line 2355 "zeal-plugin.c"
						default:
						{
							GMatchInfo* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
#line 291 "zeal-plugin.vala"
							_tmp22_ = mi;
#line 291 "zeal-plugin.vala"
							_tmp23_ = g_match_info_fetch (_tmp22_, 2);
#line 291 "zeal-plugin.vala"
							_tmp24_ = _tmp23_;
#line 291 "zeal-plugin.vala"
							_tmp25_ = g_utf8_strdown (_tmp24_, (gssize) -1);
#line 291 "zeal-plugin.vala"
							_g_free0 (self->scf_bundle_name);
#line 291 "zeal-plugin.vala"
							self->scf_bundle_name = _tmp25_;
#line 291 "zeal-plugin.vala"
							_g_free0 (_tmp24_);
#line 292 "zeal-plugin.vala"
							break;
#line 2378 "zeal-plugin.c"
						}
					}
				}
			}
		}
#line 280 "zeal-plugin.vala"
		_g_match_info_unref0 (mi);
#line 2386 "zeal-plugin.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
#line 280 "zeal-plugin.vala"
		e = _inner_error0_;
#line 280 "zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 298 "zeal-plugin.vala"
		_tmp26_ = e;
#line 298 "zeal-plugin.vala"
		_tmp27_ = _tmp26_->message;
#line 298 "zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:298: Regex failed: %s", _tmp27_);
#line 280 "zeal-plugin.vala"
		_g_error_free0 (e);
#line 2406 "zeal-plugin.c"
	}
	__finally1:
#line 280 "zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 280 "zeal-plugin.vala"
		_g_regex_unref0 (exp);
#line 280 "zeal-plugin.vala"
		_g_free0 (contents);
#line 280 "zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 280 "zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 280 "zeal-plugin.vala"
		return;
#line 2421 "zeal-plugin.c"
	}
#line 266 "zeal-plugin.vala"
	_g_regex_unref0 (exp);
#line 266 "zeal-plugin.vala"
	_g_free0 (contents);
#line 2427 "zeal-plugin.c"
}

const gchar*
synapse_zeal_doc_get_doc_path (SynapseZealDoc* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 154 "zeal-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 154 "zeal-plugin.vala"
	_tmp0_ = self->priv->_doc_path;
#line 154 "zeal-plugin.vala"
	result = _tmp0_;
#line 154 "zeal-plugin.vala"
	return result;
#line 2443 "zeal-plugin.c"
}

static void
synapse_zeal_doc_set_doc_path (SynapseZealDoc* self,
                               const gchar* value)
{
	gchar* old_value;
#line 154 "zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 154 "zeal-plugin.vala"
	old_value = synapse_zeal_doc_get_doc_path (self);
#line 154 "zeal-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2457 "zeal-plugin.c"
		gchar* _tmp0_;
#line 154 "zeal-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 154 "zeal-plugin.vala"
		_g_free0 (self->priv->_doc_path);
#line 154 "zeal-plugin.vala"
		self->priv->_doc_path = _tmp0_;
#line 154 "zeal-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeal_doc_properties[SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY]);
#line 2467 "zeal-plugin.c"
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 2482 "zeal-plugin.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 2486 "zeal-plugin.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 2492 "zeal-plugin.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 2497 "zeal-plugin.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 2503 "zeal-plugin.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 2507 "zeal-plugin.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 2511 "zeal-plugin.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 2515 "zeal-plugin.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2519 "zeal-plugin.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 2523 "zeal-plugin.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 2538 "zeal-plugin.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 2547 "zeal-plugin.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 2554 "zeal-plugin.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 2560 "zeal-plugin.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 2568 "zeal-plugin.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 2572 "zeal-plugin.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 2578 "zeal-plugin.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 2583 "zeal-plugin.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 2589 "zeal-plugin.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 2593 "zeal-plugin.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 2597 "zeal-plugin.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 2603 "zeal-plugin.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 2609 "zeal-plugin.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 2621 "zeal-plugin.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 2625 "zeal-plugin.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 2629 "zeal-plugin.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 2634 "zeal-plugin.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 2642 "zeal-plugin.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 2660 "zeal-plugin.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 2666 "zeal-plugin.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 2670 "zeal-plugin.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 2678 "zeal-plugin.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 2687 "zeal-plugin.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 2696 "zeal-plugin.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 2702 "zeal-plugin.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 2710 "zeal-plugin.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 2722 "zeal-plugin.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 2728 "zeal-plugin.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 2732 "zeal-plugin.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 2740 "zeal-plugin.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 2751 "zeal-plugin.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 2760 "zeal-plugin.c"
	}
}

static GObject *
synapse_zeal_doc_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZealDoc * self;
	GError* _inner_error0_ = NULL;
#line 174 "zeal-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_zeal_doc_parent_class);
#line 174 "zeal-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 174 "zeal-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 176 "zeal-plugin.vala"
	synapse_zeal_doc_parse_doc_name (self);
#line 177 "zeal-plugin.vala"
	synapse_zeal_doc_parse_doc_bundle (self);
#line 2783 "zeal-plugin.c"
	{
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
#line 181 "zeal-plugin.vala"
		_tmp1_ = self->scf_bundle_name;
#line 181 "zeal-plugin.vala"
		_tmp3_ = _tmp2_ = g_strsplit_set (_tmp1_, "_ ", 0);
#line 181 "zeal-plugin.vala"
		_tmp4_ = _tmp3_;
#line 181 "zeal-plugin.vala"
		_tmp4__length1 = _vala_array_length (_tmp2_);
#line 181 "zeal-plugin.vala"
		_tmp5_ = _vala_g_strjoinv ("|", _tmp4_, (gint) _vala_array_length (_tmp2_));
#line 181 "zeal-plugin.vala"
		_tmp6_ = _tmp5_;
#line 181 "zeal-plugin.vala"
		_tmp7_ = g_strdup_printf ("^(%s)[ :]+([a-z0-9 -_.:;,]*)", _tmp6_);
#line 181 "zeal-plugin.vala"
		_tmp8_ = _tmp7_;
#line 181 "zeal-plugin.vala"
		_tmp9_ = g_regex_new (_tmp8_, G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 181 "zeal-plugin.vala"
		_tmp10_ = _tmp9_;
#line 181 "zeal-plugin.vala"
		_g_free0 (_tmp8_);
#line 181 "zeal-plugin.vala"
		_g_free0 (_tmp6_);
#line 181 "zeal-plugin.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 181 "zeal-plugin.vala"
		_tmp0_ = _tmp10_;
#line 181 "zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "zeal-plugin.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2830 "zeal-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 181 "zeal-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "zeal-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 2837 "zeal-plugin.c"
		}
#line 181 "zeal-plugin.vala"
		_tmp11_ = _tmp0_;
#line 181 "zeal-plugin.vala"
		_tmp0_ = NULL;
#line 181 "zeal-plugin.vala"
		_g_regex_unref0 (self->regex);
#line 181 "zeal-plugin.vala"
		self->regex = _tmp11_;
#line 179 "zeal-plugin.vala"
		_g_regex_unref0 (_tmp0_);
#line 2849 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 179 "zeal-plugin.vala"
		e = _inner_error0_;
#line 179 "zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 185 "zeal-plugin.vala"
		_g_regex_unref0 (self->regex);
#line 185 "zeal-plugin.vala"
		self->regex = NULL;
#line 186 "zeal-plugin.vala"
		_tmp12_ = e;
#line 186 "zeal-plugin.vala"
		_tmp13_ = _tmp12_->message;
#line 186 "zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:186: regex error %s", _tmp13_);
#line 179 "zeal-plugin.vala"
		_g_error_free0 (e);
#line 2873 "zeal-plugin.c"
	}
	__finally0:
#line 179 "zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 179 "zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 179 "zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 2882 "zeal-plugin.c"
	}
#line 174 "zeal-plugin.vala"
	return obj;
#line 2886 "zeal-plugin.c"
}

static void
synapse_zeal_doc_class_init (SynapseZealDocClass * klass,
                             gpointer klass_data)
{
#line 152 "zeal-plugin.vala"
	synapse_zeal_doc_parent_class = g_type_class_peek_parent (klass);
#line 152 "zeal-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZealDoc_private_offset);
#line 152 "zeal-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_zeal_doc_real_do_action;
#line 152 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeal_doc_get_property;
#line 152 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeal_doc_set_property;
#line 152 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_zeal_doc_constructor;
#line 152 "zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeal_doc_finalize;
#line 152 "zeal-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY, synapse_zeal_doc_properties[SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY] = g_param_spec_string ("doc-path", "doc-path", "doc-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2909 "zeal-plugin.c"
}

static void
synapse_zeal_doc_instance_init (SynapseZealDoc * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 152 "zeal-plugin.vala"
	self->priv = synapse_zeal_doc_get_instance_private (self);
#line 156 "zeal-plugin.vala"
	_tmp0_ = g_strdup ("");
#line 156 "zeal-plugin.vala"
	self->priv->query = _tmp0_;
#line 157 "zeal-plugin.vala"
	_tmp1_ = g_strdup ("");
#line 157 "zeal-plugin.vala"
	self->priv->doc_name = _tmp1_;
#line 158 "zeal-plugin.vala"
	_tmp2_ = g_strdup ("");
#line 158 "zeal-plugin.vala"
	self->scf_bundle_identifier = _tmp2_;
#line 159 "zeal-plugin.vala"
	_tmp3_ = g_strdup ("");
#line 159 "zeal-plugin.vala"
	self->scf_bundle_name = _tmp3_;
#line 2938 "zeal-plugin.c"
}

static void
synapse_zeal_doc_finalize (GObject * obj)
{
	SynapseZealDoc * self;
#line 152 "zeal-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 154 "zeal-plugin.vala"
	_g_free0 (self->priv->_doc_path);
#line 156 "zeal-plugin.vala"
	_g_free0 (self->priv->query);
#line 157 "zeal-plugin.vala"
	_g_free0 (self->priv->doc_name);
#line 158 "zeal-plugin.vala"
	_g_free0 (self->scf_bundle_identifier);
#line 159 "zeal-plugin.vala"
	_g_free0 (self->scf_bundle_name);
#line 160 "zeal-plugin.vala"
	_g_regex_unref0 (self->regex);
#line 161 "zeal-plugin.vala"
	_g_free0 (self->priv->version);
#line 152 "zeal-plugin.vala"
	G_OBJECT_CLASS (synapse_zeal_doc_parent_class)->finalize (obj);
#line 2963 "zeal-plugin.c"
}

static GType
synapse_zeal_doc_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZealDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeal_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZealDoc), 0, (GInstanceInitFunc) synapse_zeal_doc_instance_init, NULL };
	GType synapse_zeal_doc_type_id;
	synapse_zeal_doc_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapseZealDoc", &g_define_type_info, 0);
	SynapseZealDoc_private_offset = g_type_add_instance_private (synapse_zeal_doc_type_id, sizeof (SynapseZealDocPrivate));
	return synapse_zeal_doc_type_id;
}

GType
synapse_zeal_doc_get_type (void)
{
	static volatile gsize synapse_zeal_doc_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeal_doc_type_id__once)) {
		GType synapse_zeal_doc_type_id;
		synapse_zeal_doc_type_id = synapse_zeal_doc_get_type_once ();
		g_once_init_leave (&synapse_zeal_doc_type_id__once, synapse_zeal_doc_type_id);
	}
	return synapse_zeal_doc_type_id__once;
}

static void
_vala_synapse_zeal_doc_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SynapseZealDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 152 "zeal-plugin.vala"
	switch (property_id) {
#line 152 "zeal-plugin.vala"
		case SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY:
#line 152 "zeal-plugin.vala"
		g_value_set_string (value, synapse_zeal_doc_get_doc_path (self));
#line 152 "zeal-plugin.vala"
		break;
#line 3004 "zeal-plugin.c"
		default:
#line 152 "zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 152 "zeal-plugin.vala"
		break;
#line 3010 "zeal-plugin.c"
	}
}

static void
_vala_synapse_zeal_doc_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SynapseZealDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 152 "zeal-plugin.vala"
	switch (property_id) {
#line 152 "zeal-plugin.vala"
		case SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY:
#line 152 "zeal-plugin.vala"
		synapse_zeal_doc_set_doc_path (self, g_value_get_string (value));
#line 152 "zeal-plugin.vala"
		break;
#line 3030 "zeal-plugin.c"
		default:
#line 152 "zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 152 "zeal-plugin.vala"
		break;
#line 3036 "zeal-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "pastebin-plugin.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3047 "zeal-plugin.c"
		gssize i;
#line 24 "pastebin-plugin.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "pastebin-plugin.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "pastebin-plugin.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3055 "zeal-plugin.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "pastebin-plugin.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "pastebin-plugin.vala"
	g_free (array);
#line 3070 "zeal-plugin.c"
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
#line 24 "pastebin-plugin.vala"
	if (array) {
#line 24 "pastebin-plugin.vala"
		while (((gpointer*) array)[length]) {
#line 24 "pastebin-plugin.vala"
			length++;
#line 3084 "zeal-plugin.c"
		}
	}
#line 24 "pastebin-plugin.vala"
	return length;
#line 3089 "zeal-plugin.c"
}

