/* command-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from command-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <synapse-core.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_COMMAND_PLUGIN_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT (synapse_command_plugin_command_object_get_type ())
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))

typedef struct _SynapseCommandPluginCommandObject SynapseCommandPluginCommandObject;
typedef struct _SynapseCommandPluginCommandObjectClass SynapseCommandPluginCommandObjectClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseCommandPluginSearchData SynapseCommandPluginSearchData;
typedef struct _SynapseCommandPluginCommandObjectPrivate SynapseCommandPluginCommandObjectPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseCommandPluginPrivate {
	gboolean _enabled;
	GeeSet* past_commands;
	GRegex* split_regex;
};

struct _SynapseCommandPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCommandPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp1_;
	gchar* stripped;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GeeSet* _tmp10_;
	const gchar* _tmp11_;
	GeeIterator* _command_it;
	GeeSet* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	gchar* command;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	SynapseResultSet* _tmp19_;
	const gchar* _tmp20_;
	SynapseCommandPluginCommandObject* _tmp21_;
	SynapseCommandPluginCommandObject* _tmp22_;
	gchar** args;
	GRegex* _tmp23_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint args_length1;
	gint _args_size_;
	gchar* valid_cmd;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_;
	SynapseCommandPluginCommandObject* co;
	const gchar* _tmp33_;
	SynapseCommandPluginCommandObject* _tmp34_;
	SynapseCommandPluginCommandObject* _tmp35_;
	SynapseResultSet* _tmp36_;
	SynapseCommandPluginCommandObject* _tmp37_;
	SynapseCommandPluginCommandObject* _tmp38_;
	SynapseResultSet* _tmp39_;
	const gchar* _tmp40_;
	SynapseCommandPluginCommandObject* _tmp41_;
	SynapseCommandPluginCommandObject* _tmp42_;
	GError* _inner_error0_;
};

struct _SynapseCommandPluginCommandObject {
	SynapseApplicationMatch parent_instance;
	SynapseCommandPluginCommandObjectPrivate * priv;
};

struct _SynapseCommandPluginCommandObjectClass {
	SynapseApplicationMatchClass parent_class;
};

struct _SynapseCommandPluginCommandObjectPrivate {
	gchar* _command;
};

static gint SynapseCommandPlugin_private_offset;
static gpointer synapse_command_plugin_parent_class = NULL;
static gint SynapseCommandPluginCommandObject_private_offset;
static gpointer synapse_command_plugin_command_object_parent_class = NULL;
static SynapseActivatableIface * synapse_command_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_command_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_command_plugin_real_activate (SynapseActivatable* base);
static void synapse_command_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_command_plugin_register_plugin (void);
static void _synapse_command_plugin_register_plugin_synapse_plugin_register_func (void);
static GType synapse_command_plugin_command_object_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                                                     const gchar* exec);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type,
                                                                                    const gchar* cmd);
static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                              SynapseMatch* match);
static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self);
static void synapse_command_plugin_real_search_data_free (gpointer _data);
static void synapse_command_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_);
static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self);
static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                      gpointer self);
static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                        const gchar* value);
static void synapse_command_plugin_command_object_finalize (GObject * obj);
static GType synapse_command_plugin_command_object_get_type_once (void);
static void _vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static GObject * synapse_command_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_command_plugin_finalize (GObject * obj);
static GType synapse_command_plugin_get_type_once (void);
static void _vala_synapse_command_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_command_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_command_plugin_get_instance_private (SynapseCommandPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPlugin_private_offset);
}

static void
synapse_command_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
#line 28 "command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 232 "command-plugin.c"
}

static void
synapse_command_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
#line 33 "command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 241 "command-plugin.c"
}

static void
_synapse_command_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 61 "command-plugin.vala"
	synapse_command_plugin_register_plugin ();
#line 249 "command-plugin.c"
}

static void
synapse_command_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 61 "command-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 61 "command-plugin.vala"
	_tmp1_ = _tmp0_;
#line 61 "command-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_COMMAND_PLUGIN, "Command Search", _ ("Find and execute arbitrary commands."), "system-run", _synapse_command_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 61 "command-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 265 "command-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 103 "command-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 273 "command-plugin.c"
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                  const gchar* exec)
{
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp0_;
	GeeList* df_list = NULL;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	SynapseDesktopFileInfo* dfi = NULL;
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp16_;
	SynapseDesktopFileInfo* _tmp17_;
	SynapseCommandPluginCommandObject* result;
#line 92 "command-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "command-plugin.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 97 "command-plugin.vala"
	_tmp0_ = synapse_desktop_file_service_get_default ();
#line 97 "command-plugin.vala"
	dfs = _tmp0_;
#line 98 "command-plugin.vala"
	_tmp1_ = dfs;
#line 98 "command-plugin.vala"
	_tmp2_ = synapse_desktop_file_service_get_desktop_files_for_exec (_tmp1_, exec);
#line 98 "command-plugin.vala"
	df_list = _tmp2_;
#line 99 "command-plugin.vala"
	dfi = NULL;
#line 306 "command-plugin.c"
	{
		GeeList* _df_list = NULL;
		GeeList* _tmp3_;
		gint _df_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _df_index = 0;
#line 100 "command-plugin.vala"
		_tmp3_ = df_list;
#line 100 "command-plugin.vala"
		_df_list = _tmp3_;
#line 100 "command-plugin.vala"
		_tmp4_ = _df_list;
#line 100 "command-plugin.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 100 "command-plugin.vala"
		_tmp6_ = _tmp5_;
#line 100 "command-plugin.vala"
		_df_size = _tmp6_;
#line 100 "command-plugin.vala"
		_df_index = -1;
#line 100 "command-plugin.vala"
		while (TRUE) {
#line 331 "command-plugin.c"
			gint _tmp7_;
			gint _tmp8_;
			SynapseDesktopFileInfo* df = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			SynapseDesktopFileInfo* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			SynapseDesktopFileInfo* _tmp14_;
			SynapseDesktopFileInfo* _tmp15_;
#line 100 "command-plugin.vala"
			_df_index = _df_index + 1;
#line 100 "command-plugin.vala"
			_tmp7_ = _df_index;
#line 100 "command-plugin.vala"
			_tmp8_ = _df_size;
#line 100 "command-plugin.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 100 "command-plugin.vala"
				break;
#line 352 "command-plugin.c"
			}
#line 100 "command-plugin.vala"
			_tmp9_ = _df_list;
#line 100 "command-plugin.vala"
			_tmp10_ = gee_list_get (_tmp9_, _df_index);
#line 100 "command-plugin.vala"
			df = (SynapseDesktopFileInfo*) _tmp10_;
#line 102 "command-plugin.vala"
			_tmp11_ = df;
#line 102 "command-plugin.vala"
			_tmp12_ = synapse_desktop_file_info_get_is_hidden (_tmp11_);
#line 102 "command-plugin.vala"
			_tmp13_ = _tmp12_;
#line 102 "command-plugin.vala"
			if (!_tmp13_) {
#line 102 "command-plugin.vala"
				result = NULL;
#line 102 "command-plugin.vala"
				_g_object_unref0 (df);
#line 102 "command-plugin.vala"
				_g_object_unref0 (dfi);
#line 102 "command-plugin.vala"
				_g_object_unref0 (df_list);
#line 102 "command-plugin.vala"
				_g_object_unref0 (dfs);
#line 102 "command-plugin.vala"
				return result;
#line 380 "command-plugin.c"
			}
#line 103 "command-plugin.vala"
			_tmp14_ = df;
#line 103 "command-plugin.vala"
			_tmp15_ = _g_object_ref0 (_tmp14_);
#line 103 "command-plugin.vala"
			_g_object_unref0 (dfi);
#line 103 "command-plugin.vala"
			dfi = _tmp15_;
#line 100 "command-plugin.vala"
			_g_object_unref0 (df);
#line 392 "command-plugin.c"
		}
	}
#line 106 "command-plugin.vala"
	_tmp16_ = synapse_command_plugin_command_object_new (exec);
#line 106 "command-plugin.vala"
	co = _tmp16_;
#line 107 "command-plugin.vala"
	_tmp17_ = dfi;
#line 107 "command-plugin.vala"
	if (_tmp17_ != NULL) {
#line 403 "command-plugin.c"
		SynapseCommandPluginCommandObject* _tmp18_;
		SynapseDesktopFileInfo* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		SynapseDesktopFileInfo* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp29_ = FALSE;
		SynapseDesktopFileInfo* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
#line 109 "command-plugin.vala"
		_tmp18_ = co;
#line 109 "command-plugin.vala"
		_tmp19_ = dfi;
#line 109 "command-plugin.vala"
		_tmp20_ = synapse_desktop_file_info_get_name (_tmp19_);
#line 109 "command-plugin.vala"
		_tmp21_ = _tmp20_;
#line 109 "command-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) _tmp18_, _tmp21_);
#line 110 "command-plugin.vala"
		_tmp22_ = dfi;
#line 110 "command-plugin.vala"
		_tmp23_ = synapse_desktop_file_info_get_comment (_tmp22_);
#line 110 "command-plugin.vala"
		_tmp24_ = _tmp23_;
#line 110 "command-plugin.vala"
		if (g_strcmp0 (_tmp24_, "") != 0) {
#line 433 "command-plugin.c"
			SynapseCommandPluginCommandObject* _tmp25_;
			SynapseDesktopFileInfo* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
#line 110 "command-plugin.vala"
			_tmp25_ = co;
#line 110 "command-plugin.vala"
			_tmp26_ = dfi;
#line 110 "command-plugin.vala"
			_tmp27_ = synapse_desktop_file_info_get_comment (_tmp26_);
#line 110 "command-plugin.vala"
			_tmp28_ = _tmp27_;
#line 110 "command-plugin.vala"
			synapse_match_set_description ((SynapseMatch*) _tmp25_, _tmp28_);
#line 448 "command-plugin.c"
		}
#line 111 "command-plugin.vala"
		_tmp30_ = dfi;
#line 111 "command-plugin.vala"
		_tmp31_ = synapse_desktop_file_info_get_icon_name (_tmp30_);
#line 111 "command-plugin.vala"
		_tmp32_ = _tmp31_;
#line 111 "command-plugin.vala"
		if (_tmp32_ != NULL) {
#line 458 "command-plugin.c"
			SynapseDesktopFileInfo* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
#line 111 "command-plugin.vala"
			_tmp33_ = dfi;
#line 111 "command-plugin.vala"
			_tmp34_ = synapse_desktop_file_info_get_icon_name (_tmp33_);
#line 111 "command-plugin.vala"
			_tmp35_ = _tmp34_;
#line 111 "command-plugin.vala"
			_tmp29_ = g_strcmp0 (_tmp35_, "") != 0;
#line 470 "command-plugin.c"
		} else {
#line 111 "command-plugin.vala"
			_tmp29_ = FALSE;
#line 474 "command-plugin.c"
		}
#line 111 "command-plugin.vala"
		if (_tmp29_) {
#line 478 "command-plugin.c"
			SynapseCommandPluginCommandObject* _tmp36_;
			SynapseDesktopFileInfo* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
#line 111 "command-plugin.vala"
			_tmp36_ = co;
#line 111 "command-plugin.vala"
			_tmp37_ = dfi;
#line 111 "command-plugin.vala"
			_tmp38_ = synapse_desktop_file_info_get_icon_name (_tmp37_);
#line 111 "command-plugin.vala"
			_tmp39_ = _tmp38_;
#line 111 "command-plugin.vala"
			synapse_match_set_icon_name ((SynapseMatch*) _tmp36_, _tmp39_);
#line 493 "command-plugin.c"
		}
	}
#line 114 "command-plugin.vala"
	result = co;
#line 114 "command-plugin.vala"
	_g_object_unref0 (dfi);
#line 114 "command-plugin.vala"
	_g_object_unref0 (df_list);
#line 114 "command-plugin.vala"
	_g_object_unref0 (dfs);
#line 114 "command-plugin.vala"
	return result;
#line 506 "command-plugin.c"
}

static void
synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                         SynapseMatch* match)
{
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp0_;
	GeeSet* _tmp1_;
	SynapseCommandPluginCommandObject* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 117 "command-plugin.vala"
	g_return_if_fail (self != NULL);
#line 117 "command-plugin.vala"
	g_return_if_fail (match != NULL);
#line 119 "command-plugin.vala"
	co = SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT (match) ? ((SynapseCommandPluginCommandObject*) match) : NULL;
#line 120 "command-plugin.vala"
	_tmp0_ = co;
#line 120 "command-plugin.vala"
	if (_tmp0_ == NULL) {
#line 120 "command-plugin.vala"
		return;
#line 531 "command-plugin.c"
	}
#line 122 "command-plugin.vala"
	_tmp1_ = self->priv->past_commands;
#line 122 "command-plugin.vala"
	_tmp2_ = co;
#line 122 "command-plugin.vala"
	_tmp3_ = synapse_command_plugin_command_object_get_command (_tmp2_);
#line 122 "command-plugin.vala"
	_tmp4_ = _tmp3_;
#line 122 "command-plugin.vala"
	gee_collection_add ((GeeCollection*) _tmp1_, _tmp4_);
#line 543 "command-plugin.c"
}

static void
synapse_command_plugin_real_search_data_free (gpointer _data)
{
	SynapseCommandPluginSearchData* _data_;
	_data_ = _data;
#line 24 "command-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "command-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "command-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "command-plugin.vala"
	g_slice_free (SynapseCommandPluginSearchData, _data_);
#line 559 "command-plugin.c"
}

static void
synapse_command_plugin_real_search (SynapseItemProvider* base,
                                    SynapseQuery* q,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseCommandPlugin * self;
	SynapseCommandPluginSearchData* _data_;
	SynapseCommandPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "command-plugin.vala"
	g_return_if_fail (q != NULL);
#line 24 "command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 24 "command-plugin.vala"
	_data_ = g_slice_new0 (SynapseCommandPluginSearchData);
#line 24 "command-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "command-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_command_plugin_real_search_data_free);
#line 24 "command-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "command-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "command-plugin.vala"
	_tmp1_ = *q;
#line 24 "command-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "command-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "command-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "command-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "command-plugin.vala"
	synapse_command_plugin_real_search_co (_data_);
#line 600 "command-plugin.c"
}

static SynapseResultSet*
synapse_command_plugin_search_finish (SynapseItemProvider* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SynapseResultSet* result;
	SynapseCommandPluginSearchData* _data_;
#line 24 "command-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "command-plugin.vala"
	if (NULL == _data_) {
#line 24 "command-plugin.vala"
		return NULL;
#line 616 "command-plugin.c"
	}
#line 24 "command-plugin.vala"
	result = _data_->result;
#line 24 "command-plugin.vala"
	_data_->result = NULL;
#line 24 "command-plugin.vala"
	return result;
#line 624 "command-plugin.c"
}

static gboolean
_synapse_command_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_command_plugin_real_search_co (self);
#line 130 "command-plugin.vala"
	return result;
#line 634 "command-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 655 "command-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 677 "command-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 681 "command-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 687 "command-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 691 "command-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 695 "command-plugin.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 703 "command-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 731 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 740 "command-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 754 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 763 "command-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 777 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 786 "command-plugin.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 795 "command-plugin.c"
}

static void
_synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                 gpointer self)
{
#line 162 "command-plugin.vala"
	synapse_command_plugin_command_executed ((SynapseCommandPlugin*) self, _sender);
#line 804 "command-plugin.c"
}

static gboolean
synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_)
{
#line 125 "command-plugin.vala"
	switch (_data_->_state_) {
#line 125 "command-plugin.vala"
		case 0:
#line 814 "command-plugin.c"
		goto _state_0;
#line 125 "command-plugin.vala"
		case 1:
#line 818 "command-plugin.c"
		goto _state_1;
		default:
#line 125 "command-plugin.vala"
		g_assert_not_reached ();
#line 823 "command-plugin.c"
	}
	_state_0:
#line 128 "command-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 128 "command-plugin.vala"
	if (!((_data_->_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
#line 128 "command-plugin.vala"
		_data_->result = NULL;
#line 128 "command-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 128 "command-plugin.vala"
		if (_data_->_state_ != 0) {
#line 128 "command-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 128 "command-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 840 "command-plugin.c"
			}
		}
#line 128 "command-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 128 "command-plugin.vala"
		return FALSE;
#line 847 "command-plugin.c"
	}
#line 130 "command-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_command_plugin_real_search_co_gsource_func, _data_, NULL);
#line 131 "command-plugin.vala"
	_data_->_state_ = 1;
#line 131 "command-plugin.vala"
	return FALSE;
#line 855 "command-plugin.c"
	_state_1:
	;
#line 133 "command-plugin.vala"
	_data_->_tmp1_ = synapse_result_set_new ();
#line 133 "command-plugin.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 135 "command-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 135 "command-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
#line 135 "command-plugin.vala"
	_data_->_tmp4_ = string_strip (_data_->_tmp3_);
#line 135 "command-plugin.vala"
	_data_->stripped = _data_->_tmp4_;
#line 136 "command-plugin.vala"
	_data_->_tmp5_ = _data_->stripped;
#line 136 "command-plugin.vala"
	if (g_strcmp0 (_data_->_tmp5_, "") == 0) {
#line 136 "command-plugin.vala"
		_data_->result = NULL;
#line 136 "command-plugin.vala"
		_g_free0 (_data_->stripped);
#line 136 "command-plugin.vala"
		_g_object_unref0 (_data_->_result_);
#line 136 "command-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 136 "command-plugin.vala"
		if (_data_->_state_ != 0) {
#line 136 "command-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 136 "command-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 888 "command-plugin.c"
			}
		}
#line 136 "command-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 136 "command-plugin.vala"
		return FALSE;
#line 895 "command-plugin.c"
	}
#line 137 "command-plugin.vala"
	_data_->_tmp6_ = _data_->stripped;
#line 137 "command-plugin.vala"
	if (g_str_has_prefix (_data_->_tmp6_, "~/")) {
#line 139 "command-plugin.vala"
		_data_->_tmp7_ = _data_->stripped;
#line 139 "command-plugin.vala"
		_data_->_tmp8_ = g_get_home_dir ();
#line 139 "command-plugin.vala"
		_data_->_tmp9_ = string_replace (_data_->_tmp7_, "~", _data_->_tmp8_);
#line 139 "command-plugin.vala"
		_g_free0 (_data_->stripped);
#line 139 "command-plugin.vala"
		_data_->stripped = _data_->_tmp9_;
#line 911 "command-plugin.c"
	}
#line 142 "command-plugin.vala"
	_data_->_tmp10_ = _data_->self->priv->past_commands;
#line 142 "command-plugin.vala"
	_data_->_tmp11_ = _data_->stripped;
#line 142 "command-plugin.vala"
	if (!gee_collection_contains ((GeeCollection*) _data_->_tmp10_, _data_->_tmp11_)) {
#line 919 "command-plugin.c"
		{
#line 144 "command-plugin.vala"
			_data_->_tmp12_ = _data_->self->priv->past_commands;
#line 144 "command-plugin.vala"
			_data_->_tmp13_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp12_);
#line 144 "command-plugin.vala"
			_data_->_command_it = _data_->_tmp13_;
#line 144 "command-plugin.vala"
			while (TRUE) {
#line 144 "command-plugin.vala"
				_data_->_tmp14_ = _data_->_command_it;
#line 144 "command-plugin.vala"
				if (!gee_iterator_next (_data_->_tmp14_)) {
#line 144 "command-plugin.vala"
					break;
#line 935 "command-plugin.c"
				}
#line 144 "command-plugin.vala"
				_data_->_tmp15_ = _data_->_command_it;
#line 144 "command-plugin.vala"
				_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
#line 144 "command-plugin.vala"
				_data_->command = (gchar*) _data_->_tmp16_;
#line 146 "command-plugin.vala"
				_data_->_tmp17_ = _data_->command;
#line 146 "command-plugin.vala"
				_data_->_tmp18_ = _data_->stripped;
#line 146 "command-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp17_, _data_->_tmp18_)) {
#line 148 "command-plugin.vala"
					_data_->_tmp19_ = _data_->_result_;
#line 148 "command-plugin.vala"
					_data_->_tmp20_ = _data_->command;
#line 148 "command-plugin.vala"
					_data_->_tmp21_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp20_);
#line 148 "command-plugin.vala"
					_data_->_tmp22_ = _data_->_tmp21_;
#line 148 "command-plugin.vala"
					synapse_result_set_add (_data_->_tmp19_, (SynapseMatch*) _data_->_tmp22_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 148 "command-plugin.vala"
					_g_object_unref0 (_data_->_tmp22_);
#line 961 "command-plugin.c"
				}
#line 144 "command-plugin.vala"
				_g_free0 (_data_->command);
#line 965 "command-plugin.c"
			}
#line 144 "command-plugin.vala"
			_g_object_unref0 (_data_->_command_it);
#line 969 "command-plugin.c"
		}
#line 152 "command-plugin.vala"
		_data_->_tmp23_ = _data_->self->priv->split_regex;
#line 152 "command-plugin.vala"
		_data_->_tmp24_ = _data_->stripped;
#line 152 "command-plugin.vala"
		_data_->_tmp26_ = _data_->_tmp25_ = g_regex_split (_data_->_tmp23_, _data_->_tmp24_, 0);
#line 152 "command-plugin.vala"
		_data_->args = _data_->_tmp26_;
#line 152 "command-plugin.vala"
		_data_->args_length1 = _vala_array_length (_data_->_tmp25_);
#line 152 "command-plugin.vala"
		_data_->_args_size_ = _data_->args_length1;
#line 153 "command-plugin.vala"
		_data_->_tmp27_ = _data_->args;
#line 153 "command-plugin.vala"
		_data_->_tmp27__length1 = _data_->args_length1;
#line 153 "command-plugin.vala"
		_data_->_tmp28_ = _data_->_tmp27_[0];
#line 153 "command-plugin.vala"
		_data_->_tmp29_ = g_find_program_in_path (_data_->_tmp28_);
#line 153 "command-plugin.vala"
		_data_->valid_cmd = _data_->_tmp29_;
#line 155 "command-plugin.vala"
		_data_->_tmp30_ = _data_->valid_cmd;
#line 155 "command-plugin.vala"
		if (_data_->_tmp30_ != NULL) {
#line 158 "command-plugin.vala"
			_data_->_tmp31_ = _data_->args;
#line 158 "command-plugin.vala"
			_data_->_tmp31__length1 = _data_->args_length1;
#line 158 "command-plugin.vala"
			_data_->_tmp32_ = _data_->_tmp31_[0];
#line 158 "command-plugin.vala"
			if (g_strcmp0 (_data_->_tmp32_, "rm") == 0) {
#line 158 "command-plugin.vala"
				_data_->result = NULL;
#line 158 "command-plugin.vala"
				_g_free0 (_data_->valid_cmd);
#line 158 "command-plugin.vala"
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 158 "command-plugin.vala"
				_g_free0 (_data_->stripped);
#line 158 "command-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 158 "command-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 158 "command-plugin.vala"
				if (_data_->_state_ != 0) {
#line 158 "command-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 158 "command-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1023 "command-plugin.c"
					}
				}
#line 158 "command-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 158 "command-plugin.vala"
				return FALSE;
#line 1030 "command-plugin.c"
			}
#line 159 "command-plugin.vala"
			_data_->_tmp33_ = _data_->stripped;
#line 159 "command-plugin.vala"
			_data_->_tmp34_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp33_);
#line 159 "command-plugin.vala"
			_data_->co = _data_->_tmp34_;
#line 160 "command-plugin.vala"
			_data_->_tmp35_ = _data_->co;
#line 160 "command-plugin.vala"
			if (_data_->_tmp35_ == NULL) {
#line 160 "command-plugin.vala"
				_data_->result = NULL;
#line 160 "command-plugin.vala"
				_g_object_unref0 (_data_->co);
#line 160 "command-plugin.vala"
				_g_free0 (_data_->valid_cmd);
#line 160 "command-plugin.vala"
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 160 "command-plugin.vala"
				_g_free0 (_data_->stripped);
#line 160 "command-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 160 "command-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 160 "command-plugin.vala"
				if (_data_->_state_ != 0) {
#line 160 "command-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 160 "command-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1062 "command-plugin.c"
					}
				}
#line 160 "command-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 160 "command-plugin.vala"
				return FALSE;
#line 1069 "command-plugin.c"
			}
#line 161 "command-plugin.vala"
			_data_->_tmp36_ = _data_->_result_;
#line 161 "command-plugin.vala"
			_data_->_tmp37_ = _data_->co;
#line 161 "command-plugin.vala"
			synapse_result_set_add (_data_->_tmp36_, (SynapseMatch*) _data_->_tmp37_, (gint) SYNAPSE_MATCH_SCORE_POOR);
#line 162 "command-plugin.vala"
			_data_->_tmp38_ = _data_->co;
#line 162 "command-plugin.vala"
			g_signal_connect_object ((SynapseMatch*) _data_->_tmp38_, "executed", (GCallback) _synapse_command_plugin_command_executed_synapse_match_executed, _data_->self, 0);
#line 155 "command-plugin.vala"
			_g_object_unref0 (_data_->co);
#line 1083 "command-plugin.c"
		}
#line 142 "command-plugin.vala"
		_g_free0 (_data_->valid_cmd);
#line 142 "command-plugin.vala"
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 1089 "command-plugin.c"
	} else {
#line 167 "command-plugin.vala"
		_data_->_tmp39_ = _data_->_result_;
#line 167 "command-plugin.vala"
		_data_->_tmp40_ = _data_->stripped;
#line 167 "command-plugin.vala"
		_data_->_tmp41_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp40_);
#line 167 "command-plugin.vala"
		_data_->_tmp42_ = _data_->_tmp41_;
#line 167 "command-plugin.vala"
		synapse_result_set_add (_data_->_tmp39_, (SynapseMatch*) _data_->_tmp42_, (gint) SYNAPSE_MATCH_SCORE_VERY_GOOD);
#line 167 "command-plugin.vala"
		_g_object_unref0 (_data_->_tmp42_);
#line 1103 "command-plugin.c"
	}
#line 170 "command-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 170 "command-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 170 "command-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 170 "command-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 170 "command-plugin.vala"
			_g_free0 (_data_->stripped);
#line 170 "command-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 170 "command-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 170 "command-plugin.vala"
			return FALSE;
#line 1121 "command-plugin.c"
		} else {
#line 170 "command-plugin.vala"
			_g_free0 (_data_->stripped);
#line 170 "command-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 170 "command-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 170 "command-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 170 "command-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 170 "command-plugin.vala"
			return FALSE;
#line 1135 "command-plugin.c"
		}
	}
#line 172 "command-plugin.vala"
	_data_->result = _data_->_result_;
#line 172 "command-plugin.vala"
	_g_free0 (_data_->stripped);
#line 172 "command-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 172 "command-plugin.vala"
	if (_data_->_state_ != 0) {
#line 172 "command-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 172 "command-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1150 "command-plugin.c"
		}
	}
#line 172 "command-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 172 "command-plugin.vala"
	return FALSE;
#line 1157 "command-plugin.c"
}

SynapseCommandPlugin*
synapse_command_plugin_construct (GType object_type)
{
	SynapseCommandPlugin * self = NULL;
#line 24 "command-plugin.vala"
	self = (SynapseCommandPlugin*) g_object_new (object_type, NULL);
#line 24 "command-plugin.vala"
	return self;
#line 1168 "command-plugin.c"
}

SynapseCommandPlugin*
synapse_command_plugin_new (void)
{
#line 24 "command-plugin.vala"
	return synapse_command_plugin_construct (SYNAPSE_TYPE_COMMAND_PLUGIN);
#line 1176 "command-plugin.c"
}

static gboolean
synapse_command_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommandPlugin* self;
#line 26 "command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 26 "command-plugin.vala"
	result = self->priv->_enabled;
#line 26 "command-plugin.vala"
	return result;
#line 1190 "command-plugin.c"
}

static void
synapse_command_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommandPlugin* self;
	gboolean old_value;
#line 26 "command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 26 "command-plugin.vala"
	old_value = synapse_command_plugin_real_get_enabled (base);
#line 26 "command-plugin.vala"
	if (old_value != value) {
#line 26 "command-plugin.vala"
		self->priv->_enabled = value;
#line 26 "command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY]);
#line 1209 "command-plugin.c"
	}
}

static inline gpointer
synapse_command_plugin_command_object_get_instance_private (SynapseCommandPluginCommandObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPluginCommandObject_private_offset);
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_construct (GType object_type,
                                                 const gchar* cmd)
{
	SynapseCommandPluginCommandObject * self = NULL;
	GError* _inner_error0_ = NULL;
#line 42 "command-plugin.vala"
	g_return_val_if_fail (cmd != NULL, NULL);
#line 44 "command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) g_object_new (object_type, "title", cmd, "description", _ ("Run command"), "command", cmd, "icon-name", "application-x-executable", "needs-terminal", g_str_has_prefix (cmd, "sudo "), NULL);
#line 1229 "command-plugin.c"
	{
		GAppInfo* _tmp0_ = NULL;
		GAppInfo* _tmp1_;
#line 50 "command-plugin.vala"
		_tmp1_ = g_app_info_create_from_commandline (cmd, NULL, 0, &_inner_error0_);
#line 50 "command-plugin.vala"
		_tmp0_ = _tmp1_;
#line 50 "command-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1239 "command-plugin.c"
			goto __catch0_g_error;
		}
#line 50 "command-plugin.vala"
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, _tmp0_);
#line 48 "command-plugin.vala"
		_g_object_unref0 (_tmp0_);
#line 1246 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 48 "command-plugin.vala"
		err = _inner_error0_;
#line 48 "command-plugin.vala"
		_inner_error0_ = NULL;
#line 54 "command-plugin.vala"
		_tmp2_ = err;
#line 54 "command-plugin.vala"
		_tmp3_ = _tmp2_->message;
#line 54 "command-plugin.vala"
		g_warning ("command-plugin.vala:54: %s", _tmp3_);
#line 48 "command-plugin.vala"
		_g_error_free0 (err);
#line 1266 "command-plugin.c"
	}
	__finally0:
#line 48 "command-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 48 "command-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 48 "command-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 48 "command-plugin.vala"
		return NULL;
#line 1277 "command-plugin.c"
	}
#line 42 "command-plugin.vala"
	return self;
#line 1281 "command-plugin.c"
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_new (const gchar* cmd)
{
#line 42 "command-plugin.vala"
	return synapse_command_plugin_command_object_construct (SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, cmd);
#line 1289 "command-plugin.c"
}

static const gchar*
synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 40 "command-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "command-plugin.vala"
	_tmp0_ = self->priv->_command;
#line 40 "command-plugin.vala"
	result = _tmp0_;
#line 40 "command-plugin.vala"
	return result;
#line 1305 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                   const gchar* value)
{
	gchar* old_value;
#line 40 "command-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "command-plugin.vala"
	old_value = synapse_command_plugin_command_object_get_command (self);
#line 40 "command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1319 "command-plugin.c"
		gchar* _tmp0_;
#line 40 "command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 40 "command-plugin.vala"
		_g_free0 (self->priv->_command);
#line 40 "command-plugin.vala"
		self->priv->_command = _tmp0_;
#line 40 "command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY]);
#line 1329 "command-plugin.c"
	}
}

static void
synapse_command_plugin_command_object_class_init (SynapseCommandPluginCommandObjectClass * klass,
                                                  gpointer klass_data)
{
#line 38 "command-plugin.vala"
	synapse_command_plugin_command_object_parent_class = g_type_class_peek_parent (klass);
#line 38 "command-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommandPluginCommandObject_private_offset);
#line 38 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_command_object_get_property;
#line 38 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_command_object_set_property;
#line 38 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_command_object_finalize;
#line 38 "command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY] = g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1349 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_instance_init (SynapseCommandPluginCommandObject * self,
                                                     gpointer klass)
{
#line 38 "command-plugin.vala"
	self->priv = synapse_command_plugin_command_object_get_instance_private (self);
#line 1358 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_finalize (GObject * obj)
{
	SynapseCommandPluginCommandObject * self;
#line 38 "command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 40 "command-plugin.vala"
	_g_free0 (self->priv->_command);
#line 38 "command-plugin.vala"
	G_OBJECT_CLASS (synapse_command_plugin_command_object_parent_class)->finalize (obj);
#line 1371 "command-plugin.c"
}

static GType
synapse_command_plugin_command_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginCommandObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_command_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPluginCommandObject), 0, (GInstanceInitFunc) synapse_command_plugin_command_object_instance_init, NULL };
	GType synapse_command_plugin_command_object_type_id;
	synapse_command_plugin_command_object_type_id = g_type_register_static (SYNAPSE_TYPE_APPLICATION_MATCH, "SynapseCommandPluginCommandObject", &g_define_type_info, 0);
	SynapseCommandPluginCommandObject_private_offset = g_type_add_instance_private (synapse_command_plugin_command_object_type_id, sizeof (SynapseCommandPluginCommandObjectPrivate));
	return synapse_command_plugin_command_object_type_id;
}

static GType
synapse_command_plugin_command_object_get_type (void)
{
	static volatile gsize synapse_command_plugin_command_object_type_id__once = 0;
	if (g_once_init_enter (&synapse_command_plugin_command_object_type_id__once)) {
		GType synapse_command_plugin_command_object_type_id;
		synapse_command_plugin_command_object_type_id = synapse_command_plugin_command_object_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_command_object_type_id__once, synapse_command_plugin_command_object_type_id);
	}
	return synapse_command_plugin_command_object_type_id__once;
}

static void
_vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 38 "command-plugin.vala"
	switch (property_id) {
#line 38 "command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
#line 38 "command-plugin.vala"
		g_value_set_string (value, synapse_command_plugin_command_object_get_command (self));
#line 38 "command-plugin.vala"
		break;
#line 1412 "command-plugin.c"
		default:
#line 38 "command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "command-plugin.vala"
		break;
#line 1418 "command-plugin.c"
	}
}

static void
_vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 38 "command-plugin.vala"
	switch (property_id) {
#line 38 "command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
#line 38 "command-plugin.vala"
		synapse_command_plugin_command_object_set_command (self, g_value_get_string (value));
#line 38 "command-plugin.vala"
		break;
#line 1438 "command-plugin.c"
		default:
#line 38 "command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "command-plugin.vala"
		break;
#line 1444 "command-plugin.c"
	}
}

static GObject *
synapse_command_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommandPlugin * self;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 78 "command-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_command_plugin_parent_class);
#line 78 "command-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 78 "command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 81 "command-plugin.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 81 "command-plugin.vala"
	_g_object_unref0 (self->priv->past_commands);
#line 81 "command-plugin.vala"
	self->priv->past_commands = (GeeSet*) _tmp0_;
#line 1470 "command-plugin.c"
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
#line 84 "command-plugin.vala"
		_tmp2_ = g_regex_new ("\\s+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 84 "command-plugin.vala"
		_tmp1_ = _tmp2_;
#line 84 "command-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 84 "command-plugin.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1483 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 84 "command-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 84 "command-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 1490 "command-plugin.c"
		}
#line 84 "command-plugin.vala"
		_tmp3_ = _tmp1_;
#line 84 "command-plugin.vala"
		_tmp1_ = NULL;
#line 84 "command-plugin.vala"
		_g_regex_unref0 (self->priv->split_regex);
#line 84 "command-plugin.vala"
		self->priv->split_regex = _tmp3_;
#line 82 "command-plugin.vala"
		_g_regex_unref0 (_tmp1_);
#line 1502 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 82 "command-plugin.vala"
		err = _inner_error0_;
#line 82 "command-plugin.vala"
		_inner_error0_ = NULL;
#line 88 "command-plugin.vala"
		_tmp4_ = err;
#line 88 "command-plugin.vala"
		_tmp5_ = _tmp4_->message;
#line 88 "command-plugin.vala"
		g_critical ("command-plugin.vala:88: %s", _tmp5_);
#line 82 "command-plugin.vala"
		_g_error_free0 (err);
#line 1522 "command-plugin.c"
	}
	__finally0:
#line 82 "command-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 82 "command-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 82 "command-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 1531 "command-plugin.c"
	}
#line 78 "command-plugin.vala"
	return obj;
#line 1535 "command-plugin.c"
}

static void
synapse_command_plugin_class_init (SynapseCommandPluginClass * klass,
                                   gpointer klass_data)
{
#line 24 "command-plugin.vala"
	synapse_command_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "command-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommandPlugin_private_offset);
#line 24 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_get_property;
#line 24 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_set_property;
#line 24 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_command_plugin_constructor;
#line 24 "command-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_finalize;
#line 24 "command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 72 "command-plugin.vala"
	synapse_command_plugin_register_plugin ();
#line 1558 "command-plugin.c"
}

static void
synapse_command_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 24 "command-plugin.vala"
	synapse_command_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "command-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_activate;
#line 24 "command-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_deactivate;
#line 24 "command-plugin.vala"
	iface->get_enabled = synapse_command_plugin_real_get_enabled;
#line 24 "command-plugin.vala"
	iface->set_enabled = synapse_command_plugin_real_set_enabled;
#line 1575 "command-plugin.c"
}

static void
synapse_command_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                             gpointer iface_data)
{
#line 24 "command-plugin.vala"
	synapse_command_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "command-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_command_plugin_real_search;
#line 24 "command-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_command_plugin_search_finish;
#line 1588 "command-plugin.c"
}

static void
synapse_command_plugin_instance_init (SynapseCommandPlugin * self,
                                      gpointer klass)
{
#line 24 "command-plugin.vala"
	self->priv = synapse_command_plugin_get_instance_private (self);
#line 26 "command-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1599 "command-plugin.c"
}

static void
synapse_command_plugin_finalize (GObject * obj)
{
	SynapseCommandPlugin * self;
#line 24 "command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 75 "command-plugin.vala"
	_g_object_unref0 (self->priv->past_commands);
#line 76 "command-plugin.vala"
	_g_regex_unref0 (self->priv->split_regex);
#line 24 "command-plugin.vala"
	G_OBJECT_CLASS (synapse_command_plugin_parent_class)->finalize (obj);
#line 1614 "command-plugin.c"
}

static GType
synapse_command_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPlugin), 0, (GInstanceInitFunc) synapse_command_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_command_plugin_type_id;
	synapse_command_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseCommandPlugin_private_offset = g_type_add_instance_private (synapse_command_plugin_type_id, sizeof (SynapseCommandPluginPrivate));
	return synapse_command_plugin_type_id;
}

GType
synapse_command_plugin_get_type (void)
{
	static volatile gsize synapse_command_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_command_plugin_type_id__once)) {
		GType synapse_command_plugin_type_id;
		synapse_command_plugin_type_id = synapse_command_plugin_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_type_id__once, synapse_command_plugin_type_id);
	}
	return synapse_command_plugin_type_id__once;
}

static void
_vala_synapse_command_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 24 "command-plugin.vala"
	switch (property_id) {
#line 24 "command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
#line 24 "command-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "command-plugin.vala"
		break;
#line 1659 "command-plugin.c"
		default:
#line 24 "command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "command-plugin.vala"
		break;
#line 1665 "command-plugin.c"
	}
}

static void
_vala_synapse_command_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 24 "command-plugin.vala"
	switch (property_id) {
#line 24 "command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
#line 24 "command-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "command-plugin.vala"
		break;
#line 1685 "command-plugin.c"
		default:
#line 24 "command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "command-plugin.vala"
		break;
#line 1691 "command-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

