/* data-sink.c generated by valac 0.56.17, the Vala compiler
 * generated from data-sink.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "synapse-core.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION (synapse_data_sink_data_sink_configuration_get_type ())
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration))
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfigurationClass))
#define SYNAPSE_DATA_SINK_IS_DATA_SINK_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION))
#define SYNAPSE_DATA_SINK_IS_DATA_SINK_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION))
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfigurationClass))

typedef struct _SynapseDataSinkDataSinkConfiguration SynapseDataSinkDataSinkConfiguration;
typedef struct _SynapseDataSinkDataSinkConfigurationClass SynapseDataSinkDataSinkConfigurationClass;
enum  {
	SYNAPSE_DATA_SINK_0_PROPERTY,
	SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY,
	SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY,
	SYNAPSE_DATA_SINK_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_properties[SYNAPSE_DATA_SINK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _SynapseDataSinkInitializeCachesData SynapseDataSinkInitializeCachesData;
#define _synapse_plugin_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_plugin_info_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDataSinkSearchData SynapseDataSinkSearchData;
typedef struct _SynapseDataSinkDataSinkConfigurationPrivate SynapseDataSinkDataSinkConfigurationPrivate;
enum  {
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_0_PROPERTY,
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY,
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_NUM_PROPERTIES];
enum  {
	SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL,
	SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL,
	SYNAPSE_DATA_SINK_NUM_SIGNALS
};
static guint synapse_data_sink_signals[SYNAPSE_DATA_SINK_NUM_SIGNALS] = {0};

struct _SynapseDataSinkPrivate {
	SynapseDataSinkDataSinkConfiguration* config;
	GeeSet* item_plugins;
	GeeSet* action_plugins;
	guint query_id;
	SynapseDBusService* dbus_name_cache;
	SynapseDesktopFileService* desktop_file_service;
	SynapsePluginRegistry* registry;
	SynapseRelevancyService* relevancy_service;
	SynapseVolumeService* volume_service;
	GType* plugin_types;
	gint plugin_types_length1;
	gint _plugin_types_size_;
	gboolean _has_empty_handlers;
	gboolean _has_unknown_handlers;
	gboolean plugins_loaded;
};

struct _Block2Data {
	int _ref_count_;
	SynapseDataSink* self;
	gint initialized_components;
	gint NUM_COMPONENTS;
	gpointer _async_data_;
};

struct _SynapseDataSinkInitializeCachesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDataSink* self;
	Block2Data* _data2_;
	SynapseDBusService* _tmp0_;
	SynapseDBusService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
};

struct _Block3Data {
	int _ref_count_;
	SynapseDataSink* self;
	SynapseQuery q;
	GList* cancellables;
	SynapseResultSet* current_result_set;
	gint search_size;
	gboolean waiting;
	gpointer _async_data_;
};

struct _SynapseDataSinkSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDataSink* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	Block3Data* _data3_;
	gboolean _tmp0_;
	GError* _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	SynapseQueryFlags _tmp4_;
	gchar* query_stripped;
	gchar* _tmp5_;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseResultSet* _tmp8_;
	SynapseResultSet* _tmp9_;
	GeeSet* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeIterator* _data_plugin_it;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	SynapseItemProvider* data_plugin;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	SynapseItemProvider* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	SynapseItemProvider* _tmp24_;
	SynapseItemProvider* _tmp25_;
	SynapseQuery _tmp26_;
	gboolean skip;
	gint _tmp27_;
	GCancellable* c;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	SynapseItemProvider* _tmp33_;
	SynapseQuery _tmp34_;
	gboolean _tmp35_;
	GError* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	SynapseUnknownMatch* unknown_match;
	SynapseUnknownMatch* _tmp40_;
	gboolean add_to_rs;
	gboolean _tmp41_;
	GeeList* unknown_match_actions;
	SynapseUnknownMatch* _tmp42_;
	GeeList* _tmp43_;
	GeeList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	SynapseResultSet* _tmp47_;
	SynapseUnknownMatch* _tmp48_;
	SynapseResultSet* _tmp49_;
	GeeList* _tmp50_;
	GError* _inner_error0_;
};

struct _SynapseDataSinkDataSinkConfiguration {
	SynapseConfigObject parent_instance;
	SynapseDataSinkDataSinkConfigurationPrivate * priv;
};

struct _SynapseDataSinkDataSinkConfigurationClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseDataSinkDataSinkConfigurationPrivate {
	gchar** _disabled_plugins;
	gint _disabled_plugins_length1;
	gint __disabled_plugins_size_;
};

static gint SynapseDataSink_private_offset;
static gpointer synapse_data_sink_parent_class = NULL;
static gint SynapseDataSinkDataSinkConfiguration_private_offset;
static gpointer synapse_data_sink_data_sink_configuration_parent_class = NULL;
static SynapseSearchProviderIface * synapse_data_sink_synapse_search_provider_parent_iface = NULL;

static GType synapse_search_provider_get_type_once (void);
static GType synapse_data_sink_data_sink_configuration_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_data_sink_initialize_caches_data_free (gpointer _data);
static void synapse_data_sink_initialize_caches (SynapseDataSink* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_data_sink_initialize_caches_finish (SynapseDataSink* self,
                                                 GAsyncResult* _res_);
static gboolean synapse_data_sink_initialize_caches_co (SynapseDataSinkInitializeCachesData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _synapse_data_sink_initialize_caches_co_gsource_func (gpointer self);
static void __lambda13_ (Block2Data* _data2_);
static void ___lambda13__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void synapse_data_sink_check_plugins (SynapseDataSink* self);
static void _synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                gpointer self);
static void __lambda14_ (Block2Data* _data2_);
static void ___lambda14__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean __lambda15_ (SynapseDataSink* self);
static void synapse_data_sink_load_plugins (SynapseDataSink* self);
static gboolean ___lambda15__gsource_func (gpointer self);
static void _vala_array_add1 (SynapsePluginRegisterFunc* * array,
                       gint* length,
                       gint* size,
                       SynapsePluginRegisterFunc value);
static void synapse_data_sink_update_has_unknown_handlers (SynapseDataSink* self);
static void synapse_data_sink_update_has_empty_handlers (SynapseDataSink* self);
static GObject* synapse_data_sink_create_plugin (SynapseDataSink* self,
                                          GType t);
static gboolean synapse_data_sink_data_sink_configuration_is_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                                      GType t);
static gboolean _vala_g_type_array_contains (GType * stack,
                                      gssize stack_length,
                                      const GType needle);
static void _vala_array_add2 (GType* * array,
                       gint* length,
                       gint* size,
                       GType value);
static void synapse_data_sink_data_sink_configuration_set_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                                   GType t,
                                                                   gboolean enabled);
static void synapse_data_sink_real_search_data_free (gpointer _data);
static void synapse_data_sink_real_search (SynapseSearchProvider* base,
                                    const gchar* query,
                                    SynapseQueryFlags flags,
                                    SynapseResultSet* dest_result_set,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean synapse_data_sink_real_search_co (SynapseDataSinkSearchData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void block3_data_unref (void * _userdata_);
static gboolean _synapse_data_sink_real_search_co_gsource_func (gpointer self);
static void ____lambda16_ (Block3Data* _data3_,
                    GObject* src_obj,
                    GAsyncResult* res);
static void _____lambda16__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda17_ (Block3Data* _data3_);
static void ____lambda17__gfunc (gconstpointer data,
                          gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void synapse_data_sink_data_sink_configuration_enable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                              const gchar* name);
static void synapse_data_sink_data_sink_configuration_disable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                               const gchar* name);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static SynapseDataSinkDataSinkConfiguration* synapse_data_sink_data_sink_configuration_new (void);
static SynapseDataSinkDataSinkConfiguration* synapse_data_sink_data_sink_configuration_construct (GType object_type);
static gchar** synapse_data_sink_data_sink_configuration_get_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                        gint* result_length1);
static void synapse_data_sink_data_sink_configuration_set_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                     gchar** value,
                                                                     gint value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void synapse_data_sink_data_sink_configuration_finalize (GObject * obj);
static GType synapse_data_sink_data_sink_configuration_get_type_once (void);
static void _vala_synapse_data_sink_data_sink_configuration_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_synapse_data_sink_data_sink_configuration_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static GObject * synapse_data_sink_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void synapse_data_sink_finalize (GObject * obj);
static GType synapse_data_sink_get_type_once (void);
static void _vala_synapse_data_sink_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_synapse_data_sink_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
synapse_search_error_quark (void)
{
#line 27 "config-service.vala"
	return g_quark_from_static_string ("synapse-search-error-quark");
#line 361 "data-sink.c"
}

static GType
synapse_search_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED", "search-cancelled"}, {SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR, "SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR", "unknown-error"}, {0, NULL, NULL}};
	GType synapse_search_error_type_id;
	synapse_search_error_type_id = g_enum_register_static ("SynapseSearchError", values);
	return synapse_search_error_type_id;
}

GType
synapse_search_error_get_type (void)
{
	static volatile gsize synapse_search_error_type_id__once = 0;
	if (g_once_init_enter (&synapse_search_error_type_id__once)) {
		GType synapse_search_error_type_id;
		synapse_search_error_type_id = synapse_search_error_get_type_once ();
		g_once_init_leave (&synapse_search_error_type_id__once, synapse_search_error_type_id);
	}
	return synapse_search_error_type_id__once;
}

void
synapse_search_provider_search (SynapseSearchProvider* self,
                                const gchar* query,
                                SynapseQueryFlags flags,
                                SynapseResultSet* dest_result_set,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseSearchProviderIface* _iface_;
#line 29 "data-sink.vala"
	_iface_ = SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE (self);
#line 29 "data-sink.vala"
	if (_iface_->search) {
#line 29 "data-sink.vala"
		_iface_->search (self, query, flags, dest_result_set, cancellable, _callback_, _user_data_);
#line 401 "data-sink.c"
	}
}

GeeList*
synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	SynapseSearchProviderIface* _iface_;
#line 29 "data-sink.vala"
	_iface_ = SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE (self);
#line 29 "data-sink.vala"
	if (_iface_->search_finish) {
#line 29 "data-sink.vala"
		return _iface_->search_finish (self, _res_, error);
#line 417 "data-sink.c"
	}
#line 29 "data-sink.vala"
	return NULL;
#line 421 "data-sink.c"
}

static void
synapse_search_provider_default_init (SynapseSearchProviderIface * iface,
                                      gpointer iface_data)
{
}

static GType
synapse_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_search_provider_type_id;
	synapse_search_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseSearchProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_search_provider_type_id, G_TYPE_OBJECT);
	return synapse_search_provider_type_id;
}

GType
synapse_search_provider_get_type (void)
{
	static volatile gsize synapse_search_provider_type_id__once = 0;
	if (g_once_init_enter (&synapse_search_provider_type_id__once)) {
		GType synapse_search_provider_type_id;
		synapse_search_provider_type_id = synapse_search_provider_get_type_once ();
		g_once_init_leave (&synapse_search_provider_type_id__once, synapse_search_provider_type_id);
	}
	return synapse_search_provider_type_id__once;
}

static inline gpointer
synapse_data_sink_get_instance_private (SynapseDataSink* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSink_private_offset);
}

SynapseDataSink*
synapse_data_sink_construct (GType object_type)
{
	SynapseDataSink * self = NULL;
#line 95 "data-sink.vala"
	self = (SynapseDataSink*) g_object_new (object_type, NULL);
#line 95 "data-sink.vala"
	return self;
#line 466 "data-sink.c"
}

SynapseDataSink*
synapse_data_sink_new (void)
{
#line 95 "data-sink.vala"
	return synapse_data_sink_construct (SYNAPSE_TYPE_DATA_SINK);
#line 474 "data-sink.c"
}

static void
synapse_data_sink_initialize_caches_data_free (gpointer _data)
{
	SynapseDataSinkInitializeCachesData* _data_;
	_data_ = _data;
#line 37 "data-sink.vala"
	_g_object_unref0 (_data_->self);
#line 37 "data-sink.vala"
	g_slice_free (SynapseDataSinkInitializeCachesData, _data_);
#line 486 "data-sink.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 37 "data-sink.vala"
	return self ? g_object_ref (self) : NULL;
#line 494 "data-sink.c"
}

static void
synapse_data_sink_initialize_caches (SynapseDataSink* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseDataSinkInitializeCachesData* _data_;
	SynapseDataSink* _tmp0_;
#line 37 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 37 "data-sink.vala"
	_data_ = g_slice_new0 (SynapseDataSinkInitializeCachesData);
#line 37 "data-sink.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 37 "data-sink.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_data_sink_initialize_caches_data_free);
#line 37 "data-sink.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 37 "data-sink.vala"
	_data_->self = _tmp0_;
#line 37 "data-sink.vala"
	synapse_data_sink_initialize_caches_co (_data_);
#line 518 "data-sink.c"
}

static void
synapse_data_sink_initialize_caches_finish (SynapseDataSink* self,
                                            GAsyncResult* _res_)
{
	SynapseDataSinkInitializeCachesData* _data_;
#line 37 "data-sink.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 528 "data-sink.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 137 "data-sink.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 137 "data-sink.vala"
	return _data2_;
#line 538 "data-sink.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 137 "data-sink.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 548 "data-sink.c"
		SynapseDataSink* self;
#line 137 "data-sink.vala"
		self = _data2_->self;
#line 137 "data-sink.vala"
		_g_object_unref0 (self);
#line 137 "data-sink.vala"
		g_slice_free (Block2Data, _data2_);
#line 556 "data-sink.c"
	}
}

static gboolean
_synapse_data_sink_initialize_caches_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_data_sink_initialize_caches_co (self);
#line 139 "data-sink.vala"
	return result;
#line 567 "data-sink.c"
}

static void
__lambda13_ (Block2Data* _data2_)
{
	SynapseDataSink* self;
	gint _tmp0_;
#line 146 "data-sink.vala"
	self = _data2_->self;
#line 147 "data-sink.vala"
	_tmp0_ = _data2_->initialized_components;
#line 147 "data-sink.vala"
	_data2_->initialized_components = _tmp0_ + 1;
#line 148 "data-sink.vala"
	if (_data2_->initialized_components >= _data2_->NUM_COMPONENTS) {
#line 150 "data-sink.vala"
		synapse_data_sink_initialize_caches_co (_data2_->_async_data_);
#line 585 "data-sink.c"
	}
}

static void
___lambda13__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 146 "data-sink.vala"
	__lambda13_ (self);
#line 146 "data-sink.vala"
	block2_data_unref (self);
#line 598 "data-sink.c"
}

static void
_synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                           gpointer self)
{
#line 155 "data-sink.vala"
	synapse_data_sink_check_plugins ((SynapseDataSink*) self);
#line 607 "data-sink.c"
}

static void
__lambda14_ (Block2Data* _data2_)
{
	SynapseDataSink* self;
	gint _tmp0_;
#line 156 "data-sink.vala"
	self = _data2_->self;
#line 157 "data-sink.vala"
	_tmp0_ = _data2_->initialized_components;
#line 157 "data-sink.vala"
	_data2_->initialized_components = _tmp0_ + 1;
#line 158 "data-sink.vala"
	if (_data2_->initialized_components >= _data2_->NUM_COMPONENTS) {
#line 160 "data-sink.vala"
		synapse_data_sink_initialize_caches_co (_data2_->_async_data_);
#line 625 "data-sink.c"
	}
}

static void
___lambda14__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 156 "data-sink.vala"
	__lambda14_ (self);
#line 156 "data-sink.vala"
	block2_data_unref (self);
#line 638 "data-sink.c"
}

static gboolean
__lambda15_ (SynapseDataSink* self)
{
	gboolean result;
#line 167 "data-sink.vala"
	synapse_data_sink_load_plugins (self);
#line 168 "data-sink.vala"
	result = FALSE;
#line 168 "data-sink.vala"
	return result;
#line 651 "data-sink.c"
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ ((SynapseDataSink*) self);
#line 166 "data-sink.vala"
	return result;
#line 661 "data-sink.c"
}

static gboolean
synapse_data_sink_initialize_caches_co (SynapseDataSinkInitializeCachesData* _data_)
{
#line 137 "data-sink.vala"
	switch (_data_->_state_) {
#line 137 "data-sink.vala"
		case 0:
#line 671 "data-sink.c"
		goto _state_0;
#line 137 "data-sink.vala"
		case 1:
#line 675 "data-sink.c"
		goto _state_1;
#line 137 "data-sink.vala"
		case 2:
#line 679 "data-sink.c"
		goto _state_2;
		default:
#line 137 "data-sink.vala"
		g_assert_not_reached ();
#line 684 "data-sink.c"
	}
	_state_0:
#line 137 "data-sink.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 137 "data-sink.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 137 "data-sink.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 137 "data-sink.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 139 "data-sink.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_data_sink_initialize_caches_co_gsource_func, _data_, NULL);
#line 140 "data-sink.vala"
	_data_->_state_ = 1;
#line 140 "data-sink.vala"
	return FALSE;
#line 701 "data-sink.c"
	_state_1:
	;
#line 142 "data-sink.vala"
	_data_->_data2_->initialized_components = 0;
#line 143 "data-sink.vala"
	_data_->_data2_->NUM_COMPONENTS = 2;
#line 145 "data-sink.vala"
	_data_->_tmp0_ = synapse_dbus_service_get_default ();
#line 145 "data-sink.vala"
	_g_object_unref0 (_data_->self->priv->dbus_name_cache);
#line 145 "data-sink.vala"
	_data_->self->priv->dbus_name_cache = _data_->_tmp0_;
#line 146 "data-sink.vala"
	_data_->_tmp1_ = _data_->self->priv->dbus_name_cache;
#line 146 "data-sink.vala"
	synapse_dbus_service_initialize (_data_->_tmp1_, ___lambda13__gasync_ready_callback, block2_data_ref (_data_->_data2_));
#line 154 "data-sink.vala"
	_data_->_tmp2_ = synapse_desktop_file_service_get_default ();
#line 154 "data-sink.vala"
	_g_object_unref0 (_data_->self->priv->desktop_file_service);
#line 154 "data-sink.vala"
	_data_->self->priv->desktop_file_service = _data_->_tmp2_;
#line 155 "data-sink.vala"
	_data_->_tmp3_ = _data_->self->priv->desktop_file_service;
#line 155 "data-sink.vala"
	g_signal_connect_object (_data_->_tmp3_, "reload-done", (GCallback) _synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done, _data_->self, 0);
#line 156 "data-sink.vala"
	_data_->_tmp4_ = _data_->self->priv->desktop_file_service;
#line 156 "data-sink.vala"
	synapse_desktop_file_service_initialize (_data_->_tmp4_, ___lambda14__gasync_ready_callback, block2_data_ref (_data_->_data2_));
#line 164 "data-sink.vala"
	_data_->_state_ = 2;
#line 164 "data-sink.vala"
	return FALSE;
#line 736 "data-sink.c"
	_state_2:
	;
#line 166 "data-sink.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 137 "data-sink.vala"
	block2_data_unref (_data_->_data2_);
#line 137 "data-sink.vala"
	_data_->_data2_ = NULL;
#line 137 "data-sink.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 137 "data-sink.vala"
	if (_data_->_state_ != 0) {
#line 137 "data-sink.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 137 "data-sink.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 753 "data-sink.c"
		}
	}
#line 137 "data-sink.vala"
	g_object_unref (_data_->_async_result);
#line 137 "data-sink.vala"
	return FALSE;
#line 760 "data-sink.c"
}

static void
_vala_array_add1 (SynapsePluginRegisterFunc* * array,
                  gint* length,
                  gint* size,
                  SynapsePluginRegisterFunc value)
{
#line 177 "data-sink.vala"
	if ((*length) == (*size)) {
#line 177 "data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 177 "data-sink.vala"
		*array = g_renew (SynapsePluginRegisterFunc, *array, *size);
#line 775 "data-sink.c"
	}
#line 177 "data-sink.vala"
	(*array)[(*length)++] = value;
#line 779 "data-sink.c"
}

static void
synapse_data_sink_check_plugins (SynapseDataSink* self)
{
	SynapsePluginRegisterFunc* reg_funcs = NULL;
	SynapsePluginRegisterFunc* _tmp0_;
	gint reg_funcs_length1;
	gint _reg_funcs_size_;
	SynapsePluginRegisterFunc* _tmp12_;
	gint _tmp12__length1;
#line 172 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 174 "data-sink.vala"
	_tmp0_ = g_new0 (SynapsePluginRegisterFunc, 0);
#line 174 "data-sink.vala"
	reg_funcs = _tmp0_;
#line 174 "data-sink.vala"
	reg_funcs_length1 = 0;
#line 174 "data-sink.vala"
	_reg_funcs_size_ = reg_funcs_length1;
#line 801 "data-sink.c"
	{
		GeeList* _pi_list = NULL;
		SynapsePluginRegistry* _tmp1_;
		GeeList* _tmp2_;
		gint _pi_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pi_index = 0;
#line 175 "data-sink.vala"
		_tmp1_ = self->priv->registry;
#line 175 "data-sink.vala"
		_tmp2_ = synapse_plugin_registry_get_plugins (_tmp1_);
#line 175 "data-sink.vala"
		_pi_list = _tmp2_;
#line 175 "data-sink.vala"
		_tmp3_ = _pi_list;
#line 175 "data-sink.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 175 "data-sink.vala"
		_tmp5_ = _tmp4_;
#line 175 "data-sink.vala"
		_pi_size = _tmp5_;
#line 175 "data-sink.vala"
		_pi_index = -1;
#line 175 "data-sink.vala"
		while (TRUE) {
#line 829 "data-sink.c"
			gint _tmp6_;
			gint _tmp7_;
			SynapsePluginInfo* pi = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			SynapsePluginInfo* _tmp10_;
			SynapsePluginRegisterFunc _tmp11_;
#line 175 "data-sink.vala"
			_pi_index = _pi_index + 1;
#line 175 "data-sink.vala"
			_tmp6_ = _pi_index;
#line 175 "data-sink.vala"
			_tmp7_ = _pi_size;
#line 175 "data-sink.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 175 "data-sink.vala"
				break;
#line 847 "data-sink.c"
			}
#line 175 "data-sink.vala"
			_tmp8_ = _pi_list;
#line 175 "data-sink.vala"
			_tmp9_ = gee_list_get (_tmp8_, _pi_index);
#line 175 "data-sink.vala"
			pi = (SynapsePluginInfo*) _tmp9_;
#line 177 "data-sink.vala"
			_tmp10_ = pi;
#line 177 "data-sink.vala"
			_tmp11_ = _tmp10_->register_func;
#line 177 "data-sink.vala"
			_vala_array_add1 (&reg_funcs, &reg_funcs_length1, &_reg_funcs_size_, _tmp11_);
#line 175 "data-sink.vala"
			_synapse_plugin_info_unref0 (pi);
#line 863 "data-sink.c"
		}
#line 175 "data-sink.vala"
		_g_object_unref0 (_pi_list);
#line 867 "data-sink.c"
	}
#line 180 "data-sink.vala"
	_tmp12_ = reg_funcs;
#line 180 "data-sink.vala"
	_tmp12__length1 = reg_funcs_length1;
#line 873 "data-sink.c"
	{
		SynapsePluginRegisterFunc* func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
#line 180 "data-sink.vala"
		func_collection = _tmp12_;
#line 180 "data-sink.vala"
		func_collection_length1 = _tmp12__length1;
#line 180 "data-sink.vala"
		for (func_it = 0; func_it < func_collection_length1; func_it = func_it + 1) {
#line 885 "data-sink.c"
			SynapsePluginRegisterFunc func = NULL;
#line 180 "data-sink.vala"
			func = func_collection[func_it];
#line 889 "data-sink.c"
			{
				SynapsePluginRegisterFunc _tmp13_;
#line 182 "data-sink.vala"
				_tmp13_ = func;
#line 182 "data-sink.vala"
				_tmp13_ ();
#line 896 "data-sink.c"
			}
		}
	}
#line 172 "data-sink.vala"
	reg_funcs = (g_free (reg_funcs), NULL);
#line 902 "data-sink.c"
}

void
synapse_data_sink_register_plugin (SynapseDataSink* self,
                                   GObject* plugin)
{
#line 193 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 193 "data-sink.vala"
	g_return_if_fail (plugin != NULL);
#line 195 "data-sink.vala"
	if (SYNAPSE_IS_ACTION_PROVIDER (plugin)) {
#line 915 "data-sink.c"
		SynapseActionProvider* action_plugin = NULL;
		GeeSet* _tmp0_;
		SynapseActionProvider* _tmp1_;
		gboolean _tmp2_;
		SynapseActionProvider* _tmp3_;
#line 197 "data-sink.vala"
		action_plugin = G_TYPE_CHECK_INSTANCE_CAST (plugin, SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider);
#line 198 "data-sink.vala"
		_tmp0_ = self->priv->action_plugins;
#line 198 "data-sink.vala"
		_tmp1_ = action_plugin;
#line 198 "data-sink.vala"
		gee_collection_add ((GeeCollection*) _tmp0_, _tmp1_);
#line 199 "data-sink.vala"
		_tmp2_ = self->priv->_has_unknown_handlers;
#line 199 "data-sink.vala"
		_tmp3_ = action_plugin;
#line 199 "data-sink.vala"
		synapse_data_sink_set_has_unknown_handlers (self, _tmp2_ | synapse_action_provider_handles_unknown (_tmp3_));
#line 935 "data-sink.c"
	}
#line 201 "data-sink.vala"
	if (SYNAPSE_IS_ITEM_PROVIDER (plugin)) {
#line 939 "data-sink.c"
		SynapseItemProvider* item_plugin = NULL;
		GeeSet* _tmp4_;
		SynapseItemProvider* _tmp5_;
		gboolean _tmp6_;
		SynapseItemProvider* _tmp7_;
#line 203 "data-sink.vala"
		item_plugin = G_TYPE_CHECK_INSTANCE_CAST (plugin, SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider);
#line 204 "data-sink.vala"
		_tmp4_ = self->priv->item_plugins;
#line 204 "data-sink.vala"
		_tmp5_ = item_plugin;
#line 204 "data-sink.vala"
		gee_collection_add ((GeeCollection*) _tmp4_, _tmp5_);
#line 205 "data-sink.vala"
		_tmp6_ = self->priv->_has_empty_handlers;
#line 205 "data-sink.vala"
		_tmp7_ = item_plugin;
#line 205 "data-sink.vala"
		synapse_data_sink_set_has_empty_handlers (self, _tmp6_ | synapse_item_provider_handles_empty_query (_tmp7_));
#line 959 "data-sink.c"
	}
#line 208 "data-sink.vala"
	g_signal_emit (self, synapse_data_sink_signals[SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL], 0, plugin);
#line 963 "data-sink.c"
}

static void
synapse_data_sink_update_has_unknown_handlers (SynapseDataSink* self)
{
	gboolean tmp = FALSE;
#line 211 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 213 "data-sink.vala"
	tmp = FALSE;
#line 974 "data-sink.c"
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 214 "data-sink.vala"
		_tmp0_ = self->priv->action_plugins;
#line 214 "data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 214 "data-sink.vala"
		_action_it = _tmp1_;
#line 214 "data-sink.vala"
		while (TRUE) {
#line 987 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			SynapseActionProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 214 "data-sink.vala"
			_tmp2_ = _action_it;
#line 214 "data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 214 "data-sink.vala"
				break;
#line 1002 "data-sink.c"
			}
#line 214 "data-sink.vala"
			_tmp3_ = _action_it;
#line 214 "data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 214 "data-sink.vala"
			action = (SynapseActionProvider*) _tmp4_;
#line 216 "data-sink.vala"
			_tmp6_ = action;
#line 216 "data-sink.vala"
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 216 "data-sink.vala"
			_tmp8_ = _tmp7_;
#line 216 "data-sink.vala"
			if (_tmp8_) {
#line 1018 "data-sink.c"
				SynapseActionProvider* _tmp9_;
#line 216 "data-sink.vala"
				_tmp9_ = action;
#line 216 "data-sink.vala"
				_tmp5_ = synapse_action_provider_handles_unknown (_tmp9_);
#line 1024 "data-sink.c"
			} else {
#line 216 "data-sink.vala"
				_tmp5_ = FALSE;
#line 1028 "data-sink.c"
			}
#line 216 "data-sink.vala"
			if (_tmp5_) {
#line 218 "data-sink.vala"
				tmp = TRUE;
#line 219 "data-sink.vala"
				_g_object_unref0 (action);
#line 219 "data-sink.vala"
				break;
#line 1038 "data-sink.c"
			}
#line 214 "data-sink.vala"
			_g_object_unref0 (action);
#line 1042 "data-sink.c"
		}
#line 214 "data-sink.vala"
		_g_object_unref0 (_action_it);
#line 1046 "data-sink.c"
	}
#line 222 "data-sink.vala"
	synapse_data_sink_set_has_unknown_handlers (self, tmp);
#line 1050 "data-sink.c"
}

static void
synapse_data_sink_update_has_empty_handlers (SynapseDataSink* self)
{
	gboolean tmp = FALSE;
#line 225 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 227 "data-sink.vala"
	tmp = FALSE;
#line 1061 "data-sink.c"
	{
		GeeIterator* _item_plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 228 "data-sink.vala"
		_tmp0_ = self->priv->item_plugins;
#line 228 "data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 228 "data-sink.vala"
		_item_plugin_it = _tmp1_;
#line 228 "data-sink.vala"
		while (TRUE) {
#line 1074 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseItemProvider* item_plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			SynapseItemProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 228 "data-sink.vala"
			_tmp2_ = _item_plugin_it;
#line 228 "data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 228 "data-sink.vala"
				break;
#line 1089 "data-sink.c"
			}
#line 228 "data-sink.vala"
			_tmp3_ = _item_plugin_it;
#line 228 "data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 228 "data-sink.vala"
			item_plugin = (SynapseItemProvider*) _tmp4_;
#line 230 "data-sink.vala"
			_tmp6_ = item_plugin;
#line 230 "data-sink.vala"
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 230 "data-sink.vala"
			_tmp8_ = _tmp7_;
#line 230 "data-sink.vala"
			if (_tmp8_) {
#line 1105 "data-sink.c"
				SynapseItemProvider* _tmp9_;
#line 230 "data-sink.vala"
				_tmp9_ = item_plugin;
#line 230 "data-sink.vala"
				_tmp5_ = synapse_item_provider_handles_empty_query (_tmp9_);
#line 1111 "data-sink.c"
			} else {
#line 230 "data-sink.vala"
				_tmp5_ = FALSE;
#line 1115 "data-sink.c"
			}
#line 230 "data-sink.vala"
			if (_tmp5_) {
#line 232 "data-sink.vala"
				tmp = TRUE;
#line 233 "data-sink.vala"
				_g_object_unref0 (item_plugin);
#line 233 "data-sink.vala"
				break;
#line 1125 "data-sink.c"
			}
#line 228 "data-sink.vala"
			_g_object_unref0 (item_plugin);
#line 1129 "data-sink.c"
		}
#line 228 "data-sink.vala"
		_g_object_unref0 (_item_plugin_it);
#line 1133 "data-sink.c"
	}
#line 236 "data-sink.vala"
	synapse_data_sink_set_has_empty_handlers (self, tmp);
#line 1137 "data-sink.c"
}

static GObject*
synapse_data_sink_create_plugin (SynapseDataSink* self,
                                 GType t)
{
	GObjectClass* obj_class = NULL;
	GTypeClass* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GObjectClass* _tmp2_;
	GObject* result;
#line 239 "data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 241 "data-sink.vala"
	_tmp0_ = g_type_class_ref (t);
#line 241 "data-sink.vala"
	obj_class = (GObjectClass*) _tmp0_;
#line 242 "data-sink.vala"
	_tmp2_ = obj_class;
#line 242 "data-sink.vala"
	if (_tmp2_ != NULL) {
#line 1159 "data-sink.c"
		GObjectClass* _tmp3_;
		GParamSpec* _tmp4_;
#line 242 "data-sink.vala"
		_tmp3_ = obj_class;
#line 242 "data-sink.vala"
		_tmp4_ = g_object_class_find_property (_tmp3_, "data-sink");
#line 242 "data-sink.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 1168 "data-sink.c"
	} else {
#line 242 "data-sink.vala"
		_tmp1_ = FALSE;
#line 1172 "data-sink.c"
	}
#line 244 "data-sink.vala"
	if (_tmp1_) {
#line 1176 "data-sink.c"
		GObject* _tmp5_;
		GObject* _tmp6_;
#line 244 "data-sink.vala"
		_tmp5_ = g_object_new (t, "data-sink", self, NULL, NULL);
#line 244 "data-sink.vala"
		_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
#line 244 "data-sink.vala"
		result = _tmp6_;
#line 244 "data-sink.vala"
		_g_type_class_unref0 (obj_class);
#line 244 "data-sink.vala"
		return result;
#line 1189 "data-sink.c"
	} else {
		GObject* _tmp7_;
		GObject* _tmp8_;
#line 248 "data-sink.vala"
		_tmp7_ = g_object_new (t, NULL, NULL);
#line 248 "data-sink.vala"
		_tmp8_ = G_IS_INITIALLY_UNOWNED (_tmp7_) ? g_object_ref_sink (_tmp7_) : _tmp7_;
#line 248 "data-sink.vala"
		result = _tmp8_;
#line 248 "data-sink.vala"
		_g_type_class_unref0 (obj_class);
#line 248 "data-sink.vala"
		return result;
#line 1203 "data-sink.c"
	}
}

static void
synapse_data_sink_load_plugins (SynapseDataSink* self)
{
	GType* _tmp0_;
	gint _tmp0__length1;
#line 252 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 255 "data-sink.vala"
	_tmp0_ = self->priv->plugin_types;
#line 255 "data-sink.vala"
	_tmp0__length1 = self->priv->plugin_types_length1;
#line 1218 "data-sink.c"
	{
		GType* t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
#line 255 "data-sink.vala"
		t_collection = _tmp0_;
#line 255 "data-sink.vala"
		t_collection_length1 = _tmp0__length1;
#line 255 "data-sink.vala"
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
#line 1230 "data-sink.c"
			GType t = 0UL;
#line 255 "data-sink.vala"
			t = t_collection[t_it];
#line 1234 "data-sink.c"
			{
				GTypeClass* _tmp1_;
				GTypeClass* _tmp2_;
				SynapsePluginInfo* info = NULL;
				SynapsePluginRegistry* _tmp3_;
				SynapsePluginInfo* _tmp4_;
				gboolean _tmp5_ = FALSE;
				SynapsePluginInfo* _tmp6_;
				gboolean skip = FALSE;
				gboolean _tmp8_ = FALSE;
				SynapseDataSinkDataSinkConfiguration* _tmp9_;
#line 257 "data-sink.vala"
				_tmp1_ = g_type_class_ref (t);
#line 257 "data-sink.vala"
				_tmp2_ = _tmp1_;
#line 257 "data-sink.vala"
				_g_type_class_unref0 (_tmp2_);
#line 258 "data-sink.vala"
				_tmp3_ = self->priv->registry;
#line 258 "data-sink.vala"
				_tmp4_ = synapse_plugin_registry_get_plugin_info_for_type (_tmp3_, t);
#line 258 "data-sink.vala"
				info = _tmp4_;
#line 259 "data-sink.vala"
				_tmp6_ = info;
#line 259 "data-sink.vala"
				if (_tmp6_ != NULL) {
#line 1262 "data-sink.c"
					SynapsePluginInfo* _tmp7_;
#line 259 "data-sink.vala"
					_tmp7_ = info;
#line 259 "data-sink.vala"
					_tmp5_ = _tmp7_->runnable == FALSE;
#line 1268 "data-sink.c"
				} else {
#line 259 "data-sink.vala"
					_tmp5_ = FALSE;
#line 1272 "data-sink.c"
				}
#line 259 "data-sink.vala"
				skip = _tmp5_;
#line 260 "data-sink.vala"
				_tmp9_ = self->priv->config;
#line 260 "data-sink.vala"
				if (synapse_data_sink_data_sink_configuration_is_plugin_enabled (_tmp9_, t)) {
#line 260 "data-sink.vala"
					_tmp8_ = !skip;
#line 1282 "data-sink.c"
				} else {
#line 260 "data-sink.vala"
					_tmp8_ = FALSE;
#line 1286 "data-sink.c"
				}
#line 260 "data-sink.vala"
				if (_tmp8_) {
#line 1290 "data-sink.c"
					GObject* plugin = NULL;
					GObject* _tmp10_;
					GObject* _tmp11_;
					GObject* _tmp12_;
#line 262 "data-sink.vala"
					_tmp10_ = synapse_data_sink_create_plugin (self, t);
#line 262 "data-sink.vala"
					plugin = _tmp10_;
#line 263 "data-sink.vala"
					_tmp11_ = plugin;
#line 263 "data-sink.vala"
					synapse_data_sink_register_plugin (self, _tmp11_);
#line 264 "data-sink.vala"
					_tmp12_ = plugin;
#line 264 "data-sink.vala"
					synapse_activatable_activate (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable));
#line 260 "data-sink.vala"
					_g_object_unref0 (plugin);
#line 1309 "data-sink.c"
				}
#line 255 "data-sink.vala"
				_synapse_plugin_info_unref0 (info);
#line 1313 "data-sink.c"
			}
		}
	}
#line 268 "data-sink.vala"
	self->priv->plugins_loaded = TRUE;
#line 1319 "data-sink.c"
}

static gboolean
_vala_g_type_array_contains (GType * stack,
                             gssize stack_length,
                             const GType needle)
{
	gssize i;
#line 275 "data-sink.vala"
	for (i = 0; i < stack_length; i++) {
#line 275 "data-sink.vala"
		if (needle == stack[i]) {
#line 275 "data-sink.vala"
			return TRUE;
#line 1334 "data-sink.c"
		}
	}
#line 275 "data-sink.vala"
	return FALSE;
#line 1339 "data-sink.c"
}

static void
_vala_array_add2 (GType* * array,
                  gint* length,
                  gint* size,
                  GType value)
{
#line 276 "data-sink.vala"
	if ((*length) == (*size)) {
#line 276 "data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 276 "data-sink.vala"
		*array = g_renew (GType, *array, *size);
#line 1354 "data-sink.c"
	}
#line 276 "data-sink.vala"
	(*array)[(*length)++] = value;
#line 1358 "data-sink.c"
}

void
synapse_data_sink_register_static_plugin (SynapseDataSink* self,
                                          GType plugin_type)
{
	GType* _tmp0_;
	gint _tmp0__length1;
#line 273 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 275 "data-sink.vala"
	_tmp0_ = self->priv->plugin_types;
#line 275 "data-sink.vala"
	_tmp0__length1 = self->priv->plugin_types_length1;
#line 275 "data-sink.vala"
	if (_vala_g_type_array_contains (_tmp0_, _tmp0__length1, plugin_type)) {
#line 275 "data-sink.vala"
		return;
#line 1377 "data-sink.c"
	}
#line 276 "data-sink.vala"
	_vala_array_add2 (&self->priv->plugin_types, &self->priv->plugin_types_length1, &self->priv->_plugin_types_size_, plugin_type);
#line 1381 "data-sink.c"
}

GObject*
synapse_data_sink_get_plugin (SynapseDataSink* self,
                              const gchar* name)
{
	GObject* _result_ = NULL;
	GObject* _tmp8_;
	GObject* result;
#line 279 "data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 279 "data-sink.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 281 "data-sink.vala"
	_result_ = NULL;
#line 1397 "data-sink.c"
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 283 "data-sink.vala"
		_tmp0_ = self->priv->item_plugins;
#line 283 "data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 283 "data-sink.vala"
		_plugin_it = _tmp1_;
#line 283 "data-sink.vala"
		while (TRUE) {
#line 1410 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseItemProvider* _tmp5_;
			const gchar* _tmp6_;
#line 283 "data-sink.vala"
			_tmp2_ = _plugin_it;
#line 283 "data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 283 "data-sink.vala"
				break;
#line 1423 "data-sink.c"
			}
#line 283 "data-sink.vala"
			_tmp3_ = _plugin_it;
#line 283 "data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 283 "data-sink.vala"
			plugin = (SynapseItemProvider*) _tmp4_;
#line 285 "data-sink.vala"
			_tmp5_ = plugin;
#line 285 "data-sink.vala"
			_tmp6_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_));
#line 285 "data-sink.vala"
			if (g_strcmp0 (_tmp6_, name) == 0) {
#line 1437 "data-sink.c"
				SynapseItemProvider* _tmp7_;
#line 287 "data-sink.vala"
				_tmp7_ = plugin;
#line 287 "data-sink.vala"
				_result_ = (GObject*) _tmp7_;
#line 288 "data-sink.vala"
				_g_object_unref0 (plugin);
#line 288 "data-sink.vala"
				break;
#line 1447 "data-sink.c"
			}
#line 283 "data-sink.vala"
			_g_object_unref0 (plugin);
#line 1451 "data-sink.c"
		}
#line 283 "data-sink.vala"
		_g_object_unref0 (_plugin_it);
#line 1455 "data-sink.c"
	}
#line 292 "data-sink.vala"
	_tmp8_ = _result_;
#line 292 "data-sink.vala"
	result = _tmp8_;
#line 292 "data-sink.vala"
	return result;
#line 1463 "data-sink.c"
}

gboolean
synapse_data_sink_is_plugin_enabled (SynapseDataSink* self,
                                     GType plugin_type)
{
	gboolean result;
#line 295 "data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1473 "data-sink.c"
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 297 "data-sink.vala"
		_tmp0_ = self->priv->item_plugins;
#line 297 "data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 297 "data-sink.vala"
		_plugin_it = _tmp1_;
#line 297 "data-sink.vala"
		while (TRUE) {
#line 1486 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseItemProvider* _tmp5_;
#line 297 "data-sink.vala"
			_tmp2_ = _plugin_it;
#line 297 "data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 297 "data-sink.vala"
				break;
#line 1498 "data-sink.c"
			}
#line 297 "data-sink.vala"
			_tmp3_ = _plugin_it;
#line 297 "data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 297 "data-sink.vala"
			plugin = (SynapseItemProvider*) _tmp4_;
#line 299 "data-sink.vala"
			_tmp5_ = plugin;
#line 299 "data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_) == plugin_type) {
#line 1510 "data-sink.c"
				SynapseItemProvider* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
#line 299 "data-sink.vala"
				_tmp6_ = plugin;
#line 299 "data-sink.vala"
				_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 299 "data-sink.vala"
				_tmp8_ = _tmp7_;
#line 299 "data-sink.vala"
				result = _tmp8_;
#line 299 "data-sink.vala"
				_g_object_unref0 (plugin);
#line 299 "data-sink.vala"
				_g_object_unref0 (_plugin_it);
#line 299 "data-sink.vala"
				return result;
#line 1528 "data-sink.c"
			}
#line 297 "data-sink.vala"
			_g_object_unref0 (plugin);
#line 1532 "data-sink.c"
		}
#line 297 "data-sink.vala"
		_g_object_unref0 (_plugin_it);
#line 1536 "data-sink.c"
	}
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
#line 302 "data-sink.vala"
		_tmp9_ = self->priv->action_plugins;
#line 302 "data-sink.vala"
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
#line 302 "data-sink.vala"
		_action_it = _tmp10_;
#line 302 "data-sink.vala"
		while (TRUE) {
#line 1550 "data-sink.c"
			GeeIterator* _tmp11_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			SynapseActionProvider* _tmp14_;
#line 302 "data-sink.vala"
			_tmp11_ = _action_it;
#line 302 "data-sink.vala"
			if (!gee_iterator_next (_tmp11_)) {
#line 302 "data-sink.vala"
				break;
#line 1562 "data-sink.c"
			}
#line 302 "data-sink.vala"
			_tmp12_ = _action_it;
#line 302 "data-sink.vala"
			_tmp13_ = gee_iterator_get (_tmp12_);
#line 302 "data-sink.vala"
			action = (SynapseActionProvider*) _tmp13_;
#line 304 "data-sink.vala"
			_tmp14_ = action;
#line 304 "data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp14_) == plugin_type) {
#line 1574 "data-sink.c"
				SynapseActionProvider* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
#line 304 "data-sink.vala"
				_tmp15_ = action;
#line 304 "data-sink.vala"
				_tmp16_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp15_);
#line 304 "data-sink.vala"
				_tmp17_ = _tmp16_;
#line 304 "data-sink.vala"
				result = _tmp17_;
#line 304 "data-sink.vala"
				_g_object_unref0 (action);
#line 304 "data-sink.vala"
				_g_object_unref0 (_action_it);
#line 304 "data-sink.vala"
				return result;
#line 1592 "data-sink.c"
			}
#line 302 "data-sink.vala"
			_g_object_unref0 (action);
#line 1596 "data-sink.c"
		}
#line 302 "data-sink.vala"
		_g_object_unref0 (_action_it);
#line 1600 "data-sink.c"
	}
#line 307 "data-sink.vala"
	result = FALSE;
#line 307 "data-sink.vala"
	return result;
#line 1606 "data-sink.c"
}

void
synapse_data_sink_set_plugin_enabled (SynapseDataSink* self,
                                      GType plugin_type,
                                      gboolean enabled)
{
	SynapseDataSinkDataSinkConfiguration* _tmp0_;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseDataSinkDataSinkConfiguration* _tmp3_;
#line 310 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 313 "data-sink.vala"
	_tmp0_ = self->priv->config;
#line 313 "data-sink.vala"
	synapse_data_sink_data_sink_configuration_set_plugin_enabled (_tmp0_, plugin_type, enabled);
#line 314 "data-sink.vala"
	_tmp1_ = synapse_config_service_get_default ();
#line 314 "data-sink.vala"
	_tmp2_ = _tmp1_;
#line 314 "data-sink.vala"
	_tmp3_ = self->priv->config;
#line 314 "data-sink.vala"
	synapse_config_service_set_config (_tmp2_, "data-sink", "global", (SynapseConfigObject*) _tmp3_);
#line 314 "data-sink.vala"
	_g_object_unref0 (_tmp2_);
#line 1634 "data-sink.c"
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
#line 316 "data-sink.vala"
		_tmp4_ = self->priv->item_plugins;
#line 316 "data-sink.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 316 "data-sink.vala"
		_plugin_it = _tmp5_;
#line 316 "data-sink.vala"
		while (TRUE) {
#line 1647 "data-sink.c"
			GeeIterator* _tmp6_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SynapseItemProvider* _tmp9_;
#line 316 "data-sink.vala"
			_tmp6_ = _plugin_it;
#line 316 "data-sink.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 316 "data-sink.vala"
				break;
#line 1659 "data-sink.c"
			}
#line 316 "data-sink.vala"
			_tmp7_ = _plugin_it;
#line 316 "data-sink.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 316 "data-sink.vala"
			plugin = (SynapseItemProvider*) _tmp8_;
#line 318 "data-sink.vala"
			_tmp9_ = plugin;
#line 318 "data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp9_) == plugin_type) {
#line 1671 "data-sink.c"
				SynapseItemProvider* _tmp10_;
#line 320 "data-sink.vala"
				_tmp10_ = plugin;
#line 320 "data-sink.vala"
				synapse_activatable_set_enabled ((SynapseActivatable*) _tmp10_, enabled);
#line 321 "data-sink.vala"
				if (enabled) {
#line 1679 "data-sink.c"
					SynapseItemProvider* _tmp11_;
#line 321 "data-sink.vala"
					_tmp11_ = plugin;
#line 321 "data-sink.vala"
					synapse_activatable_activate ((SynapseActivatable*) _tmp11_);
#line 1685 "data-sink.c"
				} else {
					SynapseItemProvider* _tmp12_;
#line 322 "data-sink.vala"
					_tmp12_ = plugin;
#line 322 "data-sink.vala"
					synapse_activatable_deactivate ((SynapseActivatable*) _tmp12_);
#line 1692 "data-sink.c"
				}
#line 323 "data-sink.vala"
				synapse_data_sink_update_has_empty_handlers (self);
#line 324 "data-sink.vala"
				_g_object_unref0 (plugin);
#line 324 "data-sink.vala"
				_g_object_unref0 (_plugin_it);
#line 324 "data-sink.vala"
				return;
#line 1702 "data-sink.c"
			}
#line 316 "data-sink.vala"
			_g_object_unref0 (plugin);
#line 1706 "data-sink.c"
		}
#line 316 "data-sink.vala"
		_g_object_unref0 (_plugin_it);
#line 1710 "data-sink.c"
	}
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp13_;
		GeeIterator* _tmp14_;
#line 328 "data-sink.vala"
		_tmp13_ = self->priv->action_plugins;
#line 328 "data-sink.vala"
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
#line 328 "data-sink.vala"
		_action_it = _tmp14_;
#line 328 "data-sink.vala"
		while (TRUE) {
#line 1724 "data-sink.c"
			GeeIterator* _tmp15_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			SynapseActionProvider* _tmp18_;
#line 328 "data-sink.vala"
			_tmp15_ = _action_it;
#line 328 "data-sink.vala"
			if (!gee_iterator_next (_tmp15_)) {
#line 328 "data-sink.vala"
				break;
#line 1736 "data-sink.c"
			}
#line 328 "data-sink.vala"
			_tmp16_ = _action_it;
#line 328 "data-sink.vala"
			_tmp17_ = gee_iterator_get (_tmp16_);
#line 328 "data-sink.vala"
			action = (SynapseActionProvider*) _tmp17_;
#line 330 "data-sink.vala"
			_tmp18_ = action;
#line 330 "data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_) == plugin_type) {
#line 1748 "data-sink.c"
				SynapseActionProvider* _tmp19_;
#line 332 "data-sink.vala"
				_tmp19_ = action;
#line 332 "data-sink.vala"
				synapse_activatable_set_enabled ((SynapseActivatable*) _tmp19_, enabled);
#line 333 "data-sink.vala"
				if (enabled) {
#line 1756 "data-sink.c"
					SynapseActionProvider* _tmp20_;
#line 333 "data-sink.vala"
					_tmp20_ = action;
#line 333 "data-sink.vala"
					synapse_activatable_activate ((SynapseActivatable*) _tmp20_);
#line 1762 "data-sink.c"
				} else {
					SynapseActionProvider* _tmp21_;
#line 334 "data-sink.vala"
					_tmp21_ = action;
#line 334 "data-sink.vala"
					synapse_activatable_deactivate ((SynapseActivatable*) _tmp21_);
#line 1769 "data-sink.c"
				}
#line 335 "data-sink.vala"
				synapse_data_sink_update_has_unknown_handlers (self);
#line 336 "data-sink.vala"
				_g_object_unref0 (action);
#line 336 "data-sink.vala"
				_g_object_unref0 (_action_it);
#line 336 "data-sink.vala"
				return;
#line 1779 "data-sink.c"
			}
#line 328 "data-sink.vala"
			_g_object_unref0 (action);
#line 1783 "data-sink.c"
		}
#line 328 "data-sink.vala"
		_g_object_unref0 (_action_it);
#line 1787 "data-sink.c"
	}
#line 341 "data-sink.vala"
	if (enabled) {
#line 1791 "data-sink.c"
		GObject* new_instance = NULL;
		GObject* _tmp22_;
		GObject* _tmp23_;
		GObject* _tmp24_;
#line 343 "data-sink.vala"
		_tmp22_ = synapse_data_sink_create_plugin (self, plugin_type);
#line 343 "data-sink.vala"
		new_instance = _tmp22_;
#line 344 "data-sink.vala"
		_tmp23_ = new_instance;
#line 344 "data-sink.vala"
		synapse_data_sink_register_plugin (self, _tmp23_);
#line 345 "data-sink.vala"
		_tmp24_ = new_instance;
#line 345 "data-sink.vala"
		synapse_activatable_activate (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable));
#line 341 "data-sink.vala"
		_g_object_unref0 (new_instance);
#line 1810 "data-sink.c"
	}
}

static void
synapse_data_sink_real_search_data_free (gpointer _data)
{
	SynapseDataSinkSearchData* _data_;
	_data_ = _data;
#line 242 "data-sink.vala"
	_g_free0 (_data_->query);
#line 242 "data-sink.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 242 "data-sink.vala"
	_g_object_unref0 (_data_->cancellable);
#line 242 "data-sink.vala"
	_g_object_unref0 (_data_->result);
#line 242 "data-sink.vala"
	_g_object_unref0 (_data_->self);
#line 242 "data-sink.vala"
	g_slice_free (SynapseDataSinkSearchData, _data_);
#line 1831 "data-sink.c"
}

static void
synapse_data_sink_real_search (SynapseSearchProvider* base,
                               const gchar* query,
                               SynapseQueryFlags flags,
                               SynapseResultSet* dest_result_set,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SynapseDataSink * self;
	SynapseDataSinkSearchData* _data_;
	SynapseDataSink* _tmp0_;
	gchar* _tmp1_;
	SynapseResultSet* _tmp2_;
	GCancellable* _tmp3_;
#line 242 "data-sink.vala"
	g_return_if_fail (query != NULL);
#line 242 "data-sink.vala"
	self = (SynapseDataSink*) base;
#line 242 "data-sink.vala"
	_data_ = g_slice_new0 (SynapseDataSinkSearchData);
#line 242 "data-sink.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 242 "data-sink.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_data_sink_real_search_data_free);
#line 242 "data-sink.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 242 "data-sink.vala"
	_data_->self = _tmp0_;
#line 242 "data-sink.vala"
	_tmp1_ = g_strdup (query);
#line 242 "data-sink.vala"
	_g_free0 (_data_->query);
#line 242 "data-sink.vala"
	_data_->query = _tmp1_;
#line 242 "data-sink.vala"
	_data_->flags = flags;
#line 242 "data-sink.vala"
	_tmp2_ = _g_object_ref0 (dest_result_set);
#line 242 "data-sink.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 242 "data-sink.vala"
	_data_->dest_result_set = _tmp2_;
#line 242 "data-sink.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 242 "data-sink.vala"
	_g_object_unref0 (_data_->cancellable);
#line 242 "data-sink.vala"
	_data_->cancellable = _tmp3_;
#line 242 "data-sink.vala"
	synapse_data_sink_real_search_co (_data_);
#line 1885 "data-sink.c"
}

static GeeList*
synapse_data_sink_search_finish (SynapseSearchProvider* base,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GeeList* result;
	SynapseDataSinkSearchData* _data_;
#line 242 "data-sink.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 242 "data-sink.vala"
	if (NULL == _data_) {
#line 242 "data-sink.vala"
		return NULL;
#line 1901 "data-sink.c"
	}
#line 242 "data-sink.vala"
	result = _data_->result;
#line 242 "data-sink.vala"
	_data_->result = NULL;
#line 242 "data-sink.vala"
	return result;
#line 1909 "data-sink.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 352 "data-sink.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 352 "data-sink.vala"
	return _data3_;
#line 1919 "data-sink.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 352 "data-sink.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1927 "data-sink.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 352 "data-sink.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1935 "data-sink.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 352 "data-sink.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1945 "data-sink.c"
		SynapseDataSink* self;
#line 352 "data-sink.vala"
		self = _data3_->self;
#line 352 "data-sink.vala"
		_g_object_unref0 (_data3_->current_result_set);
#line 352 "data-sink.vala"
		(_data3_->cancellables == NULL) ? NULL : (_data3_->cancellables = (_g_list_free__g_object_unref0_ (_data3_->cancellables), NULL));
#line 352 "data-sink.vala"
		synapse_query_destroy (&_data3_->q);
#line 352 "data-sink.vala"
		_g_object_unref0 (self);
#line 352 "data-sink.vala"
		g_slice_free (Block3Data, _data3_);
#line 1959 "data-sink.c"
	}
}

static gboolean
_synapse_data_sink_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_data_sink_real_search_co (self);
#line 360 "data-sink.vala"
	return result;
#line 1970 "data-sink.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 1991 "data-sink.c"
}

static void
____lambda16_ (Block3Data* _data3_,
               GObject* src_obj,
               GAsyncResult* res)
{
	SynapseDataSink* self;
	SynapseItemProvider* plugin = NULL;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	GError* _inner_error0_ = NULL;
#line 394 "data-sink.vala"
	self = _data3_->self;
#line 394 "data-sink.vala"
	g_return_if_fail (res != NULL);
#line 395 "data-sink.vala"
	plugin = SYNAPSE_IS_ITEM_PROVIDER (src_obj) ? ((SynapseItemProvider*) src_obj) : NULL;
#line 396 "data-sink.vala"
	g_return_if_fail (plugin != NULL);
#line 2012 "data-sink.c"
	{
		SynapseResultSet* results = NULL;
		SynapseResultSet* _tmp0_;
		const gchar* _tmp1_;
		SynapseQuery _tmp2_;
		SynapseResultSet* _tmp3_;
#line 400 "data-sink.vala"
		_tmp0_ = synapse_item_provider_search_finish (plugin, res, &_inner_error0_);
#line 400 "data-sink.vala"
		results = _tmp0_;
#line 400 "data-sink.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 400 "data-sink.vala"
			if (_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 2027 "data-sink.c"
				goto __catch0_synapse_search_error;
			}
#line 400 "data-sink.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 400 "data-sink.vala"
			g_clear_error (&_inner_error0_);
#line 400 "data-sink.vala"
			return;
#line 2036 "data-sink.c"
		}
#line 401 "data-sink.vala"
		_tmp1_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) plugin));
#line 401 "data-sink.vala"
		_tmp2_ = _data3_->q;
#line 401 "data-sink.vala"
		g_signal_emit (self, synapse_data_sink_signals[SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL], g_quark_from_string (_tmp1_), results, _tmp2_.query_id);
#line 402 "data-sink.vala"
		_tmp3_ = _data3_->current_result_set;
#line 402 "data-sink.vala"
		synapse_result_set_add_all (_tmp3_, results);
#line 398 "data-sink.vala"
		_g_object_unref0 (results);
#line 2050 "data-sink.c"
	}
	goto __finally0;
	__catch0_synapse_search_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
#line 398 "data-sink.vala"
		err = _inner_error0_;
#line 398 "data-sink.vala"
		_inner_error0_ = NULL;
#line 406 "data-sink.vala"
		_tmp4_ = err;
#line 406 "data-sink.vala"
		if (!g_error_matches (_tmp4_, SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED)) {
#line 2065 "data-sink.c"
			const gchar* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
#line 408 "data-sink.vala"
			_tmp5_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) plugin));
#line 408 "data-sink.vala"
			_tmp6_ = err;
#line 408 "data-sink.vala"
			_tmp7_ = _tmp6_->message;
#line 408 "data-sink.vala"
			g_warning ("data-sink.vala:408: %s returned error: %s", _tmp5_, _tmp7_);
#line 2077 "data-sink.c"
		}
#line 398 "data-sink.vala"
		_g_error_free0 (err);
#line 2081 "data-sink.c"
	}
	__finally0:
#line 398 "data-sink.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 398 "data-sink.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 398 "data-sink.vala"
		g_clear_error (&_inner_error0_);
#line 398 "data-sink.vala"
		return;
#line 2092 "data-sink.c"
	}
#line 413 "data-sink.vala"
	_data3_->search_size = _data3_->search_size - 1;
#line 413 "data-sink.vala"
	_tmp9_ = _data3_->search_size;
#line 413 "data-sink.vala"
	if (_tmp9_ == 0) {
#line 413 "data-sink.vala"
		_tmp8_ = _data3_->waiting;
#line 2102 "data-sink.c"
	} else {
#line 413 "data-sink.vala"
		_tmp8_ = FALSE;
#line 2106 "data-sink.c"
	}
#line 413 "data-sink.vala"
	if (_tmp8_) {
#line 413 "data-sink.vala"
		synapse_data_sink_real_search_co (_data3_->_async_data_);
#line 2112 "data-sink.c"
	}
}

static void
_____lambda16__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
#line 394 "data-sink.vala"
	____lambda16_ (self, source_object, res);
#line 394 "data-sink.vala"
	block3_data_unref (self);
#line 2125 "data-sink.c"
}

static void
___lambda17_ (Block3Data* _data3_)
{
	SynapseDataSink* self;
	GList* _tmp0_;
#line 420 "data-sink.vala"
	self = _data3_->self;
#line 421 "data-sink.vala"
	_tmp0_ = _data3_->cancellables;
#line 2137 "data-sink.c"
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
#line 421 "data-sink.vala"
		c_collection = _tmp0_;
#line 421 "data-sink.vala"
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
#line 2145 "data-sink.c"
			GCancellable* _tmp1_;
			GCancellable* c = NULL;
#line 421 "data-sink.vala"
			_tmp1_ = _g_object_ref0 ((GCancellable*) c_it->data);
#line 421 "data-sink.vala"
			c = _tmp1_;
#line 2152 "data-sink.c"
			{
				GCancellable* _tmp2_;
#line 421 "data-sink.vala"
				_tmp2_ = c;
#line 421 "data-sink.vala"
				g_cancellable_cancel (_tmp2_);
#line 421 "data-sink.vala"
				_g_object_unref0 (c);
#line 2161 "data-sink.c"
			}
		}
	}
}

static void
____lambda17__gfunc (gconstpointer data,
                     gpointer self)
{
#line 420 "data-sink.vala"
	___lambda17_ (self);
#line 2173 "data-sink.c"
}

static gboolean
synapse_data_sink_real_search_co (SynapseDataSinkSearchData* _data_)
{
#line 352 "data-sink.vala"
	switch (_data_->_state_) {
#line 352 "data-sink.vala"
		case 0:
#line 2183 "data-sink.c"
		goto _state_0;
#line 352 "data-sink.vala"
		case 1:
#line 2187 "data-sink.c"
		goto _state_1;
#line 352 "data-sink.vala"
		case 2:
#line 2191 "data-sink.c"
		goto _state_2;
		default:
#line 352 "data-sink.vala"
		g_assert_not_reached ();
#line 2196 "data-sink.c"
	}
	_state_0:
#line 352 "data-sink.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 352 "data-sink.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 352 "data-sink.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 352 "data-sink.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 358 "data-sink.vala"
	while (TRUE) {
#line 358 "data-sink.vala"
		if (!(!_data_->self->priv->plugins_loaded)) {
#line 358 "data-sink.vala"
			break;
#line 2213 "data-sink.c"
		}
#line 360 "data-sink.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _synapse_data_sink_real_search_co_gsource_func, _data_, NULL);
#line 361 "data-sink.vala"
		_data_->_state_ = 1;
#line 361 "data-sink.vala"
		return FALSE;
#line 2221 "data-sink.c"
		_state_1:
		;
#line 362 "data-sink.vala"
		if (_data_->cancellable != NULL) {
#line 362 "data-sink.vala"
			_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->cancellable);
#line 2228 "data-sink.c"
		} else {
#line 362 "data-sink.vala"
			_data_->_tmp0_ = FALSE;
#line 2232 "data-sink.c"
		}
#line 362 "data-sink.vala"
		if (_data_->_tmp0_) {
#line 364 "data-sink.vala"
			_data_->_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
#line 364 "data-sink.vala"
			_data_->_inner_error0_ = _data_->_tmp1_;
#line 364 "data-sink.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 364 "data-sink.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 364 "data-sink.vala"
				block3_data_unref (_data_->_data3_);
#line 364 "data-sink.vala"
				_data_->_data3_ = NULL;
#line 364 "data-sink.vala"
				g_object_unref (_data_->_async_result);
#line 364 "data-sink.vala"
				return FALSE;
#line 2252 "data-sink.c"
			} else {
#line 364 "data-sink.vala"
				block3_data_unref (_data_->_data3_);
#line 364 "data-sink.vala"
				_data_->_data3_ = NULL;
#line 364 "data-sink.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 364 "data-sink.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 364 "data-sink.vala"
				g_object_unref (_data_->_async_result);
#line 364 "data-sink.vala"
				return FALSE;
#line 2266 "data-sink.c"
			}
		}
	}
#line 367 "data-sink.vala"
	_data_->_tmp2_ = _data_->self->priv->query_id;
#line 367 "data-sink.vala"
	_data_->self->priv->query_id = _data_->_tmp2_ + 1;
#line 367 "data-sink.vala"
	_data_->_tmp3_ = _data_->query;
#line 367 "data-sink.vala"
	_data_->_tmp4_ = _data_->flags;
#line 367 "data-sink.vala"
	synapse_query_init (&_data_->_data3_->q, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, (guint) 96);
#line 368 "data-sink.vala"
	_data_->_tmp5_ = string_strip (_data_->query);
#line 368 "data-sink.vala"
	_data_->query_stripped = _data_->_tmp5_;
#line 370 "data-sink.vala"
	_data_->_data3_->cancellables = NULL;
#line 372 "data-sink.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->dest_result_set);
#line 372 "data-sink.vala"
	_data_->_tmp6_ = _data_->_tmp7_;
#line 372 "data-sink.vala"
	if (_data_->_tmp6_ == NULL) {
#line 372 "data-sink.vala"
		_data_->_tmp8_ = synapse_result_set_new ();
#line 372 "data-sink.vala"
		_g_object_unref0 (_data_->_tmp6_);
#line 372 "data-sink.vala"
		_data_->_tmp6_ = _data_->_tmp8_;
#line 2298 "data-sink.c"
	}
#line 372 "data-sink.vala"
	_data_->_tmp9_ = _data_->_tmp6_;
#line 372 "data-sink.vala"
	_data_->_tmp6_ = NULL;
#line 372 "data-sink.vala"
	_data_->_data3_->current_result_set = _data_->_tmp9_;
#line 373 "data-sink.vala"
	_data_->_tmp10_ = _data_->self->priv->item_plugins;
#line 373 "data-sink.vala"
	_data_->_tmp11_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp10_);
#line 373 "data-sink.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 373 "data-sink.vala"
	_data_->_data3_->search_size = _data_->_tmp12_;
#line 376 "data-sink.vala"
	_data_->_data3_->waiting = FALSE;
#line 2316 "data-sink.c"
	{
#line 378 "data-sink.vala"
		_data_->_tmp13_ = _data_->self->priv->item_plugins;
#line 378 "data-sink.vala"
		_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
#line 378 "data-sink.vala"
		_data_->_data_plugin_it = _data_->_tmp14_;
#line 378 "data-sink.vala"
		while (TRUE) {
#line 378 "data-sink.vala"
			_data_->_tmp15_ = _data_->_data_plugin_it;
#line 378 "data-sink.vala"
			if (!gee_iterator_next (_data_->_tmp15_)) {
#line 378 "data-sink.vala"
				break;
#line 2332 "data-sink.c"
			}
#line 378 "data-sink.vala"
			_data_->_tmp16_ = _data_->_data_plugin_it;
#line 378 "data-sink.vala"
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
#line 378 "data-sink.vala"
			_data_->data_plugin = (SynapseItemProvider*) _data_->_tmp17_;
#line 380 "data-sink.vala"
			_data_->_tmp20_ = _data_->data_plugin;
#line 380 "data-sink.vala"
			_data_->_tmp21_ = synapse_activatable_get_enabled ((SynapseActivatable*) _data_->_tmp20_);
#line 380 "data-sink.vala"
			_data_->_tmp22_ = _data_->_tmp21_;
#line 380 "data-sink.vala"
			if (!_data_->_tmp22_) {
#line 380 "data-sink.vala"
				_data_->_tmp19_ = TRUE;
#line 2350 "data-sink.c"
			} else {
#line 381 "data-sink.vala"
				if (g_strcmp0 (_data_->query, "") == 0) {
#line 381 "data-sink.vala"
					_data_->_tmp24_ = _data_->data_plugin;
#line 381 "data-sink.vala"
					_data_->_tmp23_ = !synapse_item_provider_handles_empty_query (_data_->_tmp24_);
#line 2358 "data-sink.c"
				} else {
#line 381 "data-sink.vala"
					_data_->_tmp23_ = FALSE;
#line 2362 "data-sink.c"
				}
#line 381 "data-sink.vala"
				_data_->_tmp19_ = _data_->_tmp23_;
#line 2366 "data-sink.c"
			}
#line 380 "data-sink.vala"
			if (_data_->_tmp19_) {
#line 380 "data-sink.vala"
				_data_->_tmp18_ = TRUE;
#line 2372 "data-sink.c"
			} else {
#line 382 "data-sink.vala"
				_data_->_tmp25_ = _data_->data_plugin;
#line 382 "data-sink.vala"
				_data_->_tmp26_ = _data_->_data3_->q;
#line 382 "data-sink.vala"
				_data_->_tmp18_ = !synapse_item_provider_handles_query (_data_->_tmp25_, &_data_->_tmp26_);
#line 2380 "data-sink.c"
			}
#line 380 "data-sink.vala"
			_data_->skip = _data_->_tmp18_;
#line 383 "data-sink.vala"
			if (_data_->skip) {
#line 385 "data-sink.vala"
				_data_->_tmp27_ = _data_->_data3_->search_size;
#line 385 "data-sink.vala"
				_data_->_data3_->search_size = _data_->_tmp27_ - 1;
#line 386 "data-sink.vala"
				_g_object_unref0 (_data_->data_plugin);
#line 386 "data-sink.vala"
				continue;
#line 2394 "data-sink.c"
			}
#line 390 "data-sink.vala"
			_data_->_tmp28_ = g_cancellable_new ();
#line 390 "data-sink.vala"
			_data_->c = _data_->_tmp28_;
#line 391 "data-sink.vala"
			_data_->_tmp29_ = _data_->c;
#line 391 "data-sink.vala"
			_data_->_tmp30_ = _g_object_ref0 (_data_->_tmp29_);
#line 391 "data-sink.vala"
			_data_->_data3_->cancellables = g_list_prepend (_data_->_data3_->cancellables, _data_->_tmp30_);
#line 392 "data-sink.vala"
			_data_->_tmp31_ = _data_->c;
#line 392 "data-sink.vala"
			_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
#line 392 "data-sink.vala"
			_g_object_unref0 (_data_->_data3_->q.cancellable);
#line 392 "data-sink.vala"
			_data_->_data3_->q.cancellable = _data_->_tmp32_;
#line 394 "data-sink.vala"
			_data_->_tmp33_ = _data_->data_plugin;
#line 394 "data-sink.vala"
			_data_->_tmp34_ = _data_->_data3_->q;
#line 394 "data-sink.vala"
			synapse_item_provider_search (_data_->_tmp33_, &_data_->_tmp34_, _____lambda16__gasync_ready_callback, block3_data_ref (_data_->_data3_));
#line 378 "data-sink.vala"
			_g_object_unref0 (_data_->c);
#line 378 "data-sink.vala"
			_g_object_unref0 (_data_->data_plugin);
#line 2424 "data-sink.c"
		}
#line 378 "data-sink.vala"
		_g_object_unref0 (_data_->_data_plugin_it);
#line 2428 "data-sink.c"
	}
#line 416 "data-sink.vala"
	_data_->_data3_->cancellables = g_list_reverse (_data_->_data3_->cancellables);
#line 418 "data-sink.vala"
	if (_data_->cancellable != NULL) {
#line 420 "data-sink.vala"
		g_cancellable_connect (_data_->cancellable, (GCallback) ____lambda17__gfunc, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 2436 "data-sink.c"
	}
#line 425 "data-sink.vala"
	_data_->_data3_->waiting = TRUE;
#line 426 "data-sink.vala"
	if (_data_->_data3_->search_size > 0) {
#line 426 "data-sink.vala"
		_data_->_state_ = 2;
#line 426 "data-sink.vala"
		return FALSE;
#line 2446 "data-sink.c"
		_state_2:
		;
	}
#line 428 "data-sink.vala"
	if (_data_->cancellable != NULL) {
#line 428 "data-sink.vala"
		_data_->_tmp35_ = g_cancellable_is_cancelled (_data_->cancellable);
#line 2454 "data-sink.c"
	} else {
#line 428 "data-sink.vala"
		_data_->_tmp35_ = FALSE;
#line 2458 "data-sink.c"
	}
#line 428 "data-sink.vala"
	if (_data_->_tmp35_) {
#line 430 "data-sink.vala"
		_data_->_tmp36_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
#line 430 "data-sink.vala"
		_data_->_inner_error0_ = _data_->_tmp36_;
#line 430 "data-sink.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 430 "data-sink.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 430 "data-sink.vala"
			_g_object_unref0 (_data_->_tmp6_);
#line 430 "data-sink.vala"
			_g_free0 (_data_->query_stripped);
#line 430 "data-sink.vala"
			block3_data_unref (_data_->_data3_);
#line 430 "data-sink.vala"
			_data_->_data3_ = NULL;
#line 430 "data-sink.vala"
			g_object_unref (_data_->_async_result);
#line 430 "data-sink.vala"
			return FALSE;
#line 2482 "data-sink.c"
		} else {
#line 430 "data-sink.vala"
			_g_object_unref0 (_data_->_tmp6_);
#line 430 "data-sink.vala"
			_g_free0 (_data_->query_stripped);
#line 430 "data-sink.vala"
			block3_data_unref (_data_->_data3_);
#line 430 "data-sink.vala"
			_data_->_data3_ = NULL;
#line 430 "data-sink.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 430 "data-sink.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 430 "data-sink.vala"
			g_object_unref (_data_->_async_result);
#line 430 "data-sink.vala"
			return FALSE;
#line 2500 "data-sink.c"
		}
	}
#line 433 "data-sink.vala"
	_data_->_tmp38_ = _data_->self->priv->_has_unknown_handlers;
#line 433 "data-sink.vala"
	if (_data_->_tmp38_) {
#line 433 "data-sink.vala"
		_data_->_tmp39_ = _data_->query_stripped;
#line 433 "data-sink.vala"
		_data_->_tmp37_ = g_strcmp0 (_data_->_tmp39_, "") != 0;
#line 2511 "data-sink.c"
	} else {
#line 433 "data-sink.vala"
		_data_->_tmp37_ = FALSE;
#line 2515 "data-sink.c"
	}
#line 433 "data-sink.vala"
	if (_data_->_tmp37_) {
#line 435 "data-sink.vala"
		_data_->_tmp40_ = synapse_unknown_match_new (_data_->query);
#line 435 "data-sink.vala"
		_data_->unknown_match = _data_->_tmp40_;
#line 436 "data-sink.vala"
		_data_->add_to_rs = FALSE;
#line 437 "data-sink.vala"
		if ((_data_->flags & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 437 "data-sink.vala"
			_data_->_tmp41_ = TRUE;
#line 2529 "data-sink.c"
		} else {
#line 437 "data-sink.vala"
			_data_->_tmp41_ = (_data_->flags & SYNAPSE_QUERY_FLAGS_TEXT) == SYNAPSE_QUERY_FLAGS_TEXT;
#line 2533 "data-sink.c"
		}
#line 437 "data-sink.vala"
		if (_data_->_tmp41_) {
#line 440 "data-sink.vala"
			_data_->add_to_rs = TRUE;
#line 2539 "data-sink.c"
		} else {
#line 445 "data-sink.vala"
			_data_->_tmp42_ = _data_->unknown_match;
#line 445 "data-sink.vala"
			_data_->_tmp43_ = synapse_data_sink_find_actions_for_unknown_match (_data_->self, (SynapseMatch*) _data_->_tmp42_, _data_->flags);
#line 445 "data-sink.vala"
			_data_->unknown_match_actions = _data_->_tmp43_;
#line 446 "data-sink.vala"
			_data_->_tmp44_ = _data_->unknown_match_actions;
#line 446 "data-sink.vala"
			_data_->_tmp45_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp44_);
#line 446 "data-sink.vala"
			_data_->_tmp46_ = _data_->_tmp45_;
#line 446 "data-sink.vala"
			if (_data_->_tmp46_ > 0) {
#line 446 "data-sink.vala"
				_data_->add_to_rs = TRUE;
#line 2557 "data-sink.c"
			}
#line 437 "data-sink.vala"
			_g_object_unref0 (_data_->unknown_match_actions);
#line 2561 "data-sink.c"
		}
#line 449 "data-sink.vala"
		if (_data_->add_to_rs) {
#line 449 "data-sink.vala"
			_data_->_tmp47_ = _data_->_data3_->current_result_set;
#line 449 "data-sink.vala"
			_data_->_tmp48_ = _data_->unknown_match;
#line 449 "data-sink.vala"
			synapse_result_set_add (_data_->_tmp47_, (SynapseMatch*) _data_->_tmp48_, 0);
#line 2571 "data-sink.c"
		}
#line 433 "data-sink.vala"
		_g_object_unref0 (_data_->unknown_match);
#line 2575 "data-sink.c"
	}
#line 452 "data-sink.vala"
	_data_->_tmp49_ = _data_->_data3_->current_result_set;
#line 452 "data-sink.vala"
	_data_->_tmp50_ = synapse_result_set_get_sorted_list (_data_->_tmp49_);
#line 452 "data-sink.vala"
	_data_->result = _data_->_tmp50_;
#line 452 "data-sink.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 452 "data-sink.vala"
	_g_free0 (_data_->query_stripped);
#line 452 "data-sink.vala"
	block3_data_unref (_data_->_data3_);
#line 452 "data-sink.vala"
	_data_->_data3_ = NULL;
#line 452 "data-sink.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 452 "data-sink.vala"
	if (_data_->_state_ != 0) {
#line 452 "data-sink.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 452 "data-sink.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2599 "data-sink.c"
		}
	}
#line 452 "data-sink.vala"
	g_object_unref (_data_->_async_result);
#line 452 "data-sink.vala"
	return FALSE;
#line 2606 "data-sink.c"
}

GeeList*
synapse_data_sink_find_actions_for_unknown_match (SynapseDataSink* self,
                                                  SynapseMatch* match,
                                                  SynapseQueryFlags flags)
{
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp0_;
	SynapseQuery q = {0};
	SynapseResultSet* _tmp14_;
	GeeList* _tmp15_;
	GeeList* result;
#line 455 "data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 455 "data-sink.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 458 "data-sink.vala"
	_tmp0_ = synapse_result_set_new ();
#line 458 "data-sink.vala"
	rs = _tmp0_;
#line 459 "data-sink.vala"
	synapse_query_init (&q, (guint) 0, "", flags, (guint) 96);
#line 2630 "data-sink.c"
	{
		GeeIterator* _action_plugin_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
#line 460 "data-sink.vala"
		_tmp1_ = self->priv->action_plugins;
#line 460 "data-sink.vala"
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
#line 460 "data-sink.vala"
		_action_plugin_it = _tmp2_;
#line 460 "data-sink.vala"
		while (TRUE) {
#line 2643 "data-sink.c"
			GeeIterator* _tmp3_;
			SynapseActionProvider* action_plugin = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SynapseActionProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			SynapseActionProvider* _tmp9_;
			SynapseResultSet* _tmp10_;
			SynapseActionProvider* _tmp11_;
			SynapseResultSet* _tmp12_;
			SynapseResultSet* _tmp13_;
#line 460 "data-sink.vala"
			_tmp3_ = _action_plugin_it;
#line 460 "data-sink.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 460 "data-sink.vala"
				break;
#line 2662 "data-sink.c"
			}
#line 460 "data-sink.vala"
			_tmp4_ = _action_plugin_it;
#line 460 "data-sink.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 460 "data-sink.vala"
			action_plugin = (SynapseActionProvider*) _tmp5_;
#line 462 "data-sink.vala"
			_tmp6_ = action_plugin;
#line 462 "data-sink.vala"
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 462 "data-sink.vala"
			_tmp8_ = _tmp7_;
#line 462 "data-sink.vala"
			if (!_tmp8_) {
#line 462 "data-sink.vala"
				_g_object_unref0 (action_plugin);
#line 462 "data-sink.vala"
				continue;
#line 2682 "data-sink.c"
			}
#line 463 "data-sink.vala"
			_tmp9_ = action_plugin;
#line 463 "data-sink.vala"
			if (!synapse_action_provider_handles_unknown (_tmp9_)) {
#line 463 "data-sink.vala"
				_g_object_unref0 (action_plugin);
#line 463 "data-sink.vala"
				continue;
#line 2692 "data-sink.c"
			}
#line 464 "data-sink.vala"
			_tmp10_ = rs;
#line 464 "data-sink.vala"
			_tmp11_ = action_plugin;
#line 464 "data-sink.vala"
			_tmp12_ = synapse_action_provider_find_for_match (_tmp11_, &q, match);
#line 464 "data-sink.vala"
			_tmp13_ = _tmp12_;
#line 464 "data-sink.vala"
			synapse_result_set_add_all (_tmp10_, _tmp13_);
#line 464 "data-sink.vala"
			_g_object_unref0 (_tmp13_);
#line 460 "data-sink.vala"
			_g_object_unref0 (action_plugin);
#line 2708 "data-sink.c"
		}
#line 460 "data-sink.vala"
		_g_object_unref0 (_action_plugin_it);
#line 2712 "data-sink.c"
	}
#line 467 "data-sink.vala"
	_tmp14_ = rs;
#line 467 "data-sink.vala"
	_tmp15_ = synapse_result_set_get_sorted_list (_tmp14_);
#line 467 "data-sink.vala"
	result = _tmp15_;
#line 467 "data-sink.vala"
	synapse_query_destroy (&q);
#line 467 "data-sink.vala"
	_g_object_unref0 (rs);
#line 467 "data-sink.vala"
	return result;
#line 2726 "data-sink.c"
}

GeeList*
synapse_data_sink_find_actions_for_match (SynapseDataSink* self,
                                          SynapseMatch* match,
                                          const gchar* query,
                                          SynapseQueryFlags flags)
{
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SynapseQuery q = {0};
	SynapseResultSet* _tmp14_;
	GeeList* _tmp15_;
	GeeList* result;
#line 470 "data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 470 "data-sink.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 473 "data-sink.vala"
	_tmp0_ = synapse_result_set_new ();
#line 473 "data-sink.vala"
	rs = _tmp0_;
#line 474 "data-sink.vala"
	_tmp1_ = query;
#line 474 "data-sink.vala"
	if (_tmp1_ == NULL) {
#line 474 "data-sink.vala"
		_tmp1_ = "";
#line 2756 "data-sink.c"
	}
#line 474 "data-sink.vala"
	synapse_query_init (&q, (guint) 0, _tmp1_, flags, (guint) 96);
#line 2760 "data-sink.c"
	{
		GeeIterator* _action_plugin_it = NULL;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
#line 475 "data-sink.vala"
		_tmp2_ = self->priv->action_plugins;
#line 475 "data-sink.vala"
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
#line 475 "data-sink.vala"
		_action_plugin_it = _tmp3_;
#line 475 "data-sink.vala"
		while (TRUE) {
#line 2773 "data-sink.c"
			GeeIterator* _tmp4_;
			SynapseActionProvider* action_plugin = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			SynapseActionProvider* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			SynapseResultSet* _tmp10_;
			SynapseActionProvider* _tmp11_;
			SynapseResultSet* _tmp12_;
			SynapseResultSet* _tmp13_;
#line 475 "data-sink.vala"
			_tmp4_ = _action_plugin_it;
#line 475 "data-sink.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 475 "data-sink.vala"
				break;
#line 2791 "data-sink.c"
			}
#line 475 "data-sink.vala"
			_tmp5_ = _action_plugin_it;
#line 475 "data-sink.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 475 "data-sink.vala"
			action_plugin = (SynapseActionProvider*) _tmp6_;
#line 477 "data-sink.vala"
			_tmp7_ = action_plugin;
#line 477 "data-sink.vala"
			_tmp8_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp7_);
#line 477 "data-sink.vala"
			_tmp9_ = _tmp8_;
#line 477 "data-sink.vala"
			if (!_tmp9_) {
#line 477 "data-sink.vala"
				_g_object_unref0 (action_plugin);
#line 477 "data-sink.vala"
				continue;
#line 2811 "data-sink.c"
			}
#line 478 "data-sink.vala"
			_tmp10_ = rs;
#line 478 "data-sink.vala"
			_tmp11_ = action_plugin;
#line 478 "data-sink.vala"
			_tmp12_ = synapse_action_provider_find_for_match (_tmp11_, &q, match);
#line 478 "data-sink.vala"
			_tmp13_ = _tmp12_;
#line 478 "data-sink.vala"
			synapse_result_set_add_all (_tmp10_, _tmp13_);
#line 478 "data-sink.vala"
			_g_object_unref0 (_tmp13_);
#line 475 "data-sink.vala"
			_g_object_unref0 (action_plugin);
#line 2827 "data-sink.c"
		}
#line 475 "data-sink.vala"
		_g_object_unref0 (_action_plugin_it);
#line 2831 "data-sink.c"
	}
#line 481 "data-sink.vala"
	_tmp14_ = rs;
#line 481 "data-sink.vala"
	_tmp15_ = synapse_result_set_get_sorted_list (_tmp14_);
#line 481 "data-sink.vala"
	result = _tmp15_;
#line 481 "data-sink.vala"
	synapse_query_destroy (&q);
#line 481 "data-sink.vala"
	_g_object_unref0 (rs);
#line 481 "data-sink.vala"
	return result;
#line 2845 "data-sink.c"
}

gboolean
synapse_data_sink_get_has_empty_handlers (SynapseDataSink* self)
{
	gboolean result;
#line 186 "data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 186 "data-sink.vala"
	result = self->priv->_has_empty_handlers;
#line 186 "data-sink.vala"
	return result;
#line 2858 "data-sink.c"
}

void
synapse_data_sink_set_has_empty_handlers (SynapseDataSink* self,
                                          gboolean value)
{
	gboolean old_value;
#line 186 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 186 "data-sink.vala"
	old_value = synapse_data_sink_get_has_empty_handlers (self);
#line 186 "data-sink.vala"
	if (old_value != value) {
#line 186 "data-sink.vala"
		self->priv->_has_empty_handlers = value;
#line 186 "data-sink.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY]);
#line 2876 "data-sink.c"
	}
}

gboolean
synapse_data_sink_get_has_unknown_handlers (SynapseDataSink* self)
{
	gboolean result;
#line 187 "data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 187 "data-sink.vala"
	result = self->priv->_has_unknown_handlers;
#line 187 "data-sink.vala"
	return result;
#line 2890 "data-sink.c"
}

void
synapse_data_sink_set_has_unknown_handlers (SynapseDataSink* self,
                                            gboolean value)
{
	gboolean old_value;
#line 187 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 187 "data-sink.vala"
	old_value = synapse_data_sink_get_has_unknown_handlers (self);
#line 187 "data-sink.vala"
	if (old_value != value) {
#line 187 "data-sink.vala"
		self->priv->_has_unknown_handlers = value;
#line 187 "data-sink.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY]);
#line 2908 "data-sink.c"
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 242 "data-sink.vala"
	g_return_if_fail (n_param_values == 3);
#line 242 "data-sink.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 242 "data-sink.vala"
		data1 = closure->data;
#line 242 "data-sink.vala"
		data2 = param_values->data[0].v_pointer;
#line 2934 "data-sink.c"
	} else {
#line 242 "data-sink.vala"
		data1 = param_values->data[0].v_pointer;
#line 242 "data-sink.vala"
		data2 = closure->data;
#line 2940 "data-sink.c"
	}
#line 242 "data-sink.vala"
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 242 "data-sink.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
#line 2946 "data-sink.c"
}

static inline gpointer
synapse_data_sink_data_sink_configuration_get_instance_private (SynapseDataSinkDataSinkConfiguration* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSinkDataSinkConfiguration_private_offset);
}

static void
synapse_data_sink_data_sink_configuration_set_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                              GType t,
                                                              gboolean enabled)
{
#line 56 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 58 "data-sink.vala"
	if (enabled) {
#line 2964 "data-sink.c"
		const gchar* _tmp0_;
#line 58 "data-sink.vala"
		_tmp0_ = g_type_name (t);
#line 58 "data-sink.vala"
		synapse_data_sink_data_sink_configuration_enable_plugin (self, _tmp0_);
#line 2970 "data-sink.c"
	} else {
		const gchar* _tmp1_;
#line 59 "data-sink.vala"
		_tmp1_ = g_type_name (t);
#line 59 "data-sink.vala"
		synapse_data_sink_data_sink_configuration_disable_plugin (self, _tmp1_);
#line 2977 "data-sink.c"
	}
}

static gboolean
synapse_data_sink_data_sink_configuration_is_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                             GType t)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* plugin_name = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
#line 62 "data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "data-sink.vala"
	_tmp0_ = self->priv->_disabled_plugins;
#line 64 "data-sink.vala"
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
#line 64 "data-sink.vala"
	if (_tmp0_ == NULL) {
#line 64 "data-sink.vala"
		result = TRUE;
#line 64 "data-sink.vala"
		return result;
#line 3004 "data-sink.c"
	}
#line 65 "data-sink.vala"
	_tmp1_ = g_type_name (t);
#line 65 "data-sink.vala"
	plugin_name = _tmp1_;
#line 66 "data-sink.vala"
	_tmp2_ = self->priv->_disabled_plugins;
#line 66 "data-sink.vala"
	_tmp2__length1 = self->priv->_disabled_plugins_length1;
#line 3014 "data-sink.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 66 "data-sink.vala"
		s_collection = _tmp2_;
#line 66 "data-sink.vala"
		s_collection_length1 = _tmp2__length1;
#line 66 "data-sink.vala"
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
#line 3026 "data-sink.c"
			gchar* _tmp3_;
			gchar* s = NULL;
#line 66 "data-sink.vala"
			_tmp3_ = g_strdup (s_collection[s_it]);
#line 66 "data-sink.vala"
			s = _tmp3_;
#line 3033 "data-sink.c"
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_;
#line 68 "data-sink.vala"
				_tmp4_ = s;
#line 68 "data-sink.vala"
				_tmp5_ = plugin_name;
#line 68 "data-sink.vala"
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 68 "data-sink.vala"
					result = FALSE;
#line 68 "data-sink.vala"
					_g_free0 (s);
#line 68 "data-sink.vala"
					return result;
#line 3049 "data-sink.c"
				}
#line 66 "data-sink.vala"
				_g_free0 (s);
#line 3053 "data-sink.c"
			}
		}
	}
#line 70 "data-sink.vala"
	result = TRUE;
#line 70 "data-sink.vala"
	return result;
#line 3061 "data-sink.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 76 "data-sink.vala"
	for (i = 0; i < stack_length; i++) {
#line 76 "data-sink.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 76 "data-sink.vala"
			return TRUE;
#line 3076 "data-sink.c"
		}
	}
#line 76 "data-sink.vala"
	return FALSE;
#line 3081 "data-sink.c"
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 81 "data-sink.vala"
	if ((*length) == (*size)) {
#line 81 "data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 81 "data-sink.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3096 "data-sink.c"
	}
#line 81 "data-sink.vala"
	(*array)[(*length)++] = value;
#line 81 "data-sink.vala"
	(*array)[*length] = NULL;
#line 3102 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_enable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                         const gchar* name)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** cpy = NULL;
	gchar** _tmp2_;
	gint cpy_length1;
	gint _cpy_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
#line 73 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 73 "data-sink.vala"
	g_return_if_fail (name != NULL);
#line 75 "data-sink.vala"
	_tmp0_ = self->priv->_disabled_plugins;
#line 75 "data-sink.vala"
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
#line 75 "data-sink.vala"
	if (_tmp0_ == NULL) {
#line 75 "data-sink.vala"
		return;
#line 3133 "data-sink.c"
	}
#line 76 "data-sink.vala"
	_tmp1_ = self->priv->_disabled_plugins;
#line 76 "data-sink.vala"
	_tmp1__length1 = self->priv->_disabled_plugins_length1;
#line 76 "data-sink.vala"
	if (!_vala_string_array_contains (_tmp1_, _tmp1__length1, name)) {
#line 76 "data-sink.vala"
		return;
#line 3143 "data-sink.c"
	}
#line 78 "data-sink.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 78 "data-sink.vala"
	cpy = _tmp2_;
#line 78 "data-sink.vala"
	cpy_length1 = 0;
#line 78 "data-sink.vala"
	_cpy_size_ = cpy_length1;
#line 79 "data-sink.vala"
	_tmp3_ = self->priv->_disabled_plugins;
#line 79 "data-sink.vala"
	_tmp3__length1 = self->priv->_disabled_plugins_length1;
#line 3157 "data-sink.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 79 "data-sink.vala"
		s_collection = _tmp3_;
#line 79 "data-sink.vala"
		s_collection_length1 = _tmp3__length1;
#line 79 "data-sink.vala"
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
#line 3169 "data-sink.c"
			gchar* _tmp4_;
			gchar* s = NULL;
#line 79 "data-sink.vala"
			_tmp4_ = g_strdup (s_collection[s_it]);
#line 79 "data-sink.vala"
			s = _tmp4_;
#line 3176 "data-sink.c"
			{
				const gchar* _tmp5_;
#line 81 "data-sink.vala"
				_tmp5_ = s;
#line 81 "data-sink.vala"
				if (g_strcmp0 (_tmp5_, name) != 0) {
#line 3183 "data-sink.c"
					const gchar* _tmp6_;
					gchar* _tmp7_;
#line 81 "data-sink.vala"
					_tmp6_ = s;
#line 81 "data-sink.vala"
					_tmp7_ = g_strdup (_tmp6_);
#line 81 "data-sink.vala"
					_vala_array_add3 (&cpy, &cpy_length1, &_cpy_size_, _tmp7_);
#line 3192 "data-sink.c"
				}
#line 79 "data-sink.vala"
				_g_free0 (s);
#line 3196 "data-sink.c"
			}
		}
	}
#line 83 "data-sink.vala"
	_tmp8_ = cpy;
#line 83 "data-sink.vala"
	_tmp8__length1 = cpy_length1;
#line 83 "data-sink.vala"
	cpy = NULL;
#line 83 "data-sink.vala"
	cpy_length1 = 0;
#line 83 "data-sink.vala"
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
#line 83 "data-sink.vala"
	self->priv->_disabled_plugins = _tmp8_;
#line 83 "data-sink.vala"
	self->priv->_disabled_plugins_length1 = _tmp8__length1;
#line 83 "data-sink.vala"
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
#line 73 "data-sink.vala"
	cpy = (_vala_array_free (cpy, cpy_length1, (GDestroyNotify) g_free), NULL);
#line 3218 "data-sink.c"
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 90 "data-sink.vala"
	if ((*length) == (*size)) {
#line 90 "data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 90 "data-sink.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3233 "data-sink.c"
	}
#line 90 "data-sink.vala"
	(*array)[(*length)++] = value;
#line 90 "data-sink.vala"
	(*array)[*length] = NULL;
#line 3239 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_disable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                          const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 86 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 86 "data-sink.vala"
	g_return_if_fail (name != NULL);
#line 88 "data-sink.vala"
	_tmp1_ = self->priv->_disabled_plugins;
#line 88 "data-sink.vala"
	_tmp1__length1 = self->priv->_disabled_plugins_length1;
#line 88 "data-sink.vala"
	if (_tmp1_ == NULL) {
#line 88 "data-sink.vala"
		_tmp0_ = TRUE;
#line 3261 "data-sink.c"
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 88 "data-sink.vala"
		_tmp2_ = self->priv->_disabled_plugins;
#line 88 "data-sink.vala"
		_tmp2__length1 = self->priv->_disabled_plugins_length1;
#line 88 "data-sink.vala"
		_tmp0_ = !_vala_string_array_contains (_tmp2_, _tmp2__length1, name);
#line 3271 "data-sink.c"
	}
#line 88 "data-sink.vala"
	if (_tmp0_) {
#line 3275 "data-sink.c"
		gchar* _tmp3_;
#line 90 "data-sink.vala"
		_tmp3_ = g_strdup (name);
#line 90 "data-sink.vala"
		_vala_array_add4 (&self->priv->_disabled_plugins, &self->priv->_disabled_plugins_length1, &self->priv->__disabled_plugins_size_, _tmp3_);
#line 3281 "data-sink.c"
	}
}

static SynapseDataSinkDataSinkConfiguration*
synapse_data_sink_data_sink_configuration_construct (GType object_type)
{
	SynapseDataSinkDataSinkConfiguration * self = NULL;
#line 39 "data-sink.vala"
	self = (SynapseDataSinkDataSinkConfiguration*) synapse_config_object_construct (object_type);
#line 39 "data-sink.vala"
	return self;
#line 3293 "data-sink.c"
}

static SynapseDataSinkDataSinkConfiguration*
synapse_data_sink_data_sink_configuration_new (void)
{
#line 39 "data-sink.vala"
	return synapse_data_sink_data_sink_configuration_construct (SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION);
#line 3301 "data-sink.c"
}

static gchar**
synapse_data_sink_data_sink_configuration_get_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 46 "data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "data-sink.vala"
	_tmp0_ = self->priv->_disabled_plugins;
#line 48 "data-sink.vala"
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
#line 48 "data-sink.vala"
	_tmp1_ = _tmp0_;
#line 48 "data-sink.vala"
	_tmp1__length1 = _tmp0__length1;
#line 48 "data-sink.vala"
	if (result_length1) {
#line 48 "data-sink.vala"
		*result_length1 = _tmp1__length1;
#line 3327 "data-sink.c"
	}
#line 48 "data-sink.vala"
	result = _tmp1_;
#line 48 "data-sink.vala"
	return result;
#line 3333 "data-sink.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 52 "data-sink.vala"
	if (length >= 0) {
#line 3342 "data-sink.c"
		gchar** result;
		gssize i;
#line 52 "data-sink.vala"
		result = g_new0 (gchar*, length + 1);
#line 52 "data-sink.vala"
		for (i = 0; i < length; i++) {
#line 3349 "data-sink.c"
			gchar* _tmp0_;
#line 52 "data-sink.vala"
			_tmp0_ = g_strdup (self[i]);
#line 52 "data-sink.vala"
			result[i] = _tmp0_;
#line 3355 "data-sink.c"
		}
#line 52 "data-sink.vala"
		return result;
#line 3359 "data-sink.c"
	}
#line 52 "data-sink.vala"
	return NULL;
#line 3363 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_set_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                gchar** value,
                                                                gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 50 "data-sink.vala"
	g_return_if_fail (self != NULL);
#line 52 "data-sink.vala"
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
#line 52 "data-sink.vala"
	_tmp0__length1 = value_length1;
#line 52 "data-sink.vala"
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
#line 52 "data-sink.vala"
	self->priv->_disabled_plugins = _tmp0_;
#line 52 "data-sink.vala"
	self->priv->_disabled_plugins_length1 = _tmp0__length1;
#line 52 "data-sink.vala"
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
#line 50 "data-sink.vala"
	g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY]);
#line 3389 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_class_init (SynapseDataSinkDataSinkConfigurationClass * klass,
                                                      gpointer klass_data)
{
#line 39 "data-sink.vala"
	synapse_data_sink_data_sink_configuration_parent_class = g_type_class_peek_parent (klass);
#line 39 "data-sink.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDataSinkDataSinkConfiguration_private_offset);
#line 39 "data-sink.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_sink_data_sink_configuration_get_property;
#line 39 "data-sink.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_sink_data_sink_configuration_set_property;
#line 39 "data-sink.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_data_sink_configuration_finalize;
#line 39 "data-sink.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY, synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY] = g_param_spec_boxed ("disabled-plugins", "disabled-plugins", "disabled-plugins", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3408 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_instance_init (SynapseDataSinkDataSinkConfiguration * self,
                                                         gpointer klass)
{
#line 39 "data-sink.vala"
	self->priv = synapse_data_sink_data_sink_configuration_get_instance_private (self);
#line 43 "data-sink.vala"
	self->priv->_disabled_plugins = NULL;
#line 43 "data-sink.vala"
	self->priv->_disabled_plugins_length1 = 0;
#line 43 "data-sink.vala"
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
#line 3423 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_finalize (GObject * obj)
{
	SynapseDataSinkDataSinkConfiguration * self;
#line 39 "data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 43 "data-sink.vala"
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
#line 39 "data-sink.vala"
	G_OBJECT_CLASS (synapse_data_sink_data_sink_configuration_parent_class)->finalize (obj);
#line 3436 "data-sink.c"
}

static GType
synapse_data_sink_data_sink_configuration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkDataSinkConfigurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_data_sink_configuration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkDataSinkConfiguration), 0, (GInstanceInitFunc) synapse_data_sink_data_sink_configuration_instance_init, NULL };
	GType synapse_data_sink_data_sink_configuration_type_id;
	synapse_data_sink_data_sink_configuration_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseDataSinkDataSinkConfiguration", &g_define_type_info, 0);
	SynapseDataSinkDataSinkConfiguration_private_offset = g_type_add_instance_private (synapse_data_sink_data_sink_configuration_type_id, sizeof (SynapseDataSinkDataSinkConfigurationPrivate));
	return synapse_data_sink_data_sink_configuration_type_id;
}

static GType
synapse_data_sink_data_sink_configuration_get_type (void)
{
	static volatile gsize synapse_data_sink_data_sink_configuration_type_id__once = 0;
	if (g_once_init_enter (&synapse_data_sink_data_sink_configuration_type_id__once)) {
		GType synapse_data_sink_data_sink_configuration_type_id;
		synapse_data_sink_data_sink_configuration_type_id = synapse_data_sink_data_sink_configuration_get_type_once ();
		g_once_init_leave (&synapse_data_sink_data_sink_configuration_type_id__once, synapse_data_sink_data_sink_configuration_type_id);
	}
	return synapse_data_sink_data_sink_configuration_type_id__once;
}

static void
_vala_synapse_data_sink_data_sink_configuration_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 39 "data-sink.vala"
	switch (property_id) {
#line 39 "data-sink.vala"
		case SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY:
#line 3473 "data-sink.c"
		{
			int length;
#line 39 "data-sink.vala"
			g_value_set_boxed (value, synapse_data_sink_data_sink_configuration_get_disabled_plugins (self, &length));
#line 3478 "data-sink.c"
		}
#line 39 "data-sink.vala"
		break;
#line 3482 "data-sink.c"
		default:
#line 39 "data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "data-sink.vala"
		break;
#line 3488 "data-sink.c"
	}
}

static void
_vala_synapse_data_sink_data_sink_configuration_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 39 "data-sink.vala"
	switch (property_id) {
#line 39 "data-sink.vala"
		case SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY:
#line 3504 "data-sink.c"
		{
			gpointer boxed;
#line 39 "data-sink.vala"
			boxed = g_value_get_boxed (value);
#line 39 "data-sink.vala"
			synapse_data_sink_data_sink_configuration_set_disabled_plugins (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 3511 "data-sink.c"
		}
#line 39 "data-sink.vala"
		break;
#line 3515 "data-sink.c"
		default:
#line 39 "data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "data-sink.vala"
		break;
#line 3521 "data-sink.c"
	}
}

static GObject *
synapse_data_sink_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDataSink * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GType* _tmp2_;
	SynapseConfigService* cfg = NULL;
	SynapseConfigService* _tmp3_;
	SynapseConfigService* _tmp4_;
	SynapseConfigObject* _tmp5_;
	SynapsePluginRegistry* _tmp6_;
	SynapseRelevancyService* _tmp7_;
	SynapseVolumeService* _tmp8_;
#line 117 "data-sink.vala"
	parent_class = G_OBJECT_CLASS (synapse_data_sink_parent_class);
#line 117 "data-sink.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 117 "data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 119 "data-sink.vala"
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_ITEM_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 119 "data-sink.vala"
	_g_object_unref0 (self->priv->item_plugins);
#line 119 "data-sink.vala"
	self->priv->item_plugins = (GeeSet*) _tmp0_;
#line 120 "data-sink.vala"
	_tmp1_ = gee_hash_set_new (SYNAPSE_TYPE_ACTION_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 120 "data-sink.vala"
	_g_object_unref0 (self->priv->action_plugins);
#line 120 "data-sink.vala"
	self->priv->action_plugins = (GeeSet*) _tmp1_;
#line 121 "data-sink.vala"
	_tmp2_ = g_new0 (GType, 0);
#line 121 "data-sink.vala"
	self->priv->plugin_types = (g_free (self->priv->plugin_types), NULL);
#line 121 "data-sink.vala"
	self->priv->plugin_types = _tmp2_;
#line 121 "data-sink.vala"
	self->priv->plugin_types_length1 = 0;
#line 121 "data-sink.vala"
	self->priv->_plugin_types_size_ = self->priv->plugin_types_length1;
#line 122 "data-sink.vala"
	self->priv->query_id = (guint) 0;
#line 124 "data-sink.vala"
	_tmp3_ = synapse_config_service_get_default ();
#line 124 "data-sink.vala"
	cfg = _tmp3_;
#line 125 "data-sink.vala"
	_tmp4_ = cfg;
#line 125 "data-sink.vala"
	_tmp5_ = synapse_config_service_get_config (_tmp4_, "data-sink", "global", SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION);
#line 125 "data-sink.vala"
	_g_object_unref0 (self->priv->config);
#line 125 "data-sink.vala"
	self->priv->config = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 129 "data-sink.vala"
	_tmp6_ = synapse_plugin_registry_get_default ();
#line 129 "data-sink.vala"
	_g_object_unref0 (self->priv->registry);
#line 129 "data-sink.vala"
	self->priv->registry = _tmp6_;
#line 130 "data-sink.vala"
	_tmp7_ = synapse_relevancy_service_get_default ();
#line 130 "data-sink.vala"
	_g_object_unref0 (self->priv->relevancy_service);
#line 130 "data-sink.vala"
	self->priv->relevancy_service = _tmp7_;
#line 131 "data-sink.vala"
	_tmp8_ = synapse_volume_service_get_default ();
#line 131 "data-sink.vala"
	_g_object_unref0 (self->priv->volume_service);
#line 131 "data-sink.vala"
	self->priv->volume_service = _tmp8_;
#line 133 "data-sink.vala"
	synapse_data_sink_initialize_caches (self, NULL, NULL);
#line 134 "data-sink.vala"
	synapse_data_sink_register_static_plugin (self, SYNAPSE_TYPE_COMMON_ACTIONS);
#line 117 "data-sink.vala"
	_g_object_unref0 (cfg);
#line 117 "data-sink.vala"
	return obj;
#line 3611 "data-sink.c"
}

static void
synapse_data_sink_class_init (SynapseDataSinkClass * klass,
                              gpointer klass_data)
{
#line 37 "data-sink.vala"
	synapse_data_sink_parent_class = g_type_class_peek_parent (klass);
#line 37 "data-sink.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDataSink_private_offset);
#line 37 "data-sink.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_sink_get_property;
#line 37 "data-sink.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_sink_set_property;
#line 37 "data-sink.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_data_sink_constructor;
#line 37 "data-sink.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_finalize;
#line 37 "data-sink.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY] = g_param_spec_boolean ("has-empty-handlers", "has-empty-handlers", "has-empty-handlers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "data-sink.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY] = g_param_spec_boolean ("has-unknown-handlers", "has-unknown-handlers", "has-unknown-handlers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 37 "data-sink.vala"
	synapse_data_sink_signals[SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL] = g_signal_new ("plugin-registered", SYNAPSE_TYPE_DATA_SINK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
#line 37 "data-sink.vala"
	synapse_data_sink_signals[SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL] = g_signal_new ("search-done", SYNAPSE_TYPE_DATA_SINK, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
#line 3638 "data-sink.c"
}

static void
synapse_data_sink_synapse_search_provider_interface_init (SynapseSearchProviderIface * iface,
                                                          gpointer iface_data)
{
#line 242 "data-sink.vala"
	synapse_data_sink_synapse_search_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 242 "data-sink.vala"
	iface->search = (void (*) (SynapseSearchProvider*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_data_sink_real_search;
#line 242 "data-sink.vala"
	iface->search_finish = (GeeList* (*) (SynapseSearchProvider*, GAsyncResult*, GError**)) synapse_data_sink_search_finish;
#line 3651 "data-sink.c"
}

static void
synapse_data_sink_instance_init (SynapseDataSink * self,
                                 gpointer klass)
{
#line 37 "data-sink.vala"
	self->priv = synapse_data_sink_get_instance_private (self);
#line 186 "data-sink.vala"
	self->priv->_has_empty_handlers = FALSE;
#line 187 "data-sink.vala"
	self->priv->_has_unknown_handlers = FALSE;
#line 189 "data-sink.vala"
	self->priv->plugins_loaded = FALSE;
#line 3666 "data-sink.c"
}

static void
synapse_data_sink_finalize (GObject * obj)
{
	SynapseDataSink * self;
#line 37 "data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 101 "data-sink.vala"
	g_debug ("data-sink.vala:101: DataSink died...");
#line 104 "data-sink.vala"
	_g_object_unref0 (self->priv->config);
#line 105 "data-sink.vala"
	_g_object_unref0 (self->priv->item_plugins);
#line 106 "data-sink.vala"
	_g_object_unref0 (self->priv->action_plugins);
#line 110 "data-sink.vala"
	_g_object_unref0 (self->priv->dbus_name_cache);
#line 111 "data-sink.vala"
	_g_object_unref0 (self->priv->desktop_file_service);
#line 112 "data-sink.vala"
	_g_object_unref0 (self->priv->registry);
#line 113 "data-sink.vala"
	_g_object_unref0 (self->priv->relevancy_service);
#line 114 "data-sink.vala"
	_g_object_unref0 (self->priv->volume_service);
#line 115 "data-sink.vala"
	self->priv->plugin_types = (g_free (self->priv->plugin_types), NULL);
#line 242 "data-sink.vala"
	G_OBJECT_CLASS (synapse_data_sink_parent_class)->finalize (obj);
#line 3697 "data-sink.c"
}

static GType
synapse_data_sink_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSink), 0, (GInstanceInitFunc) synapse_data_sink_instance_init, NULL };
	static const GInterfaceInfo synapse_search_provider_info = { (GInterfaceInitFunc) synapse_data_sink_synapse_search_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_data_sink_type_id;
	synapse_data_sink_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDataSink", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_data_sink_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER, &synapse_search_provider_info);
	SynapseDataSink_private_offset = g_type_add_instance_private (synapse_data_sink_type_id, sizeof (SynapseDataSinkPrivate));
	return synapse_data_sink_type_id;
}

GType
synapse_data_sink_get_type (void)
{
	static volatile gsize synapse_data_sink_type_id__once = 0;
	if (g_once_init_enter (&synapse_data_sink_type_id__once)) {
		GType synapse_data_sink_type_id;
		synapse_data_sink_type_id = synapse_data_sink_get_type_once ();
		g_once_init_leave (&synapse_data_sink_type_id__once, synapse_data_sink_type_id);
	}
	return synapse_data_sink_type_id__once;
}

static void
_vala_synapse_data_sink_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 37 "data-sink.vala"
	switch (property_id) {
#line 37 "data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY:
#line 37 "data-sink.vala"
		g_value_set_boolean (value, synapse_data_sink_get_has_empty_handlers (self));
#line 37 "data-sink.vala"
		break;
#line 37 "data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY:
#line 37 "data-sink.vala"
		g_value_set_boolean (value, synapse_data_sink_get_has_unknown_handlers (self));
#line 37 "data-sink.vala"
		break;
#line 3746 "data-sink.c"
		default:
#line 37 "data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "data-sink.vala"
		break;
#line 3752 "data-sink.c"
	}
}

static void
_vala_synapse_data_sink_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 37 "data-sink.vala"
	switch (property_id) {
#line 37 "data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY:
#line 37 "data-sink.vala"
		synapse_data_sink_set_has_empty_handlers (self, g_value_get_boolean (value));
#line 37 "data-sink.vala"
		break;
#line 37 "data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY:
#line 37 "data-sink.vala"
		synapse_data_sink_set_has_unknown_handlers (self, g_value_get_boolean (value));
#line 37 "data-sink.vala"
		break;
#line 3778 "data-sink.c"
		default:
#line 37 "data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "data-sink.vala"
		break;
#line 3784 "data-sink.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 239 "data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3795 "data-sink.c"
		gssize i;
#line 239 "data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 239 "data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 239 "data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3803 "data-sink.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 239 "data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 239 "data-sink.vala"
	g_free (array);
#line 3818 "data-sink.c"
}

