/* Device.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Device.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016-2018 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */
/* This is a read-only class, set the properties via PulseAudioManager.*/

#include "io.elementary.settings.sound.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pulse/pulseaudio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_DEVICE_0_PROPERTY,
	SOUND_DEVICE_INPUT_PROPERTY,
	SOUND_DEVICE_ID_PROPERTY,
	SOUND_DEVICE_CARD_NAME_PROPERTY,
	SOUND_DEVICE_CARD_INDEX_PROPERTY,
	SOUND_DEVICE_DESCRIPTION_PROPERTY,
	SOUND_DEVICE_PORT_NAME_PROPERTY,
	SOUND_DEVICE_DISPLAY_NAME_PROPERTY,
	SOUND_DEVICE_FORM_FACTOR_PROPERTY,
	SOUND_DEVICE_ICON_NAME_PROPERTY,
	SOUND_DEVICE_PROFILES_PROPERTY,
	SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY,
	SOUND_DEVICE_SINK_NAME_PROPERTY,
	SOUND_DEVICE_SINK_INDEX_PROPERTY,
	SOUND_DEVICE_CARD_SINK_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY,
	SOUND_DEVICE_SOURCE_NAME_PROPERTY,
	SOUND_DEVICE_SOURCE_INDEX_PROPERTY,
	SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY,
	SOUND_DEVICE_IS_DEFAULT_PROPERTY,
	SOUND_DEVICE_IS_MUTED_PROPERTY,
	SOUND_DEVICE_VOLUME_PROPERTY,
	SOUND_DEVICE_BALANCE_PROPERTY,
	SOUND_DEVICE_NUM_PROPERTIES
};
static GParamSpec* sound_device_properties[SOUND_DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SOUND_DEVICE_REMOVED_SIGNAL,
	SOUND_DEVICE_NUM_SIGNALS
};
static guint sound_device_signals[SOUND_DEVICE_NUM_SIGNALS] = {0};

struct _SoundDevicePrivate {
	gboolean _input;
	gchar* _id;
	gchar* _card_name;
	guint32 _card_index;
	gchar* _description;
	gchar* _port_name;
	gchar* _display_name;
	gchar* _form_factor;
	gchar* _icon_name;
	GeeArrayList* _profiles;
	gchar* _card_active_profile_name;
	gchar* _sink_name;
	gint _sink_index;
	gchar* _card_sink_name;
	gchar* _card_sink_port_name;
	gint _card_sink_index;
	gchar* _source_name;
	gint _source_index;
	gchar* _card_source_name;
	gchar* _card_source_port_name;
	gint _card_source_index;
	gboolean _is_default;
	gboolean _is_muted;
	gdouble _volume;
	gfloat _balance;
};

static gint SoundDevice_private_offset;
static gpointer sound_device_parent_class = NULL;

static GObject * sound_device_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void sound_device_finalize (GObject * obj);
static GType sound_device_get_type_once (void);
static void _vala_sound_device_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sound_device_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_device_get_instance_private (SoundDevice* self)
{
	return G_STRUCT_MEMBER_P (self, SoundDevice_private_offset);
}

SoundDevice*
sound_device_construct (GType object_type,
                        const gchar* id,
                        guint32 card_index,
                        const gchar* port_name)
{
	SoundDevice * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (port_name != NULL, NULL);
	self = (SoundDevice*) g_object_new (object_type, "id", id, "card-index", card_index, "port-name", port_name, NULL);
	return self;
}

SoundDevice*
sound_device_new (const gchar* id,
                  guint32 card_index,
                  const gchar* port_name)
{
	return sound_device_construct (SOUND_TYPE_DEVICE, id, card_index, port_name);
}

gchar*
sound_device_get_nice_form_factor (SoundDevice* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_form_factor;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("internal")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("Built-in"));
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("speaker")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (_ ("Speaker"));
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("handset")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup (_ ("Handset"));
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("tv")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup (_ ("TV"));
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("webcam")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup (_ ("Webcam"));
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("microphone")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (_ ("Microphone"));
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("headset")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup (_ ("Headset"));
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("headphone")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup (_ ("Headphone"));
				result = _tmp11_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("hands-free")))) {
		switch (0) {
			default:
			{
				gchar* _tmp12_;
				_tmp12_ = g_strdup (_ ("Hands-Free"));
				result = _tmp12_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("car")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				_tmp13_ = g_strdup (_ ("Car"));
				result = _tmp13_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("hifi")))) {
		switch (0) {
			default:
			{
				gchar* _tmp14_;
				_tmp14_ = g_strdup (_ ("HiFi"));
				result = _tmp14_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("computer")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup (_ ("Computer"));
				result = _tmp15_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("portable")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup (_ ("Portable"));
				result = _tmp16_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp17_ = NULL;
				gboolean _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = self->priv->_input;
				if (_tmp18_) {
					_tmp17_ = _ ("Input");
				} else {
					_tmp17_ = _ ("Output");
				}
				_tmp19_ = g_strdup (_tmp17_);
				result = _tmp19_;
				return result;
			}
		}
	}
}

gchar*
sound_device_get_matching_profile (SoundDevice* self,
                                   SoundDevice* other_device)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (other_device != NULL) {
		{
			GeeArrayList* _profile_list = NULL;
			GeeArrayList* _tmp0_;
			gint _profile_size = 0;
			GeeArrayList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _profile_index = 0;
			_tmp0_ = self->priv->_profiles;
			_profile_list = _tmp0_;
			_tmp1_ = _profile_list;
			_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_profile_size = _tmp3_;
			_profile_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				gchar* profile = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				GeeArrayList* _tmp8_;
				const gchar* _tmp9_;
				_profile_index = _profile_index + 1;
				_tmp4_ = _profile_index;
				_tmp5_ = _profile_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _profile_list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _profile_index);
				profile = (gchar*) _tmp7_;
				_tmp8_ = other_device->priv->_profiles;
				_tmp9_ = profile;
				if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp8_, _tmp9_)) {
					result = profile;
					return result;
				}
				_g_free0 (profile);
			}
		}
	}
	result = NULL;
	return result;
}

gboolean
sound_device_get_input (SoundDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_input;
	return result;
}

void
sound_device_set_input (SoundDevice* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_input (self);
	if (old_value != value) {
		self->priv->_input = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_INPUT_PROPERTY]);
	}
}

const gchar*
sound_device_get_id (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
sound_device_set_id (SoundDevice* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_ID_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_name);
		self->priv->_card_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_NAME_PROPERTY]);
	}
}

guint32
sound_device_get_card_index (SoundDevice* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_card_index;
	return result;
}

static void
sound_device_set_card_index (SoundDevice* self,
                             guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_index (self);
	if (old_value != value) {
		self->priv->_card_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_description (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
sound_device_set_description (SoundDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
sound_device_get_port_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_port_name;
	result = _tmp0_;
	return result;
}

static void
sound_device_set_port_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_port_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_port_name);
		self->priv->_port_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_PORT_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_display_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_display_name (SoundDevice* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_DISPLAY_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_form_factor (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_form_factor;
	result = _tmp0_;
	return result;
}

void
sound_device_set_form_factor (SoundDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_form_factor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_form_factor);
		self->priv->_form_factor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_FORM_FACTOR_PROPERTY]);
	}
}

const gchar*
sound_device_get_icon_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_icon_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_ICON_NAME_PROPERTY]);
	}
}

GeeArrayList*
sound_device_get_profiles (SoundDevice* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_profiles;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sound_device_set_profiles (SoundDevice* self,
                           GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_profiles (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_profiles);
		self->priv->_profiles = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_PROFILES_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_active_profile_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_active_profile_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_active_profile_name (SoundDevice* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_active_profile_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_active_profile_name);
		self->priv->_card_active_profile_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_sink_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sink_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_sink_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_sink_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sink_name);
		self->priv->_sink_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SINK_NAME_PROPERTY]);
	}
}

gint
sound_device_get_sink_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sink_index;
	return result;
}

void
sound_device_set_sink_index (SoundDevice* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_sink_index (self);
	if (old_value != value) {
		self->priv->_sink_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SINK_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_sink_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_sink_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_sink_name (SoundDevice* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_sink_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_sink_name);
		self->priv->_card_sink_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SINK_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_sink_port_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_sink_port_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_sink_port_name (SoundDevice* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_sink_port_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_sink_port_name);
		self->priv->_card_sink_port_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY]);
	}
}

gint
sound_device_get_card_sink_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_card_sink_index;
	return result;
}

void
sound_device_set_card_sink_index (SoundDevice* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_sink_index (self);
	if (old_value != value) {
		self->priv->_card_sink_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_source_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_source_name (SoundDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_source_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_source_name);
		self->priv->_source_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SOURCE_NAME_PROPERTY]);
	}
}

gint
sound_device_get_source_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_source_index;
	return result;
}

void
sound_device_set_source_index (SoundDevice* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_source_index (self);
	if (old_value != value) {
		self->priv->_source_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SOURCE_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_source_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_source_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_source_name (SoundDevice* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_source_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_source_name);
		self->priv->_card_source_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_source_port_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_source_port_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_source_port_name (SoundDevice* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_source_port_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_source_port_name);
		self->priv->_card_source_port_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY]);
	}
}

gint
sound_device_get_card_source_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_card_source_index;
	return result;
}

void
sound_device_set_card_source_index (SoundDevice* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_source_index (self);
	if (old_value != value) {
		self->priv->_card_source_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY]);
	}
}

gboolean
sound_device_get_is_default (SoundDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_default;
	return result;
}

void
sound_device_set_is_default (SoundDevice* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_is_default (self);
	if (old_value != value) {
		self->priv->_is_default = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_IS_DEFAULT_PROPERTY]);
	}
}

gboolean
sound_device_get_is_muted (SoundDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_muted;
	return result;
}

void
sound_device_set_is_muted (SoundDevice* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_is_muted (self);
	if (old_value != value) {
		self->priv->_is_muted = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_IS_MUTED_PROPERTY]);
	}
}

gdouble
sound_device_get_volume (SoundDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_volume;
	return result;
}

void
sound_device_set_volume (SoundDevice* self,
                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_volume (self);
	if (old_value != value) {
		self->priv->_volume = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_VOLUME_PROPERTY]);
	}
}

gfloat
sound_device_get_balance (SoundDevice* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_balance;
	return result;
}

void
sound_device_set_balance (SoundDevice* self,
                          gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_balance (self);
	if (old_value != value) {
		self->priv->_balance = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_BALANCE_PROPERTY]);
	}
}

static GObject *
sound_device_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundDevice * self;
	GeeLinkedList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	parent_class = G_OBJECT_CLASS (sound_device_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_DEVICE, SoundDevice);
	_tmp0_ = gee_linked_list_new (G_TYPE_POINTER, (GBoxedCopyFunc) pa_operation_ref, (GDestroyNotify) pa_operation_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->volume_operations);
	self->volume_operations = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp2_ = _tmp1_;
	sound_device_set_profiles (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	return obj;
}

static void
sound_device_class_init (SoundDeviceClass * klass,
                         gpointer klass_data)
{
	sound_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_device_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_device_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_INPUT_PROPERTY, sound_device_properties[SOUND_DEVICE_INPUT_PROPERTY] = g_param_spec_boolean ("input", "input", "input", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_ID_PROPERTY, sound_device_properties[SOUND_DEVICE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_NAME_PROPERTY] = g_param_spec_string ("card-name", "card-name", "card-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_INDEX_PROPERTY] = g_param_spec_uint ("card-index", "card-index", "card-index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_DESCRIPTION_PROPERTY, sound_device_properties[SOUND_DEVICE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_PORT_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_PORT_NAME_PROPERTY] = g_param_spec_string ("port-name", "port-name", "port-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_DISPLAY_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_FORM_FACTOR_PROPERTY, sound_device_properties[SOUND_DEVICE_FORM_FACTOR_PROPERTY] = g_param_spec_string ("form-factor", "form-factor", "form-factor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_ICON_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_PROFILES_PROPERTY, sound_device_properties[SOUND_DEVICE_PROFILES_PROPERTY] = g_param_spec_object ("profiles", "profiles", "profiles", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY] = g_param_spec_string ("card-active-profile-name", "card-active-profile-name", "card-active-profile-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SINK_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_SINK_NAME_PROPERTY] = g_param_spec_string ("sink-name", "sink-name", "sink-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SINK_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_SINK_INDEX_PROPERTY] = g_param_spec_int ("sink-index", "sink-index", "sink-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SINK_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SINK_NAME_PROPERTY] = g_param_spec_string ("card-sink-name", "card-sink-name", "card-sink-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY] = g_param_spec_string ("card-sink-port-name", "card-sink-port-name", "card-sink-port-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY] = g_param_spec_int ("card-sink-index", "card-sink-index", "card-sink-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SOURCE_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SOURCE_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_SOURCE_INDEX_PROPERTY] = g_param_spec_int ("source-index", "source-index", "source-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY] = g_param_spec_string ("card-source-name", "card-source-name", "card-source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY] = g_param_spec_string ("card-source-port-name", "card-source-port-name", "card-source-port-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY] = g_param_spec_int ("card-source-index", "card-source-index", "card-source-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_IS_DEFAULT_PROPERTY, sound_device_properties[SOUND_DEVICE_IS_DEFAULT_PROPERTY] = g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_IS_MUTED_PROPERTY, sound_device_properties[SOUND_DEVICE_IS_MUTED_PROPERTY] = g_param_spec_boolean ("is-muted", "is-muted", "is-muted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_VOLUME_PROPERTY, sound_device_properties[SOUND_DEVICE_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_BALANCE_PROPERTY, sound_device_properties[SOUND_DEVICE_BALANCE_PROPERTY] = g_param_spec_float ("balance", "balance", "balance", -G_MAXFLOAT, G_MAXFLOAT, (gfloat) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sound_device_signals[SOUND_DEVICE_REMOVED_SIGNAL] = g_signal_new ("removed", SOUND_TYPE_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sound_device_instance_init (SoundDevice * self,
                            gpointer klass)
{
	self->priv = sound_device_get_instance_private (self);
	self->priv->_input = TRUE;
	self->priv->_is_default = FALSE;
	self->priv->_is_muted = FALSE;
	self->priv->_volume = (gdouble) 0;
	self->priv->_balance = (gfloat) 0;
}

static void
sound_device_finalize (GObject * obj)
{
	SoundDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_DEVICE, SoundDevice);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_card_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_port_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_form_factor);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_profiles);
	_g_free0 (self->priv->_card_active_profile_name);
	_g_free0 (self->priv->_sink_name);
	_g_free0 (self->priv->_card_sink_name);
	_g_free0 (self->priv->_card_sink_port_name);
	_g_free0 (self->priv->_source_name);
	_g_free0 (self->priv->_card_source_name);
	_g_free0 (self->priv->_card_source_port_name);
	_g_object_unref0 (self->volume_operations);
	G_OBJECT_CLASS (sound_device_parent_class)->finalize (obj);
}

static GType
sound_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundDevice), 0, (GInstanceInitFunc) sound_device_instance_init, NULL };
	GType sound_device_type_id;
	sound_device_type_id = g_type_register_static (G_TYPE_OBJECT, "SoundDevice", &g_define_type_info, 0);
	SoundDevice_private_offset = g_type_add_instance_private (sound_device_type_id, sizeof (SoundDevicePrivate));
	return sound_device_type_id;
}

GType
sound_device_get_type (void)
{
	static volatile gsize sound_device_type_id__once = 0;
	if (g_once_init_enter (&sound_device_type_id__once)) {
		GType sound_device_type_id;
		sound_device_type_id = sound_device_get_type_once ();
		g_once_init_leave (&sound_device_type_id__once, sound_device_type_id);
	}
	return sound_device_type_id__once;
}

static void
_vala_sound_device_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SoundDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_DEVICE, SoundDevice);
	switch (property_id) {
		case SOUND_DEVICE_INPUT_PROPERTY:
		g_value_set_boolean (value, sound_device_get_input (self));
		break;
		case SOUND_DEVICE_ID_PROPERTY:
		g_value_set_string (value, sound_device_get_id (self));
		break;
		case SOUND_DEVICE_CARD_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_name (self));
		break;
		case SOUND_DEVICE_CARD_INDEX_PROPERTY:
		g_value_set_uint (value, sound_device_get_card_index (self));
		break;
		case SOUND_DEVICE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, sound_device_get_description (self));
		break;
		case SOUND_DEVICE_PORT_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_port_name (self));
		break;
		case SOUND_DEVICE_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_display_name (self));
		break;
		case SOUND_DEVICE_FORM_FACTOR_PROPERTY:
		g_value_set_string (value, sound_device_get_form_factor (self));
		break;
		case SOUND_DEVICE_ICON_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_icon_name (self));
		break;
		case SOUND_DEVICE_PROFILES_PROPERTY:
		g_value_set_object (value, sound_device_get_profiles (self));
		break;
		case SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_active_profile_name (self));
		break;
		case SOUND_DEVICE_SINK_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_sink_name (self));
		break;
		case SOUND_DEVICE_SINK_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_sink_index (self));
		break;
		case SOUND_DEVICE_CARD_SINK_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_sink_name (self));
		break;
		case SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_sink_port_name (self));
		break;
		case SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_card_sink_index (self));
		break;
		case SOUND_DEVICE_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_source_name (self));
		break;
		case SOUND_DEVICE_SOURCE_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_source_index (self));
		break;
		case SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_source_name (self));
		break;
		case SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_source_port_name (self));
		break;
		case SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_card_source_index (self));
		break;
		case SOUND_DEVICE_IS_DEFAULT_PROPERTY:
		g_value_set_boolean (value, sound_device_get_is_default (self));
		break;
		case SOUND_DEVICE_IS_MUTED_PROPERTY:
		g_value_set_boolean (value, sound_device_get_is_muted (self));
		break;
		case SOUND_DEVICE_VOLUME_PROPERTY:
		g_value_set_double (value, sound_device_get_volume (self));
		break;
		case SOUND_DEVICE_BALANCE_PROPERTY:
		g_value_set_float (value, sound_device_get_balance (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_device_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SoundDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_DEVICE, SoundDevice);
	switch (property_id) {
		case SOUND_DEVICE_INPUT_PROPERTY:
		sound_device_set_input (self, g_value_get_boolean (value));
		break;
		case SOUND_DEVICE_ID_PROPERTY:
		sound_device_set_id (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_NAME_PROPERTY:
		sound_device_set_card_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_INDEX_PROPERTY:
		sound_device_set_card_index (self, g_value_get_uint (value));
		break;
		case SOUND_DEVICE_DESCRIPTION_PROPERTY:
		sound_device_set_description (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_PORT_NAME_PROPERTY:
		sound_device_set_port_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_DISPLAY_NAME_PROPERTY:
		sound_device_set_display_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_FORM_FACTOR_PROPERTY:
		sound_device_set_form_factor (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_ICON_NAME_PROPERTY:
		sound_device_set_icon_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_PROFILES_PROPERTY:
		sound_device_set_profiles (self, g_value_get_object (value));
		break;
		case SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY:
		sound_device_set_card_active_profile_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_SINK_NAME_PROPERTY:
		sound_device_set_sink_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_SINK_INDEX_PROPERTY:
		sound_device_set_sink_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_CARD_SINK_NAME_PROPERTY:
		sound_device_set_card_sink_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY:
		sound_device_set_card_sink_port_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY:
		sound_device_set_card_sink_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_SOURCE_NAME_PROPERTY:
		sound_device_set_source_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_SOURCE_INDEX_PROPERTY:
		sound_device_set_source_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY:
		sound_device_set_card_source_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY:
		sound_device_set_card_source_port_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY:
		sound_device_set_card_source_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_IS_DEFAULT_PROPERTY:
		sound_device_set_is_default (self, g_value_get_boolean (value));
		break;
		case SOUND_DEVICE_IS_MUTED_PROPERTY:
		sound_device_set_is_muted (self, g_value_get_boolean (value));
		break;
		case SOUND_DEVICE_VOLUME_PROPERTY:
		sound_device_set_volume (self, g_value_get_double (value));
		break;
		case SOUND_DEVICE_BALANCE_PROPERTY:
		sound_device_set_balance (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

